layui.use(["table", "layer", "form", "laytpl"], function () {
    var $ = layui.jquery,
        table = layui.table,
        layer = layui.layer,
        form = layui.form


     var paramdata;
    //渲染参数表格
    var tableparam = table.render({
        elem: "#param-table",
        title: "字段表",
        skin: 'line',
        even: true,
        toolbar: '#paramtoolbar',
        id: 'param-table',
        defaultToolbar: [],
        data: [],
        cols: [[
            {title: '字段名', field: 'name', edit: true},
            {title: '显示名称', field: 'alias', edit: true},
            {title: '数据类型', field: 'datatype', templet: '#selectTool'},
            {title: '数据字典', field: 'dict', hide: true},
            {title: '操作', field: 'tool', align: 'center', toolbar: '#parambar'}
        ]],
        done: function (res, curr, count) {
            paramdata = res.data;
        }
    });

    // 辅助工具
    var tools = (function () {
        "use strict";

        // 参数设置表验证
        function checkParams(paramdata) {
            var f = 0;
            // 验证是否存在空值
            for (var i = 0; i < paramdata.length; i++) {
                if (paramdata[i].name === "" || paramdata[i].alias === "") {
                    f = 1;
                    break;
                }
            }
            // 验证是否有重复的字段名
            if (f === 0) {
                var namehash = {},
                    aliashash = {};
                for (var i in paramdata) {
                    if (namehash[paramdata[i].name]) {
                        f = 1;
                        break;
                    }
                    if (aliashash[paramdata[i].alias]) {
                        f = 1;
                        break;
                    }
                    namehash[paramdata[i].name] = true;
                    aliashash[paramdata[i].alias] = true;
                }
            }
            if (f === 0) {
                return true; // 符合要求
            } else {
                return false; // 存在问题
            }
        }
        return {
            checkParams: checkParams
        }
    })();

    //监听参数表头工具栏事件
    table.on("toolbar(param-table)", function (obj) {
        if (obj.event === 'paramadd') {
            // 增加参数
            paramdata.push({
                "name": "",
                "alias": "",
                "type": "String",
                "dict": ""
            });
            tableparam.reload({
                data: paramdata
            });
        }
    });

    //监听参数表行工具栏事件
    table.on("tool(param-table)", function (obj) {
        if (obj.event === 'paramdel') {
            // 删除参数
            var dataindex = obj.tr.selector.match(/data-index="(\S*)"]/)[1];
            paramdata.splice(dataindex, 1);
            tableparam.reload({
                data: paramdata
            });
        }
    });

    //监听参数类别更改
    form.on('select(type)', function (data) {
        var elem = data.othis.parents('tr');
        var dataindex = elem.attr('data-index');
        paramdata[dataindex].type = data.value;
    });

    // 新建或修改模型提交
    form.on("submit(submit)", function (data) {
        // 参数设置表验证
        if (tools.checkParams(paramdata)) {
            var new_task = data.field;
            new_task.paramJson = JSON.stringify(paramdata);

            $.ajax({
                type: "POST",
                url: rootPath + "/tablesinfo/newtable",
                contentType: "application/json",
                data: JSON.stringify(new_task),
                dataType: "json",
                success: function (data) {
                    layer.msg("创建成功！");
                }, error: function (err) {
                    layer.msg("创建失败！");
                    console.log(err);
                }
            });

        } else {
            layer.msg("请确保参数设置正确！");
        }
        return false;
    });

    $('#resetbtn').click(function () {
        var root = window.location.origin;
        location.href = root + "/dw/tables_info";
    });



});