var isLoad = true;
var isGeo = true;

layui.config({
    base: './js/'
}).use(['table', 'form'], function () {
    var $ = layui.jquery,
        table = layui.table,
        form = layui.form;

    var fieldtablepage = 1,
        datatablepage = 1,
        dynamicCols = [],
        colsList = [],
        currentTags,
        layerIndex_waiting;

    var selectFlag = false;

    bindDb($('#add-type'));

    $(document).on('click', '.back-btn', function () {
        var root = window.location.origin;
        location.href = root + "/dw/tables_info";
    })

    // $(document).on('click', '#div-version', function () {
    //     var root = window.location.origin;
    //     location.href = root + "/dw/version?tableid=" + tableid;
    // })

    //弹出新增字段的对话框
    $(document).on('click', '#add-btn', function () {
        $('#add-form')[0].reset();
        showLayer(0);
    });

    function showLoad() {
        return layer.msg('正在修改标签', {
            icon: 16,
            shade: [0.5, '#f5f5f5'],
            scrollbar: false,
            offset: 'auto',
            time: 100000
        });
    }

    function closeLoad(index) {
        layer.close(index);
    }

    function showSuccess() {
        layer.msg('修改成功！', {time: 1000, offset: 'auto'});
    }

    //弹出div函数实现：0-新增div
    var showLayer = function (index) {
        if (index == '0') {
            layer.open({
                title: '新增字段',
                shadeClose: true,
                type: 1,
                area: ['800px', auto],
                maxHeight: 400,
                maxWidth: 1000,
                content: $('#add-div'),
            })
        }
    };
    //监听事件：数据保存
    form.on('submit(submit)', function (data) {
        saveData(data.field);
        return false;
    });
    //保存数据，重新加载表格
    var saveData = function (data) {
        var info = {
            id: data.id,
            columnName: data.columnName,
            aliasName: data.aliasName,
            dataType: data.dataType,
            unit: data.unit,
            description: data.description,
        };

        $.ajax({
            type: 'POST',
            url: '/metainfo/add',
            data: {
                id: tableid,
                info: JSON.stringify(info)
            },
            success: function (data) {
                active['reloadfield'].call(this);
                var info = {field: data.columnName, title: data.columnName};
                dynamicCols[0].push(info);
                loadDataTable();
                layer.closeAll();
            },
            error: function (e, state, errorThrown) {
                console.log(e);
            }
        });
    };
    //监听表格里控件的点击事件
    table.on('tool(field-table)', function (obj) {
        var data = obj.data;
        if (obj.event == 'del') {
            layer.confirm('确认删除' + data.columnName + '？', function (index) {
                var id = data.id;
                $.ajax({
                    type: 'POST',
                    url: '/metainfo/delete',
                    data: {
                        "id": id,
                    },
                    success: function (data) {
                        var isdelete = data.data;
                        if (isdelete) {
                            obj.del();
                            if (dynamicCols.length > 0) {
                                for (i = 0; i < dynamicCols[0].length; i++) {
                                    var col = dynamicCols[0][i];
                                    var name = col.field;
                                    if (name == data.columnName) {
                                        dynamicCols[0].splice(i, 1);
                                        break;
                                    }
                                }
                                loadDataTable();
                            }
                            layer.close(index);
                        }
                    },
                    error: function (e, state, errorThrown) {
                        console.log(e);
                    }
                });
            });
        }
    });

    table.on('edit(meta-table)', function (obj) {
        var keyValue = obj.data; //得到所在行所有键值
        var editValue = obj.value;
        if (!editValue) {
            return;
        }
        var name = keyValue.name,
            value = keyValue.value;
        var info = "{" + name + ":'" + value + "'}"
        $.ajax({
            type: 'POST',
            url: '/metainfo/edit',
            data: {
                id: tableid,
                info: info,
            },
            success: function (msg) {
                //版本管理数据导入
                var versiondata = {};
                versiondata.date = Date.now();
                versiondata.user = username;
                versiondata.operate = "update";
                versiondata.operatetime = Date.now();
                versiondata.tableid = tableid;
                versiondata.rowid = "";
                versiondata.column = "";
                versiondata.oldvalue = value;
                versiondata.newvalue = editValue;
                versiondata.remark = "";

                var jspara = JSON.stringify(versiondata);
                $.ajax({
                    type: 'POST',
                    url: '/rest/es/documents',
                    data: jspara,
                    success: function (msg) {

                    },
                    error: function (e, state, error) {

                    }
                });

            },
            error: function (e, state, errorThrown) {
                console.log(e);
            }
        });
        // layer.msg('[ID: '+ data.id +'] ' + field + ' 字段更改为：'+ value);
    });

    table.on('edit(field-table)', function (obj) {
        var keyValue = obj.data;
        var id = keyValue.id;
        var value = obj.value;
        if (!value) {
            return;
        }
        var field = obj.field;
        var info = "{" + field + ":'" + value + "'}";
        $.ajax({
            type: 'POST',
            url: '/metainfo/editfield',
            data: {
                id: id,
                info: info,
            },
            success: function (msg) {
            },
            error: function (e, state, errorThrown) {
                console.log(e);
            }
        });
    });

    //动态绑定表单中下拉框的值
    function bindDb(select) {
        $.ajax({
            type: 'GET',
            url: '/metainfo/type',
            success: function (obj) {
                var data = obj.data;
                if (data.length != 0) {
                    var option = '';
                    for (var i = 0; i < data.length; i++) {
                        if (i == 0) {
                            selectdbName = data[i].name;
                        }
                        option += "<option value=\"" + data[i].id + "\">" + data[i].name + "</option>";
                    }
                    select.html(option);
                    form.render('select');
                }
            },
            error: function (e, state, error) {
                console.log(e);
            },
        })
    };

    //加载数据描述表
    table.render({
        elem: '#meta-table',
        url: '/metainfo/meta?id=' + tableid,
        cellMinWidth: 100,
        //skin:'line',
        even: false,
        id: 'meta-table',
        cols: [[
            {
                // title: '名称',
                field: 'name',
                width: 200,
                hide: true,
                templet: function (obj) {
                    return obj.name;
                }
            },
            {
                // title: '显示',
                field: 'label',
                width: 200,
                templet: function (obj) {
                    var label = obj.label;
                    return label;
                }
            },

            {
                // title: '值',
                field: 'value',
                edit: 'text',
                templet: function (obj) {
                    var val = obj.value;
                    if (obj.label == "数据标签" && ownState == "private") {
                        return '<select id="select" name="keywords" xm-select="select-keywords" xm-select-skin="normal" xm-select-direction="up" xm-select-search xm-select-create style="border: 0px solid;" ></select>';
                    } else if (obj.label == "数据标签" && ownState == "public") {
                        val = val.substring(1, val.length - 2);
                    }
                    return val;
                }
            }
        ]],
        done: function (res, curr, count) {
            $('#meta-table th').hide();
            //如果点击数据标签行，则不可以编辑
            var dataTemp = table.cache[this.id];
            var tableElem = this.elem.next();
            var tags = [];
            if (res.tags && res.tags != "") {
                tags = JSON.parse(res.tags);
            }
            layui.each(dataTemp, function (index, data) {
                if (ownState == "public") {
                    tableElem.find('tr[data-index="' + index + '"]').find('td[data-field="value"]').removeAttr('data-edit');
                    return;
                }
                if (data.label == "数据标签") {
                    var cell = tableElem.find('tr[data-index="' + index + '"]').find('td[data-field="value"]').removeAttr('data-edit').find('div.layui-table-cell')[0];
                    cell.style.padding = "0";
                    $(cell).css('overflow', 'visible');
                    // var val=data.value.toString();
                    // val= val.substring(1,val.length-1);
                    // tags=val.split(",");
                }
            });
            if (ownState == "public") {
                table.resize('meta-table');
                return;
            }
            var formSelects = layui.formSelects;
            formSelects.render('select-keywords');
            bindTags();
            formSelects.value('select-keywords', tags);
            currentTags = formSelects.value('select-keywords', 'name');
            table.resize('meta-table');
            window.setInterval(function () {
                var displayCSS = $('.xm-select-dl ').css("display");
                if (displayCSS == 'none' && selectFlag) {
                    selectFlag = false;
                    var value = formSelects.value('select-keywords', 'name');
                    if (JSON.stringify(value) != JSON.stringify(currentTags)) {
                        $.ajax({
                            type: 'POST',
                            url: '/metainfo/edit-tags',
                            data: {
                                id: tableid,
                                tags: value,
                            },
                            beforeSend: function () {
                                i = showLoad();
                            },
                            success: function (msg) {
                                closeLoad(i);
                                showSuccess();
                                currentTags = value;
                            },
                            error: function (e, state, errorThrown) {
                                closeLoad(i);
                                console.log(e);
                            }
                        });
                    }
                }
                if (displayCSS != 'none') {
                    selectFlag = true;
                }
            }, 100);
            formSelects.on('select-keywords', function (id, vals, val, isAdd, isDisabled) {
                if (!isAdd && $('.xm-select-dl ').css("display") == "none") {
                    var value = formSelects.value('select-keywords', 'name');
                    $.ajax({
                        type: 'POST',
                        url: '/metainfo/edit-tags',
                        data: {
                            id: tableid,
                            tags: value,
                        },
                        beforeSend: function () {
                            i = showLoad();
                            currentTags = value;
                        },
                        success: function (msg) {
                            closeLoad(i);
                            showSuccess();
                        },
                        error: function (e, state, errorThrown) {
                            console.log(e);
                        }
                    });
                }
                console.log(vals);
                //id:           点击select的id
                //vals:         当前select已选中的值
                //val:          当前select点击的值
                //isAdd:        当前操作选中or取消
                //isDisabled:   当前选项是否是disabled

            }, true);
        }
    });

    //加载版本管理信息
    table.render({
        elem: '#tb-version',
        url: '/rest/es/search/boolall',
        cellMinWidth: 100,
        // skin: 'line',
        even: false,
        id: 'tb-version',
        where: {
            tableid: tableid
        },
        // page: false,
        initSort: {
            field: 'operatetime' //排序字段，对应 cols 设定的各字段名
            , type: 'desc' //排序方式  asc: 升序、desc: 降序、null: 默认排序
        },
        cols: [[
            {type: 'checkbox', style: 'height:60px', fixed: 'left'},
            {
                title: '日期',
                field: 'date',
                align: 'center',
                // minWidth: 150,
                edit: false,
                templet: function (obj) {
                    return obj.date;
                },
            },
            {
                title: '用户',
                field: 'user',
                align: 'center',
                edit: false,
                templet: function (obj) {
                    return obj.user;
                },
            },
            {
                title: '操作',
                field: 'operate',
                align: 'center',
                edit: false,
                templet: function (obj) {
                    return obj.operate;
                },
            },
            {
                title: '操作时间',
                field: 'operatetime',
                align: 'center',
                // minWidth: 150,
                width: 190,
                edit: false,
                sort: true,
                templet: function (obj) {
                    return obj.operatetime;
                },
            },
            {
                title: '行号',
                field: 'rowid',
                align: 'center',
                edit: false,
                templet: function (obj) {
                    return obj.rowid;
                },
            },
            {
                title: '列名',
                field: 'column',
                align: 'center',
                edit: false,
                templet: function (obj) {
                    return obj.column;
                },
            },
            {
                title: '原值',
                field: 'oldvalue',
                align: 'center',
                edit: false,
                templet: function (obj) {
                    return obj.oldvalue;
                },
            },
            {
                title: '修改值',
                field: 'newvalue',
                align: 'center',
                edit: false,
                templet: function (obj) {
                    return obj.newvalue;
                },
            },
            {title: '操作', field: 'tool', align: 'center', toolbar: '#parambar'},
        ]],
        done: function (res, curr, count) {
            if (res.data.length == 0) {
                // layer.msg('未找到版本信息', {time: 1000, icon: 0}, function () {
                //     // var root = window.location.origin;
                //     // location.href = root + "/dw/metadata?id=" + tableid + "&ownState=private&cur=1";
                // });
            }

            //执行表格“尺寸结构”的重置，这个必须要执行，否则获取的body的高度不准确
            table.resize('tb-version');
        }
    });


    //加载字段信息表
    table.render({
        elem: '#field-table',
        url: '/metainfo/field?id=' + tableid,
        // url:'/metainfo/field',
        cellMinWidth: 100,
        // skin: 'line',
        even: false,
        id: 'field-table',
        page: {
            layout: ['prev', 'page', 'next', 'limit', 'skip'],
            theme: '#1890FF',
        },
        limit: 10,
        cols: [
            [
                {
                    title: 'id',
                    field: 'id',
                    hide: true,
                    templet: function (obj) {
                        return obj.id;
                    }
                },
                {
                    title: '字段名称',
                    field: 'columnName',
                    templet: function (obj) {
                        var info = {field: obj.columnName, title: obj.columnName};
                        colsList.push(info);
                        return obj.columnName;
                    }
                },
                {
                    title: '别名',
                    field: 'aliasName',
                    templet: function (obj) {
                        //return '字段别名';
                        return obj.aliasName;
                    }
                },
                {
                    title: '字段类型',
                    field: 'dataType',
                    templet: function (obj) {
                        //return ee'文本';
                        return obj.dataType;
                    }
                },
                // {
                //     title: '单位',
                //     field: 'unit',
                //     templet: function (obj) {
                //         //return '这个是描述';
                //         return obj.unit;
                //     }
                // },
                {
                    title: '描述',
                    field: 'description',
                    edit: 'text',
                    templet: function (obj) {
                        //return '这个是描述';
                        if (!obj.description) {
                            return "";
                        }
                        return obj.description;
                    }
                },
                {
                    title: '操作',
                    field: 'tool',
                    hide: function () {
                        return ownState == "public" ? true : false;
                    },
                    align: 'center',
                    style: 'cursor:pointer',
                    toolbar: '#toolbar',
                },
            ]
        ],
        done: function (res, curr, count) {
            fieldtablepage = curr;
            if (isLoad) {
                dynamicCols.push(colsList);
                isLoad = false;
                loadDataTable();
            }
            var dataTemp = table.cache[this.id];
            var tableElem = this.elem.next();
            if (ownState == "public") {
                for (var i = 0; i < dataTemp.length; i++) {
                    tableElem.find('tr[data-index="' + i + '"]').find('td[data-field="description"]').removeAttr('data-edit');
                }

            }
            //执行表格“尺寸结构”的重置，这个必须要执行，否则获取的body的高度不准确
            table.resize('field-table');
        }
    });

    //加载数据表
    var loadDataTable = function () {
        table.render({
            elem: '#data-table',
            url: '/metainfo/data?id=' + tableid,
            cellMinWidth: 100,
            // skin: 'line',
            even: false,
            id: 'data-table',
            page: {
                // count: 10,
                layout: ['prev', 'page', 'next', 'limit', 'skip', 'count'],
                theme: '#1890FF',
            },
            limit: 10,
            cols: dynamicCols,
            done: function (res, curr, count) {
                datatablepage = curr;
                //执行表格“尺寸结构”的重置，这个必须要执行，否则获取的body的高度不准确
                table.resize('data-table');
                // buildMap(res.geo);
            }
        })
    };

    $(document).on('click', '#tag-map', function () {
        if (isGeo) {
            isGeo = false;
            $.ajax({
                type: 'GET',
                url: '/metainfo/geo?id=' + tableid,
                beforeSend: function () {
                    layerIndex_waiting = helper.showLoad("正在加载地图...");
                },
                success: function (obj) {
                    layer.close(layerIndex_waiting);
                    buildMap(JSON.parse(obj.data));
                },
                error: function (e, state, error) {
                    console.log(e);
                },
            })
        }
    })

    $(document).on('click', '#li-map', function () {
        // debugger;
        if (isGeo) {
            isGeo = false;
            $.ajax({
                type: 'GET',
                url: '/metainfo/geo?id=' + tableid,
                beforeSend: function () {
                    layerIndex_waiting = helper.showLoad("正在加载地图...");
                },
                success: function (obj) {
                    layer.close(layerIndex_waiting);
                    buildMap(JSON.parse(obj.data));
                },
                error: function (e, state, error) {
                    console.log(e);
                },
            })
        }
    })

    var buildMap = function (geoJson) {
        var map = L.map('mapdiv', {attributionControl: false});
        var layer = L.geoJSON(geoJson, {
            pointToLayer: function (feature, latlng) {
                return L.circleMarker(latlng, {radius: 5, fillColor: "#BBCCE4"});
            }
        }).addTo(map);
        var bound = layer.getBounds();
        var lat = (bound._northEast.lat + bound._southWest.lat) / 2;
        var lng = (bound._northEast.lng + bound._southWest.lng) / 2;
        map.setView([lat, lng], 15);
    }

    var active = {
        reloadfield: function () {
            table.reload('field-table', {
                page: {
                    curr: fieldtablepage,
                },
            }, 'data');
        },
        reloaddata: function () {
            table.reload('data-table', {
                page: {
                    curr: datatablepage,
                },
            }, 'data');
        },
    };

    //绑定标签下拉框
    function bindTags() {
        $.ajax({
            type: 'GET',
            url: '/metainfo/tags',
            async: false,
            success: function (obj) {
                layui.formSelects.data('select-keywords', 'local', {
                    arr: obj
                });
            },
            error: function (e, state, errorThrown) {
                console.log(e);
            },
        });
    };
})

