layui.use(["table", "layer", "form", "laytpl", 'upload'], function () {
    var $ = layui.jquery,
        table = layui.table,
        layer = layui.layer,
        form = layui.form,
        upload = layui.upload

    var map;
    var lookLayer;
    var centerX;
    var centerY;
    var gsurl;
    var paramdata;


    bindEvent();

    function bindEvent() {
        $(document).on('click', '#btn-del', function () {
            var checkStatus = table.checkStatus('param-table');
            var tbdata = checkStatus.data;
            if (tbdata.length == 0) {
                layer.msg("请先选择样式进行操作！");
                return;
            }
            layerConfirm("是否确定删除所选样式？", function () {
                var delList = [];
                for (var i = 0; i < tbdata.length; i++) {
                    delList.push(tbdata[i].name);
                }
                var delListJson = JSON.stringify(delList);

                $.ajax({
                    type: 'POST',
                    url: '/gs/delmapstyle',
                    data: {
                        "styleNames": delListJson
                    },
                    success: function (data) {
                        if (data.data == "false") {
                            layer.msg("样式删除失败！");
                        } else {
                            reload();
                            layer.msg("样式删除成功！");
                        }
                    },
                    error: function (e, state, errorThrown) {
                        console.log(e);
                        layer.msg("样式删除失败！");
                    }
                });
            })
        });
    }

    var height = $(".right-content").outerHeight() - $(".item-top").outerHeight();
    //渲染参数表格
    var tableparam = table.render({
        elem: "#param-table",
        url: '/gs/publishedstyle',
        title: "已发布样式表",
        skin: 'row',
        height: height,
        even: true,
        // toolbar: '#paramtoolbar',
        id: 'param-table',
        defaultToolbar: [],
        // data: [],
        cols: [[
            {type: 'checkbox', style: 'height:80px', fixed: 'left'},
            {
                title: '样式名称',
                field: 'name',
                // align: 'center',
                edit: false,
                templet: function (obj) {
                    return obj.name;
                }
            },
            {
                title: '缩略图',
                field: 'thumbnail',
                align: 'center',
                style: 'height:80px',
                edit: false,
                templet: function (obj) {
                    return '<img src="' + rootPath + '/images/default.png" style="width:75px;height:75px;" />';
                    // return '<img src="' + obj.thumbnail + '" style="width:75px;height:75px;" />';
                }
            },
            {title: '操作', field: 'tool', align: 'center', edit: false, toolbar: '#parambar'}
        ]],
        done: function (res, curr, count) {
            paramdata = res.data;


            var dataTemp = table.cache[this.id];
            var tableElem = this.elem.next();

            $.ajax({
                url: "/gs/stylewiththumbnail",
                type: "POST",
                data: {
                    page: 1,
                    limit: 10
                },
                dataType: 'json',
                success: function (result) {

                    layui.each(dataTemp, function (index, data) {
                        var typeElem = tableElem.find('tr[data-index="' + index + '"]').find('td[data-field="thumbnail"]').find('div.layui-table-cell')[0];
                        if (typeElem) {
                            typeElem.children[0].src = result.data[index].thumbnail;
                        }
                    });
                    // form.render('select');
                    table.resize('table-params');

                }
            });

        },
        page: true
    });

    //选完文件后不自动上传
    var uploadListIns = upload.render({
        elem: '#btn-new'
        // ,url: rootPath + "/common/upload"
        , auto: false
        , exts: 'sld'
        , accept: 'file'
        //,multiple: true
        // ,bindAction: '#btOK'
        , choose: function (obj) {
            layerConfirm("是否确定发布样式？", function () {
                obj.preview(function (index, file, result) {
                    var formData = new FormData();
                    formData.append("file", file);
                    $.ajax({
                        url: "/gs/style/publish",
                        type: "POST",
                        contentType: false,
                        processData: false,
                        data: formData,
                        success: function (result) {
                            layer.msg("发布完成！");
                            reload();
                        },
                        error: function (e, state, error) {
                            layer.msg("发布失败！");
                        }
                    });
                })
            });
        }
    });

    function reload() {
        table.reload('param-table', {
            // page: {
            //     curr: page,
            // }
        }, 'data');
    };

    //监听参数表行工具栏事件
    table.on("tool(param-table)", function (obj) {
        if (obj.event === 'paramlook') {
            layer.open({
                type: 1,
                title: "样式预览",
                shadeClose: true,
                area: ["900px", "400px"],
                maxHeight: 400,
                maxWidth: 1000,
                content: $("#displaydiv"),
                success: function () {

                    if (lookLayer == null) {
                        $.ajax({
                            url: "/gs/publishedlayers",
                            type: "GET",
                            contentType: false,
                            processData: false,
                            async: false,
                            success: function (result) {
                                if (result.length == 0) {
                                    layer.msg("无可预览图层！");
                                    return;
                                }
                                lookLayer = result.data[0].name;
                                centerX = ((Number(result.data[0].maxX) + Number(result.data[0].minX)) * 0.5).toFixed(2);
                                centerY = ((Number(result.data[0].maxY) + Number(result.data[0].minY)) * 0.5).toFixed(2);
                                gsurl = result.data[0].gsUrl;
                            },
                            error: function (e, state, error) {
                                layer.msg("获取图层预览失败！");
                            }
                        });
                    }

                    if (map == null) {
                        //预览样式
                        map = new L.Map("mapDiv", {
                            zoom: 6,
                            center: [centerY, centerX],
                            boxZoom: true,
                            attributionControl: false
                        });
                    }

                    map.eachLayer(function (layer) {
                        layer.remove();
                    });

                    var rowdata = obj.data;
                    var wmsLayer = L.tileLayer.wms(gsurl + "dw/wms?", {
                        layers: lookLayer,//需要加载的图层'JHB_1562743355102'
                        format: 'image/png',//返回的数据格式
                        transparent: true,
                        styles: rowdata.name
                    });
                    map.addLayer(wmsLayer);

                }
            });
        }
    });


});