layui.config({
    base: './js/'
}).use(['layer', 'table', 'form'], function () {
    var $ = layui.jquery,
        table = layui.table,
        form = layui.form;

    var page = 1,
        keywords = '',
        addIndex,
        editIndex;

    initTable();

    bindSelect();

    bindEvent();

    /**
     * 数据库实例表绑定
     */
    function initTable() {
        var height = $(".right-content").outerHeight() - $(".item-top").outerHeight();
        table.render({
            elem: '#data-table',
            url: '/dbinfo/list',
            skin: 'line',
            even: true,
            id: 'data-table',
            height: height,
            page: {
                layout: ['prev', 'page', 'next', 'limit', 'skip'],
                theme: '#1890FF',
            },
            where: {
                keywords: keywords,
            },
            cols: [
                [{
                    type: 'checkbox'
                },
                    {
                        title: 'ID',
                        field: 'id',
                        hide: true,
                        templet: function (obj) {
                            return obj.id;
                        },
                    },
                    {
                        title: '实例名称',
                        field: 'instanceName',
                        templet: function (obj) {
                            if (obj.instanceName) {
                                return obj.instanceName;
                            }
                            return "";
                        },
                    },
                    {
                        title: '数据库类型',
                        field: 'dbtype',
                        templet: function (obj) {
                            var params = obj.parameters;
                            if (params.dbtype) {
                                return params.dbtype;
                            }
                            return "";
                        },
                    },
                    {
                        title: 'IP地址',
                        field: 'host',
                        templet: function (obj) {
                            var params = obj.parameters;
                            if (params.host) {
                                return params.host;
                            }
                            return "";
                        },
                    },
                    {
                        title: '端口号',
                        field: 'port',
                        templet: function (obj) {
                            var params = obj.parameters;
                            if (params.port) {
                                return params.port;
                            }
                            return "";
                        },
                    },
                    {
                        title: '用户名',
                        field: 'user',
                        hide: true,
                        templet: function (obj) {
                            var params = obj.parameters;
                            if (params.user) {
                                return params.user;
                            }
                            return "";
                        },
                    },
                    {
                        title: '密码',
                        field: 'passwd',
                        hide: true,
                        templet: function (obj) {
                            var params = obj.parameters;
                            if (params.passwd) {
                                return params.passwd;
                            }
                            return "";
                        },
                    },
                    {
                        title: '操作',
                        field: 'tool',
                        align: 'center',
                        style: 'cursor:pointer',
                        toolbar: '#toolbar',
                    },
                ]
            ],
            done: function (res, curr, count) {
                page = curr;
                table.resize('data-table');
            },
        });
    };

    /**
     * 绑定数据库类型
     */
    function bindSelect() {
        $.ajax({
            type: 'GET',
            url: '/dbinfo/listdbtype',
            success: function (obj) {
                if (obj.code != "0") {
                    layer.msg("获取数据库类型失败！");
                    return;
                }
                var data = obj.data;
                if (data.length != 0) {
                    var option = '<option></option>';
                    for (var i = 0; i < data.length; i++) {
                        option += "<option value=\"" + data[i].id + "\">" + data[i].typeName + "</option>";
                    }
                    $('#add-selectdb').html(option);
                    form.render('select');
                }
            },
            error: function (e, state, error) {
                layer.msg("获取数据库类型失败！");
                console.log(e);
            },
        })
    };

    /**
     * 绑定事件
     */
    function bindEvent() {
        /**
         * 新增弹窗
         */
        $(document).on('click', '#addbtn', function () {
            $('#add-form')[0].reset();
            showLayer(0);
        });

        /**
         * 新增连接时测试数据库连接
         */
        $(document).on('click', '#test-connection-add', function () {
            var dbtype = $("#add-form .layui-this").text();
            var arr = $("#add-form").serializeArray();
            var config = convertData(arr, dbtype);
            $.ajax({
                type: 'POST',
                url: '/dbinfo/access',
                data: {
                    parameters: config
                },
                success: function (data) {
                    if (data["data"]) {
                        layer.msg('连接成功');
                    } else {
                        layer.msg('连接失败');
                    }

                },
                error: function (e, state, errorThrown) {
                    layer.msg('连接失败');
                    console.log(e);
                }
            });
        });

        /**
         * 编辑连接时测试数据库连接
         */
        $(document).on('click', '#test-connection-edit', function () {
            var arr = $("#edit-form").serializeArray();
            var config = convertData(arr);
            $.ajax({
                type: 'POST',
                url: '/dbinfo/access',
                data: {
                    parameters: config
                },
                success: function (data) {
                    if (data["data"]) {
                        layer.msg('连接成功');
                    } else {
                        layer.msg('连接失败');
                    }

                },
                error: function (e, state, errorThrown) {
                    layer.msg('连接失败');
                    console.log(e);
                }
            });
        });

        /**
         * 删除数据库连接
         */
        $(document).on('click', '#deletebtn', function () {
            var checkStatus = table.checkStatus('data-table');
            var data = checkStatus.data;
            if (data.length > 0) {
                layer.confirm('确认删除选中项？', function (index) {
                    for (var i = 0; i < data.length; i++) {
                        var id = data[i].id;
                        $.ajax({
                            type: 'POST',
                            url: '/dbinfo/delete',
                            data: {"id": id},
                            success: function (data) {
                                active['reload'].call(this);
                            },
                            error: function (e, state, errorThrown) {
                                console.log(e);
                            },
                        });
                    }
                    layer.close(index);
                });
            } else {
                layer.msg('请选择删除数据！');
            }
        });
        
        $(document).on('click','#reset-connection',function () {
            $('#edit-dbtype')[0].defaultValue=$('#edit-dbtype')[0].value;
            $('#edit-database')[0].defaultValue=$('#edit-database')[0].value;
            $('#edit-host')[0].defaultValue=$('#edit-host')[0].value;
            $('#edit-port')[0].defaultValue=$('#edit-port')[0].value;
        })
    }

    /**
     * 提交新增数据库连接
     */
    form.on('submit(add-submit)', function (data) {
        var field = data.field;
        register(field);
    });

    /**
     * 提交编辑数据库连接
     */
    form.on('submit(edit-submit)', function (data) {
        var field = data.field;
        update(field);
    });

    /**
     * 表格工具列事件
     */
    table.on('tool(data-table)', function (obj) {
        var data = obj.data;
        if (obj.event == 'edit') {
            var params = data.parameters;
            if (params.schema == "postgis") {
                $('#div-edit-schema').show();
            }
            else {
                $('#div-edit-schema').hide();
            }
            form.val('edit-form', {
                "instanceName": data.instanceName,
                "id": data.id,
                "description": data.description,
                "database": params.database,
                "host": params.host,
                "schema": params.schema,
                "port": params.port,
                "dbtype": params.dbtype,
                "user": params.user,
                "passwd": params.passwd,
            });
            showLayer(1);
        }
        else if (obj.event == 'del') {
            layer.confirm('确认删除' + data.instanceName + '？', function (index) {
                var id = data.id;
                $.ajax({
                    type: 'POST',
                    url: '/dbinfo/delete',
                    data: {"id": id,},
                    success: function (data) {
                        var isdelete = data.data;
                        if (isdelete) {
                            obj.del();
                        }
                    },
                    error: function (e, state, errorThrown) {
                        console.log(e);
                    }
                });
                layer.close(index);
            });
        }
    });

    /**
     * 弹窗
     * @param index 0表示新增，1表示修改
     */
    function showLayer(index) {
        var height=$(".right-content").outerHeight();
        if (index == '0') {
            addIndex = layer.open({
                title: '新增数据库连接',
                shadeClose: true,
                type: 1,
                area: ['700px','500px'],
                maxHeight: height,
                maxWidth: 1000,
                content: $('#add-div'),
            })
        }
        else if (index == '1') {
            editIndex = layer.open({
                title: '修改数据库连接',
                shadeClose: true,
                type: 1,
                area: ['700px','500px'],
                maxHeight: height,
                maxWidth: 1000,
                content: $('#edit-div'),
            })
        }
    };

    /**
     * 注册数据库实例
     * @param field 实例参数列表
     */
    function register(field) {
        var dbtype = $("#add-form .layui-this").text();
        var parameters = {};
        parameters["dbtype"] = dbtype;
        parameters["host"] = field.host;
        parameters["port"] = field.port;
        parameters["user"] = field.user;
        parameters["passwd"] = field.passwd;
        parameters["database"] = field.database;
        parameters["schema"] = field.schema;

        $.ajax({
            type: 'POST',
            url: '/dbinfo/register',
            data: {
                "dbTypeId": field.dbtype,
                "instanceName": field.instanceName,
                "description": field.description,
                "parameters": JSON.stringify(parameters),
            },
            success: function (data) {
                reload();
                layer.close(addIndex);
                layer.msg("添加实例成功！");
            },
            error: function (e, state, errorThrown) {
                console.log(e);
                layer.msg("添加实例失败！");
            }
        });
    };

    /**
     * 重新加载表格
     */
    function reload() {
        table.reload('data-table', {
            page: {
                curr: page,
            }
        }, 'data');
    };

    /**
     * 格式转换
     * @param arr
     * @returns {string}
     */
    function convertData(arr, dbtype) {
        var data = {};
        for (var i = 0; i < arr.length; i++) {
            var item = arr[i];
            if (dbtype && item["name"] == "dbtype") {
                data[item["name"]] = dbtype;
            }
            else if (!data[item["name"]]) {
                data[item["name"]] = item["value"];
            }
        }
        return JSON.stringify(data);
    };

    /**
     * 更新数据库连接(可更新名称、用户名、密码和描述)
     * @param field
     */
    function update(field) {
        var params = [];
        params["instanceName"] = field.instanceName;
        params["description"] = field.description;
        var parameters = [];
        parameters["user"] = field.user;
        parameters["passwd"] = field.passwd;
        parameters["schema"] = field.schema;
        params["parameters"] = parameters;
        $.ajax({
            type: 'POST',
            url: '/dbinfo/update',
            data: {
                "instanceId": field.id,
                "parameters": JSON.stringify(params),
            },
            success: function (obj) {
                reload();
                layer.close(editIndex);
                layer.msg("添加实例成功！");
            }
        });
    };

    //验证表单填写是否符合规则
    form.verify({
        ip: [
            /^(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])$/,
            'IP地址不符合规则'
        ]
    });

    /**
     * 如果新增的是postgis，则显示schema输入框
     */
    form.on('select(add-dbtype)', function (obj) {
        var name = obj.elem.selectedOptions[0].innerHTML;
        if (name == "postgis") {
            $('#div-add-schema').show();
        }
        else {
            $('#div-add-schema').hide();
        }
    })
});