layui.config({
    base: './js/'
}).use(['layer', 'table', 'form', 'upload'], function () {
    let $ = layui.jquery,
        table = layui.table,
        form = layui.form,
        layer = layui.layer;

    /**
     * 入库任务列表内容绑定
     */
    let insertTableIns = table.render({
        elem: '#insert-table',
        url: '/data-insert/taskInfos',
        skin: 'line',
        even: true,
        id: 'insert-table',
        height: '680',
        page: {
            layout: ['prev', 'page', 'next', 'limit', 'skip'],
            theme: '#1890FF',
        },
        limit: 10,
        where: {
            keywords: $('#search-text').val(),
        },
        cols: [[
            {
                field: 'fileName', title: '入库文件', align: 'center', templet: function (obj) {
                    let fileName = obj.folderPath;
                    if (fileName.lastIndexOf('\\') != -1) {
                        fileName = fileName.substr(fileName.lastIndexOf('\\') + 1);
                    } else if (fileName.lastIndexOf('/') != -1) {
                        fileName = fileName.substr(fileName.lastIndexOf('/') + 1);
                    }
                    return fileName;
                }
            },
            {
                field: 'insAndTables', title: '入库实例和表名', align: 'center', templet: function (obj) {
                    let listSubTasks = obj.subTaskInfos;
                    let insAndTables = {};
                    let str = "";
                    for (let i = 0; i < listSubTasks.length; i++) {
                        let subTask = listSubTasks[i];
                        let instanceId = subTask.instanceId;
                        let tableName = subTask.tableName;
                        if (insAndTables[instanceId]) {
                            instanceId[instanceId] += tableName + ';';
                        } else {
                            insAndTables[instanceId] = tableName + ';';
                        }
                        str += instanceId + ':' + insAndTables[instanceId] + "\n";
                    }
                    return str;
                }
            },
            {
                field: 'startTime', title: '任务开始时间', align: 'center',width:160, templet: function (obj) {
                    let startTime = obj.startTime;
                    return helper.transformTimestamp(startTime);
                }
            },
            {
                field: 'finishedTime', title: '任务结束时间', align: 'center', width: 160, templet: function (obj) {
                    if (obj.finishedTime != 0) {
                        return helper.transformTimestamp(obj.finishedTime);
                    } else {
                        return '';
                    }
                }
            },
            {
                field: 'taskStatus', title: '任务状态', align: 'center',width: 100, templet: function (obj) {
                    let status = '';
                    switch (obj.taskStatus) {
                        case 'error':
                            status = '失败';
                            break;
                        case 'finished':
                            status = '成功';
                            break;
                        case 'processing':
                            status = '进行中';
                            break;
                        case 'submit':
                            status = '尚未开始';
                            break;
                        default:
                            break;
                    }
                    return status;
                }
            }
        ]],
        done: function (res, curr, count) {
            table.resize('insert-table');
        },
    });
    /**
     * 删除任务列表内容绑定
     */
    let deleteTableIns = table.render({
        elem: '#delete-table',
        url: '/data-insert/deleteTasks',
        skin: 'line',
        even: true,
        id: 'delete-table',
        height: '680',
        page: {
            layout: ['prev', 'page', 'next', 'limit', 'skip'],
            theme: '#1890FF',
        },
        limit: 10,
        where: {
            keywords: $('#search-text').val(),
        },
        cols: [[
            {
                field: 'tableId', title: '表id', align: 'center', hide: true, templet: function (obj) {
                    return obj.tableId;
                }
            },
            {
                field: 'tableName', title: '表名', align: 'center', templet: function (obj) {
                    let name;
                    $.ajax({
                        type: 'GET',
                        async: false,
                        url: '/metainfo/meta?id=' + obj.tableId,
                        success: function (obj) {
                            for (var i = 0; i < obj.data.length; i++) {
                                if (obj.data[i].name == 'tableName') {
                                    name = obj.data[i].value;
                                }
                            }
                        },
                        error: function (e, state, error) {
                        },
                    });
                    return name;
                }
            },
            // {
            //     field: 'where', title: '删除条件', align: 'center', templet: function (obj) {
            //         return obj.where;
            //     }
            // },
            {
                field: 'startTime', title: '任务开始时间', align: 'center', templet: function (obj) {
                    if (obj.submitTime != 0) {
                        let startTime = obj.submitTime;
                        return helper.transformTimestamp(startTime);
                    } else {
                        return '';
                    }

                }
            },
            {
                field: 'finishedTime', title: '任务结束时间', align: 'center', templet: function (obj) {
                    if (obj.finishedTime != 0) {
                        return helper.transformTimestamp(obj.finishedTime);
                    } else {
                        return '';
                    }
                }
            },
            {
                field: 'taskStatus', title: '任务状态', align: 'center', templet: function (obj) {
                    let status = '';
                    switch (obj.taskStatus) {
                        case 'error':
                            status = '失败';
                            break;
                        case 'finished':
                            status = '成功';
                            break;
                        case 'processing':
                            status = '进行中';
                            break;
                        case 'submit':
                            status = '尚未开始';
                            break;
                        default:
                            break;
                    }
                    return status;
                }
            }
        ]],
        done: function (res, curr, count) {
            table.resize('delete-table');
        },
    });
    /**
     * 切换入库/删除任务列表
     */
    $(document).on('click', '[name=btn-insert-list]', function () {
        let $this = $(this);
        let $divInsert = $('#div-insert');
        let $divDelete = $('#div-delete');
        $('.btn-select').removeClass('btn-select').addClass('btn-unselect');
        $this.removeClass('btn-unselect').addClass('btn-select');
        if ($this.text() == '入库任务列表' && $divInsert.is(':hidden')) {
            insertTableIns.reload();
            $('#search-text').val('');
            $('#div-insert').show();
            $('#div-delete').hide();
        } else if ($this.text() == '删除任务列表' && $divDelete.is(':hidden')) {
            deleteTableIns.reload();
            $('#search-text').val('');
            $('#div-insert').hide();
            $('#div-delete').show();
        }
    });

    //以下查询功能因无任务名称废弃
    /**
     * 查询功能
     */
    $(document).on('click', '#search-btn', function () {
        let $divInsert = $('#div-insert');
        let $divDelete = $('#div-delete');
        if (!$divInsert.is(':hidden')) {
            table.reload('insert-table', {
                where: {
                    keywords: $('#search-text').val(),
                }
            }, 'data');
        } else if (!$divDelete.is(':hidden')) {
            table.reload('delete-table', {
                where: {
                    keywords: $('#search-text').val(),
                }
            }, 'data');
        }
    });
    /**
     * 查询功能
     */
    $('#search-text').keyup(function (event) {
        $('#search-btn').trigger('click');
    });
});