layui.config({
    base: './js/'
}).use(['layer', 'table', 'form', 'upload'], function () {
    let $ = layui.jquery,
        table = layui.table,
        form = layui.form,
        upload = layui.upload,
        layer = layui.layer;

    let fileTableIns, addTableIns, shpUploadIns, addIndex, contrastIns;

    let change_upload = 0, change_select = 0;    //分别标识是否更换过上传，数据库选择的文件

    let global_insert = true, global_update = true;      //分别标识是否重新从后台获取全量入库和增量更新的相关接口

    let params = [], addCount = 0;     //记录全量入库时需要导入的数据库和表信息

    let chooseFile, chooseData, chooseTableId;      //记录上传文件的内容、选择文件和数据库表id的内容

    let resultTableId, resultFolderPath;     //最终tableId和路径

    let fieldlist = [];      //表字段列表

    init();

    bindButton();

    bindAllDB();

    function init() {
        // 初始化步骤
        $('.box').step({
            stepDirection: 'x',
            showStepButton: true,
            stepCount: 3,
            stepTitles: ['设置数据源', '数据概览', '设置入库参数'],
        });

        // 绑定选择文件的文件列表
        fileTableIns = table.render({
            elem: '#file-table',
            url: '/data-insert/file',
            skin: 'line',
            even: true,
            id: 'file-table',
            height: '355',
            page: {
                layout: ['prev', 'page', 'next', 'limit', 'skip'],
                theme: '#1890FF',
            },
            where: {
                keywords: $('#search-text').val(),
            },
            cols: [[
                {type: 'radio', fixed: 'left'},
                {
                    field: 'fileName', title: '文件名称', align: 'center', templet: function (obj) {
                        return obj.fileName;
                    }
                },
                {
                    field: 'folderPath', title: '文件路径', align: 'center', templet: function (obj) {
                        return obj.folderPath;
                    }
                },
                {
                    field: 'fileSize', title: '文件大小', align: 'center', templet: function (obj) {
                        return obj.fileSize;
                    }
                },
                {
                    field: 'createTime', title: '创建时间', align: 'center', templet: function (obj) {
                        return obj.createTime;
                    }
                }
            ]],
            done: function (res, curr, count) {
                // $('input[name="layTableRadio_2"]').attr('disabled', true);
                form.render('radio');
                table.resize('file-table');
            },
        });

        addTableIns = table.render({
            elem: '#add-table',
            defaultToolbar: [],
            id: 'add-table',
            data: params,
            limit: 100,
            text: {none: "无实例信息"},
            cols: [[
                {
                    field: 'instanceId',
                    title: '数据库实例id',
                    align: 'center',
                    hide: true,
                    templet: function (obj) {
                        return obj.instanceId;
                    }
                },
                {
                    field: 'instanceName', title: '数据库实例名称', align: 'center', templet: function (obj) {
                        return obj.instanceName;
                    }
                },
                {
                    field: 'type', title: '创建方式', align: 'center', templet: function (obj) {
                        return obj.type;
                    }
                },
                {
                    field: 'tableId', title: '表id', align: 'center', hide: true, templet: function (obj) {
                        return obj.tableId;
                    }
                },
                {
                    field: 'tableName', title: '表名称', align: 'center', templet: function (obj) {
                        return obj.tableName;
                    }
                },
                {field: 'operation', title: '操作', width: 110, toolbar: '#bar-delete', align: 'center'}
            ]],
            done: function (res, curr, count) {
                table.resize('add-table');
            }
        })

        // 上传绑定,延迟上传
        shpUploadIns = upload.render({
            elem: '#upload-button',
            url: '',
            accept: 'file',
            exts: 'zip|rar|7z',
            auto: false,
            bindAction: '.eis-over-btn',
            choose: function (obj) {
                obj.preview(function (index, file) {
                    $('#text-name').val(file.name);
                    chooseFile = file;
                    if (chooseFile) {
                        $('.eis-next-btn').attr('disabled', false);
                    }
                })
            },
            done: function (res, index, upload) {
            }
        });

        // 设置数据源，二选一
        form.on('radio(set-datasource)', function (data) {
            let val = data.value;
            let $divUpload = $('#div-select-upload');
            let $divChoose = $('#div-select-choose');
            let $divDatabase = $('#div-select-database');
            if (val === '上传shp压缩文件') {
                // $('#search-btn').attr('disabled', true);
                // $('#upload-button').attr('disabled', false);
                // $('#text-name').css('color', 'black');
                // $('#text-name').css('background-color', 'white');
                // $('#selectdb-datasource').attr('disabled', true);
                // $('#selecttable-datasource').attr('disabled', true);
                // $('input[name="layTableRadio_2"]').attr('disabled', true);
                // if (!$('#text-name').text()) {
                //     $('.eis-next-btn').attr('disabled', true);
                // } else {
                //     $('.eis-next-btn').attr('disabled', false);
                // }
                $divUpload.show();
                $divChoose.hide();
                $divDatabase.hide();
                form.render('radio');
            } else if (val === '选择已有文件') {
                // $('#upload-button').attr('disabled', true);
                // $('#search-btn').attr('disabled', false);
                // $('#text-name').css('color', '#eee');
                // $('#selectdb-datasource').attr('disabled', true);
                // $('#selecttable-datasource').attr('disabled', true);
                // $('input[name="layTableRadio_2"]').attr('disabled', false);
                // form.render('radio');
                // let checkStatus = table.checkStatus('file-table');
                // let data = checkStatus.data;
                // if (data.length > 0) {
                //     $('.eis-next-btn').attr('disabled', false);
                // } else {
                //     $('.eis-next-btn').attr('disabled', true);
                // }
                $divUpload.hide();
                $divChoose.show();
                $divDatabase.hide();
            } else if (val === '选择数据库数据') {
                // $('#upload-button').attr('disabled', true);
                // $('#search-btn').attr('disabled', true);
                // $('#text-name').css('color', '#eee');
                // $('#selectdb-datasource').attr('disabled', false);
                // if (!$('#selectdb-datasource').val()) {
                //     $('#selecttable-datasource').attr('disabled', true);
                // } else {
                //     $('#selecttable-datasource').attr('disabled', false);
                // }
                // $('input[name="layTableRadio_2"]').attr('disabled', true);
                // form.render('radio');
                // if ($('#selecttable-datasource').val()) {
                //     $('.eis-next-btn').attr('disabled', false);
                // } else {
                //     $('.eis-next-btn').attr('disabled', true);
                // }
                $divUpload.hide();
                $divChoose.hide();
                $divDatabase.show();
                form.render('radio');
            }
            form.render('select');
        });

        table.on('radio(file-table)', function (obj) {
            if (obj.checked) {
                $('.eis-next-btn').attr('disabled', false);
            }
        });

        // bindDB('#selectdb-datasource');

        // $('#select-table').attr("disabled", true);
        // $('#selecttable-update').attr("disabled", true);
        // $('#selectdb-datasource').attr("disabled", true);
        // $('#selecttable-datasource').attr("disabled", true);
        // $('.eis-next-btn').attr('disabled', true);
        form.render('select');
    };

    function bindButton() {
        // 监视上传按钮是否被点击过，如果点击过则重新解析文件
        $(document).on('click', '#upload-button', function () {
            if ($('#upload-button').attr('disabled')) {
                return;
            }
            change_upload = 1;
        });

        $(document).on('click', '#btn-add', function () {
            if (addCount == 3) {
                layer.msg("最多添加3个数据库实例！");
                return;
            }
            addCount++;
            form.val('set-form', {
                'selectdb': '',
                'create-newtable': '新建表名',
                'text-tablename': '',
                'select-table': ''
            });
            if ($('input[name="create-newtable"]:checked').val() === '新建表名') {
                $('#text-tablename').attr('disabled', false);
                $('#text-tablename').css('color', 'black');
                $('#select-table').attr('disabled', true);
            } else if ($('input[name="create-newtable"]:checked').val() === '覆盖已有表') {
                $('#text-tablename').attr('disabled', true);
                $('#text-tablename').css('color', '#eee');
                $('#select-table').attr('disabled', false);
            }
            form.render('select');
            showLayer();
        });

        form.on('radio(create-newtable)', function (data) {
            let val = data.value;
            if (val === '新建表名') {
                $('#text-tablename').attr('disabled', false);
                $('#text-tablename').css('color', 'black');
                $('#select-table').attr('disabled', true);
            } else if (val === '覆盖已有表') {
                $('#text-tablename').attr('disabled', true);
                $('#text-tablename').css('color', '#eee');
                $('#select-table').attr('disabled', false);
            }
            form.render('select');
        });

        $(document).on('click', '#btn-submit', function () {
            let type = $('input[name="create-newtable"]:checked').val();
            let tableId = '', tableName;
            if (type === '新建表名') {
                tableName = $('#text-tablename').val();
            } else if (type === '覆盖已有表') {
                tableId = $('#select-table').val();
                tableName = $('#select-table option:selected').text();
            }
            params.push({
                instanceId: $('#selectdb').val(),
                instanceName: $('#selectdb option:selected').text(),
                type: type,
                tableId: tableId,
                tableName: tableName
            });
            addTableIns.reload({data: params});
            layer.close(addIndex);
        });

        // 查询
        $(document).on('click', '#search-btn', function () {
            table.reload('file-table', {
                where: {
                    keywords: $('#search-text').val(),
                }
            }, 'data');
        });

        table.on('tool(add-table)', function (obj) {
            let index = obj.tr[0].attributes[0].value;
            params.splice(index, 1);
            addCount--;
            addTableIns.reload({data: params});
        })

        // 当选择数据库实例后，获取数据库下表
        form.on('select(selectdb)', function (data) {
            let instancId = data.value;
            bindDBTables('#select-table', instancId);
            if ($('input[name="create-newtable"]:checked').val() == '覆盖已有表') {
                $('#select-table').attr("disabled", false);
                form.render('select');
            }
        });
        form.on('select(selectdb-update)', function (data) {
            let instancId = data.value;
            bindDBTables('#selecttable-update', instancId);
            $('#selecttable-update').attr("disabled", false);
            form.render('select');
        });
        form.on('select(selectdb-datasource)', function (data) {
            let instancId = data.value;
            bindDBTables('#selecttable-datasource', instancId);
            $('#selecttable-datasource').attr("disabled", false);
            form.render('select');
        })

        form.on('select(selecttable-update)', function (data) {
        });

        form.on('select(selecttable-datasource)', function (data) {
            change_select = 1;
            chooseTableId = data.value;
        })

        // 点击下一步
        $(document).on('click', '.eis-next-btn', function () {
            if (!$('#first-div').is(':hidden')) {

            } else if (!$('#second-div').is(':hidden')) {// 预读数据
                let needAnalysis = false, needFile, needPath = '', needTableId = '';
                let method = $('input:radio[name="set-datasource"]:checked').val();
                if (method === '选择已有文件') {
                    let checkStatus = table.checkStatus('file-table');
                    let data = checkStatus.data;
                    if (data != chooseData) {           //需要重新读取数据
                        needAnalysis = true;
                        chooseData = data;
                        needPath = chooseData[0].folderPath;
                    }
                } else if (method === '上传shp压缩文件') {
                    if (change_upload === 1) {
                        needAnalysis = true;
                        needFile = chooseFile;
                    }
                } else if (method === '选择数据库数据') {
                    if (change_select === 1) {
                        needAnalysis = true;
                        needTableId = chooseTableId;
                    }
                }
                if (needAnalysis) {
                    var formData = new FormData();
                    formData.append("file", needFile);
                    formData.append("folderPath", needPath);
                    formData.append("tableId", needTableId);
                    formData.append("size", 10);
                    $.ajax({
                        url: "/data-insert/parseFile",
                        type: "POST",
                        contentType: false,
                        processData: false,
                        data: formData,
                        beforeSend: function () {
                            layerIndex_waiting = helper.showLoad("正在解析数据内容...");
                        },
                        success: function (obj) {
                            helper.closeLoad(layerIndex_waiting);
                            let dynamicCols = [], cols = [];
                            let data = obj.data;
                            if (data.length != 0) {
                                let fieldsType = data.fieldsType;
                                resultTableId = data.tableId;
                                resultFolderPath = data.folderPath;
                                fieldlist = [];
                                for (let key in fieldsType) {
                                    let value = fieldsType[key];
                                    if (key != 'the_geom') {
                                        cols.push({field: key, title: key});
                                    }
                                    fieldlist.push({name: key, contrastName: key, type: value});
                                }
                                dynamicCols.push(cols);
                                let properties = data.properties;
                                table.render({
                                    elem: '#data-table',
                                    data: properties,
                                    cellMinWidth: 100,
                                    // skin: 'line',
                                    even: true,
                                    height: '422',
                                    id: 'data-table',
                                    cols: dynamicCols,
                                    done: function (res, curr, count) {
                                        //执行表格“尺寸结构”的重置，这个必须要执行，否则获取的body的高度不准确
                                        table.resize('data-table');
                                    }
                                })
                            }
                        },
                        error: function (e, state, error) {
                            helper.closeLoad(layerIndex_waiting);
                            layer.msg("解析数据失败！");
                            console.log(e);
                        },
                    })
                }
            } else if (!$('#thirth-div').is(':hidden')) {
                if ($('input[name="insert-type"]:checked').val() === '全量入库') {
                    $('#first-form').show();
                    $('#second-form').hide();

                    if (global_insert) {
                        global_insert = !global_insert;
                        // bindDB('#selectdb');
                    }
                    if (global_update) {
                        global_update = !global_update;
                        // bindDB('#selectdb-update');
                    }

                    //生成数据字段对应表
                    contrastIns = table.render({
                        elem: '#contrast-table',
                        defaultToolbar: [],
                        id: 'contrast-table',
                        even: true,
                        data: fieldlist,
                        limit: 100,
                        height: '295',
                        cols: [[
                            {
                                field: 'name',
                                title: '字段名称',
                                align: 'center',
                                templet: function (obj) {
                                    return obj.name;
                                }
                            },
                            {
                                field: 'contrastName',
                                title: '对应字段',
                                align: 'center',
                                edit: 'text',
                                templet: function (obj) {
                                    return obj.contrastName;
                                }
                            },
                            {
                                field: 'type', title: '字段类型', align: 'center', templet: function (obj) {
                                    return obj.type;
                                }
                            },
                            {
                                field: 'index', title: '是否创建索引', align: 'center', type: 'checkbox'
                            },
                        ]],
                        done: function (res, curr, count) {
                            table.resize('contrast-table');
                        }
                    })
                } else if ($('input[name="insert-type"]:checked').val() === '增量更新') {
                    $('#first-form').hide();
                    $('#second-form').show();
                    // bindDB('#selectdb-update');
                }
            }
        });

        $(document).on('click', '.eis-over-btn', function () {
            let data = contrastIns.config.data;
            $.ajax({
                type: 'post',
                url: '/data-insert/import',
                data: {
                    params: JSON.stringify(params),
                    fields: JSON.stringify(data),
                    tableId: resultTableId,
                    folderPath: resultFolderPath,
                    taskType: $('input[name="insert-type"]:checked').val()
                },
                async: false,
                beforeSend: function () {
                    layerIndex_waiting = helper.showLoad("任务提交中...");
                },
                success: function (obj) {
                    helper.closeLoad(layerIndex_waiting);
                    let data = obj.data;
                    if (data.length != 0) {
                        if (data) {
                            layer.msg("提交任务成功！");
                        } else {
                            layer.msg("提交任务失败！");
                        }
                    }
                },
                error: function (e, state, error) {
                    helper.closeLoad(layerIndex_waiting);
                    layer.msg("提交任务失败！");
                    console.log(e);
                },
            });
            window.location.reload();
        });
    };

    function bindAllDB() {
        $.ajax({
            type: 'GET',
            url: '/tablesinfo/instance',
            success: function (obj) {
                let data = obj.data;
                let option = "<option></option>";
                if (data.length != 0) {
                    for (let i = 0; i < data.length; i++) {
                        option += "<option value=\"" + data[i].id + "\">" + data[i].instanceName + "</option>";
                    }
                    $('#selectdb').html(option);
                    $('#selectdb-datasource').html(option);
                    $('#selectdb-update').html(option);
                    form.render('select');
                }
            },
            error: function (e, state, error) {
                layer.msg("获取数据库实例数据失败!");
            },
        });
    };

    function bindDB(elem) {
        let $this = $(elem);
        let layerIndex_waiting;
        $.ajax({
            type: 'GET',
            url: '/tablesinfo/instance',
            // beforeSend: function () {
            //     layerIndex_waiting = helper.showLoad("正在获取数据库实例信息...");
            // },
            success: function (obj) {
                // helper.closeLoad(layerIndex_waiting);
                let data = obj.data;
                let option = "<option></option>";
                if (data.length != 0) {
                    for (let i = 0; i < data.length; i++) {
                        option += "<option value=\"" + data[i].id + "\">" + data[i].instanceName + "</option>";
                    }
                    $this.html(option);
                    form.render('select');
                }
            },
            error: function (e, state, error) {
                // helper.closeLoad(layerIndex_waiting);
                layer.msg("获取数据库实例数据失败!");
            },
        });
    };

    function bindDBTables(elem, id) {
        let $this = $(elem);
        let layerIndex_waiting;
        if (!id) {
            $this.attr("disabled", true);
            $this.html("");
            form.render('select');
            return;
        }
        $.ajax({
            type: 'GET',
            url: '/data-insert/listlayer?id=' + id,
            beforeSend: function () {
                layerIndex_waiting = helper.showLoad("正在获取数据仓储表信息...");
            },
            success: function (obj) {
                helper.closeLoad(layerIndex_waiting);
                let data = obj.data;
                if (data.length != 0) {
                    let option = "<option></option>";
                    for (let i = 0; i < data.length; i++) {
                        option += "<option value=\"" + data[i].id + "\">" + data[i].tableName + "</option>";
                    }
                    // $this.attr("disabled", false);
                    $this.html(option);
                    form.render('select');
                }
            },
            error: function (e, state, error) {
                helper.closeLoad(layerIndex_waiting);
                layer.msg("获取数据失败！");
                $this.attr("disabled", true);
                $this.html("");
                console.log(e);
            },
        });
    };

    function showLayer() {
        addIndex = layer.open({
            title: '添加数据库设置',
            shadeClose: true,
            type: 1,
            area: ['600px', '450px'],
            maxHeight: 450,
            maxWidth: 1000,
            content: $('#add-div'),
        });
        form.render('radio');
    }
})