layui.config({
    base: './js/'
}).use(['layer', 'table', 'form', 'upload'], function () {
    let $ = layui.jquery,
        table = layui.table,
        form = layui.form,
        upload = layui.upload,
        layer = layui.layer;

    let tableins, uploadins, selectTableId, queryParam = [], chooseFile = null, queryCount = 1, preview, deleteTask,
        dynamicCols = [];

    init();
    bindButton();

    function init() {
        $('.box').step({
            stepDirection: 'x',
            showStepButton: true,
            stepCount: 3,
            stepTitles: ['选择数据源', '查询删除数据', '确认删除信息'],
        });

        /**
         * 选择数据表
         */
        tableins = table.render({
            elem: '#table-table',
            url: '/tablesinfo/search',
            skin: 'line',
            even: true,
            id: 'table-table',
            height: '580',
            page: {
                layout: ['prev', 'page', 'next', 'limit', 'skip'],
                theme: '#1890FF',
            },
            where: {
                keyword: $('#search-text1').val(),
                moduleCode: 'ccglzy',
                ownState: 'private',
            },
            cols: [
                [{
                    type: 'radio'
                },
                    {
                        title: 'ID',
                        field: 'id',
                        hide: true,
                        templet: function (obj) {
                            return obj.id;
                        },
                    },
                    {
                        title: '名称',
                        field: 'name',
                        align: 'center',
                        templet: function (obj) {
                            return obj.tableName;
                        },
                    },
                    {
                        title: '数据类型',
                        field: 'dataType',
                        align: 'center',
                        templet: function (obj) {
                            return obj.dataType;
                        },
                    },
                    {
                        title: '数据来源',
                        field: 'resource',
                        align: 'center',
                        templet: function (obj) {
                            return obj.dataSource;
                        },
                    },
                    {
                        title: '关键字',
                        field: 'dataTags',
                        align: 'center',
                        templet: function (obj) {
                            if (!obj.dataTags) {
                                return "";
                            }
                            return obj.dataTags;
                        },
                    },
                    {
                        title: '更新时间',
                        field: 'dbTypeName',
                        align: 'center',
                        templet: function (obj) {
                            return renderDate(obj.lastUpdateTime);
                        },
                    },
                    {
                        title: '数据库连接',
                        field: 'dbName',
                        hide: true,
                        templet: function (obj) {
                            return obj.dbName;
                        },
                    },
                    {
                        title: '操作',
                        field: 'tool',
                        align: 'center',
                        style: 'cursor:pointer',
                        toolbar: '#toolbar',
                    },
                ]
            ],
            done: function (res, curr, count) {
                table.resize('table-table');
            },
        });
        /**
         * 上传按钮绑定
         */
        uploadins = upload.render({
            elem: '#upload-button',
            url: '',
            accept: 'file',
            exts: 'zip|rar|7z',
            auto: false,
            bindAction: '.eis-over-btn',
            choose: function (obj) {
                obj.preview(function (index, file) {
                    $('#text-name').val(file.name);
                    chooseFile = file;
                });
            },
            done: function (res, index, upload) {
            }
        });
    };

    /**
     * 绑定按钮事件
     */
    function bindButton() {
        /**
         * 选择数据源时，查询功能
         */
        $(document).on('click', '#search-btn1', function () {
            table.reload('table-table', {
                where: {
                    keyword: $('#search-text1').val(),
                    moduleCode: 'ccglzy',
                    ownState: 'private',
                }
            }, 'data');
        });
        $('#search-text').keyup(function (event) {
            $('#search-btn1').trigger('click');
        });
        /**
         * 添加查询条件
         */
        $(document).on('click', '[name=btn-addquery]', function () {
            if (queryCount == 10) {
                layer.msg('最多可添加10个过滤条件');
                return;
            }
            queryCount++;
            $(this).hide();
            $('[name=btn-deletequery]').show();
            let $divQuery = $('#div-query');
            $divQuery.append($('#div-addquery').html());
            form.render();
        });
        /**
         * 删除查询条件
         */
        $(document).on('click', '[name=btn-deletequery]', function () {
            let $this = $(this);
            let $parentDiv = $this.parents().parent('.layui-row');
            if ($parentDiv.next('.layui-row').length == 0) {
                let $preDiv = $parentDiv.prev();
                $preDiv.find('[name=btn-addquery]').show();
            }
            queryCount--;
            if (queryCount == 1) {
                $('[name=btn-deletequery]').hide();
            }
            $parentDiv.remove();
            form.render();
        });
        /**
         * 点击下一步，触发具体事件
         */
        $(document).on('click', '.eis-next-btn', function () {
            //跳到第二步
            if (!$('#div-second').is(':hidden')) {
                //根据tableid获取字段列表，绑定select
                let checkStatus = table.checkStatus('table-table');
                let data = checkStatus.data;
                if (data.length == 0) {
                    //如果没有选择数据表，跳回到第一页
                    $('.eis-prev-btn').trigger('click');
                    layer.msg('请选择数据表！');
                    return;
                }
                selectTableId = data[0].id;
                bindSelectforField('[name=select-field]', selectTableId);
            } else if (!$('#div-thirth').is(':hidden')) {
                //获取属性查询条件
                let isCorrect = true;
                let $divParams = $('#div-second').find('[name=div-part-query]');
                queryParam = [];
                $divParams.each(function (i, divElement) {
                    let fieldName = $(divElement).find('[name=select-field]').val();
                    let predicate = $(divElement).find('[name=text-queryfilter]').val();
                    let fieldValue = $(divElement).find('[name=text-value]').val();
                    // if (fieldName == '' && predicate == '' && fieldValue == '') {
                    //     return;
                    // }
                    queryParam.push({fieldName: fieldName, predicate: predicate, fieldValue: fieldValue});
                    if ((fieldName == '' || predicate == '' || fieldValue == '')) {       //存在属性条件填写不完整的情况
                        isCorrect = false;
                    }
                });
                if (!isCorrect&&!$('#check-deleteAll').is(':checked')) {
                    $('.eis-prev-btn').trigger('click');
                    layer.msg('请确认是否填写完整属性条件或勾选“删除所有数据”！');
                    queryParam = [];
                    return;
                }
                var formData = new FormData();
                formData.append("file", chooseFile);
                formData.append("params", JSON.stringify(queryParam));
                formData.append("tableId", selectTableId);
                formData.append("deleteAll",$('#check-deleteAll').is(':checked'))
                $.ajax({
                    url: "/data-insert/deletePreview",
                    type: "POST",
                    contentType: false,
                    processData: false,
                    data: formData,
                    beforeSend: function () {
                        layerIndex_waiting = helper.showLoad("正在进行查询...");
                    },
                    success: function (obj) {
                        helper.closeLoad(layerIndex_waiting);
                        let data = obj.data;
                        if (data) {
                            preview = data.preview;
                            deleteTask = data.task;
                            if (preview) {
                                let metatables = preview.taskRelationship.metaTables;
                                let tableCount = metatables.length;
                                let $lblTable = $('#lbl-delete-table');
                                let $lblCount = $('#lbl-delete-data');
                                if (tableCount == 0) {
                                    $lblTable.hide();
                                }
                                let count = preview.count;
                                $lblCount.text('表中共计删除' + count + '条数据');

                                table.render({
                                    elem: '#relate-table',
                                    data: metatables,
                                    skin: 'line',
                                    even: true,
                                    id: 'relate-table',
                                    height: '220',
                                    text: {
                                        none: '无可删除数据表数据'
                                    },
                                    page: {
                                        layout: ['prev', 'page', 'next', 'limit', 'skip'],
                                        theme: '#1890FF',
                                    },
                                    cols: [
                                        [{
                                            title: 'ID',
                                            field: 'id',
                                            hide: true,
                                            templet: function (obj) {
                                                return obj.id;
                                            },
                                        },
                                            {
                                                title: '名称',
                                                field: 'name',
                                                align: 'center',
                                                templet: function (obj) {
                                                    $lblTable.append(obj.metaInstance.instanceName + '实例中' + obj.tableName + '表；');
                                                    return obj.tableName;
                                                },
                                            },
                                            {
                                                title: '数据类型',
                                                field: 'dataType',
                                                align: 'center',
                                                templet: function (obj) {
                                                    return obj.dataType;
                                                },
                                            },
                                            {
                                                title: '数据来源',
                                                field: 'resource',
                                                align: 'center',
                                                templet: function (obj) {
                                                    return obj.dataSource;
                                                },
                                            },
                                            {
                                                title: '数据库实例id',
                                                field: 'instanceId',
                                                hide: true,
                                                templet: function (obj) {
                                                    return obj.metaInstance.id;
                                                },
                                            },
                                            {
                                                title: '数据库实例名称',
                                                field: 'instanceName',
                                                align: 'center',
                                                templet: function (obj) {
                                                    return obj.metaInstance.instanceName;
                                                },
                                            },
                                            {
                                                title: '创建人',
                                                field: 'createBy',
                                                align: 'center',
                                                templet: function (obj) {
                                                    return obj.createBy;
                                                },
                                            }
                                        ]
                                    ],
                                    done: function (res, curr, count) {
                                        table.resize('relate-table');
                                    },
                                });

                                table.render({
                                    elem: '#data-table',
                                    url: '/data-insert/previewData',
                                    skin: 'line',
                                    even: true,
                                    id: 'data-table',
                                    height: '320',
                                    page: {
                                        layout: ['prev', 'page', 'next', 'limit', 'skip'],
                                        theme: '#1890FF',
                                    },
                                    where: {
                                        preview: JSON.stringify(preview),
                                    },
                                    limit: 10,
                                    cols: dynamicCols,
                                    done: function (res, curr, count) {
                                        table.resize('data-table');
                                    },
                                });
                            }
                        }
                    },
                    error: function (e, state, error) {
                        helper.closeLoad(layerIndex_waiting);
                        layer.msg("查询数据失败！");
                        console.log(e);
                    },
                });
            }
        });
        /**
         * 点击完成，提交删除任务
         */
        $(document).on('click', '.eis-over-btn', function () {
            $.ajax({
                type: 'POST',
                url: '/data-insert/createDeleteTask',
                data: {
                    task: JSON.stringify(deleteTask)
                },
                success: function (obj) {
                    if (obj.data) {
                        layer.msg("提交任务成功！");
                    } else {
                        layer.msg("提交任务失败！");
                    }
                },
                error: function (e, state, error) {
                    layer.msg("提交任务失败！");
                    console.log(e);
                },
            })
        });
    };

    /**
     * 绑定查询字段
     */
    function bindSelectforField(elem, tableid) {
        let $elem = $(elem);
        let layerIndex_waiting;
        dynamicCols = [];
        let cols = [];
        $.ajax({
            type: 'GET',
            url: '/metainfo/field?id=' + tableid,
            beforeSend: function () {
                layerIndex_waiting = helper.showLoad("正在获取字段信息...");
            },
            success: function (obj) {
                helper.closeLoad(layerIndex_waiting);
                let data = obj.data;
                let option = "<option></option>";
                if (data.length != 0) {
                    for (let i = 0; i < data.length; i++) {
                        if (data[i].columnName != 'the_geom' && data[i].columnName != 'geom') {
                            let info = {field: data[i].columnName, title: data[i].columnName, align: 'center'};
                            cols.push(info);
                            option += "<option value=\"" + data[i].columnName + "\">" + data[i].columnName + "</option>";
                        }
                    }
                    dynamicCols.push(cols);
                    $elem.html(option);
                    form.render('select');
                }
            },
            error: function (e, state, error) {
                helper.closeLoad(layerIndex_waiting);
                layer.msg("获取字段信息失败!");
            },
        });
    }
});