// 通用方法封装

var helper = helper || {};
/**
 * 绑定select框数据
 */
helper.bindSelect = function (elem, data, filter) {
    var $target = $(elem);
    var formData;
    var renderData;
    if (!(data instanceof Array)) {
        $.ajax({
            url: data,
            async: false,
            success: function (result) {
                formData = result;
            },
            error: function (e, state, error) {
                console.log(e);
            },
        });
    } else {
        formData = data;
    }
    if (filter) {
        renderData = filter(formData);
    }
    if (!renderData) {
        return;
    }
    var option = "";
    for (var i = 0; i < renderData.length; i++) {
        option += "<option value=" + renderData[i].id + ">" + renderData[i].name + "</option>";
    }
    $target.html(option);
    for (var i = 0; i < formData.length; i++) {
        var id = formData[i].id;
        $("#" + id).data(formData[i]);
    }
};

/**
 * layui默认选中
 * @param elem
 * @param value
 * @param form
 */
helper.selectValue = function (elem, value, form) {
    $(elem).find("option[value='" + value + "']").prop("selected", true);
    form.render();
};

/**
 * 绑定数据字典表
 */
helper.bindDict = function (elem, keyName) {
    var url = rootPath + "/common/get-dict?key=" + keyName;
    this.bindSelect(elem, url, function (data) {
        var dt = data["data"];
        if (!dt || (!dt["children"] || (dt["children"].length == 0))) {
            layer.msg("key值无效");
            return;
        }
        dt = data["data"]["children"];
        for (var i = 0; i < dt.length; i++) {
            var dict = dt[i];
            dict["name"] = dict["title"];
            dict["id"] = dict["value"];
        }
        return dt;
    });

};

/**
 * 授权
 * @param moduleName 模块名称,目前已有模块名称：“服务管理资源”、“仓储管理资源”
 * @param moduleCode 模块代码，目前已有模块代码：fwglzy,ccglzy
 * @param code 授权资源，即数据，例如服务id，表id等
 * @param user 授权对象，即用户名，不填默认当前用户
 * @param msg 返回成功时弹出框的提示语句
 */
helper.saveAuthority = function (moduleName, moduleCode, code, user, msg) {
    if (!user) {
        user = 'self';
    }
    $.ajax({
        type: 'POST',
        url: '/authority/save',
        data: {
            "users": user,
            "moduleCode": moduleCode,
            "moduleName": moduleName,
            "code": code,
        },
        success: function (data) {
            if (msg) {
                layer.msg(msg);
            }
        },
        error: function (e, state, errorThrown) {
            console.log(e);
        }
    });
};

/**
 * 弹出等待框
 * @param msg 等待框显示信息
 * @returns {*} 等待框索引,用于关闭
 */
helper.showLoad = function (msg) {
    return layer.msg(msg, {icon: 16, shade: [0.5, '#f5f5f5'], scrollbar: false, offset: 'auto', time: 100000});
};
/**
 * 关闭弹出层
 * @param index 弹出层索引
 */
helper.closeLoad = function closeLoad(index) {
    layer.close(index);
};

helper.showState = function (msg) {
    var dic = {};
    dic["pending"] = "等待中";
    dic["starting"] = "准备中";
    dic["running"] = "正在执行";
    dic["stopped"] = "已停止";
    dic["error"] = "发生错误";
    dic["timed out"] = "超时";
    dic["finished"] = "执行结束";
    dic["waitting"] = "等待中";
    dic["success"] = "执行成功";
    dic["fail"] = "执行失败";
    dic["opened"] = "已开启";
    dic["closed"] = "已关闭";
    return dic[msg.toLowerCase()];
};

/**
 * 时间戳转成yyyy-MM-dd hh:mm:ss格式
 * @param timestamp
 */
helper.transformTimestamp = function (timestamp) {
    let date = new Date(timestamp);
    let Y = date.getFullYear() + '-';
    let M = (date.getMonth() + 1 < 10 ? '0' + (date.getMonth() + 1) : date.getMonth() + 1) + '-';
    let D = date.getDate() + ' ';
    let h = date.getHours() + ':';
    let m = date.getMinutes() + ':';
    let s = date.getSeconds();
    return Y + M + D + h + m + s;
}



