layui.use(["table", "layer", "form", "upload", "laytpl", "util"], function () {
    // 启用模块
    var $ = layui.jquery,
        table = layui.table,
        layer = layui.layer,
        form = layui.form,
        upload = layui.upload,
        laytpl = layui.laytpl,
        util = layui.util,
        formSelects = layui.formSelects;
    var timingWideget ;

        // 弹窗标识
    var addModelLayer,
        editModelLayer,
        paramInfoLayer;

    var params;

    formSelects.render('keywords');

    // 渲染数据表格
    var  dataTable = table.render({
        elem: "#data-table",
        title: "作业信息表",
        url: rootPath + "/rest/job/list",
        skin: 'line',
        even: true,
        id: 'data-table',
        height: "full-300",
        page: {
            layout: ['prev', 'page', 'next', 'limit', 'skip'],
            theme: '#1890FF',
        },
        request: {
            pageName: "page",
            limitName: "size"
        },
        cols: [
            [
                {
                    type: 'checkbox'
                },
                {
                    title: 'ID',
                    field: 'id_job',
                    hide: true
                },
                {
                    title: "名称",
                    field: "name",
                    minWidth: 100,
                    edit:"text"
                },
                {
                    title: "创建人",
                    field: "createBy",
                    minWidth: 100,
                    template:function (data) {
                        return "Admin";
                    }
                },
                {
                    title: "描述",
                    field: "description",
                    minWidth: 150,
                    edit:"text"
                },
                {
                    title: "创建时间",
                    field: "created_date",
                    minWidth: 180
                },
                {
                    title: "运行状态",
                    field: "RUN_STATUS",
                },
                {
                    title: "操作",
                    field: 'tool',
                    align: 'center',
                    toolbar: "#bar",
                    minWidth: 250
                }
            ]
        ],
        parseData: function (res) {
            return {
                msg: res.msg,
                code: res.code,
                count: res.count,
                data: res.data
            };
        }
    });




    // // 点击新增打开弹窗
    // $(document).on("click", "#addbtn", function () {
    //     editModelLayer = null;
    //     modelTypeChange();
    //     $('#modelType').attr("disabled", false);
    //     addModelLayer = layer.open({
    //         type: 1,
    //         title: "新增模型",
    //         shadeClose: true,
    //         area: ["800px", "400px"],
    //         maxHeight: 400,
    //         maxWidth: 1000,
    //         content: $("#addform"),
    //         success: function () {
    //             params = [];
    //             tableparam.reload({
    //                 cellMinWidth: 80,
    //                 data: params,
    //                 done: function () {
    //                     tableparam.resize();
    //                 }
    //             });
    //             $("#resetbtn").click();
    //         }
    //     });
    // });
    // // 删除选中项
    // $(document).on('click', '#deletebtn', function () {
    //     let checkStatus = table.checkStatus('data-table');
    //     let data = checkStatus.data;
    //     if (data.length > 0) {
    //         layer.confirm('确认删除选中项？', function (index) {
    //             for (let i = 0; i < data.length; i++) {
    //                 if (data[i].modelType === "BPM") {
    //                     $.ajax({
    //                         type: "DELETE",
    //                         url: rootPath + "/rest/process-models/delete/" + data[i].processId,
    //                         success: function () {
    //                             $.ajax({
    //                                 type: "DELETE",
    //                                 url: rootPath + "/rest/dmm/model/" + data[i].id,
    //                                 success: function () {
    //                                     tablelns.reload();
    //                                 },
    //                                 error: function (err) {
    //                                     console.log(err);
    //                                 }
    //                             });
    //                         },
    //                         error: function (err) {
    //                             console.log(err);
    //                         }
    //                     });
    //                 } else {
    //                     $.ajax({
    //                         type: "DELETE",
    //                         url: rootPath + "/rest/dmm/model/" + data[i].id,
    //                         success: function () {
    //                             tablelns.reload();
    //                         },
    //                         error: function (err) {
    //                             console.log(err);
    //                         }
    //                     });
    //                 }
    //             }
    //             layer.close(index);
    //         });
    //     } else {
    //         layer.msg('请选择需要删除的数据！');
    //     }
    // });
    //
    // //导出所选数据
    // $(document).on('click', '#importbtn', function () {
    //     let checkStatus = table.checkStatus('data-table');
    //     let data = checkStatus.data;
    //     if (data.length > 0) {
    //         layer.confirm('确认导出选中项？', function (index) {
    //             table.exportFile(tablelns.config.id, data, 'xls');
    //             layer.close(index);
    //         });
    //     } else {
    //         layer.msg('请选择需要导出的数据！');
    //     }
    // });
    //
    // // 搜索
    // $(document).on('click', "#searchbtn", function () {
    //     tablelns.reload({
    //         page: {
    //             curr: 1
    //         }
    //         , where: {
    //             keywords: $('#search-text').val()
    //         }
    //     })
    // });
    //
    // // 新建或修改任务提交
    // form.on("submit(submit)", function (data) {
    //     // 新增
    //     if (addModelLayer) {
    //         let new_task = data.field;
    //         new_task.createTime = util.toDateString(new Date(), "yyyy-MM-dd HH:mm:ss");
    //         new_task.createById = userId;
    //         new_task.keywordsIndex = formSelects.value('keywords', 'valStr');
    //         new_task.keywords = formSelects.value('keywords', 'nameStr');
    //         new_task.paramJson = JSON.stringify(params);
    //         if (new_task.modelType1 === "1") {
    //             new_task.modelType = "BPM";
    //             let new_process = {};
    //             new_process.id = "";
    //             new_process.name = new_task.name;
    //             new_process.description = new_task.description;
    //             new_process.modelCategoryKey = new_task.modelType;
    //             new_process.modelCategoryName = new_task.modelType;
    //             new_process.modelStatusKey = "activity";
    //             new_process.modelStatusName = "编辑";
    //             new_process.modelKey = randomNum(16);
    //
    //             $.ajax({
    //                 type: "POST",
    //                 url: rootPath + "/rest/process-models/add?userId=" + new_task.createById,
    //                 contentType: "application/json",
    //                 data: JSON.stringify(new_process),
    //                 dataType: "json",
    //                 success: function (data) {
    //                     new_task.processKey = new_process.modelKey;
    //                     new_task.processId = data.id;
    //                     $.ajax({
    //                         type: "POST",
    //                         url: rootPath + "/rest/dmm/model",
    //                         contentType: "application/json",
    //                         data: JSON.stringify(new_task),
    //                         dataType: "json",
    //                         success: function () {
    //                             tablelns.reload({
    //                                 page: {
    //                                     curr: 1
    //                                 }
    //                             });
    //                             layer.close(addModelLayer);
    //                             addModelLayer = null;
    //                             layer.msg("创建成功");
    //                         },
    //                         error: function (err) {
    //                             layer.close(addModelLayer);
    //                             addModelLayer = null;
    //                             layer.msg("创建失败");
    //                             console.log(err);
    //                         }
    //                     });
    //                 }, error: function (err) {
    //                     layer.close(addModelLayer);
    //                     addModelLayer = null;
    //                     layer.msg("创建失败");
    //                     console.log(err);
    //                 }
    //             });
    //         } else if (new_task.modelType1 === "2") {
    //             new_task.modelType = "Rapid Miner";
    //             $.ajax({
    //                 type: "POST",
    //                 url: rootPath + "/rest/dmm/model",
    //                 contentType: "application/json",
    //                 data: JSON.stringify(new_task),
    //                 dataType: "json",
    //                 success: function () {
    //                     tablelns.reload({
    //                         page: {
    //                             curr: 1
    //                         }
    //                     });
    //                     layer.close(addModelLayer);
    //                     addModelLayer = null;
    //                     layer.msg("创建成功");
    //                 },
    //                 error: function (err) {
    //                     layer.close(addModelLayer);
    //                     addModelLayer = null;
    //                     layer.msg("创建失败");
    //                     console.log(err);
    //                 }
    //             });
    //         }
    //     }
    //     //修改
    //     if (editModelLayer) {
    //         let edit_task = data.field;
    //         edit_task.keywordsIndex = formSelects.value('keywords', 'valStr');
    //         edit_task.keywords = formSelects.value('keywords', 'nameStr');
    //         edit_task.paramJson = JSON.stringify(params);
    //         if (edit_task.modelType1 === "1") {
    //             edit_task.modelType = "BPM";
    //             let edit_process = {};
    //             edit_process.description = edit_task.description;
    //             edit_process.id = edit_task.processId;
    //             edit_process.modelCategoryKey = edit_task.modelType;
    //             edit_process.modelCategoryName = edit_task.modelType;
    //             edit_process.modelKey = edit_task.processKey;
    //             edit_process.modelStatusKey = "activity";
    //             edit_process.modelStatusName = "编辑";
    //             edit_process.name = edit_task.name;
    //
    //             $.ajax({
    //                 type: "PATCH",
    //                 url: rootPath + "/rest/process-models/update/1",
    //                 contentType: "application/json",
    //                 data: JSON.stringify(edit_process),
    //                 dataType: "json",
    //                 success: function (data) {
    //                     $.ajax({
    //                         type: "POST",
    //                         url: rootPath + "/rest/dmm/model",
    //                         contentType: "application/json",
    //                         data: JSON.stringify(edit_task),
    //                         dataType: "json",
    //                         success: function () {
    //                             tablelns.reload();
    //                             layer.close(editModelLayer);
    //                             editModelLayer = null;
    //                             layer.msg("修改成功");
    //                         },
    //                         error: function (err) {
    //                             layer.close(editModelLayer);
    //                             editModelLayer = null;
    //                             layer.msg("修改失败");
    //                             console.log(err);
    //                         }
    //                     });
    //                 },
    //                 error: function (err) {
    //                     layer.close(editModelLayer);
    //                     editModelLayer = null;
    //                     layer.msg("修改失败");
    //                     console.log(err);
    //                 }
    //             });
    //         } else if (edit_task.modelType1 === "2") {
    //             edit_task.modelType = "Rapid Miner";
    //             $.ajax({
    //                 type: "POST",
    //                 url: rootPath + "/rest/dmm/model",
    //                 contentType: "application/json",
    //                 data: JSON.stringify(edit_task),
    //                 dataType: "json",
    //                 success: function () {
    //                     tablelns.reload();
    //                     layer.close(editModelLayer);
    //                     editModelLayer = null;
    //                     layer.msg("修改成功");
    //                 },
    //                 error: function (err) {
    //                     layer.close(editModelLayer);
    //                     editModelLayer = null;
    //                     layer.msg("修改失败");
    //                     console.log(err);
    //                 }
    //             });
    //         }
    //     }
    //     return false;
    // });

    table.on("edit(data-table)",function (obj) {
        var data={};
        data[obj["field"]] =obj["value"];
        $.ajax({
            url:rootPath + "/rest/job/timing/edit",
            data:data,
            success:function (data) {
                layer.msg("保存成功");
            }
        });
    })

    // 监听行工具栏事件
    table.on("tool(data-table)", function (obj) {
        var id =obj.data.id_job;
        switch (obj.event) {
            // 编辑模型
            case 'edit':
                break;
            // 删除模型
            case 'del':
                layer.confirm(
                    "确定要删除吗？",
                    {
                        btn: ["确定", "取消"]
                    },
                    function (index) {

                    }
                );
                break;
            case 'run':

                var data={
                    a:1,
                    b:2,
                    c:3,
                    d:4,
                    f:5
                }
                $.ajax({
                    type: 'POST',
                    url:rootPath + "/rest/job/timing/set?id="+id,
                    data:{
                        data:JSON.stringify(data)
                    },
                    success:function (data) {
                        
                    },
                    error:function (e1,e2) {
                    }
                });
                if( $(this).hasClass("start")){
                    $(this).removeClass("start")
                    $(this).text("停止");
                    $.ajax({
                        url: rootPath + "/rest/job/start?id="+id,
                        success:function (data) {
                            if(data["data"]){
                                layer.msg("启动成功");
                            }
                        }
                    });
                }else {
                    $(this).addClass("start")
                    $(this).text("开始");
                    $.ajax({
                        url: rootPath + "/rest/job/stop?id="+id,
                        success:function (data) {
                            if(data["data"]){
                                layer.msg("停止成功");
                            }
                        }
                    });

                }
                break;
            case 'timing':
                $.ajax({
                    url: rootPath + "/rest/job/timing/get?id="+id,
                    success:function (data) {
                        openTimingWidget(data.data,id);
                    }
                });
                break;
            case "edit":
                break;
            default:
                break;
        }
    });

    //监听参数表头工具栏事件
    table.on("toolbar(param-table)", function (obj) {
        // console.log(obj);
        switch (obj.event) {
            case 'paramadd':
                $("#tool-param-info")[0].reset();
                $('#paramName').attr("disabled", false);
                paramInfoLayer = layer.open({
                    title: "新增参数",
                    content: $('#param-info'),
                    shadeClose: true,
                    type: 1,
                    area: ['700px'],
                    maxHeight: 500,
                    skin: 'to-fix-select',
                    maxWidth: 700
                });
                break;
            default:
                break;
        }
    });

    /**
     * 辅助功能
     */







    /**
     * 定时任务组件
     */
    function openTimingWidget(data,id) {
        timingWideget = layer.open({
            type: 1,
            title: "任务定时",
            shadeClose: true,
            area: ["400px", "400px"],
            maxHeight: 400,
            maxWidth: 1000,
            content: $("#timingForm").html(),
            success: function () {
                //js 渲染页面
                layer.close(timingWideget);
            }
        });
        form.val('timingForm',data);
        //js渲染form
        function bindEvent() {
            /**
             *
             */
            form.on('select(scheduler_type)', function(data){
                process(data.value);
            });
            process(data.scheduler_type.toString());
            function process(val) {
                var interval_seconds = "interval_seconds";
                var interval_minutes="interval_minutes";
                var week_day="week_day";
                var day_of_month= "day_of_month";
                var day ="day";
                var is_repeat="is_repeat";
                switch (val){
                    case "0":
                        disableControl([interval_seconds,interval_minutes,week_day,day_of_month,day,is_repeat]);
                        break;
                    case "1":
                        disableControl([week_day,day_of_month,day]);
                        break;
                    case "2":
                        disableControl([interval_seconds,interval_minutes,week_day,day_of_month]);
                        break;
                    case "3":
                        disableControl([interval_seconds,interval_minutes,day_of_month]);
                        break;
                    case "4":
                        disableControl([interval_seconds,interval_minutes,week_day]);
                        break;
                }
                function disableControl(arr) {
                    var all=[interval_seconds,interval_minutes,week_day,day_of_month,day,is_repeat];
                    for(var i=0;i<all.length;i++){
                        $("."+all[i]).show();
                    }
                    for(var i=0;i<arr.length;i++){
                        $("."+arr[i]).hide();
                    }
                }
            }

            form.on("submit(job-submit)", function (data) {
                $.ajax({
                    type:"POST",
                    url:rootPath + "/rest/job/timing/set?id="+id,
                    contentType:'application/json;charset=utf-8',
                    data:JSON.stringify(data.field),
                    success:function (result) {
                        alert(result);
                    }
                });
                return null;
            });
        }
        bindEvent();
    }
    
    function f() {
        
    }
});
