layui.use(["table", "layer", "form", "upload", "laytpl", "util"], function () {
    // 启用模块
    var $ = layui.jquery,
        table = layui.table,
        layer = layui.layer,
        form = layui.form,
        upload = layui.upload,
        laytpl = layui.laytpl,
        util = layui.util,
        formSelects = layui.formSelects;
    var timingWideget ;

        // 弹窗标识
    var addModelLayer,
        editModelLayer,
        paramInfoLayer;

    var params;

    formSelects.render('keywords');


    var height = $(".right-content").outerHeight() - $(".item-top").outerHeight();
    // 渲染数据表格
    var  dataTable = table.render({
        elem: "#data-table",
        title: "作业信息表",
        url: rootPath + "/rest/job/list",
        skin: 'line',
        even: true,
        id: 'data-table',
        height: height,
        page: {
            layout: ['prev', 'page', 'next', 'limit', 'skip'],
            theme: '#1890FF',
        },
        request: {
            pageName: "page",
            limitName: "size"
        },
        cols: [
            [
                {
                    type: 'checkbox'
                },
                {
                    title: 'ID',
                    field: 'id_job',
                    hide: true
                },
                {
                    title: "名称",
                    field: "name",
                    minWidth: 200,
                },
                {
                    title: "描述",
                    field: "description",
                    minWidth: 150,
                },
                {
                    title: "创建人",
                    field: "createBy",
                    minWidth: 100,
                    templet:function (data) {
                        return "Admin";
                    }
                },

                {
                    title: "创建时间",
                    field: "created_date",
                    minWidth: 200
                },
                {
                    title: "运行状态",
                    field: "running_status",
                },
                {
                    title: "操作",
                    field: 'tool',
                    align: 'center',
                    toolbar: "#bar",
                    minWidth: 250
                }
            ]
        ],
        parseData: function (res) {
            return {
                msg: res.msg,
                code: res.code,
                count: res.count,
                data: res.data
            };
        }
    });

    table.on("edit(data-table)",function (obj) {
        var data={};
        // data[obj["field"]] =obj["value"];
        // $.ajax({
        //     url:rootPath + "/rest/job/timing/edit",
        //     data:data,
        //     success:function (data) {
        //         layer.msg("保存成功");
        //     }
        // });
    })

    // 监听行工具栏事件
    table.on("tool(data-table)", function (obj) {
        var id =obj.data.id_job;
        var data_instance_id =obj.data.data_instance_id;
        switch (obj.event) {
            // 编辑模型
            case 'edit':
                break;
            // 删除模型
            case 'del':
                layer.confirm(
                    "确定要删除吗？",
                    {
                        btn: ["确定", "取消"]
                    },
                    function (index) {

                    }
                );
                break;
            case 'run':
                var $that = $(this);
                if( $that.hasClass("start")){
                    $.ajax({
                        url: rootPath + "/rest/job/start?id="+id,
                        success:function (data) {
                            if(data["data"]){
                                layer.msg("启动成功");
                                reload();
                                $that.removeClass("start")
                                var icon= $that.find(".iconfont");
                                icon.removeClass("icon-begin");
                                icon.addClass("icon-stop");
                                $that.attr("title","停止");
                            }
                        }
                    });
                }else {
                    $.ajax({
                        url: rootPath + "/rest/job/stop?id="+id,
                        success:function (data) {
                            if(data["data"]){
                                $that.addClass("start")
                                var icon= $that.find(".iconfont");
                                icon.addClass("icon-begin");
                                icon.removeClass("icon-stop");
                                $that.attr("title","执行");
                                layer.msg("停止成功");
                                reload();
                            }
                        }
                    });

                }
                break;
            case 'timing':
                $.ajax({
                    url: rootPath + "/rest/job/timing/get?id="+id,
                    success:function (data) {
                        openTimingWidget(data.data,id);
                    }
                });
                break;
            case "edit":
                break;
            case "log":
                window.location.href = rootPath + "/view/dgk/job-log?jobId="+id;
                break;
            case "detail":
                if(!data_instance_id){
                    layer.msg("暂无数据");
                    return;
                }
                window.location.href = rootPath + "/dw/metadata?ownState=private&breadType=dgk_metadata&breadTitle=查看抓取数据&id="+data_instance_id;
                break;
            default:
                break;
        }
    });

    function reload() {
        table.reload('data-table', {
            page: {
                curr: 0,
            },
        }, 'data');
    }

    function bindEvent() {
        $("#addbtn").click(function (evt) {
            layer.msg("请于桌面端使用作业编辑工具操作");
        })
        $("#deletebtn").click(function (evt) {
            layer.msg("请于桌面端使用作业编辑工具操作");
        });
    }

    bindEvent();

    /**
     * 定时任务组件
     */
    function openTimingWidget(data,id) {
        timingWideget = layer.open({
            type: 1,
            title: "任务定时",
            shadeClose: true,
            area: ["400px", "330px"],
            maxHeight: 300,
            maxWidth: 1000,
            content: $("#timingForm").html(),
            success: function () {
                //js 渲染页面
                layer.close(timingWideget);
            }
        });
        form.val('timingForm',data);
        //js渲染form
        function bindEvent() {
            /**
             *
             */
            form.on('select(scheduler_type)', function(data){
                process(data.value);
            });
            process(data.scheduler_type.toString());
            function process(val) {
                var interval_seconds = "interval_seconds";
                var interval_minutes="interval_minutes";
                var week_day="week_day";
                var day_of_month= "day_of_month";
                var day ="day";
                var is_repeat="is_repeat";
                switch (val){
                    case "0":
                        disableControl([interval_seconds,interval_minutes,week_day,day_of_month,day,is_repeat]);
                        break;
                    case "1":
                        disableControl([week_day,day_of_month,day]);
                        break;
                    case "2":
                        disableControl([interval_seconds,interval_minutes,week_day,day_of_month]);
                        break;
                    case "3":
                        disableControl([interval_seconds,interval_minutes,day_of_month]);
                        break;
                    case "4":
                        disableControl([interval_seconds,interval_minutes,week_day]);
                        break;
                }
                function disableControl(arr) {
                    var all=[interval_seconds,interval_minutes,week_day,day_of_month,day,is_repeat];
                    for(var i=0;i<all.length;i++){
                        $("."+all[i]).show();
                    }
                    for(var i=0;i<arr.length;i++){
                        $("."+arr[i]).hide();
                    }
                }
            }

            form.on("submit(job-submit)", function (data) {
                $.ajax({
                    type:"POST",
                    url:rootPath + "/rest/job/timing/set?id="+id,
                    contentType:'application/json;charset=utf-8',
                    data:JSON.stringify(data.field),
                    success:function (result) {
                        alert(result);
                    }
                });
                return null;
            });
        }
        bindEvent();
    }
});
