layui.use(["table", "layer", "form",  "laytpl", "util"], function () {
    // 启用模块
    var $ = layui.jquery,
        table = layui.table,
        layer = layui.layer,
        form = layui.form,
        laytpl = layui.laytpl;
    // 渲染数据表格
    var height = $(".right-content").outerHeight();
    var  dataTable = table.render({
        elem: "#data-table",
        title: "作业执行信息",
        url: rootPath + "/rest/job/log/his?id="+jobId,
        skin: 'line',
        even: true,
        id: 'data-table',
        height: height,
        page: {
            layout: ['prev', 'page', 'next', 'limit', 'skip'],
            theme: '#1890FF',
        },
        request: {
            pageName: "page",
            limitName: "size"
        },
        cols: [
            [
                {
                    title: 'ID',
                    field: 'oid',
                    hide: true
                },
                {
                    title: "任务名称",
                    field: "job_name",
                    minWidth: 200,
                    edit:"text"
                },
                {
                    title: '执行时间',
                    field: 'start_date',
                    templet:function (data) {
                        var dateType = "";
                        var date = new Date();
                        date.setTime(data.start_date);
                        dateType += date.getFullYear();   //年
                        dateType += "-" + (date.getMonth() + 1); //月
                        dateType += "-" + date.getDate();   //日
                        dateType+=" "+date.getHours()+":"+date.getMinutes();
                        return dateType;
                    }
                },
                {
                    title: "运行结果",
                    field: "status",
                    templet:function (data) {
                        return "成功";
                    }
                },
                {
                    title: "操作",
                    field: 'tool',
                    align: 'center',
                    toolbar: "#bar",
                    minWidth: 250
                }
            ]
        ],
        parseData: function (res) {
            var page = res.data;
            return {
                msg: res.msg,
                code: res.code,
                count: page.totalElements,
                data: page.content
            };
        }
    });

    // 监听行工具栏事件
    table.on("tool(data-table)", function (obj) {
        var id =obj.data.id_job;
        switch (obj.event) {
            case "detail":
                openLayer(obj.data.url);
                break;
            default:
                break;
        }
    });

    /**
     * 打开日志窗口
     * @param id
     */
    function openLayer(url) {
        var index = layer.open({
            type: 2,
            content: url,
            area: ['1600px', '900px'],
            // maxmin: true
        });
        layer.full(index);
    }
});
