layui.use(['element', 'jquery', 'carousel'], function () {
    var element = layui.element,
        $ = layui.$,
        carousel = layui.carousel;

    initElem();
    bindEvent();

    function initElem() {
        caseRender();

        function caseRender() {
            var cases = [{
                name: "房地一体化全生命周期管理应用示范",
                img: "/images/index/yantai/peitu1.png",
                href: "/map/app/fdyth"
            }, {
                name: "国土空间规划与产业布局大数据研究",
                img: "/images/index/yantai/peitu2.png",
                href: ""
            }, {
                name: "牟平区社会综合治理应用示范",
                img: "/images/index/yantai/peitu3.png",
                href: ""
            }, {
                name: "海洋与渔业“一张图”应用示范",
                img: "/images/index/yantai/peitu4.png",
                href: ""
            }, {
                name: "海岸带开发利用动态监测",
                img: "/images/index/yantai/peitu5.png",
                href: "/map/app/hax"
            }];

            var i = 0;
            do {
                var content = '<div class="item layui-col-space15">';
                for (var j = i; j < i + 3; j++) {
                    var tmp = j;
                    if (tmp >= cases.length) tmp -= cases.length;
                    content += '<div class="layui-col-md4"><div class="case-item" href="' + cases[tmp].href + '">' +
                        '<img src="' + cases[tmp].img + '"/><p>' + cases[tmp].name + '</p></div></div>';
                }
                content += "</div>";
                $("#carousel1 > div[carousel-item]").append(content);
                i += 3;
                if (i >= cases.length) i -= cases.length;
            } while (i !== 0);

            //轮播图
            carousel.render({
                elem: '#carousel1',
                width: '100%', //设置容器宽度
                height: '265px',
                arrow: 'always', //始终显示箭头
                indicator: 'none',//不显示指示器
                autoplay: false,//自动播放
                interval: 3000 //自动切换的时间间隔
            });
        }
    }

    function bindEvent() {
        //平台功能切换事件
        $('.ptgn .nav li').click(function () {
            $(this).addClass('active').siblings().removeClass('active');
            var id = $(this).index();
            $('.ptgn .content .content-item').eq(id).addClass('active').siblings().removeClass('active');
        });

        //监听导航点击
        element.on('nav(ulhead)', function (elem) {
        });

        $("#loginout").click(function (obj) {
            var curHref = window.location.href;
            location.href = loginoutUrl + curHref;
        });

        $(document).on('click', '.content-item li', function () {
            if ($(this).attr("href") && $(this).attr("href") !== "") {
                location.href = $(this).attr("href");
            }
        });

        $(document).on('click', '.case .case-item', function () {
            if ($(this).attr("href") && $(this).attr("href") !== "") {
                location.href = $(this).attr("href");
            }
        });
    }
});