layui.use(['jquery', 'util', 'layer'], function () {
    var $ = layui.jquery,
        util = layui.util,
        layer = layui.layer;

    var scrollNum = 0, // 监测下拉辅助变量
        thisYear = parseInt(util.toDateString(new Date(), 'yyyy')),
        year = thisYear;

    // 图表配置声明
    var threedOption, threedChart, threedData;

    var cities = ['南京', '无锡', '徐州', '常州', '苏州', '南通', '连云港',
        '淮安', '盐城', '扬州', '镇江', '泰州', '宿迁'];

    // 小工具
    var tools = (function () {
        // 根据aqi值返回空气质量文本
        function getAqidjByAqi(aqi) {
            if (aqi >= 0 && aqi <= 50) return '优';
            if (aqi > 50 && aqi <= 100) return '良';
            if (aqi > 100 && aqi <= 150) return '轻微污染';
            if (aqi > 150 && aqi <= 200) return '轻度污染';
            if (aqi > 200 && aqi <= 300) return '中度污染';
            if (aqi > 300) return '重度污染';
            return '';
        }

        // 根据自定的datenum返回当前小时数字
        function getHourByDatenum(datenum) {
            return datenum - Math.floor(datenum / 100) * 100;
        }

        // 查询图数据库
        function search_query(ini_gremlin_query) {
            graphioGremlin.search_query(ini_gremlin_query, true);
        }

        function reloadYearTime3DEcharts(year) {
            var yearInstanceid = threedinstanceid["t" + year];
            threedChart.showLoading();
            $.getJSON(rootPath + '/rest/es/search/all/page?instanceId=' + yearInstanceid + '&pageSize=5000').done(function (res) {
                threedChart.hideLoading();
                threedData = res.data;
                var stat = [];
                var maxValue = 0;
                var level = {};

                var data = threedData.features.map(function (dataItem) {
                    var value = parseInt(dataItem.properties.HYDA) + parseInt(dataItem.properties.LRDL)
                        + parseInt(dataItem.properties.RESA) + parseInt(dataItem.properties.TERL)
                        + parseInt(dataItem.properties.PIPL) + parseInt(dataItem.properties.VEGA);
                    stat.push(value);
                    if (value > maxValue) maxValue = value;
                    return [dataItem.geometry.coordinates[0], dataItem.geometry.coordinates[1], value];
                });

                stat.sort();
                if (stat.length > 0) {
                    level = {
                        "l0": stat[Math.floor(stat.length / 5)],
                        "l1": stat[Math.floor(stat.length * 2 / 5)],
                        "l2": stat[Math.floor(stat.length * 3 / 5)],
                        "l3": stat[Math.floor(stat.length * 4 / 5)],
                        "l4": maxValue
                    };
                }
                threedOption = {
                    // backgroundColor: '#cdcfd5',
                    geo3D: {
                        map: 'ningxia',
                        shading: 'color',
                        boxWidth: 120,
                        viewControl: {
                            distance: 180,
                            // zoomSensitivity: 0,
                            // panSensitivity: 0,
                            // rotateSensitivity: 0,
                            center: [0, -25, 0],
                            beta: -20,
                            alpha: 50,
                            panMouseButton: 'left',
                            rotateMouseButton: 'right'
                        },
                        groundPlane: {
                            show: false,
                            color: '#999'
                        },
                        postEffect: {
                            enable: true,
                            bloom: {
                                enable: false
                            },
                            SSAO: {
                                radius: 1,
                                intensity: 1,
                                enable: true
                            },
                            depthOfField: {
                                enable: false,
                                focalRange: 10,
                                blurRadius: 10,
                                fstop: 1
                            }
                        },
                        temporalSuperSampling: {
                            enable: true
                        },
                        itemStyle: {
                            // borderWidth: 0.8,
                            // opacity: 0.9
                        },
                        regionHeight: 3,
                        // boxHeight: 10,
                        instancing: true
                    },
                    visualMap: {
                        show: true,
                        type: 'piecewise',
                        pieces: [
                            {gt: level.l3, lte: level.l4, color: '#a50026'},
                            {gt: level.l2, lte: level.l3, color: 'orange'},
                            {gt: level.l1, lte: level.l2, color: '#f46d43'},
                            {gt: level.l0, lte: level.l1, color: '#4575b4'},
                            {gte: 0, lte: level.l0, color: '#313695'}
                        ],
                        textStyle: {
                            color: '#fff'
                        }
                    },
                    series: [{
                        type: 'bar3D',
                        coordinateSystem: 'geo3D',
                        shading: 'color',
                        data: data,
                        barSize: 0.4,
                        minHeight: 2,
                        silent: true,
                        itemStyle: {
                            color: 'orange'
                            // opacity: 0.8
                        },
                        label: {}
                    }]
                };
                if (threedOption && typeof threedOption === "object") {
                    threedChart.setOption(threedOption, true);
                }
            }).fail(function () {
                threedChart.hideLoading();
                layer.msg("加载失败。");
            });
        }

        // 重载3D图表
        function reloadChart(type) {
            var maxValue = 0;
            var data;
            var stat = [];
            var level = {};
            switch (type) {
                case 'HYDA':
                    data = threedData.features.map(function (dataItem) {
                        var value = parseInt(dataItem.properties.HYDA);
                        stat.push(value);
                        if (value > maxValue) maxValue = value;
                        return [dataItem.geometry.coordinates[0], dataItem.geometry.coordinates[1], value];
                    });
                    break;
                case 'LRDL':
                    data = threedData.features.map(function (dataItem) {
                        var value = parseInt(dataItem.properties.LRDL);
                        stat.push(value);
                        if (value > maxValue) maxValue = value;
                        return [dataItem.geometry.coordinates[0], dataItem.geometry.coordinates[1], value];
                    });
                    break;
                case 'RESA':
                    data = threedData.features.map(function (dataItem) {
                        var value = parseInt(dataItem.properties.RESA);
                        stat.push(value);
                        if (value > maxValue) maxValue = value;
                        return [dataItem.geometry.coordinates[0], dataItem.geometry.coordinates[1], value];
                    });
                    break;
                case 'TERL':
                    data = threedData.features.map(function (dataItem) {
                        var value = parseInt(dataItem.properties.TERL);
                        stat.push(value);
                        if (value > maxValue) maxValue = value;
                        return [dataItem.geometry.coordinates[0], dataItem.geometry.coordinates[1], value];
                    });
                    break;
                case 'PIPL':
                    data = threedData.features.map(function (dataItem) {
                        var value = parseInt(dataItem.properties.PIPL);
                        stat.push(value);
                        if (value > maxValue) maxValue = value;
                        return [dataItem.geometry.coordinates[0], dataItem.geometry.coordinates[1], value];
                    });
                    break;
                case 'VEGA':
                    data = threedData.features.map(function (dataItem) {
                        var value = parseInt(dataItem.properties.VEGA);
                        stat.push(value);
                        if (value > maxValue) maxValue = value;
                        return [dataItem.geometry.coordinates[0], dataItem.geometry.coordinates[1], value];
                    });
                    break;
                default:
                    return;
                    break;
            }
            stat.sort();
            if (stat.length > 0) {
                level = {
                    "l0": stat[Math.floor(stat.length / 5)],
                    "l1": stat[Math.floor(stat.length * 2 / 5)],
                    "l2": stat[Math.floor(stat.length * 3 / 5)],
                    "l3": stat[Math.floor(stat.length * 4 / 5)],
                    "l4": maxValue
                };
            }
            threedOption.visualMap.pieces = [
                {gt: level.l3, lte: level.l4, color: '#a50026'},
                {gt: level.l2, lte: level.l3, color: 'orange'},
                {gt: level.l1, lte: level.l2, color: '#f46d43'},
                {gt: level.l0, lte: level.l1, color: '#4575b4'},
                {gte: 0, lte: level.l0, color: '#313695'}
            ];
            threedOption.series[0].data = data;
            if (threedOption && typeof threedOption === "object") {
                threedChart.setOption(threedOption, true);
            }
        }

        function getHourListAsc(datenum) {
            var time = this.getHourByDatenum(datenum);
            var hourList = [];
            for (var i = 0; i < 24; i++) {
                var value = time + i + 1;
                if (value >= 24) value -= 24;
                hourList.push(value);
            }
            return hourList;
        }

        function getHourListDesc(datenum) {
            var time = this.getHourByDatenum(datenum);
            var hourList = [];
            for (var i = 0; i < 24; i++) {
                var value = time + i + 1;
                if (value >= 24) value -= 24;
                hourList.unshift(value);
            }
            return hourList;
        }

        function getHourListIndex(time, array) {
            for (var i = 0; i < 24; i++) {
                if (time === array[i]) return i;
            }
        }

        function getIndexOfCity(city) {
            for (var i = 0; i < 13; i++) {
                if (city === cities[i]) return i;
            }
            return null;
        }

        function getCityByIndex(i) {
            if (typeof i !== "number" | i !== parseInt(i)) return null;
            if (i < 0 || i >= 13) return null;
            return cities[i];
        }

        function convertData(data) {
            var res = [];
            for (var i = 0; i < data.length; i++) {
                res.push({
                    name: data[i][0] + '市',
                    value: data[i][1]
                })
            }
            return res;
        }

        function convertData1(data, geoCoordMap) {
            var res = [];
            for (var i = 0; i < data.length; i++) {
                var geoCoord = geoCoordMap[data[i][0]];
                if (geoCoord) {
                    res.push({
                        name: data[i][0] + '市',
                        value: geoCoord.concat(data[i][1])
                    });
                }
            }
            return res;
        }

        function compare(index) {
            return function (m, n) {
                var a = m[index];
                var b = n[index];
                return b - a;
            }
        }

        function getTime() {
            $('#date').html(util.toDateString(new Date(), 'yyyy-MM-dd'));
            $('#time').html(util.toDateString(new Date(), 'HH:mm:ss'));

            setTimeout(function () {
                tools.getTime();
            }, 500);
        }

        return {
            getAqidjByAqi: getAqidjByAqi
            , getHourByDatenum: getHourByDatenum
            , search_query: search_query
            , reloadChart: reloadChart
            , getHourListAsc: getHourListAsc
            , getHourListDesc: getHourListDesc
            , getHourListIndex: getHourListIndex
            , getIndexOfCity: getIndexOfCity
            , getCityByIndex: getCityByIndex
            , convertData: convertData
            , convertData1: convertData1
            , compare: compare
            , reloadYearTime3DEcharts: reloadYearTime3DEcharts
            , getTime: getTime
        }
    })();

    initElem();
    // 江苏3D
    init3DEcharts();
    bindEvent();

    function initElem() {
        $.getJSON('/yzy/query/latest?limit=1', function (res) {
            $('#total-resource').html(res.count);
        });
    }

    // 江苏3D
    function init3DEcharts() {
        // 初始化图表
        threedChart = echarts.init($('#3dChart')[0]);
        threedChart.showLoading();
        $.getJSON(rootPath + '/datas/ningxia.json').done(function (ningxia) {
            echarts.registerMap('ningxia', ningxia);
            $.getJSON(rootPath + '/rest/es/search/all/page?instanceId=' + threedinstanceid["t" + default_year] + '&pageSize=5000').done(function (res) {
                threedChart.hideLoading();
                threedData = res.data;
                var stat = [];
                var maxValue = 0;
                var level = {};

                var data = threedData.features.map(function (dataItem) {
                    var value = parseInt(dataItem.properties.HYDA) + parseInt(dataItem.properties.LRDL)
                        + parseInt(dataItem.properties.RESA) + parseInt(dataItem.properties.TERL)
                        + parseInt(dataItem.properties.PIPL) + parseInt(dataItem.properties.VEGA);
                    stat.push(value);
                    if (value > maxValue) maxValue = value;
                    return [dataItem.geometry.coordinates[0], dataItem.geometry.coordinates[1], value];
                });

                stat.sort();
                if (stat.length > 0) {
                    level = {
                        "l0": stat[Math.floor(stat.length / 5)],
                        "l1": stat[Math.floor(stat.length * 2 / 5)],
                        "l2": stat[Math.floor(stat.length * 3 / 5)],
                        "l3": stat[Math.floor(stat.length * 4 / 5)],
                        "l4": maxValue
                    };
                }
                threedOption = {
                    // backgroundColor: '#cdcfd5',
                    geo3D: {
                        map: 'ningxia',
                        shading: 'color',
                        boxWidth: 120,
                        viewControl: {
                            distance: 180,
                            // zoomSensitivity: 0,
                            // panSensitivity: 0,
                            // rotateSensitivity: 0,
                            center: [0, -25, 0],
                            beta: -20,
                            alpha: 50,
                            panMouseButton: 'left',
                            rotateMouseButton: 'right'
                        },
                        groundPlane: {
                            show: false,
                            color: '#999'
                        },
                        postEffect: {
                            enable: true,
                            bloom: {
                                enable: false
                            },
                            SSAO: {
                                radius: 1,
                                intensity: 1,
                                enable: true
                            },
                            depthOfField: {
                                enable: false,
                                focalRange: 10,
                                blurRadius: 10,
                                fstop: 1
                            }
                        },
                        temporalSuperSampling: {
                            enable: true
                        },
                        itemStyle: {
                            // borderWidth: 0.8,
                            // opacity: 0.9
                        },
                        regionHeight: 3,
                        // boxHeight: 10,
                        instancing: true
                    },
                    visualMap: {
                        show: true,
                        type: 'piecewise',
                        pieces: [
                            {gt: level.l3, lte: level.l4, color: '#a50026'},
                            {gt: level.l2, lte: level.l3, color: 'orange'},
                            {gt: level.l1, lte: level.l2, color: '#f46d43'},
                            {gt: level.l0, lte: level.l1, color: '#4575b4'},
                            {gte: 0, lte: level.l0, color: '#313695'}
                        ],
                        textStyle: {
                            color: '#fff'
                        }
                    },
                    series: [{
                        type: 'bar3D',
                        coordinateSystem: 'geo3D',
                        shading: 'color',
                        data: data,
                        barSize: 0.4,
                        minHeight: 2,
                        silent: true,
                        itemStyle: {
                            color: 'orange'
                            // opacity: 0.8
                        },
                        label: {}
                    }]
                };
                if (threedOption && typeof threedOption === "object") {
                    threedChart.setOption(threedOption, true);
                }
            }).fail(function () {
                threedChart.hideLoading();
                layer.msg("加载失败。");
            });
        });
    }

    // 绑定页面事件
    function bindEvent() {
        $(window).on('beforeunload', function () {
            $(window).scrollTop(0);
        });

        $(window).scroll(function () {
            var pos = $(window).scrollTop();
            scrollNum = scrollNum + 1;
            if (scrollNum < 2) {
                $(".title-bg1").slideUp(500);
                $('body,html').animate({scrollTop: 0}, 1000);
            }
            if (pos > 500) {
                $('.new-header-box').css("background-color", "#1f469e");
            } else {
                $('.new-header-box').css("background-color", "rgba(255,255,255,0)");
            }
            return false;
        });

        $(window).resize(function () {
            threedChart.resize();
        });

        $(document).ready(function () {
            tools.getTime();
            $('#left-botton-title').html(default_year + "年度资源概况");
            // $('#left-bottom-content-total-title').html(util.toDateString(new Date(), 'yyyy') + "年资源总数：");
            for (var i = 0; i < $('.year-time-year').length; i++) {
                $('.year-time-year:eq(' + i + ')').html(year - $('.year-time-year').length + i + 1);
            }
        });

        $(document).on('click', '.year-time-item', function () {
            var selected_year = $(this).find('.year-time-year:eq(0)').html();
            if (threedinstanceid["t" + selected_year]) {
                $('#left-botton-title').html(selected_year + "年度资源概况");
                $('#left-bottom-content-total-title').html(selected_year + "年资源总数：");
                tools.reloadYearTime3DEcharts(selected_year);
            } else {
                layer.msg("暂无数据.");
            }
        });

        $(document).on('click', '#year-plus', function () {
            if (year >= thisYear) return;
            year += 5;
            for (var i = 0; i < $('.year-time-year').length; i++) {
                $('.year-time-year:eq(' + i + ')').html(year - $('.year-time-year').length + i + 1);
            }
        });

        $(document).on('click', '#year-minus', function () {
            year -= 5;
            for (var i = 0; i < $('.year-time-year').length; i++) {
                $('.year-time-year:eq(' + i + ')').html(year - $('.year-time-year').length + i + 1);
            }
        });

        $(document).on('click', '.left-bottom-content-box', function () {
            if (threedOption) {
                var select_type = $(this).find('p').html();
                switch (select_type) {
                    case '水系':
                        tools.reloadChart("HYDA");
                        break;
                    case '交通':
                        tools.reloadChart("LRDL");
                        break;
                    case '居民地':
                        tools.reloadChart("RESA");
                        break;
                    case '等高线':
                        tools.reloadChart("TERL");
                        break;
                    case '管线':
                        tools.reloadChart("PIPL");
                        break;
                    case '植被':
                        tools.reloadChart("VEGA");
                        break;
                    default:
                        break;
                }
            }
        });

        $('.year-time-item').hover(function () {
            $(this).addClass('active');
        }, function () {
            $(this).removeClass('active');
        });
    }
});
