layui.use(['jquery', 'util', 'layer'], function () {
    var $ = layui.jquery,
        util = layui.util,
        layer = layui.layer;

    var scrollNum = 0, // 监测下拉辅助变量
        thisYear = parseInt(util.toDateString(new Date(), 'yyyy')),
        year = thisYear;

    // 图表配置声明
    var threedOption, threedChart, threedData,
        aqiOption, aqiChart, aqiData;

    var cities = ['南京', '无锡', '徐州', '常州', '苏州', '南通', '连云港',
        '淮安', '盐城', '扬州', '镇江', '泰州', '宿迁'];

    // 小工具
    var tools = (function () {
        // 根据aqi值返回空气质量文本
        function getAqidjByAqi(aqi) {
            if (aqi >= 0 && aqi <= 50) return '优';
            if (aqi > 50 && aqi <= 100) return '良';
            if (aqi > 100 && aqi <= 150) return '轻微污染';
            if (aqi > 150 && aqi <= 200) return '轻度污染';
            if (aqi > 200 && aqi <= 300) return '中度污染';
            if (aqi > 300) return '重度污染';
            return '';
        }

        // 根据自定的datenum返回当前小时数字
        function getHourByDatenum(datenum) {
            return datenum - Math.floor(datenum / 100) * 100;
        }

        // 查询图数据库
        function search_query(ini_gremlin_query) {
            graphioGremlin.search_query(ini_gremlin_query, true);
        }

        function reloadYearTime3DEcharts(year) {
            var yearInstanceid = threedinstanceid["t" + year];
            threedChart.showLoading();
            $.getJSON(rootPath + '/rest/es/search/all/page?instanceId=' + yearInstanceid + '&pageSize=5000').done(function (res) {
                threedChart.hideLoading();
                threedData = res.data;
                var stat = [];
                var maxValue = 0;
                var level = {};

                var data = threedData.features.map(function (dataItem) {
                    var value = parseInt(dataItem.properties.HYDA) + parseInt(dataItem.properties.LRDL)
                        + parseInt(dataItem.properties.RESA) + parseInt(dataItem.properties.TERL)
                        + parseInt(dataItem.properties.PIPL) + parseInt(dataItem.properties.VEGA);
                    stat.push(value);
                    if (value > maxValue) maxValue = value;
                    return [dataItem.geometry.coordinates[0], dataItem.geometry.coordinates[1], value];
                });

                stat.sort();
                if (stat.length > 0) {
                    level = {
                        "l0": stat[Math.floor(stat.length / 5)],
                        "l1": stat[Math.floor(stat.length * 2 / 5)],
                        "l2": stat[Math.floor(stat.length * 3 / 5)],
                        "l3": stat[Math.floor(stat.length * 4 / 5)],
                        "l4": maxValue
                    };
                }
                threedOption = {
                    // backgroundColor: '#cdcfd5',
                    geo3D: {
                        map: 'jiangsu',
                        shading: 'color',
                        boxWidth: 120,
                        viewControl: {
                            distance: 120,
                            // zoomSensitivity: 0,
                            // panSensitivity: 0,
                            // rotateSensitivity: 0,
                            center: [0, 0, 0],
                            beta: -20,
                            alpha: 50,
                            panMouseButton: 'left',
                            rotateMouseButton: 'right'
                        },
                        groundPlane: {
                            show: false,
                            color: '#999'
                        },
                        postEffect: {
                            enable: true,
                            bloom: {
                                enable: false
                            },
                            SSAO: {
                                radius: 1,
                                intensity: 1,
                                enable: true
                            },
                            depthOfField: {
                                enable: false,
                                focalRange: 10,
                                blurRadius: 10,
                                fstop: 1
                            }
                        },
                        temporalSuperSampling: {
                            enable: true
                        },
                        itemStyle: {
                            // borderWidth: 0.8,
                            // opacity: 0.9
                        },
                        regionHeight: 3,
                        // boxHeight: 10,
                        instancing: true
                    },
                    visualMap: {
                        show: false,
                        type: 'piecewise',
                        pieces: [
                            {gt: level.l3, lte: level.l4, color: '#a50026'},
                            {gt: level.l2, lte: level.l3, color: 'orange'},
                            {gt: level.l1, lte: level.l2, color: '#f46d43'},
                            {gt: level.l0, lte: level.l1, color: '#4575b4'},
                            {gte: 0, lte: level.l0, color: '#313695'}
                        ],
                        textStyle: {
                            color: '#fff'
                        }
                    },
                    series: [{
                        type: 'bar3D',
                        coordinateSystem: 'geo3D',
                        shading: 'color',
                        data: data,
                        barSize: 0.4,
                        minHeight: 2,
                        silent: true,
                        itemStyle: {
                            color: 'orange'
                            // opacity: 0.8
                        },
                        label: {}
                    }]
                };
                if (threedOption && typeof threedOption === "object") {
                    threedChart.setOption(threedOption, true);
                }
            }).fail(function () {
                threedChart.hideLoading();
                layer.msg("加载失败。");
            });
        }

        // 重载3D图表
        function reloadChart(type) {
            var maxValue = 0;
            var data;
            var stat = [];
            var level = {};
            switch (type) {
                case 'HYDA':
                    data = threedData.features.map(function (dataItem) {
                        var value = parseInt(dataItem.properties.HYDA);
                        stat.push(value);
                        if (value > maxValue) maxValue = value;
                        return [dataItem.geometry.coordinates[0], dataItem.geometry.coordinates[1], value];
                    });
                    break;
                case 'LRDL':
                    data = threedData.features.map(function (dataItem) {
                        var value = parseInt(dataItem.properties.LRDL);
                        stat.push(value);
                        if (value > maxValue) maxValue = value;
                        return [dataItem.geometry.coordinates[0], dataItem.geometry.coordinates[1], value];
                    });
                    break;
                case 'RESA':
                    data = threedData.features.map(function (dataItem) {
                        var value = parseInt(dataItem.properties.RESA);
                        stat.push(value);
                        if (value > maxValue) maxValue = value;
                        return [dataItem.geometry.coordinates[0], dataItem.geometry.coordinates[1], value];
                    });
                    break;
                case 'TERL':
                    data = threedData.features.map(function (dataItem) {
                        var value = parseInt(dataItem.properties.TERL);
                        stat.push(value);
                        if (value > maxValue) maxValue = value;
                        return [dataItem.geometry.coordinates[0], dataItem.geometry.coordinates[1], value];
                    });
                    break;
                case 'PIPL':
                    data = threedData.features.map(function (dataItem) {
                        var value = parseInt(dataItem.properties.PIPL);
                        stat.push(value);
                        if (value > maxValue) maxValue = value;
                        return [dataItem.geometry.coordinates[0], dataItem.geometry.coordinates[1], value];
                    });
                    break;
                case 'VEGA':
                    data = threedData.features.map(function (dataItem) {
                        var value = parseInt(dataItem.properties.VEGA);
                        stat.push(value);
                        if (value > maxValue) maxValue = value;
                        return [dataItem.geometry.coordinates[0], dataItem.geometry.coordinates[1], value];
                    });
                    break;
                default:
                    return;
                    break;
            }
            stat.sort();
            if (stat.length > 0) {
                level = {
                    "l0": stat[Math.floor(stat.length / 5)],
                    "l1": stat[Math.floor(stat.length * 2 / 5)],
                    "l2": stat[Math.floor(stat.length * 3 / 5)],
                    "l3": stat[Math.floor(stat.length * 4 / 5)],
                    "l4": maxValue
                };
            }
            threedOption.visualMap.pieces = [
                {gt: level.l3, lte: level.l4, color: '#a50026'},
                {gt: level.l2, lte: level.l3, color: 'orange'},
                {gt: level.l1, lte: level.l2, color: '#f46d43'},
                {gt: level.l0, lte: level.l1, color: '#4575b4'},
                {gte: 0, lte: level.l0, color: '#313695'}
            ];
            threedOption.series[0].data = data;
            if (threedOption && typeof threedOption === "object") {
                threedChart.setOption(threedOption, true);
            }
        }

        function getHourListAsc(datenum) {
            var time = this.getHourByDatenum(datenum);
            var hourList = [];
            for (var i = 0; i < 24; i++) {
                var value = time + i + 1;
                if (value >= 24) value -= 24;
                hourList.push(value);
            }
            return hourList;
        }

        function getHourListDesc(datenum) {
            var time = this.getHourByDatenum(datenum);
            var hourList = [];
            for (var i = 0; i < 24; i++) {
                var value = time + i + 1;
                if (value >= 24) value -= 24;
                hourList.unshift(value);
            }
            return hourList;
        }

        function getHourListIndex(time, array) {
            for (var i = 0; i < 24; i++) {
                if (time === array[i]) return i;
            }
        }

        function getIndexOfCity(city) {
            for (var i = 0; i < 13; i++) {
                if (city === cities[i]) return i;
            }
            return null;
        }

        function getCityByIndex(i) {
            if (typeof i !== "number" | i !== parseInt(i)) return null;
            if (i < 0 || i >= 13) return null;
            return cities[i];
        }

        function convertData(data) {
            var res = [];
            for (var i = 0; i < data.length; i++) {
                res.push({
                    name: data[i][0] + '市',
                    value: data[i][1]
                })
            }
            return res;
        }

        function convertData1(data, geoCoordMap) {
            var res = [];
            for (var i = 0; i < data.length; i++) {
                var geoCoord = geoCoordMap[data[i][0]];
                if (geoCoord) {
                    res.push({
                        name: data[i][0] + '市',
                        value: geoCoord.concat(data[i][1])
                    });
                }
            }
            return res;
        }

        function compare(index) {
            return function (m, n) {
                var a = m[index];
                var b = n[index];
                return b - a;
            }
        }

        function getTime() {
            $('#date').html(util.toDateString(new Date(), 'yyyy-MM-dd'));
            $('#time').html(util.toDateString(new Date(), 'HH:mm:ss'));

            setTimeout(function () {
                tools.getTime();
            }, 500);
        }

        return {
            getAqidjByAqi: getAqidjByAqi
            , getHourByDatenum: getHourByDatenum
            , search_query: search_query
            , reloadChart: reloadChart
            , getHourListAsc: getHourListAsc
            , getHourListDesc: getHourListDesc
            , getHourListIndex: getHourListIndex
            , getIndexOfCity: getIndexOfCity
            , getCityByIndex: getCityByIndex
            , convertData: convertData
            , convertData1: convertData1
            , compare: compare
            , reloadYearTime3DEcharts: reloadYearTime3DEcharts
            , getTime: getTime
        }
    })();

    initElem();
    // 江苏3D
    init3DEcharts();
    //知识图谱
    initGraph();
    // aqi实时感知
    // initAQI3();
    //绑定页面事件
    bindEvent();

    function initElem() {
        $.getJSON(rootPath + '/yzy/query/latest?limit=1', function (res) {
            $('#total-resource').html(res.count);
            $('#total-size').html(totalSize);
        });
    }

    // 江苏3D
    function init3DEcharts() {
        // 初始化图表
        threedChart = echarts.init($('#3dChart')[0]);
        threedChart.showLoading();
        $.getJSON(rootPath + '/datas/jiangsu.json').done(function (jiangsu) {
            echarts.registerMap('jiangsu', jiangsu);
            $.getJSON(rootPath + '/rest/es/search/all/page?instanceId=' + threedinstanceid["t" + default_year] + '&pageSize=5000').done(function (res) {
                threedChart.hideLoading();
                threedData = res.data;
                var stat = [];
                var maxValue = 0;
                var level = {};

                var data = threedData.features.map(function (dataItem) {
                    var value = parseInt(dataItem.properties.HYDA) + parseInt(dataItem.properties.LRDL)
                        + parseInt(dataItem.properties.RESA) + parseInt(dataItem.properties.TERL)
                        + parseInt(dataItem.properties.PIPL) + parseInt(dataItem.properties.VEGA);
                    stat.push(value);
                    if (value > maxValue) maxValue = value;
                    return [dataItem.geometry.coordinates[0], dataItem.geometry.coordinates[1], value];
                });

                stat.sort();
                if (stat.length > 0) {
                    level = {
                        "l0": stat[Math.floor(stat.length / 5)],
                        "l1": stat[Math.floor(stat.length * 2 / 5)],
                        "l2": stat[Math.floor(stat.length * 3 / 5)],
                        "l3": stat[Math.floor(stat.length * 4 / 5)],
                        "l4": maxValue
                    };
                }
                threedOption = {
                    // backgroundColor: '#cdcfd5',
                    geo3D: {
                        map: 'jiangsu',
                        shading: 'color',
                        boxWidth: 120,
                        viewControl: {
                            distance: 120,
                            // zoomSensitivity: 0,
                            // panSensitivity: 0,
                            // rotateSensitivity: 0,
                            center: [0, 0, 0],
                            beta: -20,
                            alpha: 50,
                            panMouseButton: 'left',
                            rotateMouseButton: 'right'
                        },
                        groundPlane: {
                            show: false,
                            color: '#999'
                        },
                        postEffect: {
                            enable: true,
                            bloom: {
                                enable: false
                            },
                            SSAO: {
                                radius: 1,
                                intensity: 1,
                                enable: true
                            },
                            depthOfField: {
                                enable: false,
                                focalRange: 10,
                                blurRadius: 10,
                                fstop: 1
                            }
                        },
                        temporalSuperSampling: {
                            enable: true
                        },
                        itemStyle: {
                            // borderWidth: 0.8,
                            // opacity: 0.9
                        },
                        regionHeight: 3,
                        // boxHeight: 10,
                        instancing: true
                    },
                    visualMap: {
                        show: false,
                        type: 'piecewise',
                        pieces: [
                            {gt: level.l3, lte: level.l4, color: '#a50026'},
                            {gt: level.l2, lte: level.l3, color: 'orange'},
                            {gt: level.l1, lte: level.l2, color: '#f46d43'},
                            {gt: level.l0, lte: level.l1, color: '#4575b4'},
                            {gte: 0, lte: level.l0, color: '#313695'}
                        ],
                        textStyle: {
                            color: '#fff'
                        }
                    },
                    series: [{
                        type: 'bar3D',
                        coordinateSystem: 'geo3D',
                        shading: 'color',
                        data: data,
                        barSize: 0.4,
                        minHeight: 2,
                        silent: true,
                        itemStyle: {
                            color: 'orange'
                            // opacity: 0.8
                        },
                        label: {}
                    }]
                };
                if (threedOption && typeof threedOption === "object") {
                    threedChart.setOption(threedOption, true);
                }
            }).fail(function () {
                threedChart.hideLoading();
                layer.msg("加载失败。");
            });
        });
    }

    // 知识图谱
    function initGraph() {

        graph_viz.init("#zsfw");
        //graph_viz.addzoom();
        // 查询语句
        if (!initQuery) {
            initQuery = "江苏省测绘地理信息局";
        }
        var ini_gremlin_query = 'nodes = g.V().has("name","' + initQuery + '").as("node").both().as("node").both().as("node").select(all,"node").unfold();'
            + 'edges = g.V().has("name","' + initQuery + '").both().bothE().as("edge").inject(g.V().has("name","' + initQuery + '").bothE()).as("edge").select(all,"edge").unfold();[nodes.toList(),edges.toList()]';
        // var ini_gremlin_query = 'nodes = g.V().has("name","江苏省测绘地理信息局").as("node").both().as("node").select(all,"node").inject( g.V().has("name","江苏省测绘地理信息局")).unfold();'
        //     + 'edges = g.V().has("name","江苏省测绘地理信息局").bothE();[nodes.toList(),edges.toList()]';
        tools.search_query(ini_gremlin_query);
    }

    function init(label) {
        var home_svg = d3.select(label).select("svg");
        var svg_width = +d3.select(label).node().getBoundingClientRect().width
        var svg_height = +d3.select(label).node().getBoundingClientRect().height;
        home_svg.attr("width", svg_width).attr("height", svg_height);
    }

    // aqi实时感知
    function initAQI() {
        // 初始化图表
        aqiChart = echarts.init($('#aqiChart')[0]);
        var date = new Date();
        date.setDate(date.getDate() - 1);
        var time = parseInt(util.toDateString(date, 'yyyyMMddHH'));
        var hours = tools.getHourList(time);
        // var hoursArray = tools.getHoursArray(time);
        $.getJSON(rootPath + '/rest/datastore/features/map?tableId=1c1ce57d-a4f0-4760-ad11-992c5eb1c57a&where=time>=' + time, function (res) {
            var dataNJ = [], dataWX = [], dataXZ = [], dataCZ = [],
                dataSZ = [], dataNT = [], dataLYG = [], dataHA = [],
                dataYC = [], dataYZ = [], dataZJ = [], dataTZ = [],
                dataSQ = [];
            var maxPm25 = 0, maxSo2 = 0;
            res = res.data;
            res.forEach(function (data) {
                var value = [];
                value.push(tools.getHourByDatenum(data.time));
                if (data.pm25 > maxPm25) maxPm25 = data.pm25;
                if (data.so2 > maxSo2) maxSo2 = data.so2;
                value.push(data.aqi);
                value.push(data.pm25);
                value.push(data.pm10);
                value.push(data.co);
                value.push(data.no2);
                value.push(data.so2);
                value.push(tools.getAqidjByAqi(data.aqi));
                switch (data.city) {
                    case '南京市':
                        dataNJ.push(value);
                        break;
                    case '无锡市':
                        dataWX.push(value);
                        break;
                    case '徐州市':
                        dataXZ.push(value);
                        break;
                    case '常州市':
                        dataCZ.push(value);
                        break;
                    case '苏州市':
                        dataSZ.push(value);
                        break;
                    case '南通市':
                        dataNT.push(value);
                        break;
                    case '连云港市':
                        dataLYG.push(value);
                        break;
                    case '淮安市':
                        dataHA.push(value);
                        break;
                    case '盐城市':
                        dataYC.push(value);
                        break;
                    case '扬州市':
                        dataYZ.push(value);
                        break;
                    case '镇江市':
                        dataZJ.push(value);
                        break;
                    case '泰州市':
                        dataTZ.push(value);
                        break;
                    case '宿迁市':
                        dataSQ.push(value);
                        break;
                    default:
                        break;
                }
            });

            var schema = [
                {name: 'hour', index: 0, text: '时'},
                {name: 'aqi', index: 1, text: 'AQI指数'},
                {name: 'pm25', index: 2, text: 'PM2.5'},
                {name: 'so2', index: 3, text: 'PM10'},
                {name: 'co', index: 4, text: '一氧化碳（CO）'},
                {name: 'no2', index: 5, text: '二氧化氮（NO2）'},
                {name: 'so2', index: 6, text: '二氧化硫（SO2）'}
            ];

            var itemStyle = {
                normal: {
                    opacity: 0.8,
                    shadowBlur: 10,
                    shadowOffsetX: 0,
                    shadowOffsetY: 0,
                    shadowColor: 'rgba(0, 0, 0, 0.5)'
                }
            };

            aqiOption = {
                backgroundColor: '#161838',
                color: [
                    '#d50000', '#C51162', '#AA00FF', '#6200EA', '#304FFE', '#2962FF', '#0091EA',
                    '#00B8D4', '#00BFA5', '#00C853', '#64DD17', '#AEEA00', '#FFD600'
                ],
                legend: {
                    top: 'top',
                    width: 500,
                    data: ['南京', '无锡', '徐州', '常州', '苏州', '南通', '连云港',
                        '淮安', '盐城', '扬州', '镇江', '泰州', '宿迁'],
                    selected: {
                        '南京': true,
                        '无锡': true,
                        '徐州': false,
                        '常州': false,
                        '苏州': true,
                        '南通': false,
                        '连云港': false,
                        '淮安': false,
                        '盐城': false,
                        '扬州': false,
                        '镇江': false,
                        '泰州': false,
                        '宿迁': false
                    },
                    textStyle: {
                        color: '#fff',
                        fontSize: 16
                    }
                },
                grid: {
                    x: '10%',
                    x2: 150,
                    y: '18%',
                    y2: '10%'
                },
                tooltip: {
                    padding: 10,
                    backgroundColor: '#222',
                    borderColor: '#777',
                    borderWidth: 1,
                    formatter: function (obj) {
                        var value = obj.value;
                        return '<div style="border-bottom: 1px solid rgba(255,255,255,.3); font-size: 18px;padding-bottom: 7px;margin-bottom: 7px">'
                            + obj.seriesName + ' ' + value[0] + '时：'
                            + value[7]
                            + '</div>'
                            + schema[1].text + '：' + value[1] + '<br>'
                            + schema[2].text + '：' + value[2] + '<br>'
                            + schema[3].text + '：' + value[3] + '<br>'
                            + schema[4].text + '：' + value[4] + '<br>'
                            + schema[5].text + '：' + value[5] + '<br>'
                            + schema[6].text + '：' + value[6] + '<br>';
                    }
                },
                xAxis: {
                    type: 'category',
                    name: '时间',
                    nameGap: 16,
                    nameTextStyle: {
                        color: '#fff',
                        fontSize: 14
                    },
                    data: hours,
                    splitLine: {
                        show: false
                    },
                    axisLine: {
                        lineStyle: {
                            color: '#eee'
                        }
                    }
                },
                yAxis: {
                    type: 'value',
                    name: 'AQI指数',
                    nameLocation: 'end',
                    nameGap: 20,
                    nameTextStyle: {
                        color: '#fff',
                        fontSize: 16
                    },
                    axisLine: {
                        lineStyle: {
                            color: '#eee'
                        }
                    },
                    splitLine: {
                        show: false
                    }
                },
                visualMap: [
                    {
                        left: 'right',
                        top: '10%',
                        dimension: 2,
                        min: 0,
                        max: maxPm25,
                        itemWidth: 30,
                        itemHeight: 120,
                        calculable: true,
                        precision: 0.1,
                        text: ['圆形大小：PM2.5'],
                        textGap: 30,
                        textStyle: {
                            color: '#fff'
                        },
                        inRange: {
                            symbolSize: [10, 70]
                        },
                        outOfRange: {
                            symbolSize: [10, 70],
                            color: ['rgba(255,255,255,.2)']
                        },
                        controller: {
                            inRange: {
                                color: ['#c23531']
                            },
                            outOfRange: {
                                color: ['#444']
                            }
                        }
                    },
                    {
                        left: 'right',
                        bottom: '5%',
                        dimension: 6,
                        min: 0,
                        max: maxSo2,
                        itemHeight: 120,
                        calculable: true,
                        precision: 0.1,
                        text: ['明暗：二氧化硫'],
                        textGap: 30,
                        textStyle: {
                            color: '#fff'
                        },
                        inRange: {
                            colorLightness: [1, 0.5]
                        },
                        outOfRange: {
                            color: ['rgba(255,255,255,.2)']
                        },
                        controller: {
                            inRange: {
                                color: ['#c23531']
                            },
                            outOfRange: {
                                color: ['#444']
                            }
                        }
                    }
                ],
                series: [
                    {
                        name: '南京',
                        type: 'scatter',
                        itemStyle: itemStyle,
                        data: dataNJ
                    },
                    {
                        name: '无锡',
                        type: 'scatter',
                        itemStyle: itemStyle,
                        data: dataWX
                    },
                    {
                        name: '徐州',
                        type: 'scatter',
                        itemStyle: itemStyle,
                        data: dataXZ
                    },
                    {
                        name: '常州',
                        type: 'scatter',
                        itemStyle: itemStyle,
                        data: dataCZ
                    },
                    {
                        name: '苏州',
                        type: 'scatter',
                        itemStyle: itemStyle,
                        data: dataSZ
                    },
                    {
                        name: '南通',
                        type: 'scatter',
                        itemStyle: itemStyle,
                        data: dataNT
                    },
                    {
                        name: '连云港',
                        type: 'scatter',
                        itemStyle: itemStyle,
                        data: dataLYG
                    },
                    {
                        name: '淮安',
                        type: 'scatter',
                        itemStyle: itemStyle,
                        data: dataHA
                    },
                    {
                        name: '盐城',
                        type: 'scatter',
                        itemStyle: itemStyle,
                        data: dataYC
                    },
                    {
                        name: '扬州',
                        type: 'scatter',
                        itemStyle: itemStyle,
                        data: dataYZ
                    },
                    {
                        name: '镇江',
                        type: 'scatter',
                        itemStyle: itemStyle,
                        data: dataZJ
                    },
                    {
                        name: '泰州',
                        type: 'scatter',
                        itemStyle: itemStyle,
                        data: dataTZ
                    },
                    {
                        name: '宿迁',
                        type: 'scatter',
                        itemStyle: itemStyle,
                        data: dataSQ
                    }
                ]
            };
            if (aqiOption && typeof aqiOption === "object") {
                aqiChart.setOption(aqiOption, true);
            }
        });
    }

    // aqi实时感知方案2
    function initAQI2() {
        aqiChart = echarts.init($('#aqiChart')[0]);
        aqiChart.showLoading();
        var date = new Date();
        date.setDate(date.getDate() - 1);
        var time = parseInt(util.toDateString(date, 'yyyyMMddHH'));
        $.getJSON(rootPath + '/rest/datastore/features/map?tableId=' + aqi_tableid + '&where=time>=' + date.getTime(), function (res) {
            aqiChart.hideLoading();
            res = res.data;
            var hours = tools.getHourListDesc(time);
            aqiData = [];
            res.forEach(function (value) {
                aqiData.push(
                    [
                        tools.getIndexOfCity(value.city),
                        tools.getHourListIndex(new Date(value.time).getHours(), hours),
                        value.aqi,
                        value.pm25,
                        value.so2,
                        value.co,
                        value.no2,
                        value.so2,
                        tools.getAqidjByAqi(value.aqi)
                    ]
                );
            });

            var schema = [
                {name: 'city', index: 0, text: '城市'},
                {name: 'hour', index: 1, text: '时'},
                {name: 'aqi', index: 2, text: 'AQI指数'},
                {name: 'pm25', index: 3, text: 'PM2.5'},
                {name: 'pm10', index: 4, text: 'PM10'},
                {name: 'co', index: 5, text: '一氧化碳（CO）'},
                {name: 'no2', index: 6, text: '二氧化氮（NO2）'},
                {name: 'so2', index: 7, text: '二氧化硫（SO2）'}
            ];

            aqiOption = {
                tooltip: {
                    padding: 10,
                    backgroundColor: '#222',
                    borderColor: '#777',
                    borderWidth: 1,
                    formatter: function (obj) {
                        var value = obj.value;
                        return '<div style="border-bottom: 1px solid rgba(255,255,255,.3); font-size: 18px;padding-bottom: 7px;margin-bottom: 7px">'
                            + tools.getCityByIndex(value[0]) + ' ' + value[1] + '时：'
                            + value[8]
                            + '</div>'
                            + schema[2].text + '：' + value[2] + '<br>'
                            + schema[3].text + '：' + value[3] + '<br>'
                            + schema[4].text + '：' + value[4] + '<br>'
                            + schema[5].text + '：' + value[5] + '<br>'
                            + schema[6].text + '：' + value[6] + '<br>'
                            + schema[7].text + '：' + value[7] + '<br>';
                    }
                },
                visualMap: {
                    type: 'piecewise',
                    left: 'right',
                    dimension: 2,
                    pieces: [
                        {gt: 300, color: '#480D27', label: '严重污染'},
                        {gt: 200, lte: 300, color: '#7E2B7D', label: '重度污染'},
                        {gt: 150, lte: 200, color: '#ED1D24', label: '中度污染'},
                        {gt: 100, lte: 150, color: '#F57E20', label: '轻度污染'},
                        {gt: 50, lte: 100, color: '#F3EC19', label: '良'},
                        {gte: 0, lte: 50, color: '#52B947', label: '优'}
                    ],
                    textStyle: {
                        color: '#fff'
                    }
                },
                xAxis3D: {
                    type: "category",
                    data: cities,
                    axisLabel: {
                        interval: 0
                    },
                    name: '城市'
                },
                yAxis3D: {
                    type: "category",
                    data: hours,
                    name: '时间'
                },
                zAxis3D: {
                    type: "value",
                    name: "AQI"
                },
                grid3D: {
                    top: 'middle',
                    left: 'center',
                    boxHeight: 150,
                    boxWidth: 250,
                    boxDepth: 300,
                    temporalSuperSampling: {
                        enable: true
                    },
                    viewControl: {
                        distance: 500,
                        center: [0, 0, 50],
                        projection: 'perspective',
                        panMouseButton: 'left',
                        rotateMouseButton: 'right'
                    },
                    light: {
                        main: {
                            intensity: 1.2,
                            shadow: false
                        },
                        ambient: {
                            intensity: 0.3
                        }
                    },
                    axisLine: {
                        lineStyle: {
                            color: "#fff"
                        }
                    },
                    axisPointer: {
                        lineStyle: {
                            color: [1, 1, 1, 1]
                        }
                    }
                },
                series: [
                    {
                        type: "bar3D",
                        data: aqiData,
                        shading: "lambert",
                        emphasis: {
                            label: {
                                show: false
                            },
                            itemStyle: {
                                color: "#900"
                            }
                        }
                    }
                ]
            };
            if (aqiOption && typeof aqiOption === "object") {
                aqiChart.setOption(aqiOption, true);
            }
        });
    }

    // aqi实时感知方案3
    function initAQI3() {
        aqiChart = echarts.init($('#aqiChart')[0]);
        aqiChart.showLoading();
        $.getJSON(rootPath + '/datas/jiangsu.json', function (jiangsu) {
            echarts.registerMap('jiangsu', jiangsu);
        }).then(function () {
            $.getJSON(rootPath + '/rest/datastore/features/map?tableId=' + aqi_tableid + '&where=1=1', function (res) {
                aqiChart.hideLoading();
                res = res.data;
                aqiData = [];
                var maxAQI = 0;
                res.forEach(function (value) {
                    if (value.aqi > maxAQI) maxAQI = value.aqi;
                    aqiData.push(
                        [
                            value.city,
                            value.aqi,
                            value.pm25,
                            value.so2,
                            value.co,
                            value.no2,
                            value.so2,
                            tools.getAqidjByAqi(value.aqi)
                        ]
                    );
                });
                var geoCoordMap = {
                    '南京': [118.778611, 32.043889],
                    '无锡': [120.313, 31.49],
                    '徐州': [117.283, 34.205],
                    '常州': [119.976, 31.81],
                    '苏州': [120.616667, 31.5],
                    '南通': [120.895, 31.98],
                    '连云港': [119.222, 34.597],
                    '淮安': [119.114, 33.55],
                    '盐城': [120.164, 33.347],
                    '扬州': [119.415, 32.393],
                    '镇江': [119.428, 32.188],
                    '泰州': [119.923, 32.455],
                    '宿迁': [118.2757, 33.9624]
                };
                var schema = [
                    {name: 'city', index: 0, text: '城市'},
                    {name: 'hour', index: 1, text: '时'},
                    {name: 'aqi', index: 2, text: 'AQI指数'},
                    {name: 'pm25', index: 3, text: 'PM2.5'},
                    {name: 'pm10', index: 4, text: 'PM10'},
                    {name: 'co', index: 5, text: '一氧化碳（CO）'},
                    {name: 'no2', index: 6, text: '二氧化氮（NO2）'},
                    {name: 'so2', index: 7, text: '二氧化硫（SO2）'}
                ];
                aqiOption = {
                    tooltip: {
                        trigger: 'item'
                    },
                    geo: {
                        show: false,
                        map: 'jiangsu'
                    },
                    visualMap: {
                        type: 'piecewise',
                        left: 'right',
                        seriesIndex: 0,
                        pieces: [
                            {gt: 300, color: '#480D27', label: '严重污染'},
                            {gt: 200, lte: 300, color: '#7E2B7D', label: '重度污染'},
                            {gt: 150, lte: 200, color: '#ED1D24', label: '中度污染'},
                            {gt: 100, lte: 150, color: '#F57E20', label: '轻度污染'},
                            {gt: 50, lte: 100, color: '#F3EC19', label: '良'},
                            {gte: 0, lte: 50, color: '#52B947', label: '优'}
                        ],
                        textStyle: {
                            color: '#fff'
                        }
                    },
                    series: [
                        {
                            name: '江苏AQI',
                            type: 'map',
                            mapType: 'jiangsu', // 自定义扩展图表类型
                            itemStyle: {
                                normal: {label: {show: false}},
                                emphasis: {label: {show: false}}
                            },
                            data: tools.convertData(aqiData),
                            tooltip: {
                                padding: 10,
                                backgroundColor: '#222',
                                borderColor: '#777',
                                borderWidth: 1,
                                formatter: function (obj) {
                                    var data = obj.data;
                                    return '<div style="border-bottom: 1px solid rgba(255,255,255,.3); font-size: 18px;padding-bottom: 7px;margin-bottom: 7px">'
                                        + data.name
                                        + '</div>'
                                        + schema[2].text + '：' + data.value + '<br>'
                                }
                            }
                        },
                        {
                            name: 'AQI',
                            type: 'scatter',
                            coordinateSystem: 'geo',
                            data: tools.convertData1(aqiData, geoCoordMap),
                            symbolSize: function (val) {
                                return val[2] / maxAQI * 30;
                            },
                            label: {
                                normal: {
                                    formatter: '{b}',
                                    position: 'right',
                                    show: true
                                }
                            },
                            itemStyle: {
                                normal: {
                                    color: 'purple'
                                }
                            },
                            tooltip: {
                                padding: 10,
                                backgroundColor: '#222',
                                borderColor: '#777',
                                borderWidth: 1,
                                formatter: function (obj) {
                                    var data = obj.data;
                                    return '<div style="border-bottom: 1px solid rgba(255,255,255,.3); font-size: 18px;padding-bottom: 7px;margin-bottom: 7px">'
                                        + data.name
                                        + '</div>'
                                        + schema[2].text + '：' + data.value[2] + '<br>'
                                }
                            }
                        },
                        {
                            name: 'Top 3',
                            type: 'effectScatter',
                            coordinateSystem: 'geo',
                            data: tools.convertData1(aqiData.sort(tools.compare[1]).slice(0, 3), geoCoordMap),
                            symbolSize: function (val) {
                                return val[2] / maxAQI * 30;
                            },
                            showEffectOn: 'render',
                            rippleEffect: {
                                brushType: 'stroke'
                            },
                            hoverAnimation: true,
                            label: {
                                normal: {
                                    show: false
                                }
                            },
                            itemStyle: {
                                normal: {
                                    color: 'purple',
                                    shadowBlur: 10,
                                    shadowColor: '#333'
                                }
                            },
                            zlevel: 1,
                            tooltip: {
                                padding: 10,
                                backgroundColor: '#222',
                                borderColor: '#777',
                                borderWidth: 1,
                                formatter: function (obj) {
                                    var data = obj.data;
                                    return '<div style="border-bottom: 1px solid rgba(255,255,255,.3); font-size: 18px;padding-bottom: 7px;margin-bottom: 7px">'
                                        + 'Top 3'
                                        + '</div>'
                                        + schema[2].text + '：' + data.value[2] + '<br>'
                                }
                            }
                        }
                    ]
                };
                if (aqiOption && typeof aqiOption === "object") {
                    aqiChart.setOption(aqiOption, true);
                }
            });
        })
        ;
    }

    // 绑定页面事件
    function bindEvent() {
        $(window).on('beforeunload', function () {
            $(window).scrollTop(0);
        });

        $(window).scroll(function () {
            var pos = $(window).scrollTop();
            scrollNum = scrollNum + 1;
            if (scrollNum < 2) {
                $(".title-bg1").slideUp(500);
                $('body,html').animate({scrollTop: 0}, 1000);
            }
            if (pos > 500) {
                $('.new-header-box').css("background-color", "#1f469e");
            } else {
                $('.new-header-box').css("background-color", "rgba(255,255,255,0)");
            }
            return false;
        });

        $(window).resize(function () {
            threedChart.resize();
            // aqiChart.resize();
        });

        $(document).ready(function () {
            tools.getTime();
            $('#left-botton-title').html(default_year + "年度资源概况");
            // $('#left-bottom-content-total-title').html(util.toDateString(new Date(), 'yyyy') + "年资源总数：");
            for (var i = 0; i < $('.year-time-year').length; i++) {
                $('.year-time-year:eq(' + i + ')').html(year - $('.year-time-year').length + i + 1);
            }
        });

        $(document).on('click', '.year-time-item', function () {
            var selected_year = $(this).find('.year-time-year:eq(0)').html();
            if (threedinstanceid["t" + selected_year]) {
                $('#left-botton-title').html(selected_year + "年度资源概况");
                $('#left-bottom-content-total-title').html(selected_year + "年资源总数：");
                tools.reloadYearTime3DEcharts(selected_year);
            } else {
                layer.msg("暂无数据.");
            }
        });

        $(document).on('click', '#year-plus', function () {
            if (year >= thisYear) return;
            year += 5;
            for (var i = 0; i < $('.year-time-year').length; i++) {
                $('.year-time-year:eq(' + i + ')').html(year - $('.year-time-year').length + i + 1);
            }
        });

        $(document).on('click', '#year-minus', function () {
            year -= 5;
            for (var i = 0; i < $('.year-time-year').length; i++) {
                $('.year-time-year:eq(' + i + ')').html(year - $('.year-time-year').length + i + 1);
            }
        });

        $(document).on('mouseover', '.left-bottom-content-box', function () {
            if (threedOption) {
                var select_type = $(this).find('p').html();
                switch (select_type) {
                    case '水系':
                        tools.reloadChart("HYDA");
                        break;
                    case '交通':
                        tools.reloadChart("LRDL");
                        break;
                    case '居民地':
                        tools.reloadChart("RESA");
                        break;
                    case '等高线':
                        tools.reloadChart("TERL");
                        break;
                    case '管线':
                        tools.reloadChart("PIPL");
                        break;
                    case '植被':
                        tools.reloadChart("VEGA");
                        break;
                    default:
                        break;
                }
            }
        });

        $(document).on('click', '#zsfw', function () {
            //window.location.href = '/kg/index.html';
        });

        $('.year-time-item').hover(function () {
            $(this).addClass('active');
        }, function () {
            $(this).removeClass('active');
        });

        $(document).on('mouseover', '.moreInfo', function () {
            $("#infoMsg").css("display", 'block');
            $(document).on('mousemove', function (event) {
                if ($("#infoMsg").css("display") !== "none") {
                    $("#infoMsg").css("left", event.pageX).css("top", event.pageY);
                }
            });
        });

        $(document).on('mouseout', '.moreInfo', function () {
            $('#infoMsg').hide();
            $(document).off('mousemove');
        });

        // $(document).on('mouseover', '#3dChart', function () {
        //     if (threedOption && threedOption.visualMap) {
        //         threedOption.visualMap.show = true;
        //         threedChart.setOption(threedOption, true);
        //     }
        // });
        //
        // $(document).on('mouseout', '#3dChart', function () {
        //     if (threedOption && threedOption.visualMap) {
        //         threedOption.visualMap.show = false;
        //         threedChart.setOption(threedOption, true);
        //     }
        // });
    }
});
