/**
 * 公共组件
 * by 李锐
 * date:2018/09/16
 **/
layui.define(['exception'], function (exports) {
    var $ = layui.jquery,
        exception = layui.exception;
    var common = {
        /**
         * -------------------------------------------------------------------------------------------------------------
         * 检查组件的【必选】配置项是否为空
         * @param config(object)  组件配置
         * @param mustItem(Array)   必选项
         * -------------------------------------------------------------------------------------------------------------
         */
        checkConfigIsEmpty: function (plugin, mustItem) {
            if (plugin.config === undefined || plugin.config === null) {
                return;
            }
            var item, checkLength;
            $.each(plugin.config, function (index, obj) {
                for (var i = 0; i < mustItem.length; i++) {
                    checkLength = false;
                    item = mustItem[i];
                    if (item.indexOf('.length') > 0) {
                        item = item.substr(0, item.indexOf('.length'));
                        checkLength = true;
                    }
                    if (item === index) {
                        if (obj === undefined || obj === null) {
                            exception.throwNotFindConfig(plugin, item);
                            return;
                        }
                        if (checkLength && checkLength <= 0) {
                            exception.throwNotFindConfig(plugin, item);
                            return;
                        }
                    }
                }
            })
        },


        /**
         * ----------------------------------------------------------------------------------
         * 将组件配置中的字符串或对象封装成容器并检查合法性
         * @param that
         * @returns {*}
         * ----------------------------------------------------------------------------------
         */
        getContainer: function (that) {
            var _config = that.config;
            //如果没有配置容器则,使用默认容器
            if (_config.el === undefined || _config.el === null) {
                _config.el = that.info.el;
            }
            if (typeof (_config.el) !== 'string' && typeof (_config.el) !== 'object') {
                exception.throwElemConfigError(that);
                return null;
            }
            var $container;
            if (typeof (_config.el) === 'string') {
                $container = $('' + _config.el + '');
            }
            if (typeof (_config.el) === 'object') {
                $container = _config.el;
            }
            if ($container.length === 0) {
                exception.throwElemNotFind(that.info);
                return null;
            }
            return $container;
        },
        /**----------------------------------------------------------------------------------
         * 获取当前项目的根路径
         * 返回:http:www.example.cn:port/工程名
         * @returns {string}
         * -----------------------------------------------------------------------------------
         */
        getRootPath: function () {
            var curWwwPath = window.document.location.href;
            var pathName = window.document.location.pathname;
            var pos = curWwwPath.indexOf(pathName);
            var localhostPaht = curWwwPath.substring(0, pos);
            var projectName = pathName.substring(0, pathName.substr(1).indexOf('/') + 1);
            return (localhostPaht + projectName);
        },
        getServerUrl: function () {
            var curWwwPath = window.document.location.href;
            var pathName = window.document.location.pathname;
            var pos = curWwwPath.indexOf(pathName);
            var localhostPaht = curWwwPath.substring(0, pos);
            return localhostPaht;
        },
        getUrlParam: function () {
            var url = decodeURI(location.href);
            var str = url.substr(url.indexOf("param=") + 6, url.length);
            return JSON.parse(str);
        }


    }
    exports('common', common);
})