/**
 *
 * @author by <a href="mailto:chaomashi@gmail.com">Du</a>
 * @version v1.0 2019/7/20/9:32  Copyright gtmap Corp
 */

define(["knockout",
    "Cesium",
    "global/utils/MapUtils",
    "global/utils/WidgetUtils",
    "leaflet",
    "leaflet-pip",
    "tp/TagsInput/src/jquery.tagsinput",
    "css!tp/TagsInput/src/jquery.tagsinput.css"
], function (
    ko,
    Cesium,
    MapUtils,
    WidgetUtils,
    L,
    leafletPip
    ) {
    var instance,
        me,
        $that = me = {
            viewer: "",
            centerPosition: [],
            ko: "",
            form: "",
            searchTag: {},
            allTags: [],
            // init fun
            init: function () {
                var config = WidgetUtils._appConfig;
                $that.viewer = MapUtils.viewer;
                $that = me;
                $.ajax({
                    url: getAllRegionsUrl + allRegionCode,
                    type: 'get',
                    async:false,
                    success: function (data) {
                        dict = data
                    },
                    error: function () {
                        $.ajax({
                            url: "../../mock/region.json",
                            type: 'get',
                            async:false,
                            success: function (data) {
                                dict = data;
                            }
                        })
                    }
                });
                $.ajax({
                    type: "post",
                    url: getAllRegionGeoJson,
                    data: {
                        'instanceId': countyInstanceId,
                        'returnExtent': true
                    },
                    dataType: "json",
                    async: false,
                    success: function (data) {
                        correctData = data.data.features;

                        function correct(correctData) {
                            return correctData.properties.XZQMC !== "江苏省岛屿"
                        }

                        countyArr = correctData.filter(correct);
                        $.each(correctData, function (index, value) {
                            if (value.properties.XZQMC === "江苏省岛屿") {
                                countyArr.push(correctData[index])
                            }
                        });
                    }
                });
                ko.applyBindings(new $that.createRegionSelect(dict), document.getElementById("regionSelect"));//绑定数据生成选项列表
                $that.viewer.scene.camera.moveEnd.addEventListener($that.regionLocation);// 监听camera移动定位行政区
                $that.initLayui();//layui设置下拉列表
                $("#regionNowCity")[0].innerText = tpl.regionName!=""?tpl.regionName:"江苏省";

            },

            // open event
            onOpen: function () {
                $that.viewer.scene.camera.moveEnd.addEventListener($that.regionLocation);
                $that.controlForm();
                $that.correctHeight();
            },
            // close event
            onClose: function () {
                $(".region-form")[0].reset();
                $that.form.render();
                $that.clearData();
                chooseStyle();
                $("#regionSearchHistory").importTags("");
                $that.allTags = [];
                $that.viewer.scene.camera.moveEnd.removeEventListener($that.regionLocation)
            },
            // pause event
            onPause: function () {
                $that.onClose()
            },
            initLayui: function () {
                layui.use(['form', 'upload', 'layer'], function () {
                    $that.form = layui.form;
                    $.each($("#regionSelect").find('span'), function (index, value) {
                        $("#regionSearchInput").append(new Option(value.innerText, value.value))
                    });
                    $that.controlForm();
                    $that.form.on("select(regionSearchInput)", function (data) {
                        chooseStyle();
                        if (data.value.length === 6) {
                            var btnId = '#Span' + data.value;
                            $(btnId).addClass("region-children-pointed");
                            instanceId = countyInstanceId;
                            fieldValue = data.value;
                            $.each(dict, function (index, value) {
                                $.each(value.children, function (index1, value1) {
                                    if (value1.value === data.value) {
                                        var tag = value1.name;
                                        $that.createTags(tag);
                                    }
                                });
                            })
                        } else if (data.value.length === 4) {
                            var btnId = '#Span' + data.value;
                            $(btnId).addClass("region-title-pointed");
                            instanceId = cityInstanceId;
                            fieldValue = data.value;
                            $.each(dict, function (index, value) {
                                if (value.value === data.value) {
                                    var tag = value.name;
                                    $that.createTags(tag);
                                }
                            })
                        }
                        $that.createPolygon(instanceId, fieldValue);
                    })
                });
                $("#regionSearchHistory").tagsInput({
                    'defaultText': "",
                    interactive: false,
                    "height": 'auto',
                    "min-height": '4vh',
                    "width": "95%",
                    onRemoveTag: function (data) {
                        $.each($that.allTags, function (index, value) {
                            if (value === data) {
                                $that.allTags.splice(index, 1)
                            }
                        });
                        $that.correctHeight();
                    }
                });
                $("#regionSearchHistory_tagsinput ").on("click", "span", function () {
                    chooseStyle();
                    var test = this.innerText;
                    var str = /[\u4e00-\u9fa5]/g;
                    var names = test.match(str);
                    names = names.join("");
                    $.each(dict, function (index, value) {
                        if (value.name === names) {
                            var btnId = '#Span' + value.value;
                            $(btnId).addClass("region-title-pointed");
                            instanceId = cityInstanceId;
                            fieldValue = value.value;
                            $that.createPolygon(instanceId, fieldValue)
                        }
                    });
                    $.each(dict, function (index, value) {
                        $.each(value.children, function (index1, value1) {
                            if (value1.name === names) {
                                var btnId = '#Span' + value1.value;
                                $(btnId).addClass("region-children-pointed");
                                instanceId = countyInstanceId;
                                fieldValue = value1.value;
                                $that.createPolygon(instanceId, fieldValue)
                            }
                        })
                    });
                });
                $("#regionSearchHistory_tagsinput ").on("mouseover", "span", function () {
                    this.title = this.innerText;
                })
            },


            // 生成行政区列表，绑定点击事件
            createRegionSelect: function () {
                var self = this;
                self.types = [];
                $that.ko = self;
                order(dict);
                self.types = ko.observableArray(dict);
                self.searchArea = function (btn) {
                    var btnId = '#Span' + btn.value;
                    var tag = btn.name;
                    $that.createTags(tag);
                    chooseStyle();
                    $(btnId).addClass("region-title-pointed");
                    instanceId = cityInstanceId;
                    fieldValue = btn.value;
                    $that.createPolygon(instanceId, fieldValue);
                };
                regionSearch = function (btn) {
                    var btnId = '#Span' + btn.value;
                    chooseStyle();
                    var tag = btn.name;
                    $that.createTags(tag);
                    $(btnId).addClass("region-children-pointed");
                    instanceId = countyInstanceId;
                    fieldValue = btn.value;
                    $that.createPolygon(instanceId, fieldValue);
                };
            },
            createTags: function (tag) {
                $that.searchTag = tag;
                if (!$("#regionSearchHistory").tagExist($that.searchTag)) {
                    $that.allTags.push($that.searchTag);
                    if ($that.allTags.length > 8) {
                        var delTag = $that.allTags.shift();
                        $("#regionSearchHistory").removeTag(delTag);
                    }
                    $that.allTags.reverse();
                    $("#regionSearchHistory").importTags("");
                    $("#regionSearchHistory").importTags($that.allTags.toString());
                    $that.correctHeight();
                    $that.allTags.reverse();
                }
            },
            // 渲染并fly to
            createPolygon: function () {
                $that.clearData();
                $.ajax({
                    type: "post",
                    url: singleRegionGeoJson,
                    data: {
                        'instanceId': instanceId,
                        'fieldName': "properties.XZQDM",
                        'fieldValue': fieldValue
                    },
                    dataType: "json",
                    async: false,
                    success: function (data) {
                        var temp = {};
                        temp.features = data.data.features;
                        temp.type = data.data.type;
                        var promise = Cesium.GeoJsonDataSource.load(temp);

                        promise.then(function (dataSource) {
                            $that.viewer.dataSources.add(dataSource);
                            var entity = dataSource.entities.values;
                            MapUtils.setEntityStyle(entity, "region");
                        });

                        //$that.viewer.flyToViewer(promise) .then(function () {
                        $that.viewer.flyTo(promise) .then(function () {
                            // showCountyPosition();
                            //修正因为行政区凹陷导致行政区名称不准确问题
                            var features = data.data.features;
                            var feature=null;
                            if(features.length>0){
                                feature = features[0];
                            }
                            if(feature){
                                setTimeout(function () {
                                    $("#regionNowCounty")[0].innerText = feature.properties.XZQMC;
                                },1000);

                            }

                        });
                    }
                })
            },

            // 获取camera中心点坐标
            screenPosition: function () {
                var result = $that.viewer.camera.pickEllipsoid(new Cesium.Cartesian2($that.viewer.canvas.clientWidth / 2, $that.viewer.canvas
                    .clientHeight / 2));
                if (result) {
                    var curPosition = Cesium.Ellipsoid.WGS84.cartesianToCartographic(result); //84坐标
                    var centerX = curPosition.longitude * 180 / Math.PI;
                    var centerY = curPosition.latitude * 180 / Math.PI;
                    $that.centerPosition = [centerX, centerY];
                } else {
                    $that.centerPosition = []
                }
            },

            // 监听相机移动显示行政区信息
            regionLocation: function () {
                showCountyPosition();
            },
            //判断高度
            correctHeight: function () {
                if ($that.allTags.length === 0) {
                    $(".region-select-result").css("display", "none")
                } else {
                    $(".region-select-result").css("display", "block")
                }
                if ($(window).width() < 1920) {
                    if ($(".region-select-result").height() > 40 && $(".region-select-result").height() < 45) {
                        $(".region-select").css("height", "60vh")
                    } else if ($(".region-select-result").height() > 45) {
                        $(".region-select").css("height", "55vh")
                    } else if ($(".region-select-result").height() < 40) {
                        $(".region-select").css("height", "65vh")
                    }
                } else if ($(window).width() === 1920) {
                    if ($(".region-select-result").height() > 40 && $(".region-select-result").height() < 45) {
                        $(".region-select").css("height", "66vh")
                    } else if ($(".region-select-result").height() > 45) {
                        $(".region-select").css("height", "63vh")
                    } else if ($(".region-select-result").height() < 40) {
                        $(".region-select").css("height", "70vh")
                    }
                }
            },
            // 清除图层
            clearData: function () {
                var len = $that.viewer.dataSources.length;
                $(len).each(function () {
                    $that.viewer.dataSources.remove($that.viewer.dataSources.get(0));
                })
            },
            // 表单控制
            controlForm: function () {
                $that.form.render("select");
                $(".region-input").find(".layui-input").focus(function () {
                    $(".layui-anim-upbit").css("visibility", "hidden")
                });
                $(".region-input").on('input propertychange', '.layui-input', function () {
                    var text = $(".region-input").find(".layui-input").val();
                    if (text === "") {
                        $(".layui-anim-upbit").css("visibility", "hidden")
                    } else {
                        $(".layui-anim-upbit").css("visibility", "visible")
                    }
                    $(".region-form").find(".layui-this").addClass("layui-hide").removeClass("layui-this");
                });
            }
        };
    var interfaceConfig = WidgetUtils._appConfig.interface,
        getAllRegionsUrl = interfaceConfig.allRegionUrl,
        getAllRegionGeoJson = interfaceConfig.regionEsGeoJson,
        singleRegionGeoJson = interfaceConfig.singleRegionEsGeoJson,
        allRegionCode = interfaceConfig.regionCode,
        cityInstanceId = interfaceConfig.cityInstanceId,
        countyInstanceId = interfaceConfig.countyInstanceId,
        instanceId = "",
        dict = {},
        correctData = [],
        countyArr = [],
        fieldValue = {};

    // 行政区根据名字长度排序
    function order(dict) {
        dict.sort(function (a,b) {
            if(a.value<b.value){
                return -1;
            }else {
                return 1;
            }
        })

        $.each(dict, function (i, item) {
            item.children.sort(function (a, b) {
                if (a.name.length < b.name.length) {
                    return -1;
                } else if (a.name.length > b.name.length) {
                    return 1;
                } else {
                    return 0;
                }
            })
        })
    }


    // 县级的相对定位，并根据父组数据断定所在市范围
    function showCountyPosition() {
        $that.screenPosition();
        var cartesian3 = $that.viewer.camera.positionWC;
        var cartographic = Cesium.Ellipsoid.WGS84.cartesianToCartographic(cartesian3);
        var height = cartographic.height;
        // var firstHeight = $that.viewer.camera.positionCartographic.height;
        // var height = Math.ceil(firstHeight);
        if (height < 600000) {
            $.each(countyArr, function (i, item) {
                var gjLayer = L.geoJson(item);
                var pipResult = leafletPip.pointInLayer($that.centerPosition, gjLayer, false);
                if (pipResult.length !== 0) {
                    $("#regionNowCounty")[0].innerText = item.properties.XZQMC;
                    $.each(dict, function (index, value) {
                        $.each(value.children, function (index1, value1) {
                            if (value1.name === item.properties.XZQMC) {
                                $("#regionNowCity")[0].innerText = value.name;
                            }
                        });
                    });
                    return false;
                }
                if (pipResult.length === 0) {
                    $("#regionNowCity")[0].innerText = "";
                    $("#regionNowCounty")[0].innerText = "行政区定位";
                }
            })
        } else if (height < 1400000 && height > 600000) {
            if ($that.centerPosition[0] < 124.500000 && $that.centerPosition[0] > 116.800000 &&
                $that.centerPosition[1] < 35.333333 && $that.centerPosition[1] > 30.750000) {
                $("#regionNowCity")[0].innerText = tpl.regionName!=""?tpl.regionName:"江苏省";
                $("#regionNowCounty")[0].innerText = ""
            } else {
                $("#regionNowCity")[0].innerText = "";
                $("#regionNowCounty")[0].innerText = "行政区定位"
            }
        } else if (height > 1400000) {
            $("#regionNowCity")[0].innerText = "";
            $("#regionNowCounty")[0].innerText = "行政区定位"
        }
    }

    function chooseStyle() {
        $(".region-title-pointed").removeClass("region-title-pointed");
        $(".region-children-label").removeClass("region-children-pointed");
    }

    /**
     * get instance
     *
     * @returns {*}
     */
    me.getInstance = function () {
        if (void 0 === instance) {
            instance = me;
        }
        return instance;
    };
    return me;
});
