define(['global/utils/MapUtils',
    'Cesium',
    'lodash',
    'global/widgets/dataViews/upload',
    'global/core/Popup',
    'knockout',
    'global/utils/WidgetUtils',
    'global/core/DrawGeometry',
    "global/widgets/aysSearch/Index"
], function (
    MapUtils,
    Cesium,
    _,
    Upload,
    Popup,
    ko,
    WidgetUtils,
    DrawGeometry,
    aysSearch
) {
    var instance, me,
        $that = me = {

            // 标记点集合
            billboards: "",

            // 监听
            handler: "",

            //起始点
            koList: {},

            //终点
            koList1: {},

            // init fun
            init: function () {
                $that.url = this.config.analysisurl;

                $that.handler = new Cesium.ScreenSpaceEventHandler(MapUtils.viewer.scene.canvas);
                $that.billboards = MapUtils.viewer.scene.primitives.add(new Cesium.BillboardCollection());

                $that._initDrawPath();
                $that._initLayui();
            },
            // open event
            onOpen: function () {
                $that.handler = new Cesium.ScreenSpaceEventHandler(MapUtils.viewer.scene.canvas);
                $that.billboards = MapUtils.viewer.scene.primitives.add(new Cesium.BillboardCollection());

                $that._initDrawPath();
            },
            // close event
            onClose: function () {
                $that._closePathPane();
            },
            // pause event
            onPause: function () {
                $that._closePathPane();
            },

            _initEnd: function(coords){
                $("#input-pathplan-end").val("(" + coords[0] + "," + coords[1] + ")");
            },

            // 初始化layui
            _initLayui: function () {
                layui.use(['form'], function () {
                    var form = layui.form;
                    form.render();
                });
            },

            // 初始化绘制方法，监听和事件
            _initDrawPath: function () {
                var clampMode = 1; // 贴地
                var viewer = MapUtils.viewer;
                var scene = viewer.scene;
                var widget = viewer.cesiumWidget;
                // var handlerDis, handlerArea, handlerHeight;
                // // 初始化测量距离
                // handlerDis = new Cesium.MeasureHandler(viewer, Cesium.MeasureMode.Distance, clampMode);
                // // 注册测距功能事件
                // handlerDis.measureEvt.addEventListener(function (result) {
                //     var dis = Number(result.distance);
                //     var distance = dis > 1000 ? (dis / 1000).toFixed(2) + 'km' : dis.toFixed(2) + 'm';
                //     handlerDis.disLabel.text = '距离:' + distance;
                //
                // });
                // handlerDis.activeEvt.addEventListener(function (isActive) {
                //     if (isActive === true) {
                //         viewer.enableCursorStyle = false;
                //         viewer._element.style.cursor = '';
                //         $('body').removeClass('measureCur').addClass('measureCur');
                //     } else {
                //         viewer.enableCursorStyle = true;
                //         $('body').removeClass('measureCur');
                //     }
                // });
                //
                // $that.handlerDis = handlerDis;

                // // 初始化测量面积
                // handlerArea = new Cesium.MeasureHandler(viewer, Cesium.MeasureMode.Area, clampMode);
                // handlerArea.measureEvt.addEventListener(function (result) {
                //     var mj = Number(result.area);
                //     var area = mj > 1000000 ? (mj / 1000000).toFixed(2) + 'km²' : mj.toFixed(2) + '㎡'
                //     handlerArea.areaLabel.text = '面积:' + area;
                // });
                // handlerArea.activeEvt.addEventListener(function (isActive) {
                //     if (isActive === true) {
                //         viewer.enableCursorStyle = false;
                //         viewer._element.style.cursor = '';
                //         $('body').removeClass('measureCur').addClass('measureCur');
                //     } else {
                //         viewer.enableCursorStyle = true;
                //         $('body').removeClass('measureCur');
                //     }
                // });

                // $that.handlerArea = handlerArea;

                $(".mark-start").on('click', function () {
                    // deactiveAll();
                    $that.hasInitMark = false;
                    if ($that.handler.removeInputAction !== undefined) {
                        $that.handler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_CLICK);
                    }
                    $that._initMarkerPath("start");
                });

                $(".mark-end").on('click', function () {
                    // deactiveAll();
                    $that.hasInitMark = false;
                    if ($that.handler.removeInputAction !== undefined) {
                        $that.handler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_CLICK);
                    }
                    $that._initMarkerPath("end");
                });

                $(".pathplan-analysis").on('click', function () {
                    var startP=$("#input-pathplan-start").val();
                    var endP=$("#input-pathplan-end").val();
                    if(startP.length === 0||endP.length === 0){
                        layer.msg("请先选择起点和终点！");
                        return;
                    }

                    var weighttype = "";
                    if($("#input-length")[0].checked){
                        weighttype = $("#input-length").val();
                    }else {
                        weighttype = $("#input-speed").val();
                    }

                    $that.hasInitMark = false;
                    if ($that.handler.removeInputAction !== undefined) {
                        $that.handler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_CLICK);
                    }

                    var x1 = startP.split(',')[0].substring(1, startP.split(',')[0].length);
                    var y1 = startP.split(',')[1].substring(0, startP.split(',')[1].length-1);
                    var x2 = endP.split(',')[0].substring(1, endP.split(',')[0].length);
                    var y2 = endP.split(',')[1].substring(0, endP.split(',')[1].length-1);

                    var formData1 = new FormData();
                    formData1.append("weighttype", weighttype);
                    // formData1.append("ishighspeedroad", "true");

                    // //测试南京
                    // formData1.append("x1", 118.71710300445557);
                    // formData1.append("y1", 32.036693066742735);
                    // formData1.append("x2", 118.69980812072754);
                    // formData1.append("y2", 31.96570696858825);

                    // // 测试宁夏
                    // formData1.append("x1", 106.14509582519531);
                    // formData1.append("y1", 38.50357937743225);
                    // formData1.append("x2", 106.25118255615234);
                    // formData1.append("y2", 38.34030979622719);
                    formData1.append("x1", x1);
                    formData1.append("y1", y1);
                    formData1.append("x2", x2);
                    formData1.append("y2", y2);

                    $.ajax({
                        type: 'POST',
                        url: $that.url,
                        // url: 'http://192.168.2.101:10002/mdb/v1/analysis/pathanalysis',
                        contentType: false,
                        processData: false,
                        data: formData1,
                        beforeSend: function () {
                            showLoading("路线规划中...","#pathPlanWidget");
                        },
                        success: function (data) {
                            closeLoading();

                            if(data.data === null){
                                layer.msg("路线规划失败！");
                                return;
                            }

                            var featurecollection = JSON.parse(data.data);

                            var resultEntity = aysSearch.geoJsonToMapGroud(featurecollection.features, {color: new Cesium.Color.fromBytes(255, 175, 151, 255)});

                        },
                        error: function (e, state, errorThrown) {
                            // console.log(e);
                            closeLoading();
                            layer.msg("路线规划失败！");
                        }
                    });


                });

                $(".pathplan-clear").on('click', function () {
                    $.each($that.koList, function (index, value) {
                        $that.billboards.remove(value.removeMark);
                    });
                    $.each($that.koList1, function (index, value) {
                        $that.billboards.remove(value.removeMark);
                    });
                    MapUtils.viewer.dataSources.removeAll();
                    $that.koList = {};
                    $that.koList1 = {};
                    $("#input-pathplan-start").val("");
                    $("#input-pathplan-end").val("");
                });

                // $(".mark-remove-all").on('click', function () {
                //     // clearAll();
                //     $that.billboards.removeAll();
                //     $.each($that.koList, function (index, value) {
                //         MapUtils.viewer.dataSources.remove(value.remove);
                //     });
                //     $.each($that.koList1, function (index, value) {
                //         MapUtils.viewer.dataSources.remove(value.remove);
                //     });
                //     $that.koList = {};
                //     $that.koList1 = {};
                //     // $that._updateUploadList();
                //     $that.hasInitMark = false;
                //     $that.handler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_CLICK);
                //     // $(".mark-popup").hide();
                //     // DrawGeometry.remove();
                // });

                // function clearAll() {
                //     handlerDis && handlerDis.clear();
                //     handlerArea && handlerArea.clear();
                // }
                //
                // function deactiveAll() {
                //     handlerDis && handlerDis.deactivate();
                //     handlerArea && handlerArea.deactivate();
                // }
            },

            // 初始化标记点
            _initMarkerPath: function (pointType) {
                // 标记点集合
                var viewer = MapUtils.viewer;

                $that.handler.setInputAction(function (click) {
                    var pickedObject = MapUtils.viewer.scene.pick(click.position);
                    var clickPoint = MapUtils.viewer.scene.pickPosition(click.position);
                    var pointWithHeight = Cesium.Cartographic.fromCartesian(clickPoint);

                    var lat = Cesium.Math.toDegrees(pointWithHeight.latitude);
                    var lng = Cesium.Math.toDegrees(pointWithHeight.longitude);

                    var lastPosition = viewer.scene.globe.ellipsoid.cartographicToCartesian(pointWithHeight);
                    if (typeof pickedObject !== 'undefined' && pickedObject.id !== undefined && pickedObject.id.indexOf('mark') !== -1) {
                        // var content = $that._createPopupContent(pickedObject);
                        // $("#markPopupClose" + pickedObject.id).trigger('click');
                        // Popup.open({
                        //     content: content,
                        //     position: click.position,
                        //     offset: "top",
                        //     hasTriangle: true,
                        //     triangleOffset: "bottom",
                        //     hasClose: false
                        // });
                        // $("#markPopupClose" + pickedObject.id).on('click', function (e) {
                        //     Popup.close(e);
                        // });
                        // $("#markPopupSave" + pickedObject.id).on('click', function (e) {
                        //     pickedObject.name = $("#markPopupName" + pickedObject.id).val();
                        //     pickedObject.content = $("#markPopupContent" + pickedObject.id).val();
                        //     var temp = $that.koList[pickedObject.id];
                        //     temp.name = pickedObject.name;
                        //     delete $that.koList[pickedObject.id];
                        //     $that._createRBPane();
                        //     $that.koList[pickedObject.id] = temp;
                        //     $that._createRBPane();
                        // });
                    } else {
                        if (!$that.hasInitMark) {
                            var id = "mark" + _.uniqueId();
                            var remove = $that.billboards.add({
                                position: lastPosition,
                                image: './../../../global/widgets/smartSearch/defaultPhoto/biaoji_common.png',
                                verticalOrigin: Cesium.VerticalOrigin.BOTTOM,
                                id: id,
                                pixelOffset: new Cesium.Cartesian2(0, -5),
                                eyeOffset: new Cesium.Cartesian3(0, 0, -50)
                            });
                            $that.hasInitMark = true;
                            // 生成名称，定位，和移除方法3个内容组成的对象方便移除
                            var list = {};
                            list.id = id;
                            list.name = "请填写名称";
                            list.point = clickPoint;
                            list.removeMark = remove;
                            list.mark = true;

                            if(pointType === "start"){
                                $("#input-pathplan-start").val("(" + lng + "," + lat + ")");

                                $.each($that.koList, function (index, value) {
                                    MapUtils.viewer.dataSources.remove(value.remove);
                                    $that.billboards.remove(value.removeMark);
                                    delete $that.koList[value.id];
                                });
                                $that.koList[list.id] = list;
                            }else if(pointType === "end"){
                                $("#input-pathplan-end").val("(" + lng + "," + lat + ")");

                                $.each($that.koList1, function (index, value) {
                                    MapUtils.viewer.dataSources.remove(value.remove);
                                    $that.billboards.remove(value.removeMark);
                                    delete $that.koList1[value.id];
                                });
                                $that.koList1[list.id] = list;
                            }


                            // $(".mark-upload-result").show();
                            // // 更新右侧列表
                            // $that._createRBPane();
                        }
                    }
                }, Cesium.ScreenSpaceEventType.LEFT_CLICK)

            },

            _closePathHandler: function () {
                $that.billboards.removeAll();
                $that.hasInitMark = false;
                $that.handler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_CLICK);
            },

            _closePathPane: function () {
                $that._closePathHandler();
                // WidgetUtils.closeRightPopup();
                $.each($that.koList, function (index, value) {
                    MapUtils.viewer.dataSources.remove(value.remove);
                    $that.billboards.remove(value.removeMark);
                });
                $.each($that.koList1, function (index, value) {
                    MapUtils.viewer.dataSources.remove(value.remove);
                    $that.billboards.remove(value.removeMark);
                });
                $that.koList = {};
                $that.koList1 = {};
                $("#input-pathplan-start").val("");
                $("#input-pathplan-end").val("");
            }


            // // 初始化右下角窗口
            // _initRBPopup: function () {
            //     var content = '<div class="mark-upload-result" data-bind="foreach: {data: markResults, as: \'result\'}" id="markUploadResult">\n' +
            //         '<!-- ko if: result.upload -->' +
            //         '        <div class="mark-result-content">\n' +
            //         '            <i class="icon-f-tool-layout mark-upload-icon"></i>\n' +
            //         '            <div class="mark-result-title" data-bind="click: $parent.location"><i class="mark-result-name" data-bind="attr: {id: result.id + \'MarkUpload\'}, text: result.name"></i></div>\n' +
            //         '            <i class="icon-f-close mark-result-close" data-bind="click: $parent.remove, click: $parent.remove"></i>\n' +
            //         '        </div>\n' +
            //         '<!-- /ko -->' +
            //         '<!-- ko if: result.mark -->' +
            //         '        <div data-bind="if: result.mark" class="mark-upload-mark-result">\n' +
            //         '            <i class="icon-f-point mark-mark-icon"></i>\n' +
            //         '            <div class="mark-result-title" data-bind="click: $parent.locationMark" title="点击定位"><i class="mark-result-name" data-bind="attr: {id: result.id + \'MarkUpload\'}, text: result.name"></i></div>\n' +
            //         '            <i class="icon-f-close mark-result-close" data-bind="click: $parent.remove, click: $parent.removeMark"></i>\n' +
            //         '            <i class="icon-f-analysis-edit mark-mark-edit"  data-bind="click: $parent.editMark"></i>\n' +
            //         '        </div>\n' +
            //         '<!-- /ko -->' +
            //         '    </div>';
            //     return content;
            // },
            //
            // // 初始化绘制方法，监听和事件
            // _initDraw: function () {
            //     var clampMode = 1; // 贴地
            //     var viewer = MapUtils.viewer;
            //     var scene = viewer.scene;
            //     var widget = viewer.cesiumWidget;
            //     var handlerDis, handlerArea, handlerHeight;
            //     // 初始化测量距离
            //     handlerDis = new Cesium.MeasureHandler(viewer, Cesium.MeasureMode.Distance, clampMode);
            //     // 注册测距功能事件
            //     handlerDis.measureEvt.addEventListener(function (result) {
            //         var dis = Number(result.distance);
            //         var distance = dis > 1000 ? (dis / 1000).toFixed(2) + 'km' : dis.toFixed(2) + 'm';
            //         handlerDis.disLabel.text = '距离:' + distance;
            //
            //     });
            //     handlerDis.activeEvt.addEventListener(function (isActive) {
            //         if (isActive === true) {
            //             viewer.enableCursorStyle = false;
            //             viewer._element.style.cursor = '';
            //             $('body').removeClass('measureCur').addClass('measureCur');
            //         } else {
            //             viewer.enableCursorStyle = true;
            //             $('body').removeClass('measureCur');
            //         }
            //     });
            //
            //     $that.handlerDis = handlerDis;
            //
            //     // 初始化测量面积
            //     handlerArea = new Cesium.MeasureHandler(viewer, Cesium.MeasureMode.Area, clampMode);
            //     handlerArea.measureEvt.addEventListener(function (result) {
            //         var mj = Number(result.area);
            //         var area = mj > 1000000 ? (mj / 1000000).toFixed(2) + 'km²' : mj.toFixed(2) + '㎡'
            //         handlerArea.areaLabel.text = '面积:' + area;
            //     });
            //     handlerArea.activeEvt.addEventListener(function (isActive) {
            //         if (isActive === true) {
            //             viewer.enableCursorStyle = false;
            //             viewer._element.style.cursor = '';
            //             $('body').removeClass('measureCur').addClass('measureCur');
            //         } else {
            //             viewer.enableCursorStyle = true;
            //             $('body').removeClass('measureCur');
            //         }
            //     });
            //
            //     $that.handlerArea = handlerArea;
            //
            //     $(".mark-type-marker").on('click', function () {
            //         deactiveAll();
            //         $that.hasInitMark = false;
            //         if ($that.handler.removeInputAction !== undefined) {
            //             $that.handler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_CLICK);
            //         }
            //         $that._initMarker()
            //     });
            //     //
            //     $(".mark-type-space-line").on('click', function () {
            //         // deactiveAll();
            //         // handlerDis && handlerDis.activate();
            //         DrawGeometry.draw({
            //             type: "groundLine",
            //             measure: true,
            //             viewer: MapUtils.viewer
            //         });
            //     });
            //
            //     $(".mark-type-area").on('click', function () {
            //         // deactiveAll();
            //         // handlerArea && handlerArea.activate();
            //         DrawGeometry.draw({
            //             type: "drawGroundSurface",
            //             measure: true,
            //             viewer: MapUtils.viewer
            //         });
            //     });
            //
            //     $(".mark-remove-all").on('click', function () {
            //         clearAll();
            //         $that.billboards.removeAll();
            //         $.each($that.koList, function (index, value) {
            //             MapUtils.viewer.dataSources.remove(value.remove);
            //         });
            //         $that.koList = {};
            //         $that._updateUploadList();
            //         $that.hasInitMark = false;
            //         $that.handler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_CLICK);
            //         $(".mark-popup").hide();
            //
            //         DrawGeometry.remove();
            //     });
            //
            //     function clearAll() {
            //         handlerDis && handlerDis.clear();
            //         handlerArea && handlerArea.clear();
            //     }
            //
            //     function deactiveAll() {
            //         handlerDis && handlerDis.deactivate();
            //         handlerArea && handlerArea.deactivate();
            //     }
            // },
            //
            // // 初始化标记点
            // _initMarker: function () {
            //     // 标记点集合
            //     var viewer = MapUtils.viewer;
            //
            //     $that.handler.setInputAction(function (click) {
            //         var pickedObject = MapUtils.viewer.scene.pick(click.position);
            //
            //         var clickPoint = MapUtils.viewer.scene.pickPosition(click.position);
            //         var pointWithHeight = Cesium.Cartographic.fromCartesian(clickPoint);
            //         // pointWithHeight.height += 300;
            //
            //         var lastPosition = viewer.scene.globe.ellipsoid.cartographicToCartesian(pointWithHeight);
            //         if (typeof pickedObject !== 'undefined' && pickedObject.id !== undefined && pickedObject.id.indexOf('mark') !== -1) {
            //             var content = $that._createPopupContent(pickedObject);
            //             $("#markPopupClose" + pickedObject.id).trigger('click');
            //             Popup.open({
            //                 content: content,
            //                 position: click.position,
            //                 offset: "top",
            //                 hasTriangle: true,
            //                 triangleOffset: "bottom",
            //                 hasClose: false
            //             });
            //             $("#markPopupClose" + pickedObject.id).on('click', function (e) {
            //                 Popup.close(e);
            //             });
            //             $("#markPopupSave" + pickedObject.id).on('click', function (e) {
            //                 pickedObject.name = $("#markPopupName" + pickedObject.id).val();
            //                 pickedObject.content = $("#markPopupContent" + pickedObject.id).val();
            //                 var temp = $that.koList[pickedObject.id];
            //                 temp.name = pickedObject.name;
            //                 delete $that.koList[pickedObject.id];
            //                 $that._createRBPane();
            //                 $that.koList[pickedObject.id] = temp;
            //                 $that._createRBPane();
            //             });
            //         } else {
            //             if (!$that.hasInitMark) {
            //                 var id = "mark" + _.uniqueId();
            //                 var remove = $that.billboards.add({
            //                     position: lastPosition,
            //                     image: './../../../global/widgets/smartSearch/defaultPhoto/biaoji_common.png',
            //                     verticalOrigin: Cesium.VerticalOrigin.BOTTOM,
            //                     id: id,
            //                     pixelOffset: new Cesium.Cartesian2(0, -5),
            //                     eyeOffset: new Cesium.Cartesian3(0, 0, -50)
            //                 });
            //                 $that.hasInitMark = true;
            //                 // 生成名称，定位，和移除方法3个内容组成的对象方便移除
            //                 var list = {};
            //                 list.id = id;
            //                 list.name = "请填写名称";
            //                 list.point = clickPoint;
            //                 list.removeMark = remove;
            //                 list.mark = true;
            //
            //                 $that.koList[list.id] = list;
            //
            //                 $(".mark-upload-result").show();
            //                 // 更新右侧列表
            //                 $that._createRBPane();
            //             }
            //         }
            //
            //     }, Cesium.ScreenSpaceEventType.LEFT_CLICK)
            //
            // },
            //
            // // 根据点击获得的属性生成popup窗
            // _createPopupContent: function (options) {
            //     var name, content;
            //     options.name === undefined ? name = "" : name = options.name;
            //     options.content === undefined ? content = "" : content = options.content;
            //     var result = "<div class='mark-popup'>" +
            //         "<i class='mark-popup-title'>标记</i><i class='icon-f-close1 mark-popup-close' title='关闭' id='markPopupClose" + options.id + "'></i>" +
            //         "<div class='mark-popup-content'>" +
            //         "<i>标题</i><div class='mark-popup-content-div'>" +
            //         "<input class='mark-popup-input' id='markPopupName" + options.id + "' value='" + name + "'></div>" +
            //         "<i>内容</i><div class='mark-popup-content-div'>" +
            //         "<input class='mark-popup-input' id='markPopupContent" + options.id + "'  value='" + content + "'></div>" +
            //         "<i>符号</i><div class='mark-popup-content-div'></div>" +
            //         "<i>附件</i><div class='mark-popup-content-div'></div>" +
            //         "<div><button class='layui-btn mark-popup-save' id='markPopupSave" + options.id + "'>保存</button></div>" +
            //         "</div></div>";
            //     return result;
            // },
            //
            // // 离开关闭监听事件
            // _closeHandler: function () {
            //     $that.handlerDis && $that.handlerDis.clear();
            //     $that.handlerArea && $that.handlerArea.clear();
            //     $that.handlerDis && $that.handlerDis.deactivate();
            //     $that.handlerArea && $that.handlerArea.deactivate();
            //     $that.billboards.removeAll();
            //     $that.hasInitMark = false;
            //     $that.handler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_CLICK);
            //     $(".mark-popup").hide();
            // },
            //
            // // 初始化上传事件
            // _initImport: function () {
            //     $("#fileMarkImportant").on('change', function () {
            //         Upload.loadFile($(this), "fileMarkImportant", $that.onComplete)
            //     });
            // },
            //
            // onComplete: function (data) {
            //     // 上图
            //     if (typeof data !== 'object') {
            //         data = JSON.parse(data);
            //     }
            //     var featureCollection = {};
            //     Upload.parseResult(data, featureCollection);
            //     var temp = {};
            //     temp.features = featureCollection.featureCollection.features;
            //     temp.type = featureCollection.featureCollection.type;
            //     var loadCollection;
            //     var promise = Cesium.GeoJsonDataSource.load(temp);
            //     promise.then(function (dataSource) {
            //         loadCollection = dataSource;
            //         MapUtils.viewer.dataSources.add(dataSource);
            //
            //         var entities = dataSource.entities.values;
            //         $.each(entities, function (index, value) {
            //             MapUtils.setEntityStyle(value)
            //         });
            //     });
            //     MapUtils.viewer.flyTo(promise);
            //
            //     var result = {};
            //     Upload.parseResult(data, result);
            //
            //     // 生成名称，定位，和移除方法3个内容组成的对象方便移除
            //     var list = {};
            //     list.id = _.uniqueId();
            //     list.name = result.fileName;
            //     list.location = promise;
            //     list.remove = loadCollection;
            //     list.upload = true;
            //
            //     $that.koList[list.id] = list;
            //
            //     $(".mark-upload-result").show();
            //     // 更新右侧列表
            //     $that._createRBPane();
            //     return true;
            // },
            //
            // _createUploadList: function () {
            //     var self = this;
            //     $that.ko = self;
            //     var temp = [];
            //      temp.push($that.koList[Object.keys($that.koList)[0]]);
            //     self.markResults = ko.observableArray(temp);
            //
            //     self.location = function (e) {
            //         MapUtils.viewer.flyTo(e.location);
            //     };
            //
            //     self.locationMark = function (e) {
            //         if ($that.lastBillboard) {
            //             $that.lastBillboard.image = "./../../../global/widgets/smartSearch/defaultPhoto/biaoji_common.png";
            //             $that.lastBillboard.image = "./../../../global/widgets/smartSearch/defaultPhoto/biaoji_common.png";
            //         }
            //         e.removeMark.image = "./../../../global/widgets/smartSearch/defaultPhoto/biaoji_choosed.png";
            //         $that.lastBillboard = e.removeMark;
            //         $that.entity = new Cesium.Entity({
            //             position: e.point,
            //             point: {
            //                 pixelSize: 0,
            //                 color: Cesium.Color.BLUE.withAlpha(0.9),
            //                 outlineColor: Cesium.Color.BLUE.withAlpha(0.9),
            //                 outlineWidth: 0
            //             }
            //         });
            //         MapUtils.viewer.entities.add($that.entity);
            //         MapUtils.viewer.flyTo($that.entity, {
            //             offset: {
            //                 heading: Cesium.Math.toRadians(0.0),
            //                 pitch: Cesium.Math.toRadians(-25),
            //                 range: 1000
            //             }
            //         });
            //         // MapUtils.viewer.entities.remove($that.entity);
            //     };
            //
            //     self.remove = function (e) {
            //         MapUtils.viewer.dataSources.remove(e.remove);
            //         delete $that.koList[e.id];
            //         $that._updateUploadList();
            //         if (Object.keys($that.koList).length === 0) {
            //             $(".mark-upload-result").hide();
            //         }
            //     };
            //
            //     self.removeMark = function (e) {
            //         $that.billboards.remove(e.removeMark);
            //         delete $that.koList[e.id];
            //         $that._updateUploadList();
            //         if (Object.keys($that.koList).length === 0) {
            //             $(".mark-upload-result").hide();
            //         }
            //     };
            //
            //     self.editMark = function (e) {
            //         // var pickedObject = e.editMark.pickedObject;
            //         // 点击生成的点可能在地表下，手动增加高度保证点击事件正常触发
            //         $that.entity = new Cesium.Entity({
            //             position: e.point,
            //             point: {
            //                 pixelSize: 0,
            //                 color: Cesium.Color.WHITE.withAlpha(0.9),
            //                 outlineColor: Cesium.Color.WHITE.withAlpha(0.9),
            //                 outlineWidth: 0
            //             }
            //         });
            //         MapUtils.viewer.entities.add($that.entity);
            //         MapUtils.viewer.flyTo($that.entity, {
            //             offset: {
            //                 heading: Cesium.Math.toRadians(0.0),
            //                 pitch: Cesium.Math.toRadians(-25),
            //                 range: 1000
            //             }
            //         }).then(function () {
            //             var temp = Cesium.Cartographic.fromCartesian(e.point);
            //             temp.height += 15;
            //             var tempPoint = MapUtils.viewer.scene.globe.ellipsoid.cartographicToCartesian(temp);
            //             var position = Cesium.SceneTransforms.wgs84ToWindowCoordinates(MapUtils.viewer.scene, tempPoint);
            //             var pickedObject = MapUtils.viewer.scene.pick(position);
            //             var content = $that._createPopupContent(pickedObject);
            //             $("#markPopupClose" + pickedObject.id).trigger('click');
            //             Popup.open({
            //                 content: content,
            //                 position: position,
            //                 offset: "top",
            //                 hasTriangle: true,
            //                 triangleOffset: "bottom",
            //                 hasClose: false
            //             });
            //             $("#markPopupClose" + pickedObject.id).on('click', function (e) {
            //                 Popup.close(e);
            //             });
            //             $("#markPopupSave" + pickedObject.id).on('click', function (e) {
            //                 pickedObject.name = $("#markPopupName" + pickedObject.id).val();
            //                 pickedObject.content = $("#markPopupContent" + pickedObject.id).val();
            //                 var temp = $that.koList[pickedObject.id];
            //                 temp.name = pickedObject.name;
            //                 delete $that.koList[pickedObject.id];
            //                 $that._createRBPane();
            //                 $that.koList[pickedObject.id] = temp;
            //                 $that._createRBPane();
            //             });
            //         });
            //
            //     }
            //
            // },
            //
            // _updateUploadList: function () {
            //     if ($that.ko) {
            //         var temp = [];
            //         $.each($that.koList, function (index, value) {
            //             temp.push(value)
            //         });
            //         // if (temp.length !== 0) {
            //         $that.ko.markResults(temp);
            //         // }
            //     }
            // },
            //
            // // 生成或更新面板
            // _createRBPane: function () {
            //     if ($that.ko !== undefined) {
            //         $that._updateUploadList();
            //     } else {
            //         ko.applyBindings(new $that._createUploadList(), document.getElementById("markUploadResult"));
            //     }
            // },
            //
            // // 关闭popup窗事件
            // _closeRightBottom: function () {
            // },
            //
            // // 关闭和切换面板事件
            // _closePane: function () {
            //     $that._closeHandler();
            //     WidgetUtils.closeRightPopup();
            //     $.each($that.koList, function (index, value) {
            //         $("#markPopupClose" + value.id).trigger('click');
            //         MapUtils.viewer.dataSources.remove(value.remove);
            //     });
            //     $that.koList = {};
            //     $that._updateUploadList();
            //     $that.ko = undefined
            // }

        };

    /**
     * get instance
     *
     * @returns {*}
     */
    me.getInstance = function () {
        if (void 0 === instance) {
            instance = me;
        }
        return instance;
    };
    return me;
});