/**
 *  图层控制
 *
 *  tpl配置可选(亮度 / 色调 / 饱和度 / 对比度 )
 *  透明度、可见为基本功能不需配置
 * @author by>cyj</a>
 * @version v1.0 2019/7/20/9:21  Copyright gtmap Corp
 */

define(['global/utils/MapUtils',
    'Cesium',
    'knockout',
    'global/core/CameraAndScale',
    'drag'
], function (MapUtils, Cesium, ko, Camera) {
    var instance,
        $that,
        me = {
            // init fun
            init: function () {
                $that = me;
                try {
                    // 拖拽插件使用
                    useDrag();
                    //imageLayer
                    $that._viewer = MapUtils.viewer;
                    $that._scene = MapUtils.viewer.scene;
                    $that._imageryLayers = MapUtils.viewer.scene.imageryLayers;
                    // 滑块参数管理配置
                    sliderType = this.config.manager;
                    //listener
                    addEvent();
                    // 过滤掉底图中没有id的图层并反转顺序
                    $that.tempLyrs.lyrs = filterLayer($that._imageryLayers._layers);
                    // bindind ko
                    ko.applyBindings(viewModel, document.getElementById("tool-layerList"));
                    viewModel.lyrList($that.tempLyrs.lyrs);
                    viewModel.managerList(sliderType);
                    // 初始化layui
                    initLayui($that.tempLyrs.lyrs);
                    cameraRemove();
                    // es6 proxy监听
                    // 监听到数据变化对对新增的数据刷新layui的控件
                    $that.tempLyrs = new Proxy($that.tempLyrs, {
                        set: function (receiver, property, value) {
                            //清空原有绑定数组
                            viewModel.lyrList([]);
                            //刷新时保留子图层的check状态缓存
                            $.each(receiver.lyrs, function (i, e) {
                                if (e.layers.length > 0) {
                                    $.each(value, function (j, k) {
                                        if (k.layerId === e.layerId) {
                                            k.layers = e.layers;
                                        }
                                    });
                                }
                            });
                            viewModel.lyrList(value);
                            form.render();
                            refreshSlider(value);
                            // 判断当前可见性
                            cameraRemove();
                            receiver[property] = value;
                            return Reflect.set(receiver, property, value);
                        }
                    });
                } catch (e) {
                    console.log(e)
                }
            },
            // open event
            onOpen: function () {
                //listener
                addEvent();
                //过滤掉底图中没有id的图层
                $that.tempLyrs.lyrs = filterLayer($that._imageryLayers._layers);
            },
            // close event
            onClose: function () {
                $.each($that._imageryLayers._layers, function (i, e) {
                    if (e.layerId) {
                        e.brightness = 1;
                        e.contrast = 1;
                        e.hue = 0;
                        e.saturation = 1;
                    }
                });
                moveEvent();
            },
            // pause event
            onPause: function () {
            },

            tempLyrs: {lyrs: []},

            sceneExtent: {},

            scale: 0
        };

    /*************************【参数】***********************************/

    var start = 0, end = 0, chooseId = ""; //拖拽变化值
    var form, layer, slider; //layui类
    var sliderType = []; // 参数类型

    /***********************【layui监听,业务代码】************************/

    function initLayui(data) {
        layui.use(['form', 'layer', 'slider'], function () {
            form = layui.form;
            layer = layui.layer;
            slider = layui.slider;
            form.render();
            refreshSlider(data);
            // 监听check框
            form.on('switch(switchLyr)', function (data) {
                var id = $(this)[0].id.split("check-")[1];
                var check = this.checked;
                $.each($that._imageryLayers._layers, function (i, e) {
                    if (e.layerId === id) {
                        // 重新刷新所有图层
                        if (check) {
                            e._imageryProvider._layers = "";
                        }
                        e.show = check;
                    }
                });
                // 更改子节点状态值
                $.each($that.tempLyrs.lyrs, function (i, e) {
                    if (e.layerId === id) {
                        $.each(e.layers, function (j, k) {
                            if (check) {
                                k.check = true;
                                $("#lyrSecond-" + id + "-" + k.id).prop("checked", true);
                            } else {
                                k.check = false;
                                $("#lyrSecond-" + id + "-" + k.id).prop("checked", false);
                            }
                        })
                    }
                });
                form.render();
            });
            // 子图层switch框
            form.on('switch(switchChildLyr)', function (data) {
                try {
                    var group = $(this)[0].id.split("-"), check = this.checked;
                    var id = group[1], index = group[2], temp = {};
                    var showTag = true;
                    var showIndex = [];
                    var checkLayer;
                    // 更改主服务check状态
                    if (check) {
                        $("#check-" + id).prop('checked', true);
                        form.render();
                    }
                    // 更改check状态值 取子图层的所有id
                    $.each($that.tempLyrs.lyrs, function (i, e) {
                        if (e.layerId === id) {
                            temp = e.childIndex;
                            e.layers.forEach(function (item) {
                                if (item.id.toString() === index) {
                                    item.defaultVisibility = check;
                                }
                                if (item.defaultVisibility) {
                                    showIndex.push(item.id);
                                }
                            })
                        }
                    });
                    // 给图层塞入子节点图层值
                    $.each($that._imageryLayers._layers, function (i, e) {
                        if (e.layerId === id) {
                            showTag = showIndex.length === 0 ? false : true
                            e._imageryProvider._layers = showIndex.join(",");
                            e.show = false;
                            checkLayer = e;
                        }
                    });
                    // 刷新图层
                    var showlyr = function () {
                        if (!showTag) {
                            $("#check-" + id).prop('checked', false);
                            form.render();
                            layer.msg('该服务下全部图层已关闭', {
                                time: 1000, //自动关闭
                                btn: false
                            });
                        } else {
                            checkLayer.show = true;
                        }
                    };
                    setTimeout(showlyr, 10);
                } catch (e) {
                }
            });
        });
    }

    // 根据图层中参数渲染滑块
    function refreshSlider(group) {
        var allSlider = JSON.parse(JSON.stringify(sliderType));
        allSlider.push({
            "name": "透明度",
            "label": "alpha"
        });
        $.each(group, function (i, e) {
            $.each(allSlider, function (j, k) {
                var key = k.label;
                slider.render({
                    elem: "#" + key + "-" + e.layerId,  // id
                    theme: '#2a80ff',                   // 主题
                    width: '70%',                        // 宽度
                    value: e[key] * 100,                // 初始的value值
                    min: 0,                              // 最小值
                    max: key === "alpha" ? 100 : 300,        // 最大值
                    id: e.layerId,                      // 供滑动时监听事件获取
                    disabled: e.disabled,               // 可用性
                    type: key,                          // 供滑动时监听事件获取
                    change: function (value) {
                        var id = this.id;
                        var type = this.type;
                        $.each($that._imageryLayers._layers, function (p, q) {
                            if (q.layerId === id) {
                                q[type] = value / 100;
                            }
                        });
                        $.each(viewModel.lyrList(), function (i, e) {
                            // 更新图层状态
                            if (e.layerId === id) {
                                var clone = e;
                                clone[type] = value / 100;
                                viewModel.lyrList.replace(e, clone);
                            }
                        });
                    }
                });
            });
        });
    }


    /***********************【注册knockout事件】**************************/

    function LayerList() {
        var self = this;
        self.lyrList = ko.observableArray([]);
        self.managerList = ko.observableArray([]);
        // 下拉菜单，判断动态服务进行请求
        self.clickmanager = function (btn) {
            var temp = self.clone(btn);
            var unfold = "icon-f-unfold", fold = "icon-f-fold",
                tag = "#fold-" + btn.layerId, param = "#lyrParam-" + btn.layerId;
            // 根据tag判断下拉状态
            if ($(tag).hasClass(unfold)) {
                $(tag).removeClass(unfold).addClass(fold);
                $(param).slideDown(200);
            } else {
                $(param).slideUp(200);
                $(tag).removeClass(fold).addClass(unfold);
            }
        };

        // 【用做ko更新数组某一项数据时的克隆，无需重新清空并绑定整个列表】
        self.clone = function (source) {
            var obj = {};
            for (var p in source)
                obj[p] = source[p];
            return obj;
        };

        // 【修改】
        self.changeVec = function (btn, event) {
            showManagerLayer(btn, event);
        }
    }

    var viewModel = new LayerList();

    /**********************【监听图层事件】******************************/

    function addEvent() {
        $that._imageryLayers.layerAdded.addEventListener(isAdded);
        $that._imageryLayers.layerMoved.addEventListener(isMoved);
        $that._imageryLayers.layerRemoved.addEventListener(isRemoved);
        $that._viewer.scene.camera.moveEnd.addEventListener(cameraRemove);
    }

    function moveEvent() {
        $that._imageryLayers.layerAdded.removeEventListener(isAdded);
        $that._imageryLayers.layerMoved.removeEventListener(isMoved);
        $that._imageryLayers.layerRemoved.removeEventListener(isRemoved);
        $that._viewer.scene.camera.moveEnd.removeEventListener(cameraRemove);
    }

    function isAdded() {
        $that.tempLyrs.lyrs = filterLayer($that._imageryLayers._layers);
    }

    function isMoved() {
    }

    function isRemoved() {
        $that.tempLyrs.lyrs = filterLayer($that._imageryLayers._layers);
    }


    /*过滤图层*/
    function filterLayer(lyr) {
        try {
            var arr = [];
            $.each(lyr, function (i, e) {
                // e.layerAlias=e.layerAlias||"未命名";
                var clone = {};
                if (e.layerAlias) {
                    clone.layerAlias = e.layerAlias;// 名称
                    clone.layerId = e.layerId;// id
                    clone.alpha = e.alpha;// 透明度
                    clone.check = e.show;// 可见
                    clone.brightness = e.brightness;
                    clone.contrast = e.contrast;
                    clone.hue = e.hue;
                    clone.saturation = e.saturation;
                    clone.dynamic = (e.hasOwnProperty("info") && e.info.hasOwnProperty("tileInfo")) ? false : true;// 是否动态图层
                    clone.url = e._imageryProvider._resource._url;// 服务地址
                    clone.layers = (e.hasOwnProperty("info") && e.info.hasOwnProperty("layers")) ? e.info.layers : []; // 子集图层
                    clone.manager = false;// 是否展示菜单列表
                    clone.childIndex = [];
                    clone.hasChildren = (clone.layers.length > 0 && clone.dynamic) ? true : false;
                    clone.vecTile = (e.ags_vt) ? false : false; // 矢量切片
                    clone.extent = e.extent;// 可见范围
                    clone.disabled = false;// 控制滑块可用
                    clone.minLevel = e.minLevel;// 最小范围

                    // 存放子图层id
                    clone.layers.forEach(function (e) {
                        clone.childIndex.push(e.id.toString());
                    });

                    arr.push(clone);
                }
            });
            return arr.reverse();
        } catch (e) {
            console.log(e);
            return [];
        }
    }

    /**
     * 相机移动
     */
    function cameraRemove() {
        try {
            // 范围对象
            $that.sceneExtent = {};

            // 读取图层的extent
            $that.sceneExtent = Camera.getCameraExtent();

            // 获取当前比例尺
            $that.scale = Camera.getCenterPoint().zoom;

            // 存储禁止
            var disableId = [];

            $.each(viewModel.lyrList(), function (i, e) {
                var clone = e;
                // // 当图层的可使高度低于屏幕高度时
                // if (e.extent && !e.dynamic) {
                //     // 判断可见
                //     clone.minLevel = clone.minLevel * 1;
                //     if(clone.minLevel !== 0 && (clone.minLevel >= $that.scale - 1) && (clone.minLevel <= $that.scale + 1)){
                //         // 判断是否超出
                //         clone.disabled =
                //             (e.extent.west > $that.sceneExtent.rectangle.east || e.extent.east < $that.sceneExtent.rectangle.west
                //                 || e.extent.north < $that.sceneExtent.rectangle.south || e.extent.south > $that.sceneExtent.rectangle.north) ? true : false
                //     }else if(clone.minLevel === 0){
                //         clone.disabled = false;
                //     }else {
                //         clone.disabled = true;
                //     }
                // }
                // // 动态图层只判断extent
                // else if(e.extent && e.dynamic) {
                //     clone.disabled =
                //         (e.extent.west > $that.sceneExtent.rectangle.east || e.extent.east < $that.sceneExtent.rectangle.west
                //             || e.extent.north < $that.sceneExtent.rectangle.south || e.extent.south > $that.sceneExtent.rectangle.north) ? true : false
                // }
                // 更新图层状态
                var disableDom = $("#" + clone.layerId);
                var disableCheckDom = $("#check-" + clone.layerId);
                if (clone.disabled) {
                    disableDom.find(".layers-pic").addClass("pic-disabled");
                    disableCheckDom.prop("disabled", true);
                    disableId.push(clone.layerId);
                } else {
                    disableDom.find(".layers-pic").removeClass("pic-disabled");
                    disableCheckDom.prop("disabled", false);
                }
                viewModel.lyrList.replace(e, clone);
            });
            form.render();
            refreshSlider(viewModel.lyrList());
            disableId.forEach(function (index) {
                $("#" + index).find(".layui-form-onswitch").addClass("switch-disabled");
            });
        } catch (error) {
            console.log(error)
        }
    }


    /************************【拖拽方式】************************************/
    function useDrag() {
        $('.layer-drag').DDSort({
            up: drag,
            down: getStart,
            moveTarget: '.layerlist-col',
            target: '.layui-list-title',
            delay: 50,
            floatStyle: {
                'border': '1px solid #ccc',
                'background-color': '#85ade8',
                'color': '#fff',
                'font-weight': '600',
                'transform': 'rotate(1deg)'
            }
        });
    }

    function getStart() {
        start = $(this).parent().parent().index();
        chooseId = $(this).parent().parent()[0].id;
    }

    // 改变图层顺序
    function drag() {
        try {
            //定义上下排序，图层改变索引，拖拽图层
            var dragLyr = [];
            end = this.index();
            //console.log("drag" + chooseId + "from:"+start +"-->" +end);
            var isRaise = (start > end) ? true : false;
            $.each($that._imageryLayers._layers, function (i, e) {
                if (e.layerId && e.layerId === chooseId) {
                    dragLyr = e;
                }
            });
            //按改变值raise或low
            for (var i = 0; i < Math.abs(end - start); i++) {
                (isRaise) ?
                    $that._imageryLayers.raise(dragLyr) :
                    $that._imageryLayers.lower(dragLyr);
            }

        } catch (e) {
        }
    }


    /****************************【更改矢量切片样式】*************************************/

    var vecStyleHtml = "<div class='vec-card'><div class='vec-tri'></div><div class='theme-content'>" +
        "<div class='vecCard-text'>更改样式:</div>" +
        "</div></div>";

    function showManagerLayer(btn, event) {
        $("#globalContainer").append(vecStyleHtml);
        $(".vec-card").css("left", event.pageX - 348 + "px").css("top", event.pageY - 110 + "px").css("display", "block");
    }


    /**
     * get instance
     *
     * @returns {*}
     */
    me.getInstance = function () {
        if (void 0 === instance) {
            instance = me;
        }
        return instance;
    };
    return me;
});