// configuration for the graph database access
define(function () {
    return {
        // if host is set, will override default localhost server option
        // 'host': "some_gremlin_server"
        'host': false,

        // For implementations like Neptune where only single commands are allowed per request
        // set to true
        'SINGLE_COMMANDS_AND_NO_VARS': false,

        // Time out for the REST protocol. Increase it if the graphDB is slow.
        'REST_TIMEOUT': 2000,
        // TODO: configuration for the secure server


        // Graph configuration
        'default_nb_of_layers': 1,
        'node_limit_per_request': 1000,

        // Simulation
        'force_strength': -400,
        'link_strength': 0.1,
        'force_x_strength': -0.01,
        'force_y_strength': -0.01,

        // Nodes
        'default_node_size': 40,
        'default_stroke_width': 12,
        'default_stroke_color': "#f5f5f5",
        'default_stroke_opacity': 0.5,
        // 'default_node_color': "#80E810",
        'default_node_color': "#F4606C",
        'active_node_margin': 0,
        'active_node_margin_opacity': 0.3,
        // Node position info in the DB
        // Replace by the key storing the node position inside the DB if any
        'node_position_x': 'graphexpx',
        'node_position_y': 'graphexpy',

        // Edges
        'default_edge_stroke_width': 2,
        'default_nodetext_color': "#fff",
        'default_nodetext_size': 18,
        'default_edge_color': "#ccc",
        'edge_label_color': "#CFD8DC",
        // Choose between curved (true) and straight edges (false).
        // If set to false, multiple edges between 2 nodes will all be straight and overlap.
        'use_curved_edges': false

    }
});