define([
    "knockout",
    'Cesium',
    "./Dict",
    "global/utils/MapUtils",
    "./description",
    "d3",
    '../../core/GeometryStore',
    "./graphConf",
    "./graphShapes",
    "./graph_viz",
    "./graphioGremlin",
    "css!lib/graphexp/css/graphStyle.css"
], function (ko, Cesium, Dict, MapUtils, Description, d3, store, graphConf, graphShapes, graph_viz, graphioGremlin) {
    var instance,
        $that,
        me = {

            // 存放字典表
            dict: {},

            //
            active: "",

            // 弹出框id
            popupId: "",

            // click后增加查询

            // 存放选择的tag
            searchTag: {},

            // 存放整理好的结果方便点击获得详情数据
            detailData: [],

            // layui弹出层
            layer: "",

            // 是否有layui弹出层，是否加延迟
            hasLayer: false,

            viewer: "",

            entity: "",

            // 上一个选中的查询结果ID
            lastSelectId: "",

            // 历史关联搜节点
            historyAssociatedIds: [],

            // 查询结果的knockout
            resultKo: "",

            // 全部查询结果，方便在点击图标时展示
            allResult: {},

            // pop窗是否已经打开
            ifPopup: false,

            // 点击查询结果是否缩放地图
            zoomSwitch: true,

            // 默认展示图片url
            defaultPhotoUrl: "url(/assets/images/defaultPhoto.png",

            // 选中图片
            selectedPhoto: "/global/widgets/smartSearch/defaultPhoto/biaoji_choosed.png",

            // 默认图片
            commonPhoto: "/global/widgets/smartSearch/defaultPhoto/biaoji_common.png",

            // 智能识别用到的鼠标监听
            identifyHandler: undefined,

            // 智能识别的配置和url
            identifyOptions: undefined,

            // 智能识别用到的点坐标
            identifyPoint: {},

            // 需要做数据对应的es图形数据
            esFeatures: [],

            // 输入查询接口配置
            urlInputOptions: {},

            init: function () {
                // console.log(store.get())
                // store.clear();
                // console.log(store.get())
                // 初始化存放一些全局变量读取配置
                $that = me;
                $that.dict = Dict.dict;
                $that.url = this.config.esUrl;
                $that.nameUrl = this.config.esNameUrl;
                $that.urlBool = this.config.esBoolUrl;
                $that.viewer = MapUtils.viewer;
                $that.poiEsInstanceId = this.config.poiEsInstanceId;
                $that.addressEsInstanceId = this.config.addressEsInstanceId;
                // $that.photoUrl = this.config.photoUrl;
                // $that.relatedUrl = this.config.relatedUrl;
                // $that.relatedIdUrl = this.config.relatedIdUrl;
                $that.storageUrl = this.config.storageUrl;
                $that.associatedList = this.config.associatedList;
                $that.propertyList = this.config.propertyList;
                $that.noContentList = this.config.noContentList;
                $that.relateUrl = this.config.relateUrl;
                $that.nearbyUrl = this.config.nearbyUrl;
                $that.geoAreaUrl = this.config.geoAreaUrl;
                window.graphShapes = graphShapes;
                window.graph_viz = graph_viz;
                window.graphioGremlin = graphioGremlin;

                $that.esFeatures = this.config.esFeatures;
                $that.identifyHandler = new Cesium.ScreenSpaceEventHandler($that.viewer.scene.canvas);
                $that.identifyOptions = this.config.identifyOptions;
                $that.urlInputOptions = this.config.urlInputOptions;
                $that.buildingOptions = this.config.buildingOptions;
                // 增加popup窗的div
                $that.createClickPopup();
                // 用ko进行选择面板的初始化
                $that.initClickEvent();
                $that.initLayui();

                $that.ajaxSuccessFunction(this.data)
            },

            // open event
            onOpen: function () {
                $that.returnToSelect();
                if ($that.identifyHandler) {
                    $that.identifyHandler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_CLICK);
                }
                $that.ajaxSuccessFunction(this.data);
            },
            // close event
            onClose: function () {
                $that.returnToSelect();
                if ($that.identifyHandler) {
                    $that.identifyHandler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_CLICK);
                }
            },

            // close event
            onPause: function () {
                $that.returnToSelect();
                if ($that.identifyHandler) {
                    $that.identifyHandler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_CLICK);
                }
            },

            // 初始化layui
            initLayui: function () {
                layui.use(['layer', 'carousel', 'form', 'laypage', 'element', 'table'], function () {
                    // 将分页存到全局中，方便查询结果后调用
                    $that.laypage = layui.laypage;
                    var layer = layui.layer;
                    $that.layer = layer;
                    var form = layui.form;
                    var carousel = layui.carousel;
                    $that.carousel = carousel;
                    var element = layui.element;
                    $that.element = element;
                    var table = layui.table;
                    $that.table = table;
                    // 点击详情展开面板
                    $that.active = {
                        offset: function (detailData) {
                            var type = "r";
                            $that.popupId = '#layerDemo' + type;
                            var title = "<span>" + detailData.name + "</span>";
                            var content = $that.createSearchDetailContent(detailData);
                            var left = screen.width - 309 + "px";
                            var top = $(".new-header-box").height() + $(".tool-widgets-pane").height() + 11 + "px";
                            var offSetTop = [top, left];

                            layer.open({
                                type: 1
                                , offset: offSetTop
                                , id: 'layerDemo' + type //防止重复弹出
                                , content: content
                                , maxWidth: 308
                                , title: [title, "background-color: rgba(67, 117, 253, 0.6);cursor: move;" +
                                "font-size: 1.3em;text-align: center;height: 90px;color: #fff;padding: 0;border-bottom: unset;background-image:url('/assets/images/bgPopupPanel.png')"]
                                // , btn: '关闭全部'
                                // , btnAlign: 'c' //按钮居中
                                , shade: 0 //不显示遮罩
                                , success: function () {
                                    if ($that.historyAssociatedIds.length > 1) {
                                        $('.search-right-pane-icon').hide();
                                        $('.search-right-pane-back').show();
                                        $('.fav_geo').hide();
                                    }
                                    $('.search-select-all').each(function () {
                                        var searchSelectCount = $(this).parent().parent().find('button').length;
                                        var searchSelectGeojsons = [];
                                        var searchSelectLocation = $(this);
                                        $(this).parent().parent().find('button').each(function () {
                                            $.ajax({
                                                url: $that.nearbyUrl + $(this).attr("dataid") + "?type=UUID"
                                            }).done(function (data) {
                                                try {
                                                    if (data.data.ownerV) {
                                                        var geojson = JSON.parse(data.data.ownerV.cordinate[0]);
                                                        if (geojson.type !== "" || geojson.type !== undefined)
                                                            searchSelectGeojsons.push(geojson);
                                                    }
                                                    searchSelectCount--;
                                                } catch (e) {
                                                    searchSelectCount--;
                                                }
                                                if (searchSelectCount === 0) {
                                                    var unitedGeojson = $that.getUnitedGeojson(searchSelectGeojsons);
                                                    $that.getGeojsonArea(unitedGeojson, searchSelectLocation.parent().find('.search-select-area'));
                                                }
                                            }).fail(function () {
                                                searchSelectCount--;
                                                if (searchSelectCount === 0) {
                                                    var unitedGeojson = $that.getUnitedGeojson(searchSelectGeojsons);
                                                    $that.getGeojsonArea(unitedGeojson, searchSelectLocation.parent().find('.search-select-area'));
                                                }
                                            });
                                        });
                                    });
                                    $('.search-right-pane-part .search-text-text,.search-right-pane-part .layui-btn-container').each(function () {
                                        if ($(this).height() > 60) {
                                            $(this).addClass('wrap');
                                            $(this).parents('.search-right-pane-part').find('.icon-f-unfold').show();
                                        }
                                    });
                                    table.init('buildingInfoTable', {
                                        width: 'auto',
                                        id: 'buildingInfoTable'
                                    });
                                }
                                , yes: function () {
                                    layer.closeAll();
                                }
                                , cancel: function () {
                                    $that.hasLayer = false;
                                    if ($that.removeEntity) {
                                        MapUtils.setAllStyle($that.removeEntity.entities.values);
                                    }
                                    if ($that.removeRelatedEntity) {
                                        $that.viewer.dataSources.remove($that.removeRelatedEntity);
                                        $that.removeRelatedEntity = null;
                                    }
                                    layer.closeAll();
                                    $($that.lastSelectId).removeClass("search-result-index-active");
                                }
                            });

                            element.on('tab(search-right-pane-overflow)', function () {
                                $('.search-right-pane-part .search-text-text,.search-right-pane-part .layui-btn-container').each(function () {
                                    if ($(this).height() > 60) {
                                        $(this).addClass('wrap');
                                        $(this).parents('.search-right-pane-part').find('.icon-f-unfold').show();
                                    }
                                });
                            });

                            $that.layer.photos({
                                photos: '#defaultPhoto'
                                , anim: 5
                            });
                            $('.card-container-1').on('click', function () {
                                var cc1 = $('.card-container-1');
                                var disappear = {
                                        top: '40px',
                                        opacity: '0'
                                    },
                                    appear = {
                                        top: '0',
                                        opacity: '1'
                                    };
                                var firstCard = cc1.children('.card').first();
                                firstCard.css(disappear);
                                var x = setTimeout(function () {
                                    //firstCard.remove();
                                    firstCard.css(appear);
                                    $('.card-container-1').append(firstCard);
                                }, 200);
                            })
                            // $that.carousel.render({
                            //     elem: '#defaultPhoto'
                            //     , width: '250px'
                            //     , height: '250px'
                            //     , interval: 5000
                            // });
                            $($($that.popupId).parent().find('a')[0])
                                .removeClass('layui-layer-ico').addClass('icon-f-close').css('color', '#ffffff')
                                .css('top', '-5px').css('font-size', '20px').attr('title', '关闭面板');
                        },
                        showGraph: function (name) {
                            $that.graphPopupId = '#layerDemoGraph';

                            layer.open({
                                type: 1
                                , offset: 'auto'
                                , id: 'layerDemoGraph' //防止重复弹出
                                , content: '<div class="defaultGraph"><svg></svg></div>'
                                , area: ['1600px', '800px']
                                , resize: false
                                // , title: [title, "background-color: rgba(67, 117, 253, 0.6);cursor: move;" +
                                // "font-size: 1.3em;text-align: center;height: 90px;color: #fff;padding: 0;border-bottom: unset;background-image:url('/assets/images/bgPopupPanel.png')"]
                                , title: false
                                // , btn: '关闭全部'
                                // , btnAlign: 'c' //按钮居中
                                , shade: 0.7 //不显示遮罩
                                , shadeClose: true
                                , yes: function () {
                                }
                                , cancel: function () {
                                }
                            });
                            $($($that.graphPopupId).parent().find('a')[0])
                                .removeClass('layui-layer-ico').addClass('icon-f-close').css('color', '#ffffff')
                                .css('top', '-5px').css('right', '-20px').css('font-size', '20px').attr('title', '关闭面板');
                            setTimeout(function () {
                                graph_viz.init('.defaultGraph');
                                graph_viz.addzoom();
                                var ini_gremlin_query = 'nodes = g.V().has("name","' + name +
                                    '").as("node").both().as("node").select(all,"node").inject( g.V().has("name","' +
                                    name + '")).unfold();edges = g.V().has("name","' + name +
                                    '").bothE();[nodes.toList(),edges.toList()]';
                                graphioGremlin.search_query(ini_gremlin_query, true);
                            }, 500);
                        }
                    };
                    form.render();


                });
            },

            // 初始化点击事件
            initClickEvent: function () {
                // 绑定两个不同的输入框的事件
                // 因为onchange事件会导致importTag触发两次搜索事件，所以用onAddTag监听，在每次置空后增加返回事件
                // $("#searchInput").tagsInput({
                //     'defaultText': '请输入或选择搜索内容',
                //     'onAddTag': function () {
                //         setTimeout(function () {
                //             $that.searchAjax();
                //         }, 100);
                //     },
                //     'onRemoveTag': $that.returnToSelect
                // });

                // 绑定智能识别事件
                $(".search-input-icon").on('click', function () {
                    // $that.searchAjax();
                    $that.setIdentifyAction()
                });

                // 绑定返回事件的事件
                $(".search-result-back").on('click', function () {
                    $that.returnToSelect();
                });

                // poi查询更多按钮的事件
                // $("#searchMoreSelect").on('click', function (e) {
                //     $(".search-select").css("overflow-y", "auto");
                //     $(".search-select").css("overflow-x", "hidden");
                //     if (screen.width === 1920) {
                //         $(".search-select").css("height", "470px");
                //     } else {
                //         $(".search-select").css("height", "365px");
                //     }
                //     $(".search-hide-button").empty();
                // });

                // 点击展示关联节点属性
                $(document).on('click', '.search-associated-contentname', function () {
                    $that.historyAssociatedIds.push($(this).attr('dataid'));
                    $that.createAssocitedData($(this).attr('dataid'));
                });

                $(document).on('click', '.search-associated-nocontent', function () {
                    $.ajax({
                        url: $that.nearbyUrl + $(this).attr("dataid") + "?type=UUID"
                    }).done(function (data) {
                        try {
                            if (data.data.ownerV) {
                                var geojson = JSON.parse(data.data.ownerV.cordinate[0]);
                                if (geojson.type !== "" || geojson.type !== undefined) {
                                    $that.createPolygon(geojson);
                                }
                            } else {
                                layui.use(['layer'], function () {
                                    layui.layer.msg("查询无结果");
                                });
                            }
                        } catch (e) {
                            layui.use(['layer'], function () {
                                layui.layer.msg("查询无结果");
                            });
                        }
                    }).fail(function () {
                        layui.use(['layer'], function () {
                            layui.layer.msg("查询无结果");
                        });
                    });
                });

                // $(document).on('click', '.imageList', function () {
                //     $that.layer.photos({
                //         photos: '.imageList'
                //         , anim: 5
                //     });
                // });

                // $(document).on('click', '.search-photo-big', function () {
                //     $that.layer.photos({
                //         photos: '.imageList'
                //         , anim: 5
                //     });
                // });

                // 点击展示知识图谱
                $(document).on('click', '.search-related-graph', function () {
                    $that.active["showGraph"].call(this, $(this).attr("dataname"));
                });

                // 点击折叠/展开更多信息
                $(document).on('click', '.search-text-title > .icon-f-unfold', function () {
                    $(this).parent().parent().find('.search-text-text').removeClass('wrap');
                    $(this).parent().parent().find('.layui-btn-container').removeClass('wrap');
                    $(this).removeClass('icon-f-unfold');
                    $(this).addClass('icon-f-fold');
                });

                $(document).on('click', '.search-text-title > .icon-f-fold', function () {
                    $(this).parent().parent().find('.search-text-text').addClass('wrap');
                    $(this).parent().parent().find('.layui-btn-container').addClass('wrap');
                    $(this).removeClass('icon-f-fold');
                    $(this).addClass('icon-f-unfold');
                });

                // 点击展开更多直属单位
                $(document).on('click', '.search-result-subordinate-more', function () {
                    if ($(this).parent().find('.search-result-subordinate').hasClass('search-result-subordinate-wrap')) {
                        $($(this).parent().find('.search-result-subordinate')).removeClass('search-result-subordinate-wrap');
                        $(this).html('收起')
                    } else {
                        $($(this).parent().find('.search-result-subordinate')).addClass('search-result-subordinate-wrap');
                        $(this).html('展开更多');
                    }
                });

                // 点击直属单位面板下节点
                $(document).on('click', '.search-result-subordinate-content > .search-associated-contentname', function () {
                    $that.layer.closeAll();
                    $that.closePopup();
                    if ($that.lastSelectId !== "") {
                        $($that.lastSelectId).removeClass("search-result-index-active");
                    }
                    if ($that.removeRelatedEntity) {
                        $that.viewer.dataSources.remove($that.removeRelatedEntity);
                        $that.removeRelatedEntity = null;
                    }
                    $that.historyAssociatedIds = [];
                    $($(this).attr("parentId")).addClass("search-result-index-active");
                    $that.lastSelectId = $(this).attr("parentId");
                    $that.historyAssociatedIds.push($(this).attr('dataid'));
                });

                // 智能检索详细信息返回按钮
                $(document).on('click', '.search-right-pane-back', function () {
                    if ($that.historyAssociatedIds.length > 2) {
                        $that.historyAssociatedIds.pop();
                        $that.createAssocitedData($that.historyAssociatedIds[$that.historyAssociatedIds.length - 1]);
                    } else if ($that.historyAssociatedIds.length === 2) {
                        $that.historyAssociatedIds.pop();
                        $($that.historyAssociatedIds[$that.historyAssociatedIds.length - 1]).find('.search-result-main').trigger('click');
                    }
                });

                // 点击知识图谱面板信息标题集合展示
                $(document).on('click', '.search-select-all', function () {
                    var searchSelectCount = $(this).parent().parent().find('button').length;
                    var searchSelectGeojsons = [];
                    $(this).parent().parent().find('button').each(function () {
                        $.ajax({
                            url: $that.nearbyUrl + $(this).attr("dataid") + "?type=UUID"
                        }).done(function (data) {
                            try {
                                if (data.data.ownerV) {
                                    var geojson = JSON.parse(data.data.ownerV.cordinate[0]);
                                    if (geojson.type !== "" || geojson.type !== undefined)
                                        searchSelectGeojsons.push(geojson);
                                }
                                searchSelectCount--;
                            } catch (e) {
                                searchSelectCount--;
                            }
                            if (searchSelectCount === 0) {
                                var unitedGeojson = $that.getUnitedGeojson(searchSelectGeojsons);
                                $that.createPolygon(unitedGeojson);
                            }
                        }).fail(function () {
                            searchSelectCount--;
                            if (searchSelectCount === 0) {
                                var unitedGeojson = $that.getUnitedGeojson(searchSelectGeojsons);
                                $that.createPolygon(unitedGeojson);
                            }
                        });
                    });
                });

                // 鼠标悬浮至更多按钮时的事件
                $(document).on("mouseover", ".search-result-more", function () {
                    $($(this).find('img')).show();
                    $($(this).find('span')).hide();
                    $(this).css('width', "26%");
                    $($(this).parent().children()[0]).css('width', '70%')
                });
                $(document).on("mouseout", ".search-result-more", function () {
                    $($(this).find('img')).hide();
                    $($(this).find('span')).show();
                    $(this).css('width', "13%");
                    $($(this).parent().children()[0]).css('width', '85%')
                });

                $(document).on('click', '.search-input-clear', function () {
                    $that.returnToSelect();
                });

                $(document).on('click', '.fav_geo', function () {
                    $that.favGeo = $that.layer.open({
                        type: 1,
                        title: "输入别名",
                        shadeClose: true,
                        maxmin: false,
                        area: ['340px', '180px'],
                        content: $("#fav_geo_win").html()
                    });
                    $(".saveFavGeo").data($that.searchResultElement);
                });

                $(document).on("click", ".saveFavGeo", function (e) {
                    var geoData = $(e.currentTarget).data();
                    if ($("[name=tmp_layer_name]").val()) {
                        var tmp = {};
                        tmp.type = "feature";
                        tmp.id = geoData.id;
                        tmp.label = $("[name=tmp_layer_name]").val();
                        tmp.feature = geoData;
                        store.set(tmp);
                        layer.close($that.favGeo);
                        layer.msg("保存成功");
                    } else {
                        layer.msg("请输入别名");
                    }
                });
            },

            // 生成查询面板


            // 生成右侧layui的结果展示面板
            createSearchDetailContent: function (data) {
                var content = "<i class='icon-f-back search-right-pane-back'></i><div class='search-right-pane'>";
                if (graphEnable) {
                    switch (data.__index) {
                        case data.__index ? (data.__index.match(/^poi/) || {}).input : "poi":
                            // 面板展示字段
                            var defaultTitle = $that.createDefaultTitle(data);
                            // 生成图片div，如果有则显示，如果没有则默认循环
                            var defaultPhoto = $that.createDefaultPhoto(data);
                            // 生成概况，按市读取
                            var defaultDescription = $that.createDescription(data);
                            // 生成关联搜页面
                            var associated = $that.createAssociated(data);
                            // 生成周边搜页面
                            var surround = $that.createSurround();
                            // 生成知识图谱页面
                            var graph = $that.createGraph(data);
                            // 生成属性列表
                            var properties = $that.createPropertiesList(data);

                            var titlepart = "";
                            var contentpart = "";

                            content += defaultTitle + '<div class="search-right-pane-overflow layui-tab layui-tab-card" lay-filter="search-right-pane-overflow">';
                            if (defaultTitle + defaultPhoto + defaultDescription + properties + surround + associated + graph !== "") {
                                titlepart += '<ul class="layui-tab-title">';
                                contentpart += '<div class="layui-tab-content">';
                                if (defaultDescription + defaultPhoto + properties + surround !== "") {
                                    titlepart += '<li class="layui-this layui-col-xs4"><i class="iconfont icon-f-excalmation-mark">&nbsp;信息</i></li>';
                                    contentpart += '<div class="layui-tab-item layui-show">' + defaultDescription + defaultPhoto + properties + surround + '</div>';
                                    if (associated !== "") {
                                        titlepart += '<li class="layui-col-xs4"><i class="iconfont icon-f-location1">&nbsp;附近</i></li>';
                                        contentpart += '<div class="layui-tab-item">' + associated + '</div>';
                                    }
                                    if (graph !== "") {
                                        titlepart += '<li class="layui-col-xs4"><i class="iconfont icon-f-graph2">&nbsp;相关</i></li>';
                                        contentpart += '<div class="layui-tab-item">' + graph + '</div>';
                                    }
                                } else {
                                    if (associated !== "") {
                                        titlepart += '<li class="layui-this layui-col-xs4"><i class="iconfont icon-f-location1">&nbsp;附近</i></li>';
                                        contentpart += '<div class="layui-tab-item layui-show">' + associated + '</div>';
                                        if (graph !== "") {
                                            titlepart += '<li class="layui-col-xs4"><i class="iconfont icon-f-graph2">&nbsp;相关</i></li>';
                                            contentpart += '<div class="layui-tab-item">' + graph + '</div>';
                                        }
                                    } else {
                                        if (graph !== "") {
                                            titlepart += '<li class="layui-this layui-col-xs4"><i class="iconfont icon-f-graph2">&nbsp;相关</i></li>';
                                            contentpart += '<div class="layui-tab-item layui-show">' + graph + '</div>';
                                        }
                                    }
                                }
                                titlepart += '</ul>';
                                contentpart += '</div>';
                            }

                            content += titlepart + contentpart;

                            if (data.name) {
                                content += '<span class="search-related-graph search-result-graph" dataname="' + data.name +
                                    '"><i class="iconfont icon-f-graph2" style="color: #ffffff;font-size: 18px"></i></span>';
                            }
                            content += '<i class="iconfont fav_geo icon-f-tool-mark" title="收藏至历史图层"></i>';
                            content += '</div>';
                            break;
                        case "js_xzq":
                        case "shuiku":
                        case "gonglu":
                        case "school_all":
                        case "sghp":
                        case "resa":
                            // 生成属性列表
                            var properties = $that.createPropertiesList(data);
                            // 生成关联搜页面
                            var associated = $that.createAssociated(data);
                            // 生成周边搜页面
                            var surround = $that.createSurround();
                            // 生成知识图谱页面
                            var graph = $that.createGraph(data);
                            // 生成房产信息
                            var buildingInfo = $that.createBuildingInfo(data);

                            var titlepart = "";
                            var contentpart = "";

                            content += '<div class="search-right-pane-overflow layui-tab layui-tab-card" lay-filter="search-right-pane-overflow">';
                            if (properties + surround + associated + graph + buildingInfo !== "") {
                                titlepart += '<ul class="layui-tab-title">';
                                contentpart += '<div class="layui-tab-content">';
                                if (buildingInfo + properties + surround !== "") {
                                    titlepart += '<li class="layui-this"><i class="iconfont icon-f-excalmation-mark">&nbsp;信息</i></li>';
                                    contentpart += '<div class="layui-tab-item layui-show">' + buildingInfo + properties + surround + '</div>';
                                    if (associated !== "") {
                                        titlepart += '<li><i class="iconfont icon-f-location1">&nbsp;附近</i></li>';
                                        contentpart += '<div class="layui-tab-item">' + associated + '</div>';
                                    }
                                    if (graph !== "") {
                                        titlepart += '<li><i class="iconfont icon-f-graph2">&nbsp;相关</i></li>';
                                        contentpart += '<div class="layui-tab-item">' + graph + '</div>';
                                    }
                                } else {
                                    if (associated !== "") {
                                        titlepart += '<li class="layui-this"><i class="iconfont icon-f-location1">&nbsp;附近</i></li>';
                                        contentpart += '<div class="layui-tab-item layui-show">' + associated + '</div>';
                                        if (graph !== "") {
                                            titlepart += '<li><i class="iconfont icon-f-graph2">&nbsp;相关</i></li>';
                                            contentpart += '<div class="layui-tab-item">' + graph + '</div>';
                                        }
                                    } else {
                                        if (graph !== "") {
                                            titlepart += '<li class="layui-this"><i class="iconfont icon-f-graph2">&nbsp;相关</i></li>';
                                            contentpart += '<div class="layui-tab-item layui-show">' + graph + '</div>';
                                        }
                                    }
                                }
                                titlepart += '</ul>';
                                contentpart += '</div>';
                            }

                            content += titlepart + contentpart;

                            if (data.name) {
                                content += '<span class="search-related-graph search-result-graph" dataname="' + data.name +
                                    '"><i class="iconfont icon-f-graph2" style="color: #ffffff;font-size: 16px"></i></span>';
                            }
                            content += '<i class="iconfont fav_geo icon-f-tool-mark" title="收藏至历史图层"></i>';
                            content += '</div>';
                            break;
                        default:
                            // 生成属性列表
                            var properties = $that.createPropertiesList(data);
                            // 生成关联搜页面
                            var associated = $that.createAssociated(data);
                            // 生成周边搜页面
                            var surround = $that.createSurround();
                            // 生成知识图谱页面
                            var graph = $that.createGraph(data);

                            var titlepart = "";
                            var contentpart = "";

                            content += '<div class="search-right-pane-overflow layui-tab layui-tab-card" lay-filter="search-right-pane-overflow">';
                            if (properties + surround + associated + graph !== "") {
                                titlepart += '<ul class="layui-tab-title">';
                                contentpart += '<div class="layui-tab-content">';
                                if (properties + surround !== "") {
                                    titlepart += '<li class="layui-this"><i class="iconfont icon-f-excalmation-mark">&nbsp;信息</i></li>';
                                    contentpart += '<div class="layui-tab-item layui-show">' + properties + surround + '</div>';
                                    if (associated !== "") {
                                        titlepart += '<li><i class="iconfont icon-f-location1">&nbsp;附近</i></li>';
                                        contentpart += '<div class="layui-tab-item">' + associated + '</div>';
                                    }
                                    if (graph !== "") {
                                        titlepart += '<li><i class="iconfont icon-f-graph2">&nbsp;相关</i></li>';
                                        contentpart += '<div class="layui-tab-item">' + graph + '</div>';
                                    }
                                } else {
                                    if (associated !== "") {
                                        titlepart += '<li class="layui-this"><i class="iconfont icon-f-location1">&nbsp;附近</i></li>';
                                        contentpart += '<div class="layui-tab-item layui-show">' + associated + '</div>';
                                        if (graph !== "") {
                                            titlepart += '<li><i class="iconfont icon-f-graph2">&nbsp;相关</i></li>';
                                            contentpart += '<div class="layui-tab-item">' + graph + '</div>';
                                        }
                                    } else {
                                        if (graph !== "") {
                                            titlepart += '<li class="layui-this"><i class="iconfont icon-f-graph2">&nbsp;相关</i></li>';
                                            contentpart += '<div class="layui-tab-item layui-show">' + graph + '</div>';
                                        }
                                    }
                                }
                                titlepart += '</ul>';
                                contentpart += '</div>';
                            }

                            content += titlepart + contentpart;

                            if (data.name) {
                                content += '<span class="search-related-graph search-result-graph" dataname="' + data.name +
                                    '"><i class="iconfont icon-f-graph2" style="color: #ffffff;font-size: 16px"></i></span>';
                            }
                            content += '<i class="iconfont fav_geo icon-f-tool-mark" title="收藏至历史图层"></i>';
                            content += '</div>';
                            break;
                    }
                } else {
                    switch (data.__index) {
                        case data.__index ? (data.__index.match(/^poi/) || {}).input : "poi":
                            // 面板展示字段
                            var defaultTitle = $that.createDefaultTitle(data);
                            // 生成图片div，如果有则显示，如果没有则默认循环
                            var defaultPhoto = $that.createDefaultPhoto(data);
                            // 生成概况，按市读取
                            var defaultDescription = $that.createDescription(data);
                            // 生成周边搜页面
                            // var surround = $that.createSurround();
                            // 生成属性列表
                            var properties = $that.createPropertiesList(data);
                            content += defaultTitle + '<div class="search-right-pane-overflow">' + defaultDescription +
                                defaultPhoto + properties + '<i class="iconfont fav_geo icon-f-tool-mark" title="收藏至历史图层"></i></div>';
                            break;
                        case "js_xzq":
                        case "shuiku":
                        case "gonglu":
                        case "school_all":
                        case "sghp":
                            // 生成属性列表
                            var properties = $that.createPropertiesList(data);
                            // // 生成周边搜页面
                            // var surround = $that.createSurround();

                            content += '<div class="search-right-pane-overflow">' + properties + '</div>';
                            content += '<i class="iconfont fav_geo icon-f-tool-mark" title="收藏至历史图层"></i>';
                            break;
                        default:
                            // 生成属性列表
                            var properties = $that.createPropertiesList(data);
                            // // 生成周边搜页面
                            // var surround = $that.createSurround();

                            content += '<div class="search-right-pane-overflow">' + properties +
                                '<i class="iconfont fav_geo icon-f-tool-mark" title="收藏至历史图层"></i></div>';

                            break;
                    }
                }
                return content + "</div>";
            },



            // 查询方法多处调用，摘出统一使用
            searchResult: function (haveCode) {
                var url;
                if (haveCode === "urlBool") {
                    url = $that.urlBool;
                } else if (haveCode === "urlInput") {
                    url = $that.url;
                } else if (haveCode === "urlIdentify") {
                    url = $that.identifyOptions.url;
                }

                $.ajax({
                    url: url,
                    type: 'GET',
                    dataType: 'json',
                    traditional: true,
                    async: true,
                    data: $that.options,
                    timeout: 1000 * 60 * 10,
                    success: function (data) {
                        if (data.count === 0) {
                            $that.returnToSelect();
                            $that.layer.msg('查询无结果', {
                                time: 2000
                            });

                        } else {
                            // 移除上一次查询留下的结果
                            $that.removeDetailShow();
                            $that.closePopup();
                            $that.ajaxSuccessFunction(data);
                            $("#searchResultPageTotal").text(data.count);
                            if (data.totalPage > 100)
                                $that.pageGroup = 3;
                            else
                                $that.pageGroup = 4;
                            $that.laypage.render({
                                elem: 'searchResultPageGroup'
                                , count: data.count //数据总数，从服务端得到
                                , theme: '#4576FD'
                                , groups: $that.pageGroup
                                , prev: "<"
                                , next: ">"
                                , limit: $that.pageSize
                                , curr: data.currentPage
                                , jump: function (obj, first) {
                                    // 首次不执行
                                    if (!first) {
                                        $that.options.pageIndex = obj.curr;
                                        $.ajax({
                                            url: url,
                                            type: 'GET',
                                            dataType: 'json',
                                            traditional: true,
                                            async: true,
                                            data: $that.options,
                                            timeout: 1000 * 60 * 10,
                                            success: function (data) {
                                                if (data.count === 0) {
                                                    $that.returnToSelect();
                                                    $that.layer.msg('查询无结果', {
                                                        time: 2000
                                                    });
                                                } else {
                                                    $that.removeDetailShow();
                                                    $that.ajaxSuccessFunction(data);
                                                }
                                            }
                                        });
                                    }
                                }
                            });
                        }
                    }
                });
            },

            // 返回并清空所有地图结果
            returnToSelect: function () {
                $that.viewer.scene.camera.moveEnd.removeEventListener($that.searchOnMove);
                $that.zoomSwitch = true;
                $(".search-select").css("display", "block");
                $(".search-result-pane").css("display", "none");
                $(".search-hide-button").css("display", "block");
                // switch暂时隐藏
                // $(".search-add-switch-form").css("display", "inline-block");
                $(".search-poi-switch-form").css("display", "inline-block");
                $that.removeDetailShow();
                $that.closePopup();
                $("#searchInput").val("");
                $('.search-input-clear').hide();
            },

            // 移除查询后地图展示内容
            removeDetailShow: function () {
                if ($that.billboards) {
                    $that.billboards.removeAll();
                }
                if ($that.entity) {
                    $that.viewer.entities.remove($that.entity);
                    $that.entity = null;
                }
                // 重置各种选中值
                if ($that.selectedBillboard)
                    $that.selectedBillboard = null;
                if ($that.lastLocationLine)
                    $that.lastLocationLine = null;
                if ($that.lastLocationPolygon)
                    $that.lastLocationPolygon = null;
                if ($that.removeEntity) {
                    $that.viewer.dataSources.remove($that.removeEntity);
                    $that.removeEntity = null;
                }
                if ($that.removeRelatedEntity) {
                    $that.viewer.dataSources.remove($that.removeRelatedEntity);
                    $that.removeRelatedEntity = null;
                }
                $that.layer.closeAll();
                $that.hasLayer = false;
            },

            // 处理ajax请求后的显示隐藏和数据处理
            ajaxSuccessFunction: function (data) {
                $("#identifyResultPageTotal").text(data.count);
                $(".search-result-pane").css("display", "block");
                $(".search-hide-button").css("display", "none");
                // $(".search-add-switch-form").css("display", "none");
                $(".search-poi-switch-form").css("display", "none");
                $("#searchResultPage").show();
                if (data.count < $that.pageSize) {
                    $(".search-result-hide-div").hide();
                    $("#searchResultPage").hide();
                } else if (data.data[0].features.length < $that.pageSize && data.totalPage !== data.currentPage) {
                    $(".search-result-hide-div").hide();
                    $("#searchResultPage").hide();
                } else if (data.data[0].features.length === $that.pageSize && $that.hideResult === true) {
                    $(".search-result-hide-div").css("display", "flex");
                }

                var temp = [];
                $.each(data.data[0].features, function (index, value) {
                    if (value.properties.score_new > 10) {
                        temp.push(value);
                    }
                });
                if (temp.length > 0 && temp.length < $that.pageSize
                    && $that.hideResult === true && data.data[0].features.length !== temp.length) {
                    data.data[0].features = temp;
                    $("#searchResultPage").hide();
                    $(".search-result-hide-div").css("display", "flex");
                    $("#searchResultShowMore").on('click', function () {
                        $that.hideResult = false;
                        $that.searchResult("urlInput");
                        $(".search-result-hide-div").hide();
                        setTimeout(function () {
                            $("#searchResultPage").show();
                        }, 500);
                    })
                } else
                    $(".search-result-hide-div").hide();

                $that.dealWithData(data);
                // 监听点击事件
                $that.setInputAction();
            },

            // 处理数据，方便展示
            dealWithData: function (data) {
                $that.allResult = {};

                $that.billboards = $that.viewer.scene.primitives.add(new Cesium.BillboardCollection());
                var layerFeatures = [];
                $.each(data.data[0].features, function (index, value) {
                    switch (value.properties.__index) {
                        case "js_xzq":
                            value.properties.photoUrl = "url(/assets/images/defaultPhoto-xzq.png)";
                            $.each($that.esFeatures, function (i, val) {
                                if (val.index === "js_xzq") {
                                    value.properties.INDEXLABEL = val.INDEXLABEL;
                                }
                            });
                            break;
                        case "shuiku":
                            value.properties.photoUrl = "url(/assets/images/defaultPhoto-shuiku.png)";
                            $.each($that.esFeatures, function (i, val) {
                                if (val.index === "shuiku") {
                                    value.properties.INDEXLABEL = val.INDEXLABEL;
                                }
                            });
                            break;
                        case "gonglu":
                            value.properties.photoUrl = "url(/assets/images/defaultPhoto-gonglu.png)";
                            $.each($that.esFeatures, function (i, val) {
                                if (val.index === "gonglu") {
                                    value.properties.INDEXLABEL = val.INDEXLABEL;
                                }
                            });
                            break;
                        case "school_all":
                            value.properties.photoUrl = "url(/assets/images/defaultPhoto-xuexiao.png)";
                            $.each($that.esFeatures, function (i, val) {
                                if (val.index === "school_all") {
                                    value.properties.INDEXLABEL = val.INDEXLABEL;
                                }
                            });
                            break;
                        case "sghp":
                            value.properties.photoUrl = "url(/assets/images/defaultPhoto-hupo.png)";
                            $.each($that.esFeatures, function (i, val) {
                                if (val.index === "sghp") {
                                    value.properties.INDEXLABEL = val.INDEXLABEL;
                                }
                            });
                            break;
                        case "resa":
                            value.properties.photoUrl = "url(/assets/images/defaultPhoto.png)";
                            $.each($that.esFeatures, function (i, val) {
                                if (val.index === "resa") {
                                    value.properties.INDEXLABEL = val.INDEXLABEL;
                                }
                            });
                            break;
                        case data.__index ? (data.__index.match(/^poi/) || {}).input : "poi":
                        default:
                            // value.properties.photoUrl = $that.defaultPhotoUrl;
                            switch (value.geometry.type) {
                                case "Point":
                                case "MultiPoint":
                                    value.properties.photoUrl = "url(/assets/images/defaultPoint.png)";
                                    break;
                                case "Polygon":
                                case "MultiPolygon":
                                    value.properties.photoUrl = "url(/assets/images/defaultPolygon.png)";
                                    break;
                                case "LineString":
                                case "MultiLineString":
                                    value.properties.photoUrl = "url(/assets/images/defaultPolyline.png)";
                                    break;
                                default:
                                    value.properties.photoUrl = $that.defaultPhotoUrl;
                                    break;
                            }
                            value.properties.INDEXLABEL = "POI";
                            break;
                    }

                    value.properties.__ID = _.uniqueId();
                    // 生成marker点
                    if (value.geometry.type.includes("Point")) {
                        value.properties.DISPLAY_X = value.geometry.coordinates[0];
                        value.properties.DISPLAY_Y = value.geometry.coordinates[1];
                    } else if (value.properties.DISPLAY_X && value.properties.DISPLAY_Y) {
                        value.properties.DISPLAY_X = Number(value.properties.DISPLAY_X);
                        value.properties.DISPLAY_Y = Number(value.properties.DISPLAY_Y);
                    } else if (value.properties.X && value.properties.Y) {
                        value.properties.DISPLAY_X = Number(value.properties.X);
                        value.properties.DISPLAY_Y = Number(value.properties.Y);
                    }
                    if (value.properties.DISPLAY_X && value.properties.DISPLAY_Y) {
                        value.properties.billboard = $that.createMarker(value.properties.DISPLAY_X, value.properties.DISPLAY_Y, value.properties.__ID, $that.billboards);
                    }
                    // 在渲染左侧展示名称和地址时处理一下空数据
                    // 左侧面板的对应字段，从tpl中获取，poi数据单独处理
                    if (!/^poi/.test(value.properties.__index)) {
                        $.each($that.esFeatures, function (count, temp) {
                            if (temp.index === value.properties.__index) {
                                if (value.properties.__index === "resa") {
                                    value.properties.NAME = "房产";
                                    value.properties.PLNAME = "房产";
                                } else {
                                    value.properties.NAME = value.properties[temp.NAME];
                                    value.properties.PLNAME = value.properties[temp.PLNAME];
                                }
                                if (!value.geometry.type.includes("Point")) {
                                    layerFeatures.push(value);
                                }
                            }
                        });
                    } else {
                        if (value.properties.PLNAME === null || value.properties.PLNAME === undefined) {
                            value.properties.PLNAME = value.properties.NAME;
                        }
                    }

                    // 根据id生成全局保存的结果
                    $that.allResult[value.properties.__ID] = value.properties;
                });
                var temp = {
                    "type": "FeatureCollection",
                    "features": layerFeatures
                };
                var promise = Cesium.GeoJsonDataSource.load(temp);
                promise.then(function (dataSource) {
                    $that.removeEntity = dataSource;
                    $that.viewer.dataSources.add(dataSource);

                    var entities = dataSource.entities.values;
                    // 将所有实体绑定到结果属性中，方便定位
                    $.each(entities, function (count, entity) {
                        $that.allResult[entity.properties.__ID.getValue()]._entity = entity;
                    });

                    MapUtils.setAllStyle(entities)
                    // MapUtils.setEntityStyle(entities,"building")
                    // $.each(entities, function (index, value) {
                    //     MapUtils.setEntityStyle(value,"building")
                    // });
                });
                if ($that.resultKo !== "") {
                    $that.resultKo.results(data.data[0].features);

                    $that.resultKo.addressResult = false;
                    $that.resultKo.poiResult = true;

                } else {
                    ko.applyBindings(new $that.createSearchData(data.data[0].features), document.getElementById("identifyResult"));
                }

                // 渲染完成后请求存在的房产数据
                $.each(data.data[0].features, function (index, value) {
                    if (value.properties.__index === "resa" && value.properties.OBJECTID) {
                        $.ajax({
                            url: $that.buildingOptions.url + "?instanceId=" + $that.buildingOptions.instanceId
                                + "&fieldName=properties.UUID&fieldValue=" + value.properties.OBJECTID,
                            type: 'POST'
                        }).done(function (data) {
                            if (!$.isEmptyObject(data.data) && data.data.features.length > 0) {
                                var temp = [];
                                $.each($that.resultKo.results(), function (index1, value1) {
                                    var buildingInfos = [];
                                    if (value1.properties.__index === "resa" && value1.properties.OBJECTID === value.properties.OBJECTID) {
                                        $.each(data.data.features, function (index2, value2) {
                                            if (value2.properties.REFNAME) value1.properties.NAME = value2.properties.REFNAME;
                                            var buildingInfo = {
                                                "ZRZH": value2.properties.ZRZH,
                                                "DYH": value2.properties.DYH,
                                                "FJH": value2.properties.FJH,
                                                "GD": value2.properties.GD,
                                                "JMGC": value2.properties.JMGC,
                                                "WLCH": value2.properties.WLCH,
                                                "REFNAME": value1.properties.REFNAME
                                            };
                                            buildingInfos.push(buildingInfo);
                                        });
                                        if (buildingInfos.length > 0) value1.properties.buildingInfos = buildingInfos;
                                    }
                                    temp.push(value1);
                                });
                                $that.resultKo.results([]);
                                $that.resultKo.results(temp)
                            }
                        });
                    }
                });

                if (graphEnable) {
                    // 渲染完成之后请求图片，渲染图片数据
                    $.each(data.data[0].features, function (index, value) {
                        if (value.properties.ELEMID !== undefined) {
                            var url = $that.nearbyUrl + value.properties.ELEMID + "?type=elemid";
                            $.ajax({
                                url: url,
                                type: 'GET',
                                dataType: 'json',
                                async: true,
                                success: function (data) {
                                    if (!$.isEmptyObject(data.data)) {
                                        var temp = [];
                                        $.each($that.resultKo.results(), function (index, value) {
                                            var associated = [];
                                            if (value.properties.ELEMID === data.data.ownerV.elemid[0]) {
                                                (data.data.ownerV.introduce !== undefined && data.data.ownerV.introduce !== null) ?
                                                    value.properties.introduce = data.data.ownerV.introduce[0] : value.properties.introduce = "";
                                                if (data.data.ownerV.pictureid !== undefined && data.data.ownerV.pictureid !== null)
                                                    value.properties.photoUrl = "url(" + $that.storageUrl + data.data.ownerV.pictureid[0] + "/thumbnail?w=70&h=70)";
                                                $.each($that.associatedList, function (count, list) {
                                                    if (data.data.ownerV.hasOwnProperty(list.key))
                                                        value.properties[list.key] = data.data.ownerV[list.key][0];
                                                });
                                                $.each($that.propertyList, function (count, list) {
                                                    if (data.data.ownerV.hasOwnProperty(list.key))
                                                        value.properties[list.key] = data.data.ownerV[list.key][0];
                                                });
                                                value.properties.nearby = {};
                                                $.each(data.data, function (count, list) {
                                                    if (count !== "ownerV") {
                                                        value.properties.nearby[count] = data.data[count];
                                                    }
                                                });
                                                if (associated.length > 0) value.properties.associated = associated;
                                            }
                                            temp.push(value);
                                        });
                                        $that.resultKo.results([]);
                                        $that.resultKo.results(temp)
                                    }
                                }
                            });
                        }
                    });

                    // 请求关联节点
                    $.each(data.data[0].features, function (index, value) {
                        if (value.properties.ELEMID !== undefined) {
                            var url = $that.relateUrl + value.properties.ELEMID + "?type=elemid";
                            $.ajax({
                                url: url,
                                type: 'GET',
                                dataType: 'json',
                                async: true,
                                success: function (data) {
                                    if (!$.isEmptyObject(data.data)) {
                                        var temp = [];
                                        $.each($that.resultKo.results(), function (index, value) {
                                            if (value.properties.ELEMID === data.data.ownerV.elemid[0]) {
                                                value.properties.relate = {};
                                                $.each(data.data, function (count, list) {
                                                    if (count !== "ownerV") {
                                                        if (count === "直属单位") {
                                                            value.properties.hasSubordinate = true;
                                                        }
                                                        value.properties.relate[count] = data.data[count];
                                                    }
                                                });
                                            }
                                            temp.push(value);
                                        });
                                        $that.resultKo.results([]);
                                        $that.resultKo.results(temp)
                                    }
                                }
                            });
                        }
                    });
                }
            },

            // 用ko生成左侧结果面板和点击事件
            createSearchData: function (data) {
                var self = this;
                self.results = ko.observableArray(data);
                $that.resultKo = self;

                self.showDetails = function (e) {
                    $that.searchResultElement = e;
                    $that.layer.closeAll();
                    $that.closePopup();
                    if ($that.lastSelectId !== "") {
                        $($that.lastSelectId).removeClass("search-result-index-active");
                    }
                    if ($that.removeRelatedEntity) {
                        $that.viewer.dataSources.remove($that.removeRelatedEntity);
                        $that.removeRelatedEntity = null;
                    }
                    if ($that.removeEntity) {
                        MapUtils.setAllStyle($that.removeEntity.entities.values);
                    }
                    $that.historyAssociatedIds = [];
                    if (!e.properties.isSubordinate) {
                        $("#resultId" + e.properties.__ID).addClass("search-result-index-active");
                        $that.lastSelectId = "#resultId" + e.properties.__ID;
                        $that.historyAssociatedIds.push($that.lastSelectId);
                    } else {
                        $("#resultId" + e.properties.UUID[0]).addClass("search-result-index-active");
                        $that.lastSelectId = "#resultId" + e.properties.UUID[0];
                        $that.historyAssociatedIds.push($that.lastSelectId);

                    }
                    var detailData = $that.createNeedData(e);
                    // 移除上一个选中样式
                    $that.removeLastSelectStyle();
                    if (detailData.geo !== undefined) {
                        // geo已经不适用于判断标准，应用_entity实体类作为判断标准，暂时没有空闲时间修改
                        if (detailData.geo.type.includes("Point")) {
                            var coords = detailData.geo.coordinates;
                            $that.selectedBillboard = $that.viewerflyToLonLat(coords[0], coords[1], e);
                        } else if (detailData.geo.type.includes("LineString")) {
                            $that.viewer.flyToViewer(e.properties._entity);
                            e.properties._entity.polyline.material.color.setValue(Cesium.Color.RED);
                            $that.lastLocationLine = e.properties._entity;
                        } else if (detailData.geo.type.includes("Polygon")) {
                            $that.viewer.flyToViewer(e.properties._entity);
                            e.properties._entity.polygon.material.color.setValue(Cesium.Color.RED.withAlpha(0.3));
                            e.properties._entity.polygon.outlineColor.setValue(Cesium.Color.RED);
                            $that.lastLocationPolygon = e.properties._entity;
                        }
                    }
                    if ($that.hasLayer === false) {
                        $that.active["offset"].call(this, detailData);
                        $that.hasLayer = true;
                    } else {
                        setTimeout(function () {
                            $that.active["offset"].call(this, detailData);
                        }, 500);
                    }
                };

                self.clickNavigation = function (e) {
                    console.log("navigation");
                };

                self.clickShare = function (e) {
                    console.log("share");
                };

                self.clickCamera = function (e) {
                    console.log("camera");
                }
            },

            // 移除上一个选中样式
            removeLastSelectStyle: function () {
                if ($that.lastLocationLine)
                    $that.lastLocationLine.polyline.material.color.setValue(Cesium.Color.LIGHTSKYBLUE);
                if ($that.lastLocationPolygon)
                    $that.lastLocationPolygon.polygon.material.color.setValue(Cesium.Color.LIGHTSKYBLUE);
                if ($that.selectedBillboard && $that.selectedBillboard.billboard)
                    $that.selectedBillboard.billboard.setImage('flyTo' + $that.selectedBillboard.id, $that.commonPhoto);
            },
            // 生成数据集，方便统一调用
            createNeedData: function (data) {
                var detail = data.properties;
                var temp = {};
                // id都是null，暂时拿OBJECTid作为key值判断
                // if (detail.OBJECTID) {
                if (detail.__ID) {
                    temp.__ID = detail.__ID;
                    if (data.geometry) {
                        temp.geo = data.geometry;
                    }

                    (detail.NAME !== null) ? temp.name = detail.NAME : temp.name = "名称数据为空";
                    (detail.FULLADDRES !== null) ? temp.addName = detail.FULLADDRES : temp.addName = "地址数据为空";
                    (detail.CITY !== null) ? temp.city = detail.CITY : temp.city = "城市数据为空";
                    (detail.DISTRICT !== null) ? temp.county = detail.DISTRICT : temp.county = "区县数据为空";
                    (detail.PROVINCE !== null) ? temp.province = detail.PROVINCE : temp.province = "省份数据为空";
                    (detail.TEL !== null) ? temp.tel = detail.TEL : temp.tel = "";
                    (detail.ZIPCODE !== null) ? temp.zipcode = detail.ZIPCODE : temp.zipcode = "";
                    (detail.introduce !== null) ? temp.introduce = detail.introduce : temp.introduce = "";
                    (detail.photoUrl !== undefined && detail.photoUrl !== null) ? temp.photoUrl = detail.photoUrl : temp.photoUrl = "";
                    $.each($that.associatedList, function (count, list) {
                        if (detail.hasOwnProperty(list.key))
                            temp[list.key] = detail[list.key]
                    });
                    $.each($that.propertyList, function (count, list) {
                        if (detail.hasOwnProperty(list.key))
                            temp[list.key] = detail[list.key];
                    });
                    if (detail.buildingInfos) temp.buildingInfos = detail.buildingInfos;
                    temp.nearby = detail.nearby;
                    temp.relate = detail.relate;
                    temp.__index = detail.__index;

                    return temp;
                } else {
                    temp.__ID = detail.UUID[0];
                    if (data.geometry) {
                        temp.geo = data.geometry;
                    }

                    (detail.NAME !== undefined) ? temp.name = detail.NAME[0] : temp.name = "名称数据为空";
                    (detail.ADDRESS !== undefined) ? temp.addName = detail.ADDRESS[0] : temp.addName = "地址数据为空";
                    (detail.city !== undefined) ? temp.city = detail.city[0] : temp.city = "城市数据为空";
                    (detail.county !== undefined) ? temp.county = detail.county[0] : temp.county = "区县数据为空";
                    (detail.PROVINCE !== undefined) ? temp.province = detail.PROVINCE[0] : temp.province = "省份数据为空";
                    (detail.TELEPHONE !== undefined) ? temp.tel = detail.TELEPHONE[0] : temp.tel = "";
                    (detail.ZIPCODE !== undefined) ? temp.zipcode = detail.ZIPCODE[0] : temp.zipcode = "";
                    (detail.introduce !== undefined) ? temp.introduce = detail.introduce[0] : temp.introduce = "";
                    (detail.photoUrl !== undefined && detail.photoUrl !== null) ? temp.photoUrl = detail.photoUrl[0] : temp.photoUrl = "";
                    $.each($that.associatedList, function (count, list) {
                        if (detail.hasOwnProperty(list.key))
                            temp[list.key] = detail[list.key]
                    });
                    $.each($that.propertyList, function (count, list) {
                        search - right - paneif(detail.hasOwnProperty(list.key))
                        temp[list.key] = detail[list.key];
                    });
                    temp.nearby = detail.nearby;
                    temp.relate = detail.relate;
                    temp.__index = detail.__index;

                    return temp;
                }
            },

            // 点击定位事件
            viewerflyToLonLat: function (lon, lat, alt) {
                if ($that.entity)
                    $that.viewer.entities.remove($that.entity);
                var ellipsoid = $that.viewer.scene.globe.ellipsoid;

                var cartographic = Cesium.Cartographic.fromDegrees(lon, lat);

                var position = ellipsoid.cartographicToCartesian(cartographic);

                if (alt.properties.billboard)
                    alt.properties.billboard.setImage('flyTo' + alt.properties.__ID, $that.selectedPhoto);
                $that.entity = new Cesium.Entity({
                    position: Cesium.Cartesian3.fromDegrees(lon, lat),//待地形修改后，将position带入即可
                    billboard: {
                        id: 'flyTo',
                        width: 0,
                        height: 0,
                        pixelOffset: new Cesium.Cartesian2(0, 0),
                        image: $that.commonPhoto,
                        eyeOffset: new Cesium.Cartesian3(0, 0, -25)
                    }
                });
                $that.viewer.entities.add($that.entity);
                // $that.viewer.scene.globe.depthTestAgainstTerrain = false;

                if ($that.zoomSwitch) {
                    $that.viewer.flyTo($that.entity, {
                        offset: {
                            heading: Cesium.Math.toRadians(0.0),
                            pitch: Cesium.Math.toRadians(-50),
                            range: 500
                        }
                    });
                }
                return alt.properties;
            },

            // 生成geoJson图形
            createPolygon: function (geo) {
                if ($that.removeRelatedEntity) {
                    $that.viewer.dataSources.remove($that.removeRelatedEntity);
                    $that.removeRelatedEntity = null;
                }
                var promise = Cesium.GeoJsonDataSource.load(geo);
                promise.then(function (dataSource) {
                    $that.removeRelatedEntity = dataSource;
                    $that.viewer.dataSources.add(dataSource);
                    var entity = dataSource.entities.values;
                    MapUtils.setEntityStyle(entity, "building");
                });

                // $that.viewer.zoomToViewer(promise);
                $that.viewer.flyToViewer(promise);
            },

            // 生成标记点
            createMarker: function (x, y, id, billboards) {
                var viewer = $that.viewer;
                // var ellipsoid=$that.viewer.scene.globe.ellipsoid;
                //
                // var cartographic=Cesium.Cartographic.fromDegrees(x,y);
                //
                // var position=ellipsoid.cartographicToCartesian(cartographic);

                // viewer.scene.globe.depthTestAgainstTerrain = false;

                var b = billboards.add({
                    position: Cesium.Cartesian3.fromDegrees(x, y),
                    image: $that.commonPhoto,
                    // verticalOrigin: Cesium.VerticalOrigin.BOTTOM,
                    id: id,
                    width: 25, // default: undefined
                    height: 25,
                    pixelOffset: new Cesium.Cartesian2(0, 0),
                    eyeOffset: new Cesium.Cartesian3(0, 0, -25)
                    // disableDepthTestDistance: Number.POSITIVE_INFINITY
                });

                return b;
            },

            // 生成layer属性列表
            createPropertiesList: function (data) {
                var content = "";
                var haveContent = false;
                content += "<div class='search-right-pane-part'>" +
                    "<div class='search-text-title'><span>相关属性</span></div>" +
                    "<div class='search-associated-list search-associated-properties'>";
                $.each($that.propertyList, function (i, val) {
                    if (data.hasOwnProperty(val.key) && data[val.key] !== null) {
                        if (val.hasOwnProperty(data.__index)) {
                            content += "<div class='search-associated-label layui-col-xs3'>" + val[data.__index] + "</div><div class='layui-col-xs1'>：</div><div class='search-associated-content layui-col-xs8'>" + data[val.key] + "</div>";
                        } else {
                            content += "<div class='search-associated-label layui-col-xs3'>" + val.label + "</div><div class='layui-col-xs1'>：</div><div class='search-associated-content layui-col-xs8'>" + data[val.key] + "</div>";
                        }
                        haveContent = true;
                    }
                });
                content += '</div></div>';

                if (haveContent)
                    return content;
                else
                    return "";
            },

            // 读取默认图片
            createDefaultPhoto: function (data) {
                if (data.photoUrl !== undefined && data.photoUrl !== "") {
                    var defaultPhotoList = [
                        "url(/assets/images/defaultPoint.png)",
                        "url(/assets/images/defaultPolygon.png)",
                        "url(/assets/images/defaultPolyline.png)",
                        $that.defaultPhotoUrl
                    ];
                    if (defaultPhotoList.indexOf(data.photoUrl) === -1) {
                        var url = data.photoUrl.split('(')[1].split('?')[0];
                        var thumb = data.photoUrl.split('(')[1].split('?')[0] + "?w=250&h=250";
                        var content = '<div class="search-right-pane-part"><div class="search-text-title">' +
                            '<span>图片</span></div>';
                        // content += '<div class="layui-carousel" id="defaultPhoto"><div carousel-item="">' +
                        //     '<div class="imageList"><img class="search-image-class" layer-src="' + url + '" src="' + thumb + '" alt="' + data.name + '"></div>' +
                        //     '</div></div>';
                        content += '<div id="defaultPhoto">' +
                            '<img layer-src="' + url + '" src="' + thumb + '" alt="' + data.name + '"/>' +
                            '</div>';
                        return content + '</div>';
                    } else {
                        return "";
                    }
                } else {
                    return "";
                }
            },

            // 生成面板的展示字段
            createDefaultTitle: function (data) {
                if (data.addName || data.city) {
                    var content = "<div class='search-right-pane-title-part'>" +
                        "<div class='search-title-describe'>";
                    if (data.addName) {
                        content += "<span class='icon-f-datalist' title='" + data.addName + "'>&nbsp;&nbsp;" + data.addName + "</span>";
                    }
                    if (data.city) {
                        if (data.county) {
                            content += "<span class='icon-f-location3' title='" + data.city + "&nbsp;" + data.county + "'>&nbsp;&nbsp;" + data.city + "&nbsp&nbsp" + data.county + "</span>";
                        } else {
                            content += "<span class='icon-f-location3' title='" + data.city + "'>&nbsp;&nbsp;" + data.city + "</span>";
                        }
                    }
                    content += "</div><div class='search-right-pane-icon'>" +
                        "<img src='/assets/images/navigation.png'>" +
                        "<img src='/assets/images/share.png'>" +
                        "<img src='/assets/images/camera.png'>" +
                        "</div>";
                    return content + "</div>";
                } else {
                    return "";
                }
            },

            // 生成详情
            createDescription: function (data) {
                if (data.introduce !== undefined && data.introduce !== "") {
                    var content = "<div class='search-right-pane-part'>" +
                        "<div class='search-text-title'><span>概况</span><i class='iconfont icon-f-unfold'></i></div>";
                    content += "<div class='search-text-text'>&nbsp&nbsp&nbsp&nbsp" + data.introduce + "</div>";
                    return content + "</div>";
                } else {
                    return "";
                }
            },

            // 生成关联搜
            createAssociated: function (data) {
                var content = "";
                if (data.hasOwnProperty("subwayline") || data.hasOwnProperty("subway")) {
                    content += "<div class='search-right-pane-part'>" +
                        "<div class='search-text-title'><span>附近地铁</span></div>" +
                        "<div class='search-associated-list'>" +
                        "<span><i class='iconfont icon-f-changyonglogo18'></i><div id='subwayInfoPanel'>" +
                        "<div id='subwayLineInfo'><p>地铁" + data["subwayline"] + "</p></div>" +
                        "<div id='subwayInfo'><p>最近站口:&nbsp;" + data["subway"] + "</p></div></div></span></div></div>";
                }
                if (data.hasOwnProperty("transpot") || data.hasOwnProperty("transline")) {
                    content += "<div class='search-right-pane-part'>" +
                        "<div class='search-text-title'><span>附近公交</span><i class='iconfont icon-f-unfold'></i></div>" +
                        "<div class='search-associated-list'>";
                    if (data.hasOwnProperty("transline")) {
                        content += "<div class='search-associated-type'>附近线路</div>";
                        var datalist = data["transline"].split(' ');
                        content += '<div class="layui-btn-container">';
                        datalist.forEach(function (val) {
                            content += "<button type='button' class='layui-btn layui-btn-xs search-associated-nocontent'>" + val + "</button>";
                        });
                        content += "</div>";
                    }
                    if (data.hasOwnProperty("transpot")) {
                        content += "<div class='search-associated-type'>附近站点</div>";
                        var datalist = data["transpot"].split(' ');
                        content += '<div class="layui-btn-container">';
                        datalist.forEach(function (val) {
                            content += "<button type='button' class='layui-btn layui-btn-xs search-associated-nocontent'>" + val + "</button>";
                        });
                        content += "</div>";
                    }
                    content += "</div></div>";
                }

                $.each(data.nearby, function (index, value) {
                    content += "<div class='search-right-pane-part'>" +
                        "<div class='search-text-title'><span>" + index + "</span><i class='iconfont icon-f-unfold'></i></div>" +
                        "<div class='search-associated-list'>";
                    content += '<div class="layui-btn-container">';
                    if ($that.noContentList.indexOf(index) > -1) {
                        $.each(value, function (i, val) {
                            if (val.name !== undefined && val.name !== "") {
                                content += "<button type='button' class='layui-btn layui-btn-xs search-associated-nocontent' dataid='" +
                                    val.UUID + "'>" + val.name + "</button>";
                            } else {
                                content += "<button type='button' class='layui-btn layui-btn-xs search-associated-nocontent' dataid='" +
                                    val.UUID + "'>" + val.label + "</button>";
                            }
                        });
                    } else {
                        $.each(value, function (i, val) {
                            if (val.name !== undefined && val.name !== "") {
                                content += "<button type='button' class='layui-btn layui-btn-xs search-associated-contentname' dataid='" +
                                    val.UUID + "'>" + val.name + "</button>";
                            } else {
                                content += "<button type='button' class='layui-btn layui-btn-xs search-associated-contentname' dataid='" +
                                    val.UUID + "'>" + val.label + "</button>";
                            }
                        });
                    }
                    content += '</div></div></div>';
                });

                return content;
            },

            // 生成关联搜数据
            createAssocitedData: function (id) {
                var temp = {};

                $.ajax({
                    url: $that.relateUrl + id + "?type=UUID",
                    type: 'GET',
                    dataType: 'json'
                }).done(function (data) {
                    var detail = data.data.ownerV;
                    if (detail !== undefined) {
                        temp.relate = {};
                        $.each(data.data, function (count, list) {
                            if (count !== "ownerV") {
                                temp.relate[count] = [];
                                $.each(list, function (index, type) {
                                    var tmp = {};
                                    for (var i in type) {
                                        tmp[i] = type[i][0];
                                    }
                                    temp.relate[count].push(tmp);
                                });
                            }
                        });
                    }
                    $.ajax({
                        url: $that.nearbyUrl + id + "?type=UUID"
                    }).done(function (data) {
                        var detail = data.data.ownerV;
                        if (detail !== undefined) {
                            if (detail.cordinate !== undefined && detail.cordinate !== null) {
                                if (detail.cordinate[0].length < 50) {
                                    temp.x = parseFloat(detail.cordinate[0].split(',')[0]);
                                    temp.y = parseFloat(detail.cordinate[0].split(',')[1]);
                                } else {
                                    temp.geo = JSON.parse(detail.cordinate[0]);
                                }
                            }
                            (detail.name !== undefined && detail.name !== null) ? temp.name = detail.name[0] : temp.name = "";
                            (detail.address !== undefined && detail.address !== null) ? temp.addName = detail.address[0] : temp.addName = "";
                            (detail.city !== undefined && detail.city !== null) ? temp.city = detail.city[0] : temp.city = "";
                            (detail.zone !== undefined && detail.zone !== null) ? temp.county = detail.zone[0] : temp.county = "";
                            (detail.province !== undefined && detail.province !== null) ? temp.province = detail.province : temp.province = "";
                            (detail.tel !== undefined && detail.tel !== null) ? temp.tel = detail.tel[0] : temp.tel = "";
                            (detail.introduce !== undefined && detail.introduce !== null) ? temp.introduce = detail.introduce[0] : temp.introduce = "";
                            (detail.pictureid !== undefined && detail.pictureid !== null) ? temp.photoUrl = "url(" + $that.storageUrl + detail.pictureid[0] + "/thumbnail?w=70&h=70)" : temp.photoUrl = "";
                            (detail.worktime !== undefined && detail.worktime !== null) ? temp.worktime = detail.worktime[0] : temp.worktime = "";
                            temp.__index = "poi_fs";
                            temp.nearby = {};
                            $.each(data.data, function (count, list) {
                                if (count !== "ownerV") {
                                    temp.nearby[count] = [];
                                    $.each(list, function (index, type) {
                                        var tmp = {};
                                        for (var i in type) {
                                            tmp[i] = type[i][0];
                                        }
                                        temp.nearby[count].push(tmp);
                                    });
                                }
                            });
                            $that.layer.closeAll();
                            $that.closePopup();
                            if (temp.x !== undefined) {
                                temp.properties = {};
                                temp.properties.__ID = detail.UUID[0];
                                temp.properties.billboard = $that.createMarker(temp.x, temp.y, detail.UUID[0], $that.viewer.scene.primitives.add(new Cesium.BillboardCollection()));
                                $that.selectedBillboard = $that.viewerflyToLonLat(temp.x, temp.y, temp);
                            }
                            if (temp.geo !== undefined) {
                                $that.createPolygon(temp.geo);
                            }
                            setTimeout(function () {
                                $that.active["offset"].call(this, temp);
                            }, 500);
                        } else {
                            layui.use('layer', function () {
                                layui.layer.msg('查询无结果');
                            });
                        }
                    });
                });
            },

            // 生成周边搜
            createSurround: function () {
                var content = "<div class='search-right-pane-part'>" +
                    "<div class='search-text-title'><span>周边搜</span></div>";

                content += "<div class='search-surround-types'>" +
                    "<div class='search-surround-border'><i class='icon-f-food'></i><span>美食</span></div>" +
                    "<div class='search-surround-border'><i class='icon-f-city'></i><span>住宿</span></div>" +
                    "<div class='search-surround-border'><i class='icon-f-park'></i><span>停车</span></div>" +
                    "<div class='search-surround-border'><i class='icon-f-attractions'></i><span>景点</span></div>" +
                    "</div>";
                return content + "</div>";
            },

            // 生成知识图谱
            createGraph: function (data) {
                var content = "";
                $.each(data.relate, function (index, value) {
                    content += "<div class='search-right-pane-part'>" +
                        "<div class='search-text-title'>" +
                        "<span class='search-select-all'>" + index + "</span>" +
                        "<i class='iconfont icon-f-unfold'></i>" +
                        "<span class='search-select-area'></span></div>" +
                        "<div class='search-associated-list'>";
                    content += '<div class="layui-btn-container">';
                    if ($that.noContentList.indexOf(index) > -1) {
                        $.each(value, function (i, val) {
                            if (val.name !== undefined && val.name !== "") {
                                content += "<button type='button' class='layui-btn layui-btn-xs search-associated-nocontent' dataid='" +
                                    val.UUID + "'>" + val.name + "</button>";
                            } else {
                                content += "<button type='button' class='layui-btn layui-btn-xs search-associated-nocontent' dataid='" +
                                    val.UUID + "'>" + val.label + "</button>";
                            }
                        });
                    } else {
                        $.each(value, function (i, val) {
                            if (val.name !== undefined && val.name !== "") {
                                content += "<button type='button' class='layui-btn layui-btn-xs search-associated-contentname' dataid='" +
                                    val.UUID + "'>" + val.name + "</button>";
                            } else {
                                content += "<button type='button' class='layui-btn layui-btn-xs search-associated-contentname' dataid='" +
                                    val.UUID + "'>" + val.label + "</button>";
                            }
                        });
                    }
                    content += '</div></div></div>';
                });
                return content;
            },

            // 生成房产信息
            createBuildingInfo: function (data) {
                var content = "";
                if (data.__index === "resa" && data.hasOwnProperty("buildingInfos")) {
                    content += "<div class='search-right-pane-part'>" +
                        "<div class='search-text-title'><span>房产信息</span></div>" +
                        "<table lay-filter='buildingInfoTable'>" +
                        "<thead><tr><th lay-data=\"{field:'ZRZH'}\">总层数</th>" +
                        "<th lay-data=\"{field:'DYH'}\">单元号</th>" +
                        "<th lay-data=\"{field:'FJH'}\" ,minWidth: 130>房间号</th>" +
                        "<th lay-data=\"{field:'GD'}\">高度</th>" +
                        "</tr></thead><tbody>";

                    $.each(data.buildingInfos, function (index, value) {
                        content += "<tr><td>" + (value.ZRZH ? value.ZRZH : "") + "</td>" +
                            "<td>" + (value.DYH ? value.DYH : "") + "</td>" +
                            "<td>" + (value.FJH ? value.FJH : "") + "</td>" +
                            "<td>" + (value.GD ? value.GD : "") + "</td>" +
                            "</tr>";
                    });

                    content += "</tbody></table></div>";
                }
                return content;
            },

            // 监听点击事件
            setInputAction: function () {
                var handler = new Cesium.ScreenSpaceEventHandler($that.viewer.scene.canvas);
                handler.setInputAction(function (click) {
                    var pickedObject = $that.viewer.scene.pick(click.position);
                    var clickPoint = $that.viewer.scene.pickPosition(click.position);
                    // $that.allResult[pickedObject.id];
                    var setPosition = function () {
                        var i = $that.viewer.camera.pickEllipsoid(new Cesium.Cartesian2($that.viewer.canvas.clientWidth / 2, $that.viewer.canvas.clientHeight / 2));
                        if (i !== undefined) {
                            var changedC = Cesium.SceneTransforms.wgs84ToWindowCoordinates($that.viewer.scene, clickPoint);
                            var onTop = false;
                            var e = clickPoint;
                            var n = $that.viewer.scene.globe.ellipsoid.cartesianToCartographic(i).height;
                            var max = n + 1 * $that.viewer.scene.globe.ellipsoid.maximumRadius;
                            var distance = Cesium.Cartesian3.distance(i, e);
                            if (max < distance) {
                                onTop = false;
                            } else {
                                onTop = true;
                            }
                            if (onTop) {
                                var x = changedC.x;
                                var y = changedC.y;
                                $('#searchPopupContent').css('display', 'block');
                                $('#searchPopupContent').css('left', x + 'px');
                                $('#searchPopupContent').css('top', y - $('#searchPopupContent').width() / 4 + 'px');
                            } else {
                                $('#trackPopUpContent').css('display', 'none');
                            }
                        }
                    };
                    if (typeof pickedObject !== 'undefined' && typeof pickedObject.id !== 'undefined') {
                        var id = undefined;
                        // 实体类与广告牌
                        if (pickedObject.id.hasOwnProperty('entityCollection'))
                            id = pickedObject.id.properties.__ID.getValue();
                        else
                            id = pickedObject.id;

                        $("#searchPopupTitle").text($that.allResult[id].NAME);
                        $("#searchPopupTitle").attr("title", $that.allResult[id].NAME);
                        switch (appVersion) {
                            case "ningxia":
                                var address = $that.allResult[id].ADDRESS;
                                var tel = $that.allResult[id].TELEPHONE;
                                if (address) {
                                    if (tel) {
                                        $(".search-popup-introduce").html("地址: " + address.substr(0, 32) + "</br>电话: " + tel);
                                        $(".search-popup-introduce").attr("title", "地址: " + address + " 电话: " + tel);
                                    } else {
                                        $(".search-popup-introduce").html("地址: " + address.substr(0, 32));
                                        $(".search-popup-introduce").attr("title", "地址: " + address.substr(0, 32));
                                    }
                                } else if (tel) {
                                    $(".search-popup-introduce").html("电话: " + tel);
                                    $(".search-popup-introduce").attr("title", "电话: " + tel);
                                } else {
                                    $(".search-popup-introduce").text("暂无信息");
                                }
                                break;
                            default:
                                var introduce = $that.allResult[id].introduce;
                                if (introduce !== null && introduce !== undefined) {
                                    var hide = introduce.substr(0, 32) + "...";
                                    $(".search-popup-introduce").text(hide);
                                    $(".search-popup-introduce").attr("title", introduce);
                                } else {
                                    $(".search-popup-introduce").text("暂无介绍");
                                }
                                break;
                        }
                        var photoUrl = $that.allResult[id].photoUrl;
                        if (photoUrl !== $that.defaultPhotoUrl) {
                            $(".search-popup-photo").css("background", photoUrl)
                        } else {
                            $(".search-popup-photo").css("background", $that.defaultPhotoUrl)
                        }
                        if ($that.updatePopLocationListener !== undefined && $that.updatePopLocationListener !== null) {
                            $that.updatePopLocationListener();
                            $that.updatePopLocationListener = null;
                        }
                        $that.updatePopLocationListener = $that.viewer.scene.postRender.addEventListener(setPosition);
                    } else {
                        $that.closePopup();
                    }
                }, Cesium.ScreenSpaceEventType.LEFT_CLICK);
            },

            // 创建合并geojson
            getUnitedGeojson: function (geoList) {
                var unitedGeojson = {
                    "type": "FeatureCollection",
                    "features": []
                };
                $.each(geoList, function (i, val) {
                    var feature = {
                        "type": "Feature"
                    };
                    feature.geometry = val;
                    unitedGeojson.features.push(feature);
                });
                return unitedGeojson;
            },

            // 计算geojson面积
            getGeojsonArea: function (geo, selector) {
                if (geo !== undefined || geo !== "") {
                    $.ajax({
                        type: "post",
                        url: $that.geoAreaUrl,
                        data: {
                            geoJson: JSON.stringify(geo)
                        }
                    }).done(function (data) {
                        var area = data.data.toFixed(0);
                        if (selector instanceof jQuery && area > 0) {
                            selector.html(area + "㎡");
                        }
                    });
                }
            },

            // 监听智能识别点击事件
            setIdentifyAction: function () {
                $that.identifyHandler.setInputAction(function (click) {
                    var clickPoint = $that.viewer.scene.pickPosition(click.position);
                    var latlng = Cesium.Cartographic.fromCartesian(clickPoint);
                    var lat = Cesium.Math.toDegrees(latlng.latitude);
                    var lng = Cesium.Math.toDegrees(latlng.longitude);
                    $that.identifyPoint.lat = lat;
                    $that.identifyPoint.lng = lng;
                    //
                    // var point = new SuperMap.Geometry.Point(lng, lat);
                    // console.log(point)
                    $('#searchInput').val("智能识别");
                    $('.search-input-clear').show();
                    $that.searchAjax();
                    $that.identifyHandler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_CLICK);

                }, Cesium.ScreenSpaceEventType.LEFT_CLICK);

            },

            searchOnMove: function () {
                var viewAreaWorld = MapUtils.getExtent();
                $that.options.pointsmap = JSON.stringify({
                    "minx": viewAreaWorld.west / Math.PI * 180,
                    "miny": viewAreaWorld.south / Math.PI * 180,
                    "maxx": viewAreaWorld.east / Math.PI * 180,
                    "maxy": viewAreaWorld.north / Math.PI * 180
                });
                $that.searchResult("urlBool");
            },

            // 生成popup窗内容
            createClickPopup: function () {
                var content = "<div class='search-popup-content' id='searchPopupContent'>" +
                    "<div class='search-popup-left'></div><div class='search-popup-title'><span id='searchPopupTitle'></span></div>" +
                    "<div class='search-popup-introduce'></div>" +
                    "<div class='search-popup-photo' style='background:" + $that.defaultPhotoUrl + "'></span></div>" +
                    "<div class='search-popup-bottom'><div class='search-popup-navigation'><i class='icon-f-analytic-router'></i>" +
                    "</div>" +
                    "<div class='search-popup-around'><i class='icon-f-surround'></i></div></div>" +
                    "</div>";

                $("#globalContainer").append(content);
            },

            // 关闭popup窗方法
            closePopup: function () {
                if ($that.updatePopLocationListener !== undefined && $that.updatePopLocationListener !== null) {
                    $('#searchPopupContent').css('display', 'none');
                    $that.updatePopLocationListener();
                    $that.updatePopLocationListener = null;
                }
            }
        };

    /**
     * get instance
     *
     * @returns {*}
     */
    me.getInstance = function () {
        if (instance === undefined) {
            instance = me;
        }
        return instance;
    };
    return me;
});
