/**
 *  标记
 * @author by zzf
 * @version v1.0 2019/7/20/9:19  Copyright gtmap Corp
 */

define(['global/utils/MapUtils',
    "global/core/Popup",
    'Cesium',
    "knockout",
    "global/utils/SearchResultUtils/Index"
], function (
    MapUtils,
    Popup,
    Cesium,
    ko,
    SearchResultUtils
) {
    // var Cesium = _Cesium;
    var instance, me,
        $that = me = {
            // 默认图片
            commonPhoto: "./../../../global/widgets/smartSearch/defaultPhoto/biaoji_common.png",
            resultKo: "",
            // init fun
            init: function () {
                $that._initLayui();
                $that.handler = new Cesium.ScreenSpaceEventHandler(MapUtils.viewer.scene.canvas);
                $that.billboards = MapUtils.viewer ? MapUtils.viewer.scene.primitives.add(new Cesium.BillboardCollection()) : undefined;
                $that.dmUrl = this.config.dmUrl;
                $that.dzUrl = this.config.dzUrl;
                $that.zbUrl = this.config.zbUrl;
                $that.instanceId = this.config.instanceId;
                $that.searchUrl = this.config.dmUrl;
                $that.poiUpdateUrl = this.config.poiUpdateUrl;
                $that.propertyList = this.config.propertyList;
                $that.viewer = MapUtils.viewer;
                SearchResultUtils._initDiv("#dmdzResult");
            },

            // open event
            onOpen: function () {
                SearchResultUtils._initDiv("#dmdzResult");
            },

            // close event
            onClose: function () {
                $("#dmdzResult").empty();
                SearchResultUtils._closeDiv();
                $("#input-dm").val("");
                $("#input-dmdz-zb-x").val("");
                $("#input-dmdz-zb-y").val("")
                $("#input-dmdz-zb-jl").val(500);
            },

            // pause event
            onPause: function () {
                $("#dmdzResult").empty();
                SearchResultUtils._closeDiv();
            },

            // 初始化layui
            _initLayui: function () {
                layui.config({
                    base: './js/'
                }).use(['form', 'laypage'], function () {
                    $that.laypage = layui.laypage;
                    var form = layui.form;
                    $that.active = {
                        offset: function (detailData) {
                            var type = "r";
                            $that.popupId = '#layerDemo' + type;
                            var title = "<span>" + detailData.name + "</span>";
                            var content = $that.createSearchDetailContent(detailData);
                            var left = screen.width - 309 + "px";
                            var top = $(".new-header-box").height() + $(".tool-widgets-pane").height() + 11 + "px";
                            var offSetTop = [top, left];

                            layer.open({
                                type: 1
                                , offset: offSetTop
                                , id: 'layerDemo' + type //防止重复弹出
                                , content: content
                                , maxWidth: 308
                                , title: [title, "background-color: rgba(67, 117, 253, 0.6);cursor: move;" +
                                "font-size: 1.3em;text-align: center;height: 90px;color: #fff;padding: 0;border-bottom: unset;background-image:url('../assets/images/bgPopupPanel.png')"]
                                // , btn: '关闭全部'
                                // , btnAlign: 'c' //按钮居中
                                , shade: 0 //不显示遮罩
                                , success: function () {
                                    $('.search-select-all').each(function () {
                                        var searchSelectCount = $(this).parent().parent().find('button').length;
                                        var searchSelectGeojsons = [];
                                        var searchSelectLocation = $(this);
                                        $(this).parent().parent().find('button').each(function () {
                                            $.ajax({
                                                url: $that.nearbyUrl + $(this).attr("dataid") + "?type=UUID"
                                            }).done(function (data) {
                                                try {
                                                    if (data.data.ownerV) {
                                                        var geojson = JSON.parse(data.data.ownerV.cordinate[0]);
                                                        if (geojson.type !== "" || geojson.type !== undefined)
                                                            searchSelectGeojsons.push(geojson);
                                                    }
                                                    searchSelectCount--;
                                                } catch (e) {
                                                    searchSelectCount--;
                                                }
                                                if (searchSelectCount === 0) {
                                                    var unitedGeojson = $that.getUnitedGeojson(searchSelectGeojsons);
                                                    $that.getGeojsonArea(unitedGeojson, searchSelectLocation.parent().find('.search-select-area'), searchSelectLocation.html(), searchSelectLocation);
                                                }
                                            }).fail(function () {
                                                searchSelectCount--;
                                                if (searchSelectCount === 0) {
                                                    var unitedGeojson = $that.getUnitedGeojson(searchSelectGeojsons);
                                                    $that.getGeojsonArea(unitedGeojson, searchSelectLocation.parent().find('.search-select-area'), searchSelectLocation.html(), searchSelectLocation);
                                                }
                                            });
                                        });
                                    });
                                    $('.search-right-pane-part .search-text-text,.search-right-pane-part .layui-btn-container').each(function () {
                                        if ($(this).height() > 60) {
                                            $(this).addClass('wrap');
                                            $(this).parents('.search-right-pane-part').find('.icon-f-unfold').show();
                                        }
                                    });
                                    if (smartSearchConfig.searchOnMove) {
                                        $that.viewer.scene.camera.moveEnd.removeEventListener($that.searchOnMove);
                                    }
                                }
                                , yes: function () {
                                    layer.closeAll();
                                    $(document).off('click', '.surroundSearchAll');
                                    $(document).off('click', '.search-surround-border');
                                }
                                , cancel: function () {
                                    $that.hasLayer = false;
                                    if ($that.removeEntity) {
                                        MapUtils.setAllStyle($that.removeEntity.entities.values);
                                    }
                                    if ($that.removeCtgEntity) {
                                        MapUtils.setAllStyle($that.removeCtgEntity.entities.values, undefined, 0.7, true);
                                    }
                                    if ($that.removeRelatedEntity) {
                                        $that.viewer.dataSources.remove($that.removeRelatedEntity);
                                        $that.removeRelatedEntity = null;
                                    }
                                    layer.closeAll();
                                    $($that.lastSelectId).removeClass("search-result-index-active");
                                    if (smartSearchConfig.searchOnMove) {
                                        if ($that.enabelSearchOnMove) {
                                            $that.viewer.scene.camera.moveEnd.addEventListener($that.searchOnMove);
                                        }
                                    }
                                    $(document).off('click', '.surroundSearchAll');
                                    $(document).off('click', '.search-surround-border');
                                    if ($that.relatedBillboard) {
                                        $that.relatedBillboard.removeAll();
                                    }
                                }
                            });
                            $($($that.popupId).parent().find('a')[0])
                                .removeClass('layui-layer-ico').addClass('icon-f-close').css('color', '#ffffff')
                                .css('top', '-5px').css('font-size', '20px').attr('title', '关闭面板');
                        }
                    };
                    form.render();
                    form.on('radio(dmdz)', function (obj) {
                        $that.radioValue = obj.value;
                        if (obj.value == 1) {
                            $that.searchUrl = $that.dmUrl;
                            $("#div-radio-dmdz").removeClass("hide");
                            $("#div-radio-dmdz-zb-x").addClass("hide");
                            $("#div-radio-dmdz-zb-y").addClass("hide");
                            $("#div-radio-dmdz-zb-jl").addClass("hide");
                        } else if (obj.value == 2) {
                            $that.searchUrl = $that.dzUrl;
                            $("#div-radio-dmdz").removeClass("hide");
                            $("#div-radio-dmdz-zb-x").addClass("hide");
                            $("#div-radio-dmdz-zb-y").addClass("hide");
                            $("#div-radio-dmdz-zb-jl").addClass("hide");
                        } else if (obj.value == 3) {
                            $that.searchUrl = $that.zbUrl;
                            $("#div-radio-dmdz").addClass("hide");
                            $("#div-radio-dmdz-zb-x").removeClass("hide");
                            $("#div-radio-dmdz-zb-y").removeClass("hide");
                            $("#div-radio-dmdz-zb-jl").removeClass("hide");
                        }
                        form.render('radio');
                    });

                    $(document).on('click', '.search-dmdz', function (evt) {
                        console.log("地名地址检索");
                        _searchDmdz();
                        return false;
                    });

                    $(document).on('click', '#map-dmdz', function (evt) {
                        console.log("地名地址地图选点");
                        $that._initMarker();
                        return false;
                    });

                    function _searchDmdz() {
                        var point = [];
                        point.push($("#input-dmdz-zb-x").val());
                        point.push($("#input-dmdz-zb-y").val());

                        if ($that.radioValue == 1) {
                            $that.options = {
                                keyword: $("#input-dm").val(),
                                pageIndex: 1
                            };
                        } else if ($that.radioValue == 2) {
                            $that.options = {
                                addName: $("#input-dm").val(),
                                pageIndex: 1
                            };
                        } else if ($that.radioValue == 3) {
                            $that.options = {
                                instanceId: $that.instanceId,
                                lon: $("#input-dmdz-zb-x").val(),
                                lat: $("#input-dmdz-zb-y").val(),
                                distance: Math.round($("#input-dmdz-zb-jl").val()),
                                pageIndex: 1
                            };
                        } else {
                            $that.options = {
                                keyword: $("#input-dm").val(),
                                pageIndex: 1
                            };
                        }
                        SearchResultUtils._searchData($that.options, $that.searchUrl, $that.propertyList, "NAME",$that.poiUpdateUrl);
                    };
                });
            },

            // 初始化标记点
            _initMarker: function () {
                SearchResultUtils._clearMarker();
                $that.billboards.removeAll();
                // 标记点集合
                var viewer = MapUtils.viewer;

                $that.handler.setInputAction(function (click) {
                    SearchResultUtils._clearMarker();
                    $that.billboards.removeAll();
                    var pickedObject = MapUtils.viewer.scene.pick(click.position);

                    var clickPoint = MapUtils.viewer.scene.pickPosition(click.position),
                        cartographic = Cesium.Cartographic.fromCartesian(clickPoint),
                        longitude = Cesium.Math.toDegrees(cartographic.longitude),
                        latitude = Cesium.Math.toDegrees(cartographic.latitude);
                    $("#input-dmdz-zb-x").val(longitude);
                    $("#input-dmdz-zb-y").val(latitude);
                    var height = cartographic.height;
                    var lastPosition = Cesium.Cartesian3.fromDegrees(longitude, latitude, height);
                    var remove = $that.billboards.add({
                        position: lastPosition,
                        image: './../../../global/widgets/smartSearch/defaultPhoto/biaoji_common.png',
                        verticalOrigin: Cesium.VerticalOrigin.BOTTOM,
                        pixelOffset: new Cesium.Cartesian2(0, -5),
                        eyeOffset: new Cesium.Cartesian3(0, 0, -50)
                    });
                    $that.handler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_CLICK);
                }, Cesium.ScreenSpaceEventType.LEFT_CLICK)

            },
        };

    /**
     * get instance
     *
     * @returns {*}
     */
    me.getInstance = function () {
        if (void 0 === instance) {
            instance = me;
        }
        return instance;
    };
    return me;
});