define(["readShp", "Cesium", "jqueryUpload2"], function (shp, Cesium) {

    var that;

    var layer;
    layui.use('layer', function () {
        layer = layui.layer;
    });

    function FileUpload() {
        that = this;
    }

    FileUpload.prototype.loadFile = function (input, form, complete) {
        this._form = form;
        this._complete = complete;
        readFile(input);
    };

    /*读取shp文件*/
    FileUpload.prototype.readShp = function (input, viewer) {
        this._form = input;
        this._viewer = viewer;
        var file = $(input)[0].files[0];
        var reader = new FileReader();
        reader.readAsArrayBuffer(file);
        reader.onload = readerLoad;
    };

    // 解析上传文件类型/结果
    FileUpload.prototype.parseResult = function (data, back) {
        var tempJson = data;
        if (typeof(data) === "string") {
            tempJson = JSON.parse(data);
        }
        if (JSON.stringify(back) === "{}") {
            back.fileName = this.fileName;
        }
        //解析类型并存储数据
        if (typeof tempJson.success === "undefined" || tempJson.success === true) {
            if (tempJson.type === "bj") {
                var parseData = JSON.parse(tempJson.value.feature);
                back.featureCollection = parseData;
                back.featureList = parseData.features;
            }
            else if (tempJson.type === "shp") {
                back.featureCollection = tempJson.value;
                back.featureList = tempJson.value.features;
            }
            else if (tempJson.type === "FeatureCollection") {
                back.featureCollection = tempJson;
                back.featureList = tempJson.features;
            }
            else {
                alert("解析出错");
            }
        }

    };

    function readFile(obj) {
        try {
            if ($(obj).val() !== '') {
                //获取文件类型
                var fileType = $(obj).val().substr($(obj).val().lastIndexOf('.') + 1).toLowerCase();
                if (fileType === 'zip' || fileType === 'xls' ||
                    fileType === 'xlsx' || fileType === 'txt' || fileType === 'dwg') {
                    upLoad(obj);
                } else {
                    alert("上传错误");
                }
                $(obj).val("");
            }
        } catch (e) {
            $(obj).val("");
        }
    }

    /*
*
* jquery upload
* */
    function upLoad(object) {
        $(object).upload({
            url: "http://192.168.1.46:9016/gis/misc/parseGeoFile",//上传接口
            params: $("#" + this._form).serialize(),
            dataType: 'text',
            onSend: function (obj, filePath) {
                that.fileName = filePath.substr(filePath.lastIndexOf('\\') + 1);
                return true;//须加,否则上传后不会进入complete
            },
            onComplate: function (data) {
                if (that._complete !== null && that._complete !== undefined) {
                    that._complete(data);
                }
            },
            onProgress: function (e) {
            },
            error: function () {
            }
        });
        $(object).upload("ajaxSubmit");
    }


    /*上传zip的回调事件*/
    function readerLoad() {
        if (this.readyState !== 2 || this.error) {
            return;
        }
        else {
            shp(this.result).then(function (data) {
                //清空
                $(that._form).val("");
                loadGeojson(data,that.viewer);
            });
        }
    }

    FileUpload.prototype.loadGeojson = function(data,viewer) {
        var source;
        viewer.dataSources.removeAll();
      /*  if (data) {
            layer.msg('shp上传成功', {
                time: 1000, //20s后自动关闭
                btn: false
            });
        }*/
        var promise = Cesium.GeoJsonDataSource.load(data);
        promise.then(function (dataSource) {
            viewer.dataSources.add(dataSource);
            source = dataSource;
            var entities = dataSource.entities.values;

            for (var i = 0; i < entities.length; i++) {
                var entity = entities[i];
                entity.polygon.material = Cesium.Color.ORANGERED;
                entity.polygon.outline = false;
                entity.polygon.extrudedHeight = 10;
            }
        });
        viewer.flyTo(promise);
        return source;
    };

    /*获取地块名称*/
    FileUpload.prototype.getPropertyName = function(e) {
        var name = "";
        if (typeof e.properties.NAME !== "undefined" && e.properties.NAME !== "") {
            name = e.properties.NAME;
        }
        if (typeof e.properties.DKNAME !== "undefined" && e.properties.DKNAME !== "") {
            name = e.properties.DKNAME;
        }
        if (typeof e.properties.PL_NAME !== "undefined" && e.properties.PL_NAME !== "") {
            name = e.properties.PL_NAME;
        }
        if(typeof e.properties.KSMC !== "undefined" && e.properties.KSMC !== "" ){
            name = e.properties.KSMC;
        }
        return name;
    };

    return new FileUpload;

});