define(['Cesium',
    "./curve",
    "global/utils/MapUtils"],function (Cesium,curve,MapUtils) {
    var center = [106.540545, 29.531714];
    var model={};
    var height = 60*15;



    /*渲染一个中心点扩散圆*/
    function getCenter2Around(center,height,data) {
        var pResult = curve.getCurveDynamicPointsAndLine(center,data,height);
        var lineResult = pResult.line;
        var pointResult = pResult.point;
        //创建扩散效果
        var colorC = new Cesium.Color(118 / 255, 233/ 255, 241 / 255, 0.8);
        curve.drawTrail(MapUtils.viewer,center,pointResult,lineResult,data,height)
    }
    model.init=function (data,center) {
        MapUtils.viewer.scene.camera.flyTo({ // 图层加载完成,设置相机位置
            destination: Cesium.Cartesian3.fromDegrees(center[0], center[1], 20000)
        });
        //组织得到point数组
        var cities =data.toNj;
        var cityArr =cities.split(",");
        var cityGeo = data.cityGeo;
        var geoPointArr =[];
        $(cityArr).map(function (i,e) {
            var coors = cityGeo[e];
            if(!coors){
                return;
            }
            var geo ={};
            geo.geometry ={
                "type": "Point",
                "coordinates": coors
            }
            geoPointArr.push(geo);
        })
        getCenter2Around(center,height,geoPointArr);
    }
    return model;

});