/**
 * @author by <a href="mailto:chaomashi@gmail.com">C</a>
 * @version v1.0 2019/2/14/10:21  Copyright gtmap Corp
 */
define(["mapV","global/core/MapVLayerProvider"],function (mapV,MapVLayer) {
   /*
   * 存放echarts渲染的可视化模型参数
   *
   * scatterOption：散点(态势)图          数据格式：value(权值) coords(坐标) name(名称)
   *
   * linesOption：折线图                  数据格式： fromName   toName    coords:[[y,x],[y,x]]
   *
   * flowOption: 流线图
   *
   * mapVHeat: mapv热力图
   *
   *mapVHoneycomb：蜂窝图
   *
   * mapVLines ： 点构造首尾闭合线
   *
   * mapVDynamivPoints ： 动态点
   *
   * mapVPolygon： 渲染面
   *
   * mapVSimpleLine：常规线
   *
   * 注：cesium扩展echarts的gl类中的coordinateSystem方法,将二维坐标点转化为三维点，所以需要
   * 增加两个参数配置
   * ** GLMap:{}
   * ** coordinateSystem:"GLMap"
   *
   *
   * */


     var self;
     var model = {

        setOption: function (option) {
            self = this;
            this._color = option.color;
            this._globalAlpha = option.slider;
            this._title = option.title;
            this._size = option.size * 1;
        },

        /*散点图*/
        scatterOption : function (data) {
           return {
               animation: false,
               title:{
                   text: this._title,
                   left: 'center'
                },
               GLMap: {},
               tooltip: {trigger: "item"},
               series: [{
                   type: "effectScatter",
                   coordinateSystem: "GLMap",
                   data:data,
                   symbolSize: function (e) {
                       return (e[2] / 10) * self._size  / 20 ;
                   },
                   showEffectOn: "render",
                   rippleEffect: {brushType: "stroke"},
                   hoverAnimation: !0,
                   label: {normal: {formatter: "{b}", position: "right", show: true, color:"#333"}},
                   itemStyle: {normal: {color: self._color, shadowBlur: 60, shadowColor: "#cccccc"}},
                   zlevel: 1
               }]
           }
       },

        /*流向图*/
        flowOption: function (point,line) {
           return {
               animation: false,
               backgroundColor: "rgba(116, 112, 124, 0.2)",
               title:{
                   text: self.title,
                   left: 'center'
               },
               GLMap: {},
               tooltip: {trigger: "item"},
               series: [
                   {
                   type: "effectScatter",
                   coordinateSystem: "GLMap",
                   data:point,
                   symbolSize: function (e) {
                       return e[2] / 10;
                   },
                   showEffectOn: "render",
                   rippleEffect: {brushType: "stroke"},
                   hoverAnimation: !0,
                   label: {normal: {formatter: "{b}", position: "right", show: true}},
                   itemStyle: {normal: {color: 'purple', shadowBlur: 60, shadowColor: "#cccccc"}},
                   zlevel: 1
               },
                   {
                       type: "lines",
                       coordinateSystem:"GLMap",
                       lineStyle:{
                           normal: {
                               color: self._color,
                               curveness: 0.2,
                               opacity: 0.8,
                               width: self._size / 10
                           }
                       },
                       effect: {
                           period: 6,
                           show: true,
                           symbol: "arrow",
                           color:"red",
                           symbolSize: 10,
                           trailLength: 0.1
                       },
                       data:line,
                       zlevel: 2
                   },
                   {
                       type: "lines",
                       coordinateSystem:"GLMap",
                       lineStyle:{
                           normal: {
                               color: self._color,
                               curveness: 0.2,
                               width: self._size / 10
                           }
                       },
                       effect: {
                           color: "#fff",
                           period: 6,
                           show: true,
                           symbolSize: 10,
                           trailLength: 0.7
                       },
                       data:line,
                       zlevel: 1
                   }
               ]
           }
       },

        /*热力图*/
        mapVHeat: function (result,viewer) {
           var data = [];
            $.each(result,function (i,e) {
                data.push({
                    geometry: {type: "Point", coordinates: e.coords},
                    count: e.value,
                    time: e.time
                })
            });
           var option = {
               size:this._size,
               draw: "heatmap",
               gradient: { 0.25: "rgb(0,0,255)", 0.55: "rgb(0,255,0)", 0.85: "yellow", 1.0: "rgb(255,0,0)"},
               max:100,

               // animation: {
               //     type: 'time',
               //     stepsRange: {
               //         start: 0,
               //         end: 80
               //     },
               //     trails: 15,
               //     duration: 5
               // }
           };
           var dataSet = new mapV.DataSet(data);
            return new MapVLayer(viewer,dataSet,option);
       },

        /*蜂窝图*/
        mapVHoneycomb: function (result,viewer) {
            var data = [];
            $.each(result,function (i,e) {
                data.push({
                    geometry: {type: "Point", coordinates: e.coords},
                    count: e.value
                });
            });
            var option = {
                size:this._size,
                fillStyle: 'rgba(55, 50, 250, 0.8)',
                shadowColor: 'rgba(255, 250, 50, 1)',
                shadowBlur: 20,
                max: 100,
                label: { // 网格中显示累加的值总和
                    show: true,
                    fillStyle: 'white',
                    shadowColor: 'yellow',
                    font: '20px Arial',
                    shadowBlur: 10
                },
                gradient: { 0.25: "rgb(0,0,255)", 0.55: "rgb(0,255,0)", 0.85: "yellow", 1.0: "rgb(255,0,0)"},
                draw: 'honeycomb'
            };
            var dataSet = new mapV.DataSet(data);
            return new MapVLayer(viewer,dataSet,option);
        },

        /*自定义图片*/
        mapVImage:function (result,viewer) {
            var img = new Image();
            var data = [];
            img.src = '/assets/images/zss.png';
            img.onload = function() {
                $.each(result,function (i,e) {
                    data.push({
                        geometry: {type: "Point", coordinates: e.coords},
                        deg: 360 * Math.random(),
                        icon: img
                    });
                });
                var option = {
                    draw: 'icon'
                };
                var dataSet = new mapV.DataSet(data);
                return new MapVLayer(viewer,dataSet,option);
                }
            },

         /*点构造首尾闭合线*/
        mapVLines:function (result,viewer){
            var data = [];
            $.each(result,function (i,e) {
                $.each(result.reverse(),function (o,k) {
                    data.push({
                        geometry: {type: "LineString", coordinates: [e.coords,k.coords]},
                        count: e.value,
                        text: e.name
                    });
                });
            });
            var option = {
                size:this._size,
                gradient: {
                    0: 'blue',
                    0.5: 'yellow',
                    1: 'red'
                },
                lineWidth: this._size / 100,
                max: 30,
                draw: 'intensity'
            };
            var dataSet = new mapV.DataSet(data);
            return new MapVLayer(viewer,dataSet,option);
        },

         /*动态点*/
        mapVDynamivPoints:function (result,viewer) {
            var data = [];
            $.each(result,function (i,e) {
                data.push({
                    geometry: {type: "Point", coordinates: e.coords},
                    count: e.value,
                    time: 100 * Math.random()
                });
            });
            var option = {
                size: this._size / 5,
                fillStyle:this._color,
                draw: "simple",
                animation: {
                    type: 'time',
                    stepsRange: {
                        start: 0,
                        end: 100
                    },
                    trails: 10,
                    duration: 4
                }
            };
            var dataSet = new mapV.DataSet(data);
            return new MapVLayer(viewer,dataSet,option);
        },

         /*渲染面*/
         mapVPolygon:function (result,viewer) {
             var data = [];
             $.each(result,function (i,e) {
                 data.push({
                     geometry: {type: "Polygon", coordinates: [e.coords]},
                     count: e.value
                 });
             });
             var option = {
                 fillStyle: this._color,
                 draw: 'simple'
             };
             var dataSet = new mapV.DataSet(data);
             return new MapVLayer(viewer,dataSet,option);
         },
         
         /*常规线渲染*/
         mapVSimpleLine:function (result,viewer) {
             var data = [];
             $.each(result,function (i,e) {
                     data.push({
                         geometry: {type: "LineString", coordinates: e.coords},
                         count: e.value,
                         text: e.name
                     });
             });
             var option = {
                 strokeStyle: this._color,
                 shadowColor: 'rgba(255, 250, 50, 1)',
                 shadowBlur: 20,
                 lineWidth: this._size / 100,
                 draw: 'simple'
             };
             var dataSet = new mapV.DataSet(data);
             return new MapVLayer(viewer,dataSet,option);
         },

         mapVGeojson:function (result,viewer) {
             var data = [],polygon = [];
             data = result.features;
             $.each(data,function (i,e) {
                     e.count = e.properties.SCORE;
                     polygon.push(e);

             });
             var option = {
                 gradient: {
                     0: 'rgba(50, 50, 255, 0.8)',
                     0.5: 'rgba(255, 255, 50, 0.8)',
                     1: 'rgba(255, 55, 50, 0.8)'
                 },
                 max: 30,
                 draw: 'intensity'
             };
             var dataSet = new mapV.DataSet(polygon);
             return new MapVLayer(viewer,dataSet,option);
         }
   };














   return model
});