define(['Cesium'],function (Cesium) {

    var that;
    function Curve() {
        that = this;
        this.animationObj = {
            stepsRange: {
                start: 0,
                end: 50
            },
            trails: 10,
            duration: 85
        };
    }

    /*获取拟合曲线接口*/
   Curve.prototype.getCurve=function (obj1, obj2, count) {
      return getCurveByTwoPoints(obj1, obj2, count);
   };


   /*获取拟合线动态的点和线*/
   Curve.prototype.getCurveDynamicPointsAndLine=function (center, endPoints,height) {
      return getCurveDynamicPointsAndLine(center, endPoints,height);
   };


/**
 * 根据弧线的坐标节点数组
 */
function getCurvePoints(points, options) {
    options = options || {};
    var curvePoints = [];
    for (var i = 0; i < points.length - 1; i++) {
        var p = getCurveByTwoPoints(points[i], points[i + 1], options.count);
        if (p && p.length > 0) {
            curvePoints = curvePoints.concat(p);
        }
    }
    return curvePoints;
}

/**
 * 根据两点获取曲线坐标点数组
 * @param Point 起点
 * @param Point 终点
 */
function getCurveByTwoPoints(obj1, obj2, count) {
    if (!obj1 || !obj2) {
        return null;
    }

    var B1 = function(x) {
        return 1 - 2 * x + x * x;
    };
    var B2 = function(x) {
        return 2 * x - 2 * x * x;
    };
    var B3 = function(x) {
        return x * x;
    };

    var curveCoordinates = [];

    var count = count || 40; // 曲线是由一些小的线段组成的，这个表示这个曲线所有到的折线的个数
    var isFuture = false;
    var t, h, h2, lat3, lng3, j, t2;
    var LnArray = [];
    var i = 0;
    var inc = 0;

    if (typeof(obj2) == "undefined") {
        if (typeof(curveCoordinates) != "undefined") {
            curveCoordinates = [];
        }
        return;
    }

    var lat1 = parseFloat(obj1.lat);
    var lat2 = parseFloat(obj2.lat);
    var lng1 = parseFloat(obj1.lng);
    var lng2 = parseFloat(obj2.lng);

    // 计算曲线角度的方法
    if (lng2 > lng1) {
        if (parseFloat(lng2-lng1) > 180) {
            if (lng1 < 0) {
                lng1 = parseFloat(180 + 180 + lng1);
            }
        }
    }

    if (lng1 > lng2) {
        if (parseFloat(lng1-lng2) > 180) {
            if (lng2 < 0) {
                lng2 = parseFloat(180 + 180 + lng2);
            }
        }
    }
    j = 0;
    t2 = 0;
    if (lat2 == lat1) {
        t = 0;
        h = lng1 - lng2;
    } else if (lng2 == lng1) {
        t = Math.PI / 2;
        h = lat1 - lat2;
    } else {
        t = Math.atan((lat2 - lat1) / (lng2 - lng1));
        h = (lat2 - lat1) / Math.sin(t);
    }
    if (t2 == 0) {
        t2 = (t + (Math.PI / 5));
    }
    h2 = h / 2;
    lng3 = h2 * Math.cos(t2) + lng1;
    lat3 = h2 * Math.sin(t2) + lat1;

    for (i = 0; i < count + 1; i++) {
        curveCoordinates.push([
            (lng1 * B1(inc) + lng3 * B2(inc)) + lng2 * B3(inc),
            (lat1 * B1(inc) + lat3 * B2(inc) + lat2 * B3(inc))
        ]);
        inc = inc + (1 / count);
    }
    return curveCoordinates;
}

function Point (lng, lat) {
    this.lng = lng;
    this.lat = lat;
}

    function getCurveDynamicPointsAndLine(center, endPoints,height) {
        if (center && (center instanceof Array) && endPoints && (endPoints instanceof Array)) {
            var timeData = [];
            var lineData = [];
            endPoints.map(function (data) {
                var coords = data.geometry && data.geometry.coordinates;
                var toCenter = {lng: coords[0], lat: coords[1]};
                var fromCenter = {lng: center[0], lat: center[1]};
                var cv = getCurvePoints([fromCenter, toCenter]);
                var pointArray = [];
                for (var j = 0; j < cv.length; j++) {
                    timeData.push({
                        geometry: {
                            type: 'Point',
                            coordinates: cv[j]
                        },
                        time: j
                    });
                    pointArray.push(cv[j][0]);
                    pointArray.push(cv[j][1]);
                    pointArray.push(height);
                }

                lineData.push({
                    geometry: {
                        type: 'LineString',
                        coordinates: pointArray
                    }
                });
            });
            return {point:timeData,line:lineData};
        }
    }


    /*根据朱利安日期*/
   function isAvailable(currentTime) {
       var _range = that.animationObj.stepsRange.end - that.animationObj.stepsRange.start;
        if (!Cesium.defined(currentTime)) {
            throw new Cesium.DeveloperError('time is required.');
        }

        var nMS = Cesium.JulianDate.toDate(currentTime).getTime()/that.animationObj.duration;
        var time = (nMS%_range + that.animationObj.stepsRange.start);

        var trails = trails || 10;
        if (time && this.nameID > time - trails && this.nameID < time) {
            return true;
        } else {
            return false;
        }
    }

   Curve.prototype.drawTrail=function(viewer,center,pointResult,lineResult,group,height) {
       var curLineArray = [];
       var linecolor = new Cesium.Color(72/255,61/255,139/255,0.8);
       // var linecolor = new Cesium.Color(32/255,228/255,243/255,0.8);
       //渲染线样式
       var l2 = new Cesium.Color(65/255,105/255,225/255, 0.8);
       for (var i = 0; i < lineResult.length; ++i) {
           curLineArray[i] = viewer.entities.add({
               polyline : {
                   positions : Cesium.Cartesian3.fromDegreesArrayHeights(lineResult[i].geometry.coordinates),
                   width : 1,
                   //发光材质
                   material : new Cesium.PolylineOutlineMaterialProperty({
                       color : linecolor,
                       outlineWidth : 0.1,
                       outlineColor : l2
                   }),
                   depthFailMaterial: new Cesium.PolylineOutlineMaterialProperty({
                       color : linecolor,
                       outlineWidth : 0.1,
                       outlineColor : l2
                   })
               }
           });
       }

       //渲染点样式
       var color = new Cesium.Color(243/255,242/255,249/255,0.8);
       var endPointArray = [];
       for (var i = 0; i < group.length; ++i) {
           endPointArray[i] = viewer.entities.add({
               position : Cesium.Cartesian3.fromDegrees(group[i].geometry.coordinates[0],group[i].geometry.coordinates[1],height),
               billboard :{
                   image : '/assets/images/p.png',
                   width:8,
                   height:8,
                   color : color
               }
           });
       }

       var pointLineArray = [];
       var entityArray = [];
       //pointResult.length = 0;
       //创建扩散效果的点
       for (var i = 0; i < pointResult.length; ++i) {
           var lon = pointResult[i].geometry.coordinates[0];
           var lat = pointResult[i].geometry.coordinates[1];
           entityArray[i] = viewer.entities.add({
               position : Cesium.Cartesian3.fromDegrees(lon, lat,height),
               nameID:pointResult[i].time,
               billboard :{
                   image : '/assets/images/p.png',
                   width:5,
                   height:5,
                   color : color
               }
           });
           entityArray[i].isAvailable = isAvailable;
       }
       var colorC = new Cesium.Color(192/255,16/255,26/255, 0.8);
       //创建扩散点
       endPointArray[i] = viewer.entities.add({
           position : Cesium.Cartesian3.fromDegrees(center[0],center[1],height),
           point : {
               show : true, // default
               color : colorC,//Cesium.Color.RED, // default: WHITE
               pixelSize : 24 // default: 1
           }
       });

   };

  return new Curve;
});
