/**
 *
 * @author by <a href="mailto:chaomashi@gmail.com">c</a>
 * @version v1.0 2019/7/18/20:15  Copyright gtmap Corp
 */

define(['knockout',
    'Cesium',
    'windy',
    'heatMap',
    'CompositeView',
    "mustache",
    "./model",
    "global/utils/MapUtils",
    "./migration",
    "./migration_model",
    "./traffic_model",
    "./upload",
    "./curve",
    "global/core/Model",
    "global/core/AddTimeLine",
    'global/core/EventBus',
    "./traffic",
    "global/core/MapVLayerProvider",
    "inputSpinner"], function (ko,
                               Cesium,
                               Wind,
                               heatmap,
                               CompositeView,
                               Mustache,
                               Model,
                               MapUtils,
                               P2pTool,
                               migrationModel,
                               traffic_model,
                               toShp,
                               curve,
                               model,
                               addTimeline, EventBus) {

    var instance,
        /*调用的一些实例*/
        chartView,
        onChange,

        $that = me = {

            inited: false,
            // init fun
            init: function () {
                try {
                    // 读取配置
                    $that.themeDataModel = this.config.model;
                    $that.colorBarOptions = this.config.colorBarOptions;
                    onChange = new ONChange();
                    ko.applyBindings(onChange, document.getElementById("widget-themetic"));
                    onChange.renderPage();

                    //暴露热力图接口调用
                    window.h337 = heatmap;
                    //修饰numinput
                    $("input[type='number']").inputSpinner();
                    model.setViewer(MapUtils.viewer);
                    chartView = new CompositeView("globalContainer", MapUtils.viewer);
                } catch (e) {
                    console.log(e);
                }
            },

            // open event
            onOpen: function () {
                $that.clear();
            },

            // close event
            onClose: function () {
                $that.clear();
            },

            // pause event
            onPause: function () {
                $that.clear();
            },

            // 清除
            clear: function () {
                model.clear();
                try {
                    $("#div-bottom-pane").hide();
                } catch (e) {

                }
                if (promise) {
                    MapUtils.viewer.dataSources.remove(promise);
                }
                if (isWindy) {
                    $that.trail.removeLines();
                    clearInterval($that.timer);//清除定时器
                    isWindy = false;
                }
                if (chartView) {
                    chartView.destroy();
                }
                MapUtils.viewer.entities.removeAll();//移除实例
                $("#video").empty();//清除vedio
                $(".theme-card").remove(); // 清除编辑菜单
                //清除mapV图层
                if (mapvLyr.length > 0) {
                    mapvLyr[0].destroy();
                    mapvLyr = [];
                }
            },

            //获取theme
            getCheckedTheme: function () {
                if (onChange) {
                    return onChange.getCheckedTheme();
                } else {
                    return null;
                }

            },

            //设置theme
            checkTheme: function (theme) {
                if (theme.renderType == "view") {
                    //触发事件
                    chooseView(theme);
                } else {
                    chooseModel(theme);
                }
                return;
                onChange = onChange || new ONChange();
                onChange.checkTheme(theme);
            },

            insertGeoJson: "",

            //定时器
            timer: null,

            // 存放风力实例
            trail: null,

            // 存放新建可视化数据源
            viewSource: "",

            // 存放新建可视化模版
            viewModel: "",

            // todo some mock
            // 存放前台【我的】面板配置(从模版读取,新增和删除模版操作都从该数组中进行修改)
            themeMy: [],
            themeShare: [],

            // 数据源存放【用于选定新增可视化的数据源存放】
            themeDataSource: [],

            // 可视化模版显示【用于选择模版】
            themeDataModel: [],

            colorBarOptions: [],

            // 【我的数据】

            recordMyTotalCount: 400,
            recordMy: [
                // {
                //     "id":"",
                //     "name":"世界人口流动数据点集",
                //     "url":"../mock/flight.json",
                //     "check":false
                // },
                // {
                //     "id":"",
                //     "name":"城市pm2.5数据散点",
                //     "url":"",
                //     "check":false
                // },
                // {
                //     "id":"",
                //     "name":"北京病患人口流动数据点集",
                //     "url":"../mock/flow.json",
                //     "check":false
                // },
                // {
                //     "id":"",
                //     "name":"交通道路拥堵值点集",
                //     "url":"../mock/trans.json",
                //     "check":false
                // }
            ],

            recordShareTotalCount: 400,
            recordShare: [],

            recordAllTotalCount: 400,
            recordAll: [],

            //【共享】
            themeShare: [],

            themeShareTotalCount: 400,

            // 视屏链接
            vedioLink: "<video id='videoContainer' " +
                "muted='' autoplay='' loop='' crossorigin='' controls='' " +
                "style='width: 200px;height: 180px'>" +
                "<source src='https://cesiumjs.org/videos/Sandcastle/big-buck-bunny_trailer.mp4' type='video/mp4'>" +
                "</video>",

            // 弹窗片段
            editLayer: "<div class='theme-card'><div class='theme-tri'></div><div class='theme-content'>" +
                "<div class='themeCard-text'></div>" +
                "<div>透明度:<div id='themeCard-slider'></div></div>" +
                "<div>热力半径:<div id='themeCard-round'><input style='width: 60%;' type='number' min='0' max='100' step='5' placeholder='设定尺寸'></div></div>" +
                "<div>颜色:<br><div id='themeCard-color'></div></div>" +
                "</div></div>",

// 以wall的形式将视频贴到球体上
            addVedio: function () {
                $("#video").html($that.vedioLink);
                var videoElement = document.getElementById("videoContainer");
                var videoWall = MapUtils.viewer.entities.add({
                    position: Cesium.Cartesian3.fromDegrees(116.44829499568006, 39.9038584836946, 1000),
                    wall: {
                        positions: Cesium.Cartesian3.fromDegreesArrayHeights([116.44829499568006, 39.9038584836946, 1000,
                            116.34829499568006, 39.9038584836946, 1000]),
                        material: videoElement
                    }
                });
                MapUtils.viewer.trackedEntity = videoWall;
            },

// 展示风力图效果
            addWind: function (data) {
                isWindy = true;
                //创建一个风向图轨迹实例
                $that.trail = new Wind(data, MapUtils.viewer);
                //定时计算其运动轨迹
                $that.timer = setInterval(function () {
                    $that.trail.animate();
                }, 30);
            },

//在s3m模型上叠加热力图效果
            addHeat: function () {
                var scene = MapUtils.viewer.scene;
                var SCP_CBD_GROUND1 =
                    "http://www.supermapol.com/realspace/services/3D-WebGLCBD/rest/realspace/datas/Ground_1@%E6%96%B0CBD/config";
                var SCP_CBD_BUILD =
                    "http://www.supermapol.com/realspace/services/3D-WebGLCBD/rest/realspace/datas/Building@%E6%96%B0CBD/config";
                // 添加S3M图层
                var ground1Promise = scene.addS3MTilesLayerByScp(SCP_CBD_GROUND1, {name: 'ground1'});
                var buildPromise = scene.addS3MTilesLayerByScp(SCP_CBD_BUILD, {name: 'build'});
                var promiseSet = [ground1Promise, buildPromise];
                Cesium.when.all(promiseSet, function (layers) {
                    scene.camera.flyTo({ // 图层加载完成,设置相机位置
                        destination: Cesium.Cartesian3.fromDegrees(116.44829499568006, 39.9038584836946, 200.729171148720404),
                        orientation: {
                            heading: 5.462824916628415,
                            pitch: -1.5695598976662626,
                            roll: 6.2831853071570976
                        }
                    });
                    //生成一个随机点的热力图
                    $that.createHeatmap();
                    //加到绘制的矩形范围中
                    var positions = [];
                    var clickCount = 0;
                    //处理绘制与单击事件
                    var screenSpaceEventHandler = new Cesium.ScreenSpaceEventHandler(scene.canvas);
                    var polylineHandler = new Cesium.DrawHandler(MapUtils.viewer, Cesium.DrawMode.Line);
                    screenSpaceEventHandler.setInputAction(function (evt) {
                        // 返回笛卡尔坐标结果(需要支持深度纹理)
                        var position = scene.pickPosition(evt.position);
                        positions.push(position);
                        clickCount++;
                        if (clickCount === 2) {
                            //绘制完成时触发事件，
                            polylineHandler.drawEvt.raiseEvent(positions);
                        }
                    }, Cesium.ScreenSpaceEventType.LEFT_CLICK);
                    //绘制的生命周期
                    //绘制handler的激活事件
                    polylineHandler.activeEvt.addEventListener(function (isActive) {
                        if (isActive == true) {
                            MapUtils.viewer.enableCursorStyle = false;
                            MapUtils.viewer._element.style.cursor = '';
                            $('body').removeClass('drawCur').addClass('drawCur');
                        } else {
                            MapUtils.viewer.enableCursorStyle = true;
                            $('body').removeClass('drawCur');
                        }
                    });
                    // 注册函数在绘制移动时增加提示窗口
                    polylineHandler.movingEvt.addEventListener(function (windowPosition) {
                        //tooltiptooltip.showAt(windowPosition,'<p>两点定一个矩形</p>');
                    });
                    // 注册一个回调函数，在完成绘制后执行
                    polylineHandler.drawEvt.addEventListener(function (result) {
                        //禁用handler
                        polylineHandler.deactivate();
                        polylineHandler.polyline.show = false;
                        // 将返回的结果定义进一个矩形，并把热力图贴进去
                        var pts = result.object ? result.object.positions : result;
                        //创建一个虚拟img节点
                        var mycanvas = document.getElementsByClassName("heatmap-canvas");
                        var imgData = mycanvas[1].toDataURL("image/png");
                        var img = new Image();
                        img.src = imgData;
                        img.onload = function () {
                            for (var index in layers) {
                                layers[index].addOverlayImage({
                                    bounds: Cesium.Rectangle.fromCartesianArray(pts),
                                    name: 'heat-map' + Date.now(),
                                    image: img
                                });
                            }
                            // 重新激活状态
                            clickCount = 0;
                            positions = [];
                            polylineHandler.activate();
                        }
                    });
                    polylineHandler.activate();
                    $('#loadingbar').remove(); // 移除加载动画
                }, function (e) {
                    if (widget._showRenderLoopErrors) {
                        var title = '加载SCP失败，请检查网络连接状态或者url地址是否正确？';
                        widget.showErrorPanel(title, undefined, e);
                    }
                });
            },

            /*创建热力图模型*/
            createHeatmap: function () {
                var heatmapInstance = h337.create({
                    container: document.querySelector('.heatmap')
                });
                var points = [];
                var max = 0;
                var width = 840;
                var height = 400;
                var len = 200;
                while (len--) {
                    var val = Math.floor(Math.random() * 100);
                    max = Math.max(max, val);
                    var point = {
                        x: Math.floor(Math.random() * width),
                        y: Math.floor(Math.random() * height),
                        value: val
                    };
                    points.push(point)
                }
                var data = {
                    max: max,
                    data: points
                };
                heatmapInstance.setData(data);
            },

            /*创建一个散点图*/
            createScatterMap: function () {
                var data = [
                    {
                        name: '海门',
                        value: 9
                    }, {
                        name: '鄂尔多斯',
                        value: 12
                    }, {
                        name: '招远',
                        value: 12
                    }, {
                        name: '舟山',
                        value: 12
                    }, {
                        name: '齐齐哈尔',
                        value: 14
                    }, {
                        name: '盐城',
                        value: 15
                    }, {
                        name: '赤峰',
                        value: 16
                    }, {
                        name: '青岛',
                        value: 18
                    }, {
                        name: '乳山',
                        value: 18
                    }, {
                        name: '金昌',
                        value: 19
                    }, {
                        name: '泉州',
                        value: 21
                    }, {
                        name: '莱西',
                        value: 21
                    }, {
                        name: '日照',
                        value: 21
                    }, {
                        name: '胶南',
                        value: 22
                    }, {
                        name: '南通',
                        value: 23
                    }, {
                        name: '拉萨',
                        value: 24
                    }, {
                        name: '云浮',
                        value: 24
                    }, {
                        name: '梅州',
                        value: 25
                    }, {
                        name: '文登',
                        value: 25
                    }, {
                        name: '上海',
                        value: 25
                    }, {
                        name: '攀枝花',
                        value: 25
                    }, {
                        name: '威海',
                        value: 25
                    }, {
                        name: '承德',
                        value: 25
                    }, {
                        name: '厦门',
                        value: 26
                    }, {
                        name: '汕尾',
                        value: 26
                    }, {
                        name: '潮州',
                        value: 26
                    }, {
                        name: '丹东',
                        value: 27
                    }, {
                        name: '太仓',
                        value: 27
                    }, {
                        name: '曲靖',
                        value: 27
                    }, {
                        name: '烟台',
                        value: 28
                    }, {
                        name: '福州',
                        value: 29
                    }, {
                        name: '瓦房店',
                        value: 30
                    }, {
                        name: '即墨',
                        value: 30
                    }, {
                        name: '抚顺',
                        value: 31
                    }, {
                        name: '玉溪',
                        value: 31
                    }, {
                        name: '张家口',
                        value: 31
                    }, {
                        name: '阳泉',
                        value: 31
                    }, {
                        name: '莱州',
                        value: 32
                    }, {
                        name: '湖州',
                        value: 32
                    }, {
                        name: '汕头',
                        value: 32
                    }, {
                        name: '昆山',
                        value: 33
                    }, {
                        name: '宁波',
                        value: 33
                    }, {
                        name: '湛江',
                        value: 33
                    }, {
                        name: '揭阳',
                        value: 34
                    }, {
                        name: '荣成',
                        value: 34
                    }, {
                        name: '连云港',
                        value: 35
                    }, {
                        name: '葫芦岛',
                        value: 35
                    }, {
                        name: '常熟',
                        value: 36
                    }, {
                        name: '东莞',
                        value: 36
                    }, {
                        name: '河源',
                        value: 36
                    }, {
                        name: '淮安',
                        value: 36
                    }, {
                        name: '泰州',
                        value: 36
                    }, {
                        name: '南宁',
                        value: 37
                    }, {
                        name: '营口',
                        value: 37
                    }, {
                        name: '惠州',
                        value: 37
                    }, {
                        name: '江阴',
                        value: 37
                    }, {
                        name: '蓬莱',
                        value: 37
                    }, {
                        name: '韶关',
                        value: 38
                    }, {
                        name: '嘉峪关',
                        value: 38
                    }, {
                        name: '广州',
                        value: 38
                    }, {
                        name: '延安',
                        value: 38
                    }, {
                        name: '太原',
                        value: 39
                    }, {
                        name: '清远',
                        value: 39
                    }, {
                        name: '中山',
                        value: 39
                    }, {
                        name: '昆明',
                        value: 39
                    }, {
                        name: '寿光',
                        value: 40
                    }, {
                        name: '盘锦',
                        value: 40
                    }, {
                        name: '长治',
                        value: 41
                    }, {
                        name: '深圳',
                        value: 41
                    }, {
                        name: '珠海',
                        value: 42
                    }, {
                        name: '宿迁',
                        value: 43
                    }, {
                        name: '咸阳',
                        value: 43
                    }, {
                        name: '铜川',
                        value: 44
                    }, {
                        name: '平度',
                        value: 44
                    }, {
                        name: '佛山',
                        value: 44
                    }, {
                        name: '海口',
                        value: 44
                    }, {
                        name: '江门',
                        value: 45
                    }, {
                        name: '章丘',
                        value: 45
                    }, {
                        name: '肇庆',
                        value: 46
                    }, {
                        name: '大连',
                        value: 47
                    }, {
                        name: '临汾',
                        value: 47
                    }, {
                        name: '吴江',
                        value: 47
                    }, {
                        name: '石嘴山',
                        value: 49
                    }, {
                        name: '沈阳',
                        value: 50
                    }, {
                        name: '苏州',
                        value: 50
                    }, {
                        name: '茂名',
                        value: 50
                    }, {
                        name: '嘉兴',
                        value: 51
                    }, {
                        name: '长春',
                        value: 51
                    }, {
                        name: '胶州',
                        value: 52
                    }, {
                        name: '银川',
                        value: 52
                    }, {
                        name: '张家港',
                        value: 52
                    }, {
                        name: '三门峡',
                        value: 53
                    }, {
                        name: '锦州',
                        value: 54
                    }, {
                        name: '南昌',
                        value: 54
                    }, {
                        name: '柳州',
                        value: 54
                    }, {
                        name: '三亚',
                        value: 54
                    }, {
                        name: '自贡',
                        value: 56
                    }, {
                        name: '吉林',
                        value: 56
                    }, {
                        name: '阳江',
                        value: 57
                    }, {
                        name: '泸州',
                        value: 57
                    }, {
                        name: '西宁',
                        value: 57
                    }, {
                        name: '宜宾',
                        value: 58
                    }, {
                        name: '呼和浩特',
                        value: 58
                    }, {
                        name: '成都',
                        value: 58
                    }, {
                        name: '大同',
                        value: 58
                    }, {
                        name: '镇江',
                        value: 59
                    }, {
                        name: '桂林',
                        value: 59
                    }, {
                        name: '张家界',
                        value: 59
                    }, {
                        name: '宜兴',
                        value: 59
                    }, {
                        name: '北海',
                        value: 60
                    }, {
                        name: '西安',
                        value: 61
                    }, {
                        name: '金坛',
                        value: 62
                    }, {
                        name: '东营',
                        value: 62
                    }, {
                        name: '牡丹江',
                        value: 63
                    }, {
                        name: '遵义',
                        value: 63
                    }, {
                        name: '绍兴',
                        value: 63
                    }, {
                        name: '扬州',
                        value: 64
                    }, {
                        name: '常州',
                        value: 64
                    }, {
                        name: '潍坊',
                        value: 65
                    }, {
                        name: '重庆',
                        value: 66
                    }, {
                        name: '台州',
                        value: 67
                    }, {
                        name: '南京',
                        value: 67
                    }, {
                        name: '滨州',
                        value: 70
                    }, {
                        name: '贵阳',
                        value: 71
                    }, {
                        name: '无锡',
                        value: 71
                    }, {
                        name: '本溪',
                        value: 71
                    }, {
                        name: '克拉玛依',
                        value: 72
                    }, {
                        name: '渭南',
                        value: 72
                    }, {
                        name: '马鞍山',
                        value: 72
                    }, {
                        name: '宝鸡',
                        value: 72
                    }, {
                        name: '焦作',
                        value: 75
                    }, {
                        name: '句容',
                        value: 75
                    }, {
                        name: '北京',
                        value: 79
                    }, {
                        name: '徐州',
                        value: 79
                    }, {
                        name: '衡水',
                        value: 80
                    }, {
                        name: '包头',
                        value: 80
                    }, {
                        name: '绵阳',
                        value: 80
                    }, {
                        name: '乌鲁木齐',
                        value: 84
                    }, {
                        name: '枣庄',
                        value: 84
                    }, {
                        name: '杭州',
                        value: 84
                    }, {
                        name: '淄博',
                        value: 85
                    }, {
                        name: '鞍山',
                        value: 86
                    }, {
                        name: '溧阳',
                        value: 86
                    }, {
                        name: '库尔勒',
                        value: 86
                    }, {
                        name: '安阳',
                        value: 90
                    }, {
                        name: '开封',
                        value: 90
                    }, {
                        name: '济南',
                        value: 92
                    }, {
                        name: '德阳',
                        value: 93
                    }, {
                        name: '温州',
                        value: 95
                    }, {
                        name: '九江',
                        value: 96
                    }, {
                        name: '邯郸',
                        value: 98
                    }, {
                        name: '临安',
                        value: 99
                    }, {
                        name: '兰州',
                        value: 99
                    }, {
                        name: '沧州',
                        value: 100
                    }, {
                        name: '临沂',
                        value: 103
                    }, {
                        name: '南充',
                        value: 104
                    }, {
                        name: '天津',
                        value: 105
                    }, {
                        name: '富阳',
                        value: 106
                    }, {
                        name: '泰安',
                        value: 112
                    }, {
                        name: '诸暨',
                        value: 112
                    }, {
                        name: '郑州',
                        value: 113
                    }, {
                        name: '哈尔滨',
                        value: 114
                    }, {
                        name: '聊城',
                        value: 116
                    }, {
                        name: '芜湖',
                        value: 117
                    }, {
                        name: '唐山',
                        value: 119
                    }, {
                        name: '平顶山',
                        value: 119
                    }, {
                        name: '邢台',
                        value: 119
                    }, {
                        name: '德州',
                        value: 120
                    }, {
                        name: '济宁',
                        value: 120
                    }, {
                        name: '荆州',
                        value: 127
                    }, {
                        name: '宜昌',
                        value: 130
                    }, {
                        name: '义乌',
                        value: 132
                    }, {
                        name: '丽水',
                        value: 133
                    }, {
                        name: '洛阳',
                        value: 134
                    }, {
                        name: '秦皇岛',
                        value: 136
                    }, {
                        name: '株洲',
                        value: 143
                    }, {
                        name: '石家庄',
                        value: 147
                    }, {
                        name: '莱芜',
                        value: 148
                    }, {
                        name: '常德',
                        value: 152
                    }, {
                        name: '保定',
                        value: 153
                    }, {
                        name: '湘潭',
                        value: 154
                    }, {
                        name: '金华',
                        value: 157
                    }, {
                        name: '岳阳',
                        value: 169
                    }, {
                        name: '长沙',
                        value: 175
                    }, {
                        name: '衢州',
                        value: 177
                    }, {
                        name: '廊坊',
                        value: 193
                    }, {
                        name: '菏泽',
                        value: 194
                    }, {
                        name: '合肥',
                        value: 229
                    }, {
                        name: '武汉',
                        value: 273
                    }, {
                        name: '大庆',
                        value: 279
                    }];
                var geoCoordMap = {
                    '海门': [121.15, 31.89],
                    '鄂尔多斯': [109.781327, 39.608266],
                    '招远': [120.38, 37.35],
                    '舟山': [122.207216, 29.985295],
                    '齐齐哈尔': [123.97, 47.33],
                    '盐城': [120.13, 33.38],
                    '赤峰': [118.87, 42.28],
                    '青岛': [120.33, 36.07],
                    '乳山': [121.52, 36.89],
                    '金昌': [102.188043, 38.520089],
                    '泉州': [118.58, 24.93],
                    '莱西': [120.53, 36.86],
                    '日照': [119.46, 35.42],
                    '胶南': [119.97, 35.88],
                    '南通': [121.05, 32.08],
                    '拉萨': [91.11, 29.97],
                    '云浮': [112.02, 22.93],
                    '梅州': [116.1, 24.55],
                    '文登': [122.05, 37.2],
                    '上海': [121.48, 31.22],
                    '攀枝花': [101.718637, 26.582347],
                    '威海': [122.1, 37.5],
                    '承德': [117.93, 40.97],
                    '厦门': [118.1, 24.46],
                    '汕尾': [115.375279, 22.786211],
                    '潮州': [116.63, 23.68],
                    '丹东': [124.37, 40.13],
                    '太仓': [121.1, 31.45],
                    '曲靖': [103.79, 25.51],
                    '烟台': [121.39, 37.52],
                    '福州': [119.3, 26.08],
                    '瓦房店': [121.979603, 39.627114],
                    '即墨': [120.45, 36.38],
                    '抚顺': [123.97, 41.97],
                    '玉溪': [102.52, 24.35],
                    '张家口': [114.87, 40.82],
                    '阳泉': [113.57, 37.85],
                    '莱州': [119.942327, 37.177017],
                    '湖州': [120.1, 30.86],
                    '汕头': [116.69, 23.39],
                    '昆山': [120.95, 31.39],
                    '宁波': [121.56, 29.86],
                    '湛江': [110.359377, 21.270708],
                    '揭阳': [116.35, 23.55],
                    '荣成': [122.41, 37.16],
                    '连云港': [119.16, 34.59],
                    '葫芦岛': [120.836932, 40.711052],
                    '常熟': [120.74, 31.64],
                    '东莞': [113.75, 23.04],
                    '河源': [114.68, 23.73],
                    '淮安': [119.15, 33.5],
                    '泰州': [119.9, 32.49],
                    '南宁': [108.33, 22.84],
                    '营口': [122.18, 40.65],
                    '惠州': [114.4, 23.09],
                    '江阴': [120.26, 31.91],
                    '蓬莱': [120.75, 37.8],
                    '韶关': [113.62, 24.84],
                    '嘉峪关': [98.289152, 39.77313],
                    '广州': [113.23, 23.16],
                    '延安': [109.47, 36.6],
                    '太原': [112.53, 37.87],
                    '清远': [113.01, 23.7],
                    '中山': [113.38, 22.52],
                    '昆明': [102.73, 25.04],
                    '寿光': [118.73, 36.86],
                    '盘锦': [122.070714, 41.119997],
                    '长治': [113.08, 36.18],
                    '深圳': [114.07, 22.62],
                    '珠海': [113.52, 22.3],
                    '宿迁': [118.3, 33.96],
                    '咸阳': [108.72, 34.36],
                    '铜川': [109.11, 35.09],
                    '平度': [119.97, 36.77],
                    '佛山': [113.11, 23.05],
                    '海口': [110.35, 20.02],
                    '江门': [113.06, 22.61],
                    '章丘': [117.53, 36.72],
                    '肇庆': [112.44, 23.05],
                    '大连': [121.62, 38.92],
                    '临汾': [111.5, 36.08],
                    '吴江': [120.63, 31.16],
                    '石嘴山': [106.39, 39.04],
                    '沈阳': [123.38, 41.8],
                    '苏州': [120.62, 31.32],
                    '茂名': [110.88, 21.68],
                    '嘉兴': [120.76, 30.77],
                    '长春': [125.35, 43.88],
                    '胶州': [120.03336, 36.264622],
                    '银川': [106.27, 38.47],
                    '张家港': [120.555821, 31.875428],
                    '三门峡': [111.19, 34.76],
                    '锦州': [121.15, 41.13],
                    '南昌': [115.89, 28.68],
                    '柳州': [109.4, 24.33],
                    '三亚': [109.511909, 18.252847],
                    '自贡': [104.778442, 29.33903],
                    '吉林': [126.57, 43.87],
                    '阳江': [111.95, 21.85],
                    '泸州': [105.39, 28.91],
                    '西宁': [101.74, 36.56],
                    '宜宾': [104.56, 29.77],
                    '呼和浩特': [111.65, 40.82],
                    '成都': [104.06, 30.67],
                    '大同': [113.3, 40.12],
                    '镇江': [119.44, 32.2],
                    '桂林': [110.28, 25.29],
                    '张家界': [110.479191, 29.117096],
                    '宜兴': [119.82, 31.36],
                    '北海': [109.12, 21.49],
                    '西安': [108.95, 34.27],
                    '金坛': [119.56, 31.74],
                    '东营': [118.49, 37.46],
                    '牡丹江': [129.58, 44.6],
                    '遵义': [106.9, 27.7],
                    '绍兴': [120.58, 30.01],
                    '扬州': [119.42, 32.39],
                    '常州': [119.95, 31.79],
                    '潍坊': [119.1, 36.62],
                    '重庆': [106.54, 29.59],
                    '台州': [121.420757, 28.656386],
                    '南京': [118.78, 32.04],
                    '滨州': [118.03, 37.36],
                    '贵阳': [106.71, 26.57],
                    '无锡': [120.29, 31.59],
                    '本溪': [123.73, 41.3],
                    '克拉玛依': [84.77, 45.59],
                    '渭南': [109.5, 34.52],
                    '马鞍山': [118.48, 31.56],
                    '宝鸡': [107.15, 34.38],
                    '焦作': [113.21, 35.24],
                    '句容': [119.16, 31.95],
                    '北京': [116.46, 39.92],
                    '徐州': [117.2, 34.26],
                    '衡水': [115.72, 37.72],
                    '包头': [110, 40.58],
                    '绵阳': [104.73, 31.48],
                    '乌鲁木齐': [87.68, 43.77],
                    '枣庄': [117.57, 34.86],
                    '杭州': [120.19, 30.26],
                    '淄博': [118.05, 36.78],
                    '鞍山': [122.85, 41.12],
                    '溧阳': [119.48, 31.43],
                    '库尔勒': [86.06, 41.68],
                    '安阳': [114.35, 36.1],
                    '开封': [114.35, 34.79],
                    '济南': [117, 36.65],
                    '德阳': [104.37, 31.13],
                    '温州': [120.65, 28.01],
                    '九江': [115.97, 29.71],
                    '邯郸': [114.47, 36.6],
                    '临安': [119.72, 30.23],
                    '兰州': [103.73, 36.03],
                    '沧州': [116.83, 38.33],
                    '临沂': [118.35, 35.05],
                    '南充': [106.110698, 30.837793],
                    '天津': [117.2, 39.13],
                    '富阳': [119.95, 30.07],
                    '泰安': [117.13, 36.18],
                    '诸暨': [120.23, 29.71],
                    '郑州': [113.65, 34.76],
                    '哈尔滨': [126.63, 45.75],
                    '聊城': [115.97, 36.45],
                    '芜湖': [118.38, 31.33],
                    '唐山': [118.02, 39.63],
                    '平顶山': [113.29, 33.75],
                    '邢台': [114.48, 37.05],
                    '德州': [116.29, 37.45],
                    '济宁': [116.59, 35.38],
                    '荆州': [112.239741, 30.335165],
                    '宜昌': [111.3, 30.7],
                    '义乌': [120.06, 29.32],
                    '丽水': [119.92, 28.45],
                    '洛阳': [112.44, 34.7],
                    '秦皇岛': [119.57, 39.95],
                    '株洲': [113.16, 27.83],
                    '石家庄': [114.48, 38.03],
                    '莱芜': [117.67, 36.19],
                    '常德': [111.69, 29.05],
                    '保定': [115.48, 38.85],
                    '湘潭': [112.91, 27.87],
                    '金华': [119.64, 29.12],
                    '岳阳': [113.09, 29.37],
                    '长沙': [113, 28.21],
                    '衢州': [118.88, 28.97],
                    '廊坊': [116.7, 39.53],
                    '菏泽': [115.480656, 35.23375],
                    '合肥': [117.27, 31.86],
                    '武汉': [114.31, 30.52],
                    '大庆': [125.03, 46.58]
                };
                var convertData = function (data) {
                    var res = [];
                    for (var i = 0; i < data.length; i++) {
                        var geoCoord = geoCoordMap[data[i].name];
                        if (geoCoord) {
                            res.push({
                                name: data[i].name,
                                value: geoCoord.concat(data[i].value)
                            });
                        }
                    }
                    return res;
                };
                var option = {
                    animation: false,
                    title: {
                        text: '全国主要城市空气质量',
                        subtext: 'data from PM25.in',
                        sublink: 'http://www.pm25.in',
                        left: 'center',
                        textStyle: {
                            color: '#fff'
                        }
                    },
                    tooltip: {
                        trigger: 'item'
                    },
                    legend: {
                        orient: 'vertical',
                        y: 'bottom',
                        x: 'right',
                        data: ['pm2.5'],
                        textStyle: {
                            color: '#fff'
                        }
                    },
                    GLMap: {},
                    series: [
                        {
                            name: 'pm2.5',
                            type: 'effectScatter',
                            coordinateSystem: 'GLMap',
                            data: convertData(data),
                            symbolSize: function (val) {
                                return val[2] / 10;
                            },
                            hoverAnimation: true,
                            label: {
                                normal: {
                                    formatter: '{b}',
                                    position: 'right',
                                    show: true
                                },
                                emphasis: {
                                    show: true
                                }
                            },
                            itemStyle: {
                                normal: {
                                    color: 'purple'
                                }
                            },
                            zlevel: 1,
                            tooltip: {
                                formatter: function (params, ticket, callback) {
                                    return "a" + "<br />" +
                                        "b";
                                }
                            }
                        },
                        {
                            name: 'Top 5',
                            type: 'effectScatter',
                            coordinateSystem: 'GLMap',
                            data: convertData(data.sort(function (a, b) {
                                return b.value - a.value;
                            }).slice(0, 6)),
                            symbolSize: function (val) {
                                return val[2] / 10;
                            },
                            showEffectOn: 'render',
                            rippleEffect: {
                                brushType: 'stroke'
                            },
                            hoverAnimation: true,
                            label: {
                                normal: {
                                    formatter: '{b}',
                                    position: 'right',
                                    show: true
                                }
                            },
                            itemStyle: {
                                normal: {
                                    color: 'yellow',
                                    shadowBlur: 10,
                                    shadowColor: 'purple'
                                }
                            },
                            zlevel: 1
                        }]
                };
                chartView.updateOverlay(option);
            },

            /*创建一个流动图*/
            createFlightMap: function (data) {
                var airports = data.airports.map(function (item) {
                    return {
                        coord: [item[3], item[4]]
                    }
                });

                function getAirportCoord(idx) {
                    return [data.airports[idx][3], data.airports[idx][4]];
                }

                // Route: [airlineIndex, sourceAirportIndex, destinationAirportIndex]
                var routesGroupByAirline = {};
                data.routes.forEach(function (route) {
                    var airline = data.airlines[route[0]];
                    var airlineName = airline[0];
                    if (!routesGroupByAirline[airlineName]) {
                        routesGroupByAirline[airlineName] = [];
                    }
                    routesGroupByAirline[airlineName].push(route);
                });

                var pointsData = [];
                data.routes.forEach(function (airline) {
                    pointsData.push(getAirportCoord(airline[1]));
                    pointsData.push(getAirportCoord(airline[2]));
                });

                var series = data.airlines.map(function (airline) {
                    var airlineName = airline[0];
                    var routes = routesGroupByAirline[airlineName];

                    if (!routes) {
                        return null;
                    }
                    return {
                        type: 'lines',
                        name: airlineName,
                        coordinateSystem: 'GLMap',
                        zlevel: 0,
                        blendMode: 'lighter',
                        effect: {
                            show: true,
                            trailWidth: 2,
                            trailLength: 0.15,
                            trailOpacity: 1,
                            trailColor: 'rgb(30, 30, 60)'
                        },
                        lineStyle: {
                            width: 1,
                            color: 'rgb(50, 50, 150)',
                            // color: 'rgb(118, 233, 241)',
                            opacity: 0.1
                        },
                        data: routes.map(function (item) {
                            return [airports[item[1]].coord, airports[item[2]].coord];
                        })
                    };
                }).filter(function (series) {
                    return !!series;
                });
                series.push({
                    type: 'scatter',
                    coordinateSystem: 'GLMap',
                    blendMode: 'lighter',
                    symbolSize: 2,
                    itemStyle: {
                        color: 'rgb(50, 50, 150)',
                        opacity: 0.2
                    },
                    data: pointsData
                });
                var option = {
                    // legend: {
                    //     selectedMode: 'single',
                    //     left: 'right',
                    //     top: 'middle',
                    //     data: Object.keys(routesGroupByAirline),
                    //     orient: 'vertical',
                    //     textStyle: {
                    //         color: '#fff'
                    //     }
                    // },
                    GLMap: {},
                    series: series
                };
                chartView.updateOverlay(option);
            },

            /*创建一个*/
            createFlowMap: function (data) {
                var color = ["#a6c84c", "#ffa022", "#46bee9"];
                var flowWay = [
                    ["", [[{name: "南京市"}, {name: "上海市", value: 195}], [{name: "南京市"}, {
                        name: "广东省",
                        value: 90
                    }], [{name: "南京市"}, {name: "辽宁省", value: 80}], [{name: "南京市"}, {
                        name: "湖北省",
                        value: 70
                    }], [{name: "南京市"}, {name: "内蒙古", value: 70}], [{name: "南京市"}, {
                        name: "江苏省",
                        value: 60
                    }], [{name: "南京市"}, {name: "新疆维吾尔自治区", value: 70}], [{name: "南京市"}, {
                        name: "四川省",
                        value: 40
                    }], [{name: "南京市"}, {name: "云南省", value: 130}], [{name: "南京市"}, {
                        name: "黑龙江省",
                        value: 130
                    }], [{name: "南京市"}, {name: "甘肃省", value: 200}], [{name: "南京市"}, {
                        name: "西藏自治区",
                        value: 60
                    }]]]
                ];
                var seris = [];
                var result = data;
                var managerData = function (e) {
                    for (var a = [], i = 0; i < e.length; i++) {
                        var n = e[i], r = result[n[0].name], o = result[n[1].name];
                        r && o && a.push({fromName: n[0].name, toName: n[1].name, coords: [r, o]})
                    }
                    return a
                };
                $.each(flowWay, function (i, e) {
                    seris.push({
                            name: e[0],
                            type: "lines",
                            coordinateSystem: "GLMap",
                            zlevel: 1,
                            effect: {show: !0, period: 6, trailLength: .7, color: "#fff", symbolSize: 10},
                            lineStyle: {normal: {color: color[0], width: 0, curveness: .2}},
                            data: managerData(e[1])
                        },
                        {
                            name: e[0],
                            type: "lines",
                            coordinateSystem: "GLMap",
                            zlevel: 2,
                            effect: {show: !0, period: 6, trailLength: .1, symbol: "arrow", symbolSize: 10},
                            lineStyle: {normal: {color: color[1], width: 4, opacity: .8, curveness: .2}},
                            data: managerData(e[1])
                        },
                        {
                            name: e[0],
                            type: "effectScatter",
                            coordinateSystem: "GLMap",
                            zlevel: 2,
                            rippleEffect: {brushType: "stroke"},
                            label: {normal: {show: !0, position: "right", formatter: "{b}"}},
                            symbolSize: function (e) {
                                return e[2] / 6
                            },
                            itemStyle: {
                                normal: {
                                    color: function (e) {
                                        var a = e.data.value[2];
                                        return a < 100 ? "green" : 150 < a ? "red" : "yellow"
                                    }
                                }
                            },
                            data: e[1].map(function (e) {
                                var valueData = result[e[1].name].concat([e[1].value]);
                                return {name: e[1].name, value: valueData}
                            })
                        });
                    var option =
                        {
                            animation: !1,
                            backgroundColor: "rgba(116, 112, 124, 0.2)",
                            title: {
                                text: "南京市流向图",
                                subtext: "(1月份统计结果)",
                                left: "center",
                                textStyle: {color: "#fff"},
                                subtextStyle: {color: "yellow", fontWeight: "bold", width: 3}
                            },
                            legend: {
                                orient: "vertical",
                                top: "6%",
                                left: "center",
                                data: ["南京市"],
                                textStyle: {color: "#fff"},
                                selectedMode: "single"
                            },
                            GLMap: {},
                            series: seris
                        };
                    chartView.updateOverlay(option);
                });
            },

            /*创建一个公交线路图*/
            createTransMap: function (data) {
                //业务逻辑
                var getOption = function (o) {
                    return {
                        animation: !1,
                        GLMap: {},
                        visualMap: {
                            type: "piecewise",
                            left: "right",
                            top: "middle",
                            min: 0,
                            max: 15,
                            splitNumber: 5,
                            maxOpen: !0,
                            color: ["red", "yellow", "green"],
                            textStyle: {color: "#ffffff"}
                        },
                        tooltip: {
                            formatter: function (o, e, r) {
                                return "拥堵指数:" + o.value
                            }, trigger: "item"
                        },
                        series: [{
                            type: "lines",
                            coordinateSystem: "GLMap",
                            polyline: !0,
                            data: o,
                            lineStyle: {normal: {opacity: 1, width: 4}, emphasis: {width: 6}},
                            effect: {show: !0, symbolSize: 2, color: "white"}
                        }]
                    }
                };
                var option = getOption(data);
                chartView.updateOverlay(option);
                MapUtils.viewer.scene.camera.flyTo({ // 图层加载完成,设置相机位置
                    destination: Cesium.Cartesian3.fromDegrees(120.748, 30.768, 20000.73),
                    orientation: {
                        heading: 5.462824916628415,
                        pitch: -1.5695598976662626,
                        roll: 6.2831853071570976
                    }
                });
            },

            createTrafficByModel: function (data) {
                traffic_model.init(data, [118.800122, 32.069058])
            },

            /*创建一个中心点扩散流动图*/
            createTraffic: function () {
                var center = [106.540545, 29.531714];

                var height = 60 * 15;
                getCenter2Around(center, height);

                MapUtils.viewer.scene.camera.flyTo({ // 图层加载完成,设置相机位置
                    destination: Cesium.Cartesian3.fromDegrees(center[0], center[1], 20000)
                });
            }

        };


    /*************【初始化绑定及knockout】************/


    /*引用layui模块layui*/
    var element, layer, colorpicker, table;
    var promise;

    layui.use(['element', 'layer', 'colorpicker', 'slider', 'table'], function () {
        element = layui.element;
        element.render();
        layer = layui.layer;
        colorpicker = layui.colorpicker;
        slider = layui.slider;
        table = layui.table;
        //预定义颜色项
        colorpicker.render({
            elem: '#chooseColor'
            , color: '#c71585'
            , predefine: true // 开启预定义颜色
            , change: function (color) { //颜色改变的回调
                changeOption.color = color;
            }
        });
        //滑块
        slider.render({
            elem: '#slideChoose',
            value: 100,
            theme: '#2a80ff', //主题色
            width: '70%',
            change: function (value) {
                changeOption.slider = value / 100;
            }
        });
        //数据表格
        loadTable("dataSetTable", []);
        //dataServeTable
        loadTable("dataServeTable", []);
    });

    var p2p = new P2pTool;

    var isWindy = false;

    var mapvLyr = [];

    var serverData = []; // 存储服务接口数据实例


    /*监听数据变化*/
    var themeMyCount = {num: ""};
    var changeOption = {color: 'purple', slider: 1.0, title: "", size: 30, prop: ""};
    //定义处理程序
    var changeNum = {
        set: function (receiver, property, value) {
            $("#myView").text(value);
            //反射重新赋值
            receiver[property] = value;
            return Reflect.set(receiver, property, value);
        }
    };
    // 更改的一些参数值
    themeMyCount = new Proxy(themeMyCount, changeNum);
    changeOption = new Proxy(changeOption, {
        set: function (receiver, property, value) {
            // 重新请求参数
            $("#mapv0").css("opacity", receiver.slider);
            $("#echarts").css("opacity", receiver.slider);
            //反射重新赋值
            receiver[property] = value;
            return Reflect.set(receiver, property, value);
        }
    });


    /*注册ko的事件*/
    function ONChange(callBack) {
        var self = this;
        /**
         * 离开事件
         * 清空参数、重置数据源check与display
         */
        self.clear = function () {
            $(".param_div_container > div").hide();
            $("[name=param_prop]").empty();
            $.each(self.recordMy(), function (i, e) {
                var clone = self.clone(e);
                clone.display = true;
                clone.check = false;
                // (e.id !== btn.id)? clone.display = clone.check = false:clone.check = true;
                self.recordMy.replace(e, clone);
            });
        }

        //获取theme
        self.getCheckedTheme = function () {
            var theme;
            $(self.themeMy()).each(function (i, e) {
                if (e.check) {
                    theme = e;
                }
            })

            $(self.themeShare()).each(function (i, e) {
                if (e.check) {
                    theme = e;
                }
            })
            return theme;
        },

            //设置theme
            self.checkTheme = function (theme) {
                if (!theme) {
                    return;
                }
                if (!$that.inited) {
                    if (theme.renderType == "view") {
                        //触发事件
                        chooseView(theme);
                    } else {
                        chooseModel(theme, this);
                    }
                    return;
                }
                var targetTheme;
                $(self.themeMy()).each(function (i, e) {
                    if (e.id == theme.id) {
                        targetTheme = e;
                    }
                })

                $(self.themeShare()).each(function (i, e) {
                    if (e.id == theme.id) {
                        targetTheme = e;
                    }
                })
                if (!targetTheme) {
                    return;
                }
                self.clickThemes(targetTheme);
            },

            // 【我的数据】
            self.recordMy = ko.observableArray($that.recordMy);
        self.recordMyTotalCount = $that.recordMyTotalCount;

        self.recordShare = ko.observableArray($that.recordShare);
        self.recordShareTotalCount = $that.recordShareTotalCount;
        self.recordAll = ko.observableArray($that.recordAll);
        self.showRecordAllPage = ko.observable(true);

        // //绑定数据【用observableArray将其转化为可以监听改变的数据】
        self.themeMy = ko.observableArray($that.themeMy);// 我的可视化内容
        self.themeShare = ko.observableArray($that.themeShare); // 分享可视化内容

        self.themeShare = ko.observableArray($that.themeShare);
        self.themeShareTotalCount = $that.themeShareTotalCount;

        self.themeDataSource = ko.observableArray($that.themeDataSource);// 新增可视化数据集
        self.themeDataModel = ko.observableArray($that.themeDataModel);// 新增可视化模版类型

        // 【控制显示和隐藏参数】
        self.showThemetic = ko.observable(false);
        self.showDataset = ko.observable(false);
        // 【控制 可视化模板参数】
        self.themeParams = ko.observableArray([]);


        var dataSourceProps = {};

        //【加载专题图】
        self.exeThemePrivate = function (self, pageIndex) {
            var url = rootPath + "/map/theme/get?ownState=private";
            $.ajax({
                url: url,
                success: function (dt) {
                    if (!dt.hasOwnProperty("data")) {
                        layer.msg("加载渲染模型失败");
                        return;
                    }
                    // $(dt.data).each(function (i,e) {
                    //     e.id = e.mid;
                    //
                    // });
                    dt.data.push({
                        mid: "addNew",
                        name: "新增可视化"
                    })
                    $that.themeMy = dt.data;
                    $("#myView").text($that.themeMy.length - 1);
                    self.reLoadArr(self.themeMy, $that.themeMy);
                },
                error: function (e) {
                    layer.msg("加载渲染模型失败");
                }
            });
        }
        self.exeThemeShare = function (self, pageIndex) {
            var url = rootPath + "/map/theme/get?ownState=public";
            $.ajax({
                url: url,
                success: function (dt) {
                    if (!dt.hasOwnProperty("data")) {
                        layer.msg("加载渲染模型失败");
                        return;
                    }
                    // $(dt.data).each(function (i,e) {
                    //     e.id = e.mid;
                    //
                    // });
                    $that.themeShare = dt.data;
                    $("#shareView").text($that.themeShare.length);
                    self.reLoadArr(self.themeShare, $that.themeShare);
                },
                error: function (e) {
                    layer.msg("加载渲染模型失败");
                }
            });
        }
        self.loadTheme = function () {
            self.exeThemePrivate(self, 0);
            self.exeThemeShare(self, 0);
        }
        self.renderPage = function () {
            //初始化所有分页组建
            try {
                layui.use('laypage', function () {
                    var laypage = layui.laypage;
                    //数据 我的
                    laypage.render({
                        elem: 'my-record-page', //注意，这里的 test1 是 ID，不用加 # 号
                        count: $that.recordMyTotalCount,
                        groups: 3,
                        page: Math.ceil($that.recordMyTotalCount / 10),
                        layout: ['page'],
                        jump: function (obj, first) {
                            if ($that.recordMyTotalCount) {
                                var $count = $("<div></div>").addClass("theme-page-count").appendTo($("#my-record-page"));
                                $count.text("共 " + $that.recordMyTotalCount + " 条");
                            }
                            if (!first) {
                                self.exeRecordsPriSearch(self, obj.curr);
                            }
                        }
                        , theme: '#1E9FFF'
                    });
                    //数据检索
                    laypage.render({
                        elem: 'add-my-record-page', //注意，这里的 test1 是 ID，不用加 # 号
                        count: $that.recordAllTotalCount,
                        groups: 3,
                        page: Math.ceil($that.recordAllTotalCount / 10),
                        layout: ['page'],
                        jump: function (obj, first) {
                            if ($that.recordAllTotalCount) {
                                var $count = $("<div></div>").addClass("theme-page-count").appendTo($("#add-my-record-page"));
                                $count.text("共 " + $that.recordAllTotalCount + " 条");
                            }
                            if (!first) {
                                self.exeRecordsAllSearchProxy(self, obj.curr);
                            }
                        }
                        , theme: '#1E9FFF'
                    });

                    //数据 共享
                    laypage.render({
                        elem: 'share-record-page', //注意，这里的 test1 是 ID，不用加 # 号
                        count: $that.recordShareTotalCount,
                        groups: 3,
                        layout: ['page'],
                        jump: function (obj, first) {
                            if ($that.recordShareTotalCount) {
                                var $count = $("<div></div>").addClass("theme-page-count").appendTo($("#share-record-page"));
                                $count.text("共 " + $that.recordShareTotalCount + " 条");
                            }
                            if (!first) {
                                self.exeRecordsPublicSearch(self, obj.curr);
                            }
                        }
                        , theme: '#1E9FFF'
                    });


                });
            } catch (e) {
                console.log(e);
            }
        }
        //【加载数据】
        var baseUrl = rootPath + "/tablesinfo/search?";
        self.exeRecordsPriSearch = function (self, pageIndex) {
            var _pageIndex = pageIndex || 1;
            var url = baseUrl + "page=" + _pageIndex + "&limit=10&moduleCode=ccglzy&ownState=private";
            var val = "";
            $(".my-recordes-search-container>input").each(function (i, e) {
                if (!$(e).is(":hidden")) {
                    val = $(e).val();
                    return;
                }
            })
            if (val) {
                url = url + "&keyword=" + val;
            }
            showLoading();
            $.ajax({
                url: url,
                success: function (result) {
                    if (!result.hasOwnProperty("data")) {
                        layer.msg("加载数据失败");
                        return;
                    }
                    $(result.data).each(function (i, e) {
                        e.display = true;
                    });
                    $that.recordMyTotalCount = result.count;
                    $that.recordMy = result.data;// 我的数据
                    self.reLoadArr(self.recordMy, $that.recordMy);
                    if (!pageIndex) {
                        self.renderPage();
                    }
                }, complete: function () {
                    closeLoading();
                }
            });
        }
        self.exeRecordsPublicSearch = function (self, pageIndex) {
            showLoading();
            var _pageIndex = pageIndex || 1;
            $.ajax({
                url: baseUrl + "page=" + _pageIndex + "&limit=10&moduleCode=ccglzy&ownState=public",
                success: function (result) {
                    if (!result.hasOwnProperty("data")) {
                        layer.msg("加载数据失败");
                        return;
                    }
                    $that.recordShare = result.data;
                    $that.recordShareTotalCount = result.count;
                    self.reLoadArr(self.recordShare, $that.recordShare);
                    if (!pageIndex) {
                        self.renderPage();
                    }
                }, complete: function () {
                    closeLoading();
                }
            });
        }
        self.exeRecordsAllSearchProxy = function (self1, curr) {
            self.showRecordAllPage(true);
            if (typeof curr != "number") {
                curr = null;
            }
            self.exeRecordsAllSearch(self, curr);
            $(".theme-source-add").text("收缩");
            self.refreshDisplay(self.recordAll);
            $(".theme-source-add").text("收缩");
            $(".theme-info-content").hide();
        },
            self.exeRecordsAllSearch = function (self, pageIndex, tableIds, callBack) {
                showLoading();
                var _pageIndex = pageIndex || 1;
                var url = baseUrl + "page=" + _pageIndex + "&limit=10&moduleCode=ccglzy";
                if (tableIds) {
                    url = url + "&tableIds=" + tableIds;
                }
                var val = "";
                $(".my-recordes-search-container>input").each(function (i, e) {
                    if (!$(e).is(":hidden")) {
                        val = $(e).val();
                        return;
                    }
                })
                if (val) {
                    url = url + "&keyword=" + val;
                }
                $.ajax({
                    url: url,
                    success: function (result) {
                        if (!result.hasOwnProperty("data")) {
                            layer.msg("加载数据失败");
                            return;
                        }
                        $that.recordAll = result.data;
                        $($that.recordAll).each(function (i, e) {
                            e.display = true;
                        })
                        $that.recordAllTotalCount = result.count;
                        self.reLoadArr(self.recordAll, $that.recordAll);
                        if (!pageIndex) {
                            self.renderPage();
                        }
                        closeLoading();
                        if (callBack) {
                            callBack(self.recordAll);
                        }
                    }, error: function (e) {
                        closeLoading();
                    }
                });
            }
        // showLoading();
        //【加载数据仓储】
        self.loadRecord = function () {
            self.exeRecordsPriSearch(self);
            self.exeRecordsPublicSearch(self);
            self.exeRecordsAllSearch(self);
        }

        self.loadRecord();

        self.loadTheme();

        // 【绑定渲染专题效果】
        self.clickThemes = function (btn) {
            //
            //改变状态
            self.checkThis(btn, self.themeMy);
            self.checkThis(btn, self.themeShare);
            if (btn.renderType == "view") {
                //触发事件
                chooseView(btn);
            } else {
                chooseModel(btn, this);
            }
        };
        self.clickshares = function (btn) {
            chooseView(btn);
        };

        // 【控制新增模版菜单显示隐藏】
        self.addThemes = function () {
            model._option = {};
            $("#themeMain").hide();
            $("#theme-detail-label").text("新增可视化模板");
            self.showThemetic(true);
            //执行获取数据操作
            $("#themeticNew").addClass("layui-anim layui-anim-fadein");
            self.recordMyTotalCount = 400;
            self.recordShareTotalCount = 400;
            self.exeRecordsAllSearchProxy();
            $(".theme-info-content").hide();
            $(".grad_param_container").hide();
        };
        //后台程序
        var editClickCount = 0;
        var handler = null;
        self.editThemes = function () {
            model._option = {};
            if (this.renderType == "view") {
                editClickCount++;
                if (editClickCount == 5) {
                    editClickCount = 0;
                    this.params = this.params || {};
                    if (typeof this.params == "string") {
                        this.params = JSON.parse(this.params);
                    }
                    this.params.setMapView = MapUtils.getMapView();
                    layer.msg("设置定位。。。");
                    $.ajax({
                        url: rootPath + "/map/theme/set",
                        data: {content: JSON.stringify(this)},
                        contentType: "application/json",
                        success: function (e) {
                            layer.msg("保存成功!");
                        }, complete: function () {
                        }
                    });
                    layer.msg("保存成功！");
                    return;
                }
                handler = handler || setTimeout(function () {
                    editClickCount = 0;
                    handler = null;
                }, 1000)
                layer.msg("该模板暂不支持编辑操作");
                return;
            }
            $("#themeMain").hide();
            $("#theme-detail-label").text("编辑可视化模板");
            $(".theme-info-content").show();
            $(".grad_param_container").hide();
            self.showThemetic(true);
            $("#themeticNew").addClass("layui-anim layui-anim-fadein");
            var themeInfo = this;
            self.exeRecordsAllSearch(self, null, this.geoId, function (evt) {
                if (evt().length > 0) {
                    self.chooseDataSource(evt()[0], function () {
                        showLoading();
                        self.chooseDataModelForEdit(themeInfo);
                        $(".theme-source-add").text("展开");
                        // $("#add-my-record-page").hide();
                        self.showRecordAllPage(false);
                        closeLoading();
                    });

                }
            });
        }

        self.addDataset = function () {
            $that.uploadGeojson = "";
            $("#datasetInput").val("");
            model.clear();
            $("#themeMain").hide();
            self.showDataset(true);
            $("#datasetNew").addClass("layui-anim layui-anim-fadein");
        };
        self.hideDataset = function () {
            $("#themeMain").show();
            MapUtils.viewer.dataSources.remove(promise);
            self.showDataset(false);
            $that.geojson = "";
            model.clear();
            //重新加载数据
            self.loadRecord();
        };
        self.hideTheme = function () {
            $that.clear();
            self.clear();
            $("#themeMain").show();
            $("#choroplethLegend").remove();
            $(".icon-f-viewOff")
                .removeClass("icon-f-viewOff")
                .addClass("icon-f-view");
            if (promise) {
                MapUtils.viewer.dataSources.remove(promise);
            }
            self.showThemetic(false);
            self.refreshAll(self.themeDataSource);
            self.refreshAll(self.themeDataModel);
            $that.viewModel = $that.viewSource = "";

        };

        // 【控制新增可视化选择】
        self.chooseDataSource = function (obj, callBack) {
            //根据featureCollection 获取数据type
            var layerUrl = rootPath + "/metainfo/geo?id=" + obj.id;
            // var msg = layer.msg('加载中...', {icon: 16,shade: [0.5, '#f5f5f5'],scrollbar: false,offset: 'auto',time: 0});
            showLoading(function () {
                return $(".dataViews-pane").is(":visible");
            });
            $.ajax({
                url: layerUrl,
                success: function (result) {
                    var feaCol = null;
                    if (!result.data) {
                        return;
                    }
                    feaCol = JSON.parse(result.data);
                    if (feaCol instanceof Array) {
                        if (feaCol.length > 0) {
                            feaCol = feaCol[0];
                        } else {
                            return;
                        }
                    }
                    if (feaCol.features && feaCol.features.length == 0) {
                        layer.msg("数据不可为空！");
                        return;
                    }

                    obj.data = feaCol;
                    /*if (!feaCol.features[0].geometry) {
                        layer.msg("不支持的数据格式，请重新选择");
                        return;
                    }*/
                    //获取要素类型
                    var geoType = feaCol.features[0].geometry.type.toLowerCase();
                    switch (geoType) {
                        case "multipolygon":
                            obj.type = "polygon";
                            break;
                        case "polygon":
                            obj.type = "polygon";
                            break;
                        case "polyline":
                            obj.type = "lines";
                            break;
                        case "point":
                            obj.type = "points";
                            break;
                        case "multipoint":
                            obj.type = "points";
                            break;
                        default:
                            "";

                    }
                    $("#chooseModel").removeClass("layui-anim-fadein");
                    // 过滤模版
                    $.each(self.themeDataModel(), function (i, e) {
                        var temp2 = self.clone(e);
                        (!e.hasOwnProperty("type") || e.type === obj.type) ? (temp2.display = true) : (temp2.display = false);
                        self.themeDataModel.replace(e, temp2);
                    });
                    $("#chooseModel").addClass("layui-anim-fadein");
                    // 提升数据源面板
                    $.each(self.recordAll(), function (i, e) {
                        var clone = self.clone(e);
                        (e.id !== obj.id) ? clone.display = clone.check = false : clone.check = true;
                        self.recordAll.replace(e, clone);
                    });
                    $(".theme-source-add").show();
                    // 获取数据源
                    $that.viewSource = obj;
                    //获取属性信息
                    var properties = feaCol.features[0].properties;
                    dataSourceProps = properties;
                    self.reLoadArr(self.themeParams, dataSourceProps);
                    $("[name=theme_name]").val(obj.layerName);
                    $(".theme-info-content").show();

                    self.showRecordAllPage(false);
                    $(".theme-source-add").text("展开");
                    closeLoading();
                    if (callBack && typeof callBack == "function") {
                        callBack(obj);
                    }
                },
                error: function (e) {
                    console.log(e);
                    layer.msg("加载图层数据失败！");
                    closeLoading();
                },
                complete: function () {
                }
            });

        };
        self.chooseDataModel = function () {
            if ((!$that.viewSource) || (!$that.viewSource.data)) {
                layer.msg("请选择数据源！");
                return;
            }
            //重新初始化参数
            model._option = {
                color: 'purple',
                slider: 1.0,
                title: "",
                size: 30
            };
            changeOption = {color: 'purple', slider: 1.0, title: "", size: 30, prop: ""};
            self.checkThis(this, self.themeDataModel);
            //获取模版类型
            $that.viewModel = this.mid || this.id;
            //初始化渲染参数
            // $(".param_div_container > div").hide();
            $(".param_div_container").empty();
            if (this.option && this.option.params) {
                self.reLoadArr(self.themeParams, this.option.params);
                //初始化属性选择
                createParamControl(this.option.params);
            }
        };

        function createParamControl(params) {
            $(params).each(function (i, e) {
                switch (e.type.toLowerCase()) {
                    case "featureprop":
                        createPropSelect(e);
                        break;
                    case "featurepropnumber":
                        createPropNumberSelect(e);
                        break;
                    case "string":
                        createString(e);
                        break;
                    case "number":
                        createNumber(e);
                        break;
                    case "color":
                        createColorPiker(e);
                        break;
                    case "colorbar":
                        createColorBar(e);
                        break;
                    case "opcity":
                        creteOpcity(e);
                        break;
                    case "gradient":
                        createGradient(e);
                        break;
                    case "checkbox":
                        createCheckbox(e);
                        break;
                    case "setmapview":
                        createMapView(e);
                        break;
                }
            });
            layui.use(["form"], function (form) {
                form.render();
            });

            /**
             * 创建属性选择
             */
            function createPropSelect(e) {
                var $container = $("[name=" + e.name + "_div]");
                //初始化属性选择模板
                $container.empty();
                var $select = $("<select></select>")
                    .attr("name", e.name)
                    .attr("id", e.name + "_id")
                    .addClass("theme_param")
                    .addClass("select_param");
                $("<option></option>").attr("value", "").text("  空  ").appendTo($select);
                for (var proName in dataSourceProps) {
                    $("<option></option>").attr("value", proName).text(proName).appendTo($select);
                }
                $select.appendTo($container);
            }

            /**
             * 创建属性选择
             */
            function createPropNumberSelect(e) {
                var $container = $("[name=" + e.name + "_div]");
                //初始化属性选择模板
                $container.empty();
                var $select = $("<select></select>")
                    .attr("name", e.name)
                    .attr("id", e.name + "_id")
                    .addClass("theme_param")
                    .addClass("select_param");
                $("<option></option>").attr("value", "").text("  空  ").appendTo($select);
                for (var proName in dataSourceProps) {
                    if (isNaN(dataSourceProps[proName])) {
                        continue;
                    }
                    $("<option></option>").attr("value", proName).text(proName).appendTo($select);
                }
                $select.appendTo($container);
            }

            function createNumber(e) {
                var $container = $("[name=" + e.name + "_div]");
                //初始化属性选择模板
                $container.empty();
                var $input = $("<input type='number'/>").addClass("number_param").addClass("theme_param");
                $input.attr("name", e.name);
                var config = e.config;
                for (var i in config) {
                    $input.attr(i, config[i]);
                }
                $input.appendTo($container);
            }

            function createString(e) {
                var $container = $("[name=" + e.name + "_div]");
                //初始化属性选择模板
                $container.empty();
                var $input = $("<input type='text'/>").addClass("number_param").addClass("theme_param");
                $input.attr("name", e.name);
                var config = e.config;
                for (var i in config) {
                    $input.attr(i, config[i]);
                }
                $input.appendTo($container);
            }

            function createColorPiker(e) {
                layui.use(['element', 'colorpicker',], function () {
                    colorpicker = layui.colorpicker;
                    //预定义颜色项
                    colorpicker.render({
                        elem: '[name =' + e.name + '_div]'
                        , color: '#c71585'
                        , predefine: true // 开启预定义颜色
                        , change: function (color) { //颜色改变的回调
                            changeOption[e.name] = color;
                            // chooseModel();
                        }
                    });
                });
            }

            function createColorBar(e) {
                var colorOptions = e.colorBarOptions || $that.colorBarOptions;
                $("[name=" + e.name + "_div]").css("position", "relative");
                var $colorDiv = $("<div></div>").attr("name", e.name).addClass("colorBar");
                var $arrow = $("<i></i>")
                    .addClass("iconfont")
                    .addClass("icon-f-left")
                    .addClass("colorBarArrow");
                $arrow.appendTo($colorDiv);
                $(colorOptions).each(function (i, color) {
                    var $div = null;
                    if (color.gradient) {
                        $div = createGradientColoraDiv(color);
                    } else {
                        var colorValue = color.startColor.replace(/,/g, '') + color.toColor.replace(/,/g, '');
                        $div = $("<div></div>")
                            .addClass("colorBarItem")
                            .attr("startColor", color.startColor)
                            .attr("toColor", color.toColor)
                            .attr("value", colorValue);
                        $div.css("background", "linear-gradient(to right," + "rgba(" + color.startColor + ")" + "," + "rgba(" + color.toColor + ")" + ")");
                    }
                    $div.appendTo($colorDiv);
                    if (i == 0) {
                        $div.addClass("visible");
                    }
                });
                $colorDiv.appendTo($("[name=" + e.name + "_div]"));
                //绑定单击事件
                $(".colorBarItem").click(function (e) {
                    var $target = $(this);
                    if ($target.hasClass("visible") && $(".colorBarItem:visible").length <= 1) {
                        $(".colorBarItem").show();
                        $(".colorBarArrow").addClass("colorBarActiveArrow");
                        return;
                    }
                    $(".colorBarItem").hide();
                    $(".colorBar .visible").removeClass("visible");
                    $target.addClass("visible");
                    //获取第一个节点
                    var $prevDiv = $target.prev();
                    if ($prevDiv.length == 0) {
                        //点击为第一个元素
                        return;
                    }
                    while ($prevDiv.prev().length != 0) {
                        $prevDiv = $prevDiv.prev();
                    }
                    var $clone = $target.clone(true);
                    $prevDiv.before($clone);
                    $target.remove();
                    $(".colorBarItem").hide();
                    $(".colorBarActiveArrow").removeClass("colorBarActiveArrow");
                });

                $colorDiv.mouseleave(function (e) {
                    $(".colorBarItem").hide();
                    $(".colorBarActiveArrow").removeClass("colorBarActiveArrow");
                });

                function createGradientColoraDiv(e) {
                    var gras = e.gradient;
                    var $div = $("<div></div>")
                        .addClass("colorBarItem");
                    $div.attr("gradient", JSON.stringify(gras));
                    var colorStr = "";
                    $(gras).each(function (i, v) {
                        colorStr = colorStr + v.replace(/,/g, '');
                    });
                    $div.attr("value", colorStr);
                    var startColor = gras[0];
                    var width = (1 / (gras.length - 1) * 100 - 0.5).toFixed(2);
                    for (var i = 1; i < gras.length; i++) {
                        var endColor = gras[i];
                        var $graItem = $("<div></div>").addClass("colorGraItem").css("width", width + "%")
                        $graItem.css("background", "linear-gradient(to right," + "rgba(" + startColor + ")" + "," + "rgba(" + endColor + ")" + ")");
                        $graItem.appendTo($div);
                        startColor = endColor;
                    }
                    return $div;
                }

            }

            function creteOpcity(e) {
                var opcDiv = $("<div></div>").attr("name", e.name).attr("id", e.name + "_id");
                opcDiv.appendTo($("[name=" + e.name + "_div]"));
                layui.use(['slider'], function (slider) {
                    slider.render({
                        elem: '[name=' + e.name + ']',
                        value: e.value || 80,
                        theme: '#2a80ff', //主题色
                        width: '70px',
                        change: function (value) {
                            var opcity = Math.floor(value / 100 * 255);
                            model._option[e.name] = opcity;
                        }
                    });
                });
            }

            function createCheckbox(e) {
                var $container = $("[name=" + e.name + "_div]");
                var $form = $("<form ></form >").addClass("layui-form").css("marginLeft", 10).appendTo($container);
                var $check = $("<input type='checkbox' name='" + e.name + "_check' lay-skin='switch' lay-text='ON|OFF'>").attr("lay-filter", e.name + "-lay-filter").appendTo($form);
                if (e.value != false) {
                    $check.attr("checked", "");
                }
                model._option[e.name] = e.value;
                layui.use(["form"], function (form) {
                    form.on('switch(' + e.name + "-lay-filter" + ')', function (data) {
                        // alert("点我干嘛");
                        model._option[e.name] = this.checked;
                    });
                    form.render('switch');
                });
            }

            function createGradient(e) {
                var $container = $("[name=" + e.name + "_div]");
                // var $form = $("<form ></form >").addClass("layui-form").css("marginLeft",10);
                // var $check= $("<input type='checkbox' name='"+e.name+"_check' lay-skin='switch' lay-text='ON|OFF'>").attr("lay-filter",e.name+"-lay-filter");
                var $btn = $("<span class='grad_btn'>" + e.label + "</span>").attr("name", e.name + "_btn");
                var $input = $("<input type='hidden'>").addClass("theme_param").attr("name", e.name);
                $btn.appendTo($container);
                $input.appendTo($container);
                $("[name=" + e.name + "_btn" + "]").click(function () {
                    var params = self.getThemeParams();
                    var graData = params[e.name];
                    if (graData) {
                        paramdata = JSON.parse(graData);
                    } else {
                        paramdata = [];
                    }
                    var grade = model.grade($that.viewSource.data, params);
                    //获取属性信息
                    $(".theme-info-content").hide();
                    $(".grad_param_container").show();
                    var tableIns;
                    var legendDic = [];
                    legendDic[0] = "第一级";
                    legendDic[1] = "第一级";
                    legendDic[2] = "第二级";
                    legendDic[3] = "第三级";
                    legendDic[4] = "第四级";
                    legendDic[5] = "第五级";
                    legendDic[6] = "第六级";
                    legendDic[7] = "第七级";
                    legendDic[8] = "第八级";
                    legendDic[9] = "第九级";
                    //渲染事件
                    layui.use(['table'], function (table) {
                        tableIns = table.render({
                            elem: "#grad_param_table",
                            title: "参数表",
                            skin: 'line',
                            data: paramdata,
                            even: true,
                            toolbar: '#grad_param_tool_bar',
                            id: 'grad_param_table',
                            defaultToolbar: [],
                            cols: [[
                                {title: '等级', field: 'level'},
                                {title: '最小值', field: 'min', edit: true},
                                {title: '最大值', field: 'max', edit: true},
                                {title: "结果个数", field: 'count', edit: false},
                                {title: '操作', field: 'tool', align: 'center', toolbar: '#parambar'},
                            ]],
                            done: function (res, curr, count) {
                                var length = res.data.length;
                                $(res.data).each(function (i, v) {
                                    v.count = grade.getCountWithInter(v.min, v.max);
                                    v.level = i + 1;
                                    if (v == length - 1) {
                                        v.max = v.max + 1;
                                    }
                                    v.legend = legendDic[v.level];
                                });
                                paramdata = res.data;
                            }
                        });
                    });

                    //监听参数表头工具栏事件
                    table.on("toolbar(grad_param_table)", function (obj) {
                        if (obj.event === 'paramadd') {
                            // 增加参数
                            var dt = paramdata[paramdata.length - 1];
                            if (!dt) {
                                dt = {
                                    level: 0,
                                    min: 0,
                                    max: 10,
                                    count: 0
                                };
                            }
                            paramdata.push({
                                "level": paramdata.length + 1,
                                "min": dt.max,
                                "max": dt.max,
                                "count": 0
                            });
                            tableIns.reload({
                                data: paramdata
                            });
                        }
                        if (obj.event === 'group') {
                            var count = paramdata.length;
                            if (count == 0) {
                                count = 5;
                            }
                            var result = grade.smartGroup(count);
                            paramdata = result;
                            tableIns.reload({
                                data: paramdata
                            });
                        }

                        if (obj.event === 'save') {
                            $("[name=" + e.name + "]").val(JSON.stringify(paramdata));
                            //to do
                            //获取属性信息
                            $(".theme-info-content").show();
                            $(".grad_param_container").hide();

                        }
                    });

                    table.on("tool(grad_param_table)", function (obj) {
                        if (obj.event === "paramdel") {
                            layer.confirm('确认删除选中项？', function (index) {
                                $(obj.data).each(function (i, v) {
                                    if (v.level == obj.data.level) {
                                        paramdata.splice(i, 1);
                                    }
                                })
                                tableIns.reload({
                                    data: paramdata
                                });
                                layer.close(index);
                            });
                        }
                    });

                    table.on("edit(grad_param_table)", function (obj) {
                        var count = grade.getCountWithInter(obj.data.min, obj.data.max);
                        $(paramdata).each(function (i, v) {
                            if (i == obj.data.level) {
                                v.data.count = count;
                            }
                        })
                        tableIns.reload({
                            data: paramdata
                        });
                    })
                });

            }

            function createMapView(e) {
                var $container = $("[name=" + e.name + "_div]");
                var $btn = $("<span class='grad_btn'>" + e.label + "</span>").attr("name", e.name + "_btn").addClass("param_common_btn");
                $btn.appendTo($container);
                $("[name=" + e.name + "_btn" + "]").click(function () {
                    var dt = MapUtils.getMapView();
                    model._option[e.name] = dt;
                    layer.msg("设置方位角成功！")
                });
            }
        }

        /**
         * 主动选择数据源
         */
        self.chooseDataModelForEdit = function (themeInfo) {
            if ((!$that.viewSource) || (!$that.viewSource.data)) {
                layer.msg("请选择数据源！");
                return;
            }
            try {
                themeInfo.params = JSON.parse(themeInfo.params);
            } catch (e) {
            }

            model._option = themeInfo.params;
            var targetThemeDataModel = null;
            $.each(self.themeDataModel(), function (i, e) {
                var temp2 = self.clone(e);
                if (e.id === themeInfo.mid) {
                    temp2.check = true;
                    targetThemeDataModel = temp2;
                } else {
                    temp2.check = false;
                }
                self.themeDataModel.replace(e, temp2);
            });
            self.reLoadArr(self.themeParams, targetThemeDataModel.option.params);
            createParamControl(targetThemeDataModel.option.params);
            //初始化表单
            $("[name=own_state]").val(themeInfo.ownState);
            $("[name=theme_name]").val(themeInfo.name);
            $(targetThemeDataModel.option.params).each(function (i, e) {
                switch (e.type.toLowerCase()) {
                    case "featureprop":
                        $("[name=" + e.name + "]").val(themeInfo.params[e.name]);
                        break;
                    case "number":
                        $("[name=" + e.name + "]").val(themeInfo.params[e.name]);
                        break;
                    case "color":
                        break;
                    case "colorbar":
                        var colorObj = themeInfo.params[e.name];
                        var colorStr = "";
                        if (colorObj.gradient) {
                            $(colorObj.gradient).each(function (i, v) {
                                colorStr = colorStr + v.replace(/,/g, '');
                            });
                        } else {
                            colorStr = colorObj.startColor.replace(/,/g, '') + colorObj.toColor.replace(/,/g, '');
                        }
                        var $target = $("[value=" + colorStr + "]");
                        $(".colorBar .visible").removeClass("visible");
                        $target.addClass("visible");
                        break;
                    case "opcity":
                        layui.use(['slider'], function (slider) {
                            var value = Math.floor(themeInfo.params[e.name] / 255 * 100);
                            slider.render({
                                elem: '[name=' + e.name + ']',
                                value: value || 80,
                                theme: '#2a80ff', //主题色
                                width: '70px',
                                change: function (value) {
                                    var opcity = Math.floor(value / 100 * 255);
                                    model._option[e.name] = opcity;
                                }
                            });
                        });
                        break;
                    default:
                        $("[name=" + e.name + "]").val(themeInfo.params[e.name]);
                        break;
                }
            });
            $that.viewModel = themeInfo.mid;
            self.themeId = themeInfo.id;
        };

        self.getThemeParams = function () {
            $(".theme_param").each(function (i, e) {
                var name = $(e).attr("name");
                var val = $(e).val();
                if ($(e).attr("type") == "number") {
                    val = val * 1;
                }
                changeOption[name] = val;
            });
            $(".colorBar").each(function (i, e) {
                var name = $(e).attr("name");
                var target = $(e).find(".visible");
                if (target.attr("gradient")) {
                    changeOption[name] = {
                        gradient: JSON.parse(target.attr("gradient"))
                    }

                } else {
                    changeOption[name] = {
                        "startColor": target.attr("startcolor"),
                        "toColor": target.attr("tocolor")
                    };
                }

            });
            return changeOption;
        };

        // 【应用基础模版(新增可视化应用按钮)】
        self.useModel = function () {
            chooseModel(false, this);
        };
        self.themeId = "";
        //保存模板
        self.saveModel = function () {
            $.extend(changeOption, self.getThemeParams());
            model.setOption(changeOption);
            // option
            var param = JSON.stringify(model._option);
            var url = "";
            var layerName = "";
            var theme = {};
            $.each(self.recordAll(), function (i, e) {
                if (e.check) {
                    url = "/metainfo/geo?id=" + e.id;
                    layerName = e.layerName;
                    theme.geoId = e.id;
                    return;
                }
            });
            if (!url) {
                layer.msg("请选择数据源!");
                return;
            }
            theme.url = url;
            theme.params = param;
            theme.img = "points";
            theme.mid = $that.viewModel;
            theme.name = $("[name=theme_name]").val() || layerName;
            theme.ownState = $("[name=own_state]").val() || "private";
            if (self.themeId) {
                theme.id = self.themeId;
            }

            $.ajax({
                url: rootPath + "/map/theme/set",
                data: {content: JSON.stringify(theme)},
                contentType: "application/json",
                success: function (e) {
                    layer.msg("保存成功!");
                    self.loadTheme();
                }, complete: function () {
                    self.themeId = "";
                }
            });
        };
        self.addThemeSource = function () {
            if ($(".theme-source-add").text() == "收缩") {
                $(".theme-source-add").text("展开");
                // 提升数据源面板
                $.each(self.recordAll(), function (i, e) {
                    var clone = self.clone(e);
                    clone.display = clone.check;
                    self.recordAll.replace(e, clone);
                });
                $(".theme-info-content").show();
                self.showRecordAllPage(false);
            } else {
                self.refreshDisplay(self.recordAll);
                $(".theme-source-add").text("收缩");
                $(".theme-info-content").hide();
                self.showRecordAllPage(true);
            }
        }; // ... 加载

        //【控制echarts可视化移除】
        self.clickCharts = function () {
            model._option = {};
            if (this.check) {
                self.refreshDataSource(self.themeMy);
                self.refreshDataSource(self.themeShare);
                $that.clear();
            } else {
                self.clickThemes(this);
            }
        };

        // // 【控制可视化编辑】
        // self.clickEdit = function (btn,event) {
        //     if(!btn.check){
        //         layer.msg('未开启可视化效果',{
        //            time:2000
        //         });
        //         return;
        //     }
        //     if($(event.target).hasClass("edit-show")){
        //         $(event.target).removeClass("edit-show");
        //         $(".theme-card").remove();
        //     }else {
        //          $(event.target).addClass("edit-show");
        //          $("#globalContainer").append($that.editLayer);
        //          $(".theme-card").css("left",event.pageX + 15 +"px").css("top",event.pageY - 110+"px").css("display","block");
        //          $(".themeCard-text").text(btn.name);
        //          slider.render({
        //             elem:'#themeCard-slider',
        //             value: 100,
        //             theme: '#2a80ff', //主题色
        //             width:'70%',
        //             change: function(value){
        //             }
        //         });
        //          colorpicker.render({
        //             elem: '#themeCard-color'
        //             ,color: '#c71585'
        //             ,predefine: true // 开启预定义颜色
        //             ,change: function(color) { //颜色改变的回调
        //             }
        //         });
        //     }
        // };

        // 【用做ko更新数组某一项数据时的克隆，无需重新清空并绑定整个列表】
        self.clone = function (source) {
            var obj = {};
            for (var p in source)
                obj[p] = source[p];
            return obj;
        };

        // 【刷新数据源选择状态】
        self.checkThis = function (t, source) {
            //改变状态
            var tmp = self.clone(t);
            tmp.check = true;
            // 刷新选择状态
            if (!t.check) {
                self.refreshDataSource(source);
            }
            source.replace(t, tmp);
        }; //选中
        self.refreshDataSource = function (source) {
            $.each(source(), function (i, e) {
                var temp2 = self.clone(e);
                if (e.check === true) {
                    temp2.check = false;
                    source.replace(e, temp2);
                }
            });
        };// 刷新选中状态
        self.refreshDisplay = function (source) {
            $.each(source(), function (i, e) {
                var temp2 = self.clone(e);
                if (!e.display) {
                    temp2.display = true;
                    source.replace(e, temp2);
                }
            });
        };
        self.refreshAll = function (source) {
            $.each(source(), function (i, e) {
                var temp2 = self.clone(e);
                temp2.check = false;
                temp2.display = true;
                source.replace(e, temp2);
            });
        };

        //重新加载arr
        self.reLoadArr = function (kno, data) {
            kno.removeAll();
            $(data).each(function (i, e) {
                kno.push(e);
            });
        },

            self.loadAll = function (less, more) {
                if (less().length === more.length) {
                    alert("已加载全部数据");
                    return;
                }
                $.each(more, function (i, e) {
                    if (i > 3) {
                        less.push(e);
                    }
                })
            }; // 加载全部

        //【删除操作】
        self.deleteThemes = function () {
            var theme = this;
            layer.msg('是否确定删除:<br>' + this.name, {
                time: 20000, //20s后自动关闭
                btn: ['删除', '取消'],
                yes: function () {
                    $.ajax({
                        url: rootPath + "/map/theme/delete?id=" + theme.id,
                        success: function (e) {
                            self.themeMy.remove(theme);
                            layer.msg("删除成功");
                            //执行刷新
                            self.loadTheme();
                        },
                        error: function () {
                            layer.msg("删除失败");
                        },
                        complete: function () {
                            layer.closeAll();
                        }
                    });

                },
                btn2: function () {
                    layer.closeAll();
                }
            });
        };

        self.shareTheme = function () {
            var url;
            if (this.shared) {
                url = rootPath + "/map/theme/share/delete?id=" + this.id;
                $.ajax({
                    url: url,
                    success: function (e) {
                        layer.msg("取消分享成功");
                        //执行刷新
                        self.loadTheme();
                    },
                    error: function () {
                        layer.msg("取消分享失败");
                    },
                    complete: function () {
                    }
                });
                return;
            } else {
                url = rootPath + "/map/theme/share?id=" + this.id;
                $.ajax({
                    url: url,
                    success: function (e) {
                        layer.msg("分享成功");
                        //执行刷新
                        self.loadTheme();
                    },
                    error: function () {
                        layer.msg("分享失败");
                    },
                    complete: function () {
                    }
                });
            }

        }

        self.expandShareThemes = function () {
            $(".my-view-container").hide();
            $(".theme-my-arrow").removeClass("theme-arrow-rotate");
            //先进行判断
            if ($(".theme-share-arrow").hasClass("theme-arrow-rotate")) {
                //张开状态  收缩
                $(".share-view-container").hide();

                $(".theme-share-arrow").removeClass("theme-arrow-rotate");
            } else {
                //收缩状态  张开
                $(".share-view-container").show();
                $(".theme-share-arrow").addClass("theme-arrow-rotate");
            }
        },

            self.expandMyThemes = function () {
                $(".share-view-container").hide();
                $(".theme-share-arrow").removeClass("theme-arrow-rotate");
                //先进行判断
                if ($(".theme-my-arrow").hasClass("theme-arrow-rotate")) {
                    //张开状态  收缩
                    $(".my-view-container").hide();
                    $(".theme-my-arrow").removeClass("theme-arrow-rotate");
                    // $(".theme-share-arrow").addClass("theme-arrow-rotate");
                } else {
                    //收缩状态  张开
                    $(".my-view-container").show();
                    $(".theme-my-arrow").addClass("theme-arrow-rotate");
                }

                // $(".share-view-content").hide();
                // $(".my-view-content").show();
                // $(".theme-arrow-rotate").removeClass("theme-arrow-rotate");
                // $(".theme-my-arrow").addClass("theme-arrow-rotate");
            },

            self.expandShareRecords = function () {
                $(".record-content").hide();
                $(".record-my-arrow").removeClass("theme-arrow-rotate");
                //先进行判断
                if ($(".record-share-arrow").hasClass("theme-arrow-rotate")) {
                    //张开状态  收缩
                    $(".my-record-content").hide();

                    $(".record-share-arrow").removeClass("theme-arrow-rotate");
                } else {
                    //收缩状态  张开
                    $(".share-record-content").show();
                    $(".record-share-arrow").addClass("theme-arrow-rotate");
                }
            },

            self.expandMyRecords = function () {
                $(".record-content").hide();
                $(".record-share-arrow").removeClass("theme-arrow-rotate");
                //先进行判断
                if ($(".record-my-arrow").hasClass("theme-arrow-rotate")) {
                    //张开状态  收缩
                    $(".share-record-content").hide();
                    $(".record-my-arrow").removeClass("theme-arrow-rotate");
                    // $(".theme-share-arrow").addClass("theme-arrow-rotate");
                } else {
                    //收缩状态  张开
                    $(".my-record-content").show();
                    $(".record-my-arrow").addClass("theme-arrow-rotate");
                }

                // $(".share-view-content").hide();
                // $(".my-view-content").show();
                // $(".theme-arrow-rotate").removeClass("theme-arrow-rotate");
                // $(".theme-my-arrow").addClass("theme-arrow-rotate");
            },

            self.deleteMyDataset = function () {
                self.delete(this, self.recordMy);
            };

        self.addLayerToMap = function () {
            self.addToMap(this, self.recordMy);
        };

        self.delete = function (b, source, id) {
            layer.msg('是否确定删除:<br>' + b.name, {
                time: 20000, //20s后自动关闭
                btn: ['删除', '取消'],
                yes: function () {


                },
                btn2: function () {
                    layer.closeAll();
                }
            });
        };

        self.addToMap = function (recourd) {
            showLoading();
            MapUtils.viewer.dataSources.removeAll();
            var layerUrl = rootPath + "/metainfo/geo?id=" + recourd.id;
            $.ajax({
                url: layerUrl,
                success: function (geodata) {
                    closeLoading();
                    var geo = null;
                    if (!geodata.data) {
                        layer.msg("无数据");
                        return;
                    }
                    geo = JSON.parse(geodata.data);
                    if (geo instanceof Array) {
                        if (geo.length > 0) {
                            geo = geo[0];
                        } else {
                            layer.msg("无数据");
                            return;
                        }
                    }
                    var tmp = {
                        type: geo.type,
                        features: geo.features
                    };
                    var geoType = "";
                    if (geo.features.length == 0) {
                        layer.msg("无数据");
                        return;
                    }
                    var firstGeo = geo.features[0].geometry;
                    if (!firstGeo) {
                        layer.msg("不支持的数据格式1");
                        return;
                    }
                    geoType = firstGeo.type;
                    if (geoType.toLowerCase() == "point") {
                        var ens = [];
                        $(geo.features).each(function (i, e) {
                            var coor = e.geometry.coordinates;
                            var en = MapUtils.viewer.entities.add({
                                position: Cesium.Cartesian3.fromDegrees(coor[0], coor[1]),
                                // billboard: {
                                //     image: imgCircle.toDataURL(), // default: undefined
                                //     show: true
                                // },
                                point: {
                                    pixelSize: 15,
                                    color: Cesium.Color.BLUE.withAlpha(0.9),
                                    outlineColor: Cesium.Color.RED.withAlpha(0.9),
                                    heightReference: 1
                                    // outlineWidth: 10
                                }
                            });
                            ens.push(en);
                        })
                        MapUtils.viewer.flyTo(ens);
                        return;
                    }

                    var promise = Cesium.GeoJsonDataSource.load(tmp);
                    promise.then(function (dataSource) {
                        MapUtils.viewer.dataSources.add(dataSource);
                        var entity = dataSource.entities.values;
                        MapUtils.setEntityStyle(entity, "region");
                    });
                    MapUtils.viewer.flyToViewer(promise);

                },
                error: function (e) {
                    layer.msg("加载数据失败...");
                    closeLoading();
                }
            });
        };


        // 【请求后台数据接口】
        self.querySeverData = function () {
            //"http://192.168.2.101:10002/mdb/v1/datastore/features/map?tableId=5443345f-b171-4097-a06d-24f0e62b186a&where=1%3D1"
            if ($("#dataServeInput").val() === "") {
                layer.msg('服务地址为空', {time: 2000, icon: 0});
                return;
            } else {
                severApi($("#dataServeInput").val(), managerSeverData);
            }
        };

        // 【保存服务接口】
        self.saveServer = function () {
            var temp = {
                id: 100 * Math.random(),
                name: $("#dataSeverName").val(),
                url: $("#dataServeInput").val(),
                check: false,
                display: true,
                type: "flow",
                data: serverData
            };
            self.recordMy.push(temp);
            self.themeDataSource.push(temp);
            layer.msg("保存成功", {time: 2000, icon: 1});
        };

        // 【保存数据集】
        self.save_dataSet = function () {
            if (!$("#datasetInput").val()) {
                layer.msg("请输入数据集名称！");
                return;
            }
            if (!$that.uploadGeojson) {
                layer.msg("请导入坐标！");
                return;
            }
            showLoading();
            $.ajax({
                url: "/overlay/saveResult",
                type: "post",
                data: {
                    layerName: $("#datasetInput").val(),
                    featureCollection: $that.uploadGeojson
                },
                success: function () {
                    layer.msg("保存成功!");
                },
                complete: function () {
                    closeLoading();
                }
            });
        };

        // 计算我的模版数据
        managerNumData();
        //前台解析shp
        upload();
        //绑定透明度
        changeOpacity();
    }


    /*****************************【通用方法】************/

    /*定位到一个初始的中心点*/
    function flyToHome() {
        MapUtils.viewer.scene.camera.flyTo({ // 图层加载完成,设置相机位置
            destination: Cesium.Cartesian3.fromDegrees(121.48, 31.24, 20000000)
        });
    }

    /*定位到一个坐标点*/
    function flyToP(center, height) {
        var h = height ? height : 2000000;
        MapUtils.viewer.scene.camera.flyTo({ // 图层加载完成,设置相机位置
            destination: Cesium.Cartesian3.fromDegrees(center[0], center[1], h)
        });
        changeOption.slider += 0.001;
    }

    function chooseView(btn) {
        $that.clear();//清除痕迹
        // 业务代码
        switch (btn.mid) {
            case ("addVedio")  :    // 添加视频源
                $that.addVedio();
                break;
            case ("heatMap")   :    // 叠加热力图
                $that.addHeat();
                break;
            case ("windMap")   :    // 风场
                themeApi("../mock/wind2.json", $that.addWind);
                break;
            case ("scatterMap") :   // 散点图
                flyToHome();// 返回主视图
                $that.createScatterMap();
                break;
            case ("flightMap")  :  // 迁徙图
                flyToHome();// 返回主视图
                themeApi("../mock/flight.json", $that.createFlightMap);
                break;
            case ("flowMap")    :  // 流向图
                flyToHome();// 返回主视图
                themeApi("../mock/flow.json", $that.createFlowMap);
                break;
            case ("transMap")   : // 交通路线图
                flyToHome();// 返回主视图
                themeApi("../mock/trans.json", $that.createTransMap);
                break;
            case ("flow2Map") :
                flyToHome();// 返回主视图
                p2p.onload(MapUtils.viewer);
                break;
            case("trafficMap") :
                $that.createTraffic();
                break;
            case "traffic_model":
                themeApi("../mock/flight_2.json", $that.createTrafficByModel);
                break;
            case("pointsMapV") :
                themeApi("../mock/target.json", pointToHeat);
                break;
            case("mapVHoneycomb"):
                themeApi("../mock/target.json", mapVHoneycomb);
                break;
            case("mapVImage"):
                themeApi("../mock/target.json", mapImage);
                break;
            case("mapVLines"):
                themeApi("../mock/target.json", mapVLines);
                break;
            case("heatMap1"):
                themeApi("../mock/heat.json", heatMapModel);
                break;
            case ("honeycomb1"):
                themeApi("../mock/heat.json", mapVHoneycomb);
                break;
            case "migration":
                flyToHome();// 返回主视图
                themeApi("../mock/flight_2.json", migration);
                break;
        }
        var params = btn.params;
        if (typeof params === "string") {
            params = JSON.parse(params);
        }
        if (params.setMapView) {
            try {
                MapUtils.setMapView(params.setMapView);
            } catch (e) {

            }
        }
        //图形加载结束
        EventBus.trigger("themeLoaded");
    }

    /*计算数据总数*/
    function managerNumData() {
        $("#myShare").text($that.themeShare.length);
    }

    /*解析shp的压缩包*/
    function upload() {
        $("#dataset-upload").on("change", function () {
            //toShp.readShp(this,MapUtils.viewer);
            toShp.loadFile(this, "dataset-uploadForm", managerData);
        });
    }

    /*上传回调*/
    function managerData(data) {
        $that.clear();
        if (JSON.parse(data).type) {
            layer.msg('数据上传成功', {
                time: 1000,
                btn: false
            });
        } else {
            layer.msg('数据解析出错', {
                time: 1000,
                btn: false
            });
            return;
        }
        if (typeof data == "string") {
            data = JSON.parse(data);
        }
        model._option = {
            clampToGround: true,
            msg: "生成图形中..."
        };
        data = data.value;
        model.addModel(data, "geojson");
        $that.uploadGeojson = JSON.stringify(data);
    }

    /*触发动态效果*/
    function changeOpacity() {
        var isover = true;
        $("body").on("mouseover", ".themes-tool", function () {
            if (isover) {
                var i = 0;
                var self = this;
                $(self).addClass("class-opacity-8");
                var showBtn = function () {
                    $($(self).find(".layui-col-xs4")[i]).addClass("class-opacity-8 layui-anim-upbit");
                    i++;
                };
                setTimeout(showBtn, 200);
                setTimeout(showBtn, 400);
                setTimeout(showBtn, 600);
                isover = false;
            }
        }).on("mouseleave", ".themes-tool", function () {
            var that = this;
            $(this).removeClass("class-opacity-8");
            $.each($(that).find(".layui-col-xs4"), function () {
                $(this).removeClass("class-opacity-8 layui-anim-upbit")
            });
            isover = true;
        });
    }


    /**************************【模版函数】*************/


    /*渲染选择模版函数*/
    function chooseModel(theme, on) {
        $that.clear();
        //初始化参数
        if (on) {
            model.setOption(on.getThemeParams());
        }
        //直接从theme对象中获取参数
        if (theme) {
            var obj;
            if (typeof theme.params === "string") {
                obj = JSON.parse(theme.params);
            } else {
                obj = theme.params;
            }

            model.setOption(obj);
            //加载数据
            //根据featureCollection 获取数据type
            var layerUrl = theme.url;
            // var msg = layer.msg('加载中...', {icon: 16,shade: [0.5, '#f5f5f5'],scrollbar: false,offset: 'auto',time: 0});
            showLoading(function () {
                return $(".dataViews-pane").is(":visible");
            });
            $.ajax({
                url: layerUrl,
                success: function (result) {
                    var feaCol = null;
                    if (!result.data) {
                        return;
                    }
                    feaCol = JSON.parse(result.data);
                    if (feaCol instanceof Array) {
                        if (feaCol.length > 0) {
                            feaCol = feaCol[0];
                        } else {
                            return;
                        }
                    }
                    if (feaCol.features && feaCol.features.length == 0) {
                        return;
                    }

                    theme.data = feaCol;
                    if (!feaCol.features[0].geometry) {
                        layer.msg("不支持的数据格式，请重新选择");
                        return;
                    }
                    //获取要素类型
                    var geoType = feaCol.features[0].geometry.type.toLowerCase();
                    switch (geoType) {
                        case "multi":
                        case "polygon":
                            theme.type = "polygon";
                            break;
                        case "polyline":
                            theme.type = "lines";
                            break;
                        case "point":
                            theme.type = "points";
                            break;

                    }
                    $that.viewSource = theme;
                    $that.viewModel = theme.mid;
                    checkModel($that.viewSource.data, true);
                    if ($that.viewSource === "") {
                        alert("未选择数据集");
                        return;
                    }
                },
                error: function (e) {
                    console.log(e);
                    layer.msg(e);
                },
                complete: function () {
                    closeLoading();
                }
            });
            return;
        }
        if ($that.viewModel === "") {
            alert("未选择可使模版");
            return;
        }
        if ($that.viewSource.data && $that.viewSource.data.features.length > 0) {
            checkModel($that.viewSource.data, true);
        } else {
            themeApi($that.viewSource.url, checkModel);
        }
        if ($that.viewSource === "") {
            alert("未选择数据集");
            return;
        }

    }

    /*
     *  封装一个获取ajax的方法
     *
     *  url:数据源
     *  callback:处理业务逻辑代码
     *
     * */
    var dataGroup = [];

    function themeApi(url, callback) {
        $.ajax({
            url: url,
            async: false,
            type: "get",
            beforeSend: function () {
                layer.msg('数据请求中...', {
                    time: 200000, //自动关闭
                    btn: false,
                    icon: 16
                });
            },
            success: function (data) {
                layer.msg('正在绘制专题图', {
                    time: 200000, //自动关闭
                    btn: false,
                    icon: 1
                });
                try {
                    // 处理多时段数据
                    if (data.data) {
                        var time = 5;
                        var temp = JSON.parse(data.data[0].result).data;
                        var points = [];
                        $.each(temp, function (i, e) {
                            var tempResult = {groups: [], show: true};
                            time += 5;
                            $.each(e.points, function (j, k) {
                                var list = {};
                                list.coords = [k.lng, k.lat];
                                list.name = "";
                                list.value = k.weight;
                                list.time = time;
                                points.push(list);
                                tempResult.groups.push(list);
                            });
                            dataGroup.push(tempResult);
                        });
                        callback(points);
                    } else {
                        callback(data);
                    }
                    layer.closeAll();
                } catch (e) {
                    console.log(e);
                    layer.msg('数据渲染出错', {
                        time: 2000
                    })
                }
            }
        });
    }


    /*选择模版的回调函数*/
    function checkModel(data, large) {
        model.addModel(data, $that.viewModel, large);

    }


    /*一个散点图渲染模版*/
    function scatterModel(data) {
        $.each(data, function (i, e) {
            e.level = e.value;
            e.value = e.coords.concat(e.level);
        });
        var option = Model.scatterOption(data);
        chartView.updateOverlay(option);
        flyToHome();
    }


    /*一个流向图渲染模版(以一个中心点发散形式)
     *数据格式
     *  }
     */
    function flowModel(data) {
        //var option = Model.flowOption([],data);
        var option = model.addModel(data, "flow");
        chartView.updateOverlay(option);
        flyToHome();
    }

    /*渲染一个中心点扩散圆*/
    function getCenter2Around(center, height) {
        var pResult = curve.getCurveDynamicPointsAndLine(center, trafficPoints, height);
        var lineResult = pResult.line;
        var pointResult = pResult.point;
        //创建扩散效果
        var colorC = new Cesium.Color(192 / 255, 16 / 255, 26 / 255, 0.8);
        curve.drawTrail(MapUtils.viewer, center, pointResult, lineResult, trafficPoints, height)
    }

    //渲染一个热力图模版
    function heatMapModel(result) {
        mapvLyr.push(Model.mapVHeat(result, MapUtils.viewer));
        flyToP(result[0].coords, 2000);
    }

    function pointToHeat(result) {
        mapvLyr.push(model.addModel(result, "heat"));
    }

    /////////////////////////////////////////////////////////根据时间轴渲染热力模版
    //   function  heatMapModel(result) {
    //       addTimeline.init({},watchTime);
    //   }
    //
    //   function watchTime(time) {
    //       try {
    //           var level = parseInt(time / 300);
    //           if (level && level !== 0 && dataGroup[level-1].show) {
    //               model.addHeat(dataGroup[level-1].groups);
    //           }
    //       }catch(e){layer.msg('渲染出错',{time:2000})}
    //   }

    /*渲染一个蜂窝图模版*/
    function mapVHoneycomb(result) {
        mapvLyr.push(Model.mapVHoneycomb(result, MapUtils.viewer));
        flyToP(result[0].coords, 2000);
    }

    function migration(result) {
        migrationModel.init(result, MapUtils.viewer);
    }

    /*渲染一个图片点样式模版*/
    function mapImage(result) {
        mapvLyr.push(Model.mapVImage(result, MapUtils.viewer));
        flyToP(result[0].coords);

    }

    /*渲染一个强度线*/
    function mapVLines(result) {
        mapvLyr.push(Model.mapVLines(result, MapUtils.viewer));
        flyToP(result[0].coords);
    }

    /*渲染一个動態點*/
    function dynamicPoints(result) {
        mapvLyr.push(Model.mapVDynamivPoints(result, MapUtils.viewer));
        flyToP(result[0].coords);
    }

    /*渲染多边形*/
    function mapVPolygon(result) {
        mapvLyr.push(Model.mapVPolygon(result, MapUtils.viewer));
        flyToP(result[0].coords[0]);
    }

    /*选择常规线渲染*/
    function mapVSimpleLine(result) {
        mapvLyr.push(Model.mapVSimpleLine(result, MapUtils.viewer));
        flyToP(result[0].coords[0]);
    }

    function mapVGeojson(result) {
        //mapvLyr.push(Model.mapVGeojson(result,MapUtils.viewer));
        promise = model.addModel(result, "geojson")
    }

    /****************************【数据表格】************/
    function loadTable(id, data) {
        table.render({
            elem: "#" + id,
            cols: [[ //标题栏
                {field: 'id', title: 'ID', width: '134', sort: true},
                {field: 'title', title: '标题', width: '134'},
                {field: 'coords', title: '操作', width: '72'}
            ]],
            data: data,
            weight: 340,
            page: false //是否显示分页
            , limit: 200 //每页默认显示的数量
        });
    }


    function loadServerTable(id, data) {
        table.render({
            elem: "#" + id,
            cols: [[
                {field: 'name', title: '名称', width: '70'},
                {field: 'value', title: '权重', width: '100', sort: true},
                {field: 'location', title: '坐标', width: '163'}
            ]],
            data: data,
            width: 340,
            page: true,
            limit: 100
        });

        //todo 监听行单击事件 渲染数据点
        table.on('row(dataServer-load)', function (obj) {
            var data = obj.data;
            //标注选中样式
            obj.tr.addClass('layui-table-click').siblings().removeClass('layui-table-click');
        });
    }


    /****************************【请求服务数据接口】****/
    function severApi(url, callback) {
        $.ajax({
            type: 'get',
            url: url,
            beforeSend: function () {
                layer.msg('数据请求中...', {
                    time: 200000, //自动关闭
                    btn: false,
                    icon: 16
                });
            },
            success: function (data) {
                callback(data.data);
            },
            complete: function () {
                layer.closeAll();
            }
        })
    }

    /*处理数据*/
    function managerSeverData(result) {
        $.each(result, function (i, e) {
            e.location = [e.x * 1, e.y * 1];
            e.name = e.property;
            e.value = e.score;
            e.fromName = "南京";
            e.toName = e.property;
            e.coords = [[119.14, 32.20], e.location];
        });
        serverData = result;
        loadServerTable("dataServeTable", result);
    }


    /**
     * get instance
     *
     * @returns {*}
     */
    me.getInstance = function () {
        if (void 0 === instance) {
            instance = me;
        }
        return instance;
    };
    return me;
});