/**
 *
 * @author by <a href="mailto:chaomashi@gmail.com">Du</a>
 * @version v1.0 2019/7/18/20:09  Copyright gtmap Corp
 */
define([
    'Cesium',
    'leaflet',
    '../../core/GeometryStore',
    'esri-leaflet',
    'echarts',
    'global/core/WebMapTileServiceImageryProvider',
    'global/utils/MapUtils',
    'global/utils/WidgetUtils',
    'global/core/CameraAndScale',
    'ol',
    'ztree',
    'ztreeExhide',
    'scroll',
    'css!webjars/ztree/css/zTreeBlue.css'
], function (
    Cesium,
    L,
    store,
    LEsri,
    echarts,
    WebMapTileServiceImageryProvider,
    MapUtils,
    WidgetUtils,
    Camera,
    ol
) {

    var layuiLayer, layuiElement, layuiTable,
        coastlineTable, coastlineLayer;
    layui.use(['layer', 'element', 'table'], function () {
        layuiLayer = layui.layer;
        layuiElement = layui.element;
        layuiTable = layui.table;

        coastlineTable = layuiTable.render({
            elem: '#coastlineTable',
            skin: 'line',
            even: true,
            cols: [[]]
        });
    });

    var _imageryLayer;

    var instance,
        me,
        ztree,
        ztreeObj,
        $that = me = {

            // 所有子节点
            _nodeChild: [],

            _viewer: MapUtils.getViewer(),

            // 是否点击标识（定时器编号）,解决树节点单双击冲突
            clickFlag: null,

            // 是否点击标识（定时器编号）,解决收藏Tab中收藏卡片单双击冲突
            clickFlagFavCard: null,

            // 记录单击子节点的dom
            clickedNode: null,

            // 记录单击子节点的文字的dom
            clickedNodeText: null,

            searchNodes: [],

            searchIndex: 0,

            // 收藏的子节点
            collectNodes: [],

            defaultPhotoUrl: "url(/assets/images/defaultPhoto.png",

            commonPhoto: "/global/widgets/smartSearch/defaultPhoto/biaoji_common.png",

            identifyHandler: null,

            popupHandler: null,

            coastlineCharts: {},

            // init fun
            init: function () {
                $that = me;
                $that._initSearch();

                // 计算card最大高度
                max = $(".map-left-pane").height() - 120;
                $(".datalist-card").css("max-height", max);
                // bottom
                bottom = $(".global-container").height() - $(".map-left-pane").height() - 5;
            },

            // open event
            onOpen: function () {
                // var url = "http://192.168.2.147:8090/iserver/services/map-agscache-TuCeng/wms111?SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&FORMAT=image/png&TRANSPARENT=true&LAYERS=%E5%9B%BE%E5%B1%82&exceptions=application/vnd.ogc.se_inimage&SRS=EPSG:4490&STYLES=&WIDTH=625&HEIGHT=768&BBOX=104.25750732421875,35.2056884765625,107.69073486328125,39.4244384765625";
                // var wmsLayer = MapUtils.createGlobalLayer({
                //     url:url,
                //     type:"wms",
                //
                // }, MapUtils.viewer);
                // MapUtils.getViewer().imageryLayers.addImageryProvider(wmsLayer);
            },
            // close event
            onClose: function () {
                MapUtils.viewer.dataSources.removeAll();
                if ($that.billboards) {
                    $that.billboards.removeAll();
                }
                if ($that.layer) {
                    $that.layer.closeAll();
                }
                if ($that.popupHandler) {
                    $that.popupHandler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_CLICK);
                }
                if ($that.identifyHandler) {
                    $that.identifyHandler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_CLICK);
                }
                if (MapUtils.viewer.pickEvent.numberOfListeners > 0) {
                    for (var i = 0; i < MapUtils.viewer.pickEvent._listeners.length; i++) {
                        MapUtils.viewer.pickEvent.removeEventListener(MapUtils.viewer.pickEvent._listeners[i])
                    }
                }
                $(".datalist-card,.card-triangle").hide();
            },
            // pause event
            onPause: function () {
                MapUtils.viewer.dataSources.removeAll();
                if ($that.billboards) {
                    $that.billboards.removeAll();
                }
                if ($that.layer) {
                    $that.layer.closeAll();
                }
                if ($that.popupHandler) {
                    $that.popupHandler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_CLICK);
                }
                if ($that.identifyHandler) {
                    $that.identifyHandler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_CLICK);
                }
                if (MapUtils.viewer.pickEvent.numberOfListeners > 0) {
                    for (var i = 0; i < MapUtils.viewer.pickEvent._listeners.length; i++) {
                        MapUtils.viewer.pickEvent.removeEventListener(MapUtils.viewer.pickEvent._listeners[i])
                    }
                }
                $(".datalist-card,.card-triangle").hide();
            },

            //拼装Tree
            _getResTree: function (data) {
                function toParse(data) {
                    $.each(data, function (index, item) {
                        if (item.children && Array.isArray(item.children)) {
                            if (item.children.length === 0) {
                                $that._nodeChild.push(item);
                            }
                            if (item.level === 1) {
                                item.nocheck = true;
                            }
                            toParse(item.children);
                        } else {
                            if (item.data.hasOwnProperty("serviceId")) {
                                item.id = item.data.serviceId;
                                if (baseLayersIds.indexOf(item.data.serviceId) > -1) {
                                    $.extend(item, {
                                        isBaseLayer: true,
                                        capables: []
                                    });
                                    item.capables.push(baseLayers[baseLayersIds.indexOf(item.data.serviceId)]);
                                }
                            }
                            if (item.data.hasOwnProperty("serviceIds")) {
                                var nodeId = "";
                                $(item.data.serviceIds).each(function (i, val) {
                                    nodeId = nodeId + "-" + val;
                                });
                                item.id = nodeId;
                                if (baseLayersIds.indexOf(item.data.serviceIds[0]) > -1) {
                                    $.extend(item, {
                                        isBaseLayer: true,
                                        capables: []
                                    });
                                    item.capables.push(baseLayers[baseLayersIds.indexOf(item.data.serviceIds[0])]);
                                }
                            }
                        }
                    });
                    return data;
                }

                return toParse(data);
            },

            // 点击展开节点，点击最后一级节点弹出信息框
            _onClick: function (event, treeId, treeNode, clickFlag) {
                if ($that.clickFlag) { // 取消上次延时未执行的方法
                    $that.clickFlag = clearTimeout($that.clickFlag);
                }

                $that.clickFlag = setTimeout(function () {
                    // click 事件的处理
                    // 判断是否是父节点
                    if (treeNode.hasOwnProperty('children')) {
                        // 展开节点
                        $.fn.zTree.getZTreeObj(treeId).expandNode(treeNode);
                        // 隐藏弹框
                        $(".card-triangle，.datalist-card").hide("slow");

                        // 移除子节点的单击样式
                        $('.ztree li').removeClass('clicked-node');
                        $('.ztree li span').removeClass('clicked-node-text');
                    } else {
                        // 获取点击节点的dom和节点文字的dom
                        var nodeDom = $('#' + treeNode.id);
                        var textSpan = $('#' + treeNode.id + '_span');
                        $that.clickedNode = nodeDom;
                        $that.clickedNodeText = textSpan;
                        nodeDom.hasClass('clicked-node') ? hideCard(nodeDom, textSpan) : showCard(nodeDom, textSpan, treeNode)
                    }
                }, 300); // 延时300毫秒执行

                function hideCard(nodeDom, textSpan) {
                    nodeDom.removeClass('clicked-node');
                    textSpan.removeClass('clicked-node-text');
                    $(".card-triangle,.datalist-card").hide("slow");
                }

                function showCard(nodeDom, textSpan, treeNode) {
                    $('.ztree li').removeClass('clicked-node');
                    $('.ztree li span').removeClass('clicked-node-text');
                    nodeDom.addClass('clicked-node');
                    textSpan.addClass('clicked-node-text');
                    $(".card-triangle,.datalist-card").hide();
                    $that._createCard(nodeDom, treeNode, event);
                }
            },

            // 勾选事件
            _onCheck: function (event, treeId, treeNode) {
                treeNode.getCheckStatus().checked ? $that._checkNode(treeNode) : $that._uncheckNode(treeNode);
            },

            // 取消勾选节点
            _uncheckNode: function (treeNode, closeCard, noclear) {

                if (!treeNode.hasOwnProperty('children')) {
                    var viewer = MapUtils.getViewer();
                    // 移除是底图的图层
                    if (treeNode.hasOwnProperty("isBaseLayer") && treeNode.isBaseLayer) {
                        $.each(viewer.imageryLayers._layers, function (i, lyr) {
                            if (lyr !== undefined && lyr.hasOwnProperty("layerId")) {
                                if (treeNode.data.hasOwnProperty("serviceId")) {
                                    if (treeNode.data.serviceId === lyr.layerId) {
                                        viewer.scene.imageryLayers.remove(lyr);
                                    }
                                }

                                if (treeNode.data.hasOwnProperty("serviceIds")) {
                                    if (treeNode.data.serviceIds[0] === lyr.layerId) {
                                        viewer.scene.imageryLayers.remove(lyr);
                                    }
                                }
                            }
                        });
                    }

                    // 移除二维图层
                    if (Cesium.defined(treeNode.imageryLayer)) {
                        if (!treeNode.data.multiTime) {
                            treeNode.capables[0].type === 'ags_rest' ? treeNode.imageryLayer.imageryProvider.removeLayer() : viewer.scene.imageryLayers.remove(treeNode.imageryLayer, true);
                        } else {
                            $.each(treeNode.capables, function (i, capable) {
                                capable.type === 'ags_rest' ? treeNode.imageryLayer[i].imageryProvider.removeLayer() : viewer.scene.imageryLayers.remove(treeNode.imageryLayer[i], true);
                                delete treeNode.capables[i];
                            });
                        }
                    }
                    // 移除属性维图层及标签点击样式
                    viewer.scene.imageryLayers.remove(_imageryLayer);
                    $(".card-attribute-content span").removeClass('span-click-attr');

                    // 移除三维图层
                    if (Cesium.defined(treeNode.capables)) {
                        if (!treeNode.data.multiTime) {
                            viewer.scene.layers.remove(treeNode.capables[0].name);
                        }
                    }
                    var favCardId = "favCardCheckbox_" + treeNode.id;
                    var $favCard = $("#" + favCardId);
                    $favCard.removeClass("fav-card-checked").addClass("fav-card-uncheck");

                    // 清除时间维、属性维选中的标签及选中样式
                    delete treeNode.clickedAttrSpan;
                    delete treeNode.clickedTimeSpanId;
                    $(".card-attribute-content span").removeClass('span-click-attr');
                    if (!(treeNode.data.multiTime && noclear)) {
                        $(".card-timeline-content span").removeClass('span-click-time');
                    }

                    // 取消勾选的服务名称与正在显示的信息卡片名称相同时隐藏卡片
                    if ($(".card-title-name").attr("title") === treeNode.name && !closeCard) {
                        $(".card-triangle,.datalist-card").hide("slow");
                    }

                    // 隐藏属性识别按钮
                    if (treeNode.name === $(".card-title-name").attr("title")) {
                        if (treeNode.hasOwnProperty("capables")) {
                            if (!treeNode.data.multiTime) {
                                if (treeNode.capables[0].type === "ags_rest" || treeNode.capables[0].type === "spm_s3m") {
                                    $(".card-identify-icon").hide();
                                }
                            }
                        }
                    }
                }

                if (!treeNode.hasOwnProperty('children')) {
                    for (var k = 0; k < treeNode.data.cards.length; k++) {
                        var card = treeNode.data.cards[k];
                        if (card.type === 'legend') {
                            if (card.separate) {
                                if (!$('.datalist-legend').is(':hidden')) {
                                    $('.datalist-legend').hide();
                                }
                            }
                        }
                    }
                }
            },

            // 勾选节点
            _checkNode: function (treeNode, closeMsg) {
                addLegendDiv(treeNode);
                changeLegend();
                if (!treeNode.hasOwnProperty('children')) {
                    var viewer = MapUtils.getViewer();
                    var promise = $.ajax({
                        url: '../../mock/dataListTree2.json',
                        dataType: 'json',
                        success: function (res) {
                            if (treeNode.data.hasOwnProperty('serviceIds')) {
                                if (!treeNode.data.multiTime) {
                                    // 判断时间维标签是否有选中
                                    // 如果没有选中，添加最新年份；如果有选中，添加选中年份的服务
                                    if (!treeNode.hasOwnProperty("clickedTimeSpanId")) {
                                        $.each(res, function (i, nodeData) {
                                            if (treeNode.data.serviceIds[0] === nodeData.id) {
                                                treeNode.capables = [];
                                                treeNode.capables.push(nodeData);
                                            }
                                            $(".card-timeline-content").children("span").each(function () {
                                                if ($(this).attr('id') === treeNode.data.serviceIds[0]) {
                                                    $(this).addClass('span-click-time');
                                                    treeNode.clickedTimeSpanId = $(this).attr('id');
                                                }
                                            });
                                        });
                                    } else {
                                        $.each(res, function (i, nodeData) {
                                            if (treeNode.clickedTimeSpanId === nodeData.id) {
                                                treeNode.capables = [];
                                                treeNode.capables.push(nodeData);
                                            }
                                        });
                                    }
                                } else {
                                    // 判断时间维标签是否有选中
                                    // 如果没有选中，添加最新年份；如果有选中，添加选中年份的服务
                                    var count = 0;
                                    $(".card-timeline-content").children("span").each(function () {
                                        if ($(this).hasClass("span-click-time")) {
                                            count++;
                                        }
                                    });
                                    treeNode.clickedTimeSpanId = {};
                                    if (count > 0) {
                                        $.each(res, function (i, nodeData) {
                                            $(".card-timeline-content").children("span").each(function () {
                                                if ($(this).attr('id') === nodeData.id && $(this).hasClass("span-click-time")) {
                                                    treeNode.clickedTimeSpanId["t" + $(this).html()] = nodeData.id;
                                                    treeNode.capables["t" + $(this).html()] = nodeData;
                                                }
                                            });
                                        });
                                    } else {
                                        var latestTime = "";
                                        // timeInfo类型的时间维，选中最新时间，记录选中标签的ID
                                        $.each(treeNode.data.cards, function (i, card) {
                                            if (card.show && card.type === "timeline" && card.data.hasOwnProperty("type")) {
                                                if (card.data.type !== "timeInfo") {
                                                    latestTime = card.data.timeList[0].toString();
                                                }
                                            }
                                        });
                                        if (latestTime !== "") {
                                            $.each(res, function (i, nodeData) {
                                                if (treeNode.data.serviceIds[0] === nodeData.id) {
                                                    treeNode.capables = {};
                                                    treeNode.capables["t" + latestTime] = nodeData;
                                                }
                                                $(".card-timeline-content").children("span").each(function () {
                                                    if ($(this).attr('id') === treeNode.data.serviceIds[0]) {
                                                        $(this).addClass('span-click-time');
                                                        treeNode.clickedTimeSpanId["t" + latestTime] = $(this).attr('id');
                                                    }
                                                });
                                            });
                                        }
                                    }
                                }
                            } else {
                                $.each(res, function (i, nodeData) {
                                    if (treeNode.data.serviceId === nodeData.id) {
                                        treeNode.capables = [];
                                        treeNode.capables.push(nodeData);
                                    }
                                });

                                // timeInfo类型的时间维，选中最新时间，记录选中标签的ID
                                $.each(treeNode.data.cards, function (i, card) {
                                    if (card.show && card.type === "timeline" && card.data.hasOwnProperty("type")) {
                                        if (card.data.type === "timeInfo") {
                                            $("#" + treeNode.data.serviceId + "0").addClass('span-click-time');
                                            treeNode.capables[0].time = new Date(card.data.timeList[0].toString()).getTime();
                                            treeNode.clickedTimeSpanId = treeNode.data.serviceId + "0";
                                        }
                                    }
                                });
                            }
                        }
                    });
                    Cesium.when(promise, function () {
                        if (!treeNode.data.multiTime) {
                            switch (treeNode.capables[0].type) {
                                case "ags_rest":
                                case "ags_tile":
                                case "mljs_tile":
                                case "ags_vt":
                                    requestMetadata(treeNode.capables[0].url);
                                    break;
                                case "spm_tile":
                                    if (treeNode.capables[0].hasOwnProperty("agsURL")) {
                                        requestMetadata(treeNode.capables[0].agsURL);
                                    }
                                    break;
                                case "spm_terr":
                                    viewer.scene.terrainProvider = MapUtils.createGlobalLayer(treeNode.capables[0], viewer);
                                    break;
                                case "spm_s3m":
                                    $.ajax({
                                        type: "get",
                                        url: treeNode.capables[0].url,
                                        success: function (data) {
                                            if (data !== null && data !== undefined) {
                                                treeNode.serviceMetadata = data;
                                                MapUtils.createGlobalLayer(treeNode.capables[0], viewer);
                                                layuiLayer.msg('双击缩放至可见范围', {offset: '80px'});
                                                // 显示属性识别按钮
                                                if (treeNode.name === $(".card-title-name").attr("title")) {
                                                    $(".card-identify-icon").show();
                                                }
                                            } else {
                                                layuiLayer.msg('该服务异常，请检查服务是否可用', {offset: '80px', icon: 2});
                                            }
                                        },
                                        error: function () {
                                            layuiLayer.msg('该服务异常，请检查服务是否可用', {offset: '80px', icon: 2});
                                        }
                                    });
                                    break;
                                case "wms":
                                case "wmts":
                                    $that.addImageryLayer(treeNode);
                                    break;
                                case "geo_vt":
                                    $.each(treeNode.data.cards, function (i, val) {
                                        if (val.type === "symbol" && val.show) {
                                            if (treeNode.hasOwnProperty("clickedSymbolSpanId")) {
                                                treeNode.capables[0].sld = treeNode.clickedSymbolSpanId;
                                                $("#" + treeNode.clickedSymbolSpanId).addClass('span-click-symbol');
                                            } else {
                                                treeNode.capables[0].sld = val.data.symbolicSchemes[0].name;
                                                $("#" + treeNode.capables[0].sld).addClass('span-click-symbol');
                                            }
                                        }
                                    });
                                    $that.addImageryLayer(treeNode);
                                default:
                                    break;
                            }
                        } else {
                            $.each(treeNode.capables, function (i, capable) {
                                switch (capable.type) {
                                    case "ags_rest":
                                    case "ags_tile":
                                    case "mljs_tile":
                                    case "ags_vt":
                                        requestMetadata(capable.url, i);
                                        break;
                                    case "spm_tile":
                                        if (capable.hasOwnProperty("agsURL")) {
                                            requestMetadata(capable.agsURL, i);
                                        }
                                        break;
                                    case "spm_terr":
                                        viewer.scene.terrainProvider = MapUtils.createGlobalLayer(capable, viewer);
                                        break;
                                    case "spm_s3m":
                                        $.ajax({
                                            type: "get",
                                            url: capable.url,
                                            success: function (data) {
                                                if (data !== null && data !== undefined) {
                                                    treeNode.serviceMetadata[i] = data;
                                                    MapUtils.createGlobalLayer(capable, viewer);
                                                    layuiLayer.msg('双击缩放至可见范围', {offset: '80px'});
                                                    // 显示属性识别按钮
                                                    if (treeNode.name === $(".card-title-name").attr("title")) {
                                                        $(".card-identify-icon").show();
                                                    }
                                                } else {
                                                    layuiLayer.msg('该服务异常，请检查服务是否可用', {offset: '80px', icon: 2});
                                                }
                                            },
                                            error: function () {
                                                layuiLayer.msg('该服务异常，请检查服务是否可用', {offset: '80px', icon: 2});
                                            }
                                        });
                                        break;
                                    case "wms":
                                    case "wmts":
                                        $that.addImageryLayer(treeNode, i);
                                        break;
                                    case "geo_vt":
                                        $.each(treeNode.data.cards, function (i, val) {
                                            if (val.type === "symbol" && val.show) {
                                                if (treeNode.hasOwnProperty("clickedSymbolSpanId")) {
                                                    capable.sld = treeNode.clickedSymbolSpanId;
                                                    $("#" + treeNode.clickedSymbolSpanId).addClass('span-click-symbol');
                                                } else {
                                                    capable.sld = val.data.symbolicSchemes[0].name;
                                                    $("#" + capable.sld).addClass('span-click-symbol');
                                                }
                                            }
                                        });
                                        $that.addImageryLayer(treeNode, i);
                                    default:
                                        break;
                                }
                            });
                        }

                        function requestMetadata(url, timeFlag) {
                            var resource = Cesium.Resource.createIfNeeded(url);
                            resource.appendForwardSlash();
                            var _resource = resource.getDerivedResource({queryParameters: {f: 'json'}});
                            Cesium.when(_resource.fetchJsonp(), function (data) {
                                if (!timeFlag) {
                                    treeNode.serviceMetadata = data;
                                    if (treeNode.serviceMetadata.hasOwnProperty('error')) {
                                        layuiLayer.msg('该服务异常，请检查服务是否可用', {offset: '80px', icon: 2});
                                    } else {
                                        var provider = MapUtils.createGlobalLayer(treeNode.capables[0], viewer);
                                        var imageryLayer = new Cesium.ImageryLayer(provider);
                                        // 判断层级
                                        try {
                                            var fullExtent = data.fullExtent;
                                            var minLevel = 0;
                                            $.each(Camera.getResolution(data.spatialReference.wkid), function (index, ele) {
                                                if (data.minScale === ele.scale) {
                                                    minLevel = ele.level;
                                                }
                                            });
                                        } catch (e) {
                                            console.log(e)
                                        }
                                        $.extend(imageryLayer, {
                                            layerId: treeNode.capables[0].id,
                                            layerAlias: treeNode.capables[0].name,
                                            extent: Cesium.Rectangle.fromDegrees(fullExtent.xmin, fullExtent.ymin, fullExtent.xmax, fullExtent.ymax),
                                            minLevel: minLevel,
                                            info: data
                                        });
                                        treeNode.imageryLayer = imageryLayer;

                                        if (treeNode.capables[0].type !== 'ags_rest') {
                                            MapUtils.getViewer().scene.imageryLayers.add(imageryLayer);
                                        }

                                        if (closeMsg) {
                                            return;
                                        } else {
                                            layuiLayer.msg('双击缩放至可见范围', {offset: '80px'});
                                        }
                                    }
                                } else {
                                    if (!treeNode.hasOwnProperty("serviceMetadata")) {
                                        treeNode.serviceMetadata = {};
                                    }
                                    treeNode.serviceMetadata[timeFlag] = data;
                                    if (treeNode.serviceMetadata[timeFlag].hasOwnProperty('error')) {
                                        layuiLayer.msg('该服务异常，请检查服务是否可用', {offset: '80px', icon: 2});
                                    } else {
                                        var provider = MapUtils.createGlobalLayer(treeNode.capables[timeFlag], viewer);
                                        var imageryLayer = new Cesium.ImageryLayer(provider);
                                        // 判断层级
                                        try {
                                            var fullExtent = data.fullExtent;
                                            var minLevel = 0;
                                            $.each(Camera.getResolution(data.spatialReference.wkid), function (index, ele) {
                                                if (data.minScale === ele.scale) {
                                                    minLevel = ele.level;
                                                }
                                            });
                                        } catch (e) {
                                            console.log(e)
                                        }
                                        $.extend(imageryLayer, {
                                            layerId: treeNode.capables[timeFlag].id,
                                            layerAlias: treeNode.capables[timeFlag].name,
                                            extent: Cesium.Rectangle.fromDegrees(fullExtent.xmin, fullExtent.ymin, fullExtent.xmax, fullExtent.ymax),
                                            minLevel: minLevel,
                                            info: data
                                        });
                                        if (!treeNode.hasOwnProperty("imageryLayer")) {
                                            treeNode.imageryLayer = {};
                                        }
                                        treeNode.imageryLayer[timeFlag] = imageryLayer;

                                        if (treeNode.capables[timeFlag].type !== 'ags_rest') {
                                            MapUtils.getViewer().scene.imageryLayers.add(imageryLayer);
                                        }

                                        if (closeMsg) {
                                            return;
                                        } else {
                                            layuiLayer.msg('双击缩放至可见范围', {offset: '80px'});
                                        }
                                    }
                                }
                            });
                        }


                    });
                    var favCardId = "favCardCheckbox_" + treeNode.id;
                    var $favCard = $("#" + favCardId);
                    $favCard.addClass("fav-card-checked").removeClass("fav-card-uncheck");
                }
            },

            addImageryLayer: function (treeNode, i) {
                if (!i) {
                    i = 0;
                }
                var viewer = MapUtils.getViewer();
                var provider = MapUtils.createGlobalLayer(treeNode.capables[i], viewer);
                var imageryLayer = new Cesium.ImageryLayer(provider);
                var alias;
                treeNode.capables[i].hasOwnProperty('alias') ? alias = treeNode.capables[i].alias : alias = treeNode.capables[i].name;
                $.extend(imageryLayer, {
                    layerId: treeNode.capables[i].id,
                    layerAlias: alias
                });
                if (treeNode.capables[i].hasOwnProperty('extent')) {
                    $.extend(imageryLayer, {
                        extent: treeNode.capables[i].extent
                    });
                }
                treeNode.imageryLayer = imageryLayer;
                MapUtils.getViewer().scene.imageryLayers.add(imageryLayer);
            },

            // 双击树节点图层缩放至可见
            _onDblClick: function (event, treeId, treeNode) {
                if ($that.clickFlag) { // 取消上次延时未执行的方法
                    $that.clickFlag = clearTimeout($that.clickFlag);
                }
                var viewer = MapUtils.getViewer();
                var scene = viewer.scene, widget = viewer.cesiumWidget;
                var timeFlag;
                if (treeNode.hasOwnProperty('capables')) {
                    if (!treeNode.data.multiTime) {
                        switch (treeNode.capables[0].type) {
                            case "ags_rest":
                            case "ags_tile":
                            case "ags_vt":
                                flyToBounds();
                                break;
                            case "wms":
                            case "wmts":
                            case "geo_wmts":
                            case "geo_vt":
                                if (treeNode.capables[0].hasOwnProperty('extent')) {
                                    var extent = treeNode.capables[0].extent;
                                    scene.camera.flyTo({
                                        destination: Cesium.Rectangle.fromDegrees(extent.xmin, extent.ymin, extent.xmax, extent.ymax)
                                    });
                                }
                                break;
                            case "spm_tile":
                                flyToBounds();
                                break;
                            case "spm_s3m":
                                if (treeNode.isChecked) {
                                    // 判断是否有定位位置配置
                                    if (treeNode.capables[0].cameraPosition !== null) {
                                        try {
                                            var cameraPosition = treeNode.capables[0].cameraPosition;
                                            scene.camera.flyTo({
                                                destination: new Cesium.Cartesian3.fromDegrees(cameraPosition.longitude, cameraPosition.latitude, cameraPosition.altitude),
                                                orientation: {
                                                    heading: cameraPosition.heading,
                                                    pitch: cameraPosition.pitch,
                                                    roll: cameraPosition.roll
                                                }
                                            });
                                            if (!scene.pickPositionSupported) {
                                                alert('不支持深度纹理,无法拾取位置！');
                                            }
                                        } catch (e) {
                                            if (widget._showRenderLoopErrors) {
                                                var title = '渲染时发生错误，已停止渲染。';
                                                widget.showErrorPanel(title, undefined, e);
                                            }
                                        }
                                    } else {
                                        var str = treeNode.capables[0].url;
                                        var matchReg = /http:.*?(?=realspace)/gi;
                                        var url = str.match(matchReg);
                                        try {
                                            //定位到场景
                                            Cesium.loadJson(url + 'realspace/scenes.json').then(function (scenes) {
                                                var sname = scenes[0].name;
                                                Cesium.loadJson(url + 'realspace/scenes/' + sname + '.json').then(function (jsonData) {
                                                    var cameraPosition = jsonData.camera;
                                                    var longitude = cameraPosition.longitude,
                                                        latitude = cameraPosition.latitude,
                                                        altitude = cameraPosition.altitude;
                                                    var heading = cameraPosition.heading,
                                                        tilt = Cesium.Math.toRadians(cameraPosition.tilt - 90);
                                                    // 如果没有倾角，加倾角
                                                    if (cameraPosition.tilt < 0.1) {
                                                        tilt = tilt + 1.2;
                                                        latitude = latitude - 0.01;
                                                        altitude = 400;
                                                    }
                                                    //设置相机位置、视角
                                                    scene.camera.flyTo({
                                                        destination: new Cesium.Cartesian3.fromDegrees(longitude, latitude, altitude),
                                                        orientation: {
                                                            heading: heading,
                                                            pitch: tilt,
                                                            roll: 0
                                                        }
                                                    });
                                                    if (!scene.pickPositionSupported) {
                                                        alert('不支持深度纹理,无法拾取位置！');
                                                    }
                                                });
                                            });
                                        } catch (e) {
                                            if (widget._showRenderLoopErrors) {
                                                var title = '渲染时发生错误，已停止渲染。';
                                                widget.showErrorPanel(title, undefined, e);
                                            }
                                        }
                                    }
                                }
                                break;
                        }
                    } else {
                        $.each(treeNode.capables, function (i, capable) {
                            if (!timeFlag) {
                                timeFlag = i;
                            }
                        });
                        if (timeFlag) {
                            switch (treeNode.capables[timeFlag].type) {
                                case "ags_rest":
                                case "ags_tile":
                                case "ags_vt":
                                    flyToBounds();
                                    break;
                                case "wms":
                                case "wmts":
                                case "geo_wmts":
                                case "geo_vt":
                                    if (treeNode.capables[0].hasOwnProperty('extent')) {
                                        var extent = treeNode.capables[0].extent;
                                        scene.camera.flyTo({
                                            destination: Cesium.Rectangle.fromDegrees(extent.xmin, extent.ymin, extent.xmax, extent.ymax)
                                        });
                                    }
                                    break;
                                case "spm_tile":
                                    flyToBounds();
                                    break;
                                case "spm_s3m":
                                    if (treeNode.isChecked) {
                                        // 判断是否有定位位置配置
                                        if (treeNode.capables[0].cameraPosition !== null) {
                                            try {
                                                var cameraPosition = treeNode.capables[0].cameraPosition;
                                                scene.camera.flyTo({
                                                    destination: new Cesium.Cartesian3.fromDegrees(cameraPosition.longitude, cameraPosition.latitude, cameraPosition.altitude),
                                                    orientation: {
                                                        heading: cameraPosition.heading,
                                                        pitch: cameraPosition.pitch,
                                                        roll: cameraPosition.roll
                                                    }
                                                });
                                                if (!scene.pickPositionSupported) {
                                                    alert('不支持深度纹理,无法拾取位置！');
                                                }
                                            } catch (e) {
                                                if (widget._showRenderLoopErrors) {
                                                    var title = '渲染时发生错误，已停止渲染。';
                                                    widget.showErrorPanel(title, undefined, e);
                                                }
                                            }
                                        } else {
                                            var str = treeNode.capables[0].url;
                                            var matchReg = /http:.*?(?=realspace)/gi;
                                            var url = str.match(matchReg);
                                            try {
                                                //定位到场景
                                                Cesium.loadJson(url + 'realspace/scenes.json').then(function (scenes) {
                                                    var sname = scenes[0].name;
                                                    Cesium.loadJson(url + 'realspace/scenes/' + sname + '.json').then(function (jsonData) {
                                                        var cameraPosition = jsonData.camera;
                                                        var longitude = cameraPosition.longitude,
                                                            latitude = cameraPosition.latitude,
                                                            altitude = cameraPosition.altitude;
                                                        var heading = cameraPosition.heading,
                                                            tilt = Cesium.Math.toRadians(cameraPosition.tilt - 90);
                                                        // 如果没有倾角，加倾角
                                                        if (cameraPosition.tilt < 0.1) {
                                                            tilt = tilt + 1.2;
                                                            latitude = latitude - 0.01;
                                                            altitude = 400;
                                                        }
                                                        //设置相机位置、视角
                                                        scene.camera.flyTo({
                                                            destination: new Cesium.Cartesian3.fromDegrees(longitude, latitude, altitude),
                                                            orientation: {
                                                                heading: heading,
                                                                pitch: tilt,
                                                                roll: 0
                                                            }
                                                        });
                                                        if (!scene.pickPositionSupported) {
                                                            alert('不支持深度纹理,无法拾取位置！');
                                                        }
                                                    });
                                                });
                                            } catch (e) {
                                                if (widget._showRenderLoopErrors) {
                                                    var title = '渲染时发生错误，已停止渲染。';
                                                    widget.showErrorPanel(title, undefined, e);
                                                }
                                            }
                                        }
                                    }
                                    break;
                            }
                        }
                    }
                }

                function flyToBounds() {
                    if (treeNode.isChecked) {
                        if (treeNode.hasOwnProperty('serviceMetadata')) {
                            if (!treeNode.data.multiTime) {
                                if (treeNode.serviceMetadata.hasOwnProperty('fullExtent')) {
                                    var fullExtent = treeNode.serviceMetadata.fullExtent;
                                    scene.camera.flyTo({
                                        destination: Cesium.Rectangle.fromDegrees(fullExtent.xmin, fullExtent.ymin, fullExtent.xmax, fullExtent.ymax)
                                    });
                                }
                            } else {
                                if (timeFlag) {
                                    if (treeNode.serviceMetadata[timeFlag].hasOwnProperty('fullExtent')) {
                                        var fullExtent = treeNode.serviceMetadata[timeFlag].fullExtent;
                                        scene.camera.flyTo({
                                            destination: Cesium.Rectangle.fromDegrees(fullExtent.xmin, fullExtent.ymin, fullExtent.xmax, fullExtent.ymax)
                                        });
                                    }
                                }
                            }
                        }
                    }
                }

                /*function metadataSuccess(data) {
                    var fullExtent = data.fullExtent;
                    scene.camera.flyTo({
                        destination: Cesium.Rectangle.fromDegrees(fullExtent.xmin, fullExtent.ymin, fullExtent.xmax, fullExtent.ymax)
                    });
                }

                function metadataFailure(data) {
                    var readyPromise = Cesium.when.resolve(true);
                    var message = 'An error occurred while accessing ' + treeNode.capables[0].url + '.';
                    readyPromise.reject(new RuntimeError(message));
                }

                function requestMetadataToFlyBounds(url) {

                    var resource = Cesium.Resource.createIfNeeded(url);
                    resource.appendForwardSlash();
                    var _resource = resource.getDerivedResource({queryParameters: {f: 'json'}});
                    Cesium.when(_resource.fetchJsonp(), metadataSuccess, metadataFailure);
                }*/
            },

            // 生成右侧弹出card
            _createCard: function (dom, treeNode, event) {
                var hasLegend = false;
                $(".datalist-card-info,.datalist-card-fly,.datalist-card-timeline,.datalist-card-attr,.datalist-card-legend,.datalist-card-symbol").empty();
                // $(".card-identify-icon").removeClass("identify-in-use")
                //     .attr("title", "属性识别");

                // 卡片标题
                if (treeNode.name.length < 11) {
                    $(".card-title-name").text(treeNode.name)
                        .attr("title", treeNode.name);
                } else {
                    var cardTitle = treeNode.name.substring(0, 11);
                    $(".card-title-name").text(cardTitle + "...")
                        .attr("title", treeNode.name);
                }

                // 服务类型是ags_rest和spm_s3m时，属性识别按钮显示
                if (treeNode.isChecked && treeNode.hasOwnProperty("capables") && !treeNode.data.multiTime) {
                    if (treeNode.capables[0].type === "ags_rest" || treeNode.capables[0].type === "spm_s3m") {
                        $(".card-identify-icon").show();
                    } else {
                        $(".card-identify-icon").hide();
                    }
                } else {
                    $(".card-identify-icon").hide();
                }

                // 判断collectNode是否包含
                var isExist = $that._isContainedCol(treeNode);
                if (isExist) {
                    $("#icon-fav1").hide();
                    $("#icon-fav2").show();
                } else {
                    $("#icon-fav2").hide();
                    $("#icon-fav1").show();
                }
                var attrMulti = false;
                var appendCard = $.each(treeNode.data.cards, function (index, value) {
                    if (value.show) {
                        switch (value.type) {
                            case 'info':
                                $that._createCardInfo(value, treeNode);
                                break;
                            case 'fly':
                                $that._createCardFly(value, treeNode);
                                break;
                            case 'timeline':
                                $that._createCardTimeline(value, treeNode);
                                break;
                            case 'attr':
                                $that._createCardAttr(treeNode, value, attrMulti);
                                attrMulti = true;
                                break;
                            case 'symbol':
                                $that._createCardSymbol(treeNode, value);
                                break;
                            case 'legend':
                                if(!value.separate){
                                    hasLegend = true;
                                    $that._createCardLegend(value);
                                }
                                break;
                            case 'coastline':
                                $that._createCardCoastline(treeNode, value);
                                break;
                            default:
                                break;
                        }
                    }
                });

                // 显示卡片
                var card = ".datalist-card";
                // 鼠标点击焦点高度减去110 使卡片居中
                cardTop = event.pageY - 110;
                if (!hasLegend) {
                    cardHeight.h = $(card).height();
                }
                // 关闭卡片
                $(".datalist-card .icon-card-close").off("click").on("click", function () {
                    // $(".card-identify-icon").removeClass("identify-in-use")
                    //     .attr("title", "属性识别");
                    $(".card-triangle").hide("slow");
                    $(card).hide("slow");
                    MapUtils.viewer.dataSources.removeAll();
                    if ($that.billboards) {
                        $that.billboards.removeAll();
                    }
                    if ($that.layer) {
                        $that.layer.closeAll();
                    }
                    if ($that.popupHandler) {
                        $that.popupHandler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_CLICK);
                    }
                    if ($that.identifyHandler) {
                        $that.identifyHandler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_CLICK);
                    }
                    if (MapUtils.viewer.pickEvent.numberOfListeners > 0) {
                        for (var i = 0; i < MapUtils.viewer.pickEvent._listeners.length; i++) {
                            MapUtils.viewer.pickEvent.removeEventListener(MapUtils.viewer.pickEvent._listeners[i])
                        }
                    }
                    // 移除单击样式
                    $that.removeClickStyle();
                });

                // 点击弹出卡片的收藏图标
                $("#icon-fav1").off("click").on("click", function () {
                    $('.data-list-favourite').empty();
                    $("#icon-fav1").hide();
                    $("#icon-fav2").show();
                    if (!$that._isContainedCol(treeNode)) {
                        //保存方位角信息
                        var mapView = MapUtils.getMapView();
                        treeNode.mapView = mapView;
                        $that.collectNodes.push(treeNode);
                    }
                    $that._favCardContent(treeNode);
                });

                // 点击弹出卡片的取消收藏图标
                $("#icon-fav2").off("click").on("click", function () {
                    $('.data-list-favourite').empty();
                    $("#icon-fav2").hide();
                    $("#icon-fav1").show();
                    $.each($that.collectNodes, function (i, node) {
                        // 隐藏被取消服务的信息卡片
                        if ($(".layui-tab-title .layui-this").attr("lay-id") === "collect" && node.name === $(".card-title-name").attr("title")) {
                            $(".card-triangle,.datalist-card").hide("slow");
                        }

                        if (node.id === treeNode.id) {
                            $that.collectNodes.splice(i, 1);
                            return false;
                        }
                    });
                    $that._favCardContent();
                });

                // 点击属性识别
                var identifyBtn = $(".card-identify-icon");
                identifyBtn.off("click").on("click", function () {
                    // if (!identifyBtn.hasClass("identify-in-use")) {
                    //     identifyBtn.addClass("identify-in-use")
                    //         .attr("title", "关闭属性识别");
                    var url = treeNode.capables[0].url,
                        type = treeNode.capables[0].type;
                    var viewer = MapUtils.getViewer();
                    switch (type) {
                        case "ags_rest":
                            if ($that.popupHandler) {
                                $that.popupHandler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_CLICK);
                            }
                            $that.identifyHandler = new Cesium.ScreenSpaceEventHandler(viewer.scene.canvas);
                            $that.identifyHandler.setInputAction(function (click) {
                                var clickPoint = viewer.scene.pickPosition(click.position);
                                var latlng = Cesium.Cartographic.fromCartesian(clickPoint);
                                var lat = Cesium.Math.toDegrees(latlng.latitude);
                                var lng = Cesium.Math.toDegrees(latlng.longitude);
                                var identifyUrl = url + '/identify';
                                var rectangle = MapUtils.viewer.camera.computeViewRectangle();
                                var west = rectangle.west / Math.PI * 180;
                                var north = rectangle.north / Math.PI * 180;
                                var east = rectangle.east / Math.PI * 180;
                                var south = rectangle.south / Math.PI * 180;
                                var params = {
                                    f: 'json',
                                    geometry: '{x: ' + lng + ', y: ' + lat + '}',
                                    tolerance: 1,
                                    mapExtent: west + ',' + south + ',' + east + ',' + north,
                                    imageDisplay: '256,256,1',
                                    layers: [0]
                                };
                                $.support.cors = true;// 执行属性识别Rest服务
                                $.ajax({
                                    url: identifyUrl,
                                    type: 'get',
                                    dataType: 'jsonp',
                                    data: params,
                                    success: function (data, status) {
                                        MapUtils.viewer.dataSources.removeAll();
                                        if ($that.billboards) {
                                            $that.billboards.removeAll();
                                        }
                                        if ($that.layer) {
                                            $that.layer.closeAll();
                                        }
                                        var features = $that._jsonToGeo(data);
                                        var temp = {};

                                        var isPoint = false;
                                        $that.billboards = MapUtils.viewer.scene.primitives.add(new Cesium.BillboardCollection());
                                        $.each(features.features, function (index, value) {
                                            if (value.geometry.type.includes("Point")) {
                                                isPoint = true;
                                                value.properties.billboard = $that.createMarker(value.geometry.coordinates[0], value.geometry.coordinates[1], $that.billboards);
                                            }
                                        });
                                        if (isPoint) {
                                            if ($that.billboards) {
                                                $that.viewerflyToLonLat(features.features[0].geometry.coordinates[0], features.features[0].geometry.coordinates[1]);
                                            }
                                        } else {
                                            temp.features = features.features;
                                            temp.type = features.type;
                                            var promise = Cesium.GeoJsonDataSource.load(temp);
                                            promise.then(function (dataSource) {
                                                MapUtils.viewer.dataSources.add(dataSource);
                                                var entities = dataSource.entities.values;
                                                MapUtils.setAllStyle(entities)
                                            });
                                            MapUtils.viewer.flyTo(promise);
                                        }
                                        //初始化弹窗监听
                                        $that._setPopupInputAction(treeNode.propertyList, features.features);
                                        $that.showPropertyPanel(features.features[0].properties, treeNode.propertyList, "modelIdentify", treeNode.propertyTitle);
                                    }
                                });

                                $that.identifyHandler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_CLICK);

                            }, Cesium.ScreenSpaceEventType.LEFT_CLICK);
                            break;
                        case "spm_s3m":
                            layuiLayer.closeAll();

                            var layerName = treeNode.capables[0].layerName,
                                dataURL = treeNode.capables[0].dataURL,
                                dataSourceName = treeNode.capables[0].dataSourceName,
                                dataSetName = treeNode.capables[0].dataSetName;

                            var thisModelLayer = viewer.scene.layers.find(layerName);

                            // 设置模型为可选中
                            thisModelLayer.selectEnabled = true;

                            // 设置属性查询参数
                            thisModelLayer.setQueryParameter({
                                url: dataURL,
                                dataSourceName: dataSourceName,
                                dataSetName: dataSetName
                            });


                            // 注册鼠标点击事件
                            viewer.pickEvent.addEventListener(getModelFeature);

                        function getModelFeature(feature) {
                            $that.showPropertyPanel(feature, treeNode.propertyList, "modelIdentify", treeNode.propertyTitle);
                            viewer.pickEvent.removeEventListener(getModelFeature);
                            thisModelLayer.selectEnabled = false;
                        }

                            break;
                        default:
                            break;
                    }

                    // } else {
                    //     identifyBtn.removeClass("identify-in-use")
                    //         .attr("title", "属性识别");
                    //     var type = treeNode.capables[0].type;
                    //     var viewer = MapUtils.getViewer();
                    //     if (type === "spm_s3m") {
                    //         var thisModelLayer = viewer.scene.layers.find(treeNode.capables[0].layerName);
                    //         //释放被选择的图层对象
                    //         thisModelLayer.releaseSelection();
                    //         //设置模型为不可选中
                    //         thisModelLayer.selectEnabled = false;
                    //     }
                    // }
                });
            },

            // createClickPopup: function () {
            //     var content = "<div class='search-popup-content' id='searchPopupContent'>" +
            //         "<div class='search-popup-left'></div><div class='search-popup-title'><span id='searchPopupTitle'></span></div>" +
            //         "<div class='search-popup-introduce'></div>" +
            //         "<div class='search-popup-photo' style='background:" + $that.defaultPhotoUrl + "'></span></div>" +
            //         "<div class='search-popup-bottom'><div class='search-popup-navigation'><i class='icon-f-analytic-router'></i>" +
            //         "</div>" +
            //         "<div class='search-popup-around'><i class='icon-f-surround'></i></div></div>" +
            //         "</div>";
            //
            //     $("#globalContainer").append(content);
            // },
            //
            // closePopup: function () {
            //     if ($that.updatePopLocationListener !== undefined && $that.updatePopLocationListener !== null) {
            //         $('#searchPopupContent').css('display', 'none');
            //         $that.updatePopLocationListener();
            //         $that.updatePopLocationListener = null;
            //     }
            // },
            createPropertiesList: function (propertys, fieldsMapping, serviceType) {
                var content = "";
                var haveContent = false;
                content += "<div style='width: 308px;height:340px'><div class='search-right-pane-part'>" +
                    "<div class='search-text-title'><span>相关属性</span></div>" +
                    "<div class='search-associated-list layui-container'>";
                $.each(fieldsMapping, function (i, val) {
                    if (serviceType === "modelIdentify") {
                        if (propertys.hasOwnProperty(val.key) && propertys[val.key] !== null
                            && propertys[val.key].toLowerCase() !== "null" && propertys[val.key].toLowerCase() !== "undefined") {
                            content += "<div class='layui-row'>" +
                                "<div class='search-associated-item layui-col-xs12'>" +
                                "<span class='search-associated-label layui-col-xs3'>"
                                + val.label + "</span><span class='layui-col-xs1'>：</span>" +
                                "<span class='search-associated-content layui-col-xs8'>" + propertys[val.key] + "</span></div></div>";
                            haveContent = true;
                        }
                    } else {
                        if (propertys.hasOwnProperty(val.key) && propertys[val.key].getValue() !== null
                            && propertys[val.key].getValue().toLowerCase() !== "null" && propertys[val.key].getValue().toLowerCase() !== "undefined") {
                            content += "<div class='layui-row'>" +
                                "<div class='search-associated-item layui-col-xs12'>" +
                                "<span class='search-associated-label layui-col-xs3'>"
                                + val.label + "</span><span class='layui-col-xs1'>：</span>" +
                                "<span class='search-associated-content layui-col-xs8'>" + propertys[val.key].getValue() + "</span></div></div>";
                            haveContent = true;
                        }
                    }
                });
                content += '</div></div></div>';
                if (haveContent) {
                    return content;
                } else {
                    return "";
                }
            },
            showPropertyPanel: function (propertys, fieldsMapping, serviceType, propertyTitle) {
                layui.use(['layer', 'carousel', 'form', 'laypage', 'element'], function () {
                    var type = "r";
                    $that.popupId = '#layerDemo' + type;
                    var titleContext = "暂无标题";
                    if (serviceType === "modelIdentify" && propertys.hasOwnProperty(propertyTitle)) {
                        titleContext = propertys[propertyTitle]
                    } else if (propertys.hasOwnProperty(propertyTitle) && propertys[propertyTitle].getValue() !== "Null" && propertys[propertyTitle].getValue().trim() !== "") {
                        titleContext = propertys["名称"].getValue();
                    }
                    var title = "<span>" + titleContext + "</span>";
                    var left = screen.width - 309 + "px";
                    var top = $(".new-header-box").height() + $(".tool-widgets-pane").height() + 11 + "px";
                    var offSetTop = [top, left];
                    var layer = layui.layer;
                    $that.layer = layer;
                    var layerContent = $that.createPropertiesList(propertys, fieldsMapping, serviceType);
                    if (layerContent !== "") {
                        layer.open({
                            type: 1
                            , offset: offSetTop
                            , id: 'layerDemo' + type //防止重复弹出
                            , content: layerContent

                            // , content:  '<div style="padding: 50px; line-height: 22px; background-color: #393D49; color: #fff; font-weight: 300;">你知道吗？亲！<br>layer ≠ layui<br><br>layer只是作为Layui的一个弹层模块，由于其用户基数较大，所以常常会有人以为layui是layerui<br><br>layer虽然已被 Layui 收编为内置的弹层模块，但仍然会作为一个独立组件全力维护、升级。<br><br>我们此后的征途是星辰大海 ^_^</div>'
                            , maxWidth: 308
                            , title: [title, "background-color: rgba(67, 117, 253, 0.6);cursor: move;" +
                            "font-size: 1.3em;text-align: center;height: 90px;color: #fff;padding: 0;border-bottom: unset;background-image:url('/assets/images/bgPopupPanel.png')"]
                            // , btn: '关闭全部'
                            // , btnAlign: 'c' //按钮居中
                            , shade: 0 //不显示遮罩
                            , success: function () {


                            }
                            , yes: function () {
                                layer.closeAll();
                            }
                            , cancel: function () {
                                layer.closeAll();
                            }
                        });
                    } else {
                        layer.msg("当前对象属性为空");
                    }
                });

            },
            _setPopupInputAction: function (fieldsMapping, features) {
                var viewer = MapUtils.getViewer();
                var handler = new Cesium.ScreenSpaceEventHandler(viewer.scene.canvas);
                $that.popupHandler = handler;
                handler.setInputAction(function (click) {
                    var pickedObject = viewer.scene.pick(click.position);
                    var clickPoint = viewer.scene.pickPosition(click.position);
                    if (typeof pickedObject !== 'undefined' && typeof pickedObject.id !== 'undefined') {
                        $that.showPropertyPanel(pickedObject.id.properties, fieldsMapping);

                        store.set({type: "属性识别", feature: features[0]})
                    }
                }, Cesium.ScreenSpaceEventType.LEFT_CLICK);
            },

            _isContainedCol: function (treeNode) {
                var isExist = false;
                $($that.collectNodes).each(function (i, v) {
                    if (v.id == treeNode.id) {
                        isExist = true;
                        return;
                    }
                });
                return isExist;
            },

            _jsonToGeo: function (features) {
                var geoFeatures = [];
                //将得到的json转成GeoJson
                features.results.forEach(function (result) {
                    var geoFeature = {
                        type: 'Feature',
                        properties: result.attributes,
                        id: result.attributes.OBJECTID,
                        layerId: result.layerId,
                        layerName: result.layerName,
                        geometry: {
                            type: '',
                            coordinates: []
                        }
                    };
                    //判断要素类型
                    switch (result.geometryType) {
                        case 'esriGeometryPolygon' :
                            geoFeature.geometry.type = 'Polygon';
                            geoFeature.geometry.coordinates = result.geometry.rings;
                            geoFeatures.push(geoFeature);
                            break;
                        case 'esriGeometryPolyline' :
                            geoFeature.geometry.type = 'LineString';
                            geoFeature.geometry.coordinates = result.geometry.paths[0];
                            geoFeatures.push(geoFeature);
                            break;
                        case 'esriGeometryPoint' :
                            geoFeature.geometry.type = 'Point';
                            geoFeature.geometry.coordinates = [result.geometry.x, result.geometry.y];
                            geoFeatures.push(geoFeature);
                            break;
                        case 'esriGeometryMultipoint':
                            geoFeature.geometry.type = 'MultiPoint';
                            geoFeature.geometry.coordinates = result.geometry.points;
                            geoFeatures.push(geoFeature);
                            break;
                    }
                });
                return {
                    features: geoFeatures,
                    type: 'FeatureCollection'
                };
            },

            _favCardContent: function () {
                $('.data-list-favourite').empty();
                var collectHtml = '';
                var notFoundPng = rootPath + '/assets/images/noPic.png';
                //解决重复收藏bug去重
                for (var i = $that.collectNodes.length - 1; i >= 0; i--) {
                    var item = $that.collectNodes[i];
                    var itemId = item.id || item.tId;
                    var isContain = false;
                    for (var j = $that.collectNodes.length - 1; j >= 0; j--) {
                        if (i == j) {
                            continue;
                        }
                        var tmp = $that.collectNodes[j];
                        var tmpId = tmp.id || tmp.tId;
                        if (tmpId == itemId) {
                            isContain = true;
                            break;
                        }
                    }
                    if (isContain) {
                        $that.collectNodes.splice(i, 1);
                    }
                }

                $.each($that.collectNodes, function (i, obj) {
                    //兼容云资源检索
                    if (obj.resource) {
                        obj.tId = obj.id;
                        obj.name = obj.description;
                    } else {
                        try {
                            obj.imgUrl = obj.data.cards[0].data.background;
                        } catch (e) {
                            obj.imgUrl = null;
                        }

                    }
                    var detail = "";
                    try {
                        detail = obj.data.cards[0].data.content;
                    } catch (e) {
                        detail = obj.title;
                    }
                    obj.imgUrl = obj.imgUrl || notFoundPng;
                    collectHtml +=
                        '<div class="favourite-card" id="favCard_' + obj.id + '" onselectstart="return false;">' +
                        '    <img src="' + obj.imgUrl + '">' +
                        '    <div class="service-info" id="serviceInfo' + obj.id + '">' +
                        '        <div class="fav-info-title"><p>' + obj.name + '</p></div>' +
                        '        <div class="fav-info-detail">' + detail + '</div>' +
                        '    </div>' +
                        '    <div class="fav-card-icon" id="favCardIcon' + obj.id + '"><i style="color: #2a80ff;font-size: 20px" class="iconfont cancel_fav icon-f-tool-mark" title="取消收藏" id="' + obj.id + '"></i></div>' +
                        '    <div class="fav-card-location" location_id=' + obj.id + '><i title="设置方位角" style="font-size: 23px;color: #2a80ff" class="iconfont set-map-view icon-f-location"> </i></div>' +
                        '    <div class="fav-card-check"><i class="iconfont data-list icon-f-uncheck" id="favCardCheckbox_' + obj.id + '"></i></div>' +
                        '</div>';
                });
                if (!collectHtml) {
                    collectHtml += '<div class ="content-none">暂无收藏</div>';
                }
                $('.data-list-favourite').append(collectHtml);

                $that._uploadFavCol();
                //绑定数据
                //更新checkbox状态
                $.each($that.collectNodes, function (i, obj) {
                    var id = obj.id;
                    $("#favCardCheckbox_" + id).data(obj);
                    $("#" + id).data(obj);
                    var node = ztreeObj.getNodeByParam("id", obj.id, null);
                    if (node != null) {
                        //左侧资源树节点
                        var $favCheck = $("#favCardCheckbox_" + id);
                        var status = node.getCheckStatus();
                        if (status.checked) {
                            $favCheck.addClass("fav-card-checked").removeClass("fav-card-uncheck");
                        } else {
                            $favCheck.removeClass("fav-card-checked").addClass("fav-card-uncheck");
                        }
                    }
                });
                // 单击收藏卡片，右侧弹出信息卡片，设置点击样式
                $(".favourite-card").on("click", function () {
                    var clickDom = $(this);
                    if ($that.clickFlagFavCard) { // 取消上次延时未执行的方法
                        $that.clickFlagFavCard = clearTimeout($that.clickFlagFavCard);
                    }
                    $that.clickFlagFavCard = setTimeout(function () {
                        // click事件的处理
                        $(".favourite-card").removeClass("fav-card-focus");
                        clickDom.addClass("fav-card-focus");
                        var idAll = clickDom.attr("id");
                        var strArr = idAll.split("_");
                        var nodeId = strArr[1];
                        var node = $.fn.zTree.getZTreeObj(zTreeId).getNodeByParam("id", nodeId, null);
                        //兼容云资源检索
                        if (!node) {
                            return;
                        }
                        $that._createCard(clickDom, node);
                    }, 300); // 延时300毫秒执行
                });

                // 双击收藏卡片，定位至该服务
                $(".favourite-card").on("dblclick", function (e) {
                    e.preventDefault();
                    var clickDom = $(this);
                    if ($that.clickFlagFavCard) {
                        $that.clickFlagFavCard = clearTimeout($that.clickFlagFavCard);
                    }
                    var strAll = clickDom.attr("id");
                    var nodeId = strAll.split("_")[1];
                    var node = $.fn.zTree.getZTreeObj(zTreeId).getNodeByParam("id", nodeId, null);
                    if (!node) {
                        return;
                    }
                    $that._onDblClick(e, zTreeId, node);
                });

                // 勾选框样式
                $.each($that.collectNodes, function (i, node) {
                    //兼容云资源检索
                    if ($("#resourceCardCheckbox_" + node.id).hasClass("fav-card-checked")) {
                        $("#favCardCheckbox_" + node.id).removeClass("fav-card-uncheck").addClass("fav-card-checked");
                    }
                    if (node.hasOwnProperty("capables")) {
                        var isCheck = WidgetUtils.getCheckStatus(node.capables[0].id);
                        if (isCheck) {
                            $("#favCardCheckbox_" + node.id).addClass("fav-card-checked");
                        } else {
                            $("#favCardCheckbox_" + node.id).addClass("fav-card-uncheck");
                        }
                    } else {
                        $("#favCardCheckbox_" + node.id).addClass("fav-card-uncheck");
                    }
                });

                // 勾选事件
                //edit by ycx ：修改以iconfont选择器定位为datalist
                $(".data-list").on("click", function (e) {
                    e.stopPropagation();
                    // 获取树节点Id，根据id获取树节点进行勾选或取消勾选
                    var thisId = $(this).attr("id");
                    var strArr = thisId.split('_');
                    var nodeId = strArr[1];
                    if (strArr.length > 2) {
                        for (var i = 2; i < strArr.length; i++) {
                            nodeId = nodeId + "_" + strArr[i];
                        }
                    }

                    var node = $.fn.zTree.getZTreeObj(zTreeId).getNodeByParam("id", nodeId, null);
                    var dt = $(e.currentTarget).data();


                    // 取消勾选
                    if ($(this).hasClass("fav-card-checked")) {
                        if (node == null) {
                            //兼容 云资源检索
                            showOrHideResourceLayer(dt, false);
                            return;
                        }
                        $.fn.zTree.getZTreeObj(zTreeId).checkNode(node, false, true, true);
                    }
                    // 勾选
                    else {
                        if (node == null) {
                            //兼容 云资源检索
                            showOrHideResourceLayer(dt, true);
                            return;
                        }
                        $.fn.zTree.getZTreeObj(zTreeId).checkNode(node, true, true, true);
                        MapUtils.setMapView(dt.mapView);
                    }
                });

                // 点击收藏Tab页的取消收藏
                $(".fav-card-icon .cancel_fav").on("click", function (e) {
                    e.stopPropagation();
                    var thisId = $(this).attr("id");
                    $.each($that.collectNodes, function (i, node) {
                        // 隐藏被取消服务的信息卡片
                        if (node.name === $(".card-title-name").attr("title")) {
                            $(".card-triangle").hide("slow");
                            $('.datalist-card').hide("slow");
                        }

                        if (node.id === thisId) {
                            $that.collectNodes.splice(i, 1);
                            $("[favId=" + thisId + "]").addClass("icon-f-card-favourite1").removeClass("icon-f-tool-mark");
                            // $("#"+thisId).addClass("icon-f-card-favourite1").removeClass("icon-f-tool-mark");
                            return false;
                        }
                    });
                    $that._favCardContent();
                    // $(this).parent().parent().remove();
                    // $that._uploadFavCol();
                });
                /**
                 * 定位
                 */
                $(".fav-card-location").on("click", function (e) {
                    e.stopPropagation();
                    var thisId = $(this).attr("location_id");
                    $.each($that.collectNodes, function (i, node) {
                        if (node.id === thisId) {
                            node.mapView = MapUtils.getMapView();
                            return;
                        }
                    });
                    layer.msg("设置方位角成功！");
                    $that._favCardContent();
                });


            },

            /**
             * 同步fav到数据库
             * @private
             */
            _uploadFavCol: function () {

                //序列化collectNodes
                for (var i = 0; i < this.collectNodes.length; i++) {
                    var v = this.collectNodes[i];
                    var newNode = {};
                    if (v.resource == "search") {
                        continue;
                    } else {
                        newNode.data = v.data;
                        newNode.id = v.id || v.tId;
                        newNode.name = v.name;
                        newNode.imgUrl = v.imgUrl;
                        newNode.mapView = v.mapView;
                    }

                    this.collectNodes[i] = newNode;
                }
                var content = JSON.stringify(this.collectNodes);
                $.ajax({
                    url: rootPath + "/map/favs/set",
                    data: {content: content},
                    success: function () {
                        console.log("上传成功");
                    }
                });
            },

            /**
             * 初始化收藏列表
             * @private
             */
            _initFavCol: function () {
                $.ajax({
                    url: rootPath + "/map/favs/get",
                    success: function (e) {
                        var content;
                        if (e.data && e.data.content) {
                            content = e.data.content;
                        } else {
                            return;
                        }
                        var nodes = JSON.parse(content);
                        if (nodes instanceof Array) {
                            $that.collectNodes = nodes;
                        }
                        //兼容云资源绑定数据
                        $.each(nodes, function (i, obj) {
                            var id = obj.id;
                            $("#resourceCardCheckbox_" + id).data(obj);
                            $("[favId=" + id + "]").data(obj);
                        });
                        $that._favCardContent();
                    },
                    error: function (e) {
                        console.log(e);
                    }
                });
            },

            // info内容
            _createCardInfo: function (value, treeNode) {
                $('.datalist-card-info').empty();
                var infoHtml =
                    '<div class="card-info">' +
                    '    <blockquote class="layui-elem-quote">' + value.title + '</blockquote>' +
                    '    <div class="card-info-content">' + "<span>" + value.data.content + "</span>" +
                    '    </div>' +
                    '</div>';
                $('.datalist-card-info').append(infoHtml);
            },

            //Fly内容
            _createCardFly: function (value, treeNode) {
                $('.datalist-card-fly').empty();
                var flyHtml =
                    '<div class="card-fly">' + '<hr>' +
                    '    <blockquote class="layui-elem-quote">' + value.title + '</blockquote>' +
                    '    <div class="card-fly-content">' +
                    '    </div>' +
                    '</div>';
                $('.datalist-card-fly').append(flyHtml);

                var flyContent = '', flyRoutes = value.data.flyRoutes;
                $.each(flyRoutes, function (index, flyRoute) {
                    flyContent +=
                        '<div class="fly-list">' +
                        '<span class="fly-list-text">' + flyRoute.routeName +
                        '<i class="icon-fly-play icon-f-start-fly" id="playCtrlFlyRoute' + index + '" title="开始飞行"></i>' +
                        '<i class="icon-fly-stop icon-f-stop-fly" id="stopFlyRoute' + index + '" title="停止飞行"></i>' +
                        '</span>' +
                        '</div>';
                    var routes = new Cesium.RouteCollection();
                    routes.fromFile(flyRoute.fpfUrl);
                    flyRoutes[index].flyManager = new Cesium.FlyManager({
                        scene: MapUtils.getViewer().scene,
                        routes: routes
                    });
                });
                $(".card-fly-content").html(flyContent);


                $(".fly-list-text").on("mouseover", function () {
                    $(this).find('.icon-fly-play').show();
                });

                $(".fly-list-text").on("mouseout", function () {
                    $(this).find('.icon-fly-play').hide();
                });

                var playBtn = $(".icon-fly-play");
                var allStops;
                playBtn.on("click", function () {
                    var iconId = $(this).attr('id').match(/playCtrlFlyRoute(\S*)/)[1];
                    if (treeNode.isChecked) {
                        $(this).parent().find(".icon-fly-stop").show();
                        $(".fly-list-text").unbind("mouseover");
                        $(".fly-list-text").unbind("mouseout");

                        if ($(this).hasClass("icon-f-start-fly")) { // 播放
                            $(this).attr("title", "暂停飞行")
                                .removeClass("icon-f-start-fly")
                                .addClass("icon-f-pause-fly")
                                .css("color", "#2A80FF");

                            flyRoutes[iconId].flyManager.readyPromise.then(function () { // 飞行路线就绪
                                // 获取所有站点
                                allStops = flyRoutes[iconId].flyManager.getAllRouteStops();

                                flyRoutes[iconId].flyManager && flyRoutes[iconId].flyManager.play();
                            });

                        } else { // 暂停
                            $(this).attr("title", "开始飞行")
                                .removeClass("icon-f-pause-fly")
                                .addClass("icon-f-start-fly")
                                .css("color", "inherit");

                            flyRoutes[iconId].flyManager && flyRoutes[iconId].flyManager.pause();
                        }

                        // 停止飞行
                        $(".icon-fly-stop").on("click", function () {
                            flyRoutes[iconId].flyManager && flyRoutes[iconId].flyManager.stop();
                            // 停止后回到起点
                            var route = flyRoutes[iconId].flyManager.currentRoute;
                            var stop = route.get(0);
                            flyRoutes[iconId].flyManager.currentStopIndex = 0;
                            flyRoutes[iconId].flyManager.viewToStop(stop);
                            playBtn.attr("title", "开始飞行")
                                .removeClass("icon-f-pause-fly")
                                .addClass("icon-f-start-fly")
                                .css("color", "inherit");

                            // 隐藏播放图标，绑定鼠标移入移出事件
                            $(".fly-list-text").find("i").hide();
                            $(".fly-list-text").on("mouseover", function () {
                                $(this).find('.icon-fly-play').show();
                            });
                            $(".fly-list-text").on("mouseout", function () {
                                $(this).find('.icon-fly-play').hide();
                            });
                        });

                        // 注册站点到达事件
                        flyRoutes[iconId].flyManager.stopArrived.addEventListener(function (routeStop) {
                            // 到达最后一个站点停止
                            var lastStopIndex = allStops.length - 1; // 获取最后一个站点的索引
                            if (routeStop.index === lastStopIndex) {
                                if (playBtn.hasClass("icon-f-pause-fly")) {
                                    flyRoutes[iconId].flyManager && flyRoutes[iconId].flyManager.stop();
                                    playBtn.attr("title", "开始飞行")
                                        .removeClass("icon-f-pause-fly")
                                        .addClass("icon-f-start-fly")
                                        .css("color", "inherit");
                                }

                                // 隐藏播放图标，绑定鼠标移入移出事件
                                $(".fly-list-text").find("i").hide();
                                $(".fly-list-text").on("mouseover", function () {
                                    $(this).find('.icon-fly-play').show();
                                });
                                $(".fly-list-text").on("mouseout", function () {
                                    $(this).find('.icon-fly-play').hide();
                                });

                            }
                        });
                    } else {
                        layuiLayer.msg('请先勾选服务，再观看', {offset: '80px'});
                    }
                });
            },

            // Timeline内容
            _createCardTimeline: function (value, treeNode) {
                $('.datalist-card-timeline').empty();
                if (!treeNode.data.multiTime) {
                    var timelineHtml =
                        '<div class="card-timeline">' + '<hr>' +
                        '    <blockquote class="layui-elem-quote">' + value.title + '<i class="icon-f-start-fly" id="datalistPlayCtrl" title="播放"></i><i class="icon-f-stop-fly" id="datalistStopPlay" title="停止"></i></blockquote>' +
                        '    <div class="card-timeline-content">' +
                        '    </div>' +
                        '</div>';
                    $('.datalist-card-timeline').append(timelineHtml);
                } else {
                    var timelineHtml =
                        '<div class="card-timeline">' + '<hr>' +
                        '    <blockquote class="layui-elem-quote">' + value.title + '</blockquote>' +
                        '    <div class="card-timeline-content">' +
                        '    </div>' +
                        '</div>';
                    $('.datalist-card-timeline').append(timelineHtml);
                }
                var content = '';
                var timeList = value.data.timeList;
                var firstTimeInfoSpanId;
                $.each(timeList, function (i, year) {
                    if (value.data.hasOwnProperty('type') && value.data.type == "timeInfo") {
                        content += '<span id="' + treeNode.data.serviceId + i + '" class="' + i + '">' + year + '</span>';
                        if (i === 0) {
                            firstTimeInfoSpanId = treeNode.data.serviceId + i;
                        }
                    } else {
                        content += '<span id="' + treeNode.data.serviceIds[i] + '" class="' + i + '">' + year + '</span>';
                    }
                });

                $(".card-timeline-content").html(content);

                // 判断节点是否勾选，如果没有勾选，时间维标签全部不选中；如果勾选，选中对应的标签
                if (treeNode.isChecked) {
                    $(".card-timeline-content").children("span").each(function () {
                        if (value.data.hasOwnProperty('type') && value.data.type == "timeInfo") {
                            // 判断是否有记录选中的时间为标签，有则选中记录的标签，没有则选中最新时间，记录标签ID
                            if (treeNode.hasOwnProperty("clickedTimeSpanId")) {
                                $("#" + treeNode.clickedTimeSpanId).addClass('span-click-time');
                            } else {
                                $("#" + treeNode.firstTimeInfoSpanId).addClass('span-click-time');
                                treeNode.clickedTimeSpanId = firstTimeInfoSpanId;
                            }
                        } else {
                            if (!treeNode.data.multiTime) {
                                if ($(this).attr('id') === treeNode.capables[0].id) {
                                    $(this).addClass('span-click-time');
                                    // 记录点击的时间维标签的id
                                    treeNode.clickedTimeSpanId = $(this).attr('id');
                                }
                            } else {
                                var e = $(this);
                                $.each(treeNode.capables, function (i, capable) {
                                    if (e.attr('id') === capable.id) {
                                        e.addClass('span-click-time');
                                        // 记录点击的时间维标签的id
                                        if (!treeNode.hasOwnProperty('clickedTimeSpanId')) {
                                            treeNode.clickedTimeSpanId = {};
                                        }
                                        treeNode.clickedTimeSpanId[i] = e.attr('id');
                                    }
                                });
                            }
                        }
                    });
                }

                var viewer = MapUtils.getViewer();

                // 点击时间维标签
                // 判断点击的节点是否有imageryLayer，没有不作操作，有则移除layer并且添加选中标签的layer
                $(".card-timeline-content span").on('click', function (e) {
                    if (treeNode.isChecked) {
                        if (!treeNode.data.multiTime) {
                            $(".card-timeline-content span").removeClass('span-click-time');
                            $(this).addClass('span-click-time');
                            // 记录点击的时间维标签的id
                            treeNode.clickedTimeSpanId = $(this).attr('id');
                        } else {
                            if ($(this).hasClass('span-click-time')) {
                                $(this).removeClass('span-click-time');
                                delete treeNode.clickedTimeSpanId["t" + $(this).html()];
                            } else {
                                $(this).addClass('span-click-time');
                                if (treeNode.hasOwnProperty('clickedTimeSpanId')) {
                                    treeNode.clickedTimeSpanId["t" + $(this).html()] = $(this).attr('id');
                                } else {
                                    treeNode.clickedTimeSpanId = {};
                                    treeNode.clickedTimeSpanId["t" + $(this).html()] = $(this).attr('id');
                                }
                            }
                        }
                        if (value.data.hasOwnProperty('type') && value.data.type == "timeInfo") {
                            if (treeNode.isChecked) {
                                if (treeNode.hasOwnProperty('imageryLayer')) {
                                    var imageryLayer = treeNode.imageryLayer;
                                }
                                viewer.scene.imageryLayers.remove(_imageryLayer);
                                viewer.scene.imageryLayers.remove(imageryLayer, true);

                                // var fieldAttr = e.toElement.innerHTML;
                                var fieldAttr = e.target.innerHTML, timeInfo = null;

                                treeNode.capables[0].time = new Date(fieldAttr).getTime();
                                if (treeNode.capables[0].hasOwnProperty("layerCount")) {
                                    treeNode.capables[0].layers = treeNode.capables[0].layerCount;
                                }

                                var provider = MapUtils.createGlobalLayer(treeNode.capables[0]);
                                _imageryLayer = new Cesium.ImageryLayer(provider);
                                viewer.scene.imageryLayers.add(_imageryLayer);
                            }
                        } else {
                            if (!treeNode.data.multiTime) {
                                if (treeNode.hasOwnProperty('imageryLayer')) {
                                    $that._uncheckNode(treeNode, true);
                                    $that._checkNode(treeNode, true);
                                    $(this).addClass('span-click-time');
                                    treeNode.clickedTimeSpanId = $(this).attr('id');
                                }
                            } else {
                                if (treeNode.hasOwnProperty('imageryLayer')) {
                                    $that._uncheckNode(treeNode, true, true);
                                    // if ($(this).hasClass('span-click-time')) {
                                    //     $(this).removeClass('span-click-time');
                                    //     delete treeNode.clickedTimeSpanId["t" + $(this).html()]
                                    // } else {
                                    //     $(this).addClass('span-click-time');
                                    //     treeNode.clickedTimeSpanId["t" + $(this).html()] = $(this).attr('id');
                                    // }
                                    $that._checkNode(treeNode, true);
                                }
                            }
                        }
                    } else {
                        layuiLayer.msg('请先勾选服务', {offset: '80px'});
                    }
                });

                // 播放时间维
                treeNode.cardTimeLime = {
                    playSpanIndex: 0, // 记录播放到的标签的索引
                    playIntervalId: undefined,
                    playTimelineResetFlag: false // 记录是否是否重置（用于判断是否播放到了最后一个标签）
                };
                var playSpanIndex = treeNode.cardTimeLime.playSpanIndex,
                    playIntervalId = treeNode.cardTimeLime.playIntervalId,
                    playTimelineResetFlag = treeNode.cardTimeLime.playTimelineResetFlag;
                var spanList = [];

                $(".card-timeline-content").children("span").each(function () {
                    spanList.push($(this));
                });

                var playBtn = $("#datalistPlayCtrl");
                playBtn.off("click").on("click", function () {
                    if (treeNode.isChecked) {
                        playTimelineResetFlag = false;
                        if (playBtn.hasClass("icon-f-start-fly")) { // 播放
                            playBtn.attr("title", "暂停")
                                .removeClass("icon-f-start-fly")
                                .addClass("icon-f-pause-fly")
                                .css("color", "#2A80FF");

                            playIntervalId = setInterval(
                                function () {
                                    if (playSpanIndex === spanList.length) {
                                        stopPlayTimeline();
                                    }
                                    if (!playTimelineResetFlag) {
                                        $.each(spanList, function (i, val) {
                                            if (i === playSpanIndex) {
                                                val.trigger('click');
                                                playSpanIndex++;
                                                return false;
                                            }
                                        });
                                    }
                                }, 3000
                            );
                        } else { // 暂停
                            clearInterval(playIntervalId);
                            playBtn.attr("title", "播放")
                                .removeClass("icon-f-pause-fly")
                                .addClass("icon-f-start-fly")
                                .css("color", "inherit");
                        }
                    } else {
                        layuiLayer.msg('请先勾选服务', {offset: '80px'});
                    }
                });

                // 停止播放
                $("#datalistStopPlay").off("click").on("click", function () {
                    if (treeNode.isChecked && playBtn.hasClass("icon-f-pause-fly")) {
                        stopPlayTimeline();
                    }
                });

                function stopPlayTimeline() {
                    clearInterval(playIntervalId);
                    playBtn.attr("title", "播放")
                        .removeClass("icon-f-pause-fly")
                        .addClass("icon-f-start-fly")
                        .css("color", "inherit");
                    spanList[0].trigger('click');
                    playSpanIndex = 0;
                    playTimelineResetFlag = true;
                }
            },

            // attr内容
            _createCardAttr: function (treeNode, value, attrMulti) {
                if (!attrMulti) {
                    $(".datalist-card-attr").empty();
                }
                var attrHtml =
                    '<div class="card-attribute">' + '<hr>' +
                    '    <blockquote class="layui-elem-quote">' + value.title + '</blockquote>' +
                    '    <div class="card-attribute-content">' +
                    '    </div>' +
                    '</div>';
                $(".datalist-card-attr").append(attrHtml);

                var attrContent = '';

                if (value.data.hasOwnProperty("layers")) {
                    attrContent += '<div class="layui-collapse">';
                    $.each(value.data.layers, function (index, layer) {
                        attrContent +=
                            '    <div class="layui-colla-item">' +
                            '      <h2 class="layui-colla-title">' + layer.layerName + '</h2>' +
                            '      <div class="layui-colla-content layui-show">' +
                            '           <div class="layui-fluid">' +
                            '               <div class="layui-row">';
                        $.each(layer.values, function (i, value) {
                            if (value.length <= 5) {
                                attrContent +=
                                    '<div class="layui-col-md4">' +
                                    '     <span class="spanLayerId_' + layer.layerId + '" id="' + i + '_spanField_' + layer.field + '">' + value + '</span>' +
                                    '</div>';
                            } else if (value.length > 5) {
                                attrContent +=
                                    '<div class="layui-col-md12">' +
                                    '     <span class="spanLayerId_' + layer.layerId + '" id="' + i + '_spanField_' + layer.field + '">' + value + '</span>' +
                                    '</div>';
                            }
                        });
                        attrContent += '</div>' + '</div>' + '</div>' + '</div>';
                    });
                    attrContent += '</div>';

                    $(".card-attribute-content").html(attrContent);
                    layuiElement.render('collapse');
                    // 给已选中的属性维标签添加选中样式
                    if (treeNode.hasOwnProperty("clickedAttrSpan")) {
                        $("." + treeNode.clickedAttrSpan).addClass("span-click-attr");
                    }

                    var viewer = MapUtils.getViewer();

                    $(".card-attribute-content span").on('click', function (e, value) {
                        if (treeNode.isChecked) {
                            // 记录选中的属性维标签class
                            treeNode.clickedAttrSpan = $(this).attr("class");

                            if (treeNode.hasOwnProperty('imageryLayer')) {
                                var imageryLayer = treeNode.imageryLayer;
                            }
                            viewer.scene.imageryLayers.remove(_imageryLayer);
                            if (!treeNode.data.multiTime) {
                                viewer.scene.imageryLayers.remove(imageryLayer, true);

                                var fieldAttr = e.toElement.innerHTML,
                                    layerDefinitions = {},
                                    showLayerId = $(this).attr('class').match(/spanLayerId_(\S*)/)[1],
                                    field = $(this).attr('id').match(/_spanField_(\S*)/)[1];
                                if (fieldAttr === "所有") {
                                    treeNode.capables[0].layers = showLayerId;
                                } else {
                                    layerDefinitions[showLayerId] = field + "=" + "\'" + fieldAttr + "\'";
                                    treeNode.capables[0].layerDefs = JSON.stringify(layerDefinitions);
                                }

                                var provider = MapUtils.createGlobalLayer(treeNode.capables[0]);
                                _imageryLayer = new Cesium.ImageryLayer(provider);
                                viewer.scene.imageryLayers.add(_imageryLayer);
                                $(".card-attribute-content span").removeClass('span-click-attr');
                                $(this).addClass('span-click-attr');
                            } else {
                                $.each(imageryLayer, function (i, layer) {
                                    viewer.scene.imageryLayers.remove(layer, true);
                                });
                                var fieldAttr = e.toElement.innerHTML,
                                    layerDefinitions = {},
                                    showLayerId = $(this).attr('class').match(/spanLayerId_(\S*)/)[1],
                                    field = $(this).attr('id').match(/_spanField_(\S*)/)[1];
                                $.each(treeNode.capables, function (i, capable) {
                                    if (fieldAttr === "所有") {
                                        capable.layers = showLayerId;
                                    } else {
                                        layerDefinitions[showLayerId] = field + "=" + "\'" + fieldAttr + "\'";
                                        capable.layerDefs = JSON.stringify(layerDefinitions);
                                    }

                                    var provider = MapUtils.createGlobalLayer(capable);
                                    _imageryLayer = new Cesium.ImageryLayer(provider);
                                    viewer.scene.imageryLayers.add(_imageryLayer);
                                });
                                $(".card-attribute-content span").removeClass('span-click-attr');
                                $(this).addClass('span-click-attr');
                            }
                        } else {
                            layuiLayer.msg('请先勾选服务', {offset: '80px'});
                        }
                    });

                } else {
                    if (value.data.field == undefined) {
                        $.each(value.data, function (index, value) {
                            var field = value.field;
                            attrContent +=
                                '<div class="layui-fluid">' +
                                '    <div class="layui-row">';
                            $.each(value.values, function (index, value) {
                                if (value.length <= 5) {
                                    attrContent +=
                                        '<div class="layui-col-md4">' +
                                        '    <span id="attrSpan' + index + '">' + value + '</span>' +
                                        '</div>';
                                } else if (value.length > 5) {
                                    attrContent +=
                                        '<div class="layui-col-md12">' +
                                        '    <span id="attrSpan' + index + '">' + value + '</span>' +
                                        '</div>';
                                }
                            });
                            attrContent +=
                                '</div>' +
                                '</div>';
                            $(".card-attribute-content").html(attrContent);

                            // 给已选中的属性维标签添加选中样式
                            if (treeNode.hasOwnProperty("clickedAttrSpan")) {
                                $("#" + treeNode.clickedAttrSpan).addClass("span-click-attr");
                            }

                            var viewer = MapUtils.getViewer();

                            $(".card-attribute-content span").on('click', function (e, value) {
                                if (treeNode.isChecked) {
                                    // 记录选中的的属性维
                                    treeNode.clickedAttrSpan = $(this).attr("id");

                                    if (treeNode.hasOwnProperty('imageryLayer')) {
                                        var imageryLayer = treeNode.imageryLayer;
                                    }
                                    viewer.scene.imageryLayers.remove(_imageryLayer);
                                    if (!treeNode.data.multiTime) {
                                        viewer.scene.imageryLayers.remove(imageryLayer, true);

                                        var layerCount = [];
                                        if (treeNode.capables[0].hasOwnProperty("layerCount")) {
                                            layerCount = treeNode.capables[0].layerCount.split(',');
                                        }

                                        var fieldAttr = e.toElement.innerHTML, layerDefinitions = "";
                                        if (fieldAttr !== "所有") {
                                            if (layerCount.length > 0) {
                                                layerCount.forEach(function (result) {
                                                    layerDefinitions += ",\"" + result + "\":\"" + field + "=" + "\'" + fieldAttr + "\'\"";
                                                });
                                                layerDefinitions = layerDefinitions.substring(1, layerDefinitions.length);
                                                layerDefinitions = "{" + layerDefinitions + "}";
                                            } else {
                                                layerDefinitions = {"0": field + "=" + "\'" + fieldAttr + "\'"};
                                            }
                                        }
                                        treeNode.capables[0].layerDefs = layerDefinitions;
                                        // treeNode.capables[0].layerDefs = JSON.stringify(layerDefinitions);

                                        var provider = MapUtils.createGlobalLayer(treeNode.capables[0]);
                                        _imageryLayer = new Cesium.ImageryLayer(provider);
                                        viewer.scene.imageryLayers.add(_imageryLayer);
                                        $(".card-attribute-content span").removeClass('span-click-attr');
                                        $(this).addClass('span-click-attr');
                                    } else {
                                        $.each(imageryLayer, function (i, layer) {
                                            viewer.scene.imageryLayers.remove(layer, true);
                                        });
                                        $.each(treeNode.capables, function (i, capable) {
                                            var layerCount = [];
                                            if (capable.hasOwnProperty("layerCount")) {
                                                layerCount = capable.layerCount.split(',');
                                            }

                                            var fieldAttr = e.toElement.innerHTML, layerDefinitions = "";
                                            if (fieldAttr !== "所有") {
                                                if (layerCount.length > 0) {
                                                    layerCount.forEach(function (result) {
                                                        layerDefinitions += ",\"" + result + "\":\"" + field + "=" + "\'" + fieldAttr + "\'\"";
                                                    });
                                                    layerDefinitions = layerDefinitions.substring(1, layerDefinitions.length);
                                                    layerDefinitions = "{" + layerDefinitions + "}";
                                                } else {
                                                    layerDefinitions = {"0": field + "=" + "\'" + fieldAttr + "\'"};
                                                }
                                            }
                                            capable.layerDefs = layerDefinitions;
                                            // treeNode.capables[0].layerDefs = JSON.stringify(layerDefinitions);

                                            var provider = MapUtils.createGlobalLayer(capable);
                                            _imageryLayer = new Cesium.ImageryLayer(provider);
                                            viewer.scene.imageryLayers.add(_imageryLayer);
                                        });
                                        $(".card-attribute-content span").removeClass('span-click-attr');
                                        $(this).addClass('span-click-attr');
                                    }
                                } else {
                                    layuiLayer.msg('请先勾选服务', {offset: '80px'});
                                }
                            });
                        })
                    } else {
                        var field = value.data.field;
                        attrContent +=
                            '<div class="layui-fluid">' +
                            '    <div class="layui-row">';
                        $.each(value.data.values, function (index, value) {
                            if (value.length <= 5) {
                                attrContent +=
                                    '<div class="layui-col-md4">' +
                                    '    <span id="attrSpan' + index + '">' + value + '</span>' +
                                    '</div>';
                            } else if (value.length > 5) {
                                attrContent +=
                                    '<div class="layui-col-md12">' +
                                    '    <span id="attrSpan' + index + '">' + value + '</span>' +
                                    '</div>';
                            }
                        });
                        attrContent +=
                            '</div>' +
                            '</div>';
                        $(".card-attribute-content").html(attrContent);

                        // 给已选中的属性维标签添加选中样式
                        if (treeNode.hasOwnProperty("clickedAttrSpan")) {
                            $("#" + treeNode.clickedAttrSpan).addClass("span-click-attr");
                        }

                        var viewer = MapUtils.getViewer();

                        $(".card-attribute-content span").on('click', function (e, value) {
                            if (treeNode.isChecked) {
                                // 记录选中的的属性维
                                treeNode.clickedAttrSpan = $(this).attr("id");

                                if (treeNode.hasOwnProperty('imageryLayer')) {
                                    var imageryLayer = treeNode.imageryLayer;
                                }
                                viewer.scene.imageryLayers.remove(_imageryLayer);
                                if (!treeNode.data.multiTime) {
                                    viewer.scene.imageryLayers.remove(imageryLayer, true);


                                    var layerCount = [];
                                    if (treeNode.capables[0].hasOwnProperty("layerCount")) {
                                        layerCount = treeNode.capables[0].layerCount.split(',');
                                    }

                                    var fieldAttr = e.toElement.innerHTML, layerDefinitions = "";
                                    if (fieldAttr !== "所有") {
                                        if (layerCount.length > 0) {
                                            layerCount.forEach(function (result) {
                                                layerDefinitions += ",\"" + result + "\":\"" + field + "=" + "\'" + fieldAttr + "\'\"";
                                            });
                                            layerDefinitions = layerDefinitions.substring(1, layerDefinitions.length);
                                            layerDefinitions = "{" + layerDefinitions + "}";
                                        } else {
                                            layerDefinitions = JSON.stringify({"0": field + "=" + "\'" + fieldAttr + "\'"});
                                        }
                                    }
                                    treeNode.capables[0].layerDefs = layerDefinitions;
                                    //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                                    // var fieldAttr = e.toElement.innerHTML, layerDefinitions = null;
                                    // if (fieldAttr !== "所有") {
                                    //     layerDefinitions = {"0": field + "=" + "\'" + fieldAttr + "\'"};
                                    // }
                                    // treeNode.capables[0].layerDefs = JSON.stringify(layerDefinitions);

                                    var provider = MapUtils.createGlobalLayer(treeNode.capables[0]);
                                    _imageryLayer = new Cesium.ImageryLayer(provider);
                                    viewer.scene.imageryLayers.add(_imageryLayer);
                                    $(".card-attribute-content span").removeClass('span-click-attr');
                                    $(this).addClass('span-click-attr');
                                } else {
                                    $.each(imageryLayer, function (i, layer) {
                                        viewer.scene.imageryLayers.remove(layer, true);
                                    });
                                    $.each(treeNode.capables, function (i, capable) {
                                        var layerCount = [];
                                        if (capable.hasOwnProperty("layerCount")) {
                                            layerCount = capable.layerCount.split(',');
                                        }

                                        var fieldAttr = e.toElement.innerHTML, layerDefinitions = "";
                                        if (fieldAttr !== "所有") {
                                            if (layerCount.length > 0) {
                                                layerCount.forEach(function (result) {
                                                    layerDefinitions += ",\"" + result + "\":\"" + field + "=" + "\'" + fieldAttr + "\'\"";
                                                });
                                                layerDefinitions = layerDefinitions.substring(1, layerDefinitions.length);
                                                layerDefinitions = "{" + layerDefinitions + "}";
                                            } else {
                                                layerDefinitions = JSON.stringify({"0": field + "=" + "\'" + fieldAttr + "\'"});
                                            }
                                        }
                                        capable.layerDefs = layerDefinitions;
                                        //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                                        // var fieldAttr = e.toElement.innerHTML, layerDefinitions = null;
                                        // if (fieldAttr !== "所有") {
                                        //     layerDefinitions = {"0": field + "=" + "\'" + fieldAttr + "\'"};
                                        // }
                                        // treeNode.capables[0].layerDefs = JSON.stringify(layerDefinitions);

                                        var provider = MapUtils.createGlobalLayer(capable);
                                        _imageryLayer = new Cesium.ImageryLayer(provider);
                                        viewer.scene.imageryLayers.add(_imageryLayer);
                                    });

                                    $(".card-attribute-content span").removeClass('span-click-attr');
                                    $(this).addClass('span-click-attr');
                                }
                            } else {
                                layuiLayer.msg('请先勾选服务', {offset: '80px'});
                            }
                        });
                    }

                }
            },

            // legend内容
            _createCardLegend: function (value) {
                $('.datalist-card-legend').empty();
                var legendHtml =
                    '<div class="card-legend">' + '<hr>' +
                    '    <blockquote class="layui-elem-quote">' + value.title + '</blockquote>' +
                    '    <div class="card-legend-content">' +
                    '        <div id="legendBox"></div>' +
                    '    </div>' +
                    '</div>';
                $('.datalist-card-legend').append(legendHtml);
                var content = '';
                $.ajax({
                    async: false,
                    url: value.data.url + '/legend',
                    type: 'get',
                    dataType: 'jsonp',
                    data: {f: 'pjson'},
                    success: function (data) {
                        $.each(data.layers, function (i, layer) {
                            layer.legend.forEach(function (v) {
                                var legend = {
                                    label: v.label,
                                    icon: value.data.url + '/' + layer.layerId + '/images/' + v.url
                                };
                                if (legend.label === '' || legend.label === null || legend.label === undefined) {
                                    legend.label = layer.layerName;
                                }
                                content +=
                                    '<div class="layui-row">' +
                                    '    <div class="layui-col-xs12">' +
                                    '      <p><img src = "' + legend.icon + '">' + '&nbsp' + '&nbsp' + legend.label + '</p>' +
                                    '    </div>' +
                                    '  </div>';
                            });
                        });
                        $('#legendBox').html(content);
                        cardHeight.h = $(".datalist-card").height();
                    }
                });
            },

            // symbol符号化方案内容
            _createCardSymbol: function (treeNode, value) {
                $('.datalist-card-symbol').empty();
                var symbolHtml =
                    '<div class="card-symbol">' + '<hr>' +
                    '    <blockquote class="layui-elem-quote">' + value.title + '</blockquote>' +
                    '    <div class="card-symbol-content">' +
                    '    </div>' +
                    '</div>';
                $('.datalist-card-symbol').append(symbolHtml);

                var content = '';
                var symbolicSchemes = value.data.symbolicSchemes;
                var firstSymbolicSchemeSpanId;
                $.each(symbolicSchemes, function (i, symbolicScheme) {
                    if (i === 0) {
                        firstSymbolicSchemeSpanId = symbolicScheme.name;
                        treeNode.firstSymbolicSchemeSpanId = firstSymbolicSchemeSpanId;
                    }
                    content += '<span id="' + symbolicScheme.name + '" class="' + i + '">' + symbolicScheme.alias + '</span>';
                });

                $(".card-symbol-content").html(content);

                // 判断节点是否勾选，如果没有勾选，标签全部不选中；如果勾选，选中对应的标签
                if (treeNode.isChecked) {
                    $(".card-symbol-content").children("span").each(function () {
                        // 判断是否有记录选中的标签，有则选中记录的标签，没有则选中第一个符号化方案，记录标签ID
                        if (treeNode.hasOwnProperty("clickedSymbolSpanId")) {
                            $("#" + treeNode.clickedSymbolSpanId).addClass('span-click-symbol');
                        } else {
                            $("#" + treeNode.firstSymbolicSchemeSpanId).addClass('span-click-symbol');
                            treeNode.clickedSymbolSpanId = firstSymbolicSchemeSpanId;
                        }
                    });
                }

                // 点击符号化方案标签
                $(".card-symbol-content span").on('click', function (e) {
                    if (treeNode.isChecked) {
                        $(".card-symbol-content span").removeClass('span-click-symbol');
                        $that._uncheckNode(treeNode, true);
                        treeNode.clickedSymbolSpanId = $(this).attr('id');
                        $that._checkNode(treeNode, true);
                        $(this).addClass('span-click-symbol');

                    } else {
                        layuiLayer.msg('请先勾选服务', {offset: '80px'});
                    }
                });

            },

            _createCardCoastline: function (treeNode, value) {
                $('.datalist-card-coastline').empty();
                var coastlineHtml =
                    '<div class="card-coastline">' + '<hr>' +
                    '   <blockquote class="layui-elem-quote">' + value.title + '</blockquote>' +
                    '   <div class="card-coastline-content layui-btn-container">' +
                    '       <button type="button" class="layui-btn layui-btn-sm" id="coastline-general" data-type="' + value.data.type + '">总体概况</button>' +
                    '       <button type="button" class="layui-btn layui-btn-sm" id="coastline-contrast" data-type="' + value.data.type + '">变化监测</button>' +
                    '   </div>' +
                    '</div>';
                $('.datalist-card-coastline').append(coastlineHtml);
                $('#coastline-general').off('click').on('click', function () {
                    if (treeNode.isChecked) {
                        var keys = Object.keys(treeNode.clickedTimeSpanId);
                        if (keys.length === 1) {
                            var capable = treeNode.capables[keys[0]];
                            switch ($(this).attr("data-type")) {
                                case "had":
                                    var ajaxPromise = [];
                                    ajaxPromise.push($.ajax({
                                        url: capable.url + "/0/query",
                                        data: {
                                            where: "1=1",
                                            outFields: "gb,type,name,area",
                                            returnGeometry: false,
                                            orderByFields: "gb",
                                            f: "pjson"
                                        },
                                        dataType: "json"
                                    }));
                                    Promise.all(ajaxPromise).then((result) => {
                                        if (result[0].hasOwnProperty("features")) {
                                            var data = [], tmpdata = [], chartData = [];
                                            var area = 0, tmparea = 0, tmpgc = "";
                                            var gcList = {
                                                "01": "种植土地",
                                                "03": "林草覆盖",
                                                "05": "房屋建筑（区）",
                                                "06": "道路",
                                                "07": "构筑物",
                                                "08": "人工堆掘地",
                                                "09": "荒漠与裸露地",
                                                "10": "水域"
                                            };
                                            $.each(result[0].features, function (i, feature) {
                                                var d = feature.attributes;
                                                if (tmpgc !== d.GB.substr(0, 2)) {
                                                    if (tmpdata.length > 0) {
                                                        tmpdata[0].area = tmparea.toFixed(2);
                                                        $.each(tmpdata, function (i, dd) {
                                                            data.push(dd);
                                                        });
                                                        tmpdata = [];
                                                        tmparea = 0;
                                                    }
                                                    tmpgc = d.GB.substr(0, 2);
                                                    if (d.TYPE.includes("一级")) {
                                                        var dd = {
                                                            type: gcList[d.GB.substr(0, 2)],
                                                            area: d.AREA.toFixed(2)
                                                        };
                                                        tmpdata.push(dd);
                                                        tmparea += d.AREA;
                                                    } else {
                                                        tmpdata.push({
                                                            type: gcList[d.GB.substr(0, 2)]
                                                        });
                                                        tmpdata.push({
                                                            stype: d.NAME,
                                                            area: d.AREA.toFixed(2)
                                                        });
                                                        tmparea += d.AREA;
                                                    }
                                                } else {
                                                    tmpdata.push({
                                                        stype: d.NAME,
                                                        area: d.AREA.toFixed(2)
                                                    });
                                                    tmparea += d.AREA;
                                                }
                                                area += d.AREA;
                                            });
                                            if (tmpdata.length > 0) {
                                                tmpdata[0].area = tmparea.toFixed(2);
                                                $.each(tmpdata, function (i, dd) {
                                                    data.push(dd);
                                                });
                                                delete tmpdata;
                                                delete tmparea;
                                            }
                                            $.each(data, function (i, d) {
                                                d.rate = (d.area / area * 100).toFixed(2) + "%";
                                                if (d.hasOwnProperty("type")) {
                                                    chartData.push({
                                                        value: d.area,
                                                        name: d.type
                                                    });
                                                }
                                            });
                                            $("#coastlineTableTitle").html("海岸带地表覆盖类型面积和占比统计表");
                                            coastlineTable.reload({
                                                title: "海岸带地表覆盖类型面积和占比统计表",
                                                data: data,
                                                limit: Number.MAX_SAFE_INTEGER,
                                                cols: [[
                                                    {title: '一级类', field: 'type', align: 'center'},
                                                    {title: '二级类', field: 'stype', align: 'center'},
                                                    {title: '面积', field: 'area', align: 'center'},
                                                    {title: '占比', field: 'rate', align: 'center'}
                                                ]]
                                            });
                                            var option0 = {
                                                title: {
                                                    text: '海岸带地表覆盖面积占比统计图',
                                                    left: 'center'
                                                },
                                                tooltip: {
                                                    trigger: 'item',
                                                    formatter: '{b} : {d}%'
                                                },
                                                legend: {
                                                    orient: 'vertical',
                                                    left: '30',
                                                    top: " 30"
                                                },
                                                series: [
                                                    {
                                                        name: '地表覆盖面积',
                                                        type: 'pie',
                                                        radius: '60%',
                                                        center: ['60%', '60%'],
                                                        data: chartData
                                                    }
                                                ]
                                            };
                                            coastlineLayer = layuiLayer.open({
                                                type: 1,
                                                title: "总体概况",
                                                shadeClose: true,
                                                area: ["1500px", "800px"],
                                                content: $("#coastlineForm"),
                                                resize: false,
                                                success: function () {
                                                    coastlineTable.resize();
                                                    $('#coastlineChart0').show();
                                                    $that.coastlineCharts["chart0"] = echarts.init(document.getElementById("coastlineChart0"));
                                                    if (option0 && typeof option0 === "object") {
                                                        $that.coastlineCharts["chart0"].setOption(option0, true);
                                                    }
                                                },
                                                end: function () {
                                                    $('.coastlineChart').hide();
                                                    $.each($that.coastlineCharts, function (i, chart) {
                                                        echarts.dispose(chart);
                                                    });
                                                    $that.coastlineCharts = {};
                                                }
                                            });
                                        } else {
                                            layuiLayer.msg('加载失败', {offset: '80px'});
                                            return;
                                        }
                                    }).catch((err) => {
                                        layuiLayer.msg('加载失败', {offset: '80px'});
                                    });
                                    break;
                                case "hax":
                                    var ajaxPromise = [];
                                    ajaxPromise.push($.ajax({
                                        url: capable.url + "/0/query",
                                        data: {
                                            where: "1=1",
                                            returnGeometry: false,
                                            orderByFields: "type_id asc,stype_id asc",
                                            groupByFieldsForStatistics: "type,type_id,stype,stype_id",
                                            outStatistics: JSON.stringify([{
                                                "statisticType": "sum",
                                                "onStatisticField": "length",
                                                "outStatisticFieldName": "length"
                                            }]),
                                            f: "pjson"
                                        },
                                        dataType: "json"
                                    }));
                                    ajaxPromise.push($.ajax({
                                        url: capable.url + "/0/query",
                                        data: {
                                            where: "1=1",
                                            returnGeometry: false,
                                            orderByFields: "city asc,type_id asc",
                                            groupByFieldsForStatistics: "city,type,type_id",
                                            outStatistics: JSON.stringify([{
                                                "statisticType": "sum",
                                                "onStatisticField": "length",
                                                "outStatisticFieldName": "length"
                                            }]),
                                            f: "pjson"
                                        },
                                        dataType: "json"
                                    }));
                                    Promise.all(ajaxPromise).then((result) => {
                                        var option0, option1;
                                        if (result[0].hasOwnProperty("features")) {
                                            var data = [], tmpdata = [], length = 0, tmplength = 0, tmpid = "";
                                            $.each(result[0].features, function (i, feature) {
                                                var d = feature.attributes;
                                                d.length /= 1000.0;
                                                if (tmpid !== d.type_id) {
                                                    if (tmpdata.length > 0) {
                                                        if (tmpdata.length > 1) {
                                                            data.push({
                                                                type: tmpdata[0].type,
                                                                length: tmplength.toFixed(2),
                                                                rate: "100%"
                                                            });
                                                            $.each(tmpdata, function (i, d) {
                                                                data.push({
                                                                    stype: d.stype,
                                                                    length: d.length.toFixed(2),
                                                                    rate: (d.length / tmplength * 100).toFixed(2) + "%"
                                                                })
                                                            });
                                                        } else {
                                                            data.push({
                                                                type: tmpdata[0].type,
                                                                stype: tmpdata[0].stype,
                                                                length: tmplength.toFixed(2),
                                                                rate: "100%"
                                                            });
                                                        }
                                                        tmpdata = [];
                                                        tmplength = 0;
                                                    }
                                                    tmpid = d.type_id;
                                                    length += d.length;
                                                    tmplength += d.length;
                                                    tmpdata.push(d);
                                                } else {
                                                    length += d.length;
                                                    tmplength += d.length;
                                                    tmpdata.push(d);
                                                }
                                            });
                                            if (tmpdata.length > 0) {
                                                if (tmpdata.length > 1) {
                                                    data.push({
                                                        type: tmpdata[0].type,
                                                        length: tmplength.toFixed(2),
                                                        rate: "100%"
                                                    });
                                                    $.each(tmpdata, function (i, d) {
                                                        data.push({
                                                            stype: d.stype,
                                                            length: d.length.toFixed(2),
                                                            rate: (d.length / tmplength * 100).toFixed(2) + "%"
                                                        })
                                                    });
                                                } else {
                                                    data.push({
                                                        type: tmpdata[0].type,
                                                        stype: tmpdata[0].stype,
                                                        length: tmplength.toFixed(2),
                                                        rate: "100%"
                                                    });
                                                }
                                                delete tmpdata;
                                                delete tmplength;
                                            }
                                            if (data.length > 0) {
                                                $.each(data, function (i, d) {
                                                    d.totalrate = (d.length / length * 100).toFixed(2) + "%"
                                                });
                                            }
                                            $("#coastlineTableTitle").html("海陆分界线分类型统计表");
                                            coastlineTable.reload({
                                                title: "海陆分界线分类型统计表",
                                                data: data,
                                                cols: [[
                                                    {title: '一级类', field: 'type', align: 'center'},
                                                    {title: '二级类', field: 'stype', align: 'center'},
                                                    {title: '长度', field: 'length', align: 'center'},
                                                    {title: '占所属一级类的比例', field: 'rate', align: 'center'},
                                                    {title: '总占比', field: 'totalrate', align: 'center'}
                                                ]],
                                                limit: Number.MAX_SAFE_INTEGER
                                            });
                                        } else {
                                            layuiLayer.msg('加载失败', {offset: '80px'});
                                            return;
                                        }
                                        if (result[1].hasOwnProperty("features")) {
                                            var data = [], tmpcity = "", tmpdata = undefined, tmplength = 0, length = 0;
                                            data.push(["城市", "自然边界线", "人工边界线", "河口边界线", "补充边界线", "总长"]);
                                            $.each(result[1].features, function (i, feature) {
                                                var d = feature.attributes;
                                                d.length /= 1000.0;
                                                if (tmpcity !== d.city) {
                                                    if (tmpdata) {
                                                        tmpdata[5] = tmplength.toFixed(0);
                                                        tmplength = 0;
                                                        data.push(tmpdata);
                                                    }
                                                    tmpcity = d.city;
                                                    tmpdata = new Array(6);
                                                    tmpdata[0] = d.city;
                                                }
                                                switch (d.type) {
                                                    case "自然边界线":
                                                        tmpdata[1] = d.length.toFixed(0);
                                                        break;
                                                    case "人工边界线":
                                                        tmpdata[2] = d.length.toFixed(0);
                                                        break;
                                                    case "河口边界线":
                                                        tmpdata[3] = d.length.toFixed(0);
                                                        break;
                                                    case "补充边界线":
                                                        tmpdata[4] = d.length.toFixed(0);
                                                        break;
                                                    default:
                                                        break;
                                                }
                                                tmplength += d.length;
                                                length += d.length;
                                            });
                                            if (tmpdata) {
                                                tmpdata[5] = tmplength.toFixed(0);
                                                tmplength = 0;
                                                data.push(tmpdata);
                                            }
                                            option0 = {
                                                title: {text: "海陆分界线长度统计图", show: true, left: "center", top: 0},
                                                legend: {
                                                    left: "center",
                                                    top: 30
                                                },
                                                tooltip: {},
                                                dataset: {
                                                    source: data
                                                },
                                                xAxis: {type: 'category'},
                                                yAxis: {},
                                                // Declare several bar series, each will be mapped
                                                // to a column of dataset.source by default.
                                                series: [
                                                    {type: 'bar'},
                                                    {type: 'bar'},
                                                    {type: 'bar'},
                                                    {type: 'bar'},
                                                    {type: 'bar'}
                                                ]
                                            };
                                            var d1 = [], d2 = [];
                                            $.each(data.slice(1), function (i, d) {
                                                d1.push(d[0]);
                                                d2.push((d[1] / d[5]).toFixed(2));
                                            });
                                            option1 = {
                                                title: {
                                                    text: '自然边界线比例统计图',
                                                    left: "center",
                                                    top: "0"
                                                },
                                                tooltip: {},
                                                legend: {},
                                                xAxis: {},
                                                yAxis: {
                                                    type: 'category',
                                                    data: d1
                                                },
                                                series: [
                                                    {
                                                        type: 'bar',
                                                        data: d2
                                                    }
                                                ]
                                            };

                                        } else {
                                            layuiLayer.msg('加载失败', {offset: '80px'});
                                            return;
                                        }
                                        coastlineLayer = layuiLayer.open({
                                            type: 1,
                                            title: "总体概况",
                                            shadeClose: true,
                                            area: ["1500px", "800px"],
                                            content: $("#coastlineForm"),
                                            resize: false,
                                            success: function () {
                                                coastlineTable.resize();
                                                $('#coastlineChart0').show();
                                                $('#coastlineChart1').show();
                                                $that.coastlineCharts["chart0"] = echarts.init(document.getElementById("coastlineChart0"));
                                                $that.coastlineCharts["chart1"] = echarts.init(document.getElementById("coastlineChart1"));
                                                if (option0 && typeof option0 === "object") {
                                                    $that.coastlineCharts["chart0"].setOption(option0, true);
                                                }
                                                if (option1 && typeof option1 === "object") {
                                                    $that.coastlineCharts["chart1"].setOption(option1, true);
                                                }
                                            },
                                            end: function () {
                                                $('.coastlineChart').hide();
                                                $.each($that.coastlineCharts, function (i, chart) {
                                                    echarts.dispose(chart);
                                                });
                                                $that.coastlineCharts = {};
                                            }
                                        });
                                    }).catch((err) => {
                                        layuiLayer.msg('加载失败', {offset: '80px'});
                                    });
                                    break;
                                case "wth":
                                    var ajaxPromise = [];
                                    ajaxPromise.push($.ajax({
                                        url: capable.url + "/0/query",
                                        data: {
                                            where: "1=1",
                                            returnGeometry: false,
                                            orderByFields: "jtyt asc",
                                            groupByFieldsForStatistics: "jtyt",
                                            outStatistics: JSON.stringify([{
                                                "statisticType": "sum",
                                                "onStatisticField": "area",
                                                "outStatisticFieldName": "area"
                                            }]),
                                            f: "pjson"
                                        },
                                        dataType: "json"
                                    }));
                                    Promise.all(ajaxPromise).then((result) => {
                                        if (result[0].hasOwnProperty("features")) {
                                            var chart1Data1 = [], chart1Data2 = [], chart2Data = [], tmpArea = 0;
                                            $.each(result[0].features, function (i, feature) {
                                                var d = feature.attributes;
                                                chart1Data1.push(d.jtyt);
                                                chart1Data2.push(d.area.toFixed(2));
                                                chart2Data.push({
                                                    usage: d.jtyt,
                                                    area: d.area.toFixed(2)
                                                });
                                                tmpArea += d.area;
                                            });
                                            if (chart2Data.length > 0) {
                                                $.each(chart2Data, function (i, d) {
                                                    d.rate = (d.area / tmpArea * 100).toFixed(2) + "%"
                                                });
                                            }
                                            var option0 = {
                                                title: {
                                                    text: '围填海用地类型面积图',
                                                    top: '0',
                                                    left: 'center'
                                                },
                                                tooltip: {
                                                    trigger: 'axis',
                                                    axisPointer: {
                                                        type: 'shadow'
                                                    }
                                                },
                                                legend: {
                                                    top: '8%'
                                                },
                                                grid: {
                                                    top: '16%'
                                                },
                                                xAxis: {
                                                    type: 'category',
                                                    data: chart1Data1
                                                },
                                                yAxis: {
                                                    type: 'value'
                                                },
                                                series: [
                                                    {
                                                        type: 'bar',
                                                        data: chart1Data2
                                                    }
                                                ]
                                            };
                                            $("#coastlineTableTitle").html("围填海用地类型面积统计表");
                                            coastlineTable.reload({
                                                title: "围填海用地类型面积统计表",
                                                data: chart2Data,
                                                cols: [[
                                                    {title: '分类', field: 'usage', align: 'center'},
                                                    {title: '面积', field: 'area', align: 'center'},
                                                    {title: '占比', field: 'rate', align: 'center'}
                                                ]],
                                                limit: Number.MAX_SAFE_INTEGER
                                            });
                                            coastlineLayer = layuiLayer.open({
                                                type: 1,
                                                title: "总体概况",
                                                shadeClose: true,
                                                area: ["1500px", "800px"],
                                                content: $("#coastlineForm"),
                                                resize: false,
                                                success: function () {
                                                    coastlineTable.resize();
                                                    $('#coastlineChart0').show();
                                                    $that.coastlineCharts["chart0"] = echarts.init(document.getElementById("coastlineChart0"));
                                                    if (option0 && typeof option0 === "object") {
                                                        $that.coastlineCharts["chart0"].setOption(option0, true);
                                                    }
                                                },
                                                end: function () {
                                                    $('.coastlineChart').hide();
                                                    $.each($that.coastlineCharts, function (i, chart) {
                                                        echarts.dispose(chart);
                                                    });
                                                    $that.coastlineCharts = {};
                                                }
                                            });
                                        } else {
                                            layuiLayer.msg('加载失败', {offset: '80px'});
                                            return;
                                        }
                                    }).catch((err) => {
                                        layuiLayer.msg('加载失败', {offset: '80px'});
                                    });
                                    break;
                                default:
                                    break;
                            }
                        } else {
                            layuiLayer.msg('请仅勾选一个年份', {offset: '80px'});
                        }
                    } else {
                        layuiLayer.msg('请先勾选服务', {offset: '80px'});
                    }
                });
                $('#coastline-contrast').off('click').on('click', function () {
                    if (treeNode.isChecked) {
                        var keys = Object.keys(treeNode.clickedTimeSpanId);
                        if (keys.length === 2) {
                            switch ($(this).attr("data-type")) {
                                case "had":
                                    var ajaxPromise = [], years = [];
                                    ajaxPromise.push($.ajax({
                                        url: treeNode.capables[keys[0]].url + "/0/query",
                                        data: {
                                            where: "1=1",
                                            outFields: "gb,type,name,area",
                                            returnGeometry: false,
                                            orderByFields: "gb",
                                            f: "pjson"
                                        },
                                        dataType: "json"
                                    }));
                                    if (parseInt(keys[0].substr(1)) > parseInt(keys[1].substr(1))) {
                                        years.push(parseInt(keys[0].substr(1)));
                                        years.push(parseInt(keys[1].substr(1)));
                                        ajaxPromise.push($.ajax({
                                            url: treeNode.capables[keys[1]].url + "/0/query",
                                            data: {
                                                where: "1=1",
                                                outFields: "gb,type,name,area",
                                                returnGeometry: false,
                                                orderByFields: "gb",
                                                f: "pjson"
                                            },
                                            dataType: "json"
                                        }));
                                    } else {
                                        years.push(parseInt(keys[1].substr(1)));
                                        years.push(parseInt(keys[0].substr(1)));
                                        ajaxPromise.unshift($.ajax({
                                            url: treeNode.capables[keys[1]].url + "/0/query",
                                            data: {
                                                where: "1=1",
                                                outFields: "gb,type,name,area",
                                                returnGeometry: false,
                                                orderByFields: "gb",
                                                f: "pjson"
                                            },
                                            dataType: "json"
                                        }));
                                    }
                                    Promise.all(ajaxPromise).then((result) => {
                                        var data1 = [], data2 = [], data3 = [], data4 = [];
                                        var gcList = {
                                            "01": "种植土地",
                                            "03": "林草覆盖",
                                            "05": "房屋建筑（区）",
                                            "06": "道路",
                                            "07": "构筑物",
                                            "08": "人工堆掘地",
                                            "09": "荒漠与裸露地",
                                            "10": "水域"
                                        };
                                        if (result[0].hasOwnProperty("features")) {
                                            var tmpdata = [];
                                            var tmparea = 0, tmpgc = "";
                                            $.each(result[0].features, function (i, feature) {
                                                var d = feature.attributes;
                                                if (tmpgc !== d.GB.substr(0, 2)) {
                                                    if (tmpdata.length > 0) {
                                                        tmpdata[0].area = tmparea.toFixed(2);
                                                        $.each(tmpdata, function (i, dd) {
                                                            data3.push(dd);
                                                        });
                                                        data1.push(tmpdata[0]);
                                                        tmpdata = [];
                                                        tmparea = 0;
                                                    }
                                                    tmpgc = d.GB.substr(0, 2);
                                                    if (d.TYPE.includes("一级")) {
                                                        var dd = {
                                                            type: gcList[d.GB.substr(0, 2)],
                                                            area: d.AREA.toFixed(2)
                                                        };
                                                        tmpdata.push(dd);
                                                        tmparea += d.AREA;
                                                    } else {
                                                        tmpdata.push({
                                                            type: gcList[d.GB.substr(0, 2)]
                                                        });
                                                        tmpdata.push({
                                                            stype: d.NAME,
                                                            area: d.AREA.toFixed(2)
                                                        });
                                                        tmparea += d.AREA;
                                                    }
                                                } else {
                                                    tmpdata.push({
                                                        stype: d.NAME,
                                                        area: d.AREA.toFixed(2)
                                                    });
                                                    tmparea += d.AREA;
                                                }
                                            });
                                            if (tmpdata.length > 0) {
                                                tmpdata[0].area = tmparea.toFixed(2);
                                                $.each(tmpdata, function (i, dd) {
                                                    data3.push(dd);
                                                });
                                                data1.push(tmpdata[0]);
                                                delete tmpdata;
                                                delete tmparea;
                                            }
                                        } else {
                                            layuiLayer.msg('加载失败', {offset: '80px'});
                                            return;
                                        }
                                        if (result[1].hasOwnProperty("features")) {
                                            var tmpdata = [];
                                            var tmparea = 0, tmpgc = "";
                                            $.each(result[1].features, function (i, feature) {
                                                var d = feature.attributes;
                                                if (tmpgc !== d.GB.substr(0, 2)) {
                                                    if (tmpdata.length > 0) {
                                                        tmpdata[0].area = tmparea.toFixed(2);
                                                        $.each(tmpdata, function (i, dd) {
                                                            data4.push(dd);
                                                        });
                                                        data2.push(tmpdata[0]);
                                                        tmpdata = [];
                                                        tmparea = 0;
                                                    }
                                                    tmpgc = d.GB.substr(0, 2);
                                                    if (d.TYPE.includes("一级")) {
                                                        var dd = {
                                                            type: gcList[d.GB.substr(0, 2)],
                                                            area: d.AREA.toFixed(2)
                                                        };
                                                        tmpdata.push(dd);
                                                        tmparea += d.AREA;
                                                    } else {
                                                        tmpdata.push({
                                                            type: gcList[d.GB.substr(0, 2)]
                                                        });
                                                        tmpdata.push({
                                                            stype: d.NAME,
                                                            area: d.AREA.toFixed(2)
                                                        });
                                                        tmparea += d.AREA;
                                                    }
                                                } else {
                                                    tmpdata.push({
                                                        stype: d.NAME,
                                                        area: d.AREA.toFixed(2)
                                                    });
                                                    tmparea += d.AREA;
                                                }
                                            });
                                            if (tmpdata.length > 0) {
                                                tmpdata[0].area = tmparea.toFixed(2);
                                                $.each(tmpdata, function (i, dd) {
                                                    data4.push(dd);
                                                });
                                                data2.push(tmpdata[0]);
                                                delete tmpdata;
                                                delete tmparea;
                                            }
                                        } else {
                                            layuiLayer.msg('加载失败', {offset: '80px'});
                                            return;
                                        }
                                        var chartData1 = [], chartData2 = [];
                                        $.each(data1, function (i, d) {
                                            chartData1.push(d.type);
                                            chartData2.push((d.area - data2[i].area).toFixed(2))
                                        });
                                        var option0 = {
                                            title: {
                                                text: years[1] + '-' + years[0] + '年主要地类类型变化量统计图',
                                                left: 'center'
                                            },
                                            tooltip: {
                                                trigger: 'axis',
                                                axisPointer: {
                                                    type: 'shadow'
                                                }
                                            },
                                            xAxis: {
                                                type: 'category',
                                                axisLabel: {show: false},
                                                data: chartData1

                                            },
                                            yAxis: {
                                                type: 'value',
                                                position: 'top',
                                                splitLine: {
                                                    lineStyle: {
                                                        type: 'dashed'
                                                    }
                                                }
                                            },
                                            series: [
                                                {
                                                    type: 'bar',
                                                    label: {
                                                        show: true,
                                                        formatter: '{b}'
                                                    },
                                                    data: chartData2
                                                }
                                            ]
                                        };
                                        var tableData = [];
                                        $.each(data3, function (i, d) {
                                            $.each(data4, function (ii, dd) {
                                                if (d.type && d.type === dd.type) {
                                                    tableData.push({
                                                        type: d.type,
                                                        area: d.area - dd.area
                                                    });
                                                } else if (d.stype && d.stype === dd.stype) {
                                                    tableData.push({
                                                        stype: d.stype,
                                                        area: (d.area - dd.area).toFixed(2)
                                                    });
                                                }
                                            });
                                        });
                                        $("#coastlineTableTitle").html("海岸带各地表覆盖类型面积变化统计");
                                        coastlineTable.reload({
                                            title: "海岸带各地表覆盖类型面积变化统计",
                                            data: tableData,
                                            limit: Number.MAX_SAFE_INTEGER,
                                            cols: [[
                                                {title: '一级类', field: 'type', align: 'center'},
                                                {title: '二级类', field: 'stype', align: 'center'},
                                                {
                                                    title: years[1] + '-' + years[0] + '年面积变化',
                                                    field: 'area',
                                                    align: 'center'
                                                }
                                            ]]
                                        });
                                        coastlineLayer = layuiLayer.open({
                                            type: 1,
                                            title: "变化监测",
                                            shadeClose: true,
                                            area: ["1500px", "800px"],
                                            content: $("#coastlineForm"),
                                            resize: false,
                                            success: function () {
                                                coastlineTable.resize();
                                                $('#coastlineChart0').show();
                                                $that.coastlineCharts["chart0"] = echarts.init(document.getElementById("coastlineChart0"));
                                                if (option0 && typeof option0 === "object") {
                                                    $that.coastlineCharts["chart0"].setOption(option0, true);
                                                }
                                            },
                                            end: function () {
                                                $('.coastlineChart').hide();
                                                $.each($that.coastlineCharts, function (i, chart) {
                                                    echarts.dispose(chart);
                                                });
                                                $that.coastlineCharts = {};
                                            }
                                        });
                                    }).catch((err) => {
                                        layuiLayer.msg('加载失败', {offset: '80px'});
                                    });
                                    break;
                                case "hax":
                                    var ajaxPromise = [], years = [];

                                    if (parseInt(keys[0].substr(1)) > parseInt(keys[1].substr(1))) {
                                        years.push(parseInt(keys[0].substr(1)));
                                        years.push(parseInt(keys[1].substr(1)));
                                        ajaxPromise.push($.ajax({
                                            url: treeNode.capables[keys[0]].url + "/0/query",
                                            data: {
                                                where: "1=1",
                                                returnGeometry: false,
                                                orderByFields: "city asc",
                                                groupByFieldsForStatistics: "city",
                                                outStatistics: JSON.stringify([{
                                                    "statisticType": "sum",
                                                    "onStatisticField": "length",
                                                    "outStatisticFieldName": "length"
                                                }]),
                                                f: "pjson"
                                            },
                                            dataType: "json"
                                        }));
                                        ajaxPromise.push($.ajax({
                                            url: treeNode.capables[keys[0]].url + "/0/query",
                                            data: {
                                                where: "1=1",
                                                returnGeometry: false,
                                                orderByFields: "type_id asc",
                                                groupByFieldsForStatistics: "type,type_id",
                                                outStatistics: JSON.stringify([{
                                                    "statisticType": "sum",
                                                    "onStatisticField": "length",
                                                    "outStatisticFieldName": "length"
                                                }]),
                                                f: "pjson"
                                            },
                                            dataType: "json"
                                        }));
                                        ajaxPromise.push($.ajax({
                                            url: treeNode.capables[keys[0]].url + "/0/query",
                                            data: {
                                                where: "1=1",
                                                returnGeometry: false,
                                                orderByFields: "type_id asc,stype_id asc",
                                                groupByFieldsForStatistics: "type,type_id,stype,stype_id",
                                                outStatistics: JSON.stringify([{
                                                    "statisticType": "sum",
                                                    "onStatisticField": "length",
                                                    "outStatisticFieldName": "length"
                                                }]),
                                                f: "pjson"
                                            },
                                            dataType: "json"
                                        }));
                                        ajaxPromise.push($.ajax({
                                            url: treeNode.capables[keys[1]].url + "/0/query",
                                            data: {
                                                where: "1=1",
                                                returnGeometry: false,
                                                orderByFields: "city asc",
                                                groupByFieldsForStatistics: "city",
                                                outStatistics: JSON.stringify([{
                                                    "statisticType": "sum",
                                                    "onStatisticField": "length",
                                                    "outStatisticFieldName": "length"
                                                }]),
                                                f: "pjson"
                                            },
                                            dataType: "json"
                                        }));
                                        ajaxPromise.push($.ajax({
                                            url: treeNode.capables[keys[1]].url + "/0/query",
                                            data: {
                                                where: "1=1",
                                                returnGeometry: false,
                                                orderByFields: "type_id asc",
                                                groupByFieldsForStatistics: "type,type_id",
                                                outStatistics: JSON.stringify([{
                                                    "statisticType": "sum",
                                                    "onStatisticField": "length",
                                                    "outStatisticFieldName": "length"
                                                }]),
                                                f: "pjson"
                                            },
                                            dataType: "json"
                                        }));
                                        ajaxPromise.push($.ajax({
                                            url: treeNode.capables[keys[1]].url + "/0/query",
                                            data: {
                                                where: "1=1",
                                                returnGeometry: false,
                                                orderByFields: "type_id asc,stype_id asc",
                                                groupByFieldsForStatistics: "type,type_id,stype,stype_id",
                                                outStatistics: JSON.stringify([{
                                                    "statisticType": "sum",
                                                    "onStatisticField": "length",
                                                    "outStatisticFieldName": "length"
                                                }]),
                                                f: "pjson"
                                            },
                                            dataType: "json"
                                        }));
                                    } else {
                                        years.push(parseInt(keys[1].substr(1)));
                                        years.push(parseInt(keys[0].substr(1)));
                                        ajaxPromise.push($.ajax({
                                            url: treeNode.capables[keys[1]].url + "/0/query",
                                            data: {
                                                where: "1=1",
                                                returnGeometry: false,
                                                orderByFields: "city asc",
                                                groupByFieldsForStatistics: "city",
                                                outStatistics: JSON.stringify([{
                                                    "statisticType": "sum",
                                                    "onStatisticField": "length",
                                                    "outStatisticFieldName": "length"
                                                }]),
                                                f: "pjson"
                                            },
                                            dataType: "json"
                                        }));
                                        ajaxPromise.push($.ajax({
                                            url: treeNode.capables[keys[1]].url + "/0/query",
                                            data: {
                                                where: "1=1",
                                                returnGeometry: false,
                                                orderByFields: "type_id asc",
                                                groupByFieldsForStatistics: "type,type_id",
                                                outStatistics: JSON.stringify([{
                                                    "statisticType": "sum",
                                                    "onStatisticField": "length",
                                                    "outStatisticFieldName": "length"
                                                }]),
                                                f: "pjson"
                                            },
                                            dataType: "json"
                                        }));
                                        ajaxPromise.push($.ajax({
                                            url: treeNode.capables[keys[1]].url + "/0/query",
                                            data: {
                                                where: "1=1",
                                                returnGeometry: false,
                                                orderByFields: "type_id asc,stype_id asc",
                                                groupByFieldsForStatistics: "type,type_id,stype,stype_id",
                                                outStatistics: JSON.stringify([{
                                                    "statisticType": "sum",
                                                    "onStatisticField": "length",
                                                    "outStatisticFieldName": "length"
                                                }]),
                                                f: "pjson"
                                            },
                                            dataType: "json"
                                        }));
                                        ajaxPromise.push($.ajax({
                                            url: treeNode.capables[keys[0]].url + "/0/query",
                                            data: {
                                                where: "1=1",
                                                returnGeometry: false,
                                                orderByFields: "city asc",
                                                groupByFieldsForStatistics: "city",
                                                outStatistics: JSON.stringify([{
                                                    "statisticType": "sum",
                                                    "onStatisticField": "length",
                                                    "outStatisticFieldName": "length"
                                                }]),
                                                f: "pjson"
                                            },
                                            dataType: "json"
                                        }));
                                        ajaxPromise.push($.ajax({
                                            url: treeNode.capables[keys[0]].url + "/0/query",
                                            data: {
                                                where: "1=1",
                                                returnGeometry: false,
                                                orderByFields: "type_id asc",
                                                groupByFieldsForStatistics: "type,type_id",
                                                outStatistics: JSON.stringify([{
                                                    "statisticType": "sum",
                                                    "onStatisticField": "length",
                                                    "outStatisticFieldName": "length"
                                                }]),
                                                f: "pjson"
                                            },
                                            dataType: "json"
                                        }));
                                        ajaxPromise.push($.ajax({
                                            url: treeNode.capables[keys[0]].url + "/0/query",
                                            data: {
                                                where: "1=1",
                                                returnGeometry: false,
                                                orderByFields: "type_id asc,stype_id asc",
                                                groupByFieldsForStatistics: "type,type_id,stype,stype_id",
                                                outStatistics: JSON.stringify([{
                                                    "statisticType": "sum",
                                                    "onStatisticField": "length",
                                                    "outStatisticFieldName": "length"
                                                }]),
                                                f: "pjson"
                                            },
                                            dataType: "json"
                                        }));
                                    }
                                    Promise.all(ajaxPromise).then((result) => {
                                        var cityList = [], chart1Data1 = [], chart1Data2 = [], chart2Data = [],
                                            typeList = [], chart3Data1 = [], chart3Data2 = [], chart4Data = [],
                                            tmpLength1 = 0, tmpLength2 = 0, chart5Data1 = [], chart5Data2 = [];
                                        if (result[0].hasOwnProperty("features")) {
                                            $.each(result[0].features, function (i, feature) {
                                                var d = feature.attributes;
                                                cityList.push(d.city);
                                                chart1Data1.push((d.length / 1000.0).toFixed(2));
                                            });
                                        } else {
                                            layuiLayer.msg('加载失败', {offset: '80px'});
                                            return;
                                        }
                                        if (result[1].hasOwnProperty("features")) {
                                            $.each(result[1].features, function (i, feature) {
                                                var d = feature.attributes;
                                                typeList.push(d.type);
                                                chart3Data1.push((d.length / 1000.0).toFixed(2));
                                                tmpLength1 += d.length / 1000.0;
                                            });
                                            typeList.unshift("总长");
                                            chart3Data1.unshift(tmpLength1.toFixed(2));
                                        } else {
                                            layuiLayer.msg('加载失败', {offset: '80px'});
                                            return;
                                        }
                                        if (result[2].hasOwnProperty("features")) {
                                            var tmpdata = [], tmplength = 0, tmpid = "";
                                            $.each(result[2].features, function (i, feature) {
                                                var d = feature.attributes;
                                                d.length /= 1000.0;
                                                if (tmpid !== d.type_id) {
                                                    if (tmpdata.length > 0) {
                                                        if (tmpdata.length > 1) {
                                                            chart5Data1.push({
                                                                type: tmpdata[0].type,
                                                                length: tmplength.toFixed(2)
                                                            });
                                                            $.each(tmpdata, function (i, d) {
                                                                chart5Data1.push({
                                                                    stype: d.stype,
                                                                    length: d.length.toFixed(2)
                                                                })
                                                            });
                                                        } else {
                                                            chart5Data1.push({
                                                                type: tmpdata[0].type,
                                                                stype: tmpdata[0].stype,
                                                                length: tmplength.toFixed(2)
                                                            });
                                                        }
                                                        tmpdata = [];
                                                        tmplength = 0;
                                                    }
                                                    tmpid = d.type_id;
                                                    tmplength += d.length;
                                                    tmpdata.push(d);
                                                } else {
                                                    tmplength += d.length;
                                                    tmpdata.push(d);
                                                }
                                            });
                                            if (tmpdata.length > 0) {
                                                if (tmpdata.length > 1) {
                                                    chart5Data1.push({
                                                        type: tmpdata[0].type,
                                                        length: tmplength.toFixed(2)
                                                    });
                                                    $.each(tmpdata, function (i, d) {
                                                        chart5Data1.push({
                                                            stype: d.stype,
                                                            length: d.length.toFixed(2)
                                                        })
                                                    });
                                                } else {
                                                    chart5Data1.push({
                                                        type: tmpdata[0].type,
                                                        stype: tmpdata[0].stype,
                                                        length: tmplength.toFixed(2)
                                                    });
                                                }
                                                delete tmpdata;
                                                delete tmplength;
                                            }
                                        } else {
                                            layuiLayer.msg('加载失败', {offset: '80px'});
                                            return;
                                        }
                                        if (result[3].hasOwnProperty("features")) {
                                            $.each(result[3].features, function (i, feature) {
                                                var d = feature.attributes;
                                                chart1Data2.push((d.length / 1000.0).toFixed(2));
                                                tmpLength2 += d.length / 1000.0;
                                                chart2Data.push((chart1Data1[i] - chart1Data2[i]).toFixed(2));
                                            });
                                        } else {
                                            layuiLayer.msg('加载失败', {offset: '80px'});
                                            return;
                                        }
                                        if (result[4].hasOwnProperty("features")) {
                                            $.each(result[4].features, function (i, feature) {
                                                var d = feature.attributes;
                                                chart3Data2.push((d.length / 1000.0).toFixed(2));
                                                chart4Data.push((chart3Data1[i] - chart3Data2[i]).toFixed(2));
                                            });
                                            chart3Data2.unshift(tmpLength2.toFixed(2));
                                            chart4Data.unshift((tmpLength1 - tmpLength2).toFixed(2));
                                        } else {
                                            layuiLayer.msg('加载失败', {offset: '80px'});
                                            return;
                                        }
                                        if (result[5].hasOwnProperty("features")) {
                                            var tmpdata = [], tmplength = 0, tmpid = "";
                                            $.each(result[5].features, function (i, feature) {
                                                var d = feature.attributes;
                                                d.length /= 1000.0;
                                                if (tmpid !== d.type_id) {
                                                    if (tmpdata.length > 0) {
                                                        if (tmpdata.length > 1) {
                                                            chart5Data2.push({
                                                                type: tmpdata[0].type,
                                                                length: tmplength.toFixed(2)
                                                            });
                                                            $.each(tmpdata, function (i, d) {
                                                                chart5Data2.push({
                                                                    stype: d.stype,
                                                                    length: d.length.toFixed(2)
                                                                })
                                                            });
                                                        } else {
                                                            chart5Data2.push({
                                                                type: tmpdata[0].type,
                                                                stype: tmpdata[0].stype,
                                                                length: tmplength.toFixed(2)
                                                            });
                                                        }
                                                        tmpdata = [];
                                                        tmplength = 0;
                                                    }
                                                    tmpid = d.type_id;
                                                    tmplength += d.length;
                                                    tmpdata.push(d);
                                                } else {
                                                    tmplength += d.length;
                                                    tmpdata.push(d);
                                                }
                                            });
                                            if (tmpdata.length > 0) {
                                                if (tmpdata.length > 1) {
                                                    chart5Data2.push({
                                                        type: tmpdata[0].type,
                                                        length: tmplength.toFixed(2)
                                                    });
                                                    $.each(tmpdata, function (i, d) {
                                                        chart5Data2.push({
                                                            stype: d.stype,
                                                            length: d.length.toFixed(2)
                                                        })
                                                    });
                                                } else {
                                                    chart5Data2.push({
                                                        type: tmpdata[0].type,
                                                        stype: tmpdata[0].stype,
                                                        length: tmplength.toFixed(2)
                                                    });
                                                }
                                                delete tmpdata;
                                                delete tmplength;
                                            }
                                        } else {
                                            layuiLayer.msg('加载失败', {offset: '80px'});
                                            return;
                                        }
                                        var chart5Data3 = [];
                                        $.each(chart5Data1, function (i, d) {
                                            chart5Data3.push({
                                                type: d.type,
                                                stype: d.stype,
                                                length: (d.length - chart5Data2[i].length).toFixed(2)
                                            });
                                        });
                                        $("#coastlineTableTitle").html(years[1] + "-" + years[0] + "年海陆分界线长度变化统计表");
                                        coastlineTable.reload({
                                            title: years[1] + "-" + years[0] + "年海陆分界线长度变化统计表",
                                            data: chart5Data3,
                                            limit: Number.MAX_SAFE_INTEGER,
                                            cols: [[
                                                {title: '一级类', field: 'type', align: 'center'},
                                                {title: '二级类', field: 'stype', align: 'center'},
                                                {title: '变化长度', field: 'length', align: 'center'}
                                            ]]
                                        });
                                        var option0 = {
                                            title: {
                                                text: '各市' + years[1] + '年、' + years[0] + '年海陆分界线长度统计图',
                                                top: '0',
                                                left: 'center'
                                            },
                                            tooltip: {
                                                trigger: 'axis',
                                                axisPointer: {
                                                    type: 'shadow'
                                                }
                                            },
                                            legend: {
                                                top: '8%'
                                            },
                                            grid: {
                                                top: '16%'
                                            },
                                            xAxis: {
                                                type: 'category',
                                                data: cityList
                                            },
                                            yAxis: {
                                                type: 'value'
                                            },
                                            series: [
                                                {
                                                    name: years[1] + "年",
                                                    type: 'bar',
                                                    data: chart1Data2
                                                },
                                                {
                                                    name: years[0] + "年",
                                                    type: 'bar',
                                                    data: chart1Data1
                                                }
                                            ]
                                        };
                                        var option1 = {
                                            title: {
                                                text: '各市' + years[1] + '-' + years[0] + '年海陆分界线长度变化统计图',
                                                left: 'center'
                                            },
                                            tooltip: {
                                                trigger: 'axis',
                                                axisPointer: {
                                                    type: 'shadow'
                                                }
                                            },
                                            xAxis: {

                                                type: 'value',
                                                position: 'top',
                                                splitLine: {
                                                    lineStyle: {
                                                        type: 'dashed'
                                                    }
                                                }
                                            },
                                            yAxis: {
                                                type: 'category',
                                                axisLabel: {show: false},
                                                data: cityList
                                            },
                                            series: [
                                                {
                                                    type: 'bar',
                                                    label: {
                                                        show: true,
                                                        formatter: '{b}'
                                                    },
                                                    data: chart2Data
                                                }
                                            ]
                                        };
                                        var option2 = {
                                            title: {
                                                text: years[1] + '年、' + years[0] + '海陆分界线长度统计图',
                                                top: '0',
                                                left: 'center'
                                            },
                                            tooltip: {
                                                trigger: 'axis',
                                                axisPointer: {
                                                    type: 'shadow'
                                                }
                                            },
                                            legend: {
                                                top: '8%'
                                            },
                                            grid: {
                                                top: '16%'
                                            },
                                            xAxis: {
                                                type: 'category',
                                                data: typeList
                                            },
                                            yAxis: {
                                                type: 'value'
                                            },
                                            series: [
                                                {
                                                    name: years[1] + "年",
                                                    type: 'bar',
                                                    data: chart3Data2
                                                },
                                                {
                                                    name: years[0] + "年",
                                                    type: 'bar',
                                                    data: chart3Data1
                                                }
                                            ]
                                        };
                                        var option3 = {
                                            title: {
                                                text: years[1] + '-' + years[0] + '年海陆分界线长度变化统计图',
                                                left: 'center'
                                            },
                                            tooltip: {
                                                trigger: 'axis',
                                                axisPointer: {
                                                    type: 'shadow'
                                                }
                                            },
                                            xAxis: {

                                                type: 'value',
                                                position: 'top',
                                                splitLine: {
                                                    lineStyle: {
                                                        type: 'dashed'
                                                    }
                                                }
                                            },
                                            yAxis: {
                                                type: 'category',
                                                axisLabel: {show: false},
                                                data: typeList
                                            },
                                            series: [
                                                {
                                                    type: 'bar',
                                                    label: {
                                                        show: true,
                                                        formatter: '{b}'
                                                    },
                                                    data: chart4Data
                                                }
                                            ]
                                        };
                                        coastlineLayer = layuiLayer.open({
                                            type: 1,
                                            title: "变化监测",
                                            shadeClose: true,
                                            area: ["1500px", "800px"],
                                            content: $("#coastlineForm"),
                                            resize: false,
                                            success: function () {
                                                coastlineTable.resize();
                                                $('#coastlineChart0').show();
                                                $('#coastlineChart1').show();
                                                $('#coastlineChart2').show();
                                                $('#coastlineChart3').show();
                                                $that.coastlineCharts["chart0"] = echarts.init(document.getElementById("coastlineChart0"));
                                                $that.coastlineCharts["chart1"] = echarts.init(document.getElementById("coastlineChart1"));
                                                $that.coastlineCharts["chart2"] = echarts.init(document.getElementById("coastlineChart2"));
                                                $that.coastlineCharts["chart3"] = echarts.init(document.getElementById("coastlineChart3"));
                                                if (option0 && typeof option0 === "object") {
                                                    $that.coastlineCharts["chart0"].setOption(option0, true);
                                                }
                                                if (option1 && typeof option1 === "object") {
                                                    $that.coastlineCharts["chart1"].setOption(option1, true);
                                                }
                                                if (option2 && typeof option2 === "object") {
                                                    $that.coastlineCharts["chart2"].setOption(option2, true);
                                                }
                                                if (option3 && typeof option3 === "object") {
                                                    $that.coastlineCharts["chart3"].setOption(option3, true);
                                                }
                                            },
                                            end: function () {
                                                $('.coastlineChart').hide();
                                                $.each($that.coastlineCharts, function (i, chart) {
                                                    echarts.dispose(chart);
                                                });
                                                $that.coastlineCharts = {};
                                            }
                                        });
                                    }).catch((err) => {
                                        layuiLayer.msg('加载失败', {offset: '80px'});
                                    });
                                    break;
                                case "wth":
                                    var ajaxPromise = [], years = [];
                                    ajaxPromise.push($.ajax({
                                        url: treeNode.capables[keys[0]].url + "/0/query",
                                        data: {
                                            where: "1=1",
                                            returnGeometry: false,
                                            orderByFields: "jtyt asc",
                                            groupByFieldsForStatistics: "jtyt",
                                            outStatistics: JSON.stringify([{
                                                "statisticType": "sum",
                                                "onStatisticField": "area",
                                                "outStatisticFieldName": "area"
                                            }]),
                                            f: "pjson"
                                        },
                                        dataType: "json"
                                    }));
                                    if (parseInt(keys[0].substr(1)) > parseInt(keys[1].substr(1))) {
                                        years.push(parseInt(keys[0].substr(1)));
                                        years.push(parseInt(keys[1].substr(1)));
                                        ajaxPromise.push($.ajax({
                                            url: treeNode.capables[keys[1]].url + "/0/query",
                                            data: {
                                                where: "1=1",
                                                returnGeometry: false,
                                                orderByFields: "jtyt asc",
                                                groupByFieldsForStatistics: "jtyt",
                                                outStatistics: JSON.stringify([{
                                                    "statisticType": "sum",
                                                    "onStatisticField": "area",
                                                    "outStatisticFieldName": "area"
                                                }]),
                                                f: "pjson"
                                            },
                                            dataType: "json"
                                        }));
                                    } else {
                                        years.push(parseInt(keys[1].substr(1)));
                                        years.push(parseInt(keys[0].substr(1)));
                                        ajaxPromise.unshift($.ajax({
                                            url: treeNode.capables[keys[1]].url + "/0/query",
                                            data: {
                                                where: "1=1",
                                                returnGeometry: false,
                                                orderByFields: "jtyt asc",
                                                groupByFieldsForStatistics: "jtyt",
                                                outStatistics: JSON.stringify([{
                                                    "statisticType": "sum",
                                                    "onStatisticField": "area",
                                                    "outStatisticFieldName": "area"
                                                }]),
                                                f: "pjson"
                                            },
                                            dataType: "json"
                                        }));
                                    }
                                    Promise.all(ajaxPromise).then((result) => {
                                        var chartData1 = [], chartData2 = [], chartData3 = [], tmpData1 = [],
                                            tmpData2 = [];
                                        if (result[0].hasOwnProperty("features")) {
                                            $.each(result[0].features, function (i, feature) {
                                                var d = feature.attributes;
                                                chartData1.push(d.jtyt);
                                                tmpData1.push(d.area);
                                                chartData2.push({
                                                    usage: d.jtyt,
                                                    area: d.area
                                                });
                                            });
                                        } else {
                                            layuiLayer.msg('加载失败', {offset: '80px'});
                                            return;
                                        }
                                        if (result[1].hasOwnProperty("features")) {
                                            $.each(result[1].features, function (i, feature) {
                                                var d = feature.attributes;
                                                tmpData2.push(d.area);
                                            });
                                        } else {
                                            layuiLayer.msg('加载失败', {offset: '80px'});
                                            return;
                                        }
                                        $.each(tmpData1, function (i, d) {
                                            chartData3.push((d - tmpData2[i]).toFixed(2));
                                            chartData2[i].area = (chartData2[i].area - tmpData2[i]).toFixed(2);
                                        });
                                        var option0 = {
                                            title: {
                                                text: '围填海用地类型面积变化图',
                                                top: '0',
                                                left: 'center'
                                            },
                                            tooltip: {
                                                trigger: 'axis',
                                                axisPointer: {
                                                    type: 'shadow'
                                                }
                                            },
                                            legend: {
                                                top: '8%'
                                            },
                                            grid: {
                                                top: '16%'
                                            },
                                            xAxis: {
                                                type: 'category',
                                                data: chartData1
                                            },
                                            yAxis: {
                                                type: 'value'
                                            },
                                            series: [
                                                {
                                                    type: 'bar',
                                                    data: chartData3
                                                }
                                            ]
                                        };
                                        $("#coastlineTableTitle").html("围填海用地类型面积变化统计表");
                                        coastlineTable.reload({
                                            title: "围填海用地类型面积变化统计表",
                                            data: chartData2,
                                            cols: [[
                                                {title: '分类', field: 'usage', align: 'center'},
                                                {title: '面积变化', field: 'area', align: 'center'},
                                                {title: '占比', field: 'rate', align: 'center'}
                                            ]],
                                            limit: Number.MAX_SAFE_INTEGER
                                        });
                                        coastlineLayer = layuiLayer.open({
                                            type: 1,
                                            title: "变化监测",
                                            shadeClose: true,
                                            area: ["1500px", "800px"],
                                            content: $("#coastlineForm"),
                                            resize: false,
                                            success: function () {
                                                coastlineTable.resize();
                                                $('#coastlineChart0').show();
                                                $that.coastlineCharts["chart0"] = echarts.init(document.getElementById("coastlineChart0"));
                                                if (option0 && typeof option0 === "object") {
                                                    $that.coastlineCharts["chart0"].setOption(option0, true);
                                                }
                                            },
                                            end: function () {
                                                $('.coastlineChart').hide();
                                                $.each($that.coastlineCharts, function (i, chart) {
                                                    echarts.dispose(chart);
                                                });
                                                $that.coastlineCharts = {};
                                            }
                                        });
                                    }).catch((err) => {
                                        layuiLayer.msg('加载失败', {offset: '80px'});
                                    });
                                    break;
                                default:
                                    layuiLayer.msg('数据类型未配置，无法分析', {offset: '80px'});
                                    break;
                            }
                        } else {
                            layuiLayer.msg('请仅勾选两个年份', {offset: '80px'});
                        }
                    } else {
                        layuiLayer.msg('请先勾选服务', {offset: '80px'});
                    }
                });
            },

            treeSearch: function () {
                var zTreeObj = $.fn.zTree.getZTreeObj(zTreeId);
                var _keywords = $("#datalistKeyword").val();
                $that.searchIndex = 0;

                // 父节点收缩
                var allNodes = zTreeObj.getNodes();
                $.each(allNodes, function (index, obj) {
                    zTreeObj.expandNode(obj, false);
                    if (obj.hasOwnProperty("children")) {
                        zTreeObj.expandNode(obj, false);
                    }
                });

                ztreeFilter(zTreeObj, _keywords);

                function ztreeFilter(zTreeObj, _keywords, callBackFunc) {
                    if (!_keywords) {
                        _keywords = ''; //如果为空，赋值空字符串
                    }

                    if ($.trim(_keywords).length == 0) {
                        $("#searchUp").hide();
                        $("#searchDown").hide();
                        var nodes = zTreeObj.getNodesByParamFuzzy("name", _keywords);
                        if (nodes && nodes.length > 0) {
                            $.each(nodes, function (n, obj) {
                                $('#' + obj.tId + '_span').css("background-color", "transparent");
                            });
                        }

                    } else {
                        var childNodes = $that.getChildNodes(zTreeObj);
                        // 清除所有高亮
                        $.each(childNodes, function (i, val) {
                            $('#' + val.tId + '_span').css("background-color", "transparent");
                        });

                        // 根据name搜索
                        var nodes = zTreeObj.getNodesByParamFuzzy("name", _keywords);

                        // 结果保留子节点，删除父节点
                        var resultNodes = [];
                        $.each(nodes, function (i, v) {
                            if (!v.hasOwnProperty("children")) {
                                resultNodes.push(v);
                            }
                        });
                        $that.searchNodes = resultNodes;
                        if (resultNodes && resultNodes.length > 0) {
                            $("#searchUp").show();
                            $("#searchDown").show();
                            // 关键字节点的祖先节点展开
                            $.each(nodes, function (n, obj) {
                                var pathOfOne = obj.getPath(); //向上追溯,获取节点的所有祖先节点(包括自己)
                                if (pathOfOne && pathOfOne.length > 0) {
                                    for (var i = 0; i < pathOfOne.length - 1; i++) {
                                        zTreeObj.expandNode(pathOfOne[i], true); //展开节点
                                    }
                                }
                            });
                        }
                        // 高亮
                        $.each($that.searchNodes, function (i, val) {
                            // if (!val.hasOwnProperty(("children"))) {
                                if (i === $that.searchIndex) {
                                    $('#' + val.tId + '_span').css("background-color", "#FFA500");
                                    // setTimeout(function () {
                                    //     $('.data-list-ztree').animate({
                                    //         scrollTop: $('#' + val.tId + '_span').offset().top - $('.data-list-ztree').offset().top
                                    //     });
                                    // }, 1000);
                                } else {
                                    $('#' + val.tId + '_span').css("background-color", "#FFFF00");
                                }
                            // }
                        });
                    }
                }
            },

            _initSearch: function () {
                // 点击搜索图标触发树搜索
                $("#dataListSearchBtn").click(function () {
                    $that.treeSearch();
                });

                // 回车触发树搜索
                $('.datalist-search-input').bind('keyup', function (event) {
                    if (event.keyCode == "13") {
                        $that.treeSearch();
                    }
                });

                // 点击下一个图标
                $("#searchDown").on('click', function (e) {
                    if ($that.searchIndex < $that.searchNodes.length - 1) {
                        $that.searchIndex++;
                        $.each($that.searchNodes, function (i, val) {
                            if (i === $that.searchIndex) {
                                $('#' + val.tId + '_span').css("background-color", "#FFA500");
                                if ($('#' + val.tId + '_span').offset().top > $('.data-list-ztree').height() + $('.data-list-ztree').offset().top) {
                                    $('.data-list-ztree').animate({
                                        scrollTop: $('#' + val.tId + '_span').offset().top + $('.data-list-ztree').offset().top
                                    });
                                }
                            } else {
                                $('#' + val.tId + '_span').css("background-color", "#FFFF00");
                            }
                        });
                    }
                });

                // 点击上一个图标
                $("#searchUp").click(function () {
                    if ($that.searchIndex > 0) {
                        $that.searchIndex--;
                        $.each($that.searchNodes, function (i, val) {
                            if (i === $that.searchIndex) {
                                $('#' + val.tId + '_span').css("background-color", "#FFA500");
                                if ($('#' + val.tId + '_span').offset().top < $('.data-list-ztree').offset().top) {
                                    $('.data-list-ztree').animate({
                                        scrollTop: $('#' + val.tId + '_span').offset().top - $('.data-list-ztree').offset().top
                                    });
                                }
                            } else {
                                $('#' + val.tId + '_span').css("background-color", "#FFFF00");
                            }
                        });
                    }
                });
            },

            // 获取子节点
            getChildNodes: function (zTreeObj) {
                var childNodes = [];
                var allNodes = zTreeObj.getNodes();
                $.each(allNodes, function (index, obj) {
                    $.each(obj.children, function (i, value) {
                        if (value.hasOwnProperty("children")) {
                            $.each(value.children, function (j, val) {
                                childNodes.push(val);
                            });
                        } else {
                            childNodes.push(value);
                        }
                    })
                });
                return childNodes;
            },

            // 移除单击样式
            removeClickStyle: function () {
                $('.ztree li').removeClass('clicked-node');
                $('.ztree li span').removeClass('clicked-node-text');
                $(".favourite-card").removeClass("fav-card-focus");
            },

            // 生成标记点
            createMarker: function (x, y, billboards) {
                var viewer = $that.viewer;
                // var ellipsoid=$that.viewer.scene.globe.ellipsoid;
                //
                // var cartographic=Cesium.Cartographic.fromDegrees(x,y);
                //
                // var position=ellipsoid.cartographicToCartesian(cartographic);

                // viewer.scene.globe.depthTestAgainstTerrain = false;

                var b = billboards.add({
                    position: Cesium.Cartesian3.fromDegrees(x, y),
                    image: $that.commonPhoto,
                    // verticalOrigin: Cesium.VerticalOrigin.BOTTOM,
                    id: _.uniqueId(),
                    width: 25, // default: undefined
                    height: 25,
                    pixelOffset: new Cesium.Cartesian2(0, 0),
                    eyeOffset: new Cesium.Cartesian3(0, 0, -25)
                    // disableDepthTestDistance: Number.POSITIVE_INFINITY
                });

                return b;
            },

            // 点击定位事件
            viewerflyToLonLat: function (lon, lat) {
                if ($that.entity)
                    MapUtils.viewer.entities.remove($that.entity);
                var ellipsoid = MapUtils.viewer.scene.globe.ellipsoid;

                var cartographic = Cesium.Cartographic.fromDegrees(lon, lat);

                var position = ellipsoid.cartographicToCartesian(cartographic);

                $that.entity = new Cesium.Entity({
                    position: Cesium.Cartesian3.fromDegrees(lon, lat),//待地形修改后，将position带入即可
                    billboard: {
                        id: 'flyTo',
                        width: 0,
                        height: 0,
                        pixelOffset: new Cesium.Cartesian2(0, 0),
                        image: $that.commonPhoto,
                        eyeOffset: new Cesium.Cartesian3(0, 0, -25)
                    }
                });
                MapUtils.viewer.entities.add($that.entity);
                // $that.viewer.scene.globe.depthTestAgainstTerrain = false;

                if ($that.zoomSwitch) {
                    MapUtils.viewer.flyTo($that.entity, {
                        offset: {
                            heading: Cesium.Math.toRadians(0.0),
                            pitch: Cesium.Math.toRadians(-50),
                            range: 500
                        }
                    });
                }
            }
        };

    var baseLayers = [], // 底图图层
        baseLayersIds = []; // 地图图层id
    var baseLyrConfig = WidgetUtils._appConfig.baseLayer;
    // 获取底图图层
    $.each(baseLyrConfig, function (i, obj) {
        $.each(obj.layers, function (j, lyr) {
            baseLayers.push(lyr);
        });
    });
    // 获取地图图层id
    $.each(baseLayers, function (i, lyr) {
        baseLayersIds.push(lyr.id);
    });

    var zTreeId = "dataListTree";
    initTree();
    $that._initFavCol();
    var element;
    layui.use('element', function () {
        element = layui.element;
        // Tab切换事件监听
        element.on('tab(dataListTab)', function (data) {
            // this 当前Tab标题所在的原始DOM元素, data.index 当前Tab的所在下标, data.elem 当前的Tab大容器
            // 隐藏弹框,移除子节点的单击样式
            $('.datalist-card').hide();
            $(".card-triangle").hide();
            me.removeClickStyle();
        });
    });

    function initTree() {
        var setting = {
            check: {
                enable: true,
                autoCheckTrigger: true,
                chkStyle: "checkbox",
                nocheckInherit: false
            },
            view: {
                showLine: true,
                showTitle: true,
                selectedMulti: false,
                dblClickExpand: false,
                expandSpeed: "slow"
            },
            data: {
                key: {
                    checked: "isChecked",
                    name: "name",
                    title: "name",
                    url: "xUrl"
                }
            },
            callback: {
                onClick: me._onClick,
                onCheck: me._onCheck,
                onDblClick: me._onDblClick
            }
        };

        $.ajax({
            url: '../../mock/dataListTree_chj.json',
            dataType: 'json',
            success: function (data) {
                ztree = $.fn.zTree.init($("#dataListTree"), setting, me._getResTree(data));
                ztreeObj = $.fn.zTree.getZTreeObj("dataListTree");
            },
            complete: function () {
                WidgetUtils.setZTreeId(zTreeId);
                // 默认勾选底图
                $.each(MapUtils._baseImageryLayers, function (i, lyr) {
                    WidgetUtils.checkNode(lyr.layerId, true, false);
                });
            }
        });

    }

    // 监听高度的变化改变card的位置
    var cardHeight = {h: 0}, cardTop = 0, max = 300, bottom = 200;
    // card最大高度与datalist正文内容平齐
    var contentHeight = $(".layui-header").height() + 125;
    cardHeight = new Proxy(cardHeight, {
        set: function (receiver, property, value) {
            // 判定过一定高度(超过3/4)
            var top = (value > max * 0.75) ? contentHeight : cardTop;
            // 当居下超过页面高度时改为bottom
            if ((top + value) > ($(".map-left-pane").height() + 70) && top > contentHeight) {
                $(".datalist-card").css({"bottom": bottom, "top": "auto"}).show('slow', '', showTriangle);
            } else {
                $(".datalist-card").css({"top": top, "bottom": "auto"}).show("slow", '', showTriangle);
            }
            receiver[property] = value;
            return Reflect.set(receiver, property, value);
        }
    });

    // 展示card的三角位置
    function showTriangle() {
        $(".card-triangle").css("top", cardTop + 105).show(50);
    }

    /**
     * get instance
     *
     * @returns {*}
     */
    me.getInstance = function () {
        if (instance === undefined) {
            instance = me;
        }
        return instance;
    };

    //***********资源检索逻辑开始**********
    var imageLayerCol = {};

    function initResourceSearch() {
        $("#resourceSearchBtn").click(function () {
            exeSearch();
        });

        function exeSearch(obj) {
            var keyword = $("#resourceSearchKeyword").val();
            if (!keyword) {
                layer.msg("请输入关键字");
                return;
            }
            var url = '../yzy/query/condition4/pageable?type[]=' + '空间数据服务' + "&keyword=" + keyword;
            // var url = '../../mock/resource_test.json';
            $.ajax({
                url: url + "&page=1&size=1",
                success: function (dt) {
                    //
                    var size = dt.totalElements;
                    if (size == 0) {
                        layer.msg("查询无结果...");
                        return;
                    }
                    $.ajax({
                        url: url + "&page=1&size=" + size,
                        success: function (dt) {
                            renderPage(dt);
                        }
                    })
                }
            })
        }

        function renderPage(dt) {
            var content = dt.content;
            $(".data-list-search-content").empty();
            var resourceHtml = "";
            var notFoundPng = rootPath + '/assets/images/noPic.png';
            $.each(content, function (i, obj) {
                obj.imgUrl = obj.imgUrl || notFoundPng;
                resourceHtml +=
                    '<div class="favourite-card-resource" id="favCard_' + obj.id + '" onselectstart="return false;">' +
                    '    <img src="' + obj.imgUrl + '">' +
                    '    <div class="service-info" id="serviceInfo' + obj.id + '">' +
                    '        <div class="fav-info-title"><p>' + obj.title + '</p></div>' +
                    '        <div class="fav-info-detail">' + obj.description + '</div>' +
                    '    </div>' +
                    '    <div style="top: -11px;right: -5px" class="fav-card-icon" id="favCardIcon' + obj.id + '"><i class="iconfont icon-card-fav icon-f-card-favourite1 fav-btn" title="收藏" favId="' + obj.id + '"></i></div>' +
                    '    <div class="fav-card-check"><i class="iconfont icon-f-uncheck resource-check-btn fav-card-uncheck" id="resourceCardCheckbox_' + obj.id + '"></i></div>' +
                    '</div>';
            });
            $(".data-list-search-content").html(resourceHtml);
            //绑定数据
            $.each(content, function (i, obj) {
                var id = obj.id;
                $("#resourceCardCheckbox_" + id).data(obj);
                $("[favId=" + id + "]").data(obj);
            });
        }

        /**
         * 绑定事件
         */

        var cloudNode = null;

        function bindEvent() {
            //添加至树
            $(document).on("click", ".fav-btn", function (evt) {
                var $target = $(evt.currentTarget);
                if ($target.hasClass("icon-f-card-favourite1")) {
                    //添加至收藏
                    addToFav($target.data());
                    $target.removeClass("icon-f-card-favourite1").addClass("icon-f-tool-mark");
                } else {
                    //从收藏中移除
                    $target.addClass("icon-f-card-favourite1").removeClass("icon-f-tool-mark");
                    removeFromFav($target.data());
                }

            });

            $(document).on("click", ".resource-check-btn", function (evt) {
                var $target = $(evt.currentTarget);
                if ($target.hasClass("fav-card-checked")) {
                    //隐藏图层
                    showOrHideResourceLayer($target.data(), false);
                } else {
                    //显示图层
                    showOrHideResourceLayer($target.data(), true);
                }
            });
        }


        /**
         * 添加至收藏
         */
        function addToFav(dt) {
            dt.resource = "search";
            $that.collectNodes.push(dt);
            $that._favCardContent();
        }

        function removeFromFav(dt) {
            $.each($that.collectNodes, function (i, node) {
                if (node.id === dt.id) {
                    $that.collectNodes.splice(i, 1);
                    return false;
                }
            });
            $that._favCardContent();
        }

        /**
         * 初始化分页
         */
        function initPage(dt) {
            layui.use('laypage', function () {
                var laypage = layui.laypage;
                //执行一个laypage实例
                laypage.render({
                    elem: 'data-list-search-page', //注意，这里的 test1 是 ID，不用加 # 号
                    count: dt.totalPages,
                    jump: function (obj, first) {
                        if (!first) {
                            exeSearch(obj);
                        }
                    }
                });
            });
        }

        bindEvent();
    }

    initResourceSearch();

    /**
     * 显示node所代表的图层
     * node可选云资源数据结构或tree node
     * 默认不显示
     */
    function showOrHideResourceLayer(dt, isShow) {
        var viewer = MapUtils.getViewer();
        //找到两个checkbox
        var $favCheck = $("#favCardCheckbox_" + dt.id);
        var $resourceCheck = $("#resourceCardCheckbox_" + dt.id);
        if ($favCheck) {
            if (!isShow) {
                $favCheck.removeClass("fav-card-checked").addClass("fav-card-uncheck");
            } else {
                $favCheck.addClass("fav-card-checked").removeClass("fav-card-uncheck");
            }
        }
        if ($resourceCheck) {
            if (!isShow) {
                $resourceCheck.removeClass("fav-card-checked").addClass("fav-card-uncheck");
            } else {
                $resourceCheck.addClass("fav-card-checked").removeClass("fav-card-uncheck");
            }
        }
        if (!isShow) {
            var layerId = dt.capables[0].id;
            //获取图层id
            if (dt.capables && dt.capables.length > 0) {

            } else {
                layerId
            }

            if (imageLayerCol[layerId]) {
                var imageLayer = imageLayerCol[layerId];
                // 移除二维图层
                if (Cesium.defined(imageLayer)) {
                    viewer.scene.imageryLayers.remove(imageLayer, true);
                }
                // 移除三维图层
                viewer.scene.layers.remove(dt.capables[0].layerName);
            }
            return;
        }
        Cesium.when(dt, function () {
            dt.capables[0].layerAlias = dt.capables[0].layerAlias || dt.title;
            dt.capables[0].url = dt.capables[0].proxyUrl;
            var viewer = MapUtils.getViewer();
            if (dt.capables[0].type === "spm_s3m") {
                MapUtils.createGlobalLayer(dt.capables[0], viewer);
            } else {
                var provider = MapUtils.createGlobalLayer(dt.capables[0], viewer);
                var imageryLayer = new Cesium.ImageryLayer(provider);
                $.extend(imageryLayer, {
                    layerId: dt.capables[0].id,
                    layerAlias: dt.capables[0].name || dt.capables[0].layerAlias
                });
                imageLayerCol[dt.capables[0].id] = imageryLayer;
                MapUtils.getViewer().scene.imageryLayers.add(imageryLayer);
            }
            //缩放至地图
            var viewer = MapUtils.getViewer();
            var scene = viewer.scene, widget = viewer.cesiumWidget;
            if (dt.hasOwnProperty('capables')) {
                switch (dt.capables[0].type) {
                    case "ags_rest":
                    case "ags_tile":
                    case "ags_vt":
                        requestMetadataToFlyBounds(dt.capables[0].url);
                        break;
                    case "spm_tile":
                        if (dt.capables[0].hasOwnProperty("agsURL")) {
                            requestMetadataToFlyBounds(dt.capables[0].agsURL);
                        }
                        break;
                    case "spm_s3m":
                        var str = dt.capables[0].url;
                        var matchReg = /http:.*?(?=realspace)/gi;
                        var url = str.match(matchReg);
                        try {
                            //定位到场景
                            Cesium.loadJson(url + 'realspace/scenes.json').then(function (scenes) {
                                var sname = scenes[0].name;
                                Cesium.loadJson(url + 'realspace/scenes/' + sname + '.json').then(function (jsonData) {
                                    var cameraPosition = jsonData.camera;
                                    var tilt = Cesium.Math.toRadians(cameraPosition.tilt - 90);
                                    //设置相机位置、视角
                                    scene.camera.flyTo({
                                        destination: new Cesium.Cartesian3.fromDegrees(cameraPosition.longitude, cameraPosition.latitude - .175, cameraPosition.altitude),
                                        orientation: {
                                            heading: cameraPosition.heading,
                                            pitch: tilt,
                                            roll: 0
                                        }
                                    });
                                    if (!scene.pickPositionSupported) {
                                        alert('不支持深度纹理,无法拾取位置！');
                                    }
                                });
                            });
                        } catch (e) {
                            if (widget._showRenderLoopErrors) {
                                var title = '渲染时发生错误，已停止渲染。';
                                widget.showErrorPanel(title, undefined, e);
                            }
                        }
                        break;
                }
            }

            function metadataSuccess(data) {
                var fullExtent = data.fullExtent;
                scene.camera.flyTo({
                    destination: Cesium.Rectangle.fromDegrees(fullExtent.xmin, fullExtent.ymin, fullExtent.xmax, fullExtent.ymax)
                });
            }

            function metadataFailure(data) {
                var readyPromise = Cesium.when.resolve(true);
                var message = 'An error occurred while accessing ' + dt.capables[0].url + '.';
                readyPromise.reject(new Cesium.RuntimeError(message));
            }

            function requestMetadataToFlyBounds(url) {

                var resource = Cesium.Resource.createIfNeeded(url);
                resource.appendForwardSlash();
                var _resource = resource.getDerivedResource({queryParameters: {f: 'json'}});
                Cesium.when(_resource.fetchJsonp(), metadataSuccess, metadataFailure);
            }
        });

    }

    //***********检索逻辑结束***********


    //*******时空网格图例添加***********
    var separateNodes = [], curLevel;

    function addLegendDiv(treeNode, level) {
        if (!treeNode.hasOwnProperty('children')) {
            if (!curLevel || !level) {
                level = getZoomLevel();
            }
            curLevel = level;
            for (var k = 0; k < treeNode.data.cards.length; k++) {
                var card = treeNode.data.cards[k];
                if (card.type === 'legend') {
                    if (card.separate) {
                        if (separateNodes.indexOf(treeNode) <= -1) {
                            separateNodes.push(treeNode);
                        }
                        var $legend = $('.datalist-legend');
                        var url, minLevel = 20, maxLevel = 0, minIndex = 0, maxIndex = 0;
                        if (!level) {
                            url = card.data.url[0].value;
                        } else {
                            for (var i = 0; i < card.data.url.length; i++) {
                                if (minLevel > card.data.url[i].level) {
                                    minLevel = card.data.url[i].level;
                                    minIndex = i;
                                }
                                if (maxLevel < card.data.url[i].level) {
                                    maxLevel = card.data.url[i].level;
                                    maxIndex = i;
                                }
                                if (card.data.url[i].level === level) {
                                    url = card.data.url[i].value;
                                }
                            }
                        }
                        if (!url) {
                            if (minLevel > level) {
                                url = card.data.url[minIndex].value;
                            } else if (maxLevel < level) {
                                url = card.data.url[maxIndex].value;
                            }
                        }
                        var content = '<img src="' + url + '">';
                        $('.datalist-legend-content').html(content);
                        if ($legend.is(':hidden')) {
                            var bottom = $('.cesium-widget').height() - $('.map-left-pane').height() - 5;
                            $legend.css({'bottom': bottom}).show();
                        }
                    }
                }
            }
            ;
        }
    }

    function changeLegend() {
        var viewer = MapUtils.getViewer();
        viewer.camera.moveEnd.addEventListener(function () {
            var zoomLevel = getZoomLevel();

            if (separateNodes.length > 0) {
                var node = separateNodes[separateNodes.length - 1];
                if (zoomLevel != curLevel) {
                    addLegendDiv(node, zoomLevel);
                }
            }
        })
    }

    function getZoomLevel() {
        var viewer = MapUtils.getViewer();
        var levels = [], tilesToRender = viewer.scene.globe._surface._tilesToRender;

        tilesToRender.forEach(function (value) {
            levels.push(value.level)
        });

        var _levels = Array.from(new Set(levels));
        return Math.max.apply(null, _levels);
    }

    $(document).on('click', '#legend-close', function () {
        $('.datalist-legend').hide();
        separateNodes = [];
        curLevel = null;
    })

    //********************************

    return me;
});