/**
 *@Author: liujie<liu.im.jie@gmail.com>
 *@Created in 2019-12-17 14:30
 *@Description: 服务对比(分屏，左侧屏为原屏，右侧添加一屏，有简单的图层控制功能)
 *@Modify By:
 */
define([
    'jquery',
    'Cesium',
    'global/utils/MapUtils',
    'knockout'
], function ($, Cesium, MapUtils, ko) {
    var instance,
        $that,
        me = {
            viewer: "",
            scene: "",
            tempLyrs: {imgLyrs: [], lyrs: []},
            sceneExtent: {},
            scale: 0,
            form: undefined,
            layer: undefined,

            init: function () {
                // 初始化存放一些全局变量读取配置
                $that = me;
                $that._viewer = MapUtils.viewer;
                $that._scene = MapUtils.viewer.scene;
                $that._imageryLayers = MapUtils.viewer.scene.imageryLayers;
                $that._layers = MapUtils.viewer.scene.layers;
                $that._scene.multiViewportMode = Cesium.MultiViewportMode["HORIZONTAL"];
                $that._scene.imagerySplitPosition = 0.5;
                //listener
                addEvent();
                $that.filterImgLayer($that._imageryLayers._layers, "imgLyrs");
                $that.filterImgLayer($that._layers._layerQueue, "lyrs");

                // bindind ko
                ko.applyBindings(viewModel, document.getElementById("tool-compareList"));
                viewModel.imgLyrList($that.tempLyrs.imgLyrs);
                viewModel.lyrList($that.tempLyrs.lyrs);

                // 初始化layui
                initLayui($that.tempLyrs);
                // es6 proxy监听
                // 监听到数据变化对对新增的数据刷新layui的控件
                $that.tempLyrs = new Proxy($that.tempLyrs, {
                    set: function (target, propKey, value, receiver) {
                        if (propKey === "imgLyrs") {
                            viewModel.imgLyrList([]);
                            viewModel.imgLyrList(value);
                        } else if (propKey === "lyrs") {
                            viewModel.lyrList([]);
                            viewModel.lyrList(value);
                        }

                        $that.form.render();
                        return Reflect.set(target, propKey, value, receiver);
                    }
                });
                MapUtils.viewer.scene.layers._layerQueue = new Proxy(MapUtils.viewer.scene.layers._layerQueue, {
                    set: function (target, propKey, value, receiver) {
                        setTimeout(function () {
                            $that.filterImgLayer($that._layers._layerQueue, "lyrs");
                        }, 500);
                        return Reflect.set(target, propKey, value, receiver);
                    }
                });
            },
            onOpen: function () {
                //listener
                addEvent();
                //过滤掉底图中没有id的图层
                $that.filterImgLayer($that._imageryLayers._layers, "imgLyrs");
                $that.filterImgLayer($that._layers._layerQueue, "lyrs");
                $that._scene.multiViewportMode = Cesium.MultiViewportMode["HORIZONTAL"];
            },
            onClose: function () {
                moveEvent();
                $that._scene.multiViewportMode = Cesium.MultiViewportMode["NONE"];
            },
            onPause: function () {
                // $that._scene.multiViewportMode = Cesium.MultiViewportMode["NONE"];
            },

            /*过滤图层*/
            filterImgLayer: function (lyr, type) {
                try {
                    var arr = [];
                    if (type === "imgLyrs") {
                        if (lyr.length > 0) {
                            $.each(lyr, function (i, e) {
                                // e.layerAlias=e.layerAlias||"未命名";
                                var clone = {};
                                if (e.layerAlias) {
                                    clone.layerAlias = e.layerAlias;// 名称
                                    clone.layerId = e.layerId;// id
                                    clone.alpha = e.alpha;// 透明度
                                    clone.check = e.show;// 可见
                                    clone.brightness = e.brightness;
                                    clone.contrast = e.contrast;
                                    clone.hue = e.hue;
                                    clone.saturation = e.saturation;
                                    clone.dynamic = (e.hasOwnProperty("info") && e.info.hasOwnProperty("tileInfo")) ? false : true;// 是否动态图层
                                    clone.url = e._imageryProvider._resource._url;// 服务地址
                                    clone.layers = (e.hasOwnProperty("info") && e.info.hasOwnProperty("layers")) ? e.info.layers : []; // 子集图层
                                    clone.manager = false;// 是否展示菜单列表
                                    clone.childIndex = [];
                                    clone.hasChildren = (clone.layers.length > 0 && clone.dynamic) ? true : false;
                                    clone.vecTile = (e.ags_vt) ? false : false; // 矢量切片
                                    clone.extent = e.extent;// 可见范围
                                    clone.disabled = false;// 控制滑块可用
                                    clone.minLevel = e.minLevel;// 最小范围
                                    clone.leftVisible = (e.getVisibleInViewport(0) > 0);
                                    clone.rightVisible = (e.getVisibleInViewport(1) > 0);

                                    // 存放子图层id
                                    clone.layers.forEach(function (e) {
                                        clone.childIndex.push(e.id.toString());
                                    });

                                    arr.push(clone);
                                }
                            });
                        }
                        $that.tempLyrs.imgLyrs = arr.reverse();
                    } else if (type === "lyrs") {
                        if (lyr.length > 0) {
                            $.each(lyr, function (i, e) {
                                // e.layerAlias=e.layerAlias||"未命名";
                                var clone = {};
                                if (e._name) {
                                    clone.name = e._name;// 名称
                                    clone.id = e._id;// id
                                    clone.index = e.index;
                                    clone.visible = e.visible;// 可见
                                    clone.leftVisible = (e.getVisibleInViewport(0) > 0);
                                    clone.rightVisible = (e.getVisibleInViewport(1) > 0);

                                    arr.push(clone);
                                }
                            });
                        }
                        $that.tempLyrs.lyrs = arr.reverse();
                    }
                } catch (e) {
                    console.log(e);
                }
            }
        };


    function LayerList() {
        var self = this;
        self.lyrList = ko.observableArray([]);
        self.imgLyrList = ko.observableArray([]);

        // 【用做ko更新数组某一项数据时的克隆，无需重新清空并绑定整个列表】
        self.clone = function (source) {
            var obj = {};
            for (var p in source)
                obj[p] = source[p];
            return obj;
        };
    }

    var viewModel = new LayerList();

    function initLayui(data) {
        layui.use(['form', 'layer'], function () {
            var form = $that.form = layui.form;
            var layer = $that.layer = layui.layer;
            form.render();
            // 监听check框
            form.on('checkbox(imgLyr)', function (data) {
                var id = $(this).attr("dataId").split("check-")[1];
                var check = data.elem.checked;
                var view = data.elem.title === "左" ? 0 : (data.elem.title === "右" ? 1 : -1);
                if (view < 0) return;
                $.each($that._imageryLayers._layers, function (i, e) {
                    if (e.layerId === id) {
                        if (check) {
                            e.setVisibleInViewport(view, true);
                        } else {
                            e.setVisibleInViewport(view, false);
                        }
                    }
                });
                form.render();
            });
            form.on('checkbox(lyr)', function (data) {
                var index = $(this).attr("dataId").split("check-")[1];
                var check = data.elem.checked;
                var view = data.elem.title === "左" ? 0 : (data.elem.title === "右" ? 1 : -1);
                if (view < 0) return;
                if (check) {
                    $that._layers.findByIndex(parseInt(index)).setVisibleInViewport(view, true);
                } else {
                    $that._layers.findByIndex(parseInt(index)).setVisibleInViewport(view, false);
                }
            });
        });
    }

    /**********************【监听图层事件】******************************/

    function addEvent() {
        $that._imageryLayers.layerAdded.addEventListener(isAdded);
        $that._imageryLayers.layerMoved.addEventListener(isMoved);
        $that._imageryLayers.layerRemoved.addEventListener(isRemoved);
    }

    function moveEvent() {
        $that._imageryLayers.layerAdded.removeEventListener(isAdded);
        $that._imageryLayers.layerMoved.removeEventListener(isMoved);
        $that._imageryLayers.layerRemoved.removeEventListener(isRemoved);
    }

    function isAdded() {
        $that.filterImgLayer($that._imageryLayers._layers, "imgLyrs");
    }

    function isMoved() {
    }

    function isRemoved() {
        $that.filterImgLayer($that._imageryLayers._layers, "imgLyrs");
    }

    /**
     * get instance
     *
     * @returns {*}
     */
    me.getInstance = function () {
        if (instance === undefined) {
            instance = me;
        }
        return instance;
    };
    return me;
});

