/**
 *
 * @author by <a href="mailto:chaomashi@gmail.com">Du</a>
 * @version v1.0 2019/7/20/9:34  Copyright gtmap Corp
 */

define(['global/utils/MapUtils',
    'knockout',
    'global/core/EventBus',
    "global/widgets/dataViews/Index",
], function (MapUtils,ko,EventBus,dataView) {
    var instance,
        layerId,
        col,
        baseLayerCheckInfo={},
        tmpMapView,//监听改变mapView
        me = {
            // init fun
            init: function () {
                col=new Collection();
                ko.applyBindings(col, document.getElementById("tool-collection"));
            },
            // open event
            onOpen: function () {

            },
            // close event
            onClose: function () {

            },
            // pause event
            onPause: function () {

            }
        };

    function Collection() {
        var self =this;
        var loadedLayer = [];
        self.colLayers =ko.observableArray([]);
        /****图层操作接口请求***/
        //增加
        self.addCol = function () {
            var data = getColInfo();
            showLoading("保存中...",".collection-pane");
            //获取xinxi
            $.ajax({
                url:rootPath+"/map/col/save",
                data:data,
                success:function (result) {
                    if(!result.data){
                        layer.msg("获取收藏数据失败!");
                        return;
                    }
                    layer.msg("保存成功!");
                    self.loadCols();
                    self.hideAddContent();
                },
                complete:function () {
                    closeLoading();
                }
            });
        };
        //删除
        self.deleteColl= function (obj) {
            layer.confirm('确认删除选中项？', function (index) {
                showLoading("删除中...",".collection-pane");
                $.ajax({
                    url:rootPath+"/map/col/delete?id="+obj.id,
                    success:function (data) {
                        if(!data.data){
                            layer.msg("删除数据失败!");
                            return;
                        }
                        layer.msg("删除数据成功!");
                        self.loadCols();
                    },
                    complete:function () {
                        layer.close(index);
                        closeLoading();
                    }
                })
            })
        }
        //加载store
        self.loadCols = function() {
            showLoading("加载中...",".collection-pane");
            $.ajax({
                url:rootPath+"/map/col/get",
                success:function (data) {
                    if(!data.data){
                        layer.msg("获取收藏数据失败!");
                        return;
                    }
                    reloadArr(self.colLayers,data.data);
                },
                complete:function () {
                    closeLoading();
                }
            });
        }

        self.chooseColl=function(obj){
            var colLayers =self.colLayers();
            $(colLayers).each(function (i,e) {
                if(!e){
                    return;
                }
                if(obj.id==e.id){
                    if(obj.choosed){
                        //加载图层
                        obj.choosed =false;
                        unCheckCol(obj);
                    }else {
                        //删除图层
                        obj.choosed =true;
                        checkCol(obj);
                    }
                }else {
                    if(e.choosed){
                        e.choosed =false;
                        //删除图层
                        unCheckCol(obj);
                    }
                }
            })
            reloadArr(self.colLayers);
        }
        /****图层操作接口请求结束***/

        /**面板控制**/

        //显示面板
        self.showAddContent = function () {
            layerId = layer.open({
                type: 1,
                title: "新建收藏",
                shadeClose: true,
                maxmin: false,
                area: ['340px', '280px'],
                content: $("#add_col_detail").html()
            });
        };

        //隐藏面板
        self.hideAddContent=function () {
            if(layerId){
                layer.close(layerId);
            }
        };
        /**面板控制**/

        function init() {
            self.loadCols();
        }
        init();
        //刷新数组
        function reloadArr(arr,data) {
            if(!data){
                refreshArr(arr);
                return;
            }
            arr.removeAll();
            $(data).each(function (i,e) {
                arr.push(e);
            });
        }

        function refreshArr(arr) {
            $(arr()).each(function (i,e) {
                var clone = JSON.parse(JSON.stringify(e));
                arr.replace(e,clone);
            });
        }

        function checkCol(obj) {
            //加载图层
            var mapView = obj.mapView;
            var layers = obj.layers;
            var checkedStatus =obj.checkInfo;
            var themeInfo = obj.themeInfo;
            if(typeof mapView=="string"){
                mapView =JSON.parse(mapView);
            }
            if(typeof layers=="string"){
                layers =JSON.parse(layers);
            }
            if(typeof checkedStatus=="string"){
                checkedStatus =JSON.parse(checkedStatus);
            }

            if(typeof themeInfo=="string"){
                themeInfo =JSON.parse(themeInfo);
            }


            MapUtils.setMapView(mapView);
            tmpMapView = mapView;
            if(themeInfo){
                dataView.checkTheme(themeInfo);
            }
            $(layers).each(function (i,e) {
                if(e.type =='spm_terr'){
                    return;
                }
                var provide = MapUtils.createGlobalLayer(e);
                if(provide){
                    var imageryLayer = new Cesium.ImageryLayer(provide);
                    loadedLayer.push(imageryLayer);
                    MapUtils.getViewer().scene.imageryLayers.add(imageryLayer);

                }
            })
            //dem、model
            var demInfo = checkedStatus.dem;
            var model = checkedStatus.model;
            if(demInfo&&demInfo.checked){
                // //添加图层
                MapUtils.removeSpmTerrain();
                window.demLayer = MapUtils.createGlobalLayer(demInfo.data);
                MapUtils.getViewer().scene.terrainProvider = demLayer;

            }else {
                MapUtils.removeSpmTerrain();
            }

            var buildingLoad= MapUtils.modelLayer;
            var poiLoad =MapUtils.poiLayer;
            if (model&&model.checked) {
                buildingLoad.start();
                poiLoad.start()
            }else{
                buildingLoad.stop()
                poiLoad.stop();
            }
        }

        function unCheckCol(obj) {
            dataView.clear();
            //删除三维
            var layers = JSON.parse(obj.layers);
            $(layers).map(function (i,e) {
                if(e.type=="spm_s3m"){
                    MapUtils.getViewer().scene.layers.remove(e.layerName);
                }
            })
            $(loadedLayer).each(function (i,imageryLayer) {
                // viewer.scene.layers.remove(treeNode.capables[0].layerName);
                MapUtils.getViewer().scene.imageryLayers.remove(imageryLayer, true);
            })
            loadedLayer=[];
            //对check状态取反
            var checkedStatus =obj.checkInfo;
            if(typeof checkedStatus=="string"){
                checkedStatus =JSON.parse(checkedStatus);
            }
            //dem、model
            var demInfo = checkedStatus.dem;
            var model = checkedStatus.model;
            if(demInfo){
                if(demInfo.checked){
                    //执行uncheck
                    MapUtils.removeSpmTerrain();
                }else {
                    // //添加图层
                    MapUtils.removeSpmTerrain();
                    window.demLayer = MapUtils.createGlobalLayer(demInfo.data);
                    MapUtils.getViewer().scene.terrainProvider = demLayer;
                }

            }
            var buildingLoad= MapUtils.modelLayer;
            var poiLoad =MapUtils.poiLayer;
            if(model){
                if(model.checked){
                    //执行uncheck
                    buildingLoad.stop();
                    poiLoad.stop();
                }else {
                    buildingLoad.start();
                    poiLoad.start();
                }
            }

        }
    }

    function bindEvent() {

        $(document).on("click",".save-layer-coll",function () {
            col.addCol();
        })
        $(document).on("click",".cancel-layer-coll",function () {
            col.hideAddContent();
        });

        EventBus.listener("checkDemLayer",function (e,data) {
            baseLayerCheckInfo.dem = {
                checked:true,
                data:data
            };
        })
        EventBus.listener("unCheckDemLayer",function (e,data) {
            baseLayerCheckInfo.dem = {
                checked:false,
                data:data
            };
        })
        EventBus.listener("checkModel",function (e,data) {
            baseLayerCheckInfo.model = {
                checked:true,
                data:data
            };
        })
        EventBus.listener("unCheckModel",function (e,data) {
            baseLayerCheckInfo.model = {
                checked:false,
                data:data
            };
        })

        /**
         * dataView 异步加载会导致地图位置变化
         * 需要themeloaded改变地图视角
         */
        EventBus.listener("themeLoaded",function (e) {
            if(tmpMapView){
                MapUtils.setMapView(tmpMapView);
                tmpMapView=null;
            }
        })

    }
    //收集地图当前信息
    function getColInfo() {
        var data ={};
        data.description = $("[name=col_description]").val();
        data.label = $("[name=col_name]").val();
        data.mapView =JSON.stringify(MapUtils.getMapView());
        data.layers =JSON.stringify(MapUtils.getCurrentLayers());
        data.checkInfo = JSON.stringify(baseLayerCheckInfo);
        var themeInfo = dataView.getCheckedTheme();
        data.themeInfo = JSON.stringify(themeInfo);
        if(!data.label){
            layer.msg("请输入名称!");
            return;
        }
        return data;
    }
    bindEvent();



    /**
     * get instance
     *
     * @returns {*}
     */
    me.getInstance = function () {
        if (void 0 === instance) {
            instance = me;
        }
        return instance;
    };
    return me;
});