/**
 * 淹没分析
 * @version v1.0 2019/9/17/14:50  Copyright gtmap Corp
 */
define(["knockout",
    "lodash",
    'Cesium',
    "global/utils/MapUtils",
    "global/utils/WidgetUtils"
], function (ko, _, Cesium, MapUtils, WidgetUtils) {
    var instance, me,
        $that = me = {
            viewer: null,
            pointHandler: null,
            viewshed3D: null,
            inited: false,
            layers: [],
            // 参数
            colorPickers: [
                {
                    "id": "hiddenAreaColor",
                    "label": "不可见区域颜色",
                    "color": ""
                },
                {
                    "id": "visibleAreaColor",
                    "label": "可见区域颜色",
                    "color": ""
                },
                {
                    "id": "hintLineColor",
                    "label": "提示线颜色",
                    "color": ""
                }
            ],
            properties: [
                {
                    "id": "direction",
                    "unit": "degree",
                    "label": "方向",
                    "min": 0,
                    "max": 360
                },
                {
                    "id": "pitch",
                    "unit": "degree",
                    "label": "翻转",
                    "min": -90,
                    "max": 90
                },
                {
                    "id": "distance",
                    "unit": "meter",
                    "label": "距离",
                    "min": 1,
                    "max": 500
                },
                {
                    "id": "horizontalFov",
                    "unit": "degree",
                    "label": "水平视场角",
                    "min": 1,
                    "max": 120
                },
                {
                    "id": "verticalFov",
                    "unit": "degree",
                    "label": "垂直视场角",
                    "min": 1,
                    "max": 90
                }
            ],

            viewShedTypes: [
                {
                    "id": "visiblebodyArea",
                    "type": "VISIBLEBODY",
                    "label": "可见区域面积",
                    "value": ""
                },

                {
                    "id": "visiblebodyVolume",
                    "type": "VISIBLEBODY",
                    "label": "可见区域体积",
                    "value": ""
                }                // {
                //     "id": "hiddenbody",
                //     "type": "HIDDENBODY",
                //     "label": "不可见区域面积",
                //     "value": ""
                // }
            ],

            pickers: {},
            // 点击监听

            // 位置定位点
            viewPosition: '',

            // 初始化属性识别面板展示
            isShowPropertyEdit: false,

            btns: [
                {
                    "id": "chooseView",
                    "icon": "icon-f-editor",
                    "label": "  绘制可视域"
                },
                {
                    "id": "clear",
                    "icon": "icon-f-analysis-delete",
                    "label": " 清除"
                }
            ],

            // init fun
            init: function () {

                window.viewer = MapUtils.viewer;
                $that.viewer = MapUtils.viewer;
                // $that._initLayui()
                var scene = $that.viewer.scene;
                var widget = $that.viewer.cesiumWidget;

            // var rectangle =    new Cesium.Rectangle(2.118553031752662,0.6513687315710148, 2.1200174695657727, 0.6540294588335368)
            //     console.log(rectangle)
            //     var res =Cesium.Rectangle.northeast(rectangle)
            //     var res1 =Cesium.Rectangle.southwest(rectangle)
            //     var lat=Cesium.Math.toDegrees(res.latitude);
            //     var lng=Cesium.Math.toDegrees(res.longitude);
            //     console.log(lat)
            //     console.log(lng)
            //     var lat1=Cesium.Math.toDegrees(res1.latitude);
            //     var lng1=Cesium.Math.toDegrees(res1.longitude);
            //     console.log(lat1)
            //     console.log(lng1)

                if (!scene.pickPositionSupported) {
                    var title = '不支持深度纹理,可视域分析功能无法使用（无法添加观测）！'
                    widget.showErrorPanel(title, undefined, e);
                    // error('不支持深度纹理,可视域分析功能无法使用（无法添加观测）！');
                }

                //先将此标记置为true，不激活鼠标移动事件中对可视域分析对象的操作
                scene.viewshed3DFlag = true;
                $that.pointHandler = new Cesium.PointHandler($that.viewer);
                //创建可视域分析对象
                $that.viewshed3D = new Cesium.ViewShed3D(scene);

                // $that.onlineDataOnLoad(scene);
                $that.drawRightAndMoveEvent(scene);
                $that.drawViewCompletedEvent(scene, $that.viewshed3D);
            },

            // 绘制图形的监听事件
            drawRightAndMoveEvent: function (scene) {
                var handler = new Cesium.ScreenSpaceEventHandler(scene.canvas);
                //鼠标移动时间回调
                handler.setInputAction(function (e) {
                    //若此标记为false，则激活对可视域分析对象的操作
                    try {
                        if (!scene.viewshed3DFlag) {
                            //获取鼠标屏幕坐标,并将其转化成笛卡尔坐标
                            var position = e.endPosition;
                            var last = scene.pickPosition(position);

                            //计算该点与视口位置点坐标的距离
                            var distance = Cesium.Cartesian3.distance($that.viewPosition, last);

                            if (distance > 0) {
                                // 将鼠标当前点坐标转化成经纬度
                                var positionDegrees = MapUtils.cartesianToDegrees(last);
                                // 通过该点设置可视域分析对象的距离及方向
                                $that.viewshed3D.setDistDirByPoint(positionDegrees);
                            }
                        }
                    } catch (e) {
                        var widget = $that.viewer.cesiumWidget;
                        var title = '绘制可视域范围鼠标移动事件错误!'
                        widget.showErrorPanel(title, undefined, e);
                        // error('绘制可视域范围鼠标移动事件错误!')
                    }
                }, Cesium.ScreenSpaceEventType.MOUSE_MOVE);

                // 鼠标右键事件回调
                handler.setInputAction(function (e) {
                    scene.viewshed3DFlag = true;
                    $that.setColorPickersAndSlider($that.viewshed3D);
                    var analysisUrl=$that._getAnalysisUrl()
                    if(analysisUrl!==null){
                        //不可视的计算不出来
                        // $that.getArea($that.viewshed3D, 'HIDDENBODY',analysisUrl);
                        $that.getArea($that.viewshed3D,analysisUrl);
                    }
                    // $('.property-edit').velocity({scale: 1},
                    //     {
                    //         duration: 600,
                    //         display: "block"
                    //     });
                    $('.property-edit').show();
                    WidgetUtils.mouseMoveMsg(true);
                }, Cesium.ScreenSpaceEventType.RIGHT_CLICK);
            },
            _getAnalysisUrl:function(){
                var curModelLyrs=WidgetUtils.getModelLyrs();
                for (var i =0;i<curModelLyrs.length;i++ ){
                    var result = Cesium.Cartographic.fromDegrees($that.viewshed3D.viewPosition[0], $that.viewshed3D.viewPosition[1], $that.viewshed3D.viewPosition[2])
                    var bounds = curModelLyrs[i].modelLayerDetails.layerBounds;
                    console.log(Cesium.Rectangle.contains(bounds, result))
                    if(Cesium.Rectangle.contains(bounds, result)){
                        if(curModelLyrs[i].spatialAnalysisURL!==undefined){
                            return curModelLyrs[i].spatialAnalysisURL
                        }
                    }
                }
                return null
            },


            drawViewCompletedEvent: function (scene, viewshed3D) {
                this.pointHandler.drawCompletedEvent.addEventListener(function (point) {
                    ///清除上次计算的面积
                    try {
                        var position = point.object.position;
                        $that.viewPosition = position;

                        if (scene.viewshed3DFlag) {
                            // 设置视口位置
                            viewshed3D.viewPosition = MapUtils.cartesianToDegrees(position);
                            viewshed3D.build();
                            // 将标记置为false以激活鼠标移动回调里面的设置可视域操作
                            scene.viewshed3DFlag = false;
                        }
                    } catch (e) {
                        var widget = $that.viewer.cesiumWidget;
                        var title = '绘制可视域点错误!'
                        widget.showErrorPanel(title, undefined, e);
                        // error('绘制可视域点错误!')
                    }
                });
            },
            getArea: function (viewshed3D,url) {
                var ViewshedParameter = viewshed3D.getViewshedParameter();
                //根据经纬度获取对应的分析地址
                // var url = 'http://192.168.90.134:8090/iserver/services/spatialAnalysis-jintan/restjsr/spatialanalyst/geometry/3d/viewshedbody.rjson?returnContent=true';
               url =url +"/geometry/3d/viewshedbody.rjson?returnContent=true";
                var param = {
                    "viewerPoint": ViewshedParameter.viewPosition,
                    "point3DsList": ViewshedParameter.point3DList,
                    "radius": ViewshedParameter.distance,
                    "lonlat": true,
                    "viewShedType": "VISIBLEBODY"
                };
                var queryObjJSON = JSON.stringify(param);
                $.ajax({
                    type: "post",
                    url: url,
                    data: queryObjJSON,
                    success: function (result) {
                        var resultObj = JSON.parse(result);
                        if (resultObj) {
                            $('#visiblebodyArea').text(resultObj.infos[0].surfaceArea.toFixed(2)+"平方米");
                            $('#visiblebodyVolume').text(resultObj.infos[0].volume.toFixed(2)+"立方米");
                        }
                    },
                    error: function (msg) {
                        console.log(msg);
                    }
                })
            },
            // 初始化滚动条和颜色选择器
            setColorPickersAndSlider: function (viewshed3D) {
                // 如果layui slider先加载然后setValue去设置初始化值 无滚动
                layui.use(['slider', 'colorpicker', 'layer'], function () {
                    var slider = layui.slider,
                        layer = layui.layer,
                        colorpicker = layui.colorpicker;
                    me.properties.forEach(function (item) {
                        var sliderValue = Math.round(viewshed3D[item.id]);
                        slider.render({
                            elem: '#' + item.id,
                            input: true,
                            min: item.min,
                            max: item.max,
                            value: sliderValue,
                            change: function (value) {
                                viewshed3D[item.id] = parseFloat(value);
                            }
                        });
                    });

                    me.colorPickers.forEach(function (value) {
                        value.color = viewshed3D[value.id].toCssColorString();
                        $that.pickers[value.id] = colorpicker.render({
                            elem: '#' + value.id,
                            color: value.color,
                            predefine: true,
                            alpha: true,
                            done: function (color) {
                                var DEAFULT_MSG = '恢复至默认颜色值';
                                if (_.isEqual(color, "")) {
                                    color = value.color;
                                    if (_.isEqual(value.id, 'hintLineColor')) {
                                        DEAFULT_MSG = "<span style='color:#939393'>" + DEAFULT_MSG + "</span>"
                                    }
                                    layer.tips(DEAFULT_MSG, this.elem, {tips: [2, color]});
                                }
                                this.change(color);
                            },
                            change: function (color) {
                                viewshed3D[value.id] = Cesium.Color.fromCssColorString(color);
                            }
                        });
                    })
                });
            },

            chooseView: function () {
                WidgetUtils.mouseMoveMsg(false, '点击绘制分析起点,右键结束');
                var scene = $that.viewer.scene;
                if ($that.pointHandler.active) {
                    return;
                }

                // 先清除之前的可视域分析
                $that.viewer.entities.removeAll();
                $that.viewshed3D.distance = 0.1;
                scene.viewshed3DFlag = true;

                // 激活绘制点类
                $that.pointHandler.activate();
            },
            // open event
            onOpen: function () {
                $that.clear();

            },
            // close event
            onPause: function () {
                 // $that.viewer.scene.layers.remove("sci_park");
                $that.clear();
            },

            onClose: function () {
                // $that.viewer.scene.layers.remove("sci_park");
                $that.clear();
            },
            onlineDataOnLoad: function (scene) {
                var widget = $that.viewer.cesiumWidget;
                try {
                    //添加S3M图层服务
                    var promise = scene.open('http://www.supermapol.com/realspace/services/3D-yanmofenxi/rest/realspace');
                    Cesium.when(promise, function (layers) {
                        $that.layers = layers;
                        // 设置相机视角
                        scene.camera.flyTo({
                            destination: new Cesium.Cartesian3.fromDegrees(114.2158, 22.4169, 419),
                            orientation: {
                                up: new Cesium.Cartesian3(-0.1629169048778112, 0.7143202157541026, 0.6805914424014209),
                                direction: new Cesium.Cartesian3(0.5945902470233576, -0.4793925407032518, 0.6454806194323606),
                                heading: 5.899584294129949
                            }
                        });


                    }, function (e) {
                        if (widget._showRenderLoopErrors) {
                            var title = '加载SCP失败，请检查网络连接状态或者url地址是否正确？';
                            widget.showErrorPanel(title, undefined, e);
                        }
                    });
                } catch (e) {
                    if (widget._showRenderLoopErrors) {
                        var title = '渲染时发生错误，已停止渲染。';
                        widget.showErrorPanel(title, undefined, e);
                    }
                }
            },
            clear: function () {
                // if ($that.layers.length > 0) {
                //     for (var i = 0; i < layers.length; i++) {
                //         var name = layers[i].name;
                //         $that.viewer.scene.layers.remove(name);
                //     }
                // }
                $that.pointHandler.clear()
                $('.property-edit').hide();
                $that.viewer.entities.removeAll();
                $that.viewshed3D.distance = 0.1;
                $that.viewer.scene.viewshed3DFlag = true;
            },

        };


    ko.applyBindings(new ViewshedAnalytic(), document.getElementById("viewshedAnalytic"));

    /**
     * 初始化btn
     * @constructor
     */
    function ViewshedAnalytic() {
        var self = this;
        // 开始和清除按钮
        self.viewshedAnalysisBtns = ko.observableArray(me.btns);
        self.viewAnalysisProperties = ko.observableArray(me.properties);
        // 颜色选择器
        self.viewAnalysisColorPickers = ko.observableArray(me.colorPickers);

        self.viewShedTypes = ko.observableArray(me.viewShedTypes);
        // 是否展示参数面板
        self.isShowPropertyEdit = ko.observable(me.isShowPropertyEdit);
        // btn点击
        self.activeBtn = function (btn) {
            _.isEqual(btn.id, 'chooseView') ? me.chooseView() : me.clear();
        }
    }

    /**
     * get instance
     *
     * @returns {*}
     */
    me.getInstance = function () {
        if (instance === undefined) {
            instance = me;
        }
        return instance;
    };
    return me;
});