define([
    "global/core/EventBus",
    "global/core/Model",
    "global/utils/MapUtils",
    "global/utils/WidgetUtils",
    "global/widgets/aysSearch/Index",
    "global/widgets/dataViews/upload"
], function (EventBus, model,MapUtils, WidgetUtils,aysSearch,Upload) {
    var instance,
        oriEntity,
        fwEntity,
        me,
        $that = me = {
            params_sthj: "",
            params_sj: "",
            params_qt: "",
            upfile: "",
            bdstate: "",
            layerIndex_wait: "",
            sjccid: "",

            sideLen1: "1",
            pjdy1: "square",
            fxxzqName1: "xzq_e_2017",
            fxxzqdm1: "",
            fxType1: "shp",
            fxLayer1: "",
            resultInstanceId: "51ad9f17-2091-43fc-abdb-13169e650d00",
            resultTableName: "",
            resultRequestUrl: "http://192.168.18.126:10002/mdb/v1/datastore/featuresbyname",
            workFlowBaseUrl: "http://192.168.90.71:8888",
            workFlowExamineBaseUrl: "http://192.168.2.55:8100",
            workFlowModelId: "cfyn6AikfSYphrNX",
            livyServer: "http://192.168.18.131:8998",


            // init fun
            init: function () {
                $that.resultInstanceId=this.config.resultInstanceId;
                $that.resultRequestUrl=this.config.resultRequestUrl;
                $that.workFlowBaseUrl=this.config.workFlowBaseUrl;
                $that.workFlowExamineBaseUrl=this.config.workFlowExamineBaseUrl;
                $that.workFlowModelId=this.config.workFlowModelId;
                $that.livyServer=this.config.livyServer;
                $that._initLayui(this.config.xzq);
                layui.form.render();
                $that._getDate();
                $that._initClick();
            },

            // open event
            onOpen: function () {
                aysSearch.analysisDivInit();
                aysSearch.analysisDivOpen("#sthjzs-analysis");


                $('#div-tbs').hide();
                $('#div-jgbm-sj').hide();
                $('#download-sj').hide();
                $('#btBefor-sj').hide();
                $('#btNext-sj').show();
                $('#btReset-sj').hide();
                $('#btOK-sj').hide();
                $that.resultTableName = "";
            },

            // close event
            onClose: function () {
                aysSearch.analysisDivClose();
                MapUtils.viewer.dataSources.removeAll();

                // // EventBus.trigger("bufferClear");
                // // // model.clear();
                // // MapUtils.viewer.dataSources.removeAll();
                // aysSearch.clearAll();
                //
                // document.getElementById('radio-shp-sj').checked = true;
                // // document.getElementById("sjlxSel-sj")[0].selected=true;
                // document.getElementById("pjdy-zfx-sj").checked = "checked";
                // document.getElementById('input-pjdylen-sj').value = "1";
                // // document.getElementById('div-filename-sj').innerText = "文件名";
                // document.getElementById("div-fxfs-sj").style.display = "block";
                // document.getElementById("div-store-sj").style.display = "none";
                // document.getElementById("div-shp-sj").style.display = "block";
                // document.getElementById("div-pjdy-sj").style.display = "block";
                //
                // document.getElementById("div-xzq-sj").style.display = "none";
                //
                // document.getElementById("div-radio-sj").style.display = "block";
                // document.getElementById("div-tbsthjzs").style.display = "none";
                // document.getElementById("div-tbsjzlzs").style.display = "none";
                // document.getElementById("div-tbqtzs").style.display = "none";
                // document.getElementById("div-jgbm-sj").style.display = "none";
                // document.getElementById("btBefor-sj").style.display = "none";
                // document.getElementById("btNext-sj").style.display = "inline";
                // document.getElementById("btOK-sj").style.display = "none";
                // document.getElementById("download-sj").style.display = "none";
                // document.getElementById("btReset-sj").style.display = "inline";
                // document.getElementById("leg-sj").innerHTML = "评价范围";
            },

            // pause event
            onPause: function () {
                aysSearch.analysisDivClose();
                MapUtils.viewer.dataSources.removeAll();
            },

            // 初始化layui
            _initLayui: function (config) {
                aysSearch.analysisDivOpen("#sthjzs-analysis");
                aysSearch.analysisDiv("ays11", config);

                EventBus.listener("ays11Analysis_file", function (e, data) {
                    $that.upfile = data;
                });

                EventBus.listener("ays11Store", function (e, data) {
                    $that.vargeojson = data;
                });

                EventBus.listener("ays11sideLen", function (e, data) {
                    $that.sideLen1 = data;
                });

                EventBus.listener("ays11pjdy", function (e, data) {
                    $that.pjdy1 = data;
                });

                EventBus.listener("ays11fxxzqName", function (e, data) {
                    $that.fxxzqName1 = data;
                });

                EventBus.listener("ays11fxxzqdm", function (e, data) {
                    $that.fxxzqdm1 = data;
                });

                EventBus.listener("ays11fxType", function (e, data) {
                    $that.fxType1 = data;
                });

                EventBus.listener("ays11fxLayer", function (e, data) {
                    $that.fxLayer1 = data;
                });

                layui.config({
                    base: './js/'
                }).use(['element', 'upload', 'layer', 'table', 'form'], function () {
                    var $ = layui.jquery;
                    var table = layui.table;
                    var form = layui.form;
                    var layer = layui.layer;
                    // var upload = layui.upload;
                    var tableId = [], layerIndex_download;

                    // $("#btn-shp-sj-input").on('change', function (e) {
                    //     $that.upfile = $("#btn-shp-sj-input")[0].files[0];
                    //
                    //     Upload.loadFile($(this), "btn-shp-sj-input", function (result, result1) {
                    //         if (typeof result == "string") {
                    //             result = JSON.parse(result);
                    //         }
                    //         if (!result.value) {
                    //             layer.msg("未得到SHP解析数据！");
                    //             return false;
                    //         }
                    //
                    //         aysSearch._removeEntity(oriEntity);
                    //         aysSearch._removeEntity(fwEntity);
                    //         try {
                    //             oriEntity = aysSearch.geoJsonToMapGroud(result.value.features, {color: Cesium.Color.LIGHTSKYBLUE});
                    //         } catch (e) {
                    //             console.log(e)
                    //         }
                    //     });
                    // });
                    //
                    //
                    // //监听下拉选择
                    // form.on('select(sjcc-filter-sj)', function (data) {
                    //     showLoading("数据加载中...");
                    //     //初始化展示数据仓储图层
                    //     var formData1 = new FormData();
                    //     formData1.append("tableId", data.value);
                    //     $.ajax({
                    //         url: "/rest/rapid/table/geojson",
                    //         type: "POST",
                    //         contentType: false,
                    //         processData: false,
                    //         data: formData1,
                    //         success: function (result) {
                    //             aysSearch._removeEntity(oriEntity);
                    //             aysSearch._removeEntity(fwEntity);
                    //             try {
                    //                 oriEntity = aysSearch.geoJsonToMapGroud(result.data.features, {color: Cesium.Color.LIGHTSKYBLUE});
                    //             } catch (e) {
                    //                 console.log(e)
                    //             }
                    //             closeLoading();
                    //         },
                    //         error: function (xhr, status, error) {
                    //             closeLoading();
                    //             layer.msg("数据获取失败！错误：" + error);
                    //         }
                    //     });
                    // });
                    //
                    // //监听radiobutton选择事件
                    // form.on('radio(sthj)', function (obj) {
                    //     aysSearch.clearAll();
                    //
                    //     if (obj.value == 1) {
                    //         document.getElementById('div-shp-sj').style.display = 'block';
                    //         document.getElementById('div-store-sj').style.display = 'none';
                    //     } else if (obj.value == 2) {
                    //         if ($that.bdstate == 0) {
                    //             $that.layerIndex_wait = layer.msg("正在读取图层...", {
                    //                 icon: 16,
                    //                 shade: [0.5, '#f5f5f5'],
                    //                 scrollbar: false,
                    //                 offset: 'auto',
                    //                 time: 100000
                    //             });
                    //             _bindingLayers('#select-tablestore-sj', rootPath + "/tablesinfo/search?page=1&limit=50&keyword=");
                    //         } else {
                    //             document.getElementById('div-store-sj').style.display = 'block';
                    //         }
                    //         document.getElementById('div-shp-sj').style.display = 'none';
                    //     }
                    //     form.render('radio');
                    // });
                    //
                    // // 切换评价单元选择方式
                    // form.on('radio(filter-pjdy-sj)', function (obj) {
                    //     var value = obj.value;
                    //
                    //     if (value === 'square' || value === 'hexagonal') {
                    //         $("#div-fxfs-sj").show();
                    //         $("#div-xzq-sj").hide();
                    //         $("#div-radio-sj").show();
                    //         $("#div-shjxzq-sj").hide();
                    //         $("#div-sjxzq-sj").hide();
                    //         $("#div-xjxzq-sj").hide();
                    //     } else if (value === 'sjxzq') {
                    //         $("#div-fxfs-sj").hide();
                    //         $("#div-xzq-sj").show();
                    //         $("#div-radio-sj").hide();
                    //         $("#div-shjxzq-sj").show();
                    //         $("#div-sjxzq-sj").hide();
                    //         $("#div-xjxzq-sj").hide();
                    //
                    //         $("#select-shjxzq-sj").empty();
                    //         $("#select-shjxzq-sj").append("<option value="+32+">江苏省(32)</option>");
                    //     } else if (value === 'xjxzq') {
                    //         $("#div-fxfs-sj").hide();
                    //         $("#div-xzq-sj").show();
                    //         $("#div-radio-sj").hide();
                    //         $("#div-shjxzq-sj").hide();
                    //         $("#div-sjxzq-sj").show();
                    //         $("#div-xjxzq-sj").hide();
                    //
                    //         $("#select-sjxzq-sj").empty();
                    //         $("#select-sjxzq-sj").append("<option value="+32+">江苏省(32)</option>");
                    //         for(var key in config.SJXZQ){
                    //             $("#select-sjxzq-sj").append("<option value="+key+">"+config.SJXZQ[key]+"(" + key + ")</option>");
                    //         }
                    //     } else if (value === 'xzjxzq') {
                    //         $("#div-fxfs-sj").hide();
                    //         $("#div-xzq-sj").show();
                    //         $("#div-radio-sj").hide();
                    //         $("#div-shjxzq-sj").hide();
                    //         $("#div-sjxzq-sj").hide();
                    //         $("#div-xjxzq-sj").show();
                    //
                    //         $("#select-xjxzq-sj").empty();
                    //         $("#select-xjxzq-sj").append("<option value="+32+">江苏省(32)</option>");
                    //
                    //         $("#select-xjxzq-sj").append("<optgroup label=\"南京市(3201)\">");
                    //         for(var key in config.NJSQX){
                    //             $("#select-xjxzq-sj").append("<option value="+key+">"+config.NJSQX[key]+"(" + key + ")</option>");
                    //         }
                    //         $("#select-xjxzq-sj").append("</optgroup>");
                    //
                    //         $("#select-xjxzq-sj").append("<optgroup label=\"无锡市(3202)\">");
                    //         for(var key in config.WXSQX){
                    //             $("#select-xjxzq-sj").append("<option value="+key+">"+config.WXSQX[key]+"(" + key + ")</option>");
                    //         }
                    //         $("#select-xjxzq-sj").append("</optgroup>");
                    //
                    //         $("#select-xjxzq-sj").append("<optgroup label=\"徐州市(3203)\">");
                    //         for(var key in config.XZSQX){
                    //             $("#select-xjxzq-sj").append("<option value="+key+">"+config.XZSQX[key]+"(" + key + ")</option>");
                    //         }
                    //         $("#select-xjxzq-sj").append("</optgroup>");
                    //
                    //         $("#select-xjxzq-sj").append("<optgroup label=\"常州市(3204)\">");
                    //         for(var key in config.CZSQX){
                    //             $("#select-xjxzq-sj").append("<option value="+key+">"+config.CZSQX[key]+"(" + key + ")</option>");
                    //         }
                    //         $("#select-xjxzq-sj").append("</optgroup>");
                    //
                    //         $("#select-xjxzq-sj").append("<optgroup label=\"苏州市(3205)\">");
                    //         for(var key in config.SZSQX){
                    //             $("#select-xjxzq-sj").append("<option value="+key+">"+config.SZSQX[key]+"(" + key + ")</option>");
                    //         }
                    //         $("#select-xjxzq-sj").append("</optgroup>");
                    //
                    //         $("#select-xjxzq-sj").append("<optgroup label=\"南通市(3206)\">");
                    //         for(var key in config.NTSQX){
                    //             $("#select-xjxzq-sj").append("<option value="+key+">"+config.NTSQX[key]+"(" + key + ")</option>");
                    //         }
                    //         $("#select-xjxzq-sj").append("</optgroup>");
                    //
                    //         $("#select-xjxzq-sj").append("<optgroup label=\"连云港市(3207)\">");
                    //         for(var key in config.LYGSQX){
                    //             $("#select-xjxzq-sj").append("<option value="+key+">"+config.LYGSQX[key]+"(" + key + ")</option>");
                    //         }
                    //         $("#select-xjxzq-sj").append("</optgroup>");
                    //
                    //         $("#select-xjxzq-sj").append("<optgroup label=\"淮安市(3208)\">");
                    //         for(var key in config.HASQX){
                    //             $("#select-xjxzq-sj").append("<option value="+key+">"+config.HASQX[key]+"(" + key + ")</option>");
                    //         }
                    //         $("#select-xjxzq-sj").append("</optgroup>");
                    //
                    //         $("#select-xjxzq-sj").append("<optgroup label=\"盐城市(3209)\">");
                    //         for(var key in config.YCSQX){
                    //             $("#select-xjxzq-sj").append("<option value="+key+">"+config.YCSQX[key]+"(" + key + ")</option>");
                    //         }
                    //         $("#select-xjxzq-sj").append("</optgroup>");
                    //
                    //         $("#select-xjxzq-sj").append("<optgroup label=\"扬州市(3210)\">");
                    //         for(var key in config.YZSQX){
                    //             $("#select-xjxzq-sj").append("<option value="+key+">"+config.YZSQX[key]+"(" + key + ")</option>");
                    //         }
                    //         $("#select-xjxzq-sj").append("</optgroup>");
                    //
                    //         $("#select-xjxzq-sj").append("<optgroup label=\"镇江市(3211)\">");
                    //         for(var key in config.ZJSQX){
                    //             $("#select-xjxzq-sj").append("<option value="+key+">"+config.ZJSQX[key]+"(" + key + ")</option>");
                    //         }
                    //         $("#select-xjxzq-sj").append("</optgroup>");
                    //
                    //         $("#select-xjxzq-sj").append("<optgroup label=\"泰州市(3212)\">");
                    //         for(var key in config.TZSQX){
                    //             $("#select-xjxzq-sj").append("<option value="+key+">"+config.TZSQX[key]+"(" + key + ")</option>");
                    //         }
                    //         $("#select-xjxzq-sj").append("</optgroup>");
                    //
                    //         $("#select-xjxzq-sj").append("<optgroup label=\"宿迁市(3213)\">");
                    //         for(var key in config.SQSQX){
                    //             $("#select-xjxzq-sj").append("<option value="+key+">"+config.SQSQX[key]+"(" + key + ")</option>");
                    //         }
                    //         $("#select-xjxzq-sj").append("</optgroup>");
                    //
                    //         $("#select-xjxzq-sj").append("<optgroup label=\"岛屿(329999)\">");
                    //         for(var key in config.JSSDY){
                    //             $("#select-xjxzq-sj").append("<option value="+key+">"+config.JSSDY[key]+"(" + key + ")</option>");
                    //         }
                    //         $("#select-xjxzq-sj").append("</optgroup>");
                    //     }
                    //     form.render();
                    // });
                    //
                    // // 切换范围选择方式
                    // form.on('radio(filter-pjfw-sj)', function (obj) {
                    //     var value = obj.value;
                    //     if (value === '1'){
                    //         $("#div-shp-sj").show();
                    //         $("#div-store-sj").hide();
                    //     }else if(value === '2'){
                    //         $that.layerIndex_wait = layer.msg("正在读取图层...", {
                    //             icon: 16,
                    //             shade: [0.5, '#f5f5f5'],
                    //             scrollbar: false,
                    //             offset: 'auto',
                    //             time: 100000
                    //         });
                    //         _bindingLayers('#select-tablestore-sj', rootPath + "/tablesinfo/search?page=1&limit=50&keyword=");
                    //
                    //         $("#div-shp-sj").hide();
                    //         $("#div-store-sj").show();
                    //     }
                    // });

                    table.render({
                        elem: '#sthjzsTable',
                        title: "生态环境指数权重表",
                        // skin: 'line',
                        // even: true,
                        id: 'table-sthjzs',
                        cols: [[
                            {field: 'zb', title: '指标'}
                            , {field: 'sjzlzs', title: '生境质量指数', edit: 'text'}
                            , {field: 'stbhzs', title: '生态保护指数', edit: 'text'}
                            , {field: 'stjgzs', title: '生态结构指数', edit: 'text'}
                            , {field: 'stxpzs', title: '土地胁迫指数', edit: 'text'}
                        ]],
                        data: [
                            {
                                zb: "权重",
                                sjzlzs: "0.25",
                                stbhzs: "0.2",
                                stjgzs: "0.3",
                                stxpzs: "0.25"
                            }
                        ],
                        limit: Number.MAX_VALUE,
                        done: function (res, curr, count) {
                            $that.params_sthj = res.data;
                        }
                        // ,page: true
                    });

                    table.render({
                        elem: '#sjzlzsTable',
                        title: "生境质量分指数权重表",
                        // skin: 'line',
                        // even: true,
                        id: 'table-sjzlfzs',
                        cols: [[
                            {field: 'ydlx', title: '用地类型'}
                            , {field: 'qz', title: '权重', edit: 'text'}
                            , {field: 'jglx', title: '结构类型'}
                            , {field: 'fqz', title: '分权重', edit: 'text'}
                        ]],
                        data: [
                            {
                                ydlx: "林地",
                                qz: "0.35",
                                jglx: "森林（除稀疏林）",
                                fqz: "0.6"
                            }
                            , {
                                ydlx: "林地",
                                qz: "0.35",
                                jglx: "灌丛（除稀疏灌木林）",
                                fqz: "0.25"
                            }
                            , {
                                ydlx: "林地",
                                qz: "0.35",
                                jglx: "其他林地",
                                fqz: "0.15"
                            }
                            , {
                                ydlx: "草地",
                                qz: "0.21",
                                jglx: "草丛",
                                fqz: "0.7"
                            }
                            , {
                                ydlx: "草地",
                                qz: "0.21",
                                jglx: "其他草地",
                                fqz: "0.3"
                            }
                            , {
                                ydlx: "水域湿地",
                                qz: "0.28",
                                jglx: "河流",
                                fqz: "0.3"
                            }
                            , {
                                ydlx: "水域湿地",
                                qz: "0.28",
                                jglx: "湖泊",
                                fqz: "0.7"
                            }
                            , {
                                ydlx: "耕地",
                                qz: "0.11",
                                jglx: "水田",
                                fqz: "0.6"
                            }
                            , {
                                ydlx: "耕地",
                                qz: "0.11",
                                jglx: "旱地",
                                fqz: "0.4"
                            }
                            , {
                                ydlx: "建设用地",
                                qz: "0.04",
                                jglx: "居住地",
                                fqz: "0.6"
                            }
                            , {
                                ydlx: "建设用地",
                                qz: "0.04",
                                jglx: "工矿交通",
                                fqz: "0.4"
                            }
                            , {
                                ydlx: "未利用地",
                                qz: "0.01",
                                jglx: "裸土",
                                fqz: "0.5"
                            }
                            , {
                                ydlx: "未利用地",
                                qz: "0.01",
                                jglx: "裸岩",
                                fqz: "0.5"
                            }
                        ],
                        limit: Number.MAX_VALUE,
                        done: function (res, curr, count) {
                            $that.params_sj = res.data;

                            $that._tbmerge(0, 1, 3);
                            $that._tbmerge(1, 1, 3);

                            $that._tbmerge(0, 4, 2);
                            $that._tbmerge(1, 4, 2);

                            $that._tbmerge(0, 6, 2);
                            $that._tbmerge(1, 6, 2);

                            $that._tbmerge(0, 8, 2);
                            $that._tbmerge(1, 8, 2);

                            $that._tbmerge(0, 10, 2);
                            $that._tbmerge(1, 10, 2);

                            $that._tbmerge(0, 12, 2);
                            $that._tbmerge(1, 12, 2);
                        }
                        // ,page: true
                    });

                    table.render({
                        elem: '#qtzsTable',
                        title: "其他指数权重表",
                        // skin: 'line',
                        // even: true,
                        id: 'table-qtzs',
                        cols: [[
                            {field: 'fzs', title: '分指数'}
                            , {field: 'fzb', title: '分指标'}
                            , {field: 'qz', title: '权重', edit: 'text'}
                        ]],
                        data: [
                            {
                                fzs: "生态保护指数",
                                fzb: "受保护区面积比",
                                qz: "1.0"
                            }
                            , {
                                fzs: "生态结构指数",
                                fzb: "林地覆盖率",
                                qz: "0.5"
                            }
                            , {
                                fzs: "生态结构指数",
                                fzb: "草地覆盖率",
                                qz: "0.2"
                            }
                            , {
                                fzs: "生态结构指数",
                                fzb: "水域湿地覆盖率",
                                qz: "0.3"
                            }
                            , {
                                fzs: "生态胁迫指数",
                                fzb: "耕地覆盖率",
                                qz: "0.3"
                            }
                            , {
                                fzs: "生态胁迫指数",
                                fzb: "建设用地覆盖率",
                                qz: "0.3"
                            }
                            , {
                                fzs: "生态胁迫指数",
                                fzb: "建设用地聚集度",
                                qz: "0.2"
                            }
                            , {
                                fzs: "生态胁迫指数",
                                fzb: "林草地破碎度",
                                qz: "0.2"
                            }
                        ],
                        limit: Number.MAX_VALUE,
                        done: function (res, curr, count) {
                            $that.params_qt = res.data;

                            $that._tbmerge(0, 15, 3);
                            $that._tbmerge(0, 18, 4);
                        }
                        // ,page: true
                    });

                    table.on('edit(sthjzsTable)', function (obj) {
                        $that.params_sthj = table.cache['sthjzsTable'];
                    });

                    table.on('edit(sjzlzsTable)', function (obj) {
                        $that.params_sj = table.cache['sjzlzsTable'];
                    });

                    table.on('edit(qtzsTable)', function (obj) {
                        $that.params_qt = table.cache['qtzsTable'];
                    });


                    $(document).on('click', '#btOK-sj', function (evt) {
                        // if(document.getElementById('pjdy-zfx-analysis').checked == true || document.getElementById('pjdy-fw-analysis').checked == true ){
                        //     if (document.getElementById('radio-shp-sj').checked == true && $that.upfile == null) {
                        //         layer.msg("请选择评价范围数据SHP包！");
                        //         return false;
                        //     }
                        // }
                        if ($that.fxType1 === "shp" && $that.upfile === null) {
                            layer.msg("请选择评价范围数据SHP包！");
                            return false;
                        }

                        $that._getDate();

                        _kjAnalysis();

                        return false;
                    });

                    $(document).on('click', '#btReset-sj', function (evt) {
                        // EventBus.trigger("bufferClear");
                        // // model.clear();
                        // MapUtils.viewer.dataSources.removeAll();
                        aysSearch.clearAll();

                        document.getElementById('input-pjdylen-sj').value = "1";
                        document.getElementById("div-store-sj").style.display = "none";
                        document.getElementById("div-shp-sj").style.display = "none";
                    });


                    //结果表名保存
                    $(document).on('click', '#btTbSave-sj', function (evt) {
                        var info = "{tableName:'" + document.getElementById('input-name-sj').value + "'}";
                        $.ajax({
                            type: 'POST',
                            url: '/metainfo/edit',
                            data: {
                                id: $that.sjccid,
                                info: info,
                            },
                            success: function (msg) {
                                layer.msg("保存成功！");
                                closeLoading();
                            },
                            error: function (e, state, errorThrown) {
                                console.log(e);
                                closeLoading();
                            }
                        });
                        return false;
                    });
                    //申请下载弹窗
                    $(document).on('click', '#download-sj', function (evt) {
                        var $divDownload = $('#div-download-sj');
                        layer.close(layerIndex_download);
                        layerIndex_download = layer.open({
                            title: '提交申请',
                            shade: 0,
                            shadeClose: true,
                            type: 1,
                            area: ['500px', '360px'],
                            content: $divDownload.html(),
                        })
                        return false;
                        //var downUrl="http://192.168.2.101:10002/mdb/v1/datastore/export/shp?tableId=24478b13-2e06-405b-95c4-c4fd5454ce43";
                        // window.open(downloadUrl);
                    });
                    //申请下载弹窗中保存按钮
                    $(document).on('click', '#btn-download-sj', function () {
                        tableId.push($that.sjccid);
                        $.ajax({
                            type: 'post',
                            url: '/overlay/apply',
                            data: {
                                "id": JSON.stringify(tableId),
                                "reason": $('.text-reason').val(),
                            }
                        }).then(
                            function (obj) {
                                layer.msg('已成功提交申请，等待审核后可在数据治理中心下载！');
                            },
                            function (obj) {
                                layer.msg('提交申请失败！');
                            }
                        )
                    });

                    function _kjAnalysis() {
                        var sthjzsqz = $that._getTbjson("sthjzsTable",1);
                        var stydlxzqz = $that._getTbjson("sjzlzsTable",0);
                        var stydlxfqz = $that._getTbjson("sjzlzsTable",1);
                        var qtzbqz = $that._getTbjson("qtzsTable",1);

                        var jslist = {};
                        jslist.sthjzsqz = sthjzsqz;
                        jslist.stydlxzqz = stydlxzqz;
                        jslist.stydlxfqz = stydlxfqz;
                        jslist.qtzbqz = qtzbqz;
                        // jslist.id = "402882e56cb273c1016cf103228c0004";//测试
                        jslist.id = "402882e56c515912016c64b082080002";
                        jslist.bhqlx = "sj";
                        jslist.table = document.getElementById('input-name-sj').value;

                        jslist.sideLen = $that.sideLen1;
                        jslist.pjdy = $that.pjdy1;
                        jslist.xzqName = $that.fxxzqName1;
                        jslist.xzqdm = $that.fxxzqdm1;
                        var jspara = JSON.stringify(jslist);


                        var params = {};
                        params["layerName"] = $that.vargeojson;
                        params["jspara"] = jspara;
                        params["server"] = $that.livyServer;

                        $that.layerIndex_wait = layer.msg("分析进行中...", {
                            icon: 16,
                            shade: [0.5, '#f5f5f5'],
                            scrollbar: false,
                            offset: 'auto',
                            time: 10000000
                        });

                        showLoading();
                        // debugger
                        var idValue = session("sthjzs");
                        if (idValue) {
                            params.id = idValue * 1;
                        }
                        $.ajax({
                            type: "POST",
                            url: $that.workFlowBaseUrl + "/mso/workflow/process/" + $that.workFlowModelId,
                            contentType: "application/json",
                            data: JSON.stringify(params),
                            dataType: "json",
                            success: function (data) {
                                pollRequest(data.workflowInstanceKey, document.getElementById('input-name-sj').value);
                                layer.msg("分析任务提交成功");
                            },
                            error: function (err) {
                                closeLoading();
                                layer.msg("分析任务提交失败");
                                console.log(err);
                            }
                        });


                        // var sType = $that.fxType1;
                        // var layernm = $that.fxLayer1;
                        //
                        // var formData = new FormData();
                        // formData.append("sourceType", sType);
                        // formData.append("layerName", layernm);
                        // formData.append("file", $that.upfile);
                        // formData.append("jspara", jspara);
                        //
                        // //分析
                        // showLoading("分析进行中...");
                        // // $that.layerIndex_wait = layer.msg("分析进行中...", {icon: 16, shade: [0.5, '#f5f5f5'], scrollbar: false, offset: 'auto', time: 10000000});
                        // $.ajax({
                        //     url: "/rest/rapid/fxsthjzs",
                        //     type: "POST",
                        //     contentType: false,
                        //     processData: false,
                        //     data: formData,
                        //     success: function (result) {
                        //         if(result.data == null){
                        //             closeLoading();
                        //             // layer.close($that.layerIndex_wait);
                        //             layer.msg("未得到分析结果！");
                        //             return false;
                        //         }
                        //
                        //         // model.addModel(result.data,"geojson");
                        //
                        //         $.each(result.data, function (key, value) {
                        //             $that.sjccid = key;
                        //             model.addModel(value,"geojson");
                        //         });
                        //
                        //         // var temp = {
                        //         //     "type": "FeatureCollection",
                        //         //     "features": result.data.features
                        //         // };
                        //         // var promise = Cesium.GeoJsonDataSource.load(temp);
                        //         // promise.then(function (dataSource) {
                        //         //     MapUtils.viewer.dataSources.add(dataSource);
                        //         //     var entities = dataSource.entities.values;
                        //         //     $.each(entities, function (index, value) {
                        //         //         value.polygon.material.color = Cesium.Color.LIGHTSKYBLUE.withAlpha(0.7);
                        //         //         value.polygon.outline = true;
                        //         //         value.polygon.outlineWidth = 100;
                        //         //         value.polygon.outlineColor = Cesium.Color.RED;
                        //         //         value.polygon.closeBottom = false;
                        //         //     });
                        //         // });
                        //
                        //         // layer.close($that.layerIndex_wait);
                        //         document.getElementById("download-sj").style.display = "inline";
                        //         document.getElementById("btReset-sj").style.display = "none";
                        //         document.getElementById("div-jgbm-sj").style.display = "block";
                        //         closeLoading();
                        //         layer.msg("分析完成！");
                        //     },
                        //     error: function (xhr, status, error) {
                        //         closeLoading();
                        //         layer.msg("分析失败！错误：" + error);
                        //     }
                        // });

                    }

                    function session(id, value) {
                        var result;
                        if (!id) {
                            layer.msg("id is null");
                            throw new Error("id is null");
                        }
                        $.ajax({
                            url: rootPath + "/map/session",
                            async: false,
                            data: {
                                key: id,
                                value: value || ""
                            },
                            success: function (e) {
                                if (e.data && e.data != true) {
                                    result = e.data;
                                }
                            }
                        });
                        return result;
                    }

                    function pollRequest(id, tableName) {
                        var interval = setInterval(function () {
                            $.post({
                                url: $that.workFlowExamineBaseUrl + "/define/api/activity-instances",
                                type: "POST",
                                contentType: "application/json",
                                data: JSON.stringify({workflowInstanceId: id}),
                                success: function (data) {
                                    if (data.children && data.children.length > 0) {
                                        console.log(data);
                                        var data = data.children[data.children.length - 1];
                                        if (data.state != "COMPLETED" && data.state != "ACTIVE") {
                                            layer.msg("任务失败!");
                                            closeLoading();
                                            clearInterval(interval);
                                            return;
                                        } else if (data.state == "COMPLETED" && data.type == "END_EVENT") {
                                            //请求数据
                                            getTaskData(id, tableName);
                                            clearInterval(interval);
                                        }
                                    }
                                }
                            });
                        }, 1000);
                    }

                    function getTaskData(instanceKey, tableName) {
                        // debugger
                        $.ajax({
                            url: $that.resultRequestUrl,
                            data: {
                                instanceId: $that.resultInstanceId,
                                tableName: tableName
                            },
                            success: function (data) {
                                var tmp = {};
                                tmp.type = "FeatureCollection";
                                tmp.features = data;
                                // model._option.clampToGround = true;
                                model._option.prop = "SCORE";
                                model.addModel(tmp, "geojson");
                                // debugger
                                $.ajax({
                                    url: $that.workFlowExamineBaseUrl + "/define/api/workflow-instances/" + instanceKey + "/variables",
                                    success: function (data) {
                                        if (data instanceof Array) {
                                            $(data).map(function (i, v) {
                                                if (v.name == "id") {
                                                    session("sthjzs", v.value);
                                                }
                                            })
                                        }
                                    }
                                });
                                $that.resultTableName = tableName;
                                $("#download-sj").show();
                                $("#div-jgbm-sj").show();
                                $("#btReset-sj").hide();
                            },
                            complete: function () {
                                closeLoading();
                            }
                        })
                    }

                    /**
                     * 显示保存操作按钮及默认表名生成
                     */
                    $('#btn-save-sj').click(function () {
                        var now = new Date();
                        $('#div-savedialog-sj').show();
                        $('#input-alisaName-sj').val("生态环境指数分析_" + now.getFullYear().toString() + (now.getMonth() + 1).toString() + now.getDate().toString() + now.getHours().toString() + now.getMinutes().toString() + now.getSeconds().toString());
                    });

                    /**
                     * 执行注册操作
                     */
                    $('#btn-save-execute-sj').click(function () {
                        //判断是否已获取表名
                        if ($that.resultTableName.length > 0) {
                            $.ajax({
                                url: rootPath + "/tablesinfo/register",
                                data: {
                                    "id": $that.resultInstanceId,
                                    "layerName": $that.resultTableName,
                                    "moduleCode": "ccglzy",
                                    "moduleName": "仓储管理资源",
                                    "tableName":$('#input-alisaName-sj').val()
                                },
                                type: "POST",
                                success: function (data) {
                                    layer.msg("分析结果已保存！");
                                },
                                error: function (err) {
                                    layer.msg("分析结果保存失败！");
                                }
                            })
                        }
                        return false;
                    });


                    // function _bindingLayers(elem, url) {
                    //     var $target = $(elem);
                    //     $.ajax({
                    //         url: url,
                    //         // async: false,
                    //         success: function (result) {
                    //             var content = result["data"];
                    //             var result1 = [];
                    //             if (content) {
                    //                 for (var i = 0; i < content.length; i++) {
                    //                     var item = {};
                    //                     item.id = content[i].id;
                    //                     item.name = content[i].tableName;
                    //                     result1.push(item);
                    //                 }
                    //             }
                    //
                    //             var renderData = result1;
                    //
                    //             var option = "";
                    //             for (var i = 0; i < renderData.length; i++) {
                    //                 option += "<option value=" + renderData[i].id + ">" + renderData[i].name + "</option>";
                    //             }
                    //             $target.html(option);
                    //             for (var i = 0; i < result.length; i++) {
                    //                 var id = result[i].id;
                    //                 $("#" + id).data(result[i]);
                    //             }
                    //
                    //             form.render('select');
                    //             layer.close($that.layerIndex_wait);
                    //             document.getElementById('div-store-sj').style.display = 'block';
                    //             $that.bdstate = 1;
                    //         },
                    //         error: function (e, state, error) {
                    //             console.log(e);
                    //         }
                    //     });
                    // }

                })
            },

            // 初始化一些点击事件
            _initClick: function () {
                $(document).on('click', '#btNext-sj', function (evt) {
                    $('#analysis').hide();
                    $('#div-tbs').show();
                    $('#btNext-sj').hide();
                    $('#btBefor-sj').show();
                    $('#btOK-sj').show();

                    // document.getElementById("div-xzq-sj").style.display = "none";
                    //
                    // document.getElementById("div-fxfs-sj").style.display = "none";
                    // document.getElementById("div-store-sj").style.display = "none";
                    // document.getElementById("div-shp-sj").style.display = "none";
                    // document.getElementById("div-pjdy-sj").style.display = "none";
                    // document.getElementById("div-tbsthjzs").style.display = "block";
                    // document.getElementById("div-tbsjzlzs").style.display = "block";
                    // document.getElementById("div-tbqtzs").style.display = "block";
                    // document.getElementById("btBefor-sj").style.display = "inline";
                    // document.getElementById("btNext-sj").style.display = "none";
                    // document.getElementById("btOK-sj").style.display = "inline";

                    document.getElementById("leg-sj").innerHTML = "设置指标权重";
                    return false;
                });

                $(document).on('click', '#btBefor-sj', function (evt) {
                    $('#analysis').show();
                    $('#div-tbs').hide();
                    $('#btNext-sj').show();
                    $('#btBefor-sj').hide();
                    $('#btOK-sj').hide();

                    // if (document.getElementById('pjdy-sjxzq-sj').checked === true){
                    //     document.getElementById("div-xzq-sj").style.display = "block";
                    //     document.getElementById("div-shjxzq-sj").style.display = "block";
                    //     document.getElementById("div-sjxzq-sj").style.display = "none";
                    //     document.getElementById("div-xjxzq-sj").style.display = "none";
                    // }else if(document.getElementById('pjdy-xjxzq-sj').checked === true){
                    //     document.getElementById("div-xzq-sj").style.display = "block";
                    //     document.getElementById("div-shjxzq-sj").style.display = "none";
                    //     document.getElementById("div-sjxzq-sj").style.display = "block";
                    //     document.getElementById("div-xjxzq-sj").style.display = "none";
                    // }else if(document.getElementById('pjdy-xzxzq-sj').checked === true){
                    //     document.getElementById("div-xzq-sj").style.display = "block";
                    //     document.getElementById("div-shjxzq-sj").style.display = "none";
                    //     document.getElementById("div-sjxzq-sj").style.display = "none";
                    //     document.getElementById("div-xjxzq-sj").style.display = "block";
                    // }else{
                    //     document.getElementById("div-fxfs-sj").style.display = "block";
                    //     if (document.getElementById('radio-sjcc-sj').checked === true) {
                    //         document.getElementById("div-store-sj").style.display = "block";
                    //     }
                    //     if (document.getElementById('radio-shp-sj').checked === true) {
                    //         document.getElementById("div-shp-sj").style.display = "block";
                    //     }
                    // }
                    //
                    // document.getElementById("div-pjdy-sj").style.display = "block";
                    // // switch (document.getElementById("sjlxSel-sj").value) {
                    // //     case "0":
                    // //         document.getElementById("div-store-sj").style.display = "block";
                    // //         break;
                    // //     case "1":
                    // //         document.getElementById("div-shp-sj").style.display = "block";
                    // //         break;
                    // // }
                    //
                    // document.getElementById("div-tbsthjzs").style.display = "none";
                    // document.getElementById("div-tbsjzlzs").style.display = "none";
                    // document.getElementById("div-tbqtzs").style.display = "none";
                    // document.getElementById("btBefor-sj").style.display = "none";
                    // document.getElementById("btNext-sj").style.display = "inline";
                    // document.getElementById("btOK-sj").style.display = "none";

                    document.getElementById("leg-sj").innerHTML = "评价范围";
                    return false;
                })

            },

            _getDate: function () {
                var now= new Date();
                document.getElementById("input-name-sj").value = "STHJZS" + now.getFullYear().toString() + (now.getMonth()+1).toString() + now.getDate().toString() + now.getHours().toString() + now.getMinutes().toString() + now.getSeconds().toString();
            },

            _tbmerge: function (columsIndex, startIndex, mark) {
                var trArr = $(".layui-table-body>.layui-table").find("tr");//所有行
                var tdPreArr = trArr.eq(startIndex).find("td").eq(columsIndex);//获取相同列的第一列
                tdPreArr.each(function () {//相同列的第一列增加rowspan属性
                    $(this).attr("rowspan", mark);
                });
                for (var i = startIndex + 1; i < mark + startIndex; i++) {
                    var tdCurArr = trArr.eq(i).find("td").eq(columsIndex);//获取当前行的当前列
                    tdCurArr.each(function () {//当前行隐藏
                        $(this).css("display", "none");
                    });
                }
            },

            _getTbjson: function (tableID,type) {
                var tbData;
                var gxjson = "";
                if (tableID == "sthjzsTable") {
                    // "分值计算公式，格式{'sjzlzs':0.25,'stbhzs':0.2,'stjgzs':0.3,'tdxpzs':0.25}"
                    tbData = $that.params_sthj;
                    gxjson = "{'sjzlzs':" + tbData[0].sjzlzs + ",'stbhzs':" + tbData[0].stbhzs + ",'stjgzs':" + tbData[0].stjgzs + ",'tdxpzs':" + tbData[0].stxpzs + "}";

                } else if (tableID == "sjzlzsTable") {
                    tbData = $that.params_sj;
                    if(type == "0"){
                        //{'ld':0.35,'cd':0.21,'sysd':0.28,'gd':0.11,'jsyd':0.04,'wlyd':0.01}
                        gxjson = "{'ld':" + tbData[0].qz + ",'cd':" + tbData[3].qz + ",'sysd':" + tbData[5].qz + ",'gd':" + tbData[7].qz + ",'jsyd':" + tbData[9].qz + ",'wlyd':" + tbData[11].qz + "}";
                    }else{
                        //{'sl':0.6,'gc':0.25,'qtld':0.15,'cc':0.7,'qtcd':0.3,'hl':0.3,'hp':0.7,'st':0.6,'hd':0.4,'jzd':0.6,'gkjt':0.4,'lt':0.5,'ly':0.5}
                        gxjson = "{'sl':" + tbData[0].fqz + ",'gc':" + tbData[1].fqz + ",'qtld':" + tbData[2].fqz + ",'cc':" + tbData[3].fqz + ",'qtcd':" + tbData[4].fqz + ",'hl':" + tbData[5].fqz
                                    + ",'hp':" + tbData[6].fqz + ",'st':" + tbData[7].fqz + ",'hd':" + tbData[8].fqz + ",'jzd':" + tbData[9].fqz + ",'gkjt':" + tbData[10].fqz + ",'lt':" + tbData[11].fqz
                                    + ",'ly':" + tbData[12].fqz + "}";
                    }
                }else if (tableID == "qtzsTable") {
                    tbData = $that.params_qt;

                    // {'sbhq':1,'ldfgl':0.5,'cdfgl':0.2,'syfgl':0.3,'gdfgl':0.3,'jsydfgl':0.3,'jsydjjd':0.2,'lcdpsd':0.2}
                    gxjson = "{'sbhq':" + tbData[0].qz + ",'ldfgl':" + tbData[1].qz + ",'cdfgl':" + tbData[2].qz + ",'syfgl':" + tbData[3].qz + ",'gdfgl':" + tbData[4].qz + ",'jsydfgl':" + tbData[5].qz
                                + ",'jsydjjd':" + tbData[6].qz + ",'lcdpsd':" + tbData[7].qz + "}";
                }
                return gxjson;
            },

        };


    var interfaceConfig = WidgetUtils._appConfig.interface,
        parsefile = interfaceConfig.parsefile;

    // var sjxzqConfig = WidgetUtils._appConfig.SJXZQ;


    /**
     * get instance
     *
     * @returns {*}
     */
    me.getInstance = function () {
        if (void 0 === instance) {
            instance = me;
        }
        return instance;
    };
    return me;
});
