/**
 *
 * @author by <a href="mailto:chaomashi@gmail.com">Du</a>
 * @version v1.0 2019/2/14/10:21  Copyright gtmap Corp
 */
define(['knockout',
    "global/utils/MapUtils",
    'Cesium',
    'lodash',
    "global/utils/WidgetUtils"
], function (
    ko,
    MapUtils,
    Cesium,
    _,
    WidgetUtils) {
    var instance,
        $that,
        me = {
            btns: [
                {
                    id: 'chooseView',
                    icon: 'icon-f-dotcircle',
                    label: ' 选取观察点'
                },
                {
                    id: 'addPoint',
                    icon: 'icon-f-dotcircle',
                    label: ' 选取目标点'
                },
                {
                    id: 'clear',
                    icon: 'icon-f-analysis-delete',
                    label: ' 清除'
                }
            ],

            SIGHTLINE_COLOR_RED: Cesium.Color.RED,

            SIGHTLINE_COLOR_BLUE: Cesium.Color.fromCssColorString('#7FFF00'),

            sightline: '',

            viewer:null,

            pointHandler: '',

            // 初始化
            init: function () {
                $that = this;
                this.viewer = MapUtils.viewer;
                this.initAnalyticWidget();
            },

            // open event
            onOpen: function () {
                this.clear();
            },

            // close event
            onPause: function () {
                this.clear();
            },

            onClose: function () {
                this.clear();
            },

            // 初始化组件
            initAnalyticWidget: function () {
                this.pointHandler = new Cesium.PointHandler(this.viewer);
                this.viewer = MapUtils.viewer;
                var scene = this.viewer.scene,
                    sightline = new Cesium.Sightline(scene);
                this.sightline = sightline;

                // 设置颜色
                _.assign(sightline, {
                    visibleColor: this.SIGHTLINE_COLOR_BLUE,
                    hiddenColor: this.SIGHTLINE_COLOR_RED
                });

                sightline.couldRemove = false;
                this.drawPointCompletedEvent(scene, sightline, this.viewer);

                // this.onlineDataOnLoad(scene);

            },


            // supermap  onlinedate
            onlineDataOnLoad: function (scene) {
                var widget = this.viewer.cesiumWidget;
                try {
                    //添加S3M图层
                    var SCP_CBD_GROUND1 = "http://www.supermapol.com/realspace/services/3D-WebGLCBD/rest/realspace/datas/Ground_1@新CBD/config",
                        SCP_CBD_BUILD = "http://www.supermapol.com/realspace/services/3D-WebGLCBD/rest/realspace/datas/Building@%E6%96%B0CBD/config";
                    var ground1Promise = scene.addS3MTilesLayerByScp(SCP_CBD_GROUND1, {name: 'ground1'});
                    var buildPromise = scene.addS3MTilesLayerByScp(SCP_CBD_BUILD, {name: 'build'});
                    var promiseSet = [ground1Promise, buildPromise];
                    Cesium.when.all(promiseSet, function (layer) {
                        scene.camera.setView({
                            destination: new Cesium.Cartesian3.fromDegrees(114.32398008091434, 30.60241588421052, 100),
                            orientation: {
                                heading: 0.31348036210986194,
                                pitch: -0.13636490404291735,
                                roll: 6.283185307179563
                            }
                        });

                        layer.forEach(function (lyr) {
                            lyr.selectEnabled = false;
                        });
                        me.sightline.build();
                    }, function (e) {
                        if (widget._showRenderLoopErrors) {
                            var title = '加载SCP失败，请检查网络连接状态或者url地址是否正确？';
                            widget.showErrorPanel(title, undefined, e);
                        }
                    });
                } catch (e) {
                    if (widget._showRenderLoopErrors) {
                        var title = '渲染时发生错误，已停止渲染。';
                        widget.showErrorPanel(title, undefined, e);
                    }
                }
            },

            // 绘制图形监听事件
            drawPointCompletedEvent: function (scene, sightline, viewer) {
                this.pointHandler.drawCompletedEvent.addEventListener(function (point) {
                    // var position = point.position._value;
                    var position = point.object._position;
                    // 将获取的点的位置转化成经纬度
                    var positonDegrees = MapUtils.cartesianToDegrees(position);

                    WidgetUtils.mouseMoveMsg(true);
                    if (scene.sightlineFlag) {
                        //设置视口位置
                        sightline.viewPosition = positonDegrees;
                        scene.sightlineFlag = false;
                    } else {
                        viewer.entities.remove(point);
                        //添加视点
                        sightline.addTargetPoint({
                            position: positonDegrees,
                            name: _.uniqueId('targetPoint_')
                        });
                        sightline.couldRemove = true;
                        sightline.build();
                    }
                });
            },

            // 选取观察位置
            chooseView: function () {
                if ($that.pointHandler.active) {
                    return;
                }
                WidgetUtils.mouseMoveMsg(false, '点击选取观察点');
                $that.viewer.scene.sightlineFlag = true;

                $that.viewer.entities.removeAll();
                if ($that.sightline.couldRemove) {
                    $that.sightline.removeAllTargetPoint();
                }
                $that.pointHandler.activate();
            },

            // 添加目标点
            addPoint: function () {
                WidgetUtils.mouseMoveMsg(false, '点击选取目标点');
                $that.viewer.scene.sightlineFlag = false;
                $that.pointHandler.activate();
            },

            // 清除
            clear: function () {
                $that.viewer.entities.removeAll();
                if ($that.sightline.couldRemove) {
                    $that.sightline.removeAllTargetPoint();
                    $that.sightline.couldRemove = false;
                }
                WidgetUtils.mouseMoveMsg(true);
            }

        };


    ko.applyBindings(new AnalysisViewModel(), document.getElementById("analysisBtns"));

    /**
     * 初始化btn
     * @constructor
     */
    function AnalysisViewModel() {

        var self = this;

        self.analysisBtns = ko.observableArray(me.btns);

        self.activeBtn = function (btn) {
            switch (btn.id) {
                case 'chooseView' :
                    me.chooseView();
                    break;
                case 'addPoint' :
                    me.addPoint();
                    break;
                case 'clear' :
                    me.clear();
                    break;
                default :
                    log('选中异常！')
            }
        }

    }

    /**
     * get instance
     *
     * @returns {*}
     */
    me.getInstance = function () {
        if (instance === undefined) {
            instance = me;
        }
        return instance;
    };
    return me;
});

