/**
 * 淹没分析
 * @version v1.0 2019/9/17/14:50  Copyright gtmap Corp
 */
define(["knockout",
    "lodash",
    'Cesium',
    "global/utils/MapUtils",
    "global/utils/WidgetUtils"
], function (ko, _, Cesium, MapUtils, WidgetUtils) {
    var date = new Date()
    var instance, me,
        $that = me = {
            viewer: null,
            shadowQueryModel: {
                queryDate: date.getFullYear() + "-" + (date.getMonth() + 1) + "-" + date.getDate(),
                selectStartTime: "10",
                selectEndTime: "16",
                elevation: 20,
                height: 20,
                shadowRatio: "",
                shadowElevation: "",
                longitude: "",
                latitude: "",
            },
            inited: false,
            handlerPolygon: null,
            handlerLeftClick: null,
            shadowQuery: null,
            points: null,
            isShowShadowRatio: false,
            btns: [
                {
                    "id": "startShadowBtn",
                    "icon": "icon-f-editor",
                    "label": "分析"
                },
                {
                    "id": "sunlightEffect",
                    "icon": "icon-f-editor",
                    "label": "日照效果"
                },
                {
                    "id": "clear",
                    "icon": "icon-f-analysis-delete",
                    "label": " 清除"
                },
                {
                    "id": "shadowRatioBtn",
                    "icon": "icon-f-editor",
                    "label": " 阴影率"
                }
            ],

            // init fun
            init: function () {

                window.viewer = MapUtils.viewer;
                $that.viewer = MapUtils.viewer;
                $that._initLayui();
                var scene = $that.viewer.scene;
                var widget = $that.viewer.cesiumWidget;
                if (!scene.pickPositionSupported) {
                    var title = '不支持深度纹理,阴影分析功能无法使用（无法添加观测）！';
                    widget.showErrorPanel(title, undefined, e);
                    // error('不支持深度纹理,可视域分析功能无法使用（无法添加观测）！');
                }

                $that._initShadowQuery(scene)
                // $that.onlineDataOnLoad(scene);

            },

            _initShadowQuery: function (scene) {
                var layers = WidgetUtils.getModelLyrs();
                $that.viewer.shadows = true;
                layers.forEach(function (value) {
                    value.modelLayerDetails.shadowType = 2
                });
                var shadowQuery = new Cesium.ShadowQueryPoints(scene);
                $that.shadowQuery = shadowQuery;
                shadowQuery.build();

                var initTime = new Date($that.shadowQueryModel.queryDate);
                initTime.setHours(Number($that.shadowQueryModel.selectEndTime));

                $that.setCurrentTime(initTime);
                var handlerPolygon = new Cesium.DrawHandler(viewer, Cesium.DrawMode.Polygon, 0);
                $that.handlerPolygon = handlerPolygon;
                var points = [];
                $that.points = points;
                handlerPolygon.drawEvt.addEventListener(function (result) {
                    WidgetUtils.mouseMoveMsg(true);
                    points.length = 0;
                    var polygon = result.object;
                    if (!polygon) {
                        return;
                    }
                    polygon.show = false;
                    handlerPolygon.polyline.show = false;
                    var positions = [].concat(polygon.positions);
                    positions = Cesium.arrayRemoveDuplicates(positions, Cesium.Cartesian3.equalsEpsilon);
                    //遍历多边形，取出所有点
                    for (var i = 0, len = positions.length; i < len; i++) {
                        //转化为经纬度，并加入至临时数组
                        var cartographic = Cesium.Cartographic.fromCartesian(polygon.positions[i]);
                        var longitude = Cesium.Math.toDegrees(cartographic.longitude);
                        var latitude = Cesium.Math.toDegrees(cartographic.latitude);
                        points.push(longitude);
                        points.push(latitude);
                    }
                    //设置分析对象的开始结束时间
                    var dateValue = $("#analysisDate").val();
                    var startTime = new Date(dateValue);
                    startTime.setHours(Number($("#startHour").val()));
                    shadowQuery.startTime = Cesium.JulianDate.fromDate(startTime);

                    var endTime = new Date(dateValue);
                    endTime.setHours(Number($("#endHour").val()));
                    shadowQuery.endTime = Cesium.JulianDate.fromDate(endTime);

                    //设置当前时间
                    $that.setCurrentTime(endTime);

                    shadowQuery.spacing = 10;
                    shadowQuery.timeInterval = 60;

                    //设置分析区域、底部高程和拉伸高度
                    var bh = Number($that.shadowQueryModel.elevation);
                    var eh = Number($that.shadowQueryModel.height);
                    shadowQuery.qureyRegion({
                        position: points,
                        bottom: bh,
                        extend: eh
                    });
                });
            },
            setCurrentTime: function (endTime) {
                // var endTime = new Date(queryDate);
                // endTime.setHours(Number(selectEndTime));
                $that.viewer.clock.currentTime = Cesium.JulianDate.fromDate(endTime);
                $that.viewer.clock.multiplier = 1;
                $that.viewer.clock.shouldAnimate = true;
            },
            _initLayui: function () {
                layui.use(['form', 'layedit', 'laydate'], function () {
                    var form = layui.form
                        , laydate = layui.laydate;
                    form.render();
                    //日期
                    laydate.render({
                        elem: '#analysisDate'
                    });


                    form.on('select(endHour)', function (data) {
                        //这里做自己想做的事情
                        $that.viewer.entities.removeAll();
                        var endTime = new Date($("#analysisDate").val());
                        endTime.setHours(Number(data.value));
                        $that.shadowQuery.endTime = Cesium.JulianDate.fromDate(endTime);
                        $that.setCurrentTime(endTime);
                        //最后再渲染一次
                        form.render('select');//select是固定写法 不是选择器
                    });


                    form.on('select(startHour)', function (data) {
                        //这里做自己想做的事情
                        $that.viewer.entities.removeAll();
                        var startTime = new Date($("#analysisDate").val());
                        startTime.setHours(Number(data.value));
                        $that.shadowQuery.startTime = Cesium.JulianDate.fromDate(startTime);
                        //最后再渲染一次
                        form.render('select');//select是固定写法 不是选择器
                    });


                    $('#elevation').change(function () {
                        var bh = Number($that.shadowQueryModel.elevation);
                        var eh = Number($that.shadowQueryModel.height);
                        $that.shadowQuery.qureyRegion({
                            position: $that.points,
                            bottom: bh,
                            extend: eh
                        });
                    });

                    $('#height').change(function () {
                        var bh = Number($that.shadowQueryModel.elevation);
                        var eh = Number($that.shadowQueryModel.height);
                        $that.shadowQuery.qureyRegion({
                            position: $that.points,
                            bottom: bh,
                            extend: eh
                        });
                    });

                });
            },

            startShadow: function () {
                $('.shadowRatio').hide();
                $('#shadowRatio').val('');
                $('#longitude').val('');
                $('#latitude').val('');
                $('#shadowElevation').val('');
                WidgetUtils.mouseMoveMsg(false, '点击绘制阴影分析区域,右键结束');
                $that.handlerPolygon.deactivate();
                $that.handlerPolygon.activate();
            },
            sunlightEffect: function () {

                var dateVal = $("#analysisDate").val();
                var startTime = new Date(dateVal);
                var endTime = new Date(dateVal);
                var shour = Number($("#startHour").val());
                var ehour = Number($("#endHour").val());

                if (shour > ehour) {
                    return;
                }

                $that.shadowQuery.qureyRegion({
                    position: [0, 0],
                    bottom: 0,
                    extend: 0
                });

                var nTimer = 0.0;
                var nIntervId = setInterval(function () {
                    if (shour < ehour) {
                        startTime.setHours(shour);
                        startTime.setMinutes(nTimer);
                        viewer.clock.currentTime = Cesium.JulianDate.fromDate(startTime);
                        nTimer += 10.0;
                        if (nTimer > 60.0) {
                            shour += 1.0;
                            nTimer = 0.0;
                        }
                    } else {
                        clearInterval(nIntervId);
                        $that.shadowQuery.qureyRegion({
                            position: points,
                            bottom: Number($that.shadowQueryModel.elevation),
                            extend: Number($that.shadowQueryModel.height)
                        });
                    }
                }, 20);

            },

            shadowRatioAnalysis: function () {
                $('.shadowRatio').show();
                $('#shadowRatio').val('');
                $('#longitude').val('');
                $('#latitude').val('');
                $('#shadowElevation').val('');

                var handler = new Cesium.ScreenSpaceEventHandler($that.viewer.scene.canvas);
                if ($that.handlerLeftClick) {
                    $that.handlerLeftClick.destroy()
                }
                $that.handlerLeftClick = handler
                handler.setInputAction(function (e) {

                    var position1 = $that.viewer.scene.pickPosition(e.position);
                    var cartographic = Cesium.Cartographic.fromCartesian(position1);
                    var shadowRadio = $that.shadowQuery.getShadowRadio(cartographic);
                    var longitude = Cesium.Math.toDegrees(cartographic.longitude);
                    var latitude = Cesium.Math.toDegrees(cartographic.latitude);
                    var height = cartographic.height;
                    $that.viewer.entities.removeAll();

                    if (shadowRadio != -1) {

                        // $that.shadowQueryModel.shadowRatio=shadowRadio;
                        // $that.shadowQueryModel.shadowElevation=height;
                        // $that.shadowQueryModel.longitude=longitude;
                        // $that.shadowQueryModel.latitude=latitude;

                        $('#shadowRatio').val(shadowRadio);
                        $('#longitude').val(longitude);
                        $('#latitude').val(latitude);
                        $('#shadowElevation').val(height);

                        $that.viewer.entities.add(new Cesium.Entity({
                            point: new Cesium.PointGraphics({
                                color: new Cesium.Color(1, 0, 0, 0.5),
                                pixelSize: 15

                            }),
                            position: Cesium.Cartesian3.fromDegrees(longitude, latitude, height + 0.5)
                        }));
                    } else {
                        // $that.shadowQueryModel.shadowRatio="";
                        // $that.shadowQueryModel.shadowElevation="";
                        // $that.shadowQueryModel.longitude="";
                        // $that.shadowQueryModel.latitude="";

                        $('#shadowRatio').val('');
                        $('#longitude').val('');
                        $('#latitude').val('');
                        $('#shadowElevation').val('');
                    }
                }, Cesium.ScreenSpaceEventType.LEFT_CLICK);
            },

            // open event
            onOpen: function () {
                var layers = WidgetUtils.getModelLyrs();
                layers.forEach(function (value) {
                    value.modelLayerDetails.shadowType = 2
                });
                $that.clear();
            },
            _restoreDefault: function () {
                if ($that.shadowQuery) {
                    $that.shadowQuery.destroy()
                }
                var layers = WidgetUtils.getModelLyrs()
                $that.viewer.shadows = false;
                layers.forEach(function (value) {
                    value.modelLayerDetails.shadowType = 0
                })
            },
            // close event
            onPause: function () {
                //$that._restoreDefault()
                $that.clear();
            },
            onClose: function () {
                //$that._restoreDefault()
                $that.clear();
            },
            clear: function () {
                WidgetUtils.mouseMoveMsg(true);
                if ($that.handlerPolygon) {
                    $that.handlerPolygon.deactivate();
                    if ($that.handlerPolygon.polygon) {
                        $that.handlerPolygon.polygon.show = false;
                        $that.handlerPolygon.polyline.show = false;
                    }

                }
                if ($that.shadowQuery) {
                    $that.shadowQuery.qureyRegion({
                        position: [0, 0],
                        bottom: 0,
                        extend: 0
                    });
                }

                if ($that.handlerLeftClick) {
                    $that.handlerLeftClick.destroy()
                }
                $that.viewer.entities.removeAll();
                $("#analysisDate").val(date.getFullYear() + "-" + (date.getMonth() + 1) + "-" + date.getDate());
                $("#startHour").val("10")
                $("#endHour").val("16")
                $("#elevation").val("20")
                $("#height").val("20")
                $('.shadowRatio').hide();
                $('#shadowRatio').val('');
                $('#longitude').val('');
                $('#latitude').val('');
                $('#shadowElevation').val('');
            },

        };


    ko.applyBindings(new ShadowQuery(), document.getElementById("shadowQuery"));

    /**
     * 初始化btn
     * @constructor
     */
    function ShadowQuery() {
        var self = this;
        // 开始和清除按钮
        self.shadowQueryBtns = ko.observableArray(me.btns);
        // self.queryModel = ko.observable(me.shadowQueryModel);
        self.queryModel = me.shadowQueryModel;

        self.isShowShadowRatio = ko.observable(me.isShowShadowRatio);
        // btn点击
        self.activeBtn = function (btn) {
            if (btn.id === "startShadowBtn") {
                me.startShadow()
            } else if (btn.id === "clear") {
                me.clear()
            } else if (btn.id === "sunlightEffect") {
                me.sunlightEffect()
            } else if (btn.id === "shadowRatioBtn") {
                me.shadowRatioAnalysis()
            }


            // _.isEqual(btn.id, 'startShadowBtn') ? me.chooseView() : me.clear();
        }
    }

    /**
     * get instance
     *
     * @returns {*}
     */
    me.getInstance = function () {
        if (instance === undefined) {
            instance = me;
        }
        return instance;
    };
    return me;
});