/**
 * 剖面分析
 * @author by <a href="mailto:chaomashi@gmail.com">Du</a>
 * @version v1.0 2019/2/25/15:09  Copyright gtmap Corp
 */

define(['knockout',
    'lodash',
    'Cesium',
    "global/utils/MapUtils",
    "global/utils/WidgetUtils"
], function (
    ko,
    _,
    Cesium,
    MapUtils,
    WidgetUtils
) {
    var instance,
        $that,
        me = {
            viewer:null,
            inited:false,
            btns: [
                {
                    "id": "chooseView",
                    "icon": "icon-f-editor",
                    "label": "分析"
                },
                {
                    "id": "clear",
                    "icon": "icon-f-analysis-delete",
                    "label": "清除"
                }
            ],

            handlerLine: '',

            // init fun
            init: function () {
                $that = this;
                this.viewer = MapUtils.viewer;
                var scene =this.viewer  .scene;
                this.handlerLine = new Cesium.DrawHandler(this.viewer, Cesium.DrawMode.Line);
                this.drawMouseEvent(this.viewer, this.handlerLine);
                this.drawLineCompletedEvent(this.viewer.scene);
                this.inited =true;
            },

            // open event
            onOpen: function () {

            },

            // close event
            onPause: function () {

            },

            // close event
            onClose: function () {
                $that.clear();
            },

            // 绘制鼠标监听事件
            drawMouseEvent: function (viewer, handlerLine) {
                handlerLine.activeEvt.addEventListener(function (isActive) {
                    if (isActive) {
                        viewer.enableCursorStyle = false;
                        viewer._element.style.cursor = '';
                    } else {
                        viewer.enableCursorStyle = true;
                    }
                });


            },

            // 绘制图形
            drawLineCompletedEvent: function (scene) {
                var profile = new Cesium.Profile(scene);
                this.handlerLine.drawEvt.addEventListener(function (result) {
                    var line = result.object,
                        startPoint = line._positions[0],
                        endPoint = line._positions[line._positions.length - 1];

                    //设置坡面分析的开始和结束位置
                    profile = _.assign(profile, {
                        startPoint: MapUtils.cartesianToDegrees(startPoint),
                        endPoint: MapUtils.cartesianToDegrees(endPoint),
                        extendHeight: 40
                    });

                    //分析完毕的回调函数
                    profile.getBuffer(function (buffer) {
                        var canvas = document.getElementById("profilePane");
                        canvas.height = profile._textureHeight;
                        canvas.width = profile._textureWidth;

                        // canvas.height = 350;
                        // canvas.width = 400;
                        var ctx = canvas.getContext("2d");
                        var imgData = ctx.createImageData(profile._textureWidth, profile._textureHeight);
                        imgData.data.set(buffer);
                        //在canvas上绘制图片
                        ctx.putImageData(imgData, 0, 0);
                        $(".profile-show-pane").show();
                    });

                    profile.build();
                });
            },

            // 选择可视域范围
            chooseView: function () {
                //先清除之前绘制的线
                if (!_.isEqual($that.handlerLine, '')) {
                    $that.handlerLine.clear();
                }
                WidgetUtils.mouseMoveMsg(false, '点击绘制分析起点,再次单击结束');
                var handler = new Cesium.ScreenSpaceEventHandler($that.viewer.scene.canvas);

                if ($that.handlerLine.active) {
                    return;
                } else {
                    $that.handlerLine.activate();
                    // 由于剖面分析只能绘制直线，此处绘制时单击两次就触发结束事件
                    handler.setInputAction(function (e) {
                        if (_.isEqual($that.handlerLine.polyline._actualPositions.length, 2)) {
                            $that.handlerLine.drawEvt.raiseEvent({
                                object: $that.handlerLine.polyline
                            });
                            $that.handlerLine.deactivate();
                            handler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_CLICK);
                            WidgetUtils.mouseMoveMsg(true);
                        }
                    }, Cesium.ScreenSpaceEventType.LEFT_CLICK);

                    handler.setInputAction(function (e) {
                        WidgetUtils.mouseMoveMsg(true);
                        $that.handlerLine.deactivate();
                        handler.removeInputAction(Cesium.ScreenSpaceEventType.RIGHT_CLICK);
                    }, Cesium.ScreenSpaceEventType.RIGHT_CLICK);
                }
            },

            // 清空绘制图形
            clear: function () {
                $that.handlerLine.clear();
                $(".profile-show-pane").hide();
                WidgetUtils.mouseMoveMsg(true);
            }
        };


    ko.applyBindings(new ProfileAnalytic(), document.getElementById("profileAnalytic"));


    /**
     * 初始化btn
     * @constructor
     */
    function ProfileAnalytic() {
        var self = this;
        // 清除和点击按钮
        self.profileBtns = ko.observableArray(me.btns);
        // btn点击
        self.activeBtn = function (btn) {
            _.isEqual(btn.id, 'chooseView') ? me.chooseView() : me.clear();
        }

    }

    /**
     * get instance
     *
     * @returns {*}
     */
    me.getInstance = function () {
        if (instance === undefined) {
            instance = me;
        }
        return instance;
    };
    return me;
});