define([
    "global/core/EventBus",
    "global/core/Model",
    "global/utils/MapUtils",
    "global/utils/WidgetUtils",
    "global/widgets/aysSearch/Index",
    "global/widgets/dataViews/upload"
], function (EventBus, model, MapUtils, WidgetUtils, aysSearch, Upload) {
    var instance,
        oriEntity,
        fwEntity,
        me,
        $that = me = {

            params: "",
            paramshs: "",
            btType: "",
            upfile: "",
            bdstate: "",
            layerIndex_wait: "",
            drawjson: "",
            sjccid: "",

            sideLen1: "1",
            pjdy1: "square",
            fxxzqName1: "xzq_e_2017",
            fxxzqdm1: "",
            fxType1: "shp",
            fxLayer1: "",
            resultInstanceId: "51ad9f17-2091-43fc-abdb-13169e650d00",
            resultTableName: "",
            resultRequestUrl: "http://192.168.18.126:10002/mdb/v1/datastore/featuresbyname",
            workFlowBaseUrl: "http://192.168.90.71:8888",
            workFlowExamineBaseUrl: "http://192.168.2.55:8100",
            workFlowModelId: "FZPT5Sh5btmnzsZn",
            livyServer: "http://192.168.18.131:8998",


            // init fun
            init: function () {
                $that.resultInstanceId=this.config.resultInstanceId;
                $that.resultRequestUrl=this.config.resultRequestUrl;
                $that.workFlowBaseUrl=this.config.workFlowBaseUrl;
                $that.workFlowExamineBaseUrl=this.config.workFlowExamineBaseUrl;
                $that.workFlowModelId=this.config.workFlowModelId;
                $that.livyServer=this.config.livyServer;
                $that._initLayui(this.config.xzq);
                layui.form.render();
                $that._initClick();
            },

            // open event
            onOpen: function () {
                aysSearch.analysisDivInit();
                aysSearch.analysisDivOpen("#jtgx-analysis");

                $('#div-sjsq').show();
                $('#div-tbs-jtgx').hide();
                $('#div-jgbm').hide();
                $('#download-jtgx').hide();
                $('#btBefor').hide();
                $('#btNext').show();
                $('#btReset').hide();
                $('#btOK').hide();
                $('#btn-save-jtgx').hide();
                $('#div-savedialog-jtgx').hide();
                $that.resultTableName = "";
            },

            // close event
            onClose: function () {
                aysSearch.analysisDivClose();
                MapUtils.viewer.dataSources.removeAll();
            },

            // pause event
            onPause: function () {
                aysSearch.analysisDivClose();
                MapUtils.viewer.dataSources.removeAll();
            },

            // 初始化layui
            _initLayui: function (config) {

                aysSearch.analysisDivOpen("#jtgx-analysis");
                aysSearch.analysisDiv("ays4", config);

                EventBus.listener("ays4Analysis_file", function (e, data) {
                    $that.upfile = data;
                });

                EventBus.listener("ays4Store", function (e, data) {
                    $that.vargeojson = data;
                });

                EventBus.listener("ays4sideLen", function (e, data) {
                    $that.sideLen1 = data;
                });

                EventBus.listener("ays4pjdy", function (e, data) {
                    $that.pjdy1 = data;
                });

                EventBus.listener("ays4fxxzqName", function (e, data) {
                    $that.fxxzqName1 = data;
                });

                EventBus.listener("ays4fxxzqdm", function (e, data) {
                    $that.fxxzqdm1 = data;
                });

                EventBus.listener("ays4fxType", function (e, data) {
                    $that.fxType1 = data;
                });

                EventBus.listener("ays4fxLayer", function (e, data) {
                    $that.fxLayer1 = data;
                });

                layui.config({
                    base: './js/'
                }).use(['element', 'upload', 'layer', 'table', 'form'], function () {
                    var $ = layui.jquery;
                    var table = layui.table;
                    var form = layui.form;
                    var layer = layui.layer;
                    var upload = layui.upload;

                    var tableId = [], layerIndex_download;

                    table.render({
                        elem: '#gxTable',
                        title: "评价因子表",
                        id: 'table-gx',
                        cols: [[
                            {field: 'ck', type: 'checkbox'}
                            , {field: 'pjdy', title: '评价因子'}
                            , {field: 'start', title: '区间最小值', edit: 'text'}
                            , {field: 'end', title: '区间最大值', edit: 'text'}
                            , {field: 'fz', title: '分值', edit: 'text'}
                        ]],
                        data: [
                            {
                                LAY_CHECKED: true,
                                ck: "",
                                pjdy: "机场",
                                start: "0",
                                end: "30",
                                fz: "5"
                            }, {
                                LAY_CHECKED: true,
                                ck: "",
                                pjdy: "机场",
                                start: "30",
                                end: "90",
                                fz: "4"
                            }, {
                                LAY_CHECKED: true,
                                ck: "",
                                pjdy: "机场",
                                start: "90",
                                end: "150",
                                fz: "3"
                            }, {
                                LAY_CHECKED: true,
                                ck: "",
                                pjdy: "机场",
                                start: "150",
                                end: "",
                                fz: "0"
                            },
                            {
                                LAY_CHECKED: true,
                                ck: "",
                                pjdy: "港口",
                                start: "0",
                                end: "30",
                                fz: "4"
                            }, {
                                LAY_CHECKED: true,
                                ck: "",
                                pjdy: "港口",
                                start: "30",
                                end: "60",
                                fz: "3"
                            }, {
                                LAY_CHECKED: true,
                                ck: "",
                                pjdy: "港口",
                                start: "60",
                                end: "",
                                fz: "0"
                            },
                            {
                                LAY_CHECKED: true,
                                ck: "",
                                pjdy: "铁路",
                                start: "0",
                                end: "3",
                                fz: "5"
                            }, {
                                LAY_CHECKED: true,
                                ck: "",
                                pjdy: "铁路",
                                start: "3",
                                end: "6",
                                fz: "4"
                            }, {
                                LAY_CHECKED: true,
                                ck: "",
                                pjdy: "铁路",
                                start: "6",
                                end: "",
                                fz: "0"
                            },
                            {
                                LAY_CHECKED: false,
                                ck: "",
                                pjdy: "国道",
                                start: "0",
                                end: "3",
                                fz: "4"
                            }, {
                                LAY_CHECKED: false,
                                ck: "",
                                pjdy: "国道",
                                start: "3",
                                end: "6",
                                fz: "3"
                            }, {
                                LAY_CHECKED: false,
                                ck: "",
                                pjdy: "国道",
                                start: "6",
                                end: "",
                                fz: "0"
                            }, {
                                LAY_CHECKED: false,
                                ck: "",
                                pjdy: "省道",
                                start: "0",
                                end: "3",
                                fz: "3"
                            }, {
                                LAY_CHECKED: false,
                                ck: "",
                                pjdy: "省道",
                                start: "3",
                                end: "6",
                                fz: "2"
                            }, {
                                LAY_CHECKED: false,
                                ck: "",
                                pjdy: "省道",
                                start: "6",
                                end: "",
                                fz: "0"
                            }, {
                                LAY_CHECKED: false,
                                ck: "",
                                pjdy: "县道",
                                start: "0",
                                end: "3",
                                fz: "2"
                            }, {
                                LAY_CHECKED: false,
                                ck: "",
                                pjdy: "县道",
                                start: "3",
                                end: "6",
                                fz: "1"
                            }, {
                                LAY_CHECKED: false,
                                ck: "",
                                pjdy: "县道",
                                start: "6",
                                end: "",
                                fz: "0"
                            }, {
                                LAY_CHECKED: false,
                                ck: "",
                                pjdy: "乡道",
                                start: "0",
                                end: "3",
                                fz: "1"
                            }, {
                                LAY_CHECKED: false,
                                ck: "",
                                pjdy: "乡道",
                                start: "3",
                                end: "",
                                fz: "0"
                            }

                        ],
                        limit: Number.MAX_VALUE,
                        done: function (res, curr, count) {

                            $that.params = res.data;

                            $that._tbmerge(0, 0, 4);
                            $that._tbmerge(1, 0, 4);

                            $that._tbmerge(0, 4, 3);
                            $that._tbmerge(1, 4, 3);

                            $that._tbmerge(0, 7, 3);
                            $that._tbmerge(1, 7, 3);

                            $that._tbmerge(0, 10, 3);
                            $that._tbmerge(1, 10, 3);

                            $that._tbmerge(0, 13, 3);
                            $that._tbmerge(1, 13, 3);

                            $that._tbmerge(0, 16, 3);
                            $that._tbmerge(1, 16, 3);


                            $that._tbmerge(0, 19, 2);
                            $that._tbmerge(1, 19, 2);

                        }
                    });

                    table.render({
                        elem: '#hsTable',
                        title: "评价函数表",
                        // skin: 'line',
                        // even: true,
                        id: 'table-hs',
                        cols: [[
                            {field: 'pjdy', title: '指标评价'}
                            , {field: 'start', title: '评价系数', edit: 'text'}
                            , {field: 'end', title: '评价系数', edit: 'text'}
                            , {field: 'fz', title: '评价值', edit: 'text'}
                        ]],
                        data: [
                            {
                                // LAY_CHECKED: true,
                                // ck: "",
                                pjdy: "评价函数",
                                start: "0",
                                end: "0.25",
                                fz: "1"
                            }, {
                                // LAY_CHECKED: true,
                                // ck: "",
                                pjdy: "评价函数",
                                start: "0.25",
                                end: "0.5",
                                fz: "2"
                            }, {
                                // LAY_CHECKED: true,
                                // ck: "",
                                pjdy: "评价函数",
                                start: "0.5",
                                end: "0.75",
                                fz: "3"
                            }, {
                                // LAY_CHECKED: true,
                                // ck: "",
                                pjdy: "评价函数",
                                start: "0.75",
                                end: "1",
                                fz: "4"
                            }
                        ],
                        limit: Number.MAX_VALUE,
                        done: function (res, curr, count) {
                            $that.paramshs = res.data;
                            $that._tbmerge(0, 21, 4);
                        }
                    });

                    table.on('edit(gxTable)', function (obj) {
                        $that.params = table.cache['gxTable'];
                    });

                    table.on('edit(hsTable)', function (obj) {
                        $that.paramshs = table.cache['hsTable'];
                    });

                    //监听数据时期选择
                    form.on('select(sjsqfilter)', function (data) {
                        $that._initTableName();
                    });


                    $(document).on('click', '#btOK', function (evt) {

                        if ($that.fxType1 === "shp" && $that.upfile === null) {
                            layer.msg("请选择评价范围数据SHP包！");
                            return false;
                        }

                        $that._initTableName();
                        $that.btType = "SUBMIT";
                        _kjAnalysis();
                        return false;
                    });

                    $(document).on('click', '#btDO', function (evt) {
                        return false;
                    });

                    $(document).on('click', '#btReset', function (evt) {
                        aysSearch.clearAll();

                        document.getElementById('input-pjdylen').value = "1";

                        document.getElementById("div-store").style.display = "none";

                        document.getElementById("div-jgbm").style.display = "none";
                    });

                    EventBus.listener("jtgxDrawResult", function (e, data) {
                        $that.drawjson = JSON.stringify(data);
                    });

                    //结果表名保存
                    $(document).on('click', '#btTbSave-jt', function (evt) {
                        var info = "{tableName:'" + document.getElementById('input-name-jtgx').value + "'}";
                        $.ajax({
                            type: 'POST',
                            url: '/metainfo/edit',
                            data: {
                                id: $that.sjccid,
                                info: info,
                            },
                            success: function (msg) {
                                layer.msg("保存成功！");
                            },
                            error: function (e, state, errorThrown) {
                                console.log(e);
                            }
                        });
                        return false;
                    });
                    //申请下载弹窗
                    $(document).on('click', '#download-jtgx', function (evt) {
                        var $divDownload = $('#div-download-jt');
                        layer.close(layerIndex_download);
                        layerIndex_download = layer.open({
                            title: '提交申请',
                            shade: 0,
                            shadeClose: true,
                            type: 1,
                            area: ['500px', '360px'],
                            content: $divDownload.html(),
                        });
                        return false;
                    });
                    //申请下载弹窗中保存按钮
                    $(document).on('click', '#btn-download-jt', function () {
                        tableId.push($that.sjccid);
                        $.ajax({
                            type: 'post',
                            url: '/overlay/apply',
                            data: {
                                "id": JSON.stringify(tableId),
                                "reason": $('.text-reason').val(),
                            }
                        }).then(
                            function (obj) {
                                layer.msg('已成功提交申请，等待审核后可在数据治理中心下载！');
                            },
                            function (obj) {
                                layer.msg('提交申请失败！');
                            }
                        )
                    });

                    function session(id, value) {
                        var result;
                        if (!id) {
                            layer.msg("id is null");
                            throw new Error("id is null");
                        }
                        $.ajax({
                            url: rootPath + "/map/session",
                            async: false,
                            data: {
                                key: id,
                                value: value || ""
                            },
                            success: function (e) {
                                if (e.data && e.data != true) {
                                    result = e.data;
                                }
                            }
                        });
                        return result;
                    }

                    function _kjAnalysis() {
                        var gxjs;
                        var zxjs;
                        var zygk;
                        var ybgk;
                        var tl;
                        var gsgl;
                        var yjgl;
                        var ejgl;
                        var sjgl;
                        var sijgl;
                        var pjhs;

                        gxjs = $that._getTbjson("gxTable", 0, 4);
                        zygk = $that._getTbjson("gxTable", 4, 3);
                        tl = $that._getTbjson("gxTable", 7, 3);
                        yjgl = $that._getTbjson("gxTable", 10, 3);
                        ejgl = $that._getTbjson("gxTable", 13, 3);
                        sjgl = $that._getTbjson("gxTable", 16, 3);
                        sijgl = $that._getTbjson("gxTable", 19, 2);

                        pjhs = $that._getTbjson("hsTable", 0, 4);

                        var jslist = {};
                        jslist.gxjc = gxjs;
                        jslist.zxjc = zxjs;
                        jslist.zygk = zygk;
                        jslist.ybgk = ybgk;
                        jslist.tl = tl;
                        jslist.gsgl = gsgl;
                        jslist.yjgl = yjgl;
                        jslist.ejgl = ejgl;
                        jslist.sjgl = sjgl;
                        jslist.sijgl = sijgl;
                        jslist.pf = pjhs;
                        jslist.id = "4028e4c26be4ff77016be50bbb800001";
                        jslist.table = document.getElementById('input-name-jtgx').alias;
                        jslist.sideLen = $that.sideLen1;
                        jslist.pjdy = $that.pjdy1;
                        jslist.xzqName = $that.fxxzqName1;
                        jslist.xzqdm = $that.fxxzqdm1;
                        var jspara = JSON.stringify(jslist);

                        var sType = $that.fxType1;
                        var layernm = $that.fxLayer1;

                        var params = {};

                        params["layerName"] = $that.vargeojson;

                        params["jspara"] = jspara;
                        params["server"] = $that.livyServer;

                        $that.layerIndex_wait = layer.msg("分析进行中...", {
                            icon: 16,
                            shade: [0.5, '#f5f5f5'],
                            scrollbar: false,
                            offset: 'auto',
                            time: 10000000
                        });

                        showLoading();
                        // debugger
                        var idValue = session("jtgx");
                        if (idValue) {
                            params.id = idValue * 1;
                        }
                        $.ajax({
                            type: "POST",
                            url: $that.workFlowBaseUrl + "/mso/workflow/process/" + $that.workFlowModelId,
                            contentType: "application/json",
                            data: JSON.stringify(params),
                            dataType: "json",
                            success: function (data) {
                                pollRequest(data.workflowInstanceKey, document.getElementById('input-name-jtgx').alias)
                                layer.msg("分析任务提交成功");
                            },
                            error: function (err) {
                                closeLoading();
                                layer.msg("分析任务提交失败");
                                console.log(err);
                            }
                        });

                    };

                    function pollRequest(id, tableName) {
                        var interval = setInterval(function () {
                            $.post({
                                url: $that.workFlowExamineBaseUrl + "/define/api/activity-instances",
                                type: "POST",
                                contentType: "application/json",
                                data: JSON.stringify({workflowInstanceId: id}),
                                success: function (data) {
                                    if (data.children && data.children.length > 0) {
                                        console.log(data);
                                        var data = data.children[data.children.length - 1];
                                        if (data.state != "COMPLETED" && data.state != "ACTIVE") {
                                            layer.msg("任务失败!");
                                            closeLoading();
                                            clearInterval(interval);
                                            return;
                                        } else if (data.state == "COMPLETED" && data.type == "END_EVENT") {
                                            //请求数据
                                            getTaskData(id, tableName);
                                            clearInterval(interval);
                                        }
                                    }
                                }
                            });
                        }, 1000);
                    }

                    function getTaskData(instanceKey, tableName) {
                        // debugger
                        $.ajax({
                            url: $that.resultRequestUrl,
                            data: {
                                instanceId: $that.resultInstanceId,
                                tableName: tableName,
                            },
                            success: function (data) {
                                var tmp = {};
                                tmp.type = "FeatureCollection";
                                tmp.features = data;
                                // model._option.clampToGround = true;
                                model._option.prop = "sum";
                                model.addModel(tmp, "geojson");
                                // debugger
                                $.ajax({
                                    url: $that.workFlowExamineBaseUrl + "/define/api/workflow-instances/" + instanceKey + "/variables",
                                    success: function (data) {
                                        if (data instanceof Array) {
                                            $(data).map(function (i, v) {
                                                if (v.name == "id") {
                                                    session("jtgx", v.value);
                                                }
                                            })
                                        }
                                    }

                                });
                                $that.resultTableName = tableName;
                                $("#btn-save-jtgx").show();
                            },
                            complete: function () {
                                closeLoading();
                            }
                        })
                    }

                    /**
                     * 显示保存操作按钮及默认表名生成
                     */
                    $('#btn-save-jtgx').click(function () {
                        var now = new Date();
                        $('#div-savedialog-jtgx').show();
                        $('#input-alisaName-jtgx').val("交通干线分析_" + now.getFullYear().toString() + (now.getMonth() + 1).toString() + now.getDate().toString() + now.getHours().toString() + now.getMinutes().toString() + now.getSeconds().toString());
                    });

                    /**
                     * 执行注册操作
                     */
                    $('#btn-save-execute-jtgx').click(function () {
                        //判断是否已获取表名
                        if ($that.resultTableName.length > 0) {
                            $.ajax({
                                url: rootPath + "/tablesinfo/register",
                                data: {
                                    "id": $that.resultInstanceId,
                                    "layerName": $that.resultTableName,
                                    "moduleCode": "ccglzy",
                                    "moduleName": "仓储管理资源",
                                    "tableName":$('#input-alisaName-jtgx').val()
                                },
                                type: "POST",
                                success: function (data) {
                                    layer.msg("分析结果已保存！");
                                },
                                error: function (err) {
                                    layer.msg("分析结果保存失败！");
                                }
                            })
                        }
                        return false;
                    });

                    function _bindingLayers(elem, url) {
                        var $target = $(elem);
                        $.ajax({
                            url: url,
                            // async: false,
                            success: function (result) {
                                var content = result["data"];
                                var result1 = [];
                                if (content) {
                                    for (var i = 0; i < content.length; i++) {
                                        var item = {};
                                        item.id = content[i].id;
                                        item.name = content[i].tableName;
                                        result1.push(item);
                                    }
                                }

                                var renderData = result1;

                                var option = "";
                                for (var i = 0; i < renderData.length; i++) {
                                    option += "<option value=" + renderData[i].id + ">" + renderData[i].name + "</option>";
                                }
                                $target.html(option);
                                for (var i = 0; i < result.length; i++) {
                                    var id = result[i].id;
                                    $("#" + id).data(result[i]);
                                }

                                form.render('select');
                                layer.close($that.layerIndex_wait);
                                document.getElementById('div-store').style.display = 'block';
                                $that.bdstate = 1;
                            },
                            error: function (e, state, error) {
                                console.log(e);
                            }
                        });
                    }

                })
            },

            // //初始化绑定事件
            // _initBindEvent: function () {
            //
            // },

            // 初始化一些点击事件
            _initClick: function () {
                $(document).on('click', '#btNext', function (evt) {
                    $('#analysis').hide();
                    $('#div-sjsq').hide();
                    $('#div-tbs-jtgx').show();
                    $('#btNext').hide();
                    $('#btBefor').show();
                    $('#btOK').show();
                    if ($that.resultTableName.length > 0) {
                        $('#btn-save-jtgx').show();
                    }

                    document.getElementById("leg").innerHTML = "设置评价因子";
                    return false;
                });

                $(document).on('click', '#btBefor', function (evt) {
                    $('#analysis').show();
                    $('#div-sjsq').show();
                    $('#div-tbs-jtgx').hide();
                    $('#btNext').show();
                    $('#btBefor').hide();
                    $('#btOK').hide();
                    $('#btn-save-jtgx').hide();
                    $('#div-savedialog-jtgx').hide();

                    document.getElementById("leg").innerHTML = "评价范围";
                    return false;
                })

            },

            _tbmerge: function (columsIndex, startIndex, mark) {
                var trArr = $(".layui-table-body>.layui-table").find("tr");//所有行
                var tdPreArr = trArr.eq(startIndex).find("td").eq(columsIndex);//获取相同列的第一列
                tdPreArr.each(function () {//相同列的第一列增加rowspan属性
                    $(this).attr("rowspan", mark);
                });
                for (var i = startIndex + 1; i < mark + startIndex; i++) {
                    var tdCurArr = trArr.eq(i).find("td").eq(columsIndex);//获取当前行的当前列
                    tdCurArr.each(function () {//当前行隐藏
                        $(this).css("display", "none");
                    });
                }
            },

            _getTbjson: function (tableID, startIndex, length) {
                var tbData;
                if (tableID == "gxTable") {
                    tbData = $that.params;
                } else if (tableID = "hsTable") {
                    tbData = $that.paramshs;
                }
                var gxjson = "[";
                for (var i = startIndex; i < length + startIndex; i++) {
                    if (tbData[startIndex].LAY_CHECKED == true) {
                        if (tbData[i].end == "以上" || tbData[i].end == "") {
                            gxjson += "{'score':" + tbData[i].fz + ",'distance1':" + tbData[i].start + ",'distance2':0},";
                        } else {
                            gxjson += "{'score':" + tbData[i].fz + ",'distance1':" + tbData[i].start + ",'distance2':" + tbData[i].end + "},";
                        }
                    } else {
                        if (tbData[i].end == "以上" || tbData[i].end == "") {
                            gxjson += "{'score':0,'distance1':" + tbData[i].start + ",'distance2':0},";
                        } else {
                            gxjson += "{'score':0,'distance1':" + tbData[i].start + ",'distance2':" + tbData[i].end + "},";
                        }
                    }
                }
                if (gxjson.length > 1) {
                    gxjson = gxjson.substr(0, gxjson.length - 1) + "]";
                }
                return gxjson;
            },

            _getDate: function () {
                var now = new Date();
                document.getElementById("input-name-jtgx").value = "JTGX" + now.getFullYear().toString() + (now.getMonth() + 1).toString() + now.getDate().toString() + now.getHours().toString() + now.getMinutes().toString() + now.getSeconds().toString();
            },

            _initTableName: function () {

                var fw = "", fw1 = "";
                if ($that.fxType1 === "shp") {
                    fw = "shp";
                    fw1 = "shp";
                } else if ($that.fxType1 === "sjcc") {
                    fw = "数据仓储";
                    fw1 = "sjcc";
                } else if ($that.fxType1 === "geojson") {
                    fw = "输入图层";
                    fw1 = "geojson";
                }

                var pjdy = "", pjdy8 = "";
                if ($that.pjdy1 === "square") {
                    pjdy = "正方形";
                    pjdy8 = "zfx";
                } else if ($that.pjdy1 === "hexagonal") {
                    pjdy = "蜂窝";
                    pjdy8 = "fw";
                } else if ($that.pjdy1 === "sjxzq") {
                    pjdy = "市级行政区";
                    pjdy8 = "sjxzq";
                } else if ($that.pjdy1 === "xjxzq") {
                    pjdy = "县级级行政区";
                    pjdy8 = "xjxzq";
                } else if ($that.pjdy1 === "xzjxzq") {
                    pjdy = "乡镇级行政区";
                    pjdy8 = "xzjxzq";
                }

                var sjsq = document.getElementById('sjsqSel').value;

                var now = new Date();
                var timevar = now.getFullYear().toString() + (now.getMonth() + 1).toString() + now.getDate().toString() + now.getHours().toString() + now.getMinutes().toString() + now.getSeconds().toString();

                document.getElementById("input-name-jtgx").value = "交通影响_" + fw + "_" + pjdy + "_" + sjsq + "_" + timevar;
                document.getElementById("input-name-jtgx").alias = "jtgx_" + fw1 + "_" + pjdy8 + "_" + timevar;
            }

        };


    var interfaceConfig = WidgetUtils._appConfig.interface,
        parsefile = interfaceConfig.parsefile;

    /**
     * get instance
     *
     * @returns {*}
     */
    me.getInstance = function () {
        if (void 0 === instance) {
            instance = me;
        }
        return instance;
    };
    return me;
});
