define([
    "global/core/EventBus",
    "global/core/Model",
    "global/utils/MapUtils",
    "global/utils/WidgetUtils",
    "global/widgets/aysSearch/Index",
    'global/widgets/dataViews/upload',
    "global/core/GeometryStore"
], function (EventBus, model, MapUtils, WidgetUtils, aysSearch, Upload, geoStore) {
    var instance,
        me,
        oriEntity,
        clipEntity,
        resultEntity,
        $that = me = {
            upfile: "",
            upfile_xj: "",
            layerIndex_wait: "",
            drawjson: "",
            vargeojson: "",
            vargeojson_xj: "",

            // init fun
            init: function () {
                $that._initLayui();
                layui.form.render();
            },

            // open event
            onOpen: function () {
                aysSearch.dataStoreDivInit();
                aysSearch.dataStoreDiv2Init();
                aysSearch.dataStoreDivOpen("#intersect-xj");
                aysSearch.dataStoreDiv2Open("#intersect-mb");
                $("#btn-save-intersect").hide();
            },

            // close event
            onClose: function () {
                aysSearch.dataStoreDivClose();
                aysSearch.dataStoreDiv2Close();
                MapUtils.viewer.dataSources.removeAll();
            },

            // pause event
            onPause: function () {
                aysSearch.dataStoreDivClose();
                aysSearch.dataStoreDiv2Close();
                MapUtils.viewer.dataSources.removeAll();
            },

            // 初始化layui
            _initLayui: function () {
                aysSearch.dataStoreDivOpen("#intersect-xj");
                aysSearch.dataStoreDiv2Open("#intersect-mb");
                aysSearch.dataStoreDiv("ays");

                EventBus.listener("aysStore", function (e, data) {
                    $that.vargeojson_xj = data;
                });

                aysSearch.dataStoreDiv2("ays2");

                EventBus.listener("ays2Store", function (e, data) {
                    $that.vargeojson = data;
                });
                layui.config({
                    base: './js/'
                }).use(['element',  'layer'], function () {
                    var $ = layui.jquery;
                    var layer = layui.layer;


                    var layerIndex_download, resultgeojson, layerIndex_wait,
                        tableId = [];

                    $(document).on('click', '#btOK-xj', function (evt) {
                        if ($that.vargeojson=="") {
                            layer.msg("未获取到目标图形！");
                            return false;
                        }

                        if ($that.vargeojson_xj == "") {
                            layer.msg("未获取到相交图形！");
                            return false;
                        }
                        _kjAnalysis();
                        return false;
                    });

                    $(document).on('click', '#btReset-xj', function (evt) {
                        aysSearch.dataStoreDivInit();
                        aysSearch.dataStoreDiv2Init();
                        aysSearch.dataStoreDivOpen("#intersect-xj");
                        aysSearch.dataStoreDiv2Open("#intersect-mb");
                        $("#btn-save-intersect").hide();
                        aysSearch.clearAll();
                        aysSearch.dataStoreDivClose();
                        aysSearch.dataStoreDiv2Close();
                        MapUtils.viewer.dataSources.removeAll();
                        document.getElementById('input-distance-mb').value = "1";
                        document.getElementById('input-distance-xj').value = "1";
                        return false;
                    });

                    function _kjAnalysis() {
                        showLoading("分析进行中...");
                        var formData1 = new FormData();
                        formData1.append("inputGeometry", $that.vargeojson);
                        formData1.append("overlayGeometry", $that.vargeojson_xj);
                        $.ajax({
                            url: geoselect,
                            type: "POST",
                            contentType: false,
                            processData: false,
                            data: formData1,
                            success: function (result) {
                                if (result.data == null) {
                                    closeLoading();
                                    layer.msg("未得到分析结果！");
                                    return false;
                                }
                                closeLoading();
                                layer.msg("分析完成！");
                                $('#btn-save-intersect').text('结果保存');
                                $('#btn-save-intersect').show();
                                resultgeojson = result.data;
                                try {
                                    resultEntity = aysSearch.geoJsonToMapGroud(result.data.features, {color: new Cesium.Color.fromBytes(255, 175, 151, 255)});
                                    EventBus.trigger("aysResult",resultEntity );
                                } catch (e) {
                                    console.log(e)
                                }
                                return;
                            },
                            error: function (xhr, status, error) {
                                closeLoading();
                                //layer.close($that.layerIndex_wait);
                                layer.msg("分析失败！错误：" + error);
                            }
                        });
                    };

                    $('#btn-save-intersect').click(function () {
                        if ($(this).text().trim() === '结果保存') {
                            //以下注释代码为弹窗显示，现改为直接在界面下方显示
                            // layer.close(layerIndex_download);
                            // layerIndex_download = layer.open({
                            //     title: '分析结果保存',
                            //     shade: 0,
                            //     shadeClose: true,
                            //     type: 1,
                            //     area: ['500px', '220px'],
                            //     content: $('#script-savedialog-intersect').html(),
                            // });
                            $('#div-savedialog-intersect').show();
                            $('#input-alisaName-intersect').val("相交分析_" + new Date().toLocaleDateString().replace(/\//g, ''));

                        } else {
                            var $divDownload = $('#div-download-intersect');
                            layer.close(layerIndex_download);
                            layerIndex_download = layer.open({
                                title: '提交申请',
                                shade: 0,
                                shadeClose: true,
                                type: 1,
                                area: ['500px', '360px'],
                                content: $divDownload.html(),
                            })
                        }
                    });

                    $(document).on('click', '#btn-save-execute-intersect', function () {
                        $.ajax({
                            type: 'post',
                            url: '/overlay/saveResult',
                            data: {
                                "layerName": $('#input-alisaName-intersect').val(),
                                "featureCollection": JSON.stringify(resultgeojson)
                            },
                            beforeSend: function () {
                                showLoading("正在保存结果");
                                /*layerIndex_wait = layer.msg("正在保存结果", {
                                 icon: 16,
                                 shade: [0.5, '#f5f5f5'],
                                 scrollbar: false,
                                 offset: 'auto',
                                 time: 100000
                                 });*/
                            },
                        }).then(
                            function (obj) {
                                if (obj.data) {
                                    tableId.push(obj.data);
                                    layer.msg('保存成功，可在数据治理中心查看！');
                                    $('#div-savedialog-intersect').hide();
                                    $('#btn-save-intersect').text('申请下载');
                                    closeLoading();
                                } else {
                                    layer.msg('保存失败！');
                                    closeLoading();
                                }
                            },
                            function (obj) {
                                layer.msg('保存失败！');
                                closeLoading();
                            }
                        )
                        return false;
                    });

                    $(document).on('click', '#btn-download-intersect', function () {
                        $.ajax({
                            type: 'post',
                            url: '/overlay/apply',
                            data: {
                                "id": JSON.stringify(tableId),
                                "reason": $('.text-reason').val(),
                            }
                        }).then(
                            function (obj) {
                                layer.msg('已成功提交申请，等待审核后可在数据治理中心下载！');
                            },
                            function (obj) {
                                layer.msg('提交申请失败！');
                            }
                        )
                    });
                })
            },

            // 初始化一些点击事件
            _initClick: function () {

            },

        };

    var interfaceConfig = WidgetUtils._appConfig.interface,
        parsefile = interfaceConfig.parsefile,
        buffer = interfaceConfig.buffer,
        geojson = interfaceConfig.geojson,
        geoselect = interfaceConfig.geoselect,
        downloadUrl = interfaceConfig.download;

    var globalUpload = "";

    /**
     * get instance
     *
     * @returns {*}
     */
    me.getInstance = function () {
        if (void 0 === instance) {
            instance = me;
        }
        return instance;
    };
    return me;
});
