define([
    "global/core/EventBus",
    "global/core/Model",
    "global/utils/MapUtils",
    "global/utils/WidgetUtils",
    "global/widgets/aysSearch/Index",
    "global/widgets/dataViews/upload"
], function (EventBus, model,MapUtils, WidgetUtils,aysSearch,Upload) {
    var instance,
        oriEntity,
        fwEntity,
        me,
        $that = me = {
            params: "",
            upfile: "",
            bdstate: "",
            layerIndex_wait: "",
            sjccid: "",

            sideLen1: "1",
            pjdy1: "square",
            fxxzqName1: "xzq_e_2017",
            fxxzqdm1: "",
            fxType1: "shp",
            fxLayer1: "",

            // init fun
            init: function () {
                $that._initLayui(this.config);
                layui.form.render();
                $that._getDate();
                $that._initClick();
            },

            // open event
            onOpen: function () {
                aysSearch.analysisDivInit();
                aysSearch.analysisDivOpen("#ggfwd-analysis");

                $('#input-sjfw-fwd').val('120');
                // $("#poi-school-fwd").attr("checked","true");
                $('#div-poi-fwd').show();
                $('#div-sjfw-fwd').show();
                $('#div-tbs-fwd').hide();
                $('#div-jgbm-fwd').hide();
                $('#download-fwd').hide();
                $('#btBefor-fwd').hide();
                $('#btNext-fwd').show();
                $('#btReset-fwd').hide();
                $('#btOK-fwd').hide();
            },

            // close event
            onClose: function () {
                aysSearch.analysisDivClose();
                MapUtils.viewer.dataSources.removeAll();

                // // EventBus.trigger("ggfwdClear");
                // // model.clear();
                // // MapUtils.viewer.dataSources.removeAll();
                // aysSearch.clearAll();
                //
                // document.getElementById("div-xzq-fwd").style.display = "none";
                //
                // document.getElementById('input-pjdylen-fwd').value = "1";
                // document.getElementById('input-sjfw-fwd').value = "120";
                // // document.getElementById('div-filename-fwd').innerText = "文件名";
                // document.getElementById('radio-shp-fwd').checked = true;
                // document.getElementById('pjdy-zfx-fwd').checked = true;
                // document.getElementById("div-fxfs-fwd").style.display = "block";
                // document.getElementById("div-store-fwd").style.display = "none";
                // document.getElementById("div-shp-fwd").style.display = "block";
                // document.getElementById("div-pjdy-fwd").style.display = "block";
                // document.getElementById("div-poi-fwd").style.display = "block";
                // document.getElementById("div-sjfw-fwd").style.display = "block";
                // document.getElementById("div-speed").style.display = "none";
                // document.getElementById("div-jgbm-fwd").style.display = "none";
                // document.getElementById("btBefor-fwd").style.display = "none";
                // document.getElementById("btNext-fwd").style.display = "inline";
                // document.getElementById("btReset-fwd").style.display = "inline";
                // document.getElementById("btOK-fwd").style.display = "none";
                // document.getElementById("download-fwd").style.display = "none";
                // document.getElementById("btReset-fwd").style.display = "inline";
                // document.getElementById("leg-fwd").innerHTML = "评价范围";
            },

            // pause event
            onPause: function () {
                aysSearch.analysisDivClose();
                MapUtils.viewer.dataSources.removeAll();
            },

            // 初始化layui
            _initLayui: function (config) {
                aysSearch.analysisDivOpen("#ggfwd-analysis");
                aysSearch.analysisDiv("ays12", config);

                EventBus.listener("ays12Analysis_file", function (e, data) {
                    $that.upfile = data;
                });

                EventBus.listener("ays12Store", function (e, data) {
                    $that.vargeojson = data;
                });

                EventBus.listener("ays12sideLen", function (e, data) {
                    $that.sideLen1 = data;
                });

                EventBus.listener("ays12pjdy", function (e, data) {
                    $that.pjdy1 = data;
                });

                EventBus.listener("ays12fxxzqName", function (e, data) {
                    $that.fxxzqName1 = data;
                });

                EventBus.listener("ays12fxxzqdm", function (e, data) {
                    $that.fxxzqdm1 = data;
                });

                EventBus.listener("ays12fxType", function (e, data) {
                    $that.fxType1 = data;
                });

                EventBus.listener("ays12fxLayer", function (e, data) {
                    $that.fxLayer1 = data;
                });

                layui.config({
                    base: './js/'
                }).use(['element', 'upload', 'layer', 'table', 'form'], function () {
                    var $ = layui.jquery;
                    var table = layui.table;
                    var form = layui.form;
                    var layer = layui.layer;
                    var upload = layui.upload;

                    var tableId = [], layerIndex_download;

                    // $("#btn-shp-fwd-input").on('change', function (e) {
                    //     $that.upfile = $("#btn-shp-fwd-input")[0].files[0];
                    //
                    //     Upload.loadFile($(this), "btn-shp-fwd-input", function (result, result1) {
                    //         if (typeof result == "string") {
                    //             result = JSON.parse(result);
                    //         }
                    //         if (!result.value) {
                    //             layer.msg("未得到SHP解析数据！");
                    //             return false;
                    //         }
                    //
                    //         aysSearch._removeEntity(oriEntity);
                    //         aysSearch._removeEntity(fwEntity);
                    //         try {
                    //             oriEntity = aysSearch.geoJsonToMapGroud(result.value.features, {color: Cesium.Color.LIGHTSKYBLUE});
                    //         } catch (e) {
                    //             console.log(e)
                    //         }
                    //     });
                    // });
                    //
                    // // globalUpload = upload.render({
                    // //     elem: '#btn-shp-fwd'
                    // //     , url: rootPath + "/common/upload"
                    // //     , auto: false
                    // //     , exts: 'zip'
                    // //     , accept: 'file'
                    // //     //,multiple: true
                    // //     , bindAction: '#btupload1-fwd'
                    // //     , choose: function (obj) {
                    // //         obj.preview(function (index, file, result) {
                    // //             $that.upfile = file;
                    // //
                    // //             // document.getElementById('div-filename-fwd').innerText = file.name;
                    // //
                    // //             var formData = new FormData();
                    // //             formData.append("file", file);
                    // //             $.ajax({
                    // //                 url: parsefile,
                    // //                 type: "POST",
                    // //                 contentType: false,
                    // //                 processData: false,
                    // //                 data: formData,
                    // //                 async: false,
                    // //                 success: function (result) {
                    // //                     if (result.success == "false") {
                    // //                         layer.msg("未得到SHP解析数据！");
                    // //                         return false;
                    // //                     }
                    // //
                    // //                     aysSearch._removeEntity(oriEntity);
                    // //                     try {
                    // //                         oriEntity = aysSearch.geoJsonToMapGroud(result.data.features, {color: Cesium.Color.LIGHTSKYBLUE});
                    // //                     } catch (e) {
                    // //                         console.log(e)
                    // //                     }
                    // //
                    // //                     // model.addModel(result.data, "geojson");
                    // //
                    // //                     // aysSearch.clearAll();
                    // //                     //
                    // //                     // var temp = {
                    // //                     //     "type": "FeatureCollection",
                    // //                     //     "features": result.data.features
                    // //                     // };
                    // //                     // var promise = Cesium.GeoJsonDataSource.load(temp);
                    // //                     // promise.then(function (dataSource) {
                    // //                     //     MapUtils.viewer.dataSources.add(dataSource);
                    // //                     //     var entities = dataSource.entities.values;
                    // //                     //     MapUtils.setAllStyle(entities);
                    // //                     // });
                    // //                     // MapUtils.viewer.flyToViewer(promise)
                    // //
                    // //                     // var temp = {
                    // //                     //     "type": "FeatureCollection",
                    // //                     //     "features": result.data.features
                    // //                     // };
                    // //                     // var promise = Cesium.GeoJsonDataSource.load(temp);
                    // //                     // promise.then(function (dataSource) {
                    // //                     //     MapUtils.viewer.dataSources.add(dataSource);
                    // //                     //     var entities = dataSource.entities.values;
                    // //                     //     $.each(entities, function (index, value) {
                    // //                     //         value.polygon.material.color = Cesium.Color.LIGHTSKYBLUE.withAlpha(0.7);
                    // //                     //         value.polygon.outline = true;
                    // //                     //         value.polygon.outlineWidth = 100;
                    // //                     //         value.polygon.outlineColor = Cesium.Color.RED;
                    // //                     //         value.polygon.closeBottom = false;
                    // //                     //     });
                    // //                     // });
                    // //                     // MapUtils.viewer.flyToViewer(promise)
                    // //                 },
                    // //                 error: function (xhr, status, error) {
                    // //                     layer.msg("解析SHP失败！错误：" + error);
                    // //                 }
                    // //             });
                    // //
                    // //         })
                    // //     }
                    // // });
                    //
                    // //监听下拉选择
                    // form.on('select(sjcc-filter-fwd)', function (data) {
                    //     showLoading("数据加载中...");
                    //     //初始化展示数据仓储图层
                    //     var formData1 = new FormData();
                    //     formData1.append("tableId", data.value);
                    //     $.ajax({
                    //         url: "/rest/rapid/table/geojson",
                    //         type: "POST",
                    //         contentType: false,
                    //         processData: false,
                    //         data: formData1,
                    //         success: function (result) {
                    //             aysSearch._removeEntity(oriEntity);
                    //             aysSearch._removeEntity(fwEntity);
                    //             try {
                    //                 oriEntity = aysSearch.geoJsonToMapGroud(result.data.features, {color: Cesium.Color.LIGHTSKYBLUE});
                    //             } catch (e) {
                    //                 console.log(e)
                    //             }
                    //             closeLoading();
                    //         },
                    //         error: function (xhr, status, error) {
                    //             closeLoading();
                    //             layer.msg("数据获取失败！错误：" + error);
                    //         }
                    //     });
                    // });
                    //
                    // //监听radiobutton选择事件
                    // form.on('radio(ggfwd)', function (obj) {
                    //     aysSearch.clearAll();
                    //
                    //     if (obj.value == 1) {
                    //         document.getElementById('div-shp-fwd').style.display = 'block';
                    //         document.getElementById('div-store-fwd').style.display = 'none';
                    //     } else if (obj.value == 2) {
                    //         if ($that.bdstate == 0) {
                    //             showLoading("正在读取图层...");
                    //             /*$that.layerIndex_wait = layer.msg("正在读取图层...", {
                    //                 icon: 16,
                    //                 shade: [0.5, '#f5f5f5'],
                    //                 scrollbar: false,
                    //                 offset: 'auto',
                    //                 time: 100000
                    //             });*/
                    //             _bindingLayers('#select-tablestore-fwd', rootPath + "/tablesinfo/search?page=1&limit=50&keyword=");
                    //         } else {
                    //             document.getElementById('div-store-fwd').style.display = 'block';
                    //         }
                    //         document.getElementById('div-shp-fwd').style.display = 'none';
                    //     }
                    //     form.render('radio');
                    // });
                    //
                    //
                    // form.on('radio(zfxfilter-fwd)', function (data) {
                    //     document.getElementById('div-radio-fwd').style.display = 'block';
                    // });
                    // form.on('radio(fwfilter-fwd)', function (data) {
                    //     document.getElementById('div-radio-fwd').style.display = 'block';
                    // });
                    // form.on('radio(ytxfilter-fwd)', function (data) {
                    //     document.getElementById('div-radio-fwd').style.display = 'none';
                    // });
                    //
                    // // 切换评价单元选择方式
                    // form.on('radio(filter-pjdy-fwd)', function (obj) {
                    //     var value = obj.value;
                    //
                    //     if (value === 'square' || value === 'hexagonal') {
                    //         $("#div-fxfs-fwd").show();
                    //         $("#div-xzq-fwd").hide();
                    //         $("#div-radio-fwd").show();
                    //         $("#div-shjxzq-fwd").hide();
                    //         $("#div-sjxzq-fwd").hide();
                    //         $("#div-xjxzq-fwd").hide();
                    //     } else if (value === 'sjxzq') {
                    //         $("#div-fxfs-fwd").hide();
                    //         $("#div-xzq-fwd").show();
                    //         $("#div-radio-fwd").hide();
                    //         $("#div-shjxzq-fwd").show();
                    //         $("#div-sjxzq-fwd").hide();
                    //         $("#div-xjxzq-fwd").hide();
                    //
                    //         $("#select-shjxzq-fwd").empty();
                    //         $("#select-shjxzq-fwd").append("<option value="+32+">江苏省(32)</option>");
                    //     } else if (value === 'xjxzq') {
                    //         $("#div-fxfs-fwd").hide();
                    //         $("#div-xzq-fwd").show();
                    //         $("#div-radio-fwd").hide();
                    //         $("#div-shjxzq-fwd").hide();
                    //         $("#div-sjxzq-fwd").show();
                    //         $("#div-xjxzq-fwd").hide();
                    //
                    //         $("#select-sjxzq-fwd").empty();
                    //         $("#select-sjxzq-fwd").append("<option value="+32+">江苏省(32)</option>");
                    //         for(var key in config.SJXZQ){
                    //             $("#select-sjxzq-fwd").append("<option value="+key+">"+config.SJXZQ[key]+"(" + key + ")</option>");
                    //         }
                    //     } else if (value === 'xzjxzq') {
                    //         $("#div-fxfs-fwd").hide();
                    //         $("#div-xzq-fwd").show();
                    //         $("#div-radio-fwd").hide();
                    //         $("#div-shjxzq-fwd").hide();
                    //         $("#div-sjxzq-fwd").hide();
                    //         $("#div-xjxzq-fwd").show();
                    //
                    //         $("#select-xjxzq-fwd").empty();
                    //         $("#select-xjxzq-fwd").append("<option value="+32+">江苏省(32)</option>");
                    //
                    //         $("#select-xjxzq-fwd").append("<optgroup label=\"南京市(3201)\">");
                    //         for(var key in config.NJSQX){
                    //             $("#select-xjxzq-fwd").append("<option value="+key+">"+config.NJSQX[key]+"(" + key + ")</option>");
                    //         }
                    //         $("#select-xjxzq-fwd").append("</optgroup>");
                    //
                    //         $("#select-xjxzq-fwd").append("<optgroup label=\"无锡市(3202)\">");
                    //         for(var key in config.WXSQX){
                    //             $("#select-xjxzq-fwd").append("<option value="+key+">"+config.WXSQX[key]+"(" + key + ")</option>");
                    //         }
                    //         $("#select-xjxzq-fwd").append("</optgroup>");
                    //
                    //         $("#select-xjxzq-fwd").append("<optgroup label=\"徐州市(3203)\">");
                    //         for(var key in config.XZSQX){
                    //             $("#select-xjxzq-fwd").append("<option value="+key+">"+config.XZSQX[key]+"(" + key + ")</option>");
                    //         }
                    //         $("#select-xjxzq-fwd").append("</optgroup>");
                    //
                    //         $("#select-xjxzq-fwd").append("<optgroup label=\"常州市(3204)\">");
                    //         for(var key in config.CZSQX){
                    //             $("#select-xjxzq-fwd").append("<option value="+key+">"+config.CZSQX[key]+"(" + key + ")</option>");
                    //         }
                    //         $("#select-xjxzq-fwd").append("</optgroup>");
                    //
                    //         $("#select-xjxzq-fwd").append("<optgroup label=\"苏州市(3205)\">");
                    //         for(var key in config.SZSQX){
                    //             $("#select-xjxzq-fwd").append("<option value="+key+">"+config.SZSQX[key]+"(" + key + ")</option>");
                    //         }
                    //         $("#select-xjxzq-fwd").append("</optgroup>");
                    //
                    //         $("#select-xjxzq-fwd").append("<optgroup label=\"南通市(3206)\">");
                    //         for(var key in config.NTSQX){
                    //             $("#select-xjxzq-fwd").append("<option value="+key+">"+config.NTSQX[key]+"(" + key + ")</option>");
                    //         }
                    //         $("#select-xjxzq-fwd").append("</optgroup>");
                    //
                    //         $("#select-xjxzq-fwd").append("<optgroup label=\"连云港市(3207)\">");
                    //         for(var key in config.LYGSQX){
                    //             $("#select-xjxzq-fwd").append("<option value="+key+">"+config.LYGSQX[key]+"(" + key + ")</option>");
                    //         }
                    //         $("#select-xjxzq-fwd").append("</optgroup>");
                    //
                    //         $("#select-xjxzq-fwd").append("<optgroup label=\"淮安市(3208)\">");
                    //         for(var key in config.HASQX){
                    //             $("#select-xjxzq-fwd").append("<option value="+key+">"+config.HASQX[key]+"(" + key + ")</option>");
                    //         }
                    //         $("#select-xjxzq-fwd").append("</optgroup>");
                    //
                    //         $("#select-xjxzq-fwd").append("<optgroup label=\"盐城市(3209)\">");
                    //         for(var key in config.YCSQX){
                    //             $("#select-xjxzq-fwd").append("<option value="+key+">"+config.YCSQX[key]+"(" + key + ")</option>");
                    //         }
                    //         $("#select-xjxzq-fwd").append("</optgroup>");
                    //
                    //         $("#select-xjxzq-fwd").append("<optgroup label=\"扬州市(3210)\">");
                    //         for(var key in config.YZSQX){
                    //             $("#select-xjxzq-fwd").append("<option value="+key+">"+config.YZSQX[key]+"(" + key + ")</option>");
                    //         }
                    //         $("#select-xjxzq-fwd").append("</optgroup>");
                    //
                    //         $("#select-xjxzq-fwd").append("<optgroup label=\"镇江市(3211)\">");
                    //         for(var key in config.ZJSQX){
                    //             $("#select-xjxzq-fwd").append("<option value="+key+">"+config.ZJSQX[key]+"(" + key + ")</option>");
                    //         }
                    //         $("#select-xjxzq-fwd").append("</optgroup>");
                    //
                    //         $("#select-xjxzq-fwd").append("<optgroup label=\"泰州市(3212)\">");
                    //         for(var key in config.TZSQX){
                    //             $("#select-xjxzq-fwd").append("<option value="+key+">"+config.TZSQX[key]+"(" + key + ")</option>");
                    //         }
                    //         $("#select-xjxzq-fwd").append("</optgroup>");
                    //
                    //         $("#select-xjxzq-fwd").append("<optgroup label=\"宿迁市(3213)\">");
                    //         for(var key in config.SQSQX){
                    //             $("#select-xjxzq-fwd").append("<option value="+key+">"+config.SQSQX[key]+"(" + key + ")</option>");
                    //         }
                    //         $("#select-xjxzq-fwd").append("</optgroup>");
                    //
                    //         $("#select-xjxzq-fwd").append("<optgroup label=\"岛屿(329999)\">");
                    //         for(var key in config.JSSDY){
                    //             $("#select-xjxzq-fwd").append("<option value="+key+">"+config.JSSDY[key]+"(" + key + ")</option>");
                    //         }
                    //         $("#select-xjxzq-fwd").append("</optgroup>");
                    //     }
                    //     form.render();
                    // });
                    //
                    // // 切换范围选择方式
                    // form.on('radio(filter-pjfw-fwd)', function (obj) {
                    //     var value = obj.value;
                    //     if (value === '1'){
                    //         $("#div-shp-fwd").show();
                    //         $("#div-store-fwd").hide();
                    //     }else if(value === '2'){
                    //         showLoading("正在读取图层...");
                    //         /*$that.layerIndex_wait = layer.msg("正在读取图层...", {
                    //             icon: 16,
                    //             shade: [0.5, '#f5f5f5'],
                    //             scrollbar: false,
                    //             offset: 'auto',
                    //             time: 100000
                    //         });*/
                    //         _bindingLayers('#select-tablestore-fwd', rootPath + "/tablesinfo/search?page=1&limit=50&keyword=");
                    //
                    //         $("#div-shp-fwd").hide();
                    //         $("#div-store-fwd").show();
                    //     }
                    // });

                    table.render({
                        elem: '#speedTable',
                        title: "道路速度设置",
                        // skin: 'line',
                        // even: true,
                        id: 'table-speed',
                        cols: [[
                            {field: 'dljb', title: '道路级别'}
                            , {field: 'maxspeed', title: '速度(km/h)', edit: 'text'}
                        ]],
                        data: [
                            {
                                dljb: "一级道路",
                                maxspeed: "80"
                            }
                            ,{
                                dljb: "二级道路",
                                maxspeed: "60"
                            }
                            ,{
                                dljb: "三级道路",
                                maxspeed: "50"
                            }
                            ,{
                                dljb: "四级道路",
                                maxspeed: "40"
                            }
                            ,{
                                dljb: "等外",
                                maxspeed: "40"
                            }
                            ,{
                                dljb: "城市道路",
                                maxspeed: "40"
                            }
                            ,{
                                dljb: "乡村道路",
                                maxspeed: "30"
                            }
                            ,{
                                dljb: "其他道路",
                                maxspeed: "30"
                            }
                        ],
                        limit: Number.MAX_VALUE,
                        done: function (res, curr, count) {
                            $that.params = res.data;
                        }
                    });

                    table.on('edit(speedTable)', function (obj) {
                        $that.params = table.cache['speedTable'];
                    });

                    $(document).on('click', '#btOK-fwd', function (evt) {
                        // if (document.getElementById('pjdy-zfx-fwd').checked == true || document.getElementById('pjdy-fw-fwd').checked == true) {
                        //     if (document.getElementById('radio-shp-fwd').checked == true && $that.upfile == null) {
                        //         layer.msg("请选择评价范围数据SHP包！");
                        //         return false;
                        //     }
                        // }

                        if ($that.fxType1 === "shp" && $that.upfile === null) {
                            layer.msg("请选择评价范围数据SHP包！");
                            return false;
                        }

                        _kjAnalysis();

                        return  false;
                    });

                    $(document).on('click', '#btReset-fwd', function (evt) {
                        // EventBus.trigger("bufferClear");
                        // // model.clear();
                        // MapUtils.viewer.dataSources.removeAll();
                        aysSearch.clearAll();

                        document.getElementById('input-pjdylen-fwd').value = "1";
                        document.getElementById('input-sjfw-fwd').value = "1";

                        document.getElementById("div-store-fwd").style.display = "none";
                        document.getElementById("div-shp-fwd").style.display = "none";
                    });



                    //结果表名保存
                    $(document).on('click', '#btTbSave-fwd', function (evt) {
                        var info = "{tableName:'" + document.getElementById('input-name-fwd').value + "'}";
                        $.ajax({
                            type: 'POST',
                            url: '/metainfo/edit',
                            data: {
                                id: $that.sjccid,
                                info: info,
                            },
                            success: function (msg) {
                                layer.msg("保存成功！");
                            },
                            error: function (e, state, errorThrown) {
                                console.log(e);
                            }
                        });
                        return false;
                    });
                    //申请下载弹窗
                    $(document).on('click', '#download-fwd', function (evt) {
                        var $divDownload = $('#div-download-fwd');
                        layer.close(layerIndex_download);
                        layerIndex_download = layer.open({
                            title: '提交申请',
                            shade: 0,
                            shadeClose: true,
                            type: 1,
                            area: ['500px', '360px'],
                            content: $divDownload.html(),
                        })
                        return false;
                        //var downUrl="http://192.168.2.101:10002/mdb/v1/datastore/export/shp?tableId=24478b13-2e06-405b-95c4-c4fd5454ce43";
                        // window.open(downloadUrl);
                    });
                    //申请下载弹窗中保存按钮
                    $(document).on('click', '#btn-download-fwd', function () {
                        tableId.push($that.sjccid);
                        $.ajax({
                            type: 'post',
                            url: '/overlay/apply',
                            data: {
                                "id": JSON.stringify(tableId),
                                "reason": $('.text-reason').val(),
                            }
                        }).then(
                            function (obj) {
                                layer.msg('已成功提交申请，等待审核后可在数据治理中心下载！');
                            },
                            function (obj) {
                                layer.msg('提交申请失败！');
                            }
                        )
                    });

                    // $(document).on('click', '#download-fwd', function (evt) {
                    //     layer.msg("申请成功，等待管理员审批！");
                    //     return false;
                    //     //var downUrl="http://192.168.2.101:10002/mdb/v1/datastore/export/shp?tableId=24478b13-2e06-405b-95c4-c4fd5454ce43";
                    //     // window.open(downloadUrl);
                    // });



                    function _kjAnalysis() {
                        var speed =  $that._getTbjson();

                        var jslist = {};
                        jslist.speed = speed;
                        jslist.maxtime = document.getElementById('input-sjfw-fwd').value;
                        jslist.id = "402882e56bf56335016c004197d80000";
                        jslist.table = document.getElementById('input-name-fwd').value;

                        if(document.getElementById('poi-school-fwd').checked == true){
                            jslist.pointLayer = document.getElementById('poi-school-fwd').value;
                        }else if(document.getElementById('poi-hospital-fwd').checked == true){
                            jslist.pointLayer = document.getElementById('poi-hospital-fwd').value;
                        }else if(document.getElementById('poi-gas-fwd').checked == true){
                            jslist.pointLayer = document.getElementById('poi-gas-fwd').value;
                        }

                        jslist.sideLen = $that.sideLen1;
                        jslist.pjdy = $that.pjdy1;
                        jslist.xzqName = $that.fxxzqName1;
                        jslist.xzqdm = $that.fxxzqdm1;
                        var jspara = JSON.stringify(jslist);
                        // jslist.sideLen = document.getElementById('input-pjdylen-fwd').value;
                        // if(document.getElementById('pjdy-zfx-fwd').checked == true){
                        //     jslist.pjdy = document.getElementById('pjdy-zfx-fwd').value;
                        // }
                        // if(document.getElementById('pjdy-fw-fwd').checked == true){
                        //     jslist.pjdy = document.getElementById('pjdy-fw-fwd').value;
                        // }
                        // if(document.getElementById('pjdy-sjxzq-fwd').checked == true){
                        //     jslist.pjdy = "sjxzq";
                        //     jslist.xzqName = "xzq_c_2017";
                        //     jslist.xzqdm = document.getElementById('select-shjxzq-fwd').value;
                        // }
                        // if(document.getElementById('pjdy-xjxzq-fwd').checked == true){
                        //     jslist.pjdy = "xjxzq";
                        //     jslist.xzqName = "xzq_d_2017";
                        //     jslist.xzqdm = document.getElementById('select-sjxzq-fwd').value;
                        // }
                        // if(document.getElementById('pjdy-xzxzq-fwd').checked == true){
                        //     jslist.pjdy = "xzxzq";
                        //     jslist.xzqName = "xzq_e_2017";
                        //     jslist.xzqdm = document.getElementById('select-xjxzq-fwd').value;
                        // }
                        // var jspara = JSON.stringify(jslist);


                        var sType = $that.fxType1;
                        var layernm = $that.fxLayer1;
                        // var sType = "xzq", layernm = "xzqLayer";
                        // if(document.getElementById('pjdy-zfx-fwd').checked === true||document.getElementById('pjdy-fw-fwd').checked === true){
                        //     if (document.getElementById('radio-sjcc-fwd').checked == true) {
                        //         sType = "sjcc";
                        //         layernm = document.getElementById('select-tablestore-fwd').value;
                        //     }
                        //     if (document.getElementById('radio-shp-fwd').checked == true) {
                        //         sType = "shp";
                        //         layernm = "shpLayer";
                        //     }
                        // }


                        var formData = new FormData();
                        formData.append("sourceType", sType);
                        formData.append("layerName", layernm);
                        formData.append("file", $that.upfile);
                        formData.append("jspara", jspara);

                        //分析
                        //$that.layerIndex_wait = layer.msg("分析进行中...", {icon: 16, shade: [0.5, '#f5f5f5'], scrollbar: false, offset: 'auto', time: 10000000});
                        showLoading("分析进行中...");
                        $.ajax({
                            url: "/rest/rapid/fxsthjzs",
                            type: "POST",
                            contentType: false,
                            processData: false,
                            data: formData,
                            success: function (result) {
                                if(result.data == null){
                                    closeLoading();
                                    //layer.close($that.layerIndex_wait);
                                    layer.msg("未得到分析结果！");
                                    return false;
                                }

                                model.setOption({
                                    dic:{
                                        "0~60":{min:0,max:60},
                                        "60~70":{min:60,max:70},
                                        "70~80":{min:70,max:80},
                                        "80~90":{min:80,max:90},
                                        "90~100":{min:90,max:100}
                                    }
                                });

                                // model.addModel(result.data,"geojson");
                                $.each(result.data, function (key, value) {
                                    $that.sjccid = key;
                                    model.addModel(value,"geojson");
                                });

                                // var temp = {
                                //     "type": "FeatureCollection",
                                //     "features": result.data.features
                                // };
                                // var promise = Cesium.GeoJsonDataSource.load(temp);
                                // promise.then(function (dataSource) {
                                //     MapUtils.viewer.dataSources.add(dataSource);
                                //     var entities = dataSource.entities.values;
                                //     $.each(entities, function (index, value) {
                                //         value.polygon.material.color = Cesium.Color.LIGHTSKYBLUE.withAlpha(0.7);
                                //         value.polygon.outline = true;
                                //         value.polygon.outlineWidth = 100;
                                //         value.polygon.outlineColor = Cesium.Color.RED;
                                //         value.polygon.closeBottom = false;
                                //     });
                                // });

                                closeLoading();
                                //layer.close($that.layerIndex_wait);
                                document.getElementById("download-fwd").style.display = "inline";
                                document.getElementById("btReset-fwd").style.display = "none";
                                document.getElementById("div-jgbm-fwd").style.display = "block";
                                layer.msg("分析完成！");
                            },
                            error: function (xhr, status, error) {
                                closeLoading();
                                //layer.close($that.layerIndex_wait);
                                layer.msg("分析失败！错误：" + error);
                            }
                        });



                        // var sthjzsqz = $that._getTbjson("sthjzsTable",1);
                        // var stydlxzqz = $that._getTbjson("sjzlzsTable",0);
                        // var stydlxfqz = $that._getTbjson("sjzlzsTable",1);
                        // var qtzbqz = $that._getTbjson("qtzsTable",1);
                        //
                        // var jslist = {};
                        // jslist.sthjzsqz = sthjzsqz;
                        // jslist.stydlxzqz = stydlxzqz;
                        // jslist.stydlxfqz = stydlxfqz;
                        // jslist.qtzbqz = qtzbqz;
                        // jslist.id = "402882e56cb273c1016cf103228c0004";
                        // jslist.table = document.getElementById('input-name-sj').value;
                        //
                        // jslist.sideLen = document.getElementById('input-pjdylen-sj').value;
                        // if(document.getElementById('pjdy-zfx-sj').checked == true){
                        //     jslist.pjdy = document.getElementById('pjdy-zfx-sj').value;
                        // }
                        // if(document.getElementById('pjdy-fw-sj').checked == true){
                        //     jslist.pjdy = document.getElementById('pjdy-fw-sj').value;
                        // }
                        // if(document.getElementById('pjdy-ytx-sj').checked == true){
                        //     jslist.pjdy = document.getElementById('pjdy-ytx-sj').value;
                        // }
                        //
                        // var jspara = JSON.stringify(jslist);
                        //
                        // var sType, layernm;
                        // if (document.getElementById('sjlxSel-sj').value == "0") {
                        //     sType = "sjcc";
                        //     layernm = document.getElementById('select-tablestore-sj').value;
                        // }
                        // if (document.getElementById('sjlxSel-sj').value == "1") {
                        //     sType = "shp";
                        //     layernm = "shpLayer";
                        // }
                        //
                        // var formData = new FormData();
                        // formData.append("sourceType", sType);
                        // formData.append("layerName", layernm);
                        // formData.append("file", $that.upfile);
                        // formData.append("jspara", jspara);
                        //
                        //
                        // // var formData = new FormData();
                        // // formData.append("files", $that.upfile);
                        // // formData.append("filesbh", $that.upfile1);
                        // // formData.append("jspara", jspara);
                        //
                        // //分析
                        // $that.layerIndex_wait = layer.msg("分析进行中...", {icon: 16, shade: [0.5, '#f5f5f5'], scrollbar: false, offset: 'auto', time: 10000000});
                        // $.ajax({
                        //     url: "/rest/rapid/fxsthjzs",
                        //     type: "POST",
                        //     contentType: false,
                        //     processData: false,
                        //     data: formData,
                        //     success: function (result) {
                        //         if(result.data == null){
                        //             layer.close($that.layerIndex_wait);
                        //             layer.msg("未得到分析结果！");
                        //             return false;
                        //         }
                        //         model.addModel(result.data,"geojson");
                        //         layer.close($that.layerIndex_wait);
                        //         document.getElementById("div-jgbm-sj").style.display = "block";
                        //         layer.msg("分析完成！");
                        //     },
                        //     error: function (xhr, status, error) {
                        //         layer.close($that.layerIndex_wait);
                        //         layer.msg("分析失败！错误：" + error);
                        //     }
                        // });

                    };

                    function _bindingLayers(elem, url) {
                        var $target = $(elem);
                        $.ajax({
                            url: url,
                            // async: false,
                            success: function (result) {
                                var content = result["data"];
                                var result1 = [];
                                if (content) {
                                    for (var i = 0; i < content.length; i++) {
                                        var item = {};
                                        item.id = content[i].id;
                                        item.name = content[i].tableName;
                                        result1.push(item);
                                    }
                                }

                                var renderData = result1;

                                var option = "";
                                for (var i = 0; i < renderData.length; i++) {
                                    option += "<option value=" + renderData[i].id + ">" + renderData[i].name + "</option>";
                                }
                                $target.html(option);
                                for (var i = 0; i < result.length; i++) {
                                    var id = result[i].id;
                                    $("#" + id).data(result[i]);
                                }

                                form.render('select');
                                closeLoading();
                                //layer.close($that.layerIndex_wait);
                                document.getElementById('div-store-fwd').style.display = 'block';
                                $that.bdstate = 1;
                            },
                            error: function (e, state, error) {
                                console.log(e);
                            }
                        });
                    }

                })
            },

            // 初始化一些点击事件
            _initClick: function () {
                $(document).on('click', '#btNext-fwd', function (evt) {
                    $('#analysis').hide();
                    $('#div-poi-fwd').hide();
                    $('#div-sjfw-fwd').hide();
                    $('#div-tbs-fwd').show();
                    $('#btNext-fwd').hide();
                    $('#btBefor-fwd').show();
                    $('#btOK-fwd').show();

                    // document.getElementById("div-xzq-fwd").style.display = "none";
                    // document.getElementById("div-fxfs-fwd").style.display = "none";
                    // document.getElementById("div-store-fwd").style.display = "none";
                    // document.getElementById("div-shp-fwd").style.display = "none";
                    // document.getElementById("div-pjdy-fwd").style.display = "none";
                    // document.getElementById("div-poi-fwd").style.display = "none";
                    // document.getElementById("div-sjfw-fwd").style.display = "none";
                    // document.getElementById("div-speed").style.display = "block";
                    // document.getElementById("btBefor-fwd").style.display = "inline";
                    // document.getElementById("btNext-fwd").style.display = "none";
                    // document.getElementById("btOK-fwd").style.display = "inline";

                    document.getElementById("leg-fwd").innerHTML = "设置道路速度";
                    return false;
                })

                $(document).on('click', '#btBefor-fwd', function (evt) {
                    $('#analysis').show();
                    $('#div-poi-fwd').show();
                    $('#div-sjfw-fwd').show();
                    $('#div-tbs-fwd').hide();
                    $('#btNext-fwd').show();
                    $('#btBefor-fwd').hide();
                    $('#btOK-fwd').hide();

                    // if (document.getElementById('pjdy-sjxzq-fwd').checked === true){
                    //     document.getElementById("div-xzq-fwd").style.display = "block";
                    //     document.getElementById("div-shjxzq-fwd").style.display = "block";
                    //     document.getElementById("div-sjxzq-fwd").style.display = "none";
                    //     document.getElementById("div-xjxzq-fwd").style.display = "none";
                    // }else if(document.getElementById('pjdy-xjxzq-fwd').checked === true){
                    //     document.getElementById("div-xzq-fwd").style.display = "block";
                    //     document.getElementById("div-shjxzq-fwd").style.display = "none";
                    //     document.getElementById("div-sjxzq-fwd").style.display = "block";
                    //     document.getElementById("div-xjxzq-fwd").style.display = "none";
                    // }else if(document.getElementById('pjdy-xzxzq-fwd').checked === true){
                    //     document.getElementById("div-xzq-fwd").style.display = "block";
                    //     document.getElementById("div-shjxzq-fwd").style.display = "none";
                    //     document.getElementById("div-sjxzq-fwd").style.display = "none";
                    //     document.getElementById("div-xjxzq-fwd").style.display = "block";
                    // }else{
                    //     document.getElementById("div-fxfs-fwd").style.display = "block";
                    //
                    //     if (document.getElementById('radio-sjcc-fwd').checked == true) {
                    //         document.getElementById("div-store-fwd").style.display = "block";
                    //     }
                    //     if (document.getElementById('radio-shp-fwd').checked == true) {
                    //         document.getElementById("div-shp-fwd").style.display = "block";
                    //     }
                    // }
                    //
                    // document.getElementById("div-pjdy-fwd").style.display = "block";
                    // document.getElementById("div-poi-fwd").style.display = "block";
                    // document.getElementById("div-sjfw-fwd").style.display = "block";
                    // document.getElementById("div-speed").style.display = "none";
                    // document.getElementById("btBefor-fwd").style.display = "none";
                    // document.getElementById("btNext-fwd").style.display = "inline";
                    // document.getElementById("btOK-fwd").style.display = "none";

                    document.getElementById("leg-fwd").innerHTML = "评价范围";
                    return false;
                })
            },

            _getDate: function () {
                var now= new Date();
                document.getElementById("input-name-fwd").value = "GGFWD" + now.getFullYear().toString() + (now.getMonth()+1).toString() + now.getDate().toString() + now.getHours().toString() + now.getMinutes().toString() + now.getSeconds().toString();
            },

            _tbmerge: function (columsIndex, startIndex, mark) {
                var trArr = $(".layui-table-body>.layui-table").find("tr");//所有行
                var tdPreArr = trArr.eq(startIndex).find("td").eq(columsIndex);//获取相同列的第一列
                tdPreArr.each(function () {//相同列的第一列增加rowspan属性
                    $(this).attr("rowspan", mark);
                });
                for (var i = startIndex + 1; i < mark + startIndex; i++) {
                    var tdCurArr = trArr.eq(i).find("td").eq(columsIndex);//获取当前行的当前列
                    tdCurArr.each(function () {//当前行隐藏
                        $(this).css("display", "none");
                    });
                }
            },

            _getTbjson: function () {
                var tbData = $that.params;
                var gxjson = "{'一级':" + tbData[0].maxspeed + ",'二级':" + tbData[1].maxspeed + ",'三级':" + tbData[2].maxspeed + ",'四级':" + tbData[3].maxspeed + ",'等外':" + tbData[4].maxspeed + ",'城市道路':" + tbData[5].maxspeed + ",'乡村道路':" + tbData[6].maxspeed + ",'其他':" + tbData[7].maxspeed + ",'高速':120,'步行道':5.5}";

                // var gxjson = "{'高速':" + tbData[0].maxspeed + ",'一级':" + tbData[1].maxspeed + ",'二级':" + tbData[2].maxspeed + ",'三级':" + tbData[3].maxspeed + ",'四级':" + tbData[4].maxspeed + ",'等外':" + tbData[5].maxspeed + ",'步行道':5.5}";

                // if (tableID == "sthjzsTable") {
                //     // "分值计算公式，格式{'sjzlzs':0.25,'stbhzs':0.2,'stjgzs':0.3,'tdxpzs':0.25}"
                //     tbData = $that.params;
                //     gxjson = "{'sjzlzs':" + tbData[0].sjzlzs + ",'stbhzs':" + tbData[0].stbhzs + ",'stjgzs':" + tbData[0].stjgzs + ",'tdxpzs':" + tbData[0].stxpzs + "}";
                //
                // } else if (tableID == "sjzlzsTable") {
                //     tbData = $that.params_sj;
                //     if(type == "0"){
                //         //{'ld':0.35,'cd':0.21,'sysd':0.28,'gd':0.11,'jsyd':0.04,'wlyd':0.01}
                //         gxjson = "{'ld':" + tbData[0].qz + ",'cd':" + tbData[3].qz + ",'sysd':" + tbData[5].qz + ",'gd':" + tbData[7].qz + ",'jsyd':" + tbData[9].qz + ",'wlyd':" + tbData[11].qz + "}";
                //     }else{
                //         //{'sl':0.6,'gc':0.25,'qtld':0.15,'cc':0.7,'qtcd':0.3,'hl':0.3,'hp':0.7,'st':0.6,'hd':0.4,'jzd':0.6,'gkjt':0.4,'lt':0.5,'ly':0.5}
                //         gxjson = "{'sl':" + tbData[0].fqz + ",'gc':" + tbData[1].fqz + ",'qtld':" + tbData[2].fqz + ",'cc':" + tbData[3].fqz + ",'qtcd':" + tbData[4].fqz + ",'hl':" + tbData[5].fqz
                //                     + ",'hp':" + tbData[6].fqz + ",'st':" + tbData[7].fqz + ",'hd':" + tbData[8].fqz + ",'jzd':" + tbData[9].fqz + ",'gkjt':" + tbData[10].fqz + ",'lt':" + tbData[11].fqz
                //                     + ",'ly':" + tbData[12].fqz + "}";
                //     }
                // }else if (tableID == "qtzsTable") {
                //     tbData = $that.params_qt;
                //
                //     // {'sbhq':1,'ldfgl':0.5,'cdfgl':0.2,'syfgl':0.3,'gdfgl':0.3,'jsydfgl':0.3,'jsydjjd':0.2,'lcdpsd':0.2}
                //     gxjson = "{'sbhq':" + tbData[0].qz + ",'ldfgl':" + tbData[1].qz + ",'cdfgl':" + tbData[2].qz + ",'syfgl':" + tbData[3].qz + ",'gdfgl':" + tbData[4].qz + ",'jsydfgl':" + tbData[5].qz
                //                 + ",'jsydjjd':" + tbData[6].qz + ",'lcdpsd':" + tbData[7].qz + "}";
                // }
                return gxjson;
            },

        };

    var interfaceConfig = WidgetUtils._appConfig.interface,
        parsefile = interfaceConfig.parsefile;

    /**
     * get instance
     *
     * @returns {*}
     */
    me.getInstance = function () {
        if (void 0 === instance) {
            instance = me;
        }
        return instance;
    };
    return me;
});
