/**
 * 淹没分析
 * @author by <a href="mailto:liushanshan825@gmail.com">Liu</a>
 * @version v1.0 2019/3/18/9:50  Copyright gtmap Corp
 */
define(["knockout",
    "lodash",
    'Cesium',
    "global/utils/MapUtils",
    "global/utils/WidgetUtils"
], function (ko, _, Cesium, MapUtils, WidgetUtils) {
    var instance,
        $that,
        me = {
            viewer:null,

            inited:false,

            btns: [
                {
                    "id": "beginAnalyze",
                    "icon": "icon-f-play",
                    "label": "开始"
                },
                {
                    "id": "clear",
                    "icon": "icon-f-analysis-delete",
                    "label": "清除"
                }
            ],

            // init fun
            init: function () {
                window.viewer = MapUtils.viewer;
                this.viewer = MapUtils.viewer;
            },

            // open event
            onOpen: function () {
                this.viewer.scene.camera.flyTo({
                    destination: new Cesium.Cartesian3.fromDegrees(114.2158, 22.4169, 419),
                    orientation: {
                        up: new Cesium.Cartesian3(-0.1629169048778112, 0.7143202157541026, 0.6805914424014209),
                        direction: new Cesium.Cartesian3(0.5945902470233576, -0.4793925407032518, 0.6454806194323606),
                        heading: 5.899584294129949
                    }
                });
                this.onlineDataOnLoad(this.viewer.scene);
            },

            // close event
            onPause: function () {
                this.viewer.scene.layers.remove("sci_park");
            },

            onClose: function () {
                this.viewer.scene.layers.remove("sci_park");
            },

            onlineDataOnLoad: function (scene) {
                var widget = this.viewer.cesiumWidget;
                try {
                    //添加S3M图层服务
                    var promise = scene.open('http://www.supermapol.com/realspace/services/3D-yanmofenxi/rest/realspace');
                    Cesium.when(promise, function (layers) {
                        // 设置相机视角
                        scene.camera.flyTo({
                            destination: new Cesium.Cartesian3.fromDegrees(114.2158, 22.4169, 419),
                            orientation: {
                                up: new Cesium.Cartesian3(-0.1629169048778112, 0.7143202157541026, 0.6805914424014209),
                                direction: new Cesium.Cartesian3(0.5945902470233576, -0.4793925407032518, 0.6454806194323606),
                                heading: 5.899584294129949
                            }
                        });
                    }, function (e) {
                        if (widget._showRenderLoopErrors) {
                            var title = '加载SCP失败，请检查网络连接状态或者url地址是否正确？';
                            widget.showErrorPanel(title, undefined, e);
                        }
                    });
                } catch (e) {
                    if (widget._showRenderLoopErrors) {
                        var title = '渲染时发生错误，已停止渲染。';
                        widget.showErrorPanel(title, undefined, e);
                    }
                }
            },

            //开始淹没分析
            beginAnalyze: function () {
                currentHeight = 0;
                int = self.setInterval("flood()", 100);
                maxValue = parseInt(document.getElementById("maxHeight").value);
                minValue = parseInt(document.getElementById("minHeight").value);
            },

            clear: function () {
                self.clearInterval(int);
                var layer = window.viewer.scene.layers.find("sci_park");
                var hyp = new Cesium.HypsometricSetting();
                hyp.MaxVisibleValue = 0;

                layer.hypsometricSetting = {
                    hypsometricSetting: hyp,
                    analysisMode: Cesium.HypsometricSettingEnum.AnalysisRegionMode.ARM_ALL
                }
            },

        };

    window.flood = function () {
        if (currentHeight > maxValue) {
            self.clearInterval(int);
            return;
        }

        var layer = window.viewer.scene.layers.find("sci_park");
        var hyp = new Cesium.HypsometricSetting();

        //创建分层设色对象   设置最大/最小可见高度   颜色表  显示模式   透明度及线宽
        var colorTable = new Cesium.ColorTable();

        hyp.MaxVisibleValue = currentHeight;
        hyp.MinVisibleValue = minValue;

        colorTable.insert(71, new Cesium.Color(0, 39 / 255, 148 / 255));
        colorTable.insert(0, new Cesium.Color(149 / 255, 232 / 255, 249 / 255));

        hyp.ColorTable = colorTable;
        hyp.DisplayMode = Cesium.HypsometricSettingEnum.DisplayMode.FACE;
        hyp.Opacity = 0.5;

        hyp.LineInterval = 10.0;

        //设置图层分层设色属性
        layer.hypsometricSetting = {
            hypsometricSetting: hyp,
            analysisMode: Cesium.HypsometricSettingEnum.AnalysisRegionMode.ARM_ALL
        };

        currentHeight += (parseInt(document.getElementById("speed").value)) / 10;
    };

    ko.applyBindings(new FloodAnalytic(), document.getElementById("floodAnalytic"));

    /**
     * 初始化btn
     * @constructor
     */
    function FloodAnalytic() {
        var self = this;
        // 开始和清除按钮
        self.floodAnalysisBtns = ko.observableArray(me.btns);
        // 属性面板
        self.floodAnalysisProperties = ko.observableArray(me.properties);
        // btn点击
        self.activeBtn = function (btn) {
            _.isEqual(btn.id, 'beginAnalyze') ? me.beginAnalyze() : me.clear();
        }
    }

    /**
     * get instance
     *
     * @returns {*}
     */
    me.getInstance = function () {
        if (instance === undefined) {
            instance = me;
        }
        return instance;
    };
    return me;
});