/**
 *@Author: liujie<liu.im.jie@gmail.com>
 *@Created in 2019-08-28 16:40
 *@Description: 叠加分析
 *@Modify By:
 */

define(["global/core/EventBus",
    "global/core/Model",
    "global/utils/MapUtils",
    "global/utils/WidgetUtils",
    "js/echarts.min",
    "global/widgets/aysSearch/Index"], function (EventBus, model, MapUtils, WidgetUtils, echarts, aysSearch) {
    // 返回的实例
    var instance = {
        init: function () {
            initLayui(this.config);
            $('#div-button').html('');
            divChange(2);
        },
        onOpen: function () {
            aysSearch.dataStoreDivInit();
            aysSearch.dataStoreDivOpen("#dlgq-fxfw");
            // $('#div-button').html('');
            divChange(2);
        },
        onClose: function () {
            k = -1;
            aysSearch.dataStoreDivClose();

            overlayfile = {};
            model.clear();

            issave = false;
        },
        onPause: function () {
            aysSearch.dataStoreDivClose();
            MapUtils.viewer.dataSources.removeAll();
        },
    };

    // 用户上传的用于叠加的图层
    var overlayGeoJson;

    var sourceLayers = [];

    var myChart;


    //0 结束 1开始
    var status = 0;
    var k=0;

    var uploadShp, layerNames, tableIds, tableIDs = [], modelEntity, issave = false;

    var initLayui = function (config) {
        aysSearch.dataStoreDivOpen("#dlgq-fxfw");
        aysSearch.dataStoreDiv("ays7");

        EventBus.listener("ays7Store", function (e, data) {
            overlayGeoJson = data;
        });

        layui.config({base: "./js/"}).use(["element", "form", "layer", "upload", "table"], function () {
            var elem = layui.element, form = layui.form, layer = layui.layer, upload = layui.upload,
                $ = layui.jquery,
                table = layui.table;

            var layerIndex_wait, layerIndex_result, layerIndex_download;

            bindYears(config.years);

            form.render('select');
            form.render('radio');
            form.render('checkbox');

            // 限制选择年份的个数
            form.on("checkbox(years)", function (obj) {
                var count = $(".years:checked").length;
                if (count > 2) {
                    $(obj.elem).next().attr("class", "layui-unselect layui-form-checkbox");
                    $(obj.elem).prop("checked", false);
                    layer.msg('最多只能选2项！', {icon: 5});
                    return false;
                }
            });

            form.on('radio(geometry)', function (obj) {
                if (obj.value == 1) {
                    $("#divUpload").show();
                    $("#divRange").hide();
                } else if (obj.value == 2) {
                    $("#divUpload").hide();
                    $("#divRange").show();
                }
                form.render('radio');
            });

            // // 当用户选择完覆盖的图层后，即在界面上显示该图层模型
            // if (!uploadShp) {
            //     uploadShp = upload.render({
            //         elem: "#btn-uploadShp",
            //         url: "",
            //         accept: 'file',
            //         exts: 'zip',
            //         auto: false,
            //         choose: function (obj) {
            //             obj.preview(function (index, file, result) {
            //                 convertGeoJson(1, file);
            //                 $('#lbl-file-path').innerText = file.name;
            //                 // model.addModel(overlayGeoJson, "geojson");
            //                 var vargeojson = JSON.stringify(overlayGeoJson);
            //                 var temp = {
            //                     "type": "FeatureCollection",
            //                     "features": overlayGeoJson.features
            //                 };
            //                 aysSearch.geoJsonToMapGroud(overlayGeoJson.features, {color: Cesium.Color.LIGHTSKYBLUE});
            //                 // var promise = Cesium.GeoJsonDataSource.load(temp);
            //                 // promise.then(function (dataSource) {
            //                 //     instance.removeEntity = dataSource;
            //                 //     MapUtils.viewer.dataSources.add(dataSource);
            //                 //
            //                 //     var entities = dataSource.entities.values;
            //                 //
            //                 //     MapUtils.setAllStyle(entities);
            //                 // });
            //                 // MapUtils.viewer.flyToViewer(promise);
            //                 delete file;
            //             })
            //             uploadShp.config.elem.next()[0].value = '';
            //         },
            //     });
            // }
            // form.on("select(select-tableName)", function (obj) {
            //     convertGeoJson(0, $("[name=tableName]")[0].value);
            // });

            function getGeometry(option) {
                status = 1;
                $.ajax({
                    type: 'post',
                    url: config.queryurl,
                    // url: 'http://192.168.18.126:9016/v2/gis/analysis/ga/fserver/query',
                    data: {
                        "featureUrl": option.featureUrl,
                        "where": option.where,
                        "geometry": option.geometry,
                        "groupField": option.groupField || "",
                        "outStatistics": option.outStatistics || "",
                        "pageIndex": k * 2000,
                        "pageSize": "2000"
                    },
                    success: function (data) {
                        if (data.data.features.length === 0) {
                            return;
                        }
                        if (k === 0) {
                            showModel(data.data, option.field, '分类', config, true);
                        } else {
                            showModel(data.data, option.field, '分类', config, false);
                        }
                    },
                    complete: function (data) {
                        if (k < 5 && k !== -1) {
                            k = k + 1;
                            getGeometry(option);
                            return;
                        }
                        status = 0;
                    }
                });
            };

            $('#btn-analysis').click(function () {
                if (!overlayGeoJson) {
                    layer.msg("请上传或选择分析范围！");
                    return false;
                }
                k = 0;
                // 获取选取的年份以及对应的图层
                var years = new Array();
                var nowyear = "";
                sourceLayers = [];
                $("input:checkbox[name='years']:checked").each(function (m) {
                    var year = $(this).val();
                    if (year !== "2017" && year !== "2018") {  //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                        layer.msg("没有发现所选年度数据！");
                        return false;
                    }
                    years.push(year);
                    config.years.forEach(function (arr) {
                        if (arr.year === year) {
                            sourceLayers.push(arr);
                        }
                    })
                });
                if (years.length == 0) {
                    layer.msg("请选择年份！");
                    return false;
                }
                issave = false;
                $.ajax({
                    type: 'post',
                    url: '/overlay/ga/analysis',
                    data: {
                        "data": JSON.stringify(sourceLayers),
                        "overlay": overlayGeoJson,
                        "type": JSON.stringify(config.type)
                    },
                    beforeSend: function () {
                        showLoading("正在执行分析...");
                        /*layerIndex_wait = layer.msg("正在执行分析", {
                            icon: 16,
                            shade: [0.5, '#f5f5f5'],
                            scrollbar: false,
                            offset: 'auto',
                            time: 100000
                        });*/
                    },
                }).then(
                    function (obj) {
                        if (!obj || !obj.data) {
                            closeLoading();
                            //layer.close(layerIndex_wait);
                            layer.msg('分析失败！');
                        }
                        var data = obj.data['statistic'];
                        // var geometries = obj.data['geometry'];
                        layerNames = obj.data['names'];
                        tableIds = obj.data['tableIds'];

                        var tempCount = 0;
                        var tablesInfo = "<div ><label style='float: right;padding-right: 10px;'>面积单位：公顷</label>";

                        var resultHtml = '<fieldset class="layui-elem-field layui-field-title"><legend>分析结果</legend></fieldset>';
                        //resultHtml += '<div style="padding-left: 20px;"><button id="btn-showResult" type="button" class="layui-btn layui-btn-primary" style="margin: 10px 10px;border-width: 0 0 1px 0">统计数据</button>';
                        for (var key in data) {
                            tempCount++;
                            tablesInfo += "<div id='div-" + key + "' class='table-info div-hide' style='margin: 0px 10px;'><table id='" + key + "' class='layui-table' lay-filter='data-table' ></table></div>";
                            resultHtml += '<button name="showModel" type="button" style="margin: 10px 10px;border-width: 0 0 1px 0" class="layui-btn layui-btn-primary" value="' + key + '">' + key + '年</button>';
                        }
                        if (tempCount === 2) {
                            tablesInfo += "<div id='div-table-compare' class='table-info div-hide' style='margin: 0px 10px;'><table id='table-compare' class='layui-table' lay-filter='data-table' ></table></div>";
                            resultHtml += '<button name="showModel" style="margin: 10px 10px;border-width: 0 0 1px 0" type="button" class="layui-btn layui-btn-primary" value="compare">对比展示</button>';
                            resultHtml += '<button name="showModel" style="margin: 10px 10px;border-width: 0 0 1px 0" type="button" class="layui-btn layui-btn-primary" value="dlbhjz">地类变化矩阵</button>';
                        }
                        resultHtml += '<button name="download" style="margin: 10px 10px;border-width: 0 0 1px 0" type="button" class="layui-btn layui-btn-primary">申请下载</button>';
                        resultHtml += '</div>';
                        $('#div-button')[0].innerHTML = resultHtml;
                        tablesInfo += '<div class="div-execute"> <button id="btn-sjccsave" type="button" class="layui-btn new-blue-btn btn-execute">保存</button> <button id="btn-back" type="button" class="layui-btn new-blue-btn btn-execute">返回</button> </div></div>';
                        $("#div-result-table")[0].innerHTML = tablesInfo;
                        var tempStatistic = [];
                        var valueStatistic = [];
                        for (var key in data) {
                            var value = data[key];
                            table.render({
                                elem: "#" + key,
                                data: value,
                                id: key,
                                cols: [[
                                    {
                                        title: '分类',
                                        field: 'type',
                                        templet: function (obj) {
                                            if (!tempStatistic[obj.type]) {
                                                tempStatistic[obj.type] = [];
                                                tempStatistic[obj.type]["type"] = obj.type;
                                            }
                                            return obj.type;
                                        }
                                    },
                                    {
                                        title: '面积',
                                        field: 'area',
                                        templet: function (obj) {
                                            if (tempStatistic[obj.type]["area"]) {
                                                tempStatistic[obj.type]["area"] = (obj.area - tempStatistic[obj.type]["area"]).toFixed(2);
                                            } else {
                                                tempStatistic[obj.type]["area"] = parseFloat(obj.area).toFixed(2);
                                            }
                                            return parseFloat(obj.area).toFixed(2);
                                        }
                                    },
                                    {
                                        title: '占比',
                                        field: 'percent',
                                        templet: function (obj) {
                                            if (tempStatistic[obj.type]["percent"]) {
                                                tempStatistic[obj.type]["percent"] = (obj.percent - tempStatistic[obj.type]["percent"]).toFixed(4);
                                                valueStatistic.push({
                                                    "type": obj.type,
                                                    "area": tempStatistic[obj.type]["area"],
                                                    "percent": tempStatistic[obj.type]["percent"],
                                                    "geo": tempStatistic[obj.type]["geo"]
                                                });
                                            } else {
                                                tempStatistic[obj.type]["percent"] = parseFloat(obj.percent).toFixed(4);
                                            }
                                            return (parseFloat(obj.percent) * 100).toFixed(2) + "%";
                                        }
                                    }
                                ]],
                                done: function (res, curr, count) {
                                    table.resize(key);
                                }
                            });
                        }

                        var compareJson;
                        if (tempCount === 2) {
                            table.render({
                                elem: "#table-compare",
                                id: "table2",
                                data: valueStatistic,
                                cols: [[
                                    {
                                        title: '分类',
                                        field: 'type',
                                        templet: function (obj) {
                                            return obj["type"];
                                        },
                                    },
                                    {
                                        title: '面积差值',
                                        field: 'area',
                                        templet: function (obj) {
                                            // return obj["area"];
                                            return obj["area"];
                                        },
                                    },
                                    {
                                        title: '占比差值',
                                        field: 'percent',
                                        templet: function (obj) {
                                            // return obj["percent"];
                                            return (parseFloat(obj["percent"]) * 100).toFixed(2) + "%"
                                        },
                                    }
                                ]],
                                done: function (res, curr, count) {
                                    table.resize('table2');
                                },
                            });
                            var compareData = obj.data['compare'];
                            // compareJson = JSON.parse(compareData.geometries);
                            var params = compareData.statistic;
                            table.render({
                                elem: "#table-change",
                                skin: 'line',
                                even: true,
                                id: "table-change",
                                data: params,
                                cols: [[
                                    {
                                        title: '分类',
                                        field: 'type',
                                        width: 100,
                                        templet: function (obj) {
                                            return obj["type"];
                                        },
                                    },
                                    {
                                        title: '种植土地',
                                        field: '种植土地',
                                        width: 100,
                                        templet: function (obj) {
                                            if (obj["种植土地"]) {
                                                return obj["种植土地"];
                                            } else {
                                                return 0.00;
                                            }
                                        },
                                    },
                                    {
                                        title: '林草覆盖',
                                        field: '林草覆盖',
                                        width: 100,
                                        templet: function (obj) {
                                            if (obj["林草覆盖"]) {
                                                return obj["林草覆盖"];
                                            } else {
                                                return 0.00;
                                            }
                                        },
                                    },
                                    {
                                        title: '房屋建筑',
                                        field: '房屋建筑',
                                        width: 100,
                                        templet: function (obj) {
                                            if (obj["房屋建筑"]) {
                                                return obj["房屋建筑"];
                                            } else {
                                                return 0.00;
                                            }
                                        },
                                    },
                                    {
                                        title: '铁路与道路',
                                        field: '铁路与道路',
                                        width: 105,
                                        templet: function (obj) {
                                            if (obj["铁路与道路"]) {
                                                return obj["铁路与道路"];
                                            } else {
                                                return 0.00;
                                            }
                                        },
                                    },
                                    {
                                        title: '构筑物',
                                        field: '构筑物',
                                        width: 100,
                                        templet: function (obj) {
                                            if (obj["构筑物"]) {
                                                return obj["构筑物"];
                                            } else {
                                                return 0.00;
                                            }
                                        },
                                    },
                                    {
                                        title: '人工堆掘地',
                                        field: '人工堆掘地',
                                        width: 105,
                                        templet: function (obj) {
                                            if (obj["人工堆掘地"]) {
                                                return obj["人工堆掘地"];
                                            } else {
                                                return 0.00;
                                            }
                                        },
                                    },
                                    {
                                        title: '荒漠与裸露地',
                                        field: '荒漠与裸露地',
                                        width: 120,
                                        templet: function (obj) {
                                            if (obj["荒漠与裸露地"]) {
                                                return obj["荒漠与裸露地"];
                                            } else {
                                                return 0.00;
                                            }
                                        },
                                    },
                                    {
                                        title: '水域',
                                        field: '水域',
                                        width: 105,
                                        templet: function (obj) {
                                            if (obj["水域"]) {
                                                return obj["水域"];
                                            } else {
                                                return 0.00;
                                            }
                                        },
                                    }
                                ]],
                                done: function (res, curr, count) {
                                    var tableElem = this.elem.next();
                                    var dataTemp = table.cache[this.id];
                                    layui.each(dataTemp, function (index, data) {
                                        var titleHtml = "<div class='out'><b>" + years[1] + "</b><em>" + years[0] + "</em></div>"
                                        tableElem.find("th[data-field='type']").css("padding", "0 0").find("div").css("padding", "0 0").html(titleHtml);
                                    });
                                    table.resize('table-change');
                                },
                            });

                            var geokey;
                            var geoindex = 0;
                            // $.each(geometries, function (key, value) {
                            //     if(geoindex === 0){
                            //         geokey = key;
                            //     }
                            //     geoindex=1;
                            // });
                            $(".table-info").addClass("div-hide");
                            $("#div-" + geokey).removeClass("div-hide");
                            // showModel(compareJson, 'CC', '分类', config);
                            // model.addModel(compareJson, 'geojson');
                        } else {
                            var geokey;
                            var geoindex = 0;
                            // $.each(geometries, function (key, value) {
                            //     if(geoindex === 0){
                            //         geokey = key;
                            //     }
                            //     geoindex=1;
                            // });
                            $(".table-info").addClass("div-hide");
                            $("#div-" + geokey).removeClass("div-hide");

                            // showModel(compareJson, 'CC', '分类', config);
                            // model.addModel(geometries[0], 'geojson');
                        }


                        //监听行单击事件（单击事件为：rowDouble）
                        table.on('row', function (obj) {
                            if(status === 1){
                                layer.msg("上轮数据请求中！");
                                return false;
                            }

                            k = 0;
                            model.clear();

                            var data = obj.data;
                            //标注选中样式
                            obj.tr.addClass('layui-table-click').siblings().removeClass('layui-table-click');

                            var mapTypes = config.type1;
                            var typeSel = mapTypes[data["type"]];

                            var whereStr = "", nowType = "";//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                            if (nowyear === "2018") {
                                nowType = "newcc";
                                if (data["type"] === "其他") {
                                    whereStr = "newcc is null";
                                } else {
                                    whereStr = "newcc = '" + typeSel + "'";
                                }
                            } else if (nowyear === "2017") {
                                nowType = "newcc_overlay";
                                if (data["type"] === "其他") {
                                    whereStr = "newcc_overlay is null";
                                } else {
                                    whereStr = "newcc_overlay = '" + typeSel + "'";
                                }
                            } else if (nowyear === "compare") {
                                nowType = "newcc";
                                if (data["type"] === "其他") {
                                    whereStr = "newcc <> newcc_overlay AND newcc is null";
                                } else {
                                    whereStr = "newcc <> newcc_overlay AND newcc='" + typeSel + "'";
                                }
                            }

                            //获取图形数据并上图
                            var opt = {
                                "featureUrl": config.serverurl,
                                "where": whereStr,
                                "geometry": overlayGeoJson,
                                "groupField": "",
                                "outStatistics": "",
                                "field": nowType
                            };
                            getGeometry(opt);

                            // $.ajax({
                            //     type: 'post',
                            //     url: 'http://127.0.0.1:9016/v2/gis/analysis/ga/fserver/query',
                            //     // url: 'http://192.168.18.126:9016/v2/gis/analysis/ga/fserver/query',
                            //     data: {
                            //         "featureUrl": "https://hostserver.jsjcdlxxzx.gis/arcgis/rest/services/Hosted/dbfg2018dbfg2017overlayunion_areaCalculate_type/FeatureServer/0",
                            //         "where": whereStr,
                            //         "geometry": overlayGeoJson,
                            //         "groupField": "",
                            //         "outStatistics": ""
                            //     },
                            //     success: function (data) {
                            //         showModel(data.data, nowType, '分类', config);
                            //     }
                            // });
                        });

                        //分类点击事件
                        $(document).on('click', '[name=showModel]', function () {
                            if(status === 1){
                                layer.msg("上轮数据请求中！");
                                return false;
                            }

                            k = 0;
                            model.clear();

                            $("[name=showModel]").removeClass("button-select");
                            var value = $(this).val();
                            nowyear = value;
                            $(this).addClass("button-select");
                            if (value === 'compare') {        //年度对比
                                $(".table-info").addClass("div-hide");
                                // if (compareJson === '') {
                                //     layer.msg('无结果显示!');
                                // } else {
                                $("#div-table-compare").removeClass("div-hide");
                                // showModel(compareJson, 'CC', '分类', config);
                                // }


                                //获取图形数据并上图
                                var opt = {
                                    "featureUrl": config.serverurl,
                                    "where": "newcc<>newcc_overlay",
                                    "geometry": overlayGeoJson,
                                    "groupField": "",
                                    "outStatistics": "",
                                    "field": "ccchange"
                                };
                                getGeometry(opt);
                            } else if (value === 'dlbhjz') {    //地类变化矩阵
                                // $("#div-bottom-pane").css('display','block');
                                $("#div-showtable").css("width", "1100px");
                                $("#div-showtable").css("height", "290px");
                                $("#div-showtable").css("padding-left", "20px");
                                $("#div-showtable").css("overflow", "auto");
                                $("#div-showtable").css("padding-right", "20px");
                                $("#div-showtable").html($('#dlbhjz-div').html());
                                $("#div-bottom-pane").slideLeftShow(500);
                            } else {                            //年度
                                $(".table-info").addClass("div-hide");
                                $("#div-" + value).removeClass("div-hide");
                                // showModel(geometries[value], 'CC', '变化趋势', config);


                                var nowType = "";
                                if (value === "2018") {//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                                    nowType = "newcc";
                                } else {
                                    nowType = "newcc_overlay";
                                }
                                //获取图形数据并上图
                                var opt = {
                                    "featureUrl": config.serverurl,
                                    "where": "1=1",
                                    "geometry": overlayGeoJson,
                                    "groupField": "",
                                    "outStatistics": "",
                                    "field": nowType
                                };
                                getGeometry(opt);

                                // //获取图形数据并上图
                                // $.ajax({
                                //     type: 'post',
                                //     url: 'http://127.0.0.1:9016/v2/gis/analysis/ga/fserver/query',
                                //     // url: 'http://192.168.18.126:9016/v2/gis/analysis/ga/fserver/query',
                                //     data: {
                                //         "featureUrl": "https://hostserver.jsjcdlxxzx.gis/arcgis/rest/services/Hosted/dbfg2018dbfg2017overlayunion_areaCalculate_type/FeatureServer/0",
                                //         "where": "1=1",
                                //         "geometry": overlayGeoJson,
                                //         "groupField": "",
                                //         "outStatistics": ""
                                //     },
                                //     success: function (data) {
                                //         showModel(data.data, nowType, '分类', config);
                                //     }
                                // });
                            }
                        });

                        $(document).on('click', '[name=download]', function () {
                            if (issave === false) {
                                return layer.msg('请先保存数据！');
                            }
                            ;

                            var $divDownload = $('#div-download');
                            layer.close(layerIndex_download);
                            layerIndex_download = layer.open({
                                title: '提交申请',
                                shade: 0,
                                shadeClose: true,
                                type: 1,
                                area: ['500px', '360px'],
                                content: $divDownload.html(),
                            })
                        });

                        $(document).on('click', '#btn-sjccsave', function () {
                            if (issave === true) {
                                return layer.msg('数据已保存！');
                            }

                            showLoading("正在保存...");
                            for (var k = 0; k < layerNames.length; k++) {
                                $.ajax({
                                    type: 'post',
                                    url: '/overlay/saveResult',
                                    // async:false,
                                    data: {
                                        "layerName": layerNames[k],
                                        "featureCollection": tableIds[k]
                                    },
                                    success: function (data) {
                                        if (!data || !data.data) {
                                            layer.msg('保存失败！');
                                            issave = false;
                                            return false;
                                        }
                                        tableIDs.push(data.data);
                                    }
                                })
                            }
                            issave = true;
                            closeLoading();
                            layer.msg('保存成功！');
                        });
                        $(document).on('click', '#btn-back', function () {
                            divChange(2);
                        });
                        $(document).on('click', '#btn-download', function () {
                            if (layerNames === '') {
                                return layer.msg('无需申请下载的数据！');
                            }
                            if (issave === false) {
                                return layer.msg('请先保存数据！');
                            }
                            if (tableIDs.length === 0) {
                                return layer.msg('数据异步保存中！');
                            }
                            $.ajax({
                                type: 'post',
                                url: '/overlay/apply',
                                data: {
                                    "id": JSON.stringify(tableIDs),
                                    "reason": $('#text-reason')[0].value
                                }
                            }).then(
                                function (obj) {
                                    layer.msg('已成功提交申请，等待审核后可在数据治理中心下载！');
                                },
                                function (obj) {
                                    layer.msg('提交申请失败！');
                                }
                            )
                        });
                        closeLoading();
                        divChange(1);
                        // $(".table-info")[0].removeClass("div-hide");


                        $(".table-info").addClass("div-hide");
                        $("#div-" + years[0]).removeClass("div-hide");
                        nowyear = years[0];
                        MapUtils.viewer.entities.removeAll();
                        var nowType = "";
                        if (years[0] === "2018") {//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                            nowType = "newcc";
                        } else {
                            nowType = "newcc_overlay";
                        }
                        //获取图形数据并上图
                        var opt = {
                            "featureUrl": config.serverurl,
                            "where": "1=1",
                            "geometry": overlayGeoJson,
                            "groupField": "",
                            "outStatistics": "",
                            "field": nowType
                        };


                        getGeometry(opt);


                        // $.ajax({
                        //     type: 'post',
                        //     url: 'http://127.0.0.1:9016/v2/gis/analysis/ga/fserver/query',
                        //     // url: 'http://192.168.18.126:9016/v2/gis/analysis/ga/fserver/query',
                        //     data: {
                        //         "featureUrl": "https://hostserver.jsjcdlxxzx.gis/arcgis/rest/services/Hosted/dbfg2018dbfg2017overlayunion_areaCalculate_type/FeatureServer/0",
                        //         "where": "1=1",
                        //         "geometry": overlayGeoJson,
                        //         "groupField": "",
                        //         "outStatistics": ""
                        //     },
                        //     success: function (data) {
                        //         showModel(data.data, nowType, '分类', config);
                        //     }
                        // });


                        //
                        // if (!obj || !obj.data) {
                        //     closeLoading();
                        //     //layer.close(layerIndex_wait);
                        //     layer.msg('分析失败！');
                        // }
                        // var data = obj.data['statistic'];
                        // var geometries = obj.data['geometry'];
                        // layerNames = obj.data['names'];
                        // tableIds = obj.data['tableIds'];
                        // var tempCount = 0;
                        // var tablesInfo="<div ><label style='float: right;padding-right: 10px;'>面积单位：公顷</label>";
                        //
                        // var resultHtml = '<fieldset class="layui-elem-field layui-field-title"><legend>分析结果</legend></fieldset>';
                        // //resultHtml += '<div style="padding-left: 20px;"><button id="btn-showResult" type="button" class="layui-btn layui-btn-primary" style="margin: 10px 10px;border-width: 0 0 1px 0">统计数据</button>';
                        // for (var key in data) {
                        //     tempCount++;
                        //     tablesInfo+="<div id='div-" + key + "' class='table-info div-hide' style='margin: 0px 10px;'><table id='" + key + "' class='layui-table' lay-filter='data-table' ></table></div>";
                        //     resultHtml += '<button name="showModel" type="button" style="margin: 10px 10px;border-width: 0 0 1px 0" class="layui-btn layui-btn-primary" value="' + key + '">' + key + '年</button>';
                        // }
                        // if (tempCount === 2) {
                        //     tablesInfo+="<div id='div-table-compare' class='table-info div-hide' style='margin: 0px 10px;'><table id='table-compare' class='layui-table' lay-filter='data-table' ></table></div>";
                        //     resultHtml += '<button name="showModel" style="margin: 10px 10px;border-width: 0 0 1px 0" type="button" class="layui-btn layui-btn-primary" value="compare">对比展示</button>';
                        //     resultHtml += '<button name="showModel" style="margin: 10px 10px;border-width: 0 0 1px 0" type="button" class="layui-btn layui-btn-primary" value="dlbhjz">地类变化矩阵</button>';
                        // }
                        // resultHtml += '<button name="download" style="margin: 10px 10px;border-width: 0 0 1px 0" type="button" class="layui-btn layui-btn-primary">申请下载</button>';
                        // resultHtml += '</div>';
                        // $('#div-button')[0].innerHTML = resultHtml;
                        // tablesInfo+='<div class="div-execute"> <button id="btn-bar-new" type="button" class="layui-btn new-blue-btn btn-execute">柱状图</button> <button id="btn-pie-new" type="button" class="layui-btn new-blue-btn btn-execute">饼状图</button> <button id="btn-back" type="button" class="layui-btn new-blue-btn btn-execute">返回</button> </div></div>';
                        // $("#div-result-table")[0].innerHTML=tablesInfo;
                        // var tempStatistic = [];
                        // var valueStatistic = [];
                        // for (var key in data) {
                        //     var value = data[key];
                        //     table.render({
                        //         elem: "#" + key,
                        //         data: value,
                        //         id: key,
                        //         cols: [[
                        //             {
                        //                 title: '图形',
                        //                 field: 'geo',
                        //                 hide: true,
                        //                 templet: function (obj) {
                        //                     if (!tempStatistic[obj.type]) {
                        //                         tempStatistic[obj.type] = [];
                        //                         tempStatistic[obj.type]["geo"] = obj.geo;
                        //                     }
                        //                     return obj.geo;
                        //                 }
                        //             },
                        //             {
                        //                 title: '分类',
                        //                 field: 'type',
                        //                 templet: function (obj) {
                        //                     if (!tempStatistic[obj.type]) {
                        //                         tempStatistic[obj.type] = [];
                        //                         tempStatistic[obj.type]["type"] = obj.type;
                        //                     }
                        //                     return obj.type;
                        //                 }
                        //             },
                        //             {
                        //                 title: '面积',
                        //                 field: 'area',
                        //                 templet: function (obj) {
                        //                     if (tempStatistic[obj.type]["area"]) {
                        //                         tempStatistic[obj.type]["area"] = (obj.area - tempStatistic[obj.type]["area"]).toFixed(2);
                        //                     } else {
                        //                         tempStatistic[obj.type]["area"] = parseFloat(obj.area).toFixed(2);
                        //                     }
                        //                     return parseFloat(obj.area).toFixed(2);
                        //                 }
                        //             },
                        //             {
                        //                 title: '占比',
                        //                 field: 'percent',
                        //                 templet: function (obj) {
                        //                     if (tempStatistic[obj.type]["percent"]) {
                        //                         tempStatistic[obj.type]["percent"] = (obj.percent - tempStatistic[obj.type]["percent"]).toFixed(4);
                        //                         valueStatistic.push({
                        //                             "type": obj.type,
                        //                             "area": tempStatistic[obj.type]["area"],
                        //                             "percent": tempStatistic[obj.type]["percent"],
                        //                             "geo":tempStatistic[obj.type]["geo"]
                        //                         });
                        //                     } else {
                        //                         tempStatistic[obj.type]["percent"] = parseFloat(obj.percent).toFixed(4);
                        //                     }
                        //                     return (parseFloat(obj.percent) * 100).toFixed(2) + "%";
                        //                 }
                        //             }
                        //         ]],
                        //         done: function (res, curr, count) {
                        //             table.resize(key);
                        //         }
                        //     });
                        // }
                        //
                        // var compareJson;
                        // if (tempCount === 2) {
                        //     table.render({
                        //         elem: "#table-compare",
                        //         id: "table2",
                        //         data: valueStatistic,
                        //         cols: [[
                        //             {
                        //                 title: '分类',
                        //                 field: 'type',
                        //                 templet: function (obj) {
                        //                     return obj["type"];
                        //                 },
                        //             },
                        //             {
                        //                 title: '面积差值',
                        //                 field: 'area',
                        //                 templet: function (obj) {
                        //                     // return obj["area"];
                        //                     return obj["area"];
                        //                 },
                        //             },
                        //             {
                        //                 title: '占比差值',
                        //                 field: 'percent',
                        //                 templet: function (obj) {
                        //                     // return obj["percent"];
                        //                     return (parseFloat(obj["percent"]) * 100).toFixed(2) + "%"
                        //                 },
                        //             }
                        //         ]],
                        //         done: function (res, curr, count) {
                        //             table.resize('table2');
                        //         },
                        //     });
                        //     var compareData = obj.data['compare'];
                        //     compareJson = JSON.parse(compareData.geometries);
                        //     var params = compareData.statistic;
                        //     table.render({
                        //         elem: "#table-change",
                        //         skin: 'line',
                        //         even: true,
                        //         id: "table-change",
                        //         data: params,
                        //         cols: [[
                        //             {
                        //                 title: '分类',
                        //                 field: 'type',
                        //                 width: 100,
                        //                 templet: function (obj) {
                        //                     return obj["type"];
                        //                 },
                        //             },
                        //             {
                        //                 title: '种植土地',
                        //                 field: '种植土地',
                        //                 width: 100,
                        //                 templet: function (obj) {
                        //                     if (obj["种植土地"]) {
                        //                         return obj["种植土地"];
                        //                     } else {
                        //                         return 0.00;
                        //                     }
                        //                 },
                        //             },
                        //             {
                        //                 title: '林草覆盖',
                        //                 field: '林草覆盖',
                        //                 width: 100,
                        //                 templet: function (obj) {
                        //                     if (obj["林草覆盖"]) {
                        //                         return obj["林草覆盖"];
                        //                     } else {
                        //                         return 0.00;
                        //                     }
                        //                 },
                        //             },
                        //             {
                        //                 title: '房屋建筑',
                        //                 field: '房屋建筑',
                        //                 width: 100,
                        //                 templet: function (obj) {
                        //                     if (obj["房屋建筑"]) {
                        //                         return obj["房屋建筑"];
                        //                     } else {
                        //                         return 0.00;
                        //                     }
                        //                 },
                        //             },
                        //             {
                        //                 title: '铁路与道路',
                        //                 field: '铁路与道路',
                        //                 width: 105,
                        //                 templet: function (obj) {
                        //                     if (obj["铁路与道路"]) {
                        //                         return obj["铁路与道路"];
                        //                     } else {
                        //                         return 0.00;
                        //                     }
                        //                 },
                        //             },
                        //             {
                        //                 title: '构筑物',
                        //                 field: '构筑物',
                        //                 width: 100,
                        //                 templet: function (obj) {
                        //                     if (obj["构筑物"]) {
                        //                         return obj["构筑物"];
                        //                     } else {
                        //                         return 0.00;
                        //                     }
                        //                 },
                        //             },
                        //             {
                        //                 title: '人工堆掘地',
                        //                 field: '人工堆掘地',
                        //                 width: 105,
                        //                 templet: function (obj) {
                        //                     if (obj["人工堆掘地"]) {
                        //                         return obj["人工堆掘地"];
                        //                     } else {
                        //                         return 0.00;
                        //                     }
                        //                 },
                        //             },
                        //             {
                        //                 title: '荒漠与裸露地',
                        //                 field: '荒漠与裸露地',
                        //                 width: 120,
                        //                 templet: function (obj) {
                        //                     if (obj["荒漠与裸露地"]) {
                        //                         return obj["荒漠与裸露地"];
                        //                     } else {
                        //                         return 0.00;
                        //                     }
                        //                 },
                        //             },
                        //             {
                        //                 title: '水域',
                        //                 field: '水域',
                        //                 width: 105,
                        //                 templet: function (obj) {
                        //                     if (obj["水域"]) {
                        //                         return obj["水域"];
                        //                     } else {
                        //                         return 0.00;
                        //                     }
                        //                 },
                        //             },
                        //             {
                        //                 title: '地理单元',
                        //                 field: '地理单元',
                        //                 width: 105,
                        //                 templet: function (obj) {
                        //                     if (obj["地理单元"]) {
                        //                         return obj["地理单元"];
                        //                     } else {
                        //                         return 0.00;
                        //                     }
                        //                 },
                        //             },
                        //             {
                        //                 title: '地形',
                        //                 field: '地形',
                        //                 width: 105,
                        //                 templet: function (obj) {
                        //                     if (obj["地理单元"]) {
                        //                         return obj["地理单元"];
                        //                     } else {
                        //                         return 0.00;
                        //                     }
                        //                 },
                        //             }
                        //         ]],
                        //         done: function (res, curr, count) {
                        //             var tableElem = this.elem.next();
                        //             var dataTemp = table.cache[this.id];
                        //             layui.each(dataTemp, function (index, data) {
                        //                 var titleHtml = "<div class='out'><b>" + years[1] + "</b><em>" + years[0] + "</em></div>"
                        //                 tableElem.find("th[data-field='type']").css("padding", "0 0").find("div").css("padding", "0 0").html(titleHtml);
                        //             });
                        //             table.resize('table-change');
                        //         },
                        //     });
                        //
                        //     var geokey;
                        //     var geoindex = 0;
                        //     $.each(geometries, function (key, value) {
                        //         if(geoindex === 0){
                        //             geokey = key;
                        //         }
                        //         geoindex=1;
                        //     });
                        //     $(".table-info").addClass("div-hide");
                        //     $("#div-"+geokey).removeClass("div-hide");
                        //     showModel(compareJson, 'CC', '分类', config);
                        //     // model.addModel(compareJson, 'geojson');
                        // }
                        // else {
                        //     var geokey;
                        //     var geoindex = 0;
                        //     $.each(geometries, function (key, value) {
                        //         if(geoindex === 0){
                        //             geokey = key;
                        //         }
                        //         geoindex=1;
                        //     });
                        //     $(".table-info").addClass("div-hide");
                        //     $("#div-"+geokey).removeClass("div-hide");
                        //
                        //     showModel(compareJson, 'CC', '分类', config);
                        //     // model.addModel(geometries[0], 'geojson');
                        // }
                        //
                        //
                        // //监听行单击事件（单击事件为：rowDouble）
                        // table.on('row', function(obj){
                        //     var data = obj.data;
                        //
                        //     //要素定位
                        //     var geojson = JSON.parse(obj.data.geo);
                        //     try {
                        //         // aysSearch.geoJsonToMapGroud(geojson.features, {color: Cesium.Color.LIGHTSKYBLUE});
                        //         var temp = {
                        //             "type": "FeatureCollection",
                        //             "features": geojson.features
                        //         };
                        //         var promise = Cesium.GeoJsonDataSource.load(temp);
                        //         promise.then(function (dataSource) {
                        //             $that.removeEntity = dataSource;
                        //             MapUtils.viewer.dataSources.add(dataSource);
                        //             var entities = dataSource.entities.values;
                        //             MapUtils.setAllStyle(entities);
                        //         });
                        //         MapUtils.viewer.flyToViewer(promise);
                        //     } catch (e) {
                        //         console.log(e)
                        //     }
                        //
                        //     //展示选中行
                        //     //delete data["geo"];
                        //
                        //     //标注选中样式
                        //     obj.tr.addClass('layui-table-click').siblings().removeClass('layui-table-click');
                        //
                        // });
                        //
                        //
                        // $(document).on('click', '[name=showModel]', function () {
                        //     $("[name=showModel]").removeClass("button-select");
                        //     var value = $(this).val();
                        //     $(this).addClass("button-select");
                        //     if (value === 'compare') {
                        //         $(".table-info").addClass("div-hide");
                        //         if (compareJson === '') {
                        //             layer.msg('无结果显示!');
                        //         } else {
                        //             $("#div-table-compare").removeClass("div-hide");
                        //             showModel(compareJson, 'CC', '分类', config);
                        //             // model.addModel(compareJson, 'geojson');
                        //         }
                        //     } else if (value === 'dlbhjz'){
                        //         // $("#div-bottom-pane").css('display','block');
                        //         $("#div-showtable").css("width","1100px");
                        //         $("#div-showtable").css("height","290px");
                        //         $("#div-showtable").css("padding-left","20px");
                        //         $("#div-showtable").css("overflow","auto");
                        //         $("#div-showtable").css("padding-right","20px");
                        //         $("#div-showtable").html($('#dlbhjz-div').html());
                        //         $("#div-bottom-pane").slideLeftShow(500);
                        //
                        //         // layerIndex_result = layer.open({
                        //         //     title: '地类变化矩阵',
                        //         //     shade: 0,
                        //         //     shadeClose: true,
                        //         //     type: 1,
                        //         //     area: ['1200px', '600px'],
                        //         //     maxWidth: 1000,
                        //         //     content: $('#dlbhjz-div').html(),
                        //         // })
                        //     } else{
                        //         $(".table-info").addClass("div-hide");
                        //         $("#div-"+value).removeClass("div-hide");
                        //         showModel(geometries[value], 'CC', '变化趋势', config);
                        //         // model.addModel(geometries[value], 'geojson');
                        //     }
                        // });
                        //
                        // $(document).on('click', '[name=download]', function () {
                        //     var $divDownload = $('#div-download');
                        //     layer.close(layerIndex_download);
                        //     layerIndex_download = layer.open({
                        //         title: '提交申请',
                        //         shade: 0,
                        //         shadeClose: true,
                        //         type: 1,
                        //         area: ['500px', '360px'],
                        //         content: $divDownload.html(),
                        //     })
                        // });
                        //
                        // //柱状图
                        // $(document).on('click', '#btn-bar-new', function () {
                        //     $("#div-showtable").css("width","1100px");
                        //     $("#div-showtable").css("padding-left","20px");
                        //     $("#div-showtable").css("overflow","auto");
                        //     $("#div-showtable").css("padding-right","20px");
                        //     $("#div-showtable").css("height","290px");
                        //     $("#div-showtable").css("left","150px");
                        //     $("#div-showtable").css('top','20px');
                        // });
                        //
                        // //饼状图
                        // $(document).on('click', '#btn-pie-new', function () {
                        //     $("#div-showtable").css("width","1100px");
                        //     $("#div-showtable").css("height","290px");
                        //     $("#div-showtable").css("padding-left","20px");
                        //     $("#div-showtable").css("overflow","auto");
                        //     $("#div-showtable").css("padding-right","20px");
                        //     $("#div-showtable").css("left","150px");
                        //     $("#div-showtable").css('top','20px');
                        // });
                        //
                        // $(document).on('click', '#btn-back', function () {
                        //     divChange(2);
                        // });
                        // $(document).on('click', '#btn-download', function () {
                        //     if (layerNames === '') {
                        //         return layer.msg('无需申请下载的数据！');
                        //     }
                        //     $.ajax({
                        //         type: 'post',
                        //         url: '/overlay/apply',
                        //         data: {
                        //             "id": JSON.stringify(tableIds),
                        //             "reason": $('#text-reason')[0].value,
                        //         }
                        //     }).then(
                        //         function (obj) {
                        //             layer.msg('已成功提交申请，等待审核后可在数据治理中心下载！');
                        //         },
                        //         function (obj) {
                        //             layer.msg('提交申请失败！');
                        //         }
                        //     )
                        // });
                        // closeLoading();
                        // divChange(1);
                        // $(".table-info")[0].removeClass("div-hide");

                    },
                    function (obj) {
                        closeLoading();
                        //layer.close(layerIndex_wait);
                        layer.msg('分析失败！');
                    }
                );
                return false;
            });

            $('#showtable-close').click(function () {
                // $("#div-bottom-pane").css('display','none');
                // $("#div-bottom-pane").slideToggle(100,"swing");
                $("#div-bottom-pane").slideLeftHide(500);

                myChart.dispose();
            });

            jQuery.fn.slideLeftHide = function (speed, callback) {
                this.animate({
                    width: "hide",
                    paddingLeft: "hide",
                    paddingRight: "hide",
                    marginLeft: "hide",
                    marginRight: "hide"
                }, speed, callback);
            };
            jQuery.fn.slideLeftShow = function (speed, callback) {
                this.animate({
                    width: "show",
                    paddingLeft: "show",
                    paddingRight: "show",
                    marginLeft: "show",
                    marginRight: "show"
                }, speed, callback);
            };


            $('#btn-bar').click(function () {
                $("#div-showtable").css("width", "1100px");
                $("#div-showtable").css("padding-left", "20px");
                $("#div-showtable").css("overflow", "auto");
                $("#div-showtable").css("padding-right", "20px");
                $("#div-showtable").css("height", "290px");
                $("#div-showtable").css("left", "150px");
                $("#div-showtable").css('top', '20px');

                // $("#div-bottom-pane").css('display','block');
                $("#div-bottom-pane").slideLeftShow(500);
                if (myChart != undefined) {
                    myChart.dispose();
                }
                // 基于准备好的dom，初始化echarts实例
                myChart = echarts.init(document.getElementById('div-showtable'));

                // 指定图表的配置项和数据
                var option = {
                    title: {
                        text: '饼状图'
                    },
                    tooltip: {},
                    legend: {
                        data: ['销量']
                    },
                    xAxis: {
                        data: ["衬衫", "羊毛衫", "雪纺衫", "裤子", "高跟鞋", "袜子"]
                    },
                    yAxis: {},
                    series: [{
                        name: '销量',
                        type: 'bar',
                        data: [5, 20, 36, 10, 10, 20]
                    }]
                };

                // 使用刚指定的配置项和数据显示图表。
                myChart.setOption(option);
            });

            $('#btn-pie').click(function () {
                $("#div-showtable").css("width", "1100px");
                $("#div-showtable").css("height", "290px");
                $("#div-showtable").css("padding-left", "20px");
                $("#div-showtable").css("overflow", "auto");
                $("#div-showtable").css("padding-right", "20px");
                $("#div-showtable").css("left", "150px");
                $("#div-showtable").css('top', '20px');

                $("#div-bottom-pane").slideLeftShow(500);

                if (myChart != undefined) {
                    myChart.dispose();
                }
                // 基于准备好的dom，初始化echarts实例
                myChart = echarts.init(document.getElementById('div-showtable'));

                // 指定图表的配置项和数据
                var option = {
                    title: {
                        text: '饼状图',
                        subtext: 'demo',
                        x: 'center'
                    },
                    tooltip: {
                        trigger: 'item',
                        formatter: "{a} <br/>{b} : {c} ({d}%)"
                    },
                    legend: {
                        orient: 'vertical',
                        left: 'left',
                        data: ['直接访问', '邮件营销', '联盟广告', '视频广告', '搜索引擎']
                    },
                    series: [
                        {
                            name: '访问来源',
                            type: 'pie',
                            radius: '55%',
                            center: ['50%', '60%'],
                            data: [
                                {value: 335, name: '直接访问'},
                                {value: 310, name: '邮件营销'},
                                {value: 234, name: '联盟广告'},
                                {value: 135, name: '视频广告'},
                                {value: 1548, name: '搜索引擎'}
                            ],
                            itemStyle: {
                                emphasis: {
                                    shadowBlur: 10,
                                    shadowOffsetX: 0,
                                    shadowColor: 'rgba(0, 0, 0, 0.5)'
                                }
                            }
                        }
                    ]
                };

                // 使用刚指定的配置项和数据显示图表。
                myChart.setOption(option);
            });

            $(document).on('click', '#btn-showResult', function () {
                //layer.close(layerIndex_result);
                showLayer();
            });

            function showLayer() {
                /*layer.close(layerIndex_result);
                layerIndex_result = layer.open({
                    title: '分析结果',
                    shade: 0,
                    shadeClose: true,
                    type: 1,
                    area: ['1200px', '600px'],
                    maxWidth: 1000,
                    content: $('#div-result').html(),
                })*/
                table.resize('data-table');
            };
        })
    };

    var bindYears = function (config) {
        var $divYears = $('#divYear');
        var html = '';
        config.forEach(function (arr) {
            html += '<input type="checkbox" lay-filter="years" name="years" value="' + arr.year + '" lay-skin="primary" title="' + arr.year + '年" class="years">'
        });
        $divYears.html(html);
    }

    var divChange = function (type) {
        if (type === 1) {
            $("#dlgq-fxcz").addClass("div-hide");
            $('#div-result-table').removeClass("div-hide");
            $('#div-button').removeClass("div-hide");
        } else {
            $("#div-result-table").addClass("div-hide");
            $("#div-button").addClass("div-hide");
            $('#dlgq-fxcz').removeClass("div-hide");
        }
    }

    var convertGeoJson = function (index, obj) {
        var formData = new FormData();
        formData.append("geometry", index);
        if (index == 1) {
            formData.append("file", obj);
        } else {
            formData.append("layerName", obj);
        }
        $.ajax({
            type: "POST",
            url: "/dm/tool/geoJson",
            contentType: false,
            processData: false,
            async: false,
            data: formData,
            success: function (obj) {
                overlayGeoJson = obj.data;
            }
        });
    };

    var showModel = function (geojson, field, Name, config, showLoading) {
        // MapUtils.viewer.entities.removeAll();
        var obj = {};
        obj.gradeType = "string";
        obj.dic = config.type;
        obj.prop = field;
        obj.hideLegend = false;
        obj.colorDic = config.color;
        obj.gradeCallBack = function (e) {
            e = e.substr(0, 2);
            return e;
        };
        model._option.msg = "图形生成中...";
        model._option.polygonHeight = 25;
        model._option.clampToGround = true;
        model.setOption(obj);
        model.choroplethByArr(geojson, showLoading);
        // model.addModel(geojson, "geojson");
        // if (modelEntity) {
        //     aysSearch._removeEntity(modelEntity);
        // }
        // modelEntity = aysSearch.geoJsonToMapGroud(geojson.features, {color: new Cesium.Color.fromBytes(255, 175, 255)});
    };

    return instance;
});