/**
 *@Author: liujie<liu.im.jie@gmail.com>
 *@Created in 2019-09-11 14:43
 *@Description:
 *@Modify By:
 */

define(["global/core/EventBus","global/widgets/aysSearch/Index","global/core/Model",
    "global/utils/MapUtils", "global/utils/WidgetUtils"], function (EventBus, aysSearch, model, MapUtils, WidgetUtils) {
    var instance = {
        init: function () {
            // initLayer(this.config);
        },
        onOpen: function () {
            chooseFile = null;
            overlayer = null;
            tableIds = null;
            uploadIns = null;
            selectLayer = null;
            selectYear = null;
            $('.form-common').show();
            $('.form-result').hide();

            aysSearch.dataStoreDivInit();
            aysSearch.dataStoreDivOpen("#common-fxfw");

            initLayer(this.config);
        },
        onClose: function () {
            aysSearch.dataStoreDivClose();
            MapUtils.viewer.dataSources.removeAll();

            chooseFile = null;
            model.clear();
        },
        onPause: function () {
            aysSearch.dataStoreDivClose();
            MapUtils.viewer.dataSources.removeAll();
        },
    };

    var uploadIns,
        chooseFile,
        overlayer,
        selectLayer,
        selectYear,
        tableIds;

    var initLayer = function (config) {
        aysSearch.dataStoreDivOpen("#common-fxfw");
        aysSearch.dataStoreDiv("ays8");

        // EventBus.listener("ays8Analysis_file", function (e, data) {
        //     chooseFile = data;
        // });

        EventBus.listener("ays8Store", function (e, data) {
            chooseFile = data;
        });

        layui.config({base: "./js/"}).use(["element", "form", "layer", "upload", "table"], function () {
            var $ = layui.jquery, elem = layui.element, form = layui.form, layer = layui.layer,
                upload = layui.upload, table = layui.table;

            var layerIndex_download, layerNames;

            // // 切换范围选择方式
            // form.on('radio(geometry)', function (obj) {
            //     var value = obj.value,
            //         $divFile = $("#divUpload1"),
            //         $divTable = $("#divRange1");
            //
            //     if (value === '1') {
            //         $divFile.show();
            //         $divTable.hide();
            //     } else if (value === '2') {
            //         $divFile.hide();
            //         $divTable.show();
            //     }
            //     form.render();
            // });
            //
            // // 上传绑定
            // if (!uploadIns) {
            //     uploadIns = upload.render({
            //         elem: '#btn-uploadShp1',
            //         url: '',
            //         exts: 'zip',
            //         accept: 'file',
            //         auto: false,
            //         choose: function (obj) {
            //             obj.preview(function (index, file, result) {
            //                 chooseFile = file;
            //                 delete file;
            //                 showModel(chooseFile);
            //             });
            //             uploadIns.config.elem.next()[0].value = '';
            //         }
            //     });
            // }
            //
            // // 绑定数据仓储数据
            // bindStoreTables("/tablesinfo/search?page=1&limit=100&keyword=&moduleCode=ccglzy");


            // 绑定年份
            bindYears(config.years);

            form.render('select');

            // 年份改变时，改变(重新绑定)当前可选图层
            form.on('select(select-year)', function (obj) {
                selectYear = obj.value;

                var year = obj.value,
                    configYears = config.years,
                    // $divSelectLayer = $('#div-selectLayer'),
                    $selectLayer = $('#select-layer');

                // if (year === '') {
                //     $divSelectLayer.hide();
                // } else {
                configYears.forEach(function (arr) {
                    if (arr.year === year) {
                        var html = '';
                        var layers = arr.layers;
                        layers.forEach(function (layer) {
                            // html += '<input type="radio" name="selectLayer" lay-filter="select-layer" value="' + layer.name + '" title="' + layer.alisa + '">';
                            html += '<option value="' + layer.name + '">' + layer.alisa + '</option>';
                        });
                        $selectLayer.html(html);
                        form.render('select');
                    }
                });
                // }
            });

            // 记录选择的图层值
            form.on('select(select-layer)', function (obj) {
                selectLayer = obj.value;
            });

            // 提交
            $('#btn-analysis1').on('click', function () {
                var $selectRange = $('[name=range]'),
                    $selectTable = $('#tableName1'),
                    $lblUnit = $('#lbl-unit')[0];

                var layerIndex_wait;

                if (($selectRange.val() === '1' && !chooseFile) || ($selectRange.val() === '2' && ($selectTable.val() === '' || !$selectTable.val()))) {
                    return layer.msg("请选择分析范围！");
                }
                if (selectYear === '') {
                    return layer.msg("请选择分析年份！");
                }
                if (selectLayer === '') {
                    return layer.msg("请选择分析图层！");
                }

                var years = config.years;
                var field, crs, geoType;
                years.forEach(function (arr) {
                    if (arr.year === selectYear) {
                        var layers = arr.layers;
                        layers.forEach(function (layer) {
                            if (layer.name === selectLayer) {
                                field = layer.field;
                                geoType = layer.geoType;
                            }
                        });
                        crs = arr.crs;
                    }
                });
                var formData = new FormData();
                formData.append("file", chooseFile);
                formData.append("sourceLayer", selectLayer);
                formData.append("field", field);
                formData.append("crs", crs);
                formData.append("geoType", geoType);
                formData.append("GB", JSON.stringify(config.GB))
                $.ajax({
                    // type: 'post',
                    // url: '/overlay/common',
                    // data: {
                    //     'sourceLayer': selectLayer,
                    //     'overlayer': JSON.stringify(overlayer),
                    //     'field': field,
                    //     'crs': crs,
                    //     'geoType': geoType,
                    //     'GB': JSON.stringify(config.GB)
                    // },
                    type: 'post',
                    url: '/overlay/common',
                    contentType: false,
                    processData: false,
                    data: formData,
                    beforeSend: function () {
                        showLoading("分析进行中...");
                        // layerIndex_wait = layer.msg("正在执行分析", {
                        //     icon: 16,
                        //     shade: [0.5, '#f5f5f5'],
                        //     scrollbar: false,
                        //     offset: 'auto',
                        //     time: 100000
                        // });
                    },
                }).then(
                    function (obj) {
                        var data = obj.data;
                        closeLoading();
                        // layer.close(layerIndex_wait);
                        if (!data) {
                            layer.msg('叠加分析无结果!');
                            return false;
                        }
                        var geometry = data.geometry,
                            statistic = data.statistic,
                            colName,
                            colName1;
                        tableIds = data.tableIds;

                        $(".form-common").hide();
                        $(".form-result").show();

                        if (geoType === 'polygon') {
                            colName = '面积';
                            colName1 = '占比';
                            $lblUnit.innerText = '面积单位：平方千米';
                        } else if (geoType === 'polyline') {
                            colName = '长度';
                            colName1 = '占比';
                            $lblUnit.innerText = '长度单位：千米';
                        } else {
                            colName = '数目(个)';
                            colName1 = '面积(平方米)';
                            $lblUnit.innerText = '单位：个';
                            $('#lbl-unit').hide();
                        }
                        layerNames = data.layerName + new Date().toLocaleDateString().replace(/\//g, '');
                        $('#lbl_tableName')[0].innerText = "结果表名：";
                        $('#input-tableName').val(data.layerName + new Date().toLocaleDateString().replace(/\//g, ''));
                        // $('#lbl_tableName')[0].innerText = "结果表名：" + data.layerName + new Date().toLocaleDateString().replace(/\//g,'');
                        // $('#lbl_tableName')[0].innerText = "结果表名：十三五一轮液气储存设备" + new Date().toLocaleDateString();
                        // 展示统计数据
                        table.render({
                            elem: '#table-result',
                            data: statistic,
                            skin: 'line',
                            id: 'statistic',
                            cols: [[
                                {
                                    title: '分类',
                                    field: 'type',
                                    width: 120,
                                    templet: function (obj) {
                                        return obj.type;
                                    },
                                },
                                {
                                    title: colName,
                                    field: 'area',
                                    width: 90,
                                    templet: function (obj) {
                                        if (geoType === 'polygon') {
                                            return (parseFloat(obj.area) / 1000000).toFixed(2);
                                        } else if (geoType === 'polyline') {
                                            return (parseFloat(obj.area) / 1000).toFixed(2);
                                        } else {
                                            return parseFloat(obj.area).toFixed(0);
                                        }
                                    },
                                },
                                {
                                    title: colName1,
                                    field: 'percent',
                                    // width: 315,
                                    templet: function (obj) {
                                        if (geoType === 'polygon') {
                                            return (parseFloat(obj.percent) * 100).toFixed(2) + "%";
                                        } else if (geoType === 'polyline') {
                                            return (parseFloat(obj.percent) * 100).toFixed(2) + "%";
                                        } else {
                                            return parseFloat(obj.percent);
                                        }


                                    },
                                }
                            ]],
                            done: function (res, curr, count) {
                                table.resize();
                            }
                        });
                        var obj = {};
                        obj.gradeType = "string";
                        obj.dic = config.GB;
                        obj.prop = "GB";
                        obj.hideLegend = false;
                        model.addModel(geometry, "geojson");
                    },
                    function (obj) {
                        closeLoading();
                        // layer.close(layerIndex_wait);
                        layer.msg('分析失败！');
                    }
                );
                return false;
            });

            form.render();

            $("#btn-return1").click(function () {
                $(".form-common").show();
                $(".form-result").hide();
            });

            $('#btn-reset').click(function () {
                var $selectYear = $('[name=selectYear]'),
                    $divLayers = $('#div-selectLayer'),
                    $divFile = $("#div-file1"),
                    $divTable = $("#div-tableName1");

                chooseFile = null;
                $divLayers.hide();
                $divFile.show();
                $divTable.hide();
                model.clear();
                form.render('radio');
            });

            $('#btn-edit-name').click(function () {
                $.ajax({
                    type: 'post',
                    url: '/overlay/editLayerName',
                    data: {
                        "layerName": $('#input-tableName').val(),
                        "tableId": tableIds[0]
                    }
                }).then(
                    function (obj) {
                        if (obj.data) {
                            return layer.msg("修改名称成功！");
                        }
                        return layer.msg("修改名称失败！");
                    },
                    function (obj) {
                        return layer.msg("修改名称失败！");
                    }
                )
            });

            $('#btn-apply').click(function () {
                var $divDownload = $('#div-download1');
                layer.close(layerIndex_download);
                layerIndex_download = layer.open({
                    title: '提交申请',
                    shade: 0,
                    shadeClose: true,
                    type: 1,
                    area: ['500px', '360px'],
                    content: $divDownload.html(),
                })
            });

            $(document).on('click', '#btn-download', function () {
                if (layerNames === '') {
                    return layer.msg('无需申请下载的数据！');
                }
                $.ajax({
                    type: 'post',
                    url: '/overlay/apply',
                    data: {
                        "id": JSON.stringify(tableIds),
                        "reason": $('#text-reason')[0].value,
                    }
                }).then(
                    function (obj) {
                        layer.msg('已成功提交申请，等待审核后可在数据治理中心下载！');
                    },
                    function (obj) {
                        layer.msg('提交申请失败！');
                    }
                )
            });
        });
    };

    // 绑定数据仓储数据
    var bindStoreTables = function (url) {
        $.get(url).then(
            function (obj) {
                var data = obj.data;
                if (data) {
                    var html = '<option></option>';
                    var $selectTable = $('[name=tableName]');
                    data.forEach(function (table) {
                        html += '<option value="' + table.id + '">' + table.tableName + '</option>';
                    });
                    $selectTable.html(html);
                    form.render('select');
                } else {
                    layer.msg("数据仓储数据获取失败！");
                }
            },
            function (obj) {
                console.log(obj);
                layer.msg("数据仓储数据获取失败！");
            }
        );
    }

    // 绑定年份
    var bindYears = function (config) {
        var html = '';
        // var $selectYear = $('#div-years');
        var $selectYear = $('#select-year');

        config.forEach(function (arr) {
            var year = arr.year;
            // html += '<input type="radio" name="selectYear" lay-filter="select-year" value="' + year + '" title="' + year + '年">'
            html += '<option value="' + year + '">' + year + '年</option>';
        });
        $selectYear.html(html);
        var curYear = $selectYear.val(),
            $selectLayer = $('#select-layer');
        selectYear = curYear;

        config.forEach(function (arr) {
            if (arr.year === curYear) {
                var html = '';
                var layers = arr.layers;
                layers.forEach(function (layer) {
                    html += '<option value="' + layer.name + '">' + layer.alisa + '</option>';
                });
                $selectLayer.html(html);
                selectLayer = $selectLayer.val();
            }
        });
    }

    // 显示模型
    var showModel = function (file) {
        var $selectRange = $('[name=range]'),
            $selectTable = $('[name=tableName]'),
            formData = new FormData(),
            value = $selectRange.val();

        formData.append('geometry', value);
        if (value === '1') {
            formData.append('file', file);
        } else {
            formData.append('layerName', $selectTable.val());
        }
        $.ajax({
            type: 'post',
            url: '/dm/tool/geoJson',
            contentType: false,
            processData: false,
            data: formData,
        }).then(
            function (obj) {
                overlayer = obj.data;
                // model.addModel(overlayer, "geojson");
                var temp = {
                    "type": "FeatureCollection",
                    "features": overlayer.features
                };
                var promise = Cesium.GeoJsonDataSource.load(temp);
                promise.then(function (dataSource) {
                    instance.removeEntity = dataSource;
                    MapUtils.viewer.dataSources.add(dataSource);

                    var entities = dataSource.entities.values;

                    MapUtils.setAllStyle(entities);
                });
                MapUtils.viewer.flyToViewer(promise);
            },
            function (obj) {
                console.log(obj);
                layer.msg("生成模型失败！");
            }
        )
    }

    return instance;
});