define([
    "global/core/EventBus",
    "global/core/Model",
    "global/utils/MapUtils",
    "global/utils/WidgetUtils",
    "global/widgets/aysSearch/Index",
    "global/widgets/dataViews/upload",
    "global/core/GeometryStore"
], function (EventBus, model, MapUtils, WidgetUtils, aysSearch,Upload,geoStore) {
    var instance,
        me,
        oriEntity,
        clipEntity,
        resultEntity,
        $that = me = {
            upfile: "",
            upfile_cj: "",
            drawjson: "",
            layerIndex_wait: "",
            vargeojson: "",
            vargeojson_cj: "",

            // init fun
            init: function () {
                $that._initLayui();
                layui.form.render();
            },

            // open event
            onOpen: function () {
                aysSearch.dataStoreDivInit();
                aysSearch.dataStoreDiv2Init();
                aysSearch.dataStoreDiv2Open("#clip-ytc");
                aysSearch.dataStoreDivOpen("#clip-tc");
                $("#btn-save-clip").hide();

            },

            // close event
            onClose: function () {
                aysSearch.dataStoreDivClose();
                aysSearch.dataStoreDiv2Close();
                aysSearch.clearAll();
                $that.vargeojson = "";
                $that.vargeojson_cj = "";
                $that.drawjson = "";
            },

            // pause event
            onPause: function () {
                aysSearch.dataStoreDivClose();
                aysSearch.dataStoreDiv2Close();
                aysSearch.clearAll();
                $that.vargeojson = "";
                $that.vargeojson_cj = "";
                $that.drawjson = "";
            },


            // 初始化layui
            _initLayui: function () {
                aysSearch.dataStoreDiv2Open("#clip-ytc");
                aysSearch.dataStoreDivOpen("#clip-tc");
                aysSearch.dataStoreDiv("ays");
                aysSearch.dataStoreDiv2("ays2");

                EventBus.listener("aysStore", function (e, data) {
                    $that.vargeojson_cj = data;
                });
                EventBus.listener("ays2Store", function (e, data) {
                    $that.vargeojson = data;
                });
                layui.config({
                    base: './js/'
                }).use(['element','layer'], function () {
                    var $ = layui.jquery;
                    var layer = layui.layer;

                    var resultgeojson, layerIndex_download, tableId = [];

                    $(document).on('click', '#btReset-cj', function (evt) {
                        aysSearch.dataStoreDivInit();
                        aysSearch.dataStoreDiv2Init();
                        aysSearch.dataStoreDiv2Open("#clip-ytc");
                        aysSearch.dataStoreDivOpen("#clip-tc");
                        $("#btn-save-clip").hide();
                        aysSearch.clearAll();
                        aysSearch.dataStoreDivClose();
                        aysSearch.dataStoreDiv2Close();
                        aysSearch.clearAll();
                        $that.vargeojson = "";
                        $that.vargeojson_cj = "";
                        $that.drawjson = "";
                        document.getElementById('input-distance-y').value = "1";
                        document.getElementById('input-distance-cj').value = "1";
                    });

                    $(document).on('click', '#btOK-cj', function (evt) {
                        if ($that.vargeojson=="") {
                            layer.msg("未获取到源图形！");
                            return false;
                        }

                        if ($that.vargeojson_cj == "") {
                            layer.msg("未获取到裁剪图形！");
                            return false;
                        }
                        _kjAnalysis();
                        return false;
                    });

                    function _kjAnalysis() {
                        showLoading("分析进行中...");
                        var formData1 = new FormData();
                        formData1.append("inputGeometry", $that.vargeojson);
                        formData1.append("overlayGeometry", $that.vargeojson_cj);
                        $.ajax({
                            url: intersect,
                            type: "POST",
                            contentType: false,
                            processData: false,
                            data: formData1,
                            success: function (result) {
                                if (result.data == null) {
                                    closeLoading();
                                    //layer.close($that.layerIndex_wait);
                                    layer.msg("未得到分析结果！");
                                    return false;
                                }

                                resultgeojson = result.data;
                                aysSearch._removeEntity(resultEntity);

                                try {
                                    resultEntity = aysSearch.geoJsonToMapGroud(result.data.features, {color: new Cesium.Color.fromBytes(255, 175, 151, 255)});
                                    EventBus.trigger("aysResult",resultEntity );
                                } catch (e) {
                                    console.log(e)
                                }
                                closeLoading();
                                layer.msg("分析完成！");
                                $('#btn-save-clip').text('结果保存');
                                $('#btn-save-clip').show();
                            },
                            error: function (xhr, status, error) {
                                closeLoading();
                                //layer.close($that.layerIndex_wait);
                                layer.msg("分析失败！错误：" + error);
                            }
                        });
                        return false;
                    };

                    $('#btn-save-clip').click(function () {
                        if ($(this).text().trim() === '结果保存') {
                            //以下注释代码为弹窗显示，现改为直接在界面下方显示
                            // layer.close(layerIndex_download);
                            // layerIndex_download = layer.open({
                            //     title: '分析结果保存',
                            //     shade: 0,
                            //     shadeClose: true,
                            //     type: 1,
                            //     area: ['500px', '220px'],
                            //     content: $('#script-savedialog-clip').html(),
                            // });
                            $('#div-savedialog-clip').show();
                            $('#input-alisaName-clip').val("裁剪_" + new Date().toLocaleDateString().replace(/\//g, ''));

                        } else {
                            var $divDownload = $('#div-download-clip');
                            layer.close(layerIndex_download);
                            layerIndex_download = layer.open({
                                title: '提交申请',
                                shade: 0,
                                shadeClose: true,
                                type: 1,
                                area: ['500px', '360px'],
                                content: $divDownload.html(),
                            })
                        }
                    });

                    $(document).on('click', '#btn-save-execute-clip', function () {
                        $.ajax({
                            type: 'post',
                            url: '/overlay/saveResult',
                            data: {
                                "layerName": $('#input-alisaName-clip').val(),
                                "featureCollection": JSON.stringify(resultgeojson)
                            },
                            beforeSend: function (){
                                showLoading("正在保存结果");
                                /*layerIndex_wait = layer.msg("正在保存结果", {
                                    icon: 16,
                                    shade: [0.5, '#f5f5f5'],
                                    scrollbar: false,
                                    offset: 'auto',
                                    time: 100000
                                });*/
                            },
                        }).then(
                            function (obj) {
                                if (obj.data) {
                                    tableId.push(obj.data);
                                    $('#div-savedialog-clip').hide();
                                    layer.msg('保存成功，可在数据治理中心查看！');
                                    $('#btn-save-clip').text('申请下载');
                                    closeLoading();
                                } else {
                                    layer.msg('保存失败！');
                                    closeLoading();
                                }
                            },
                            function (obj) {
                                layer.msg('保存失败！');
                                closeLoading();
                            }
                        );
                        return false;
                    });

                    $(document).on('click', '#btn-download-clip', function () {
                        $.ajax({
                            type: 'post',
                            url: '/overlay/apply',
                            data: {
                                "id": JSON.stringify(tableId),
                                "reason": $('.text-reason').val(),
                            }
                        }).then(
                            function (obj) {
                                layer.msg('已成功提交申请，等待审核后可在数据治理中心下载！');
                            },
                            function (obj) {
                                layer.msg('提交申请失败！');
                            }
                        )
                    });

                })
            },

            // 初始化一些点击事件
            _initClick: function () {

            },

            _clear: function (clearType) {
                if (!clearType) {
                    aysSearch.clearAll();
                }
                switch (clearType) {
                    case 0:
                        aysSearch._removeEntity(oriEntity);
                        break;
                    case 1:
                        aysSearch._removeEntity(clipEntity);
                        //删除绘制图形
                        break;
                    case 2:
                        aysSearch._removeEntity(resultEntity);
                        break;
                }
            }

        };

    var interfaceConfig = WidgetUtils._appConfig.interface,
        parsefile = interfaceConfig.parsefile,
        buffer = interfaceConfig.buffer,
        intersect = interfaceConfig.intersect,
        downloadUrl = interfaceConfig.download;

    var globalUpload = "";

    /**
     * get instance
     *
     * @returns {*}
     */
    me.getInstance = function () {
        if (void 0 === instance) {
            instance = me;
        }
        return instance;
    };
    return me;
});
