define([
    "global/core/EventBus",
    "global/core/Model",
    "global/utils/MapUtils",
    "global/utils/WidgetUtils",
    "global/widgets/aysSearch/Index",
    "global/widgets/dataViews/upload",
    "global/core/GeometryStore"
], function (EventBus, model, MapUtils, WidgetUtils, aysSearch,Upload,geoStore) {
    var instance,
        oriEntity,
        bufferEntity,
        me,
        $that = me = {
            upfile: "",
            layerIndex_wait: "",
            // globalUpload:"",
            vargeojson: "",

            // init fun
            init: function () {
                $that._initLayui();
                layui.form.render();
            },

            // open event
            onOpen: function () {
                $("#btn-save-yqg").hide();
            },

            // close event
            onClose: function () {

            },

            // pause event
            onPause: function () {

            },

            // 初始化layui
            _initLayui: function () {
                layui.config({
                    base: './js/'
                }).use(['element', 'layer'], function () {
                    var $ = layui.jquery;
                    var layer = layui.layer;

                    $(document).on('click', '#btOK-yqg', function (evt) {
                        _kjAnalysis();
                        return false;
                    });

                    function _kjAnalysis() {
                        showLoading("分析进行中...");
                        var fxgeojson={};
                        fxgeojson["distance"]=parseInt($('#input-hcbj-yqg').val());
                        fxgeojson["tableName"]=$('#input-fxjg').val();
                        $.ajax({
                            type: "POST",
                            url: "http://192.168.90.33:8888/mso/workflow/process/wh8jrAMewJzHS2KT",
                            contentType: "application/json",
                            data: JSON.stringify(fxgeojson),
                            dataType: "json",
                            success: function (data) {
                                closeLoading();
                                layer.msg("分析任务提交成功");
                            },
                            error: function (err) {
                                closeLoading();
                                layer.msg("分析任务提交失败");
                                console.log(err);
                            }
                        });
                    };
                    
                    function getOrSetId() {
                        
                    }
                })
            }

        };


    /**
     * get instance
     *
     * @returns {*}
     */
    me.getInstance = function () {
        if (void 0 === instance) {
            instance = me;
        }
        return instance;
    };
    return me;
});
