define([
    "global/core/EventBus",
    "global/core/Model",
    "global/utils/MapUtils",
    "global/utils/WidgetUtils",
    "global/widgets/aysSearch/Index",
    "global/widgets/dataViews/upload",
    "global/core/GeometryStore"
], function (EventBus, model, MapUtils, WidgetUtils, aysSearch,Upload,geoStore) {
    var instance,
        oriEntity,
        bufferEntity,
        me,
        $that = me = {
            upfile: "",
            layerIndex_wait: "",
            // globalUpload:"",
            vargeojson: "",

            // init fun
            init: function () {
                $that._initLayui();
                layui.form.render();
            },

            // open event
            onOpen: function () {
                aysSearch.dataStoreDivInit();
                aysSearch.dataStoreDivOpen("#buffer-fxfw");

                $("#btn-save").hide();
            },

            // close event
            onClose: function () {
                aysSearch.dataStoreDivClose();
                MapUtils.viewer.dataSources.removeAll();

            },

            // pause event
            onPause: function () {
                aysSearch.dataStoreDivClose();
                MapUtils.viewer.dataSources.removeAll();
            },

            // 初始化layui
            _initLayui: function () {
                aysSearch.dataStoreDivOpen("#buffer-fxfw");
                aysSearch.dataStoreDiv("ays");

                EventBus.listener("aysStore", function (e, data) {
                    $that.vargeojson = data;
                });

                layui.config({
                    base: './js/'
                }).use(['element', 'layer'], function () {
                    var $ = layui.jquery;
                    var layer = layui.layer;

                    var resultgeojson, tableId = [], layerIndex_download;

                    $(document).on('click', '#btOK-bf', function (evt) {
                        if ($that.vargeojson == "") {
                            layer.msg("未获取到分析图形！");
                            return false;
                        }
                        _kjAnalysis();
                        return false;

                    });

                    function _kjAnalysis() {
                        showLoading("分析进行中...");
                        var formData1 = new FormData();
                        formData1.append("geometry", $that.vargeojson);
                        formData1.append("distance", $('#input-hcbj-bf').val());
                        $.ajax({
                            url: buffer,
                            type: "POST",
                            contentType: false,
                            processData: false,
                            data: formData1,
                            success: function (result) {
                                if (result.data == null) {
                                    closeLoading();
                                    layer.msg("未得到分析结果！");
                                    return false;
                                }
                                if (bufferEntity) {
                                    aysSearch._removeEntity(bufferEntity);
                                }
                                resultgeojson = result.data;

                                bufferEntity = aysSearch.geoJsonToMapGroud(result.data.features, {color: new Cesium.Color.fromBytes(255, 175, 255)});
                                EventBus.trigger("aysResult",bufferEntity );
                                closeLoading();
                                layer.msg("分析完成！");
                                $('#btn-save').text('结果保存');
                                $('#btn-save').show();
                                return;
                            },
                            error: function (xhr, status, error) {
                                closeLoading();
                                layer.msg("分析失败！错误：" + error);
                            }
                        });

                    };

                    $(document).on('click', '#btReset-bf', function (evt) {
                        aysSearch.dataStoreDivInit();
                        aysSearch.dataStoreDivOpen("#buffer-fxfw");
                        $("#btn-save").hide();
                        aysSearch.clearAll();
                        aysSearch.dataStoreDivClose();
                        MapUtils.viewer.dataSources.removeAll();
                        document.getElementById('input-hcbj-bf').value = "1";
                    });


                    $('#btn-save').click(function () {
                        if ($(this).text().trim() === '结果保存') {
                            //以下注释代码为弹窗显示，现改为直接在界面下方显示
                            // layer.close(layerIndex_download);
                            // layerIndex_download = layer.open({
                            //     title: '分析结果保存',
                            //     shade: 0,
                            //     shadeClose: true,
                            //     type: 1,
                            //     area: ['500px', '220px'],
                            //     content: $('#script-savedialog-buffer').html(),
                            // });
                            $('#div-savedialog-buffer').show();
                            var distance=$("#input-hcbj-bf").val();
                            $('#input-alisaName-buffer').val("缓冲区_"+distance+"千米_" + new Date().toLocaleDateString().replace(/\//g, ''));

                        } else {
                            var $divDownload = $('#div-download-bf');
                            layer.close(layerIndex_download);
                            layerIndex_download = layer.open({
                                title: '提交申请',
                                shade: 0,
                                shadeClose: true,
                                type: 1,
                                area: ['500px', '360px'],
                                content: $divDownload.html(),
                            })
                        }
                    });

                    $(document).on('click', '#btn-save-execute-buffer', function () {
                        $.ajax({
                            type: 'post',
                            url: '/overlay/saveResult',
                            data: {
                                "layerName": $('#input-alisaName-buffer').val(),
                                "featureCollection": JSON.stringify(resultgeojson)
                            },
                            beforeSend: function () {
                                showLoading("正在保存结果，请等待！");
                            },
                        }).then(
                            function (obj) {
                                if (obj.data) {
                                    tableId.push(obj.data);
                                    layer.msg('保存成功，可在数据治理中心查看！');
                                    $('#div-savedialog-buffer').hide();
                                    $('#btn-save').text('申请下载');
                                    closeLoading();
                                } else {
                                    layer.msg('保存失败！');
                                    closeLoading();
                                }
                            },
                            function (obj) {
                                layer.msg('保存失败！');
                                closeLoading();
                            }
                        );
                        return false;
                    });

                    $(document).on('click', '#btn-download', function () {
                        $.ajax({
                            type: 'post',
                            url: '/overlay/apply',
                            data: {
                                "id": JSON.stringify(tableId),
                                "reason": $('.text-reason').val(),
                            }
                        }).then(
                            function (obj) {
                                layer.msg('已成功提交申请，审核后可下载！');
                            },
                            function (obj) {
                                layer.msg('提交申请失败！');
                            }
                        )
                    });
                })
            },

            // 初始化一些点击事件
            _initClick: function () {

            },

        };

    var globalUpload = "";

    var interfaceConfig = WidgetUtils._appConfig.interface,
        parsefile = interfaceConfig.parsefile,
        buffer = interfaceConfig.buffer,
        downloadUrl = interfaceConfig.download;


    /**
     * get instance
     *
     * @returns {*}
     */
    me.getInstance = function () {
        if (void 0 === instance) {
            instance = me;
        }
        return instance;
    };
    return me;
});
