/**
 *  分析搜索
 * @author by <a href="mailto:chaomashi@gmail.com">Du</a>
 * @version v1.0 2019/7/18/20:19  Copyright gtmap Corp
 */

define([
    'global/utils/MapUtils',
    'knockout',
    'leaflet',
    'esri-leaflet',
    'lodash',
    'Cesium',
    'global/utils/WidgetUtils',
    'global/core/index',
    'global/core/EventBus',
    'global/core/DrawGeometry',
    "global/core/GeometryStore",
    "global/widgets/dataViews/upload"
], function (MapUtils,
             ko,
             L,
             LEsri,
             _,
             Cesium,
             WidgetUtils,
             Utils,
             EventBus,
             DrawGeometry,
             geoStore, Upload) {
    var instance,
        oriEntity,
        oriEntity2,
        resultEntity,
        me,
        $that = me = {

            // 查询配置
            queryConfig: "",

            // 监听
            handler: "",

            // 分析配置
            analysisConfig: "",

            // 全部挖掘组件
            widgetsAll: [],

            vargeojson: "",

            vargeojson2: "",
            // ycontent:"",


            sideLen: "1",
            pjdy: "square",
            fxxzqName: "xzq_e_2017",
            fxxzqdm: "",
            fxType: "shp",
            fxLayer: "",


            // init fun
            init: function () {
                $that.queryConfig = this.config.query;
                $that.analysisConfig = this.config.analysis;
                $that.excavateConfig = this.config.excavate;
                $that.modelerUrl = this.config.modelerUrl;
                $that.handler = new Cesium.ScreenSpaceEventHandler(MapUtils.viewer.scene.canvas);
                $that._initSearchSelect();
                if ($that.queryConfig) {
                    $that._initQuery();
                } else {
                    $(".ays-query-title").hide();
                    $(".ays-search-query").hide();
                }
                if ($that.analysisConfig) {
                    $that._initAnalysis();
                } else {
                    $(".ays-analysis-title").hide();
                    $(".ays-search-analysis-main").hide();
                }
                $that._initExcavate();
                $that._initClick();
                $that._initLayui();
                EventBus.listener("aysResult", function (e, data) {
                    resultEntity = data;
                });
            },

            // open event
            onOpen: function () {

            },

            geoJsonToMap: function (features, opt, callBack) {
                var temp = {
                    "type": "FeatureCollection",
                    "features": features
                };
                //获取最大高度
                $(features).each(function (i, e) {
                    var area = 0;
                    var maxHeight = 0;
                    try {
                        var coor = e.geometry.coordinates;
                        var polygon = turf.polygon(coor);
                        area = turf.area(polygon);
                        if (area > maxHeight) {
                            maxHeight = area;
                        }
                    } catch (e) {
                        console.log(e);
                    }
                });
                var dataSource = $that.removeEntity;
                if (maxHeight > 50000000) {
                    maxHeight = 500;
                } else {
                    maxHeight = 150;
                }
                var promise = Cesium.GeoJsonDataSource.load(temp);
                promise.then(function (dataSource) {
                    MapUtils.viewer.dataSources.add(dataSource);
                    var entities = dataSource.entities.values;
                    MapUtils.setAllStyle(entities);
                    if (callBack) {
                        callBack(dataSource);
                    }
                });
                MapUtils.viewer.flyToViewer(promise);
            },

            geoJsonToMapGroud: function (features, opt, callBack) {
                opt = opt || {};
                var entities = [];
                var geoType = "";
                //get first feature
                if (features && features.length > 0) {
                    geoType = features[0].geometry.type;
                    if (geoType.toLowerCase() == "linestring" || geoType.toLowerCase() == "multilinestring") {
                        return this.lineJsonToMapGroud(features);
                    }
                }
                var firstFeature =
                    $.each(features, function (i, e) {
                        var coors = e.geometry.coordinates;
                        var properties = e.properties;
                        var pointArr = [];
                        if (e.geometry.type == "Polygon") {
                            $(coors[0]).each(function (i, coor) {
                                pointArr.push(coor[0], coor[1], 20000000);
                            });
                        }
                        //to do
                        if (e.geometry.type == "MultiPolygon") {
                            $(coors[0]).each(function (i, geo) {
                                $(geo).each(function (i, coor) {
                                    pointArr.push(coor[0], coor[1], 20000000);
                                })
                            });
                        }

                        // if (e.geometry.type === "LineString") {
                        //     $(coors).each(function (i, coor) {
                        //         pointArr.push(coor[0], coor[1], 20000000);
                        //     });
                        // }

                        var position = Cesium.Cartesian3.fromDegreesArrayHeights(pointArr);
                        var color = opt.color || Cesium.Color.LIGHTSKYBLUE;
                        color = color.withAlpha(0.7);
                        // if (e.geometry.type === "LineString") {
                        //     var entity = MapUtils.viewer.entities.add({
                        //         line: {
                        //             hierarchy: {
                        //                 positions: position
                        //             },
                        //             material: color
                        //         },
                        //         properties: new Cesium.PropertyBag(properties)
                        //     });
                        //     entities.push(entity);
                        // } else {
                        var entity = MapUtils.viewer.entities.add({
                            polygon: {
                                hierarchy: {
                                    positions: position
                                },
                                material: color
                            },
                            properties: new Cesium.PropertyBag(properties),
                        });
                        entities.push(entity);
                        // }
                    });
                MapUtils.viewer.zoomTo(entities);
                return entities;
            },

            lineJsonToMapGroud: function (features) {
                var tmp = {};
                tmp.features = features;
                tmp.type = "FeatureCollection";
                var promise = Cesium.GeoJsonDataSource.load(tmp, {
                    stroke: Cesium.Color.HOTPINK,
                    // camera : MapUtils.viewer.scene.camera,
                    // canvas : MapUtils.viewer.scene.canvas,
                    // clampToGround: true
                });

                // ,{
                //         stroke: Cesium.Color.HOTPINK,
                //             camera : MapUtils.viewer.scene.camera,
                //             canvas : MapUtils.viewer.scene.canvas,
                //             clampToGround: true
                //     }

                promise.then(function (dataSource) {
                    MapUtils.viewer.dataSources.add(dataSource);
                    var entities = dataSource.entities.values;
                    $(entities).map(function (i, v) {
                        //to do
                        MapUtils.viewer.entities.add(v);
                    });
                    MapUtils.viewer.zoomTo(entities);
                    return entities;
                });
            },

            _removeEntity: function (entities) {
                if (!entities) {
                    return;
                }
                $(entities).each(function (i, e) {
                    MapUtils.viewer.entities.remove(e);
                })
            },
            // to do
            clearAll: function () {
                MapUtils.viewer.entities.removeAll();
                MapUtils.viewer.dataSources.removeAll();
            },

            // close event
            onClose: function () {
                $that._returnToSelect();

            },

            bindSelectLayer: function (elem, url, callBack) {
                layui.use(['form'], function (form) {
                    if (!elem || !url) {
                        return;
                    }
                    if (typeof url == "object") {
                        renderSelect(elem, url);
                    } else {
                        $.ajax({
                            url: url,
                            // async: false,
                            success: function (result) {
                                var content = result["data"];
                                var result1 = [];
                                if (content) {
                                    for (var i = 0; i < content.length; i++) {
                                        var item = {};
                                        item.id = content[i].id;
                                        item.name = content[i].tableName;
                                        result1.push(item);
                                    }
                                }

                                var renderData = result1;

                                renderSelect(elem, renderData);
                                closeLoading();
                                //layer.close($that.layerIndex_wait);
                                // document.getElementById('div-store-xj').style.display = 'block';
                            },
                            error: function (e, state, error) {
                                console.log(e);
                            }
                        });
                    }

                    /**
                     * 渲染选择框
                     */
                    function renderSelect(selector, dt) {
                        var $target = $(selector);
                        var option = "";
                        for (var i = 0; i < dt.length; i++) {
                            option += "<option value=" + dt[i].id + ">" + (dt[i].name || dt[i].label) + "</option>";
                        }
                        $target.html(option);
                        for (var i = 0; i < dt.length; i++) {
                            var id = dt[i].id;
                            $("#" + id).data(dt[i]);
                        }
                    }

                    form.render('select');
                    if (callBack) {
                        var filter = elem.replace("#", "");
                        //数据事件
                        form.on('select(' + filter + ')', function (data) {
                            var value = data.value;
                            var geoData = geoStore.get(value);
                            callBack(geoData);
                        });
                    }
                });

            },


            analysisDivInit: function () {
                layui.config({
                    base: './js/'
                }).use(['form'], function () {
                    var form = layui.form;
                    form.val('dataSource3', {
                        "ays3": "square",
                        "input-dy": "1"
                    });
                    form.val('dataSource4', {
                        "ays4": "1"
                    });
                });

                $("#div-fxfs-analysis").show();
                $("#div-xzq-analysis").hide();
                $("#div-radio-dy").show();
                $("#div-shp-analysis").show();
                $("#div-draw-analysis").hide();
                $("#div-store-analysis").hide();
                $("#div-lstc-analysis").hide();
            },
            analysisDivClose: function () {
                $that._removeEntity(oriEntity);
            },
            analysisDivOpen: function (elem) {
                $("#analysis").show();
                var analysisDiv = $("#analysis");
                $(elem).after(analysisDiv);
            },
            analysisDiv: function (drawId, config) {
                layui.config({
                    base: './js/'
                }).use(['element', 'upload', 'layer', 'table', 'form'], function () {
                    var $ = layui.jquery;
                    var form = layui.form;
                    var layer = layui.layer;

                    //监听评价单元选择事件
                    form.on('radio(ays3)', function (obj) {
                        if (obj.value === "square") {
                            $('#div-radio-dy').show();
                            $('#div-fxfs-analysis').show();
                            $('#div-xzq-analysis').hide();
                            $that.sideLen = $('#input-pjdylen').value;
                            $that.pjdy = "square";
                            $that.fxxzqName = "xzq_e_2017";
                            $that.fxxzqdm = "";
                            if ($('#radio-shp').is(":checked")) {
                                $that.fxType = "shp";
                                $that.fxLayer = "shpLayer";
                            } else if ($('#radio-sjcc').is(":checked")) {
                                $that.fxType = "sjcc";
                                $that.fxLayer = $('#select-tablestore-ays4').val();
                            } else if ($('#radio-draw').is(":checked")) {
                                $that.fxType = "geojson";
                                $that.fxLayer = $that.vargeojson;
                            } else if ($('#radio-lstc').is(":checked")) {
                                $that.fxType = "geojson";
                                $that.fxLayer = $that.vargeojson;
                            }
                        } else if (obj.value === "hexagonal") {
                            $('#div-radio-dy').show();
                            $('#div-fxfs-analysis').show();
                            $('#div-xzq-analysis').hide();
                            $that.sideLen = $('#input-pjdylen').value;
                            $that.pjdy = "hexagonal";
                            $that.fxxzqName = "xzq_e_2017";
                            $that.fxxzqdm = "";
                            if ($('#radio-shp').is(":checked")) {
                                $that.fxType = "shp";
                                $that.fxLayer = "shpLayer";
                            } else if ($('#radio-sjcc').is(":checked")) {
                                $that.fxType = "sjcc";
                                $that.fxLayer = $('#select-tablestore-ays4').val();
                            } else if ($('#radio-draw').is(":checked")) {
                                $that.fxType = "geojson";
                                $that.fxLayer = $that.vargeojson;
                            } else if ($('#radio-lstc').is(":checked")) {
                                $that.fxType = "geojson";
                                $that.fxLayer = $that.vargeojson;
                            }
                        } else if (obj.value === "sjxzq") {
                            $('#div-fxfs-analysis').hide();
                            $('#div-radio-dy').hide();
                            $('#div-xzq-analysis').show();
                            $("#div-shjxzq-analysis").show();
                            $("#div-sjxzq-analysis").hide();
                            $("#div-xjxzq-analysis").hide();
                            $("#select-shjxzq-analysis").empty();
                            $("#select-shjxzq-analysis").append("<option value=" + 32 + ">江苏省(32)</option>");

                            $that.sideLen = "";
                            $that.pjdy = "sjxzq";
                            $that.fxxzqName = "xzq_c_2017";
                            $that.fxxzqdm = $('#select-shjxzq').value;
                            $that.fxType = "xzq";
                            $that.fxLayer = "xzqLayer";

                            EventBus.trigger(drawId + "Analysis_file", null);
                        } else if (obj.value === "xjxzq") {
                            $('#div-fxfs-analysis').hide();
                            $('#div-radio-dy').hide();
                            $('#div-xzq-analysis').show();
                            $("#div-shjxzq-analysis").hide();
                            $("#div-sjxzq-analysis").show();
                            $("#div-xjxzq-analysis").hide();

                            $("#select-sjxzq-analysis").empty();
                            $("#select-sjxzq-analysis").append("<option value=" + 32 + ">江苏省(32)</option>");
                            for (var key in config.SJXZQ) {
                                $("#select-sjxzq-analysis").append("<option value=" + key + ">" + config.SJXZQ[key] + "(" + key + ")</option>");
                            }

                            $that.sideLen = "";
                            $that.pjdy = "xjxzq";
                            $that.fxxzqName = "xzq_d_2017";
                            $that.fxxzqdm = $('#select-sjxzq').val();
                            $that.fxType = "xzq";
                            $that.fxLayer = "xzqLayer";

                            EventBus.trigger(drawId + "Analysis_file", null);
                        } else if (obj.value === "xzjxzq") {
                            $('#div-fxfs-analysis').hide();
                            $('#div-radio-dy').hide();
                            $('#div-xzq-analysis').show();

                            $("#div-shjxzq-analysis").hide();
                            $("#div-sjxzq-analysis").hide();
                            $("#div-xjxzq-analysis").show();

                            $("#select-xjxzq-analysis").empty();
                            $("#select-xjxzq-analysis").append("<option value=" + 32 + ">江苏省(32)</option>");

                            $("#select-xjxzq-analysis").append("<optgroup label=\"南京市(3201)\">");
                            for (var key in config.NJSQX) {
                                $("#select-xjxzq-analysis").append("<option value=" + key + ">" + config.NJSQX[key] + "(" + key + ")</option>");
                            }
                            $("#select-xjxzq-analysis").append("</optgroup>");

                            $("#select-xjxzq-analysis").append("<optgroup label=\"无锡市(3202)\">");
                            for (var key in config.WXSQX) {
                                $("#select-xjxzq-analysis").append("<option value=" + key + ">" + config.WXSQX[key] + "(" + key + ")</option>");
                            }
                            $("#select-xjxzq-analysis").append("</optgroup>");

                            $("#select-xjxzq-analysis").append("<optgroup label=\"徐州市(3203)\">");
                            for (var key in config.XZSQX) {
                                $("#select-xjxzq-analysis").append("<option value=" + key + ">" + config.XZSQX[key] + "(" + key + ")</option>");
                            }
                            $("#select-xjxzq-analysis").append("</optgroup>");

                            $("#select-xjxzq-analysis").append("<optgroup label=\"常州市(3204)\">");
                            for (var key in config.CZSQX) {
                                $("#select-xjxzq-analysis").append("<option value=" + key + ">" + config.CZSQX[key] + "(" + key + ")</option>");
                            }
                            $("#select-xjxzq-analysis").append("</optgroup>");

                            $("#select-xjxzq-analysis").append("<optgroup label=\"苏州市(3205)\">");
                            for (var key in config.SZSQX) {
                                $("#select-xjxzq-analysis").append("<option value=" + key + ">" + config.SZSQX[key] + "(" + key + ")</option>");
                            }
                            $("#select-xjxzq-analysis").append("</optgroup>");

                            $("#select-xjxzq-analysis").append("<optgroup label=\"南通市(3206)\">");
                            for (var key in config.NTSQX) {
                                $("#select-xjxzq-analysis").append("<option value=" + key + ">" + config.NTSQX[key] + "(" + key + ")</option>");
                            }
                            $("#select-xjxzq-analysis").append("</optgroup>");

                            $("#select-xjxzq-analysis").append("<optgroup label=\"连云港市(3207)\">");
                            for (var key in config.LYGSQX) {
                                $("#select-xjxzq-analysis").append("<option value=" + key + ">" + config.LYGSQX[key] + "(" + key + ")</option>");
                            }
                            $("#select-xjxzq-analysis").append("</optgroup>");

                            $("#select-xjxzq-analysis").append("<optgroup label=\"淮安市(3208)\">");
                            for (var key in config.HASQX) {
                                $("#select-xjxzq-analysis").append("<option value=" + key + ">" + config.HASQX[key] + "(" + key + ")</option>");
                            }
                            $("#select-xjxzq-analysis").append("</optgroup>");

                            $("#select-xjxzq-analysis").append("<optgroup label=\"盐城市(3209)\">");
                            for (var key in config.YCSQX) {
                                $("#select-xjxzq-analysis").append("<option value=" + key + ">" + config.YCSQX[key] + "(" + key + ")</option>");
                            }
                            $("#select-xjxzq-analysis").append("</optgroup>");

                            $("#select-xjxzq-analysis").append("<optgroup label=\"扬州市(3210)\">");
                            for (var key in config.YZSQX) {
                                $("#select-xjxzq-analysis").append("<option value=" + key + ">" + config.YZSQX[key] + "(" + key + ")</option>");
                            }
                            $("#select-xjxzq-analysis").append("</optgroup>");

                            $("#select-xjxzq-analysis").append("<optgroup label=\"镇江市(3211)\">");
                            for (var key in config.ZJSQX) {
                                $("#select-xjxzq-analysis").append("<option value=" + key + ">" + config.ZJSQX[key] + "(" + key + ")</option>");
                            }
                            $("#select-xjxzq-analysis").append("</optgroup>");

                            $("#select-xjxzq-analysis").append("<optgroup label=\"泰州市(3212)\">");
                            for (var key in config.TZSQX) {
                                $("#select-xjxzq-analysis").append("<option value=" + key + ">" + config.TZSQX[key] + "(" + key + ")</option>");
                            }
                            $("#select-xjxzq-analysis").append("</optgroup>");

                            $("#select-xjxzq-analysis").append("<optgroup label=\"宿迁市(3213)\">");
                            for (var key in config.SQSQX) {
                                $("#select-xjxzq-analysis").append("<option value=" + key + ">" + config.SQSQX[key] + "(" + key + ")</option>");
                            }
                            $("#select-xjxzq-analysis").append("</optgroup>");

                            $("#select-xjxzq-analysis").append("<optgroup label=\"岛屿(329999)\">");
                            for (var key in config.JSSDY) {
                                $("#select-xjxzq-analysis").append("<option value=" + key + ">" + config.JSSDY[key] + "(" + key + ")</option>");
                            }
                            $("#select-xjxzq-analysis").append("</optgroup>");

                            $that.sideLen = "";
                            $that.pjdy = "xzjxzq";
                            $that.fxxzqName = "xzq_e_2017";
                            $that.fxxzqdm = $('#select-xjxzq').val();
                            $that.fxType = "xzq";
                            $that.fxLayer = "xzqLayer";
                            EventBus.trigger(drawId + "Analysis_file", null);
                        }
                        form.render('select');
                        EventBus.trigger(drawId + "pjdy", $that.pjdy);
                        EventBus.trigger(drawId + "sideLen", $that.sideLen);
                        EventBus.trigger(drawId + "fxxzqName", $that.fxxzqName);
                        EventBus.trigger(drawId + "fxxzqdm", $that.fxxzqdm);
                        EventBus.trigger(drawId + "fxType", $that.fxType);
                        EventBus.trigger(drawId + "fxLayer", $that.fxLayer);
                    });

                    //监听单元边长
                    $("#input-pjdylen-analysis").on("input", function (e) {
                        //获取input输入的值
                        $that.sideLen = e.delegateTarget.value;
                        EventBus.trigger(drawId + "sideLen", $that.sideLen);
                    });

                    //监听radiobutton选择事件
                    form.on('radio(ays4)', function (obj) {
                        $that._removeEntity(oriEntity);
                        $that._removeEntity(resultEntity);

                        if (obj.value == 1) {
                            $('#div-shp-analysis').show();
                            $('#div-draw-analysis').hide();
                            $('#div-sjcc-analysis').hide();
                            $("#div-lstc-analysis").hide();
                        } else if (obj.value == 2) {
                            $('#div-shp-analysis').hide();
                            $('#div-draw-analysis').show();
                            $('#div-sjcc-analysis').hide();
                            $("#div-lstc-analysis").hide();
                        } else if (obj.value == 3) {
                            $('#div-shp-analysis').hide();
                            $('#div-draw-analysis').hide();
                            $('#div-sjcc-analysis').show();
                            $("#div-lstc-analysis").hide();

                            if (document.getElementById('select-tablestore-analysis').options.length === 0) {
                                showLoading("正在读取图层...");
                                $that._bindingLayers('#select-tablestore-analysis', rootPath + "/tablesinfo/search?page=1&limit=1000000&keyword=");
                            } else {
                                $("#select-tablestore-analysis").val("直接选择或搜索选择");
                                form.render('select');
                            }
                        } else if (obj.value == 4) {
                            $('#div-shp-analysis').hide();
                            $('#div-draw-analysis').hide();
                            $('#div-sjcc-analysis').hide();
                            $("#div-lstc-analysis").show();
                            $that._bindingLayers("#lstc-filter-analysis", geoStore.get(), function (geoData) {
                                var feaCol = {};
                                feaCol.type = "FeatureCollection";
                                feaCol.features = [];
                                feaCol.features.push(geoData.feature);
                                $that.vargeojson = JSON.stringify(feaCol);
                                $that.fxType = "geojson";
                                $that.fxLayer = JSON.stringify(feaCol);
                                EventBus.trigger(drawId + "Store", $that.vargeojson);
                                EventBus.trigger(drawId + "pjdy", $that.pjdy);
                                EventBus.trigger(drawId + "sideLen", $that.sideLen);
                                EventBus.trigger(drawId + "fxxzqName", $that.fxxzqName);
                                EventBus.trigger(drawId + "fxxzqdm", $that.fxxzqdm);
                                EventBus.trigger(drawId + "fxType", $that.fxType);
                                EventBus.trigger(drawId + "fxLayer", $that.fxLayer);
                                try {
                                    $that._removeEntity(oriEntity);
                                    $that._removeEntity(resultEntity);
                                    oriEntity = $that.geoJsonToMapGroud([geoData.feature], {color: Cesium.Color.LIGHTSKYBLUE});
                                } catch (e) {
                                    console.log(e);
                                }
                            });
                        }
                        form.render('radio');
                    });

                    form.on('select(sel-shj)', function (data) {
                        $that.sideLen = "";
                        $that.pjdy = "sjxzq";
                        $that.fxxzqName = "xzq_c_2017";
                        $that.fxxzqdm = data.value;
                        EventBus.trigger(drawId + "pjdy", $that.pjdy);
                        EventBus.trigger(drawId + "sideLen", $that.sideLen);
                        EventBus.trigger(drawId + "fxxzqName", $that.fxxzqName);
                        EventBus.trigger(drawId + "fxxzqdm", $that.fxxzqdm);
                    });
                    form.on('select(sel-sj)', function (data) {
                        $that.sideLen = "";
                        $that.pjdy = "xjxzq";
                        $that.fxxzqName = "xzq_d_2017";
                        $that.fxxzqdm = data.value;
                        EventBus.trigger(drawId + "pjdy", $that.pjdy);
                        EventBus.trigger(drawId + "sideLen", $that.sideLen);
                        EventBus.trigger(drawId + "fxxzqName", $that.fxxzqName);
                        EventBus.trigger(drawId + "fxxzqdm", $that.fxxzqdm);
                    });
                    form.on('select(sel-xj)', function (data) {
                        $that.sideLen = "";
                        $that.pjdy = "xzjxzq";
                        $that.fxxzqName = "xzq_e_2017";
                        $that.fxxzqdm = data.value;
                        EventBus.trigger(drawId + "pjdy", $that.pjdy);
                        EventBus.trigger(drawId + "sideLen", $that.sideLen);
                        EventBus.trigger(drawId + "fxxzqName", $that.fxxzqName);
                        EventBus.trigger(drawId + "fxxzqdm", $that.fxxzqdm);
                    });


                    $("#btn-shp-analysis-input").on('change', function (e) {
                        EventBus.trigger(drawId + "Analysis_file", $("#btn-shp-analysis-input")[0].files[0]);

                        Upload.loadFile($(this), "btn-shp-analysis-input", function (result, result1) {
                            if (typeof result == "string") {
                                result = JSON.parse(result);
                            }
                            if (!result.value) {
                                layer.msg("未得到SHP解析数据！");
                                return false;
                            }
                            $that._removeEntity(oriEntity);
                            $that._removeEntity(resultEntity);
                            $that.vargeojson = JSON.stringify(result.value);
                            $that.fxType = "shp";
                            $that.fxLayer = "shpLayer";
                            EventBus.trigger(drawId + "Store", $that.vargeojson);
                            EventBus.trigger(drawId + "pjdy", $that.pjdy);
                            EventBus.trigger(drawId + "sideLen", $that.sideLen);
                            EventBus.trigger(drawId + "fxxzqName", $that.fxxzqName);
                            EventBus.trigger(drawId + "fxxzqdm", $that.fxxzqdm);
                            EventBus.trigger(drawId + "fxType", $that.fxType);
                            EventBus.trigger(drawId + "fxLayer", $that.fxLayer);
                            try {
                                oriEntity = $that.geoJsonToMapGroud(result.value.features, {color: Cesium.Color.LIGHTSKYBLUE});
                            } catch (e) {
                                console.log(e)
                            }
                            return;
                        });
                    });

                    //数据仓储表选择事件
                    form.on('select(sjcc-filter-ays4)', function (data) {
                        showLoading("数据加载中...");
                        //初始化展示数据仓储图层
                        var formData1 = new FormData();
                        formData1.append("tableId", data.value);
                        $.ajax({
                            url: "/rest/rapid/table/geojson",
                            type: "POST",
                            contentType: false,
                            processData: false,
                            data: formData1,
                            success: function (result) {
                                $that.vargeojson = JSON.stringify(result.data);
                                $that.fxType = "geojson";
                                $that.fxLayer = JSON.stringify(result.data);
                                EventBus.trigger(drawId + "Store", $that.vargeojson);
                                EventBus.trigger(drawId + "pjdy", $that.pjdy);
                                EventBus.trigger(drawId + "sideLen", $that.sideLen);
                                EventBus.trigger(drawId + "fxxzqName", $that.fxxzqName);
                                EventBus.trigger(drawId + "fxxzqdm", $that.fxxzqdm);
                                EventBus.trigger(drawId + "fxType", $that.fxType);
                                EventBus.trigger(drawId + "fxLayer", $that.fxLayer);
                                $that._removeEntity(oriEntity);
                                $that._removeEntity(resultEntity);
                                try {
                                    oriEntity = $that.geoJsonToMapGroud(result.data.features, {color: Cesium.Color.LIGHTSKYBLUE});
                                } catch (e) {
                                    console.log(e);
                                }
                                closeLoading();
                            },
                            error: function (xhr, status, error) {
                                closeLoading();
                                layer.msg("数据获取失败！错误：" + error);
                            }
                        });
                    });

                    $(document).on('click', '#btDraw-analysis', function (evt) {
                        $that.layer.msg("开始绘制", {
                            time: 2000
                        });
                        DrawGeometry.draw({
                            type: "drawGroundSurface",
                            measure: true,
                            id: drawId + "DrawResult",
                            viewer: MapUtils.viewer
                        });
                    });

                    EventBus.listener(drawId + "DrawResult", function (e, data) {
                        $that.vargeojson = JSON.stringify(data);
                        $that.fxType = "geojson";
                        $that.fxLayer = JSON.stringify(data);

                        EventBus.trigger(drawId + "Store", $that.vargeojson);
                        EventBus.trigger(drawId + "pjdy", $that.pjdy);
                        EventBus.trigger(drawId + "sideLen", $that.sideLen);
                        EventBus.trigger(drawId + "fxxzqName", $that.fxxzqName);
                        EventBus.trigger(drawId + "fxxzqdm", $that.fxxzqdm);
                        EventBus.trigger(drawId + "fxType", $that.fxType);
                        EventBus.trigger(drawId + "fxLayer", $that.fxLayer);
                    });

                    $(document).on('click', '#btClear-analysis', function (evt) {
                        DrawGeometry.remove();
                        $that._removeEntity(resultEntity);
                        MapUtils.viewer.dataSources.removeAll();

                        $that.vargeojson = "";
                        EventBus.trigger(drawId + "Store", $that.vargeojson);
                    });


                })

            },


            dataStoreDivInit: function () {
                layui.config({
                    base: './js/'
                }).use(['form'], function () {
                    var form = layui.form;
                    form.val('dataSource', {
                        "ays": "1"
                    });
                });
                $("#div-shp-ays").show();
                $("#div-draw-ays").hide();
                $("#div-sjcc-ays").hide();
                $("#div-lstc-ays").hide();
            },
            dataStoreDivClose: function () {
                $that._removeEntity(oriEntity);
            },
            dataStoreDivOpen: function (elem) {
                $("#datastore").show();
                var dataStoreDiv = $("#datastore");
                $(elem).after(dataStoreDiv);
            },
            dataStoreDiv: function (drawId) {
                var globalUpload = "";
                layui.config({
                    base: './js/'
                }).use(['element', 'upload', 'layer', 'table', 'form'], function () {
                    var $ = layui.jquery;
                    var table = layui.table;
                    var form = layui.form;
                    var layer = layui.layer;
                    var upload = layui.upload;

                    if (globalUpload == "") {
                        $("#btn-shp-ays-input").on('change', function (e) {
                            // EventBus.trigger(drawId + "Analysis_file", $("#btn-shp-ays-input")[0].files[0]);
                            Upload.loadFile($(this), "btn-shp-ays-input", function (result, result1) {
                                if (typeof result == "string") {
                                    result = JSON.parse(result);
                                }
                                if (!result.value) {
                                    layer.msg("未得到SHP解析数据！");
                                    return false;
                                }

                                $that._removeEntity(oriEntity);
                                $that._removeEntity(resultEntity);
                                $that.vargeojson = JSON.stringify(result.value);
                                EventBus.trigger(drawId + "Store", $that.vargeojson);
                                try {
                                    oriEntity = $that.geoJsonToMapGroud(result.value.features, {color: Cesium.Color.LIGHTSKYBLUE});
                                } catch (e) {
                                    console.log(e)
                                }
                                return;
                            });

                        });
                    }

                    //监听radiobutton选择事件
                    form.on('radio(ays)', function (obj) {
                        $that._removeEntity(oriEntity);
                        $that._removeEntity(resultEntity);

                        if (obj.value == 1) {
                            $('#div-shp-ays').show();
                            $('#div-draw-ays').hide();
                            $('#div-sjcc-ays').hide();
                            $("#div-lstc-ays").hide();
                        } else if (obj.value == 2) {
                            $('#div-shp-ays').hide();
                            $('#div-draw-ays').show();
                            $('#div-sjcc-ays').hide();
                            $("#div-lstc-ays").hide();
                        } else if (obj.value == 3) {
                            $('#div-shp-ays').hide();
                            $('#div-draw-ays').hide();
                            $('#div-sjcc-ays').show();
                            $("#div-lstc-ays").hide();

                            //if (document.getElementById('select-tablestore-ays').options.length === 0) {
                            showLoading("正在读取图层...");
                            $that._bindingLayers('#select-tablestore-ays', rootPath + "/tablesinfo/search?page=1&limit=1000000&keyword=");
                            //}else {
                            //   $("#select-tablestore-ays").val("直接选择或搜索选择");
                            //   form.render('select');
                            //}
                        } else if (obj.value == 4) {
                            $('#div-shp-ays').hide();
                            $('#div-draw-ays').hide();
                            $('#div-sjcc-ays').hide();
                            $("#div-lstc-ays").show();
                            $that._bindingLayers("#lstc-filter-ays", geoStore.get(), function (geoData) {
                                var feaCol = {};
                                feaCol.type = "FeatureCollection";
                                feaCol.features = [];
                                feaCol.features.push(geoData.feature);
                                $that.vargeojson = JSON.stringify(feaCol);
                                EventBus.trigger(drawId + "Store", $that.vargeojson);
                                try {
                                    $that._removeEntity(oriEntity);
                                    $that._removeEntity(resultEntity);
                                    oriEntity = $that.geoJsonToMapGroud([geoData.feature], {color: Cesium.Color.LIGHTSKYBLUE});
                                } catch (e) {
                                    console.log(e);
                                }
                            });
                        }
                        form.render('radio');
                    });

                    //数据仓储表选择事件
                    form.on('select(sjcc-filter-ays)', function (data) {
                        showLoading("数据加载中...");
                        //初始化展示数据仓储图层
                        var formData1 = new FormData();
                        formData1.append("tableId", data.value);
                        $.ajax({
                            url: "/rest/rapid/table/geojson",
                            type: "POST",
                            contentType: false,
                            processData: false,
                            data: formData1,
                            success: function (result) {
                                $that.vargeojson = JSON.stringify(result.data);
                                EventBus.trigger(drawId + "Store", $that.vargeojson);
                                $that._removeEntity(oriEntity);
                                $that._removeEntity(resultEntity);
                                try {
                                    oriEntity = $that.geoJsonToMapGroud(result.data.features, {color: Cesium.Color.ORANGREDE});
                                } catch (e) {
                                    console.log(e);
                                }
                                closeLoading();
                            },
                            error: function (xhr, status, error) {
                                closeLoading();
                                layer.msg("数据获取失败！错误：" + error);
                            }
                        });
                    });

                    $(document).on('click', '#btDraw-ays', function (evt) {
                        $that.layer.msg("开始绘制", {
                            time: 2000
                        });
                        DrawGeometry.draw({
                            type: "drawGroundSurface",
                            measure: true,
                            id: drawId + "DrawResult",
                            viewer: MapUtils.viewer
                        });
                    });

                    EventBus.listener(drawId + "DrawResult", function (e, data) {
                        $that.vargeojson = JSON.stringify(data);
                        EventBus.trigger(drawId + "Store", $that.vargeojson);
                    });

                    $(document).on('click', '#btClear-ays', function (evt) {
                        DrawGeometry.remove();
                        $that._removeEntity(resultEntity);
                        MapUtils.viewer.dataSources.removeAll();
                    });
                })

            },

            _bindingLayers: function (elem, url, callBack) {
                layui.config({
                    base: './js/'
                }).use(['element', 'form'], function () {
                    var $ = layui.jquery;
                    var form = layui.form;
                    if (!elem || !url) {
                        return;
                    }
                    if (typeof url == "object") {
                        renderSelect(elem, url);
                    } else {
                        $.ajax({
                            url: url,
                            // async: false,
                            success: function (result) {
                                var content = result["data"];
                                var result1 = [];
                                var item0 = {};
                                item0.id = "";
                                item0.name = "直接选择或搜索选择";
                                result1.push(item0);
                                if (content) {
                                    for (var i = 0; i < content.length; i++) {
                                        var item = {};
                                        item.id = content[i].id;
                                        item.name = content[i].tableName;
                                        result1.push(item);
                                    }
                                }
                                var renderData = result1;
                                renderSelect(elem, renderData);
                                closeLoading();
                                //layer.close($that.layerIndex_wait);
                                // document.getElementById('div-store-xj').style.display = 'block';
                            },
                            error: function (e, state, error) {
                                console.log(e);
                            }
                        });
                    }

                    /**
                     * 渲染选择框
                     */
                    function renderSelect(selector, dt) {
                        var $target = $(selector);
                        var option = "";
                        for (var i = 0; i < dt.length; i++) {
                            option += "<option value='" + dt[i].id + "'>" + (dt[i].name || dt[i].label) + "</option>";
                        }
                        $target.html(option);
                        for (var i = 0; i < dt.length; i++) {
                            var id = dt[i].id;
                            if (id.length > 0) {
                                $("#" + id).data(dt[i]);
                            }
                        }
                        form.render('select');
                    }

                    if (callBack) {
                        var filter = elem.replace("#", "");
                        //数据事件
                        form.on('select(' + filter + ')', function (data) {
                            var value = data.value;
                            var geoData = geoStore.get(value);
                            callBack(geoData);
                        });
                    }
                });

            },

            //dataStore
            dataStoreDiv2: function (drawId) {
                var globalUpload2 = "";
                layui.config({
                    base: './js/'
                }).use(['element', 'upload', 'layer', 'table', 'form'], function () {
                    var $ = layui.jquery;
                    var table = layui.table;
                    var form = layui.form;
                    var layer = layui.layer;
                    var upload = layui.upload;

                    if (globalUpload2 == "") {
                        $("#btn-shp-ays-input2").on('change', function (e) {
                            Upload.loadFile($(this), "btn-shp-ays-input2", function (result, result1) {
                                if (typeof result == "string") {
                                    result = JSON.parse(result);
                                }
                                if (!result.value) {
                                    layer.msg("未得到SHP解析数据！");
                                    return false;
                                }
                                $that._removeEntity(oriEntity2);
                                $that._removeEntity(resultEntity);
                                $that.vargeojson2 = JSON.stringify(result.value);
                                EventBus.trigger(drawId + "Store", $that.vargeojson2);
                                try {
                                    oriEntity2 = $that.geoJsonToMapGroud(result.value.features, {color: new Cesium.Color.fromBytes(155, 255, 151, 255)});
                                } catch (e) {
                                    console.log(e)
                                }
                                return;
                            });

                        });
                    }

                    //监听radiobutton选择事件
                    form.on('radio(ays2)', function (obj) {
                        $that._removeEntity(oriEntity2);
                        $that._removeEntity(resultEntity);
                        if (obj.value == 1) {
                            $('#div-shp-ays2').show();
                            $('#div-draw-ays2').hide();
                            $('#div-sjcc-ays2').hide();
                            $("#div-lstc-ays2").hide();
                        } else if (obj.value == 2) {
                            $('#div-shp-ays2').hide();
                            $('#div-draw-ays2').show();
                            $('#div-sjcc-ays2').hide();
                            $("#div-lstc-ays2").hide();
                        } else if (obj.value == 3) {
                            $('#div-shp-ays2').hide();
                            $('#div-draw-ays2').hide();
                            $('#div-sjcc-ays2').show();
                            $("#div-lstc-ays2").hide();

                            if (document.getElementById('select-tablestore-ays2').options.length === 0) {
                                showLoading("正在读取图层...");
                                $that._bindingLayers('#select-tablestore-ays2', rootPath + "/tablesinfo/search?page=1&limit=1000000&keyword=");
                            } else {
                                $("#select-tablestore-ays2").val("直接选择或搜索选择");
                                form.render('select');
                            }
                        } else if (obj.value == 4) {
                            $('#div-shp-ays2').hide();
                            $('#div-draw-ays2').hide();
                            $('#div-sjcc-ays2').hide();
                            $("#div-lstc-ays2").show();
                            $that._bindingLayers("#lstc-filter-ays2", geoStore.get(), function (geoData) {
                                var feaCol = {};
                                feaCol.type = "FeatureCollection";
                                feaCol.features = [];
                                feaCol.features.push(geoData.feature);
                                $that.vargeojson2 = JSON.stringify(feaCol);
                                EventBus.trigger(drawId + "Store", $that.vargeojson2);
                                try {
                                    $that._removeEntity(oriEntity2);
                                    $that._removeEntity(resultEntity);
                                    oriEntity2 = $that.geoJsonToMapGroud([geoData.feature], {color: new Cesium.Color.fromBytes(155, 255, 151, 255)});
                                } catch (e) {
                                    console.log(e);
                                }
                            });
                        }
                        form.render('radio');
                    });

                    //数据仓储表选择事件
                    form.on('select(sjcc-filter-ays2)', function (data) {
                        showLoading("数据加载中...");
                        //初始化展示数据仓储图层
                        var formData1 = new FormData();
                        formData1.append("tableId", data.value);
                        $.ajax({
                            url: "/rest/rapid/table/geojson",
                            type: "POST",
                            contentType: false,
                            processData: false,
                            data: formData1,
                            success: function (result) {
                                $that.vargeojson2 = JSON.stringify(result.data);
                                EventBus.trigger(drawId + "Store", $that.vargeojson2);
                                $that._removeEntity(oriEntity2);
                                $that._removeEntity(resultEntity);
                                try {
                                    oriEntity2 = $that.geoJsonToMapGroud(result.data.features, {color: new Cesium.Color.fromBytes(155, 255, 151, 255)});
                                } catch (e) {
                                    console.log(e);
                                }
                                closeLoading();
                            },
                            error: function (xhr, status, error) {
                                closeLoading();
                                layer.msg("数据获取失败！错误：" + error);
                            }
                        });
                    });
                })

            },
            dataStoreDiv2Open: function (elem) {
                $("#datastore2").show();
                var dataStoreDiv = $("#datastore2");
                $(elem).after(dataStoreDiv);
            },
            dataStoreDiv2Init: function () {
                layui.config({
                    base: './js/'
                }).use(['form'], function () {
                    var form = layui.form;
                    form.val('dataSource2', {
                        "ays2": "1"
                    });
                });
                $("#div-shp-ays2").show();
                $("#div-sjcc-ays2").hide();
                $("#div-lstc-ays2").hide();
            },
            dataStoreDiv2Close: function () {
                $that._removeEntity(oriEntity2);
                $that._removeEntity(resultEntity);
            },

            // pause event
            onPause: function () {
                $that._returnToSelect();
            },

            _loadWidget: function (widget, callBack) {
                try {
                    var main = null;
                    var widgetId = widget.id;
                    if (!widgetId) {
                        return main;
                    }
                    var url = rootPath + "/global/widgets/aysSearch/aysWidgets/" + widgetId;
                    require(["text!" + url + "/Index.html", "css!" + url + "/Style"], function (html) {
                        if (!html) {
                            Utils.log("widget [" + widgetId + "] must return BaseWidget")
                            return;
                        }
                        $('#' + widgetId + 'ExcavateWidget').append(html);
                        require([url + "/Index.js"], function (index) {
                            index.config = widget.config;
                            var widgetId = widget.id;
                            main = $.extend({
                                label: widget.label,
                                id: widgetId,
                                html: html
                            }, index);
                            Utils.log('组件 [' + widgetId + '] 加载完成 ');
                            // if(main.init){
                            //     main.init();
                            // }
                            $that.widgetsAll.push(main);
                            if (callBack) {
                                callBack(main);
                            }
                            // if(main&&main.id){
                            //     $('#' + widgetId + 'ExcavateWidget').append(html);
                            // }
                        })

                    }, function (err) {
                        Utils.error("模块 [" + widgetId + "] 加载异常请添加配置！")
                    });
                } catch (e) {
                    Utils.error("模块 [" + widgetId + "] 加载异常 [" + e.message + "]");
                }
            },

            _loadUserWidget: function (widget, callBack) {
                try {
                    var main = null;
                    var widgetId = widget.id;
                    if (!widgetId) {
                        return main;
                    }
                    var url = $that.modelerUrl + "?id=" + widgetId + "&theme=hide";
                    var html = "<iframe frameborder='no' class='userWidget' src='" + url + "'></iframe>";
                    $('#' + widgetId + 'ExcavateWidget').append(html);
                    main = {
                        label: widget.label,
                        id: widgetId,
                        html: html
                    };
                    Utils.log('组件 [' + widgetId + '] 加载完成 ');
                    $that.widgetsAll.push(main);
                    if (callBack) {
                        callBack(main);
                    }
                } catch (e) {
                    Utils.error("模块 [" + widgetId + "] 加载异常 [" + e.message + "]");
                }
            },

            // 初始化layui
            _initLayui: function () {
                layui.use(['carousel', 'form', 'layer', 'element'], function () {
                    var element = layui.element;
                    var layer = layui.layer;
                    $that.layer = layer;
                    $that.element = element;
                    var form = layui.form;
                    $that.form = form;
                    var carousel = layui.carousel;
                    $that.carousel = carousel;
                    form.render();
                    form.on('switch(switchQueryLayer)', function (data) {
                        if (data.elem.checked)
                            WidgetUtils.checkNode($that.serverId, true);
                        else
                            WidgetUtils.checkNode($that.serverId, false);
                        form.render();
                    });
                    form.on('select(aysSearchInput)', function (data) {
                        $.each($("#aysSearchQuery").find('span'), function (index, value) {
                            if (value.innerText === data.value) {
                                $(value).trigger('click');
                            }
                        })
                    });
                    element.on('tab(aysSearchTabs)', function (data) {
                        $.each(data.elem.find('li'), function (index, value) {
                            if ($(value).hasClass("layui-this")) {
                                // 直接从ko渲染的当前页面来获取，减少循环次数
                                $.each($that.koQueryTabs.queryTabsList(), function (count, temp) {
                                    if (temp.label === $(value).text())
                                        $that.serverId = temp.serverId;
                                })
                            }
                        });
                        $that._judgeSwitch($that.serverId);
                        // 关闭结果面板
                        $("#queryResult").hide();
                        $that.layer.closeAll();
                        $(".query-result").css('top', "unset");
                    });
                    $that.active = {
                        offset: function (detailData) {
                            var type = "r";
                            $that.popupId = '#layerDemo' + type;
                            var title = detailData.mainField;
                            var content = $that._createQueryRightDetailContent(detailData);
                            var left = screen.width - 309 + "px";
                            var top = $(".new-header-box").height() + $(".tool-widgets-pane").height() + 11 + "px";
                            var offSetTop = [top, left];

                            layer.open({
                                type: 1
                                , offset: offSetTop
                                , id: 'layerDemo' + type //防止重复弹出
                                , content: content
                                , title: [title, "background-color: rgba(67, 117, 253, 0.6);cursor: move;" +
                                "font-size: 1.3em;text-align: center;height: 90px;color: #fff;padding: 0;border-bottom: unset;background-image:url('/assets/images/bgPopupPanel.png')"]
                                , shade: 0 //不显示遮罩
                                , yes: function () {
                                    layer.closeAll();
                                }
                                , cancel: function () {
                                    $that.hasLayer = false;
                                    $($that.lastSelectId).removeClass("search-result-index-active");
                                }
                            });

                            $that.carousel.render({
                                elem: '#defaultPhoto'
                                , width: '250px'
                                , height: '250px'
                                , interval: 5000
                            });
                            $($($that.popupId).parent().find('a')[0])
                                .removeClass('layui-layer-ico').addClass('icon-f-close').css('color', '#ffffff')
                                .css('top', '-5px').css('font-size', '20px').attr('title', '关闭面板');

                            var fields = [];
                            if (detailData.queryType === "query") {
                                var keys = Object.keys(detailData.geometry.properties);
                                $.each(keys, function (index, value) {
                                    var temp = {};
                                    temp.key = $that.fieldAliases[value];
                                    temp.value = detailData.geometry.properties[value];
                                    fields.push(temp)
                                });
                            } else {
                                $.each(detailData.showField.split(","), function (index, value) {
                                    var temp = {};
                                    temp.key = value;
                                    temp.value = detailData.geometry.properties[value];
                                    fields.push(temp);
                                })
                            }

                            ko.applyBindings(new $that._createRightResultDetail(fields), document.getElementById("queryResultRightFields"));
                        }
                    };
                })
            },

            // 初始化信息查询方法
            _initQuery: function () {
                ko.applyBindings(new $that._createQuerySelect(), document.getElementById("aysSearchQuery"));

                // 初始化点击显示或隐藏查询结果的按钮
                $("#queryResultButton").on('click', function () {
                    if ($that.queryResult) {
                        if ($("#queryResult").css("display") === "none") {
                            $that._showQueryResult();
                        } else {
                            $("#queryResult").hide();
                            $that.layer.closeAll();
                            $(".query-result").css('top', "unset");
                        }
                    } else {
                        $that.layer.msg('暂无结果，请进行搜索', {
                            time: 2000
                        });
                    }

                })
            },

            // 显示结果div方法
            _showQueryResult: function () {
                $(".query-result").css('top', '24%');
                if (screen.width === 1920) {
                    $(".query-result").css('top', '16%');
                }
                $(".query-result").css('position', "absolute");
                $("#queryResult").show();
            },

            // knockout生成信息查询的div与点击事件
            _createQuerySelect: function () {
                var self = this;

                self.queryConfig = ko.observableArray($that.queryConfig);
                queryChildren = function (e) {
                    $that._createQueryDetail(e, "layer");
                };
                self.aysQuery = function (e) {
                    $that._createQueryDetail(e, "service");
                };

            },

            // 初始化分析方法
            _initAnalysis: function () {
                ko.applyBindings(new $that._createAnalysisSelect(), document.getElementById("aysSearchAnalysis"));
            },

            // knockout生成分析的div与点击事件
            _createAnalysisSelect: function () {
                var self = this;

                $.each($that.analysisConfig, function (index, type) {
                    $.each(type.children, function (count, widget) {
                        $that._loadWidget(widget);
                    })
                });

                self.analysisConfig = ko.observableArray($that.analysisConfig);

                analysisChildren = function (e) {
                    $.each($that.widgetsAll, function (index, value) {
                        if (e.id === value.id) {
                            $(".ays-search-excavate-detail").show();
                            $(".excavate-widget").hide();
                            $(".ays-search").hide();
                            if (value.onOpen) {
                                if (!value.inited) {
                                    value.init();
                                    value.inited = true;
                                }
                                value.onOpen();
                            }
                            $that.excavateWiget = value;
                            $("#aysSearchExcavateService").text(value.label);
                            $("#" + e.id + "ExcavateWidget").show();
                            $("#" + value.id + "ExcavateWidget").show();
                        }

                    })
                };
                self.aysAnalysis = function (e) {

                };
            },

            // 初始化搜索或者选择信息查询内容后的页面
            _createQueryDetail: function (e, type) {
                $(".ays-search").hide();
                $(".ays-search-query-detail").show();
                var list = [];
                var name = "";
                if (type === "layer") {
                    $.each($that.queryConfig, function (index, value) {
                        $.each(value.children, function (t, temp) {
                            if (temp.label === e.label) {
                                temp.this = "layui-this";
                                temp.show = "layui-show";
                                list = index;
                                name = temp.label;
                                $("#aysSearchQueryService").text(value.label);
                                list = value.children;
                                $.each(temp.condition, function (c, condition) {
                                    // 后续改成生成的代理地址的随机生成ID
                                    condition.id = temp.url.split("/")[7]
                                })
                            }
                        })
                    });
                } else {
                    $.each($that.queryConfig, function (index, value) {
                        if (value.label === e.label) {
                            value.children[0].this = "layui-this";
                            value.children[0].show = "layui-show";
                            name = value.children[0].label;
                            $("#aysSearchQueryService").text(value.label);
                            list = value.children;
                            $.each(value.children, function (t, temp) {
                                $.each(temp.condition, function (c, condition) {
                                    // 后续改成生成的代理地址的随机生成ID
                                    condition.id = temp.url.split("/")[7]
                                })
                            })
                        }
                    })
                }
                if ($that.koQueryTabs === undefined) {
                    ko.applyBindings(new $that._createQueryTabs(list), document.getElementById("aysSearchQueryTabs"));
                } else {
                    $that.koQueryTabs.queryTabsList(list);
                    $.each($("#aysSearchQueryTabs").find('li'), function (index, value) {
                        // layui可能切换失败，额外触发一次点击事件
                        if (value.innerText === name) {
                            $(value).trigger('click');
                        }
                    });
                }
                if ($that.koQueryTabsDeatil === undefined) {
                    ko.applyBindings(new $that._createQueryTabsDetail(list), document.getElementById("aysSearchQueryTabsContent"));
                } else {
                    $that.koQueryTabsDeatil.queryTabsDetails(list);
                }
                // 初始化switch,将图层Id
                $that.serverId = e.serverId;
                if (WidgetUtils.getCheckStatus($that.serverId)) {
                    $('input[name="switchQueryLayer' + $that.serverId + '"]').attr('checked', 'checked');
                } else {
                    $('input[name="switchQueryLayer' + $that.serverId + '"]').removeAttr('checked');
                }
                $that.form.render();
                $that.element.render();
            },

            // knockout生成信息查询内容页面
            _createQueryTabs: function (list) {
                var self = this;
                $that.koQueryTabs = self;
                self.queryTabsList = ko.observableArray(list);
            },

            // 判断并更改当前页面的switch状态
            _judgeSwitch: function (serverId) {
                try {
                    var checked = $('input[name="switchQueryLayer' + serverId + '"]')[0].checked;
                    if (WidgetUtils.getCheckStatus(serverId)) {
                        $('input[name="switchQueryLayer' + serverId + '"]')[0].checked = true;
                    } else {
                        $('input[name="switchQueryLayer' + serverId + '"]')[0].checked = false;
                    }
                    $that.form.render();
                } catch (e) {
                    console.log(e);
                }
            },

            // 生成详细查询面板
            _createQueryTabsDetail: function (list) {
                var self = this;
                $that.koQueryTabsDeatil = self;
                self.queryTabsDetails = ko.observableArray(list);

                self.query = function (e) {
                    var temp = LEsri.query({
                        url: e.url,
                        proxy: false
                    });

                    $that.queryLayerConfig = e;

                    e.type = "query";

                    var query = "";

                    $.each(e.condition, function (index, value) {
                        var temp = $("#" + value.id + value.key).val();
                        var type = $("#" + value.id + value.key).parent().find('input')[0].value;

                        if (temp !== "") {
                            // 等于类型
                            var withType = "";
                            if (type === "等于") {
                                withType = "='" + temp + "'";
                            } else if (type === "包含") {
                                withType = " like '%" + temp + "%'";
                            } else if (type === "大于") {
                                withType = ">'" + temp + "'";
                            } else if (type === "小于") {
                                withType = "<'" + temp + "'";
                            }
                            if (query === "") {
                                query = value.key + withType;
                            } else {
                                query += " and " + value.key + withType;
                            }
                        }
                    });
                    if (query === "") {
                        $that.layer.msg('请输入查询内容', {
                            time: 2000
                        });
                    } else {
                        temp.where(query).fields(e.fields).run(function (error, data, response) {
                            if (error) {
                                console.log(error);
                                $that.layer.msg("查询出错请联系管理人员", {
                                    time: 2000
                                });
                            } else if (data.features.length === 0) {
                                $that.layer.msg("查询无结果", {
                                    time: 2000
                                });
                            } else {
                                if ($that.resultLayer !== undefined) {
                                    MapUtils.viewer.dataSources.remove($that.resultLayer);
                                }
                                $that.fieldAliases = response.fieldAliases;
                                var leftResultList = [];
                                var showMain = $that.queryLayerConfig.showFields.main;
                                var showMinor = $that.queryLayerConfig.showFields.minor;
                                $.each(data.features, function (index, value) {
                                    var temp = {};
                                    temp.geometry = value;
                                    temp.mainField = value.properties[showMain];
                                    temp.minorField = value.properties[showMinor];
                                    temp.queryType = "query";
                                    temp.id = _.uniqueId();
                                    leftResultList.push(temp);
                                });
                                // 上图
                                var temp = {};
                                temp.features = data.features;
                                temp.type = data.type;
                                var promise = Cesium.GeoJsonDataSource.load(temp);
                                promise.then(function (dataSource) {
                                    $that.resultLayer = dataSource;
                                    MapUtils.viewer.dataSources.add(dataSource);

                                    var entities = dataSource.entities.values;
                                    $.each(entities, function (index, value) {
                                        MapUtils.setEntityStyle(value)
                                    });
                                });
                                MapUtils.viewer.flyTo(promise);
                                if ($that.koQueryResult === undefined) {
                                    ko.applyBindings(new $that._createQueryResult(leftResultList), document.getElementById("queryResult"));
                                } else {
                                    $that.koQueryResult.results(leftResultList);
                                    $that._showQueryResult();
                                }
                            }
                        })
                    }
                };

                self.identify = function (e) {
                    $that.queryLayerConfig = e;
                    $that.startIdentify = true;
                    $that.layer.msg('属性识别已开启', {
                        time: 2000
                    });
                    $that.handler.setInputAction(function (click) {
                        var clickPoint = MapUtils.viewer.scene.pickPosition(click.position);
                        var pointWithHeight = Cesium.Cartographic.fromCartesian(clickPoint);
                        var lat = Cesium.Math.toDegrees(pointWithHeight.latitude);
                        var lng = Cesium.Math.toDegrees(pointWithHeight.longitude);
                        var tempUrl = e.url.substr(0, e.url.length - 2);

                        var identifyUrl = tempUrl + '/identify';


                        var rectangle = MapUtils.viewer.camera.computeViewRectangle();
                        var west = rectangle.west / Math.PI * 180;
                        var north = rectangle.north / Math.PI * 180;
                        var east = rectangle.east / Math.PI * 180;
                        var south = rectangle.south / Math.PI * 180;

                        var params = {
                            f: 'json',
                            geometry: '{x: ' + lng + ', y: ' + lat + '}',
                            tolerance: 1,
                            mapExtent: west + ',' + south + ',' + east + ',' + north,
                            imageDisplay: '256,256,1',
                            layers: [0]
                        };
                        $.support.cors = true;// 执行属性识别Rest服务
                        $.ajax({
                            url: identifyUrl,
                            type: 'get',
                            dataType: 'jsonp',
                            data: params,
                            success: function (data, status) {
                                if ($that.resultLayer !== undefined) {
                                    MapUtils.viewer.dataSources.remove($that.resultLayer);
                                }
                                var features = $that._jsonToGeo(data);
                                var identifyList = [];
                                var showMain = $that.queryLayerConfig.showFieldsAliases.main;
                                var showMinor = $that.queryLayerConfig.showFieldsAliases.minor;
                                $.each(features.features, function (index, value) {
                                    var temp = {};
                                    temp.id = _.uniqueId();
                                    temp.mainField = value.properties[showMain];
                                    temp.minorField = value.properties[showMinor];
                                    temp.geometry = value;
                                    temp.showField = $that.queryLayerConfig.fieldAliases;
                                    temp.queryType = "identify";
                                    identifyList.push(temp);
                                });
                                // 上图
                                var temp = {};
                                temp.features = features.features;
                                temp.type = features.type;
                                var promise = Cesium.GeoJsonDataSource.load(temp, {
                                    stroke: new Cesium.Color(1, 1, 1, 0),
                                    fill: new Cesium.Color(1, 1, 1, 0)
                                });
                                promise.then(function (dataSource) {
                                    $that.resultLayer = dataSource;
                                    MapUtils.viewer.dataSources.add(dataSource);
                                    var entities = dataSource.entities.values;
                                    $.each(entities, function (index, value) {
                                        MapUtils.setEntityStyle(value)
                                    });
                                });
                                MapUtils.viewer.flyTo(promise);
                                if ($that.koQueryResult === undefined) {
                                    ko.applyBindings(new $that._createQueryResult(identifyList), document.getElementById("queryResult"));
                                } else {
                                    $that.koQueryResult.results(identifyList);
                                    $that._showQueryResult();
                                }
                                $("#queryResultId" + identifyList[0].id).trigger('click');
                            }
                        })

                    }, Cesium.ScreenSpaceEventType.LEFT_CLICK)
                };

                self.stopIdentify = function (e) {
                    if ($that.startIdentify) {
                        $that.handler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_CLICK);
                        $that.layer.closeAll();
                        if ($that.resultLayer !== undefined) {
                            MapUtils.viewer.dataSources.remove($that.resultLayer);
                        }
                        // 移除选中样式
                        $(".query-result-index-active").removeClass("query-result-index-active");
                        $("#queryResult").hide();
                        $(".query-result").css('top', "unset");
                        $that.layer.msg('属性识别已关闭', {
                            time: 2000
                        });
                        $that.startIdentify = false;
                    }
                }
            },

            // knockout生成查询左侧结果面板
            _createQueryResult: function (list) {
                var self = this;
                $that.queryResult = self;
                self.results = ko.observableArray(list);
                self.showDetails = function (e) {
                    $that.layer.closeAll();
                    if ($that.lastSelectId !== "") {
                        $($that.lastSelectId).removeClass("query-result-index-active");
                    }
                    $("#queryResultId" + e.id).addClass("query-result-index-active");
                    $that.lastSelectId = "#queryResultId" + e.id;
                    var promise = Cesium.GeoJsonDataSource.load(e.geometry, {
                        stroke: new Cesium.Color(1, 1, 1, 0),
                        fill: new Cesium.Color(1, 1, 1, 0)
                    });
                    promise.then(function (dataSource) {
                        $that.locationLayer = dataSource;
                        MapUtils.viewer.dataSources.add(dataSource);
                    });
                    MapUtils.viewer.flyTo(promise).then(function () {
                        MapUtils.viewer.dataSources.remove($that.locationLayer);
                    });

                    if ($that.hasLayer === false) {
                        $that.active["offset"].call(this, e);
                        $that.hasLayer = true;
                    } else {
                        setTimeout(function () {
                            $that.active["offset"].call(this, e);
                        }, 500);
                    }
                };
                $that.koQueryResult = self;
                $that._showQueryResult();
            },

            // 生成右侧详细信息面板
            _createQueryRightDetailContent: function () {
                return "<div class=\"query-result-right\">\n" +
                    "    <div class=\"query-result-right-fields\" id=\"queryResultRightFields\" data-bind=\"foreach: {data: fields, as: 'field'}\">\n" +
                    "        <div class=\"query-result-right-field\">\n" +
                    "            <div class='query-result-right-main'><span data-bind=\"text: field.key, title: filed.key\"></span></div>\n" +
                    "            <div class='query-result-right-minor'><span data-bind=\"text: field.value, title: field.value\"></span></div>\n" +
                    "        </div>\n" +
                    "    </div>\n" +
                    "</div>";
            },

            // knockout生成右侧详细属性
            _createRightResultDetail: function (data) {
                var self = this;

                self.fields = ko.observableArray(data)
            },

            // 详情页面返回事件
            _returnToSelect: function () {
                $(".ays-search").show();
                $(".ays-search-query-detail").hide();
                MapUtils.viewer.entities.removeAll();//移除实例
                $that.layer.closeAll();
                if ($that.resultLayer !== undefined) {
                    MapUtils.viewer.dataSources.remove($that.resultLayer);
                }
                $("#queryResult").hide();
                $(".query-result").css('top', "unset");
                $that.handler.removeInputAction(Cesium.ScreenSpaceEventType.LEFT_CLICK);
                $(".ays-search-excavate-detail").hide();
                if ($that.excavateWiget !== undefined) {
                    $("#" + $that.excavateWiget.id + "ExcavateWidget").hide();
                    $that.excavateWiget.onClose();
                    $that.excavateWiget = undefined;
                }

            },

            // 初始化一些点击事件
            _initClick: function () {
                $(".detail-back").on('click', function (e) {
                    // 详细页面左上返回事件
                    $that._returnToSelect();
                });
                $(".detail-close").on('click', function (e) {
                    $("#aysSearchLi").trigger('click');
                });

                $('#input-analysisSearch').bind('keypress', function (event) {
                    if (event.keyCode == 13) {
                        $that.contentSearch();
                    }
                });

                // 点击搜索图标触发树搜索
                $("#analysisSearchBtn").click(function () {
                    $that.contentSearch();
                });
            },

            // enterFind: function(e){
            //     if (e.keyCode == 13) {
            //         $that.contentSearch();
            //         return false;
            //     }
            // },

            //内容搜索事件
            contentSearch: function () {
                var searchContent = $("#input-analysisSearch")[0].value;
                var keyWordArr = searchContent.replace(/[\s]+/g, ' ').split(' ');
                if (keyWordArr === '' || keyWordArr === undefined || keyWordArr == null) {
                    return false;
                }

                var configAnalysis = new Map();
                configAnalysis.set("剖面分析", "<span class=\"layui-col-xs4 ays-analysis-select-children\" data-bind=\"id: child.id, text: child.label, click: analysisChildren, attr:{title: child.label}\" title=\"剖面分析\">剖面分析</span>@<span class=\"layui-col-xs4 ays-analysis-select-children\" data-bind=\"id: child.id, text: child.label, click: analysisChildren, attr:{title: child.label}\" title=\"剖面分析\"><span style=\"background-color:#ff0\">剖面分析</span></span>");
                configAnalysis.set("通视分析", "<span class=\"layui-col-xs4 ays-analysis-select-children\" data-bind=\"id: child.id, text: child.label, click: analysisChildren, attr:{title: child.label}\" title=\"通视分析\">通视分析</span>@<span class=\"layui-col-xs4 ays-analysis-select-children\" data-bind=\"id: child.id, text: child.label, click: analysisChildren, attr:{title: child.label}\" title=\"通视分析\"><span style=\"background-color:#ff0\">通视分析</span></span>");
                configAnalysis.set("淹没分析", "<span class=\"layui-col-xs4 ays-analysis-select-children\" data-bind=\"id: child.id, text: child.label, click: analysisChildren, attr:{title: child.label}\" title=\"淹没分析\">淹没分析</span>@<span class=\"layui-col-xs4 ays-analysis-select-children\" data-bind=\"id: child.id, text: child.label, click: analysisChildren, attr:{title: child.label}\" title=\"淹没分析\"><span style=\"background-color:#ff0\">淹没分析</span></span>");
                configAnalysis.set("可视域分析", "<span class=\"layui-col-xs4 ays-analysis-select-children\" data-bind=\"id: child.id, text: child.label, click: analysisChildren, attr:{title: child.label}\" title=\"可视域分析\">可视域分析</span>@<span class=\"layui-col-xs4 ays-analysis-select-children\" data-bind=\"id: child.id, text: child.label, click: analysisChildren, attr:{title: child.label}\" title=\"可视域分析\"><span style=\"background-color:#ff0\">可视域分析</span></span>");
                configAnalysis.set("阴影分析", "<span class=\"layui-col-xs4 ays-analysis-select-children\" data-bind=\"id: child.id, text: child.label, click: analysisChildren, attr:{title: child.label}\" title=\"阴影分析\">阴影分析</span>@<span class=\"layui-col-xs4 ays-analysis-select-children\" data-bind=\"id: child.id, text: child.label, click: analysisChildren, attr:{title: child.label}\" title=\"阴影分析\"><span style=\"background-color:#ff0\">阴影分析</span></span>");
                configAnalysis.set("缓冲区分析", "<span class=\"layui-col-xs4 ays-excavate-select-children\" data-bind=\"id: child.id, text: child.label, click: excavateChildren, attr:{title: child.label}\" title=\"缓冲区分析\">缓冲区分析</span>@<span class=\"layui-col-xs4 ays-excavate-select-children\" data-bind=\"id: child.id, text: child.label, click: excavateChildren, attr:{title: child.label}\" title=\"缓冲区分析\"><span style=\"background-color:#ff0\">缓冲区分析</span></span>");
                configAnalysis.set("图形裁剪分析", "<span class=\"layui-col-xs4 ays-excavate-select-children\" data-bind=\"id: child.id, text: child.label, click: excavateChildren, attr:{title: child.label}\" title=\"图形裁剪分析\">图形裁剪分析</span>@<span class=\"layui-col-xs4 ays-excavate-select-children\" data-bind=\"id: child.id, text: child.label, click: excavateChildren, attr:{title: child.label}\" title=\"图形裁剪分析\"><span style=\"background-color:#ff0\">图形裁剪分析</span></span>");
                configAnalysis.set("图形相交分析", "<span class=\"layui-col-xs4 ays-excavate-select-children\" data-bind=\"id: child.id, text: child.label, click: excavateChildren, attr:{title: child.label}\" title=\"图形相交分析\">图形相交分析</span>@<span class=\"layui-col-xs4 ays-excavate-select-children\" data-bind=\"id: child.id, text: child.label, click: excavateChildren, attr:{title: child.label}\" title=\"图形相交分析\"><span style=\"background-color:#ff0\">图形相交分析</span></span>");
                configAnalysis.set("交通干线影响评价分析", "<span class=\"layui-col-xs4 ays-excavate-select-children\" data-bind=\"id: child.id, text: child.label, click: excavateChildren, attr:{title: child.label}\" title=\"交通干线影响评价分析\">交通干线影响评价分析</span>@<span class=\"layui-col-xs4 ays-excavate-select-children\" data-bind=\"id: child.id, text: child.label, click: excavateChildren, attr:{title: child.label}\" title=\"交通干线影响评价分析\"><span style=\"background-color:#ff0\">交通干线影响评价分析</span></span>");
                configAnalysis.set("地理国情地类比对", "<span class=\"layui-col-xs4 ays-excavate-select-children\" data-bind=\"id: child.id, text: child.label, click: excavateChildren, attr:{title: child.label}\" title=\"地理国情地类比对\">地理国情地类比对</span>@<span class=\"layui-col-xs4 ays-excavate-select-children\" data-bind=\"id: child.id, text: child.label, click: excavateChildren, attr:{title: child.label}\" title=\"地理国情地类比对\"><span style=\"background-color:#ff0\">地理国情地类比对</span></span>");
                configAnalysis.set("地理要素统计分析", "<span class=\"layui-col-xs4 ays-excavate-select-children\" data-bind=\"id: child.id, text: child.label, click: excavateChildren, attr:{title: child.label}\" title=\"地理要素统计分析\">地理要素统计分析</span>@<span class=\"layui-col-xs4 ays-excavate-select-children\" data-bind=\"id: child.id, text: child.label, click: excavateChildren, attr:{title: child.label}\" title=\"地理要素统计分析\"><span style=\"background-color:#ff0\">地理要素统计分析</span></span>");
                configAnalysis.set("生态环境指数分析评价", "<span class=\"layui-col-xs4 ays-excavate-select-children\" data-bind=\"id: child.id, text: child.label, click: excavateChildren, attr:{title: child.label}\" title=\"生态环境指数分析评价\">生态环境指数分析评价</span>@<span class=\"layui-col-xs4 ays-excavate-select-children\" data-bind=\"id: child.id, text: child.label, click: excavateChildren, attr:{title: child.label}\" title=\"生态环境指数分析评价\"><span style=\"background-color:#ff0\">生态环境指数分析评价</span></span>");
                configAnalysis.set("公共服务度分析评价", "<span class=\"layui-col-xs4 ays-excavate-select-children\" data-bind=\"id: child.id, text: child.label, click: excavateChildren, attr:{title: child.label}\" title=\"公共服务度分析评价\">公共服务度分析评价</span>@<span class=\"layui-col-xs4 ays-excavate-select-children\" data-bind=\"id: child.id, text: child.label, click: excavateChildren, attr:{title: child.label}\" title=\"公共服务度分析评价\"><span style=\"background-color:#ff0\">公共服务度分析评价</span></span>");

                var idarray = [], zidarray = [];
                configAnalysis.forEach(function (value, key, map) {
                    for (var n = 0; n < keyWordArr.length; n++) {
                        if (key.indexOf(keyWordArr[n]) != -1 && keyWordArr[n].replace(/(^s*)|(s*$)/g, "").length != 0 && keyWordArr[n] != "") {
                            idarray.push(value);
                        }
                    }
                    zidarray.push(value);
                });

                var content = $("#div-bigDataContent")[0].innerHTML;
                for (var n = 0; n < zidarray.length; n++) {
                    var re = new RegExp("" + zidarray[n].split('@')[1] + "", "gmi");
                    content = content.replace(re, zidarray[n].split('@')[0]);
                }

                for (var n = 0; n < idarray.length; n++) {
                    var re = new RegExp("" + idarray[n].split('@')[0] + "", "gmi");
                    content = content.replace(re, idarray[n].split('@')[1]);
                }
                $("#div-bigDataContent")[0].innerHTML = content;


                // var searchContent00 = $("#aysSearchExcavate")[0].innerHTML;

                // // 高亮
                // idarray.map(function(value,index,array){
                //     $('#' + value).css("background-color", "#ff0");
                // });


                // $.each(idarray, function (i, val) {
                //     if (!val.hasOwnProperty(("children"))) {
                //         $('#' + val.tId + '_span').css("background-color", "#ff0");
                //     }
                // });


                // var searchContent = $("#input-analysisSearch")[0].value;
                // var keyWordArr = searchContent.replace(/[\s]+/g,' ').split(' ');
                // if (keyWordArr === '' || keyWordArr === undefined || keyWordArr == null) {
                //     return false;
                // }
                //
                // var content = ycontent.innerHTML;
                // var re,re1,re2;
                // var content1,content2,content3;
                // for(var n = 0; n < keyWordArr.length; n ++) {
                //     re = new RegExp(">"+keyWordArr[n]+"","gmi");
                //     re1 = new RegExp(""+keyWordArr[n]+"<","gmi");
                //     re2 = new RegExp(">"+keyWordArr[n]+"<","gmi");
                //     content1 = content.replace(re,'><span style="background-color:#ff0">'+keyWordArr[n]+'</span>');
                //     // if(content1 === content){
                //         content2 = content1.replace(re1,'<span style="background-color:#ff0">'+keyWordArr[n]+'</span><');
                //         // if(content1 === content){
                //             content3 = content2.replace(re2,'><span style="background-color:#ff0">'+keyWordArr[n]+'</span><');
                //         // }
                //     // }
                // }
                // $("#div-bigDataContent")[0].innerHTML = content3;
            },

            // 转化成featureCollection格式
            _jsonToGeo: function (features) {
                var geoFeatures = [];
                //将得到的json转成GeoJson
                features.results.forEach(function (result) {
                    var geoFeature = {
                        type: 'Feature',
                        properties: result.attributes,
                        id: result.attributes.OBJECTID,
                        layerId: result.layerId,
                        layerName: result.layerName,
                        geometry: {
                            type: '',
                            coordinates: []
                        }
                    };
                    //判断要素类型
                    switch (result.geometryType) {
                        case 'esriGeometryPolygon' :
                            geoFeature.geometry.type = 'Polygon';
                            geoFeature.geometry.coordinates = result.geometry.rings;
                            geoFeatures.push(geoFeature);
                            break;
                        case 'esriGeometryPolyline' :
                            geoFeature.geometry.type = 'LineString';
                            geoFeature.geometry.coordinates = result.geometry.paths[0];
                            geoFeatures.push(geoFeature);
                            break;
                        case 'esriGeometryPoint' :
                            geoFeature.geometry.type = 'Point';
                            geoFeature.geometry.coordinates = [result.geometry.x, result.geometry.y];
                            geoFeatures.push(geoFeature);
                            break;
                        case 'esriGeometryMultipoint':
                            geoFeature.geometry.type = 'MultiPoint';
                            geoFeature.geometry.coordinates = result.geometry.points;
                            geoFeatures.push(geoFeature);
                            break;
                    }
                });
                return {
                    features: geoFeatures,
                    type: 'FeatureCollection'
                };
            },

            // 渲染select框
            _initSearchSelect: function () {
                var content = "";
                $.each($that.queryConfig, function (index, value) {
                    content += "<option value='" + value.label + "'>" + value.label + "</option>";
                    $.each(value.children, function (count, temp) {
                        content += "<option value='" + temp.label + "'>" + temp.label + "</option>";
                    })
                });
                $("#aysSearchInput").append(content);
            },

            // 初始化分析挖掘
            _initExcavate: function () {
                $.each($that.excavateConfig, function (index, value) {
                    if (value.hasOwnProperty("url")) {
                        $.ajax({
                            url: value.url,
                            async: false
                        }).done(function (data) {
                            if (data.hasOwnProperty("content")) {
                                value.children = [];
                                $.each(data.content, function (i, v) {
                                    v.label = v.name;
                                    value.children.push(v);
                                });
                            }
                        });
                    }
                });
                ko.applyBindings(new $that._createExcavateSelect(), document.getElementById("aysSearchExcavate"));
                ko.applyBindings(new $that._createExcavateDetail(), document.getElementById("excavateMain"));
                $that._requireExcavate();
            },

            // 用ko初始化分析挖掘选择页面
            _createExcavateSelect: function () {
                var self = this;
                self.excavateConfig = ko.observableArray($that.excavateConfig);
                // self.aysExcavate = function (e) {
                //     $that._createExcavateDetail(e)
                // };
                excavateChildren = function (e) {
                    $(".ays-search-excavate-detail").show();
                    $(".ays-search").hide();
                    $("#aysSearchExcavateService").text(e.label);
                    $("#" + e.id + "ExcavateWidget").show();
                    $.each($that.widgetsAll, function (index, value) {
                        if (e.id === value.id) {
                            $that.excavateWiget = value;
                            if (!value.inited) {
                                value.init();
                                value.inited = true;
                            }
                            if (value.onOpen) {
                                value.onOpen();
                            }
                            EventBus.listener(value.id + "Draw", function () {
                                $that.layer.msg("开始绘制", {
                                    time: 2000
                                });
                                DrawGeometry.draw({
                                    type: "drawGroundSurface",
                                    measure: true,
                                    id: value.id + "DrawResult",
                                    viewer: MapUtils.viewer
                                });
                            });
                            EventBus.listener(value.id + "Clear", function () {
                                DrawGeometry.remove();
                            });
                        } else {
                            $("#" + value.id + "ExcavateWidget").hide();
                        }
                    })
                };

                userExcavateChildren = function (e) {
                    $(".ays-search-excavate-detail").show();
                    $(".ays-search").hide();
                    $("#aysSearchExcavateService").text(e.label);
                    $("#" + e.id + "ExcavateWidget").show();
                    $.each($that.widgetsAll, function (index, value) {
                        if (e.id === value.id) {
                            $that.excavateWiget = value;
                        } else {
                            $("#" + value.id + "ExcavateWidget").hide();
                        }
                    });
                }
            },

            // 初始化分析挖掘组件页面
            _createExcavateDetail: function () {
                var self = this;
                var allWidget = [];
                $.each($that.excavateConfig, function (index, value) {
                    if (value.hasOwnProperty("children")) {
                        $.each(value.children, function (count, widget) {
                            allWidget.push(widget);
                        })
                    }
                });
                $.each($that.analysisConfig, function (index, value) {
                    $.each(value.children, function (count, widget) {
                        if (!widget.id) {
                            return;
                        }
                        allWidget.push(widget);
                    })
                });
                self.excavateDetails = ko.observableArray(allWidget);
            },

            // 用requireJs渲染分析挖掘组件
            _requireExcavate: function () {
                $.each($that.excavateConfig, function (index, type) {
                    if (type.hasOwnProperty("url")) {
                        $.each(type.children, function (count, widget) {
                            $that._loadUserWidget(widget);
                        });
                    } else {
                        $.each(type.children, function (count, widget) {
                            $that._loadWidget(widget);
                            // try {
                            //     require(["text!" + url + "/Index.html", "css!" + url + "/Style"], function (html) {
                            //         if (!html) {
                            //             Utils.log("widget [" + widgetId + "] must return BaseWidget");
                            //             return;
                            //         }
                            //         $('#' + widgetId + 'ExcavateWidget').append(html);
                            //         require([url + "/Index"], function (index) {
                            //             index.config = widget.config;
                            //             var main = $.extend({
                            //                 id: widgetId,
                            //                 label: widget.label
                            //             }, index);
                            //             Utils.log('组件 [' + widgetId + '] 加载完成 ');
                            //             $that.widgetsAll.push(main);
                            //         })
                            //
                            //     }, function (err) {
                            //         Utils.error("模块 [" + widgetId + "] 加载异常请添加配置！")
                            //     });
                            // } catch (e) {
                            //     Utils.error("模块 [" + widgetId + "] 加载异常 [" + e.message + "]");
                            // }
                        })
                    }
                });
            }

        };

    /**
     * get instance
     *
     * @returns {*}
     */
    me.getInstance = function () {
        if (void 0 === instance) {
            instance = me;
        }
        return instance;
    };
    return me;
});