/**
 *
 * @author by <a href="mailto:chaomashi@gmail.com">Du</a>
 * @version v1.0 2019/7/20/9:32  Copyright gtmap Corp
 */

define(["knockout",
    "Cesium",
    "global/utils/MapUtils"
], function (
    ko,
    Cesium,
    MapUtils
) {
    var thisModelLayer;
    var viewModel = new LayerList();
    var instance,
        me,
        $that = me = {
            _viewer: MapUtils.viewer,
            // init fun
            init: function () {

                $that._scene = MapUtils.viewer.scene;
                $that._imageryLayers = MapUtils.viewer.scene.imageryLayers;
                $that._widget = MapUtils.viewer.cesiumWidget;
                $that._layers = this.config.layers;
                $that._fcLayer = {};
                $that._layer = {};
                $that._ids = [];

                // bindind ko
                ko.applyBindings(viewModel, document.getElementById("tool-applicationList"));
                viewModel.lyrList($that._layers);
                $that.initLayui($that._layers);
                $("#div-bottom-pane").append($("#image-components"));
                /*var handler = new Cesium.ScreenSpaceEventHandler(MapUtils.viewer.scene.canvas);
                handler.setInputAction(function (e) {
                    // 获取点击位置笛卡尔坐标
                    var position = $that._scene.pickPosition(e.position);
                    if (!position) {
                        position = Cesium.Cartesian3.fromDegrees(0, 0, 0);
                    }
                    // 从笛卡尔坐标获取经纬度
                    var cartographic = Cesium.Cartographic.fromCartesian(position);
                    var longitude = Cesium.Math.toDegrees(cartographic.longitude);
                    var latitude = Cesium.Math.toDegrees(cartographic.latitude);
                    var height = cartographic.height;
                    var data={"getFeatureMode":"SPATIAL",
                        "datasetNames":["data:shanhailu_1"],
                        "geometry":{
                            "points":[{"y":latitude, "x":longitude, "z":height}],
                            "type":"POINT"
                        },
                        "spatialQueryMode":"INTERSECT"
                    };
                    // 设置查询条件。Z在本例数据中代表户型面的底部高程，CENGG为层高，SmSdriW为最西边的经度，SmSdriE为最东边的经度，SmSdriS为最南边的纬度，SmSdriN为最北边的纬度
                    $.ajax({
                        url: "http://localhost:8090/iserver/services/data-shlModel/rest/data/featureResults.rjson?returnContent=true",
                        type: "POST",
                        contentType: false,
                        processData: false,
                        data: JSON.stringify(data),
                        success: function (resultString) {
                            var result=JSON.parse(resultString);
                            var fieldIndex=0;
                            if (result.hasOwnProperty("features")&&result.features.length>0){
                                var fieldNames=result.features[0].fieldNames;
                                $.each(fieldNames,function (i,e) {
                                    if (e=="SMID"){
                                        fieldIndex=i;
                                    }
                                });
                                $.each(result.features,function (i,e) {
                                    if (e.hasOwnProperty("fieldValues")){
                                        $that._ids.push(e.fieldValues[fieldIndex]);
                                    }
                                });
                            }

                            if ($that._fcLayer && $that._fcLayer.hasOwnProperty("modelLayerDetails")) {
                                $that._fcLayer.modelLayerDetails.setObjsVisible($that._ids,true);
                            }

                        },
                        error: function (xhr, status, error) {
                            //layer.msg("数据获取失败！错误：" + error);
                        }
                    });
                    }, Cesium.ScreenSpaceEventType.LEFT_CLICK);*/

            },

            // open event
            onOpen: function () {
                /*$.each($that._layers, function (i, val) {
                    $.each(MapUtils.viewer.scene.layers._layerQueue, function (j, e) {
                        if (e.name === val.name) {
                            MapUtils.viewer.scene.layers._layerQueue[j].selectEnabled = true;
                        }
                    })
                })*/
            },

            // close event
            onClose: function () {
                layui.use(['form', 'layer'], function () {
                    var form = layui.form, layer = layui.layer;
                    $(".application-fc-checkbox").prop("checked", false);
                    form.render();
                    layer.closeAll();
                    $.each($that._layers, function (i, val) {
                        // 移除房产模型
                        MapUtils.viewer.scene.layers.remove(val.layerName);
                    })
                });
            },

            // pause event
            onPause: function () {
                /*$.each($that._layers, function (i, val) {
                    $.each(MapUtils.viewer.scene.layers._layerQueue, function (j, e) {
                        if (e.name === val.name) {
                            MapUtils.viewer.scene.layers._layerQueue[j].selectEnabled = false;
                        }
                    })
                })*/
            },

            addlayer: function (layerOptions) {
                //加载图层并定位
                MapUtils.createGlobalLayer(layerOptions, $that._viewer);
                if (layerOptions.hasOwnProperty("cameraPosition")) {
                    try {
                        var cameraPosition = layerOptions.cameraPosition;
                        $that._scene.camera.flyTo({
                            destination: new Cesium.Cartesian3.fromDegrees(cameraPosition.longitude, cameraPosition.latitude, cameraPosition.altitude),
                            orientation: {
                                heading: cameraPosition.heading,
                                pitch: cameraPosition.pitch,
                                roll: cameraPosition.roll
                            }
                        });
                        if (!$that._scene.pickPositionSupported) {
                            alert('不支持深度纹理,无法拾取位置！');
                        }
                    } catch (e) {
                        if ($that._widget._showRenderLoopErrors) {
                            var title = '渲染时发生错误，已停止渲染。';
                            $that._widget.showErrorPanel(title, undefined, e);
                        }
                    }
                }

                // 注册鼠标点击事件
                MapUtils.viewer.pickEvent.addEventListener(function getFeature(feature) {
                    $that.showPropertyPanel(feature, $that._propertyList, "modelIdentify", $that._propertyTitle);
                    $that._ids = [];
                    var smid = feature.SMID;
                    var data = {
                        "getFeatureMode": "SQL",
                        "datasetNames": ["data:" + layerOptions.dataSetName],
                        "maxFeatures": 1000,
                        "queryParameter": {
                            "sortClause": null,
                            "ids": null,
                            "name": null,
                            "attributeFilter": null,
                            "groupClause": null,
                            "linkItems": null,
                            "joinItems": null,
                            "fields": null
                        }
                    };
                    data.queryParameter.attributeFilter = "cc='" + feature.CC + "'";
                    $.ajax({
                        url: layerOptions.dataURL + "/featureResults.rjson?returnContent=true",
                        type: "POST",
                        contentType: false,
                        processData: false,
                        data: JSON.stringify(data),
                        success: function (resultString) {
                            var result = JSON.parse(resultString);
                            var fieldIndex = 0;
                            if (result.hasOwnProperty("features") && result.features.length > 0) {
                                var fieldNames = result.features[0].fieldNames;
                                $.each(fieldNames, function (i, e) {
                                    if (e == "SMID") {
                                        fieldIndex = i;
                                    }
                                });
                                $.each(result.features, function (i, e) {
                                    if (e.hasOwnProperty("fieldValues")) {
                                        $that._ids.push(e.fieldValues[fieldIndex]);
                                    }
                                });
                            }

                        },
                        error: function (xhr, status, error) {
                            //layer.msg("数据获取失败！错误：" + error);
                        }
                    });

                    // 表格点击样式
                    $('#buildingPopup' + layerOptions.id).parent().find('td').removeClass('building-table-click');
                    $('#buildingPopup' + layerOptions.id).parent().find('td').each(function () {
                        if ($(this).text() === feature.FJH) {
                            $(this).addClass('building-table-click');
                        }
                    });

                });

            },

            /***********************【layui监听,业务代码】************************/
            initLayui: function (option) {
                layui.use(['form', 'layer', 'table'], function () {
                    var form = layui.form,
                        layer = layui.layer,
                        table = layui.table;
                    form.render();
                    // 监听check框
                    form.on('checkbox(appLyr)', function (data) {
                        var id = $(this).attr("dataId").split("check-")[1];
                        var check = this.checked;
                        $.each($that._layers, function (i, e) {
                            if (e.id === id) {
                                // 重新刷新所有图层
                                if (check) {
                                    $that.layerId = id;
                                    $that._propertyTitle = e.propertyTitle;
                                    $that._propertyList = e.propertyList;
                                    $that.layerName = e.layerName;
                                    $that.dataURL = e.dataURL;
                                    $that.dataSourceName = e.dataSourceName;
                                    $that.dataSetName = e.dataSetName;
                                    // e.selectEnabled = true;
                                    if ($that._layer.hasOwnProperty("modelLayerDetails")) {
                                        delete $that._layer.modelLayerDetails;
                                    }
                                    /*if ($that._layer.hasOwnProperty("color")) {
                                        delete $that._layer.color;
                                    }*/
                                    $that.setLayer($that._layer, e, "");
                                    $that.addlayer($that._layer);
                                    $that.setLayer($that._fcLayer, e, "fc-");
                                    if ($that._fcLayer.hasOwnProperty("modelLayerDetails")) {
                                        delete $that._fcLayer.modelLayerDetails;
                                    }
                                    if ($that._fcLayer.hasOwnProperty("cameraPosition")) {
                                        delete $that._fcLayer.cameraPosition;
                                    }
                                    if ($that._fcLayer.hasOwnProperty("color")) {
                                        delete $that._fcLayer.color;
                                    }
                                    $that._fcLayer.objsUnVisible = 0;
                                } else {
                                    // 移除房产模型
                                    MapUtils.viewer.scene.layers.remove(e.layerName);
                                }
                            }
                        });
                        form.render();
                    });

                    // 打开楼盘表
                    form.on('checkbox(fc)', function (data) {
                        var id = $(this).attr("dataId").split("fc-")[1];
                        $(this).addClass('checked' + id);
                        var check = this.checked;
                        $.each($that._layers, function (i, e) {
                            if (e.id === id) {
                                if (check) {
                                    var offsetTop = 600 - e.index*10;
                                    var offsetLeft = 450 + e.index*10;
                                    layer.open({
                                        type: 1,
                                        content: '<div class="building-popup" id="buildingPopup' + e.id + '">' +
                                            '    <table id="buildingTable' + e.id + '"></table>' +
                                            '</div>',
                                        title: e.layerAlias + '楼盘表',
                                        shade: 0,
                                        offset: [offsetTop +'px', offsetLeft +'px'],
                                        area: ['auto', '280px'],
                                        success: function () {
                                            table.render({
                                                elem: '#buildingPopup' + e.id,
                                                url: e.buildingTableData,
                                                cols: [[
                                                    {field: 'CC',title: '层次',width: 60,fixed: 'left',align: 'center'}
                                                    , {field: 'FJH1', title: '房间号', width: 100, align: 'center'}
                                                    , {field: 'FJH2', title: '房间号', width: 100, align: 'center'}
                                                    , {field: 'FJH3', title: '房间号', width: 100, align: 'center'}
                                                    , {field: 'FJH4', title: '房间号', width: 100, align: 'center'}
                                                    , {field: 'FJH5', title: '房间号', width: 100, align: 'center'}
                                                    , {field: 'FJH6', title: '房间号', width: 100, align: 'center'}
                                                    , {field: 'FJH7', title: '房间号', width: 100, align: 'center'}
                                                    , {field: 'FJH8', title: '房间号', width: 100, align: 'center'}
                                                    , {field: 'FJH9', title: '房间号', width: 100, align: 'center'}
                                                ]],
                                                done: function () {
                                                    var td = $('.building-popup').parent().find('td');
                                                    td.on('click', function () {
                                                        $(this).parent().parent().parent().parent().parent().parent().parent().parent().find('td').removeClass('building-table-click');
                                                        var roomNumber = $(this).text();
                                                        $(this).addClass('building-table-click');
                                                        var data = {
                                                            "getFeatureMode": "SQL",
                                                            "datasetNames": ["data:" + e.dataSetName],
                                                            "maxFeatures": 1000,
                                                            "queryParameter": {
                                                                "attributeFilter": "FJH='" + roomNumber + "'"
                                                            }
                                                        };
                                                        $.ajax({
                                                            url: e.dataURL + "/featureResults.rjson?returnContent=true",
                                                            type: "POST",
                                                            contentType: false,
                                                            processData: false,
                                                            data: JSON.stringify(data),
                                                            success: function (resultString) {
                                                                var result = JSON.parse(resultString);
                                                                if (result.hasOwnProperty("features") && result.features.length > 0) {
                                                                    var smid = result.features[0].ID;
                                                                    MapUtils.viewer.scene.layers.find(e.name).setSelection(smid);
                                                                    var selectedFeature = {};
                                                                    $.each(result.features[0].fieldNames, function (i, key) {
                                                                        selectedFeature[key] = result.features[0].fieldValues[i];
                                                                    });
                                                                    $that.showPropertyPanel(selectedFeature, $that._propertyList, "modelIdentify", $that._propertyTitle);
                                                                }
                                                            }
                                                        });
                                                    })
                                                }
                                            });
                                        },
                                        cancel: function () {
                                            $(this).addClass('checked' + id);
                                            $('.checked' + id).prop("checked", false);
                                            form.render();
                                        }
                                    });
                                } else {
                                    $('#buildingPopup td').removeClass('building-table-click');
                                    layer.close(e.index);
                                }
                            }
                        });

                    });
                });
            },

            setLayer: function (layer, data, str) {
                if (data.hasOwnProperty("layerName")) {
                    layer.layerName = str + data.layerName;
                }
                if (data.hasOwnProperty("id")) {
                    layer.id = str + data.id;
                }
                if (data.hasOwnProperty("type")) {
                    layer.type = data.type;
                }
                if (data.hasOwnProperty("name")) {
                    layer.name = str + data.name;
                }
                if (data.hasOwnProperty("url")) {
                    layer.url = data.url;
                }
                if (data.hasOwnProperty("dataURL")) {
                    layer.dataURL = data.dataURL;
                }
                if (data.hasOwnProperty("dataSetName")) {
                    layer.dataSetName = data.dataSetName;
                }
                if (data.hasOwnProperty("dataSourceName")) {
                    layer.dataSourceName = data.dataSourceName;
                }
                if (data.hasOwnProperty("propertyTitle")) {
                    layer.propertyTitle = data.propertyTitle;
                }
                if (data.hasOwnProperty("propertyList")) {
                    layer.propertyList = data.propertyList;
                }
                if (data.hasOwnProperty("cameraPosition")) {
                    layer.cameraPosition = data.cameraPosition;
                }
                /*if (data.hasOwnProperty("fc")) {
                    layer.fc = data.fc;
                }*/
                // 设置模型填充颜色
                if (data.hasOwnProperty("fillForeColor")) {
                    layer.fillForeColor = data.fillForeColor;
                }
                // 设置选中图层显示的高亮颜色
                // if (data.hasOwnProperty("selectedColor")) {
                //     layer.selectedColor = Cesium.Color.fromCssColorString(data.selectedColor);
                // }
                // 设置图层是否开启光照效果
                layer.hasLight = false;
                // S3M图层填充风格:填充和线框模式
                // layer.fillStyle = Cesium.FillStyle.Fill_And_WireFrame;
                // 设置图层线框模式：草图线框模式
                // layer.wireFrameMode = Cesium.WireFrameType.Sketch;
                layer.selectEnabled = true;
            },

            showPropertyPanel: function (propertys, fieldsMapping, serviceType, propertyTitle) {
                layui.use(['layer', 'carousel', 'form', 'laypage', 'element'], function () {
                    var type = "r";
                    $that.popupId = '#layerDemo' + type;
                    var titleContext = "暂无标题";
                    if (serviceType === "modelIdentify" && propertys.hasOwnProperty(propertyTitle)) {
                        titleContext = propertys[propertyTitle]
                    } else if (propertys.hasOwnProperty(propertyTitle) && propertys[propertyTitle].getValue() !== "Null" && propertys[propertyTitle].getValue().trim() !== "") {
                        titleContext = propertys["名称"].getValue();
                    }
                    var title = "<span>" + titleContext + "</span>";
                    var left = screen.width - 309 + "px";
                    var top = $(".new-header-box").height() + $(".tool-widgets-pane").height() + 11 + "px";
                    var offSetTop = [top, left];
                    var layer = layui.layer;
                    $that.layer = layer;
                    var layerContent = $that.createPropertiesList(propertys, fieldsMapping, serviceType);
                    if (layerContent != "") {
                        layer.close($that.openLayer);
                        $that.openLayer = layer.open({
                            type: 1
                            , offset: offSetTop
                            //, id: 'layerDemo' + type //防止重复弹出
                            , content: layerContent
                            , maxWidth: 308
                            , title: [title, "background-color: rgba(67, 117, 253, 0.6);cursor: move;" +
                            "font-size: 1.3em;text-align: center;height: 90px;color: #fff;padding: 0;border-bottom: unset;background-image:url('/assets/images/bgPopupPanel.png')"]
                            , shade: 0 //不显示遮罩
                            , success: function () {
                            }
                            // , yes: function () {
                            //     layer.closeAll();
                            // }
                            , cancel: function () {
                                layer.close($that.openLayer);
                                MapUtils.viewer.scene.layers.releaseSelection();
                                $('.building-popup').parent().find('td').removeClass('building-table-click');

                            }
                        });
                    } else {
                        layer.msg("当前对象属性为空");
                    }
                });

            },

            createPropertiesList: function (propertys, fieldsMapping, serviceType) {
                var content = "";
                var haveContent = false;
                content += "<div style='width: 308px;height:340px'><div class='search-right-pane-part'>" +
                    "<div class='search-text-title'><span>相关属性</span></div>" +
                    "<div class='search-associated-list layui-container'>";
                $.each(fieldsMapping, function (i, val) {
                    if (serviceType === "modelIdentify") {
                        if (propertys.hasOwnProperty(val.key) && propertys[val.key] !== null
                            && propertys[val.key].toLowerCase() !== "null" && propertys[val.key].toLowerCase() !== "undefined") {
                            content += "<div class='layui-row'>" +
                                "<div class='search-associated-item layui-col-xs12'>" +
                                "<span class='search-associated-label layui-col-xs3' title='" + val.label + "'>"
                                + val.label + "</span><span class='layui-col-xs1'>：</span>" +
                                "<span class='search-associated-content layui-col-xs8'>" + propertys[val.key] + "</span></div></div>";
                            haveContent = true;
                        }
                    } else {
                        if (propertys.hasOwnProperty(val.key) && propertys[val.key].getValue() !== null
                            && propertys[val.key].getValue().toLowerCase() !== "null" && propertys[val.key].getValue().toLowerCase() !== "undefined") {
                            content += "<div class='layui-row'>" +
                                "<div class='search-associated-item layui-col-xs12'>" +
                                "<span class='search-associated-label layui-col-xs3'>"
                                + val.label + "</span><span class='layui-col-xs1'>：</span>" +
                                "<span class='search-associated-content layui-col-xs8'>" + propertys[val.key].getValue() + "</span></div></div>";
                            haveContent = true;
                        }
                    }
                });
                content += '</div></div></div>';
                if (haveContent) {
                    return content;
                } else {
                    return "";
                }
            }
        };

    function LayerList() {
        var self = this;
        self.lyrList = ko.observableArray([]);
        self.imgLyrList = ko.observableArray([]);

        // 【用做ko更新数组某一项数据时的克隆，无需重新清空并绑定整个列表】
        self.clone = function (source) {
            var obj = {};
            for (var p in source)
                obj[p] = source[p];
            return obj;
        };
    }


    function metadataSuccess(data) {
        var ids = "";
        Cesium.loadJson(data.newResourceLocation).then(function (jsonData) {
            if (jsonData && jsonData.hasOwnProperty("totalCount") && jsonData.totalCount > 0) {
                $.each(jsonData.featureUriList, function (i, e) {
                    var str = e.split("/");
                    ids += str[str.length - 1] + ",";
                });
            } else {
                // an error occurred
            }
            // Do something with the JSON object

        }).otherwise(function (error) {
            // an error occurred

        });
    }

    function metadataFailure(e) {

    }

    function imgDivOpen() {
        $("#div-bottom-pane").show();
        $("#image-components").removeClass("hide");
        $(".img-div").click(function () {
            $(".img-div").removeClass("blue-bg");
            $(this).addClass("blue-bg");
        })
    }


    /**
     * get instance
     *
     * @returns {*}
     */
    me.getInstance = function () {
        if (void 0 === instance) {
            instance = me;
        }
        return instance;
    };
    return me;
});
