/**
 *
 * @author by <a href="mailto:chaomashi@gmail.com">Du</a>
 * @version v1.0 2019/7/18/9:34  Copyright gtmap Corp
 */

define(function () {

    function WidgetUtils() {
        this._zTreeId = undefined;
        this._appConfig = undefined;
        this._controlConfig = undefined;
    }

    Object.defineProperties(WidgetUtils.prototype, {

        zTreeId: {
            get: function () {
                return this._zTreeId;
            }
        },

        appConfig: {
            get: function () {
                return this._appConfig;
            }
        }
    });

    WidgetUtils.prototype.createRightPopup = function (content, title, closeEvent) {
        if ($(".main-right-pane").length === 0) {
            var html = "<div class='main-right-pane'>" +
                "<div class='main-right-pane-title'>" + title + "<i class='icon-f-close' id='mainRightPaneClose' title='关闭窗口'></i></div>" +
                "<div class='main-right-pane-content'></div></div>";
            $('body').append(html);
        }
        $(".main-right-pane").show();
        $(".main-right-pane-content").html(content);
        $("#mainRightPaneClose").on('click', function () {
            $(".main-right-pane-content").empty();
            $(".main-right-pane").hide();
            closeEvent();
        })
    };

    WidgetUtils.prototype.closeRightPopup = function () {
        $("#mainRightPaneClose").trigger('click')
    };


    /**
     *setAppConfig
     */
    WidgetUtils.prototype.setAppConfig = function (config) {
        this._appConfig = config;
    };

    /**
     *setControlConfig
     */
    WidgetUtils.prototype.setControlConfig = function (config) {
        this._controlConfig = config;
    };

    /**
     *getControlConfig
     */
    WidgetUtils.prototype.getControlConfig = function (config) {
        return this._controlConfig;
    };

    /**
     *setZTreeId
     */
    WidgetUtils.prototype.setZTreeId = function (zTreeId) {
        this._zTreeId = zTreeId;
    };

    /**
     * 获取树勾选的图层
     */
    WidgetUtils.prototype.getCheckedLyrs = function () {
        var allLayers = [];
        var treeObj = $.fn.zTree.getZTreeObj(this._zTreeId);
        var checkedNodes = treeObj.getCheckedNodes(true);
        $.each(checkedNodes, function (index, node) {
            $.each(node.capables, function (i, val) {
                allLayers.push(val);
            });
        });
        return allLayers;
    };

    /**
     * 获取树勾选的三维图层
     */
    WidgetUtils.prototype.getModelLyrs = function () {
        var modelLayers = [];
        var treeObj = $.fn.zTree.getZTreeObj(this._zTreeId);
        var checkedNodes = treeObj.getCheckedNodes(true);
        $.each(checkedNodes, function (index, node) {
            $.each(node.capables, function (i, val) {
                if (val.type === "spm_s3m") {
                    modelLayers.push(val);
                }
            });
        });
        return modelLayers;
    };

    /**
     * 获取服务在树中是否勾选
     * @param layerId
     * @returns {Boolean}
     */
    WidgetUtils.prototype.getCheckStatus = function (layerId) {
        var checkStatus = 0;
        var treeObj = $.fn.zTree.getZTreeObj(this._zTreeId);
        if (treeObj) {
            var checkedNodes = treeObj.getCheckedNodes(true);
            $.each(checkedNodes, function (index, node) {
                $.each(node.capables, function (i, val) {
                    if (layerId === val.id) {
                        checkStatus = 1;
                    }
                });
            });

            if (checkStatus === 1) {
                return true;
            } else {
                return false;
            }
        }
    };

    /**
     * 根据id勾选或取消勾选节点
     * @param layerId
     * @param isCheck (Boolean，true为勾选，false为取消勾选）
     * @param callbackFlag (Boolean，true表示执行此方法时触发 beforeCheck & onCheck 事件回调函数, false表示执行此方法时不触发事件回调函数）
     */
    WidgetUtils.prototype.checkNode = function (layerId, isCheck, callbackFlag) {
        var treeObj = $.fn.zTree.getZTreeObj(this._zTreeId);
        if (treeObj) {
            var nodes = treeObj.transformToArray(treeObj.getNodes());
            $.each(nodes, function (i, value) {
                if (!value.hasOwnProperty("children")) {
                    if (value.data.hasOwnProperty("serviceId")) {
                        if (value.data.serviceId === layerId) {
                            var node = treeObj.getNodeByTId(value.tId);
                            if (isCheck) {
                                if (callbackFlag === false) {
                                    treeObj.checkNode(node, true, true, false);
                                } else {
                                    treeObj.checkNode(node, true, true, true);
                                }
                            } else {
                                if (callbackFlag === false) {
                                    treeObj.checkNode(node, false, true, false);
                                } else {
                                    treeObj.checkNode(node, false, true, true);
                                }
                            }
                        }
                    }
                    if (value.data.hasOwnProperty("serviceIds")) {
                        if (value.data.serviceIds[0] === layerId) {
                            var node = treeObj.getNodeByTId(value.tId);
                            if (isCheck) {
                                if (callbackFlag === false) {
                                    treeObj.checkNode(node, true, true, false);
                                } else {
                                    treeObj.checkNode(node, true, true, true);
                                }
                            } else {
                                if (callbackFlag === false) {
                                    treeObj.checkNode(node, false, true, false);
                                } else {
                                    treeObj.checkNode(node, false, true, true);
                                }
                            }
                        }
                    }
                }
            });
        }


    };

    /**
     *  提示框浮动
     * @param isClose 是否关闭
     * @param value
     */
    WidgetUtils.prototype.mouseMoveMsg =function (isClose, value) {
        var moveTemp = $('.window-move-msg');
        if (isClose) {
            moveTemp.hide();
            $(document).unbind('mousemove');
        } else {
            $(document).mousemove(function (e) {
                moveTemp.show()
                    .text(value)
                    .css({left: e.clientX + 15, top: e.clientY + 20});
            })
        }
    }

    return new WidgetUtils;
});