/**
 *
 */

define(['global/utils/MapUtils', 'Cesium', 'lodash', "knockout", "global/utils/NearbySearchUtils/Index",
    "text!./Index.html","css!./Index.css"], function (MapUtils, Cesium, _, ko, NearbySearchUtils, SearchResultTpl) {
    'use strict';
    var _commonPhoto = "./../../../global/widgets/smartSearch/defaultPhoto/biaoji_common.png";
    var _pageSize = 7;
    var _pageGroup = 1;
    var _resultKo = "";
    var _viewer = MapUtils.viewer ? MapUtils.viewer : undefined;
    var _entity = undefined;
    var _billboards = MapUtils.viewer ? MapUtils.viewer.scene.primitives.add(new Cesium.BillboardCollection()) : undefined;
    var _data = undefined;
    var resultTpl = SearchResultTpl;
    var _laypage = undefined;
    var _layer = undefined;
    var _searchDataList=[];
    var _dataList=undefined;
    var _editflag = false;
    var _poiUpdateUrl="";
    // 用ko生成左侧结果面板和点击事件
    var _createSearchData = function (data, propertyList, title) {
        var self = this;
        self.results = ko.observableArray(data);
        _resultKo = self;

        self.showDetails = function (e) {
            var detailData = _createNeedData(e, propertyList, title);
            // 移除上一个选中样式
            removeLastSelectStyle();
            $("#resultId" + detailData.id).addClass("search-result-index-active");
            if (detailData.geo !== undefined) {
                // geo已经不适用于判断标准，应用_entity实体类作为判断标准，暂时没有空闲时间修改
                if (detailData.geo.type.includes("Point")) {
                    var coords = detailData.geo.coordinates;
                    _viewerflyToLonLat(detailData.id, coords[0], coords[1], e);
                }
            }
            offset(detailData);
        };
    };

    // 删除样式
    var removeLastSelectStyle = function () {
        $(".search-result-index").removeClass("search-result-index-active");
    };

    // 添加样式
    var addSelectStyle = function () {

    }

    var _searchData = function (options, searchUrl, propertyList, title,poiUpdateUrl) {
        _poiUpdateUrl=poiUpdateUrl;
        if (_viewer == undefined) {
            _viewer = MapUtils._viewer;
            _billboards = MapUtils.viewer.scene.primitives.add(new Cesium.BillboardCollection());
        }
        if (!options.hasOwnProperty("pageSize")) {
            options.pageSize = _pageSize;
        }

        if (_laypage == undefined) {
            layui.config({
                base: './js/'
            }).use(['laypage', "layer"], function () {
                _laypage = layui.laypage;
                _layer = layui.layer;
            });
        }

        $.ajax({
            url: searchUrl,
            type: 'GET',
            dataType: 'json',
            traditional: true,
            async: true,
            data: options,
            timeout: 1000 * 60 * 10,
            success: function (data) {
                _data = data;
                $("#searchResultDiv").show();
                if (data.count === 0) {
                    $('.search-noresult').show();
                    $("#searchResultPageUtil").hide();
                } else {
                    $('.search-noresult').hide();
                }
                /*$("#searchResultPageTotalUtil").text(data.count);*/
                _laypage.render({
                    elem: 'searchResultPageGroupUtil'
                    , count: data.count //数据总数，从服务端得到
                    , theme: '#4576FD'
                    , groups: _pageGroup
                    , prev: "<"
                    , next: ">"
                    ,layout: ['prev', 'page', 'next','count']
                    , limit: _pageSize
                    , curr: data.currentPage
                    , jump: function (obj, first) {
                        // 首次不执行
                        if (!first) {
                            options.pageIndex = obj.curr;
                            $.ajax({
                                url: searchUrl,
                                type: 'GET',
                                dataType: 'json',
                                traditional: true,
                                async: true,
                                data: options,
                                timeout: 1000 * 60 * 10,
                                success: function (data) {
                                    if (data.count === 0) {
                                        $('.search-noresult').show();
                                        $("#searchResultPageUtil").hide();
                                    } else {
                                        $('.search-noresult').hide();
                                        _reloadSearchDataList(data.data);
                                        _resultKo.results(_searchDataList);
                                    }
                                }
                            });
                        }
                    }
                });
                _reloadSearchDataList(data.data);
                if (_resultKo !== undefined && _resultKo !== "") {
                    _resultKo.results(_searchDataList);
                } else {
                    ko.applyBindings(new _createSearchData(_searchDataList, propertyList, title), document.getElementById("searchResultUtil"));
                }
            }
        });
    };
    var _reloadSearchDataList=function (data,newData,id) {
        _searchDataList = [];
        $.each(data, function (i, e) {
            if (e.hasOwnProperty("type") && e.type == "FeatureCollection") {
                $.each(e.features, function (j, e1) {
                    if (e1.hasOwnProperty("properties") && !e1.properties.hasOwnProperty("photoUrl")) {
                        e1.properties.photoUrl = "url(/assets/images/defaultPoint.png)";
                    }
                    if(newData!==undefined&&id==e1.id){
                        $.each(newData, function (t, n) {
                            if (n.hasOwnProperty("name")&&e1.properties.hasOwnProperty(n.name)) {
                                e1.properties[n.name] = n.value;
                            }
                        });
                    }
                    _searchDataList.push(e1);
                });
            } else {
                if (e.hasOwnProperty("properties") && !e.properties.hasOwnProperty("photoUrl")) {
                    e.properties.photoUrl = "url(/assets/images/defaultPoint.png)";
                }
                if(newData!==undefined&&id==e.id){
                    $.each(newData, function (t, n) {
                        if (n.hasOwnProperty("name")&&e.properties.hasOwnProperty(n.name)) {
                            e.properties[n.name] = n.value;
                        }
                    });
                }
                _searchDataList.push(e);
            }
        });
    }

    // 点击定位事件
    var _viewerflyToLonLat = function (id, lon, lat, alt, heading) {
        _createMarker(lon, lat, id);

        _entity = new Cesium.Entity({
            position: Cesium.Cartesian3.fromDegrees(lon, lat),//待地形修改后，将position带入即可
            billboard: {
                id: 'flyTo',
                width: 0,
                height: 0,
                pixelOffset: new Cesium.Cartesian2(0, 0),
                image: _commonPhoto,
                eyeOffset: new Cesium.Cartesian3(0, 0, -25)
            }
        });
        _viewer.entities.add(_entity);

        if (heading) {
            _viewer.flyTo(_entity, {
                offset: {
                    heading: heading,
                    pitch: Cesium.Math.toRadians(-50),
                    range: 500
                }
            });
        } else {
            _viewer.flyTo(_entity, {
                offset: {
                    heading: Cesium.Math.toRadians(0.0),
                    pitch: Cesium.Math.toRadians(-50),
                    range: 500
                }
            });
        }
    }

    // 生成标记
    var _createMarker = function (x, y, id) {
        if (_billboards == undefined) {
            _billboards = MapUtils.viewer ? MapUtils.viewer.scene.primitives.add(new Cesium.BillboardCollection()) : undefined;
        } else {
            _billboards.removeAll();
        }

        var b = _billboards.add({
            position: Cesium.Cartesian3.fromDegrees(x, y),
            image: _commonPhoto,
            // verticalOrigin: Cesium.VerticalOrigin.BOTTOM,
            id: id,
            width: 25, // default: undefined
            height: 25,
            pixelOffset: new Cesium.Cartesian2(0, 0),
            eyeOffset: new Cesium.Cartesian3(0, 0, -25)
        });

        return b;
    }

    // 生成标记
    var _clearMarker = function (x, y, id) {
        _billboards.removeAll();
    }

    // 生成数据集，方便统一调用
    var _createNeedData = function (data, propertyList, title) {
        _editflag=false;
        var detail = data.properties;
        var temp = {};
        // id都是null，暂时拿OBJECTid作为key值判断
        if (data.id) {
            temp.id = data.id;
            if (data.geometry) {
                temp.geo = data.geometry;
            }
            var coords = data.geometry.coordinates;
            temp.properties = [];
            (detail[title] !== null) ? temp[title] = detail[title] : temp[title] = "名称数据为空";
            $.each(propertyList, function (count, list) {
                var properties = {};
                if (list.name == "X") {
                    properties.name = list.name;
                    properties.value = coords[0];
                    properties.alias = list.alias;
                    if (list.hasOwnProperty("edit")) {
                        properties.edit = list.edit;
                    } else {
                        properties.edit = false;
                    }
                    temp.properties.push(properties);
                } else if (list.name == "Y") {
                    properties.name = list.name;
                    properties.value = coords[1];
                    properties.alias = list.alias;
                    if (list.hasOwnProperty("edit")) {
                        properties.edit = list.edit;
                    } else {
                        properties.edit = false;
                    }
                    temp.properties.push(properties);
                } else if (detail.hasOwnProperty(list.name)) {
                    properties.name = list.name;
                    properties.value = detail[list.name];
                    properties.alias = list.alias;
                    if (list.hasOwnProperty("edit")) {
                        properties.edit = list.edit;
                    } else {
                        properties.edit = false;
                    }
                    temp.properties.push(properties);
                }
                if(properties.hasOwnProperty("edit")&&properties.edit==true){
                    _editflag=true;
                }
            });

            return temp;
        }
    }

    var _initDiv = function (elem, viewer) {
        var resultTplDiv = $(resultTpl);
        $(elem).append(resultTplDiv);
        if (viewer) {
            _viewer = viewer;
            _billboards = viewer.scene.primitives.add(new Cesium.BillboardCollection());
        }
    };

    var _closeDiv = function (elem) {
        _resultKo = "";
        rightDivClose();
        _clearMarker();
    };

    function _createDatalist(detailData) {
        var self = this;
        self.results = ko.observableArray(detailData.properties);

    }

    function rightDivClose() {
        _dataList="";
        $("#rightDiv").hide();
        $("#propertiesId").val();
        $("#editDiv").hide();
    }

    //右侧面板打开事件
    var offset = function (detailData) {
        var type = "r";
        var popupId = '#layerDemo' + type;
        var title = "<span id='rightTitle'>" + detailData.NAME + "</span>";
        if ($("#rightTitle").length > 0) {
            $("#rightTitle")[0].innerText = detailData.NAME;
        }

        $("#rightDiv").show();
        if (_editflag) {
            $("#propertiesId").val(detailData.id);
            $('.edit-properties').show();
            $('.save-properties').hide();
            $(document).on('click', '.edit-properties', function (evt) {
                $('.properties').removeAttr("readonly");
                $('.save-properties').show();
                $('.edit-properties').hide();
                return false;
            });

            $(document).on('click', '.save-properties', function (evt) {
                $('.properties').attr("readonly", "readonly");
                $('.edit-properties').show();
                $('.save-properties').hide();
                var formData = $("#properties-form").serializeArray();
                var geoJson = {};
                var properties = {};
                var geometry = {};
                geometry.type = "Point";
                geometry.coordinates = [0, 0];

                $.each(formData, function (t, temp) {
                    var map = {};
                    if (temp.name == "id") {
                        geoJson.id = temp.value;
                    } else if (temp.name == "X") {
                        geometry.coordinates[0] = temp.value;
                    } else if (temp.name == "Y") {
                        geometry.coordinates[1] = temp.value;
                    } else {
                        properties[temp.name] = temp.value;
                    }
                });
                geoJson.geometry = geometry;
                //geoJson.properties=properties;
                geoJson.type = "Feature";

                $.ajax({
                    url: _poiUpdateUrl,
                    data: {_method: "PUT", id: geoJson.id, feature: JSON.stringify(geoJson)},
                    type: "POST",
                    dataType: "json",
                    success: function (data) {
                        if (data.hasOwnProperty("msg") && data.msg == "success") {
                            _layer.msg("保存成功！");
                            _reloadSearchDataList(_searchDataList,formData,geoJson.id);
                            _resultKo.results(_searchDataList);
                        } else {
                            _layer.msg("保存失败！");
                        }

                    }
                });
                return false;
            });
        }
        if (_dataList!== undefined && _dataList !== ""){
            _dataList.results(detailData.properties);
            } else {
            _dataList=new _createDatalist(detailData);
            ko.applyBindings(_dataList,document.getElementById("properties-div"));
            }

        //var content = createSearchDetailContent(detailData);
        var left = screen.width - 309 + "px";
        var top = $(".new-header-box").height() + $(".tool-widgets-pane").height() + 11 + "px";
        var offSetTop = [top, left];

        // 生成周边搜页面
        /*NearbySearchUtils.init(
            'rightDiv',
            {
                "url": "http://192.168.18.126:10002/mdb/v1/es/search/identify",
                "instanceId": "99c41e65-7425-42e6-b252-fb7bf9b1dc71",
                "defaultDistance": 500
            },
            {
                lon: detailData.geo.coordinates[0],
                lat: detailData.geo.coordinates[1],
                name: null
            },
            _viewer,
            function (point) {
            }
        );*/

        layer.open({
            type: 1
            , offset: offSetTop
            , id: 'layerDemo' + type //防止重复弹出
            , content: $("#rightDiv")
            , maxWidth: 308
            , title: [title, "background-color: rgba(67, 117, 253, 0.6);cursor: move;" +
            "font-size: 1.3em;text-align: center;height: 90px;color: #fff;padding: 0;border-bottom: unset;background-image:url('/assets/images/bgPopupPanel.png')"]
            // , btn: '关闭全部'
            // , btnAlign: 'c' //按钮居中
            , shade: 0 //不显示遮罩
            , success: function () {
                $('.search-select-all').each(function () {
                    var searchSelectCount = $(this).parent().parent().find('button').length;
                    var searchSelectGeojsons = [];
                    var searchSelectLocation = $(this);
                    /*$(this).parent().parent().find('button').each(function () {
                        $.ajax({
                            url: $that.nearbyUrl + $(this).attr("dataid") + "?type=UUID"
                        }).done(function (data) {
                            try {
                                if (data.data.ownerV) {
                                    var geojson = JSON.parse(data.data.ownerV.cordinate[0]);
                                    if (geojson.type !== "" || geojson.type !== undefined)
                                        searchSelectGeojsons.push(geojson);
                                }
                                searchSelectCount--;
                            } catch (e) {
                                searchSelectCount--;
                            }
                            if (searchSelectCount === 0) {
                                var unitedGeojson = $that.getUnitedGeojson(searchSelectGeojsons);
                                $that.getGeojsonArea(unitedGeojson, searchSelectLocation.parent().find('.search-select-area'), searchSelectLocation.html(), searchSelectLocation);
                            }
                        }).fail(function () {
                            searchSelectCount--;
                            if (searchSelectCount === 0) {
                                var unitedGeojson = $that.getUnitedGeojson(searchSelectGeojsons);
                                $that.getGeojsonArea(unitedGeojson, searchSelectLocation.parent().find('.search-select-area'), searchSelectLocation.html(), searchSelectLocation);
                            }
                        });
                    });*/
                });
                $('.search-right-pane-part .search-text-text,.search-right-pane-part .layui-btn-container').each(function () {
                    if ($(this).height() > 60) {
                        $(this).addClass('wrap');
                        $(this).parents('.search-right-pane-part').find('.icon-f-unfold').show();
                    }
                });
            }
            , yes: function () {
                layer.closeAll();
                $(document).off('click', '.surroundSearchAll');
                $(document).off('click', '.search-surround-border');
            }
            , cancel: function () {
                rightDivClose();
                layer.closeAll();
            }
        });
        $($(popupId).parent().find('a')[0])
            .removeClass('layui-layer-ico').addClass('icon-f-close').css('color', '#ffffff')
            .css('top', '-5px').css('font-size', '20px').attr('title', '关闭面板');
    }

    // 生成右侧layui的结果展示面板
    var createSearchDetailContent = function (data) {
        var content = "<i class='icon-f-back search-right-pane-back'></i><div class='search-right-pane'>";

        // 生成属性列表
        var properties = createPropertiesList(data);

        var titlepart = "";
        var contentpart = "";

        content += '<div class="search-right-pane-overflow layui-tab layui-tab-card" lay-filter="search-right-pane-overflow">';
        if (properties !== "") {
            titlepart += '<ul class="layui-tab-title">';
            contentpart += '<div class="layui-tab-content">';
            if (properties !== "") {
                titlepart += '<li class="layui-this"><i class="iconfont icon-f-excalmation-mark">&nbsp;信息</i></li>';
                contentpart += '<div class="layui-tab-item layui-show">' + properties + '</div>';

            }
            titlepart += '</ul>';
            contentpart += '</div>';
        }


        content += titlepart + contentpart;
        content += '<i class="iconfont fav_geo icon-f-tool-mark" title="收藏至历史图层"></i>';
        content += '</div>';
        return content + "</div>";
    }

    // 生成layer属性列表
    var createPropertiesList = function (data) {
        var content = "";
        content += "<div class='search-right-pane-part'>" +
            "<div class='search-text-title'><span>相关属性</span></div>" +
            "<div class='search-associated-list search-associated-properties'> <form id='properties-form'>";

        var editflag = false;
        $.each(data.properties, function (i, val) {
            content += "<div class='search-associated-label layui-col-xs3'>"
                + val.alias + "</div><div class='layui-col-xs1'>：</div>";
            if (val.edit) {
                editflag = true;
                content += "<div class='search-associated-content layui-col-xs8'><input type='text' class='layui-input properties' style='height: 22px;' readonly='readonly' name='" + val.name + "'  title='" + val.value + "' value='" + val.value + "'></div>";
            } else {
                content += "<div class='search-associated-content layui-col-xs8'>" + val.value + "</div>";
            }

        });

        content += '</form></div><div id="surroundPanel"></div></div>';
        return content;
    }

    return {
        _searchData: _searchData,
        _initDiv: _initDiv,
        _closeDiv: _closeDiv,
        _clearMarker: _clearMarker
    };
});