define(['Cesium',
    'lodash'
], function (Cesium,
             _) {
    'use strict';

    function PoiLoad(viewer, options) {
        this.viewer = viewer;
        this.url = options.url;
        this.instanceId = options.instanceId;
        this.lastDataSource = [];
        var $that = this;
        this.start = function () {
            // this.viewer.scene.postProcessStages.fxaa.enabled = true;
            //初始加载的时候单独执行一次
            this._moveEndListener();
            this.viewer.camera.moveEnd.addEventListener(this._moveEndListener);
        }
        this.stop = function () {
            // this.viewer.dataSources.removeAll();

            for(var j=0;j< $that.lastDataSource.length;j++){
                $that.viewer.entities.remove($that.lastDataSource[j])
            }

            // this.viewer.scene.postProcessStages.fxaa.enabled = false;
            $that.viewer.camera.moveEnd.removeEventListener(this._moveEndListener);
            $that.lastDataSource = [];
        }
        this._moveEndListener = function () {
            var levels = [];
            var tilesToRender = $that.viewer.scene.globe._surface._tilesToRender;
            tilesToRender.forEach(function (value) {
                levels.push(value.level)
            });
            var _levels = _.uniq(levels);
            var curZoomLevel = Math.max.apply(null, _levels);
            if (_levels.length > 0 && curZoomLevel > 16) {
                var extent = $that.viewer.camera.computeViewRectangle($that.viewer.scene.globe.ellipsoid);
                var northeast = Cesium.Rectangle.northeast(extent)
                var southwest = Cesium.Rectangle.southwest(extent)
                var lat = Cesium.Math.toDegrees(northeast.latitude);
                var lng = Cesium.Math.toDegrees(northeast.longitude);
                var lat1 = Cesium.Math.toDegrees(southwest.latitude);
                var lng1 = Cesium.Math.toDegrees(southwest.longitude);
                var centerLon = (lng + lng1) / 2;
                var centerLat = (lat + lat1) / 2;
                var distance = 0;
                switch (curZoomLevel) {
                    // case 16:
                    //     distance = 600;
                    //     break;
                    case 17:
                        distance = 600;
                        break;
                    case 18:
                        distance = 500;
                        break;
                    case 19:
                        distance = 400;
                        break;
                    case 20:
                        distance = 300;
                        break;
                    default:
                        distance = 300;
                }
                $that._getPois(distance, centerLon, centerLat, $that.viewer);
            } else if (_levels.length > 0 && curZoomLevel < 17) {
                // $that.viewer.dataSources.removeAll()
                for(var j=0;j< $that.lastDataSource.length;j++){
                    $that.viewer.entities.remove($that.lastDataSource[j])
                }
            }
        };

        this._getPois = function (distance, centerLon, centerLat, viewer) {
            $.ajax({
                url: $that.url,
                type: 'GET',
                dataType: 'json',
                traditional: true,
                async: true,
                data: {
                    "instanceId": $that.instanceId,
                    "distance": distance,
                    lon: centerLon,
                    lat: centerLat,
                    returnAll: true
                },
                success: function (data) {


                    for(var j=0;j< $that.lastDataSource.length;j++){
                        viewer.entities.remove($that.lastDataSource[j])
                    }
                    // var temp = {
                    //     "type": "FeatureCollection",
                    //     "features": data.data[0].features
                    // };
                    var features = data.data[0].features;
                    // var dataSource = new Cesium.CustomDataSource("poi");
                    // var labels=new Cesium.LabelCollection();

                    // var labels =new Cesium.LabelCollection()
                    // var labels =  viewer.scene.primitives.add(new Cesium.LabelCollection());

                    // var dataSource1 =new Cesium.CustomDataSource("poiLine");
                    for (var i = 0; i < features.length; i++) {
                        if (features[i].properties.TYPE2018 === "120102") {
                            var lon = features[i].geometry.coordinates[0];
                            var lat = features[i].geometry.coordinates[1];
                            var labelEntity =new Cesium.Entity({
                                id: features[i].id,
                                name: features[i].properties.NAME,
                                position: Cesium.Cartesian3.fromDegrees(lon, lat, 30),
                                //点样式
                                // point: {
                                //     pixelSize: 5,
                                //     color: Cesium.Color.RED,
                                //     outlineColor: Cesium.Color.WHITE,
                                //     outlineWidth: 1
                                // },
                                //立广告牌
                                billboard: {
                                    image: '/assets/images/biaoji_choosed.png',
                                    show: true, // default
                                    width: 25, // default: undefined
                                    height: 25 // default: undefined
                                },
                                // //字体标签样式
                                label: {
                                    text: features[i].properties.NAME,
                                    scale:0.5, //这里非常巧妙的先将字体大小放大一倍在缩小一倍
                                    font:'normal 32px MicroSoft YaHei',
                                    fillColor : Cesium.Color.BLACK ,
                                    outlineWidth:0,
                                    //垂直位置
                                    //verticalOrigin : Cesium.VerticalOrigin.BUTTON,
                                    //中心位置
                                    pixelOffset: new Cesium.Cartesian2(0, -20)
                                }
                            });
                            viewer.entities.add(labelEntity);
                            var lineEntity =new Cesium.Entity({
                                polyline: {
                                    positions: Cesium.Cartesian3.fromDegreesArrayHeights([lon, lat, 0,
                                        lon, lat, 30]),
                                    width: 1,
                                    material: Cesium.Color.fromCssColorString("#EF75BF")
                                }
                            });
                            viewer.entities.add(lineEntity)
                            $that.lastDataSource.push(labelEntity);
                            $that.lastDataSource.push(lineEntity);


                        }

                    }
                }
            })

        }
    }

    return PoiLoad


})