/**
 * option1: {
 *   titlePart: true, // 是否有标题面板
 *   useTab: true, //是否采用tab方式展示
 *   top: undefined, // 弹窗位置(可选)
 *   left: undefined,
 *   // tab配置
 *   content: [{
 *     name: "信息",
 *     icon: "icon-f-excalmation-mark",
 *     content: [
 *       "description",
 *       "photo",
 *       "property",
 *       "surround"
 *     ]
 *   }, {
 *     name: "附近",
 *     icon: "icon-f-location1",
 *     content: [
 *       "associate"
 *     ]
 *   }, {
 *     name: "相关",
 *     icon: "icon-f-graph2",
 *     content: [
 *       "graph"
 *     ]
 *   }]
 * }
 *
 * option2: {
 *   titlePart: true, // 是否有标题面板
 *   useTab: false,
 *   top: undefined, // 弹窗位置(可选)
 *   left: undefined,
 *   // 面板测试
 *   content: [
 *     "description",
 *     "photo",
 *     "property",
 *     "surround",
 *     "associate",
 *     "graph"
 *   ]
 * }
 *
 * // 展示的数据
 * data: {
 *     "name: "test",
 *     "titlepart": {
 *         "addName": "",
 *         "city": "",
 *         "county": ""
 *     },
 *     "description": {
 *         "introduce": ""
 *     },
 *     "photo": {
 *         "name": "",
 *         "photoUrl": ""
 *     },
 *     "property": {
 *         "propertyList": [
 *             {
 *                 "label": "",
 *                 "key": ""
 *             }
 *         ]
 *     }
 * }
 */

define([
    'lodash',
    "global/utils/NearbySearchUtils/Index",
    'text!global/utils/InfoPanelUtils/Index.html',
    'css!global/utils/InfoPanelUtils/Index'
], function (_, NearbySearchUtils, html) {
    var $that;

    function InfoPanelUtils() {
        $that = this;
        // 用于记录各个layer id对应的配置
        $that._options = {};
        // 未传递配置则使用默认配置
        $that._defaultOption = {
            useTab: false
        };
        // 用于记录各个layer id对应的layer index
        $that._layerIndexs = {};

        // 取出layer与element备用
        layui.use(['layer', 'element'], function () {
            $that._layer = layui.layer;
            $that._element = layui.element;
        });
    }

    Object.defineProperties(InfoPanelUtils.prototype, {
        defaultOption: {
            get: function () {
                return $that._defaultOption;
            }
        }
    });

    /**
     * 弹窗主方法
     * @param id layerId
     * @param data 用于展示的数据
     * @param option layerId对应的面板配置
     * @param yesCallback
     * @param cancelCallback
     */
    InfoPanelUtils.prototype.open = function (id, data, option, yesCallback, cancelCallback) {
        $that._popupId = '#' + id;
        if (option) {
            $that.setOption(id, option);
        }
        if ($that._options[id]) {
            var _option = $that._options[id];
            var title = "<span>" + data.name + "</span>";
            // var content = createInfoPanelContent(data, $that.options[id]);
            var left = _option.left ? _option.left : screen.width - 309 + "px";
            var top = _option.top ? _option.top : $(".new-header-box").height() + $(".tool-widgets-pane").height() + 11 + "px";
            var offSetTop = [top, left];

            var index = $that._layer.open({
                type: 1
                , offset: offSetTop
                , id: id //防止重复弹出
                , content: html
                , maxWidth: 308
                , title: [title, "background-color: rgba(67, 117, 253, 0.6);cursor: move;" +
                "font-size: 1.3em;text-align: center;height: 90px;color: #fff;padding: 0;border-bottom: unset;background-image:url('/assets/images/bgPopupPanel.png')"]
                , shade: 0 //不显示遮罩
                , success: function () {
                    $that._layerIndexs[id] = index;
                    createInfoPanelContent(id, data);
                    if ($that.historyAssociatedIds.length > 1) {
                        $('.search-right-pane-icon').hide();
                        $('.search-right-pane-back').show();
                        $('.fav_geo').hide();
                    }
                    $that.geoAreaForSchool = {};
                    $('.search-select-all').each(function () {
                        var searchSelectCount = $(this).parent().parent().find('button').length;
                        var searchSelectGeojsons = [];
                        var searchSelectLocation = $(this);
                        $(this).parent().parent().find('button').each(function () {
                            $.ajax({
                                url: $that.nearbyUrl + $(this).attr("dataid") + "?type=UUID"
                            }).done(function (data) {
                                try {
                                    if (data.data.ownerV) {
                                        var geojson = JSON.parse(data.data.ownerV.cordinate[0]);
                                        if (geojson.type !== "" || geojson.type !== undefined)
                                            searchSelectGeojsons.push(geojson);
                                    }
                                    searchSelectCount--;
                                } catch (e) {
                                    searchSelectCount--;
                                }
                                if (searchSelectCount === 0) {
                                    var unitedGeojson = $that.getUnitedGeojson(searchSelectGeojsons);
                                    $that.getGeojsonArea(unitedGeojson, searchSelectLocation.parent().find('.search-select-area'), searchSelectLocation.html(), searchSelectLocation);
                                }
                            }).fail(function () {
                                searchSelectCount--;
                                if (searchSelectCount === 0) {
                                    var unitedGeojson = $that.getUnitedGeojson(searchSelectGeojsons);
                                    $that.getGeojsonArea(unitedGeojson, searchSelectLocation.parent().find('.search-select-area'), searchSelectLocation.html(), searchSelectLocation);
                                }
                            });
                        });
                    });
                    $('.search-right-pane-part .search-text-text,.search-right-pane-part .layui-btn-container').each(function () {
                        if ($(this).height() > 60) {
                            $(this).addClass('wrap');
                            $(this).parents('.search-right-pane-part').find('.icon-f-unfold').show();
                        }
                    });
                    table.init('buildingInfoTable', {
                        width: 'auto',
                        id: 'buildingInfoTable'
                    });
                    if (smartSearchConfig.searchOnMove) {
                        $that.viewer.scene.camera.moveEnd.removeEventListener($that.searchOnMove);
                    }
                }
                , yes: yesCallback
                , cancel: cancelCallback
            });

            $($($that._popupId).parent().find('a')[0])
                .removeClass('layui-layer-ico').addClass('icon-f-close').css('color', '#ffffff')
                .css('top', '-5px').css('font-size', '20px').attr('title', '关闭面板');
        }
    };

    /**
     * 设置信息窗配置
     * @param id layerId
     * @param option layerId对应配置
     */
    InfoPanelUtils.prototype.setOption = function (id, option) {
        if (option) {
            $that._options[id] = option;
        }
    };

    /**
     * 移除id对应配置
     * @param id layerId
     */
    InfoPanelUtils.prototype.removeOption = function (id) {
        if ($that._options[id]) {
            delete $that._options[id];
        }
    };

    /**
     * 存储打开的弹窗的layerIndex
     * @param id layerId
     * @param index layerIndex
     */
    InfoPanelUtils.prototype.setLayerIndex = function (id, index) {
        if (index) {
            $that._layerIndexs[id] = index;
        }
    };

    /**
     * 移除已关闭弹窗的layerIndex
     * @param id layerId
     */
    InfoPanelUtils.prototype.removeLayerIndex = function (id) {
        if ($that._layerIndexs[id]) {
            delete $that._layerIndexs[id];
        }
    };

    // 生成右侧layui的结果展示面板
    function createInfoPanelContent(id, data) {
        var _option = $that._options[id];
        if (_option.titlePart) {
            createTitlePart(id, data.titlepart);
        }
        if (_option.useTab) {
            $('#' + id).find('#defaultInfoPanel').hide();
            $('#' + id).find('#customInfoPanel').show();
            $('#' + id).find('#customInfoPanel').show();
            $('#' + id).find('#customInfoPanel > .layui-tab-title > li').hide();
            $('#' + id).find('#customInfoPanel > .layui-tab-content > .layui-tab-item').hide();
            $.each(_option.content, function (i, v) {
                $('#' + id).find('#customInfoPanel > .layui-tab-title > li')[i].show();
                $('#' + id).find('#customInfoPanel > .layui-tab-content > .layui-tab-item')[i].show().empty();
                if (v.icon) {
                    $($('#' + id).find('#customInfoPanel > .layui-tab-title > li')[i]).html(
                        '<i class="iconfont ' + v.icon + '"></i>' + v.name
                    )
                } else {
                    $($('#' + id).find('#customInfoPanel > .layui-tab-title > li')[i]).html(v.name);
                }
                $.each(v, function (ii, vv) {
                    switch (vv) {
                        case "description":
                            createDescription(id, data[vv], i);
                            break;
                        case "photo":
                            createPhoto(id, data[vv], i);
                            break;
                        case "property":
                            createPropertiesList(id, data[vv], i);
                            break;
                        case "surround":
                            createSurround(id, data[vv], i);
                            break;
                        case "associate":
                            createAssociated(id, data[vv], i);
                            break;
                        default:
                            break;
                    }
                });

            });
        } else {
            $('#' + id).find('#defaultInfoPanel').show();
            $('#' + id).find('#customInfoPanel').hide();
            $.each(_option.content, function (i, v) {
                switch (v) {
                    case "description":
                        createDescription(id, data[v]);
                        break;
                    case "photo":
                        createPhoto(id, data[v]);
                        break;
                    case "property":
                        createPropertiesList(id, data[v]);
                        break;
                    case "surround":
                        createSurround(id, data[v]);
                        break;
                    case "associate":
                        createAssociated(id, data[v]);
                        break;
                    default:
                        break;
                }
            });
        }
    }

    /**
     * 生成面板标题部分的展示字段
     * @param id layerId
     * @param data 用到的数据
     */
    function createTitlePart(id, data) {
        if (data.addName || data.city) {
            $('#' + id).find(".search-right-pane-overflow").before(
                $(".info-panel-template-titlepart").clone().removeClass('info-panel-template')
            );
            if (data.addName) {
                $('#' + id)
                    .find(".search-right-pane .info-panel-template-titlepart .icon-f-datalist")
                    .show()
                    .attr("title", data.addName)
                    .html("&nbsp;&nbsp;" + data.addName);
            }
            if (data.city) {
                if (data.county) {
                    $('#' + id)
                        .find(".search-right-pane .info-panel-template-titlepart .icon-f-location3")
                        .show()
                        .attr("title", data.city + "&nbsp;" + data.county)
                        .html("&nbsp;&nbsp;" + data.city + "&nbsp;&nbsp;" + data.county);
                } else {
                    $('#' + id)
                        .find(".search-right-pane .info-panel-template-titlepart .icon-f-location3")
                        .show()
                        .attr("title", data.city)
                        .html("&nbsp;&nbsp;" + data.city);
                }
            }
        }
    }

    /**
     * 生成介绍页
     * @param id layerId
     * @param data 用到的数据
     * @param index tab索引(可选)
     */
    function createDescription(id, data, index) {
        var _option = $that._options[id];
        if (data.introduce) {
            if (_option.useTab && index) {
                $('#' + id).find(".customInfoPanel").find('.layui-tab-item')[index].append(
                    $(".info-panel-template-description").clone().removeClass('info-panel-template')
                );
            } else {
                $('#' + id).find(".defaultInfoPanel").append(
                    $(".info-panel-template-description").clone().removeClass('info-panel-template')
                );
            }
            $("#" + id)
                .find('.search-right-pane .info-panel-template-description .search-text-text')
                .html("&nbsp;&nbsp;&nbsp;&nbsp;" + data.introduce);
        }
    }

    // 读取默认图片
    function createPhoto(id, data, index) {
        if (data.photoUrl && data.photoUrl !== "") {
            var defaultPhotoList = [
                "url(/assets/images/defaultPoint.png)",
                "url(/assets/images/defaultPolygon.png)",
                "url(/assets/images/defaultPolyline.png)",
                "url(/assets/images/defaultPhoto.png)"
            ];
            var _option = $that._options[id];
            if (defaultPhotoList.indexOf(data.photoUrl) === -1) {
                if (_option.useTab && index) {
                    $('#' + id).find(".customInfoPanel").find('.layui-tab-item')[index].append(
                        $(".info-panel-template-photo").clone().removeClass('info-panel-template')
                    );
                } else {
                    $('#' + id).find(".defaultInfoPanel").append(
                        $(".info-panel-template-photo").clone().removeClass('info-panel-template')
                    );
                }
                var url = data.photoUrl.split('(')[1].split('?')[0];
                var thumb = data.photoUrl.split('(')[1].split('?')[0] + "?w=250&h=250";
                $("#" + id)
                    .find('.search-right-pane .info-panel-template-photo img')
                    .attr("layer-src", url)
                    .attr("src", thumb)
                    .attr("alt", data.name);
            }
        }
    }

    // 生成layer属性列表
    function createPropertiesList(id, data, index) {
        if (data.propertyList) {
            if (data.propertyList.length > 0) {
                var _option = $that._options[id];
                if (_option.useTab && index) {
                    $('#' + id).find(".customInfoPanel").find('.layui-tab-item')[index].append(
                        $(".info-panel-template-property").clone().removeClass('info-panel-template')
                    );
                } else {
                    $('#' + id).find(".defaultInfoPanel").append(
                        $(".info-panel-template-property").clone().removeClass('info-panel-template')
                    );
                }
                $.each(data.propertyList, function (i, property) {
                    $("#" + id)
                        .find('.search-right-pane .info-panel-template-property .search-associated-properties')
                        .append("<div class='search-associated-label layui-col-xs3'>" + property.label + "</div><div class='layui-col-xs1'>：</div><div class='search-associated-content layui-col-xs8'>" + property.key + "</div>")
                });
            }
        }
    }

    // 生成周边搜
    function createSurround(id, data, index) {
        var _option = $that._options[id];
        if (_option.useTab && index) {
            $('#' + id).find(".customInfoPanel").find('.layui-tab-item')[index].append(
                $(".info-panel-template-surround").clone().removeClass('info-panel-template').attr("id", "surroundPanel")
            );
        } else {
            $('#' + id).find(".defaultInfoPanel").append(
                $(".info-panel-template-surround").clone().removeClass('info-panel-template').attr("id", "surroundPanel")
            );
        }
        NearbySearchUtils.init(
            'surroundPanel',
            data.surroundOptions,
            {
                lon: data.geo.coordinates[0],
                lat: data.geo.coordinates[1],
                name: data.name
            },
            data.viewer,
            data.callback
        )
    }

    // 生成关联搜
    function createAssociated(id, data, index) {
        var _option = $that._options[id];
        if (_option.useTab && index) {
            $('#' + id).find(".customInfoPanel").find('.layui-tab-item')[index].append(
                $(".info-panel-template-surround").clone().removeClass('info-panel-template').attr("id", "surroundPanel")
            );
        } else {
            $('#' + id).find(".defaultInfoPanel").append(
                $(".info-panel-template-surround").clone().removeClass('info-panel-template').attr("id", "surroundPanel")
            );
        }
        var content = "";
        if (data.hasOwnProperty("subwayline") || data.hasOwnProperty("subway")) {
            content += "<div class='search-right-pane-part'>" +
                "<div class='search-text-title'><span>附近地铁</span></div>" +
                "<div class='search-associated-list'>" +
                "<span><i class='iconfont icon-f-changyonglogo18'></i><div id='subwayInfoPanel'>" +
                "<div id='subwayLineInfo'><p>地铁" + data["subwayline"] + "</p></div>" +
                "<div id='subwayInfo'><p>最近站口:&nbsp;" + data["subway"] + "</p></div></div></span></div></div>";
        }
        if (data.hasOwnProperty("transpot") || data.hasOwnProperty("transline")) {
            content += "<div class='search-right-pane-part'>" +
                "<div class='search-text-title'><span>附近公交</span><i class='iconfont icon-f-unfold'></i></div>" +
                "<div class='search-associated-list'>";
            if (data.hasOwnProperty("transline")) {
                content += "<div class='search-associated-type'>附近线路</div>";
                var datalist = data["transline"].split(' ');
                content += '<div class="layui-btn-container">';
                datalist.forEach(function (val) {
                    content += "<button type='button' class='layui-btn layui-btn-xs search-associated-nocontent'>" + val + "</button>";
                });
                content += "</div>";
            }
            if (data.hasOwnProperty("transpot")) {
                content += "<div class='search-associated-type'>附近站点</div>";
                var datalist = data["transpot"].split(' ');
                content += '<div class="layui-btn-container">';
                datalist.forEach(function (val) {
                    content += "<button type='button' class='layui-btn layui-btn-xs search-associated-nocontent'>" + val + "</button>";
                });
                content += "</div>";
            }
            content += "</div></div>";
        }

        $.each(data.nearby, function (index, value) {
            content += "<div class='search-right-pane-part'>" +
                "<div class='search-text-title'><span>" + index + "</span><i class='iconfont icon-f-unfold'></i></div>" +
                "<div class='search-associated-list'>";
            content += '<div class="layui-btn-container">';
            if ($that.noContentList.indexOf(index) > -1) {
                $.each(value, function (i, val) {
                    if (val.name !== undefined && val.name !== "") {
                        content += "<button type='button' class='layui-btn layui-btn-xs search-associated-nocontent' dataid='" +
                            val.UUID + "'>" + val.name + "</button>";
                    } else {
                        content += "<button type='button' class='layui-btn layui-btn-xs search-associated-nocontent' dataid='" +
                            val.UUID + "'>" + val.label + "</button>";
                    }
                });
            } else {
                $.each(value, function (i, val) {
                    if (val.name !== undefined && val.name !== "") {
                        content += "<button type='button' class='layui-btn layui-btn-xs search-associated-contentname' dataid='" +
                            val.UUID + "'>" + val.name + "</button>";
                    } else {
                        content += "<button type='button' class='layui-btn layui-btn-xs search-associated-contentname' dataid='" +
                            val.UUID + "'>" + val.label + "</button>";
                    }
                });
            }
            content += '</div></div></div>';
        });

        return content;
    }

    // 生成关联搜数据
    function createAssocitedData(id) {
        var temp = {};

        $.ajax({
            url: $that.relateUrl + id + "?type=UUID",
            type: 'GET',
            dataType: 'json'
        }).done(function (data) {
            var detail = data.data.ownerV;
            if (detail !== undefined) {
                temp.relate = {};
                $.each(data.data, function (count, list) {
                    if (count !== "ownerV") {
                        temp.relate[count] = [];
                        $.each(list, function (index, type) {
                            var tmp = {};
                            for (var i in type) {
                                tmp[i] = type[i][0];
                            }
                            temp.relate[count].push(tmp);
                        });
                    }
                });
            }
            $.ajax({
                url: $that.nearbyUrl + id + "?type=UUID"
            }).done(function (data) {
                var detail = data.data.ownerV;
                if (detail !== undefined) {
                    if (detail.cordinate !== undefined && detail.cordinate !== null) {
                        if (detail.cordinate[0].length < 50) {
                            temp.x = parseFloat(detail.cordinate[0].split(',')[0]);
                            temp.y = parseFloat(detail.cordinate[0].split(',')[1]);
                        } else {
                            temp.geo = JSON.parse(detail.cordinate[0]);
                            temp.x = temp.geo.coordinates[0];
                            temp.y = temp.geo.coordinates[1];
                        }
                    }
                    (detail.name !== undefined && detail.name !== null) ? temp.name = detail.name[0] : temp.name = "";
                    (detail.address !== undefined && detail.address !== null) ? temp.addName = detail.address[0] : temp.addName = "";
                    (detail.city !== undefined && detail.city !== null) ? temp.city = detail.city[0] : temp.city = "";
                    (detail.zone !== undefined && detail.zone !== null) ? temp.county = detail.zone[0] : temp.county = "";
                    (detail.province !== undefined && detail.province !== null) ? temp.province = detail.province : temp.province = "";
                    (detail.tel !== undefined && detail.tel !== null) ? temp.tel = detail.tel[0] : temp.tel = "";
                    (detail.introduce !== undefined && detail.introduce !== null) ? temp.introduce = detail.introduce[0] : temp.introduce = "";
                    (detail.pictureid !== undefined && detail.pictureid !== null) ? temp.photoUrl = "url(" + $that.storageUrl + detail.pictureid[0] + "/thumbnail?w=70&h=70)" : temp.photoUrl = "";
                    (detail.worktime !== undefined && detail.worktime !== null) ? temp.worktime = detail.worktime[0] : temp.worktime = "";
                    if (detail.heading) temp.heading = detail.heading[0];
                    temp.__index = "poi_fs";
                    temp.nearby = {};
                    $.each(data.data, function (count, list) {
                        if (count !== "ownerV") {
                            temp.nearby[count] = [];
                            $.each(list, function (index, type) {
                                var tmp = {};
                                for (var i in type) {
                                    tmp[i] = type[i][0];
                                }
                                temp.nearby[count].push(tmp);
                            });
                        }
                    });
                    $that.layer.closeAll();
                    $that.closePopup();
                    if (temp.x !== undefined) {
                        temp.properties = {};
                        temp.properties.__ID = detail.UUID[0];
                        if (!$that.relatedBillboard) {
                            $that.relatedBillboard = $that.viewer.scene.primitives.add(new Cesium.BillboardCollection());
                        }
                        temp.properties.billboard = $that.createMarker(temp.x, temp.y, detail.UUID[0], $that.relatedBillboard);
                        if (temp.heading) {
                            $that.selectedBillboard = $that.viewerflyToLonLat(temp.x, temp.y, temp, temp.heading);
                        } else {
                            $that.selectedBillboard = $that.viewerflyToLonLat(temp.x, temp.y, temp);
                        }
                    } else if (temp.geo !== undefined) {
                        $that.createPolygon(temp.geo);
                    }
                    setTimeout(function () {
                        $that.active["offset"].call(this, temp);
                    }, 500);
                } else {
                    layui.use('layer', function () {
                        layui.layer.msg('查询无结果');
                    });
                }
            });
        });
    }

    // 生成知识图谱
    function createGraph(data) {
        var content = "";
        $.each(data.relate, function (index, value) {
            content += "<div class='search-right-pane-part'>" +
                "<div class='search-text-title'>" +
                "<span class='search-select-all'>" + index + "</span>" +
                "<i class='iconfont icon-f-unfold'></i>" +
                "<span class='search-select-area'></span></div>" +
                "<div class='search-associated-list'>";
            content += '<div class="layui-btn-container">';
            if ($that.noContentList.indexOf(index) > -1) {
                $.each(value, function (i, val) {
                    if (val.name !== undefined && val.name !== "") {
                        content += "<button type='button' class='layui-btn layui-btn-xs search-associated-nocontent' dataid='" +
                            val.UUID + "'>" + val.name + "</button>";
                    } else {
                        content += "<button type='button' class='layui-btn layui-btn-xs search-associated-nocontent' dataid='" +
                            val.UUID + "'>" + val.label + "</button>";
                    }
                });
            } else {
                $.each(value, function (i, val) {
                    if (val.name !== undefined && val.name !== "") {
                        content += "<button type='button' class='layui-btn layui-btn-xs search-associated-contentname' dataid='" +
                            val.UUID + "'>" + val.name + "</button>";
                    } else {
                        content += "<button type='button' class='layui-btn layui-btn-xs search-associated-contentname' dataid='" +
                            val.UUID + "'>" + val.label + "</button>";
                    }
                });
            }
            content += '</div></div></div>';
        });
        return content;
    }

    // 生成房产信息
    function createBuildingInfo(data) {
        var content = "";
        if (data.__index === "resa" && data.hasOwnProperty("buildingInfos")) {
            content += "<div class='search-right-pane-part'>" +
                "<div class='search-text-title'><span>房产信息</span></div>" +
                "<table lay-filter='buildingInfoTable'>" +
                "<thead><tr><th lay-data=\"{field:'ZRZH'}\">总层数</th>" +
                "<th lay-data=\"{field:'DYH'}\">单元号</th>" +
                "<th lay-data=\"{field:'FJH'}\" ,minWidth: 130>房间号</th>" +
                "<th lay-data=\"{field:'GD'}\">高度</th>" +
                "</tr></thead><tbody>";

            $.each(data.buildingInfos, function (index, value) {
                content += "<tr><td>" + (value.ZRZH ? value.ZRZH : "") + "</td>" +
                    "<td>" + (value.DYH ? value.DYH : "") + "</td>" +
                    "<td>" + (value.FJH ? value.FJH : "") + "</td>" +
                    "<td>" + (value.GD ? value.GD : "") + "</td>" +
                    "</tr>";
            });

            content += "</tbody></table></div>";
        }
        return content;
    }

    return new InfoPanelUtils;
});