define(['Cesium',
    'lodash'
], function (Cesium, _) {
    'use strict';

    function BuildingLoad(viewer, options) {
        this.viewer = viewer;
        this.url = options.url;
        this.instanceId = options.instanceId;
        this.lastDataSource = [];
        var $that = this;
        this.start = function () {
            this.viewer.scene.postProcessStages.fxaa.enabled = true;
            //初始加载的时候单独执行一次
            this._moveEndListener();
            this.viewer.camera.moveEnd.addEventListener(this._moveEndListener);
        }
        this.stop = function () {
            // this.viewer.dataSources.removeAll();
            var dataSources = $that.viewer.dataSources._dataSources;
            var length = dataSources.length;
            var flag = 0;
            for (var i = 0; i < length; i++) {
                if (dataSources[flag].name === "buildings") {
                    $that.viewer.dataSources.remove(dataSources[flag])
                } else {
                    flag++;
                }
            }

            this.viewer.scene.postProcessStages.fxaa.enabled = false;
            this.viewer.camera.moveEnd.removeEventListener(this._moveEndListener);
            $that.lastDataSource = [];
        }
        this._moveEndListener = function () {
            var levels = [];
            var tilesToRender = $that.viewer.scene.globe._surface._tilesToRender;
            tilesToRender.forEach(function (value) {
                levels.push(value.level)
            });
            var _levels = _.uniq(levels);
            var curZoomLevel = Math.max.apply(null, _levels);
            if (_levels.length > 0 && curZoomLevel > 16) {
                var pitch = Cesium.Math.toDegrees($that.viewer.camera.pitch);
                var heading = Cesium.Math.toDegrees($that.viewer.camera.heading);
                var centerLon, centerLat;
                var distance = 0;
                switch (curZoomLevel) {
                    // case 16:
                    //     distance = 600;
                    //     break;
                    case 17:
                        distance = 600;
                        break;
                    case 18:
                        distance = 500;
                        break;
                    case 19:
                        distance = 400;
                        break;
                    case 20:
                        distance = 300;
                        break;
                    default:
                        distance = 300;
                }
                if (pitch > -25) {
                    var position = $that._getTargetPosition($that.viewer.scene.globe.ellipsoid.cartesianToCartographic($that.viewer.camera.position), heading, distance);
                    centerLon = Cesium.Math.toDegrees(position.longitude);
                    centerLat = Cesium.Math.toDegrees(position.latitude);
                } else {
                    var extent = $that.viewer.camera.computeViewRectangle($that.viewer.scene.globe.ellipsoid);
                    var northeast = Cesium.Rectangle.northeast(extent);
                    var southwest = Cesium.Rectangle.southwest(extent);
                    var lat = Cesium.Math.toDegrees(northeast.latitude);
                    var lng = Cesium.Math.toDegrees(northeast.longitude);
                    var lat1 = Cesium.Math.toDegrees(southwest.latitude);
                    var lng1 = Cesium.Math.toDegrees(southwest.longitude);
                    centerLon = (lng + lng1) / 2;
                    centerLat = (lat + lat1) / 2;
                }
                $that._getBuildings(distance, centerLon, centerLat, $that.viewer);
            } else if (_levels.length > 0 && curZoomLevel < 17) {
                // $that.viewer.dataSources.removeAll()
                var dataSources = $that.viewer.dataSources._dataSources;
                var length = dataSources.length;
                var flag = 0;
                for (var i = 0; i < length; i++) {
                    if (dataSources[flag].name === "buildings") {
                        $that.viewer.dataSources.remove(dataSources[flag])
                    } else {
                        flag++;
                    }
                }
            }
        };

        this._getBuildings = function (distance, centerLon, centerLat, viewer) {
            $.ajax({
                url: $that.url,
                type: 'GET',
                dataType: 'json',
                traditional: true,
                async: true,
                data: {
                    "instanceId": $that.instanceId,
                    "distance": distance,
                    lon: centerLon,
                    lat: centerLat,
                    returnAll: true
                },
                success: function (data) {
                    var temp = {
                        "type": "FeatureCollection",
                        "features": data.data[0].features
                    };
                    var promise = Cesium.GeoJsonDataSource.load(temp);
                    promise.then(function (dataSource) {
                        dataSource.name = "buildings";
                        viewer.dataSources.add(dataSource);
                        var listenerAdd = function (e) {
                            viewer.dataSources.remove($that.lastDataSource);
                            viewer.dataSources.dataSourceAdded.removeEventListener(listenerAdd)
                        }
                        var listenerRemove = function (e) {
                            $that.lastDataSource = dataSource;
                            viewer.dataSources.dataSourceRemoved.removeEventListener(listenerRemove)
                        }
                        viewer.dataSources.dataSourceAdded.addEventListener(listenerAdd);
                        viewer.dataSources.dataSourceRemoved.addEventListener(listenerRemove)
                        var entities = dataSource.entities.values;
                        for (var i = 0; i < entities.length; i++) {
                            // entities[i].polygon.material.color = Cesium.Color.WHITE.withAlpha(0.98);
                            //透明度色（FCFAFAFA） 不透明0xFFFAFAFA

                            entities[i].polygon.material.color = Cesium.Color.fromRgba(0xFFFAFAFA)
                            entities[i].polygon.outline = false;
                            // entities[i].polygon.outlineColor=Cesium.Color.WHITE;
                            // entities[i].polygon.shadows=Cesium.ShadowMode.ENABLED;

                            // entities[i].polygon.arcType =Cesium.ArcType.RHUMB;
                            var high = entities[i].properties.high._value;
                            var floor = entities[i].properties.Floor2._value;
                            if (high === 0 && floor === '0') {
                                entities[i].polygon.extrudedHeight = 3
                            } else if (high === 0 && floor !== '0') {
                                entities[i].polygon.extrudedHeight = 3 * parseInt(floor);
                            } else if (high !== 0) {
                                entities[i].polygon.extrudedHeight = high;
                            }

                            // entities[i].polygon.extrudedHeight = 3;
                            // 不闭合面，不然底部会和图层重叠导致闪烁
                            entities[i].polygon.closeBottom = false;
                        }
                    });
                }

            });


        }

        this._getTargetPosition = function (position, heading, distance, target) {
            var EARTH_RADIUS = 6371393;
            var x = distance * Math.sin(Cesium.Math.toRadians(heading));
            var y = distance * Math.cos(Cesium.Math.toRadians(heading));
            var lon = Cesium.Math.toRadians(180 / Math.cos(position.latitude) / Math.PI / EARTH_RADIUS) * x;
            var lat = Cesium.Math.toRadians(Math.cos(Cesium.Math.toRadians(0.5)) / EARTH_RADIUS / Math.sin(Cesium.Math.toRadians(1))) * y;
            target = new Cesium.Cartographic(position.longitude + lon, position.latitude + lat);
            return target;
        }
    }

    return BuildingLoad

})